//	Persistence of Vision Ray Tracer Scene Description File
//	File: surprise.pov
//	Date: 1/21/2005
//	Author: R. Montgomery

#default { texture { pigment { color rgb < 1, 0, 0 > } finish { ambient 0.4 } } }

#macro FlatTorus(IR,OR,RR,T)
	union {
		difference {
			cylinder { -T/2*y T/2*y OR-RR}
			cylinder { -T*y T*y IR+RR}
		} // difference
		difference {
			cylinder { (-T/2+RR)*y (T/2-RR)*y OR}
			cylinder { -T*y T*y IR}
		} // difference
		torus {OR-RR RR translate  (T/2-RR)*y}
		torus {OR-RR RR translate -(T/2-RR)*y}
		torus {IR+RR RR translate  (T/2-RR)*y}
		torus {IR+RR RR translate -(T/2-RR)*y}
	} // union
#end // macro FlatTorus

#macro RoundCylinder(T,R,RR)
	union {
		cylinder {-T/2*y T/2*y R-RR}
		#if (T > 2*RR)
			cylinder {(-T/2+RR)*y (T/2-RR)*y R}
		#end // if
		torus {R-RR RR translate (T/2-RR)*y}
		torus {R-RR RR translate (-T/2+RR)*y}
	} // union
#end // macro RoundCylinder

#macro RoundBox(T,L,W,R)
	union {
		box {<-L/2, -T/2, -W/2+R> <L/2, T/2, W/2-R>}
		box {<-L/2, -T/2+R, -W/2> <L/2, T/2-R, W/2>}
		cylinder {-L/2*x L/2*x R translate <0, -T/2+R, -W/2+R>}
		cylinder {-L/2*x L/2*x R translate <0,  T/2-R, -W/2+R>}
		cylinder {-L/2*x L/2*x R translate <0, -T/2+R,  W/2-R>}
		cylinder {-L/2*x L/2*x R translate <0,  T/2-R,  W/2-R>}
	} // union
#end // macro RoundBox

#macro Oblong(T,L,W)
	#local R=W/2;
	#local HBL=(L-W)/2;
	#local HT=T/2;
	union {
		box {<-HBL, -HT, -R> <HBL, HT, R>}
		difference {
			cylinder {<-HBL, -HT, 0> <-HBL, HT, 0> R}
			box { <-HBL, -T, -2*R> <HBL, T, 2*R>}
		} // difference
		difference {
			cylinder {<HBL, -HT, 0> <HBL, HT, 0> R}
			box { <-HBL, -T, -2*R> <HBL, T, 2*R>}
		} // difference
	} // union
#end // macro oblong

#macro RoundOblong(T,L,W,R)
	#local HBL = (L-W)/2;
	#local HT = T/2;
	#local HW = W/2;
	union {
		difference {
			RoundCylinder (T, HW, R)
			box {<0, -T, -W> <L, T, W>}
			translate -HBL*x
		} // difference
		difference {
			RoundCylinder (T, HW, R)
			box {<-L, -T, -W> <0, T, W>}
			translate HBL*x
		} // difference
		box {<-HBL, -HT, -HW+R> <HBL, HT, HW-R>}
		box {<-HBL, -HT+R, -HW> <HBL, HT-R, HW>}
		cylinder {-HBL*x HBL*x R translate <0,  HT-R,  HW-R>}
		cylinder {-HBL*x HBL*x R translate <0,  HT-R, -HW+R>}
		cylinder {-HBL*x HBL*x R translate <0, -HT+R,  HW-R>}
		cylinder {-HBL*x HBL*x R translate <0, -HT+R, -HW+R>}
	} // union
#end // macro RoundOblong

#macro Center(_thing)
	object {_thing
		translate -(min_extent(_thing)+max_extent(_thing))/2
	}
#end

#macro Size(_thing) (max_extent(_thing)-min_extent(_thing)) #end

#macro ForceScale(_thing,_size)
	#local Dsize=rgb _size;
	#local Tsize=Size(_thing);
	#local Scale=<Dsize.x/Tsize.x,Dsize.y/Tsize.y,Dsize.z/Tsize.z>;
  object {_thing scale Scale}
#end

#macro Inlay(_inlay,_cutout,_base)
	union {
		object {_inlay}
		difference {
			object {_base}
			object {_cutout}
		} // difference
	} // union
#end // macro Inlay

#macro Card(_suit,_rank)

	#if (_rank > 9)
		// pick the inlay
		#local Face=Faces[_suit][_rank-10]
		#local Cutout=box{<-.78,-10,-1.28> <.78,10,1.28> scale IN}
		#local Inlaid=box{<0,0,0><1,1,1>
			texture {
				pigment {
					image_map {
						png Face
						map_type 0	//planar
						once
						interpolate 4	//normalized distance
					}
					rotate 90*x
				}
				finish {CardFinish}
			}
			scale <1.56*IN,CardT,2.56*IN>
			translate <-.78*IN,-CardT/2,-1.28*IN>
		}
		#local ThisCard = object {Inlay(Inlaid,Cutout,BlankCard)}
	#else
		#if (_rank=0 & _suit=3) //Ace of Spades
			#local Face=SpadeAce
			#local CutOut=box{<-.75,0,-1.25> <.75,1,1.25> scale IN}
			#local Inlaid=box{<0,0,0><1,1,1>
				texture {
					pigment {
						image_map {
							png Face
							map_type 0	//planar
							once
							interpolate 4	//normalized distance
						}
						rotate 90*x
					}
					finish {CardFinish}
				}
				scale <1.56*IN,CardT/2,2.56*IN>
				translate <-.78*IN,0,-1.28*IN>
			}
			#local ThisCard = object {Inlay(Inlaid,CutOut,BlankCard)}
		#else
			#local ThisCard = object {BlankCard}
		#end
	#end
	


	#local Cutout=union {
	
		// indices
		object {Center(ForceScale(Indices[_rank],<.25*IN,1,.375*IN>)) translate <-1*IN,0,1.375*IN>}
		object {Center(ForceScale(Pips[_suit],<.25*IN,1,.375*IN>)) translate <-1*IN,0,.875*IN>}
		object {Center(ForceScale(Indices[_rank],<.25*IN,1,.375*IN>)) translate <-1*IN,0,1.375*IN> rotate 180*y}
		object {Center(ForceScale(Pips[_suit],<.25*IN,1,.375*IN>)) translate <-1*IN,0,.875*IN> rotate 180*y}

		// pips
		#if (_rank != 0 | _suit != 3) // if not the Ace of Spades
			#local Spots=PipSpots[_rank];
			#local N=dimension_size(Spots,1);
			#local I=0;
			#while (I<N)
				#local Spot=Spots[I];
				object{
					Center(ForceScale(Pips[_suit],<.4*IN,1,.6*IN>)) 
					#if (Spot.v < 0)
						rotate 180*y
					#end
					translate <Spot.u*IN,.5,Spot.v*IN>
				}
				#local I=I+1;
			#end
		#end
	}
	
	#local Inlaid=intersection {
		object {Cutout}
		box {<-1,0,-1> <1,CardT/2,1>}
		texture {SuitTextures[_suit]}
	}
	
	#local ThisCard=Inlay(Inlaid,Cutout,ThisCard)
	object {ThisCard}
#end

#macro CardBack(_c)
	union{
		difference {
			object {BlankCard}
			box {<-1.125,-1,-1.625>*IN <1.125,1,1.625>*IN}
		}
		difference {
			box {<-1.125*IN,-CardT/2,-1.625*IN> <1.125*IN,CardT/2,1.625*IN>}
			box {<-1.1*IN,-1,-1.6*IN> <1.1*IN,1,1.6*IN>}
			texture {pigment {color _c} finish {CardFinish}}
		}
		box {<-1.1*IN,-CardT/2,-1.6*IN> <1.1*IN,CardT/2,1.6*IN>
			texture {T_CardWhite}
			texture {
				pigment {
					checker rgbt <_c.x,_c.y,_c.z,.2>, rgbt <0,0,0,1>
					scale <.05*IN,10,10>
					translate <0,5,5>
					rotate 30*y
				}
				finish {CardFinish}
			}
			texture {
				pigment {
					checker rgbt <_c.x,_c.y,_c.z,.2>, rgbt <0,0,0,1>
					scale <.05*IN,10,10>
					translate <0,5,5>
					rotate -30*y
				}
				finish {CardFinish}
			}
		}
	}
#end

#macro Deck(_cards,_neat,_color)
	union{
		#local I=0;
		#while (I<_cards)
			object {CardBack(_color)
				rotate _neat*(-90+180*rand(RS))*y
				translate <_neat*(-1+2*rand(RS))*IN,I*Size(BlankCard).y,_neat*(-1+2*rand(RS))*IN>
			}
			#local I=I+1;
		#end
	}
	translate Size(BlankCard).y/2*y
#end

#macro PokerChip(CC,EC)
	union{
		object {CutChip
			texture {
				pigment {color CC}
				finish {
					ambient 0.2
					diffuse 0.8
				} // finish
				normal {granite .2 scale 0.002}
			} // texture
		} // object
		object {ChipDots
			texture {
				pigment {color EC}
				finish {
					ambient 0.2
					diffuse 0.8
					specular 0.1
					roughness 0.1
				} // finish
			} // texture
		} // object
//		translate 1.66*MM*y
	} // union
#end // macro PokerChip

#macro ChipStack(CC,EC,N)
	union{
		#local I=0;
		#while (I<N)
			object {PokerChip(CC,EC)
				rotate <int(2*rand(RS))*180,360*rand(RS),0>
				translate <(-.5+rand(RS))*MM,3.32*MM*I,(-.5+rand(RS))*MM>
			}
			#local I = I + 1;
		#end // while (I<N)
	}
#end // macro ChipStack



#declare RS=seed(176453);


#declare P_wood = pigment {
	wood
color_map {
	[ 0.0 rgb <0.85, 0.65, 0.3> ]
	[ 0.5 rgb <1.000000, 0.75, 0.37> ]
	[ 1.0 rgb <1.000000, 0.8, 0.4> ]
}
	warp {
		turbulence .2
		octaves 2
	}
	scale .04
	rotate (4-8*rand(RS))*z
}


#declare T_wood=texture{
	pigment {P_wood}
	finish {ambient 0.2 diffuse 0.7 reflection 0.1}
}


#declare IN=1/12;
#declare MM=IN/25.4;

#declare CardWhite = color rgb <1,1,1>;
#declare CardRed = color rgb<0.8, 0, 0>;
#declare CardBlack=color rgb <0, 0, .01>;
#declare CardFinish = finish {ambient .2 diffuse .7 specular .4 roughness .1}

#declare T_CardWhite=texture{pigment{color CardWhite} finish{CardFinish}}
#declare T_CardRed=texture{pigment{color CardRed} finish{CardFinish}}
#declare T_CardBlack=texture{pigment{color CardBlack} finish{CardFinish}}

#declare SPip=prism {	cubic_spline linear_sweep 0,1,23,
	<.15,-.6>,<.15,-.6>,<.05,-.54>,<.01,-.1>,	<.01,-.1>,<.05,-.2>,	<.2,-.24>,<.35,-.15>,<.4,.08>,<.04,.55>,
	<0,.6>,<-.04,.55>,	<-.4,.08>,<-.35,-.15>,<-.2,-.24>,<-.05,-.2>,<-.01,-.1>,<-.01,-.1>,	<-.05,-.54>,
	<-.15,-.6>,<.15,-.6>,<.15,-.6>,<.15,-.6>	sturm}

#declare CPip=prism {cubic_spline linear_sweep 0,1,29,
	<.15,-.6>,<.15,-.6>,<.05,-.54>,<.01,-.1>,	<.01,-.1>,<.05,-.2>,<.2,-.24>,<.35,-.15>,<.35,.07>,
	<.24,.16>,<.07,.16>,<.2,.28>,<.195,.5>,<0,.6>,<-.195,.5>,<-.2,.28>,<-.07,.16>,<-.24,.16>,	<-.35,.07>,
	<-.35,-.15>,<-.2,-.24>,<-.05,-.2>,<-.01,-.1>,<-.01,-.1>,<-.05,-.54>,<-.15,-.6>,<.15,-.6>,<.15,-.6>,
	<.15,-.6> sturm}

#declare HPip=prism {	cubic_spline linear_sweep 0,1,13,
	<0,-1>,<0,-.6>,<.35,.03>,<.38,.46>,<.19,.6>,<.04,0.5>,<0,.42>,<-.04,.5>,<-.19,.6>,<-.38,.46>,<-.35,.03>,
	<0,-.6>,<0,-1> sturm}

#declare DPip=prism {linear_spline linear_sweep 0,1,5,<-.4,0>,<0,-.6>,<.4,0>,<0,.6>,<-.4,0> sturm}

#declare IxA=text{ttf "Rockwell","A" 1, 0 rotate 90*x}
#declare Ix2=text{ttf "Rockwell","2" 1, 0 rotate 90*x}
#declare Ix3=text{ttf "Rockwell","3" 1, 0 rotate 90*x}
#declare Ix4=text{ttf "Rockwell","4" 1, 0 rotate 90*x}
#declare Ix5=text{ttf "Rockwell","5" 1, 0 rotate 90*x}
#declare Ix6=text{ttf "Rockwell","6" 1, 0 rotate 90*x}
#declare Ix7=text{ttf "Rockwell","7" 1, 0 rotate 90*x}
#declare Ix8=text{ttf "Rockwell","8" 1, 0 rotate 90*x}
#declare Ix9=text{ttf "Rockwell","9" 1, 0 rotate 90*x}
#declare Ix10=text{ttf "Rockwell","10" 1, 0 rotate 90*x}
#declare IxJ=text{ttf "Rockwell","J" 1, 0 rotate 90*x}
#declare IxQ=text{ttf "Rockwell","Q" 1, 0 rotate 90*x}
#declare IxK=text{ttf "Rockwell","K" 1, 0 rotate 90*x}

#declare Indices=array [13] {IxA,Ix2,Ix3,Ix4,Ix5,Ix6,Ix7,Ix8,Ix9,Ix10,IxJ,IxQ,IxK}
#declare Pips= array [4] {CPip,DPip,HPip,SPip}

#declare PipSpots = array [13] {
	array [1] {<0,0>}
	array [2] {<0,.95> <0,-.95>}
	array [3] {<0,.95> <0,0> <0,-.95>}
	array [4] {<.55,.95> <.55, -.95> <-.55, .95> <-.55, -.95>}
	array [5] {<.55,.95> <.55, -.95> <-.55, .95> <-.55, -.95> <0,0>}
	array [6] {<.55,.95> <.55, -.95> <.55, 0> <-.55, .95> <-.55, -.95> <-.55,0>}
	array [7] {<.55,.95> <.55, -.95> <.55, 0> <-.55, .95> <-.55, -.95> <-.55,0> <0,.475>}
	array [8] {<.55,.95> <.55, -.95> <.55, 0> <-.55, .95> <-.55, -.95> <-.55,0> <0,.475> <0,-.475>}
	array [9] {
		<.55,.95> <.55, .3167> <.55, -.3167> <.55, -.95> 
		<-.55, .95> <-.55, .3167> <-.55, -.3167> <-.55, -.95>
		<0, 0>
	}
	array [10] {<.55,.95> <.55, .3167> <.55, -.3167> <.55, -.95> 
		<-.55, .95> <-.55, .3167> <-.55, -.3167> <-.55, -.95>
		<0, .6333> <0,-.6333>
	}
	array [2] {<.55,-.95> <-.55,.95>}
	
	array [2] {<.55,-.95> <-.55,.95>}
	array [2] {<.55,-.95> <-.55,.95>}
}

#declare Faces = array [4][3] {
	{"Jc.png" "Qc.png" "Kc.png"}
	{"Jd.png" "Qd.png" "Kd.png"}
	{"Jh.png" "Qh.png" "Kh.png"}
	{"Js.png" "Qs.png" "Ks.png"}
}

#declare SpadeAce = "As.png"

#declare SuitTextures = array [4] {T_CardBlack,T_CardRed,T_CardRed,T_CardBlack} // clubs, diamonds, hearts, spades

#declare CardT=.011*IN;
#declare CardH=3.5*IN;
#declare CardW=2.5*IN;
#declare CardR=0.125*IN;

#declare BlankCard=union{
	box {<-CardW/2+CardR,-CardT/2,-CardH/2> <CardW/2-CardR,CardT/2,CardH/2>}
	box {<-CardW/2,-CardT/2,-CardH/2+CardR> <CardW/2,CardT/2,CardH/2-CardR>}
	cylinder {0 CardT*y CardR translate <-CardW/2+CardR,-CardT/2,-CardH/2+CardR>}
	cylinder {0 CardT*y CardR translate <-CardW/2+CardR,-CardT/2, CardH/2-CardR>}
	cylinder {0 CardT*y CardR translate < CardW/2-CardR,-CardT/2,-CardH/2+CardR>}
	cylinder {0 CardT*y CardR translate < CardW/2-CardR,-CardT/2, CardH/2-CardR>}
	texture {T_CardWhite}
}

#declare OldMaidCard=union{
	box {<-CardW/2+CardR,-CardT/2,-CardH/2> <CardW/2-CardR,CardT/2,CardH/2>}
	box {<-CardW/2,-CardT/2,-CardH/2+CardR> <CardW/2,CardT/2,CardH/2-CardR>}
	cylinder {0 CardT*y CardR translate <-CardW/2+CardR,-CardT/2,-CardH/2+CardR>}
	cylinder {0 CardT*y CardR translate <-CardW/2+CardR,-CardT/2, CardH/2-CardR>}
	cylinder {0 CardT*y CardR translate < CardW/2-CardR,-CardT/2,-CardH/2+CardR>}
	cylinder {0 CardT*y CardR translate < CardW/2-CardR,-CardT/2, CardH/2-CardR>}
	texture {
		pigment {
			image_map {
				png "OldMaid.png"
				map_type 0	//planar
				once
				interpolate 4	//normalized distance
			}
			rotate 90*x
			scale 3.5*IN
			translate <-1.75*IN,0,-1.75*IN>
		}
		finish {CardFinish}
	}
}

#declare ChipRed=color rgb <.7, .1, .12>;
#declare ChipBlue = color rgb <.15, .1, .6>;
#declare ChipWhite = color rgb <.9, .85, .8>;



#declare ChipBlank=difference{
	cylinder {0 3.32*MM*y 19.92*MM}
	cylinder {-1*y 0.32*MM*y 12*MM}
	cylinder {3.*MM*y y 12*MM}
}

#declare ChipDotDie=union{
	#local I=0;
	#while (I<6)
		box {<-3.32*MM, -1, 16*MM> <3.32*MM, 1, 1> rotate 60*I*y}
		#local I = I + 1;
	#end // while I
	// suits 
	object{Center(ForceScale(SPip,<5*MM,1,7*MM>)) translate 6*MM*z}
	object{Center(ForceScale(HPip,<5*MM,1,7*MM>)) translate 6*MM*z rotate 90*y}
	object{Center(ForceScale(CPip,<5*MM,1,7*MM>)) translate 6*MM*z rotate 180*y}
	object{Center(ForceScale(DPip,<5*MM,1,7*MM>)) translate 6*MM*z rotate 270*y}
} // union

#declare CutChip=difference {
	object {ChipBlank}
	object {ChipDotDie}
}

#declare ChipDots=intersection{
	object {ChipBlank}
	object {ChipDotDie}
}
#declare BlueChip=PokerChip(ChipBlue, ChipWhite)
#declare RedChip=PokerChip(ChipRed,ChipWhite)
#declare WhiteChip=PokerChip(ChipWhite,ChipBlue)

#declare RaceTrack=difference{
	Oblong (.5*IN, 8, 4)
	Oblong (1*IN, 6, 2)
	translate 5/8*IN*y
	texture {
		T_wood
		rotate 90*y
	}
	
}

#declare Burgundy=color rgb <0.3, 0.02, 0.1>;

#declare Infield=object {
	RoundOblong (.5*IN, 6, 2, .125*IN)
	translate 0.875*IN*y
	texture {
		pigment {
			checker Burgundy Burgundy*.99
		} // pigment
			scale 0.1
		finish {
			ambient .2
			diffuse .8
		}
		normal {agate .4 scale .005}
	} // texture
}

#declare Rail=union{
	difference {
		FlatTorus (21*IN,25*IN,.5*IN,2*IN)
		box {<-10,-10,-10> <0,10,10>}
		translate <2,0,0>
	}
	difference {
		FlatTorus (21*IN,25*IN,.5*IN,2*IN)
		box {<0,-10,-10> <10,10,10>}
		translate <-2,0,0>
	}
	object {RoundBox(2*IN,4,4*IN,.5*IN) translate -23*IN*z}
	object {RoundBox(2*IN,4,4*IN,.5*IN) translate 23*IN*z}
	
	translate 15/96*y	
	
	texture {
		pigment {color rgb <0.1, 0.0, 0.01>}
		finish {
			ambient 0.2
			diffuse 0.8
			specular 0.3
			roughness 0.1
		}
	} // texture
	
} // union


#declare Table=union{
	object {RaceTrack}
	object {Infield}
	object {Rail}
}

// the kitty
#declare Kitty = array [9];

#declare Kitty[0] = array [20] {
	<0.0, 1.1> <0.1, 2.6> <0.6, 1.7> <1.0, 0.6> <1.2, 2.7> 
	<1.6, 0.0> <1.6, 3.7> <1.7, 1.5> <2.3, 2.5> <2.5, 0.8>
	<2.7, 3.5> <3.1, 1.6> <3.5, 0.2> <3.5, 2.6> <4.1, 1.2>
	<4.5, 3.3> <4.6, 2.2> <5.0, 0.5> <5.5, 1.5> <5.6, 2.7>
}

#declare Kitty[1] = array [17] {
	<0.1, 2.0> <0.7, 1.2> <1.0, 2.6> <1.6, 0.5> <1.6, 1.7>
	<2.0, 3.2> <2.6, 1.2> <2.6, 2.3> <3.0, 3.3> <3.2, 0.2>
	<3.7, 1.3> <3.7, 2.4> <4.5, 0.5> <4.6, 3.1> <4.7, 1.7>
	<5.5, 1.1> <5.6, 2.4>
}

#declare Kitty[2] = array [15] {
	<0.2, 1.3> <0.3, 2.3> <1.2, 1.2> <1.2, 2.7> <2.0, 2.0>
	<2.1, 0.5> <2.3, 3.1> <2.7, 1.4> <3.4, 0.5> <3.5, 2.2>
	<4.0, 3.2> <4.2, 1.3> <5.0, 2.6> <5.1, 0.6> <5.4, 1.6>
}

#declare Kitty[3] = array [13] {
	<0.5, 2.1> <0.6, 1.0> <1.5, 1.6> <1.6, 0.5> <1.6, 3.2>
	<2.5, 1.7> <2.6, 2.7> <2.7, 0.6> <3.5, 1.5> <3.7, 0.4>
	<3.7, 2.6> <4.7, 1.1> <5.0, 2.2>
}

#declare Kitty[4] = array [12] {
	<1.0, 1.4> <1.0, 2.5> <1.2, 0.3> <1.7, 3.2> <2.0, 2.2>
	<2.1, 1.1> <3.1, 0.4> <3.1, 2.6> <3.2, 1.5> <4.1, 0.7>
	<4.3, 2.4> <5.0, 1.4>
}

#declare Kitty[5] = array [10] {
	<1.2, 1.6> <1.5, 2.6> <1.6, 0.5> <2.5, 1.2> <2.5, 2.3>
	<3.5, 0.5> <3.5, 2.7> <3.6, 1.6> <3.6, 1.1> <3.6, 2.2>
}

#declare Kitty[6] = array [6] {
	<1.6, 1.1> <2.3, 2.2> <2.7, 3.0> <3.6, 2.4> <3.7, 1.3>
	<4.7, 1.6>
}

#declare Kitty[7] = array [4] {
	<2.2, 1.3> <3.1, 2.3> <3.3, 1.0> <4.1, 1.7>
}

#declare Kitty[8] = array [2] {
	<2.7, 1.5> <3.7, 1.3>
}

#declare CardLoc=<0,1.125,7>*IN;
#declare KittyLoc=CardLoc + <-4,0,-10>*IN;
#declare MuckLoc=<-11,1.125,7>*IN;
#declare DeckLoc=<.3,.875*IN,1.3>;
#declare Hand1Loc=<-2.55,1.125*IN,-.5>;
#declare Hand1StackLoc = <-39,.875,-5>*IN;
#declare Hand2Loc=<-1,1.125*IN,-.75>;

#declare Hand1=union{
	object {Card(3,6)}
	object {Card(2,0) rotate 28*y translate <1.1*IN,.012*IN,.25*IN>}
}

#declare Hand2=union{
	object {Card(0,9)}
	object {Card(1,9) rotate 4*y translate <3.1*IN,0,-.3*IN>}
}

#macro Jiggle(_x)
	object {_x translate <2*rand(RS),0,2*rand(RS)>*MM}
#end

#declare Hand1Stack=union{
	Jiggle (ChipStack(ChipWhite,ChipBlue,12))
	object {Jiggle (ChipStack(ChipWhite,ChipBlue,10)) translate <22.5,0,45*sqrt(3)/2>*MM}
	object {Jiggle (ChipStack(ChipWhite,ChipBlue,10)) translate 45*sqrt(3)/2*MM*z}
	object {Jiggle (ChipStack(ChipBlue,ChipWhite,10)) translate <67.5,0,45*sqrt(3)/2>*MM}
	object {Jiggle (ChipStack(ChipBlue,ChipWhite,15)) translate 45*MM*x}
	object {Jiggle (ChipStack(ChipBlue,ChipWhite,10)) translate <45,0,45*sqrt(3)>*MM}
	object {Jiggle (ChipStack(ChipRed,ChipWhite,10)) translate 90*MM*x}
	object {Jiggle (ChipStack(ChipRed,ChipWhite,10)) translate 135*MM*x}
	object {Jiggle (ChipStack(ChipRed,ChipWhite,5)) translate <112.5,0,45*sqrt(3)/2>*MM}
}

#declare ChipChoice=array[3]{BlueChip RedChip WhiteChip}

#declare KittyPile = union {
	#local Ilayer = 0;
	#local Maxlayer = dimension_size(Kitty,1);
	#local Maxtilt = 2;
	#while (Ilayer < Maxlayer)
		#local Ichip = 0;
		#while (Ichip < dimension_size(Kitty[Ilayer],1))
			#local UV = Kitty[Ilayer][Ichip];
			#local Uwhole = UV.u;
			#local U = Uwhole + 1.25 * (UV.u - Uwhole);
			#local Vwhole = UV.v;
			#local V = Vwhole + 1.25 * (UV.v - Vwhole);
			#local X = (39.92 * U + 0.08 * rand(RS)) * MM;
			#local Y = 3.32 * MM * Ilayer;
			#local Z = (39.92 * V + 0.08 * rand(RS)) * MM;
	
			object {
				ChipChoice[int(3 * rand(RS))]
				rotate 360 * rand(RS) * y
				#if (rand(RS) > .5)
					rotate 180 * x
					translate 3.32 * MM * y
				#end
				rotate <Maxtilt * rand(RS) * Ilayer / Maxlayer, 360 * rand(RS), 0>
				translate <X, Y, Z>
			}
			#local Ichip = Ichip + 1;
		#end
		#local Ilayer = Ilayer + 1;
	#end
} // union 	
	
object {Table}
object {Card(0,0) rotate 180*y translate CardLoc-6*IN*x+0.01*IN*y}
object {Card(2,9) translate CardLoc-3*IN*x+0.01*IN*y}
object {Card(1,0) translate CardLoc+0.01*IN*y}
object {Card(3,7) translate CardLoc+3*IN*x+0.01*IN*y}
object {OldMaidCard translate CardLoc+6*IN*x+0.01*IN*y}
object {KittyPile translate KittyLoc}
object {Deck(32,.02,<0,0,0.4>) rotate -10*y translate DeckLoc}
object {Deck(13,.75,<0,0,0.4>) translate MuckLoc}
object {Hand1 rotate 73*y translate Hand1Loc}
object {Hand1Stack rotate 75*y translate Hand1StackLoc}
object {Hand2 rotate -15*y translate Hand2Loc}



light_source {
	0
	rgb .75
	area_light < 0.0,  0.0, 0.0 >,   < 2.0, 0.0, 4.0 >,  3,  3
	jitter 
	translate <5, 10, -8>
}

light_source {
	0
	rgb .75
	area_light < 0.0,  0.0, 0.0 >,   < 2.0, 0.0, 4.0 >,  3,  3
	jitter 
	translate <-5, 10, 0>
}


camera {
	perspective 
	location <.75,1.25,-.25>
	up y*image_height right x*image_width
	angle 60
	look_at CardLoc+z/2-x/2-y
}
