#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "transforms.inc"

/*
global_settings {
    assumed_gamma 1.0
}

// ----------------------------------------

camera {
    location  <0.0, 0, -9.0>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
    pigment {
      wrinkles
      color_map {
        [0.0 rgb <0.6,0.7,1.0>]
        [0.7 rgb <0.0,0.1,0.8>]
      }
    }
}

light_source {
    <0, 0, 0>            // light's position (translated below)
    color rgb <1, 1, 1>  // light's color
    translate <0, 0, -30>
}

// ----------------------------------------
*/

#declare fn_Oyster = function(x,y,z,XOb,YOb,ZOb) {
	pow(x+XOb,2)+pow((y+YOb)*1.5,2)+pow((z+ZOb)/2,2) - 1
		+ f_noise3d(x,y,z)*1.
		- f_noise3d(x*3,y*3,z*3)*0.25
		- f_ridged_mf(x/8,0,z/8,1,3,6,2,3,2)/1.5 + 3
}

#macro OysterBase(XO,YO,ZO)
	isosurface {
	    function { fn_Oyster(x,y,z,XO,YO,ZO) }
	    contained_by{sphere{<-XO,-YO,-ZO>,3}}
	    accuracy 0.001
	    max_gradient 15
	    translate<XO,YO,ZO>
	}
#end

#macro Barnacle()
	#declare BD = (rand(BR1)*0.07)+0.08;
	#declare BD2 = (rand(BR1)*0.03) + BD*0.25;
	#declare BH = (rand(BR1)*0.015)+0.09;
	difference{cone{y*-0.1,BD,y*BH,BD2} cone{0,BD/2,y*(BH+0.1),BD2/2}}
#end

#macro MakeBarnacles(Seed, BCount, BCount2)
	#declare BR1 = seed(Seed);
	#declare BFound = 0;
	#while(BFound < BCount)
		#declare BNorm = <0,0,0>;
		#declare BPos = trace(Oyster,<(rand(BR1)*6)-3,5,(rand(BR1)*6)-3>,<0,-5,0>,BNorm);
		#if(vlength(BNorm)!=0)
			#declare BFound = BFound + 1;
			#declare BFound2 = 0;
			#declare BCount3 = int(BCount2/2) + int(rand(BR1)*BCount2/2) + 1;
			#while(BFound2 < BCount3)
				#declare BNorm2 = <0,0,0>;
				#declare BPos2 = trace(Oyster,BPos-<(rand(BR1)*0.4)-0.2,-5,(rand(BR1)*0.4)-0.2>,<0,-5,0>,BNorm2);
				#if(vlength(BNorm2)!=0)
					object{
						Barnacle() Point_At_Trans(BNorm2) translate BPos2

		pigment{granite scale 0.1 pigment_map{[0.0 rgb<255,222,173>/255][1.0 rgb<0.75,0.70,0.5>]}}
	  normal{
	  	average 2 normal_map{
	  		[1 agate 0.1 scale 0.25][1 granite 1 scale 0.12]
	  	}
	  }
	  finish{
	  	specular 0.45
	  	roughness 0.03
	  	reflection{fresnel}
	  	conserve_energy
	  	ambient 0
	  	diffuse 0.75
	  }
   	interior{ior 1.32}

					}
					#declare BFound2 = BFound2 + 1;
				#end
			#end
		#end
	#end
#end



#macro MakeOyster(MBSeed,MOX,MOY,MOZ,TPSeed)
	#declare Oyster = OysterBase(MOX,MOY,MOZ)
	#declare TPR = seed(TPSeed);
	#declare FinalOyster =
	union{
		MakeBarnacles(MBSeed,9,15)
		object{Oyster}
		#declare TempTrans = <rand(TPR)*1000,rand(TPR)*1000,rand(TPR)*1000>;
		translate TempTrans
		texture{
		  normal{
		  	average 4 normal_map{
		  		[1 agate 1.75 scale 0.25][1 dents 4 scale 1][1 granite 2 scale 0.2][1 crackle 5 scale 0.5 turbulence 0.75]
		  	}
		  }
		  finish{
		  	specular 0.65
		  	roughness 0.03
		  	reflection{fresnel}
		  	conserve_energy
		  	ambient 0
		  	diffuse 0.55
		  }
		  pigment{
		  	agate scale 1.95 turbulence 0.75
		  	pigment_map{
		  		[0 wrinkles scale 0.1 pigment_map{[0.5 rgb<0.99,0.8,0.5>][1.0 rgb<0.6,0.55,0.35>]}]
		  		[0.7 wrinkles scale 0.1 pigment_map{[0.0 rgb<0.99,0.85,0.8>][0.5 rgb<0.6,0.45,0.35>]}]
		  	}
		  }
		}
	  interior{ior 1.32}
	  translate 0-TempTrans 
	}
#end

