#include "colors.inc"
#include "textures.inc"

// fusta
#declare fusta=
superellipsoid{<.1,.1>
scale <.2,0.05,1>
 texture{DMFWood1
 scale .1      
 }
 translate 1*y
}        


//ampolla
#declare ampolla=
lathe{
  linear_spline
  10,
  <0,0>,<.3,0>,
  <.3,1.3>,<.25,1.4>, <.23,1.5>,
  <.17,1.6>,<.1,1.9>,
  <.13,1.9>,<.13,2>,
  <.08,2>
  texture{NBbeerbottle} 
  finish{ambient.3}
  scale .15
}  


//revista
#declare B11=<0,0,3>; #declare B12=<1,.5,3>; 
#declare B13=<2,.3,3>; #declare B14=<3,0,3>; 

#declare B21=<0,0,2>; #declare B22=<1,.5,2>; 
#declare B23=<2,.3,2>; #declare B24=<3,0,2>; 

#declare B31=<0,0,1>; #declare B32=<1,0,1>; 
#declare B33=<2,0,1>; #declare B34=<3,0,1>; 

#declare B41=< 0,0,0>; #declare B42=<1,.5,0>;
#declare B43=<2,-1,0>; #declare B44=<3,0,0>;
#declare revista=
union{
 bicubic_patch {
   type 1 flatness 0.001
   u_steps 4 v_steps 4
   uv_vectors
   <0,0> <1,0> <1,1> <0,1>
   B11, B12, B13, B14
   B21, B22, B23, B24
   B31, B32, B33, B34
   B41, B42, B43, B44
   uv_mapping
   texture {
      pigment {
        image_map{png "revista.png" map_type 0 once}
      }  
      finish{phong .07}
   } 
   scale <1,1,1.5>
   rotate 180*x
 }                    
 #local inici=1;  
 #while (inici<10)
 bicubic_patch {
   type 1 flatness 0.001
   u_steps 4 v_steps 4
   uv_vectors
   <0,0> <1,0> <1,1> <0,1>
   B11, B12, B13, B14
   B21, B22, B23, B24
   B31, B32, B33, B34
   B41, B42, B43, B44
   texture {
      pigment {
       White
      }
   } 
   scale <1,1,1.5>
   rotate 180*x
   rotate -inici*2.5*z
 }                 
 #local inici=inici+1;
 #end  
 scale .09
}




// el retol 
#declare ferro=
union{
  box{
    <-.5,0,-.035>,
    <.5,.015,.035>
  }  
  box{
    <-.5,0,-.035>,
    <.5,.015,.035>
    rotate 90*x
    translate .042*y
  } 
  box{
    <-.5,0,-.035>,
    <.5,.015,.035>
    translate .05*y
  }                    
  texture{Rusty_Iron}
}  

#declare suport=
union{  
  object{ferro
    scale <3,1,1>
    rotate 90*z
    rotate 90*y
    translate <0,1.5,.08>
  }
  object{ferro
    scale <.3,1,1>
    rotate 90*z
    rotate 90*y
    rotate -45*x
    translate <0,2.8,.22>
  }
  object{ferro
    scale <3,1,1>
    rotate 90*z
    rotate 90*y 
    rotate -10*x
    translate <0,1.25,.58>
  }
  object{ferro
    scale <.5,1,1>
    rotate 90*y 
    translate <0,1.25,.34>
  }
  object{ferro
    scale <1.7,.5,.5>
    rotate 90*z
    rotate 90*y 
    rotate -15*x
    translate <0,2.1,.33>
  }
  object{ferro
    scale <1.5,.5,.5>
    rotate 90*z
    rotate 90*y 
    rotate 19*x
    translate <0,.6,.33>
  }  
  translate -.5*y
}

#declare retol= 
union{
  union{
    box{
      <-1.7,-.2,0>,
      <1.7,1.2,.04>
      texture{
        pigment{dents
         turbulence .5
         color_map{
         [.8 White]
         [.1 Brown]
         [.1 Gray20]
         } 
        } 
        finish{ambient .4} 
        scale .4
      }  
    }                            
    box{
      <-1.5,0,-.01>,
      <1.5,1,0>
      pigment {
        image_map{
          png "retol.png"
          once  
        } 
        scale <3,1,1>
        translate -1.5*x 
      }   
      normal{bumps .5}
      finish{ambient .5}             
    } 
    translate 1.5*y
  }               
  object{suport}
  object{suport translate 1.5*x}
  object{suport translate -1.5*x}
}  



//palmera
//tronc       
#local alt=20;    
#local h_factor= alt/10;       
#local R_radi=seed(1);              
#local R_xpos=seed(0);              
#local rp1=1;
#local p1=<1, -1, 0>;
#local rp2=1;
#local p2=<0, 0, 0>;
#local xp3= -.5+(-.5)*rand(R_xpos);
#local rp3= .4+(.1)*rand(R_radi);
#local p3=<xp3, h_factor*2.5, 0>;       
#local rp4= .4+(.1)*rand(R_radi);
#local p4=<0, h_factor*5, 0>;
#local xp5= 0+(.5)*rand(R_xpos);
#local rp5= .4+(.1)*rand(R_radi);
#local p5=<xp5, h_factor*7.5, 0>;       
#local rp6= .4+(.1)*rand(R_radi);
#local p6=<0, h_factor*10, 0>;
#local rp7=.5;
#local p7=<0, h_factor*11, 0>;
#local p8=<1, h_factor*12, 0>;
#declare tronc=            
union{
  sphere_sweep{
    b_spline
    8,
    p1,rp1,
    p2,rp2,
    p3,rp3,
    p4,rp4,
    p5,rp6,
    p6,rp6,
    p7,rp7,
    p8,rp7
  }
  sphere{
    <0, h_factor*9, 0>,1
    scale<1,1.3,1>
  }  
  pigment{
   wrinkles
   color_map{
     [.1 Green]
     [.2 DarkBrown]
     [.4 Gray10]
     [.6 Gray70]
   } 
   scale .01
  }
}  


//palma 
#declare fulla=
prism{
  0,.001,4,
  <-.02,0>,
  <0,1>,
  <.02,0>,   
  <-.02,0>
  rotate -90*x
}  
#declare i_palma=
cone{ 
  <0,0,0>,.06
  <0,1,0>, .03
} 
#declare s_palma=
union{
  cylinder{
    <0,0,0> <0,1,0> .03
  }          
  #local pf=0;
  #while (pf<1)
    object{fulla rotate (35+pf)*z translate pf*y}
    object{fulla rotate (35+pf)*z rotate 170*y translate pf*y}
    #local pf=pf+.1;
  #end   
  rotate 90*y
}  
#declare f_palma=   
union{
  cone{ 
    <0,0,0>,.03
    <0,1,0>,0
  } 
  #local pf=0;
  #while (pf<1)
    object{fulla rotate (35-pf)*z translate pf*y}
    object{fulla rotate (35-pf)*z rotate 170*y translate pf*y}
    #local pf=pf+.1;
  #end   
  #while (pf<5)
    object{fulla rotate (35-(pf*7))*z translate 1*y}
    object{fulla rotate (35-(pf*7))*z rotate 170*y translate 1*y}
    #local pf=pf+1;
  #end   
  rotate 90*y
}
#declare palma=
union{
  object{i_palma rotate 10*z}
  object{s_palma rotate 5*z translate <-.175, .98, 0>}
  object{s_palma  translate <-.263, 1.97, 0>}
  object{s_palma  rotate -5*z translate <-.263, 2.97, 0>}
  object{f_palma  rotate -10*z translate <-.176, 3.96, 0>}
  pigment{Green}
}  

// la palmera
#declare palmera=
union{
  object{tronc}  
  #local pfp=h_factor*12;
  #local inc_palma=10;   
  #local des_palma=.5;   
  #while (pfp>h_factor*11)
    #local pf=0;
    #while (pf<10) 
      object{palma
        rotate -inc_palma*z
        translate des_palma*x
        rotate (36*pf)*y 
        translate pfp*y
      }
      #local pf=pf+1;
    #end            
    #if (pfp>=h_factor*11.5)
      #local des_palma=des_palma+.1;
    #else
      #local des_palma=des_palma-.1;
    #end  
    #local pfp=pfp-.2;   
    #local inc_palma=inc_palma+16.5;
  #end  
}  


