#version 3.6

#include "colors.inc"
#include "textures.inc"
#include "after.inc" 

#declare aigua=1;
#declare caixes=1;            
#declare p_brossa=1;    
#declare fustes=1;     
#declare p_retol=1;   
#declare palmeres=1;       
#declare radi=1;

#declare T_aigua=
texture { 
    NBglass
    pigment { rgbf <0.1, 0.7, 0.8, 0.4> }
}
 
#declare T_brossa1=
 texture{
   pigment{Tan}     
 } 

#declare T_brossa2=
 texture{
   pigment{Brown}
 } 
  
  
camera {
    location <0, 1.5, -16>
    look_at <0,0,0>
    angle 93
}

  

light_source { 
    <0, 40, 0>   
    color White
    area_light <-50,0,0> <50,0,50> 4,4
}

plane{
 <0,1,0> ,0
 texture{
   pigment{White}
   normal{waves 1}
   normal{ripples 1}
 }  
}

sphere{
<0,0,0>,1000
texture{Blue_Sky3 scale 1000}     
hollow
} 

#if (aigua)
plane{
 <0,1,0> ,1
 texture{
   T_aigua
   normal{waves 10}
   normal{ripples 1}
 }  
} 
#end


// some different boxes
#if (caixes)   
#declare i=0;
#local r_mides=seed(21);
#local maxx=1;
#local minx=.3;
#local maxy=.2;
#local miny=.1;
#local maxz=1;
#local minz=.3;
#local maxpx=5;
#local minpx=-5;
#local maxpy=1;
#local minpy=.7;
#local maxpz=5;
#local minpz=-15;  
#local anglemaxx=90;
#local anglemaxy=90;
#local anglemaxz=90;
#while(i<20)                  
  box{ 
    <-(minx+(maxx-minx)*rand(r_mides)),-(miny+(maxy-miny)*rand(r_mides)),-(minz+(maxz-minz)*rand(r_mides))>,
    <0,.3,0>
    texture{pigment{rgb <1*rand(r_mides) 1*rand(r_mides) 1*rand(r_mides)>}}
    rotate -anglemaxx*rand(r_mides)*x
    rotate -anglemaxy*rand(r_mides)*y
    rotate -anglemaxz*rand(r_mides)*z
    translate <minpx+(maxpx-minpx)*rand(r_mides),minpy+(maxpy-minpy)*rand(r_mides),minpz+(maxpz-minpz)*rand(r_mides)>
  }                     
  #declare i=i+1;
#end
#end

#if (p_brossa)    
#declare brossa1=
height_field{
 png "brossa.png" 
 water_level .3 
 texture{T_brossa1}
 scale<1,.05,1>  
 translate <0,.97,0>
}              
#declare brossa2=
height_field{
 png "brossa.png" 
 water_level .3   
 texture{T_brossa2}
 scale<1,.05,1>  
 translate <0,.97,0>
}              
#local i=0;
#local r_mides=seed(13);
#local maxx=4;
#local minx=.3;
#local maxz=4;
#local minz=.3;
#local maxpx=5;
#local minpx=-5;
#local maxpz=5;
#local minpz=-13;  
#local anglemaxy=90;
#while(i<50)                  
  object{brossa1
    scale<minx+(maxx-minx)*rand(r_mides),1,minz+(maxz-minz)*rand(r_mides)>  
    rotate -anglemaxy*rand(r_mides)*y
    translate <minpx+(maxpx-minpx)*rand(r_mides),0,minpz+(maxpz-minpz)*rand(r_mides)>
  } 
  #declare i=i+1;                                                                  
#end                   
#local r_mides=seed(7);
#local i=0;
#while(i<20)                  
  object{brossa2
    scale<minx+(maxx-minx)*rand(r_mides),1,minz+(maxz-minz)*rand(r_mides)>  
    rotate -anglemaxy*rand(r_mides)*y
    translate <minpx+(maxpx-minpx)*rand(r_mides),0,minpz+(maxpz-minpz)*rand(r_mides)>
  } 
  #declare i=i+1;                                                                  
#end            
#end
                 
                 
// some wood panels                 
#if (fustes)
#local i=0;
#local r_mides=seed(5);
#local maxx=2;
#local minx=.3;
#local maxz=2;
#local minz=.3;
#local maxpx=5;
#local minpx=-5;
#local maxpz=5;
#local minpz=-14;  
#local anglemaxy=90;
#while(i<25)                  
  object{fusta
    scale<minx+(maxx-minx)*rand(r_mides),1,minz+(maxz-minz)*rand(r_mides)>  
    rotate -anglemaxy*rand(r_mides)*y
    translate <minpx+(maxpx-minpx)*rand(r_mides),0,minpz+(maxpz-minpz)*rand(r_mides)>
  } 
  #declare i=i+1;                                                                  
#end                   
#end
                   
                   
// two palm trees                 
#if (palmeres)
object{palmera
  rotate 15*z 
  scale .5
  translate <-4,-4,-7> 
}
 
object{palmera
  rotate 40*y
  rotate 45*z
  scale .6
  translate <-1,-4,-2> 
} 
#end
      
//welcome wall chart 
#if (p_retol) 
object {retol 
  rotate 30*y
  translate <1,0,-12>
}              
#end

   
// ball  
union{
  cylinder{
    <0,0,0>
    <0,.01,0>
    .25
    texture{
      T_aigua
      normal{ripples 5}
      scale .05
    }  
  }                  
  sphere{
    <0,.0,0>,.1
    texture{
      pigment{
        gradient y
        color_map{
        [.2 White]
        [.2 Pink] 
        }
      }         
      scale .02
      finish{phong .7 ambient .4}
    }    
    rotate 45*z
    translate .08*y
  }  
  translate <-.5,.99,-15>
}  

 
// wood panel with "POV travels" magazine   
object{fusta  
    scale <.5,1,.5>
    rotate 30*y
    translate <.65,0,-14.8>
}    
object{revista 
  rotate 30*y 
  rotate -5*z
  rotate -5*x
  translate <.5,1.09,-15>
}  

 
//dirt
 object{brossa1
   translate -15*z
}
 object{brossa1        
   rotate 40*y
   translate <-1,0,-15>
}

//some leaves palm tree
object{palma    
  rotate -80*z
  rotate -25*x
  scale .5
  translate <-1,.65,-13.5>
}
object{palma  
  rotate 80*y
  rotate -25*z
  rotate -10*x
  scale .25
  translate <-.3,.2,-14.5>
  pigment{OldGold}
}
object{palma  
  rotate 80*y
  rotate 30*z
  rotate -10*x
  scale .25
  translate <0,.2,-14.6>
  pigment{OldGold}
}
object{palma
  rotate -80*z
  rotate -10*x
  scale .5
  translate <-3.2,.65,-14>
  pigment{OldGold}
}
       
//some bottles       
object{ampolla
  rotate 15*z
  translate<.15,.8,-15.2>
}  

object{ampolla
  rotate 15*z
  rotate -25*y
  translate<.05,.81,-15.4>
}  
object{ampolla
  rotate -15*z
  translate<-.25,.81,-15.3>
}  
              
                  
fog {
    distance 25
    color rgbf<0.7, 0.7, 0.7, .7>
    fog_type 2
    fog_offset 5
    fog_alt 1
}