// BEGIN File label.pov
//
// Copyright 2005 Windell Oskay
// ( windell (at) oskay.net )
//
// I claim copyright solely for the purpose of being able to claim 
// that *I too* have the right to use the contents of this scene.  
//
// So... please let me know if you reuse any part of this file.
//
// This file is a support file to aquarium.pov, 
// used to generate label.png, 
// the image map for the label on the blender.

camera {   orthographic
   location -2.5*z
   look_at 0  }
   
background {color rgb 1}
#default {finish {ambient 1 diffuse 0}}

union{
text { ttf "povlogo.ttf", "P", 0.1,  0              
scale 0.5 translate <-0.9,0.5,0>
texture{pigment {color rgb 0.8*z}}}

text { ttf "timrom.ttf", "overizer", 0.1,  0              
scale 0.4 translate <-0.6,0.5,0>
texture{pigment {color rgb 0.8*z}}}

superellipsoid {  <0.2, 0.2>  scale 1.1  translate 4*z}

superellipsoid {  <0.2, 0.2>  scale 1.05  translate 2*z
texture{pigment {color rgb 1}}}

difference{
superellipsoid {  <0.2, 0.2>  scale 0.95}
box {<-5,-0.6,-5>, 5}
}

text { ttf "cyrvetic.ttf", "ON", 0.1,  0              
scale 0.2 translate <0.2,0.2,0>
texture{pigment {color rgb 0.8*z}}}

text { ttf "cyrvetic.ttf", "OFF", 0.1,  0              
scale 0.2 translate <0.2,-0.1,0>
texture{pigment {color rgb 0.8*z}}}

text { ttf "cyrvetic.ttf", "PULSE", 0.1,  0              
scale 0.2 translate <0.2,-0.4,0>
texture{pigment {color rgb 0.8*z}}}

scale <4/3,1,1>
}
// END File label.pov