
#version unofficial megapov 1.1;

#declare dohead = true;
#declare initcape = false;
#declare calccape = false;
#declare dobody = true;
#declare complex_brush = true;
#declare hairstep = 1.5;
#declare rad=false;
#declare fixtures_on = true;
#declare fixtures = true;

#include "head.inc"
#include "woods.inc"
#include "mycloth.inc"
#include "hand.inc"
#include "brush.inc"
#include "fixture.inc"

global_settings {
     #if(rad)
        radiosity {
                pretrace_start 0.08
                pretrace_end   0.04
                count 35

                nearest_count 5
                error_bound 1.8
                recursion_limit 2

                low_error_factor 0.5
                gray_threshold 0.0
                minimum_reuse 0.015
                brightness 1
                always_sample no
        }
      #end
      ambient_light 0
      max_trace_level 10
  }

camera {
  location <20, 60, 0>
//  location <20, 60, 20>
//    location <40,90,50>
//        location<15,50,-30>
  right <4/3, 0, 0>
  direction <0, 0, 1.8>
  look_at <0, 43, -56>
//    look_at<4,43,-34>
    
}

//sphere {<5,46,-34> 1 pigment{Yellow}}

//These are three sources of light

light_source { <0, 89, 0> color .6 }

light_source { <30,50, -50> color .7 }
light_source { <15,50, -50> color .7 }
light_source { <0,50, -50> color .7 }
light_source { <-15,50, -50> color .7 }
light_source { <-30,50, -50> color .7 }

light_source { <20, 80, 0> color Gray90 }


// Perm kit
#declare permkit = object{
difference{
        box {<0,0,0><4,8,2>}
        box {<.1,.1,.1> <3.9,8.5,1.9> pigment{rgb<.7,.6,.5>}}
        pigment{image_map{png "PermKit.png" }scale <4,8,.7>}
     }
}

// a bottle    
#declare bottle = object{
        difference{
                union{
                        sphere{<0,0,0> 1
                                scale<4,4,1>
                        }                        
                        cylinder{<0,3,0> <0,4.2,0> .6}
                        
                              

                }
                
                union{
                        sphere{<0,0,0> 1
                                scale<3.9,3.9,.9>
                        }
                        cylinder{<0,3,0> <0,4.5,0> .5}
                }
        }                        
}    
/*
**                      DresserLeg
**                      ==========
*/
#declare dresserleg = object {
#local ttt = 0;
        union{
#while(ttt < 34)
                sphere {<0,ttt,0> 4}
#local ttt = ttt + 6;
#end
        }
}


/*
**                      Dresser
**                      =======
*/                
#declare dresser = object {
       union{
               superellipsoid{<.9,.1>
                     rotate<90,0,0>
                     scale<18,1,12>      
                     translate<0,36,12>
                     texture {T_Wood1 scale 10 translate<0,0,80> rotate<2,1,1>}
                
               }
        
                object {dresserleg
                        translate<0,0,12>
                        texture {T_Wood1 scale 10 translate <40,0,80> rotate< 5,0,0>}
                }

// mirror
                difference{
                        superellipsoid{<.9,.7>
                                rotate<0,0,0>
                                scale<15,12,1>      
                        }
 
                        superellipsoid{<.9,.7>
                                rotate<0,0,0>
                                scale<13,10,2>                      
                        }
                translate<0,48,4>
                texture {T_Wood1 scale 20 translate<0,0,0> rotate<1,2,90>}
                finish{diffuse .5}
                }
                
                cylinder {<0,0,0>,<0,0,.25>,1
                                scale<14,11,1>
                                translate<0,48,4>
                                pigment{White}
                                finish{ reflection {.9} ambient 0 diffuse .001 }
                         }


        }
}

InitHand();
MakeHand();
#declare righthand = object{
        object{hand}
}

InitHand();
#declare pointer_curl = .6;
#declare middle_curl = .7;
#declare ring_curl = .7;
#declare pinky_curl = .3;

MakeHand(); 
/*
**                              Body
**                              ====
*/
#declare body = object{
                        union{
                        superellipsoid{<.1,.5>
                                rotate<0,0,0>
                                scale<6,12,3.4>
                        }
                        
// breasts
                        sphere {<-2.25,7,-2> 2.5}
                        sphere {<2.25,7,-2> 2.5}
                                                
// Upper arms                        
                        union{ // Left arm assembly
                                sphere_sweep{linear_spline 2
                                        <0,0,0> 1.5, <6,0,0> 1.5
                                }
                                
                                union{
                                        sphere_sweep{linear_spline 2
                                                <0,0,0> 1.5, <4,0,0> 1
                                        }
                                        
                                        object {hand scale 1.5 rotate<0,0,-70> rotate<0,90,0> translate<4,0,0>}
                                        object {brush
                                                rotate<-90,40,0>
                                                translate<7,-1,-1>
                                        }
                                        
                                rotate<0,80,0>
                                translate<6,0,0>
                                }
                                
                                rotate<0,30,-70>
                                translate<6,11,0>
                        }

                        union{ // right arm assembly
                                sphere_sweep{linear_spline 2
                                        <0,0,0> 1.5, <-6,0,0> 1.5
                                }
                                
                                union{
                                        sphere_sweep{linear_spline 2
                                                <0,0,0> 1.5, <-4,0,0> 1
                                        }
                                        
                                        object{righthand scale<1.5,-1.5,1.5> rotate<0,-90,0> translate<-4,0,0>}
                                rotate<0,-48,0>
                                translate<-6,0,0>
                                }
                                
                                rotate<0,-30,90>
                                translate<-6,11,0>
                        }
                        
                              
                        pigment {Tan}                     
}                       }


/*
**              Initialized the cloth
*/
#if(initcape)
        WriteClothFile("cape.cth", 80, 80, 24/80, 10, 13,55)


/*
** Initialize the cloth simulator
*/
simcloth {
  iterations 0
  input "cape.cth"
  mesh_output "cape.msh"
  uv_mesh on
}
#end


#if(calccape)
simcloth {
  environment object{body}
  friction .99
  gravity -0.4*y
  damping 0.9
  intervals 0.05
  iterations 100
  input "cape.cth"
  output "cape.cth"
  mesh_output "cape.msh"
  smooth_mesh on
  uv_mesh on
}

#end
  
#declare Cape =
  mesh {
    #include "cape.msh"
    uv_mapping
    texture {
      pigment {
        checker color rgb <1, 0.5, 0.5> color rgb <1, .2, 0.2>
        scale <1/30, 1/30, 1/30>
      }
    }
    finish {
        specular .2   
        roughness 0.001
        phong 0.25
        phong_size 20
        brilliance 4
    }
    normal { bumps 0.4 scale 0.1 }
  }
 
 #declare cape = object {
        Cape
 }
 
 
 /*
 **                     Put stuff in the picture
 */
          
#if(dohead)
object {head
        scale 1.5
        rotate<20,160,0>
        translate <0,49,-34>}
#end

#if(dobody)
object {body
        scale .95
        translate<0,34,-30>
}
#end


object {cape
        translate <0,34,-30>
}

plane {<0,1,0> 0 
        pigment{checker rgb<.6,.5,.4>,rgb<.5,.4,.3> scale 6 rotate<0,35,0> }
        finish{diffuse .5}
}

plane {<0,1,0> 90.0 inverse
        pigment{White} finish{diffuse .5}
        finish{diffuse .5}
}

plane {<1,0,0>, 60 inverse pigment{image_map{png "wallpaper.png" }scale 5} finish{diffuse .5}}
plane {<-1,0,0>, 60 inverse pigment {image_map{png "wallpaper.png" }scale 5}finish{diffuse .5}}
plane {<0,0,-1>, 60 inverse pigment {image_map{png "wallpaper.png" }scale 5}finish{diffuse .5}}
plane {<0,0,1>, 60 inverse pigment {image_map{png "wallpaper.png" }scale 5}finish{diffuse .5}}

#if(fixtures)
        object{ fixture
        rotate<0,0,90>
        translate<20,50,-60>
        }

object{ fixture
        rotate<0,0,-90>
        translate<-20-5,50,-60>
        }
#end

object{ dresser
        translate <0,0,-57>
}

object {permkit
        rotate<0,180+60,0>
        translate<14,36,-40>
        }

object {bottle
        scale .5
        rotate<0,10,0>
        translate<5,39,-50>
        texture{Orange_Glass}
        interior{I_Glass}
        }

object {bottle
        scale .5
        rotate<0,-20,0>
        translate<0,39,-48>
        texture{Vicks_Bottle_Glass}
        interior{I_Glass}
        }

object {bottle
        scale .6
        rotate<0,-50,0>
        translate<8,39,-47>
        texture{Glass3}
        interior{I_Glass}
        }
 
 object {bottle
        scale <.5,1.5,.5>
        rotate<0,-20,0>
        translate<2,39,-45>
        texture{Green_Glass}
        interior{I_Glass}
        }
       