/*
**                      Fixture.inc
**                      ===========
**
** This file defines a light fixture
*/
#include "metals.inc"
#include "glass.inc"

#declare bulb = object{
       union{
       difference{
                union{
                        sphere{<0,0,3.5> 2.5}
                        cylinder{<0,0,0> <0,0,1> .8}
                }
                
                union{
                        sphere{<0,0,3.5> 2.4}
                        cylinder{<0,0,0> <0,0,2> .7}
                }
        texture{T_Glass2}
        interior{I_Glass}
        }
#if(fixtures_on)
                light_source{<0,0,3.5> color .2}
#end
        }
}


#declare fixture = object{
union{
        box{<-20+9,0,0> <20-9,5,1>
           texture{T_Brass_3C}
        }
        
        object{bulb
                translate<-9,2.5,1>
        }               
        object{bulb
                translate<0,2.5,1>
        }               
        object{bulb
                translate<9,2.5,1>
        }               
}
}


  