// cat.inc modified by Darwin Gregory
// Extracted from:
// Cassidy.inc  by Neil Alexander 1998  
//Cassidy the cat for House.inc

#declare Catbrown = color rgb < 0.4,0.35,0.3>;

#declare Eye = union {
  sphere {  
      <0, 0, 0>, 0.5
      texture {
        pigment { color rgbf 1 }
        finish { phong 1 phong_size 80 }
        }
      interior { ior 1.5 }
      }
  difference {
    intersection {
      sphere {
        <0, 0, 0>, 0.5
        }
      sphere {
        <0, 0, 0>, 0.5
        scale <1.5,1.5,0.75>
        texture {
          pigment { color rgb <0.5,0.65,0.35>}
          finish { ambient 0.2 }
          }
        }
      }
    cylinder {
      <0,0,0>, <0,0,1>,1
      scale<.1,.2,1>
      texture { pigment { color rgb 0 }}
      }
    }
  }  // end Eye



#declare CatHead = union {  // head
  blob {
    threshold 0.56  
    sphere { <0, 0, 0>, 1, 1 // main
      scale <3.75, 3, 3>
      }
    sphere { <0, 0, 0>, 1, -0.5  // right side
      scale 1.5
      translate <3,0,0>
      }
    sphere { <0, 0, 0>, 1, -0.5  // left side
      scale 1.5
      translate <-3,0,0>
      }
    sphere { <0, 0, 0>, 1, 1  // nape
      scale <2, 1.5, 1>
      rotate <15, 0, 0>
      translate <0, -0.5, -1>
      texture { pigment { color rgb 0 }}
      }
    sphere { <0, 0, 0>, 1, 1  // right cheek
      scale 0.6
      translate <0.25,-0.4,1.6>
      texture {
        pigment { color rgb 1 }
        }
      }
    sphere { <0, 0, 0>, 1, -0.25  // right cheek
      scale 1.5
      translate <1.5,-1.25,1.5>
      }
    sphere { <0, 0, 0>, 1, 1  // left cheek
      scale 0.6
      translate <-0.25,-0.4,1.6>
      texture {
        pigment { color rgb 1 }
        }
      }
    sphere { <0, 0, 0>, 1, -0.25  // left cheek
      scale 1.5
      translate <-1.5,-1.25,1.5>
      }
    cylinder { <0, -0.7, 0.8>, <0, -0.8, 1.6> 0.4, 1  // chin
      texture {
        pigment { color rgb 1 }
        }
      }
    cylinder { <0,0.375,1>,<0,-0.1,1.875>,.375,1  // nose
      texture {
        pigment { gradient z
          color_map {
            [  0.6  color rgb 1]
            [  0.7  color rgb <1,0.5,0.3>]
            } // color_map
          }
        rotate <30,0,0>
        }
      }
    cylinder { <-.7,0.65,.8>,<.7,0.65,.8>,.65,1}  // brow
    sphere { <0, 0, 0>, 0.65, -1  // left eye socket
      scale <1,0.9,1>
      translate <-0.65, 0.45 0.85>
      texture {
        pigment { color rgb 0 }
        }
      }
    sphere { <0, 0, 0>, 0.65, -1   // right eye socket
      scale <1,0.9,1>
      translate <0.65, 0.45, 0.85>
      texture {
        pigment { color rgb 0 }
        }
      }
    sphere { <0,0,0>,1,1  // right ear
      scale <.8,3.75,0.5>
      rotate <20,10,-35>
      translate<.9,.8,-.3>
      }
    sphere { <0,0,0>,0.77,-2  // right ear
      translate <0,-3.25,0>
      rotate <20,10,-35>
      translate<.9,.8,-.3>
      }
    sphere { <0,0,0>,1,1  // right ear
      scale .6
      translate<.9,.9,.3>
      }

     sphere { <0,0,0>,1,-1 // right ear hollow
       scale <.5,2.2,.5>
       rotate <28,20,-25>
       translate<1.1,.9,-.1>
       texture {
        pigment { color rgb 1 }
        }
       }

    sphere { <0,0,0>,1,1  // left ear
      scale <.8,3.75,0.5>
      rotate <20,-10,35>
      translate<-.9,.8,-.3>
      }
    sphere { <0,0,0>,0.77,-2  // left ear
      translate <0,-3.25,0>
      rotate <20,-10,35>
      translate<-.9,.8,-.3>
      }
    sphere { <0,0,0>,1,1  // left ear
      scale .6
      translate<-.9,.9,.3>
      }

     sphere { <0,0,0>,1,-1 // left ear hollow
       scale <.5,2.2,.5>
       rotate <28,-20,25>
       translate<-1.1,.9,-.1>
       texture {
        pigment { color rgb 1 }
        }
       }
    texture {
      pigment {
        radial
        color_map{
          [0 color rgb 0]
          [0.5 color Catbrown]
          [1 color rgb 0]
          }
        frequency 15
        turbulence 0.4
        rotate<80,0,0>
        warp {  // left ear
          black_hole <-1,1,.25>, 2.5
          strength 2
          inverse
          }
        warp {  // right ear
          black_hole <1,1,.25>, 2.5
          strength 2
          inverse
          }
        warp { // left eye
          black_hole <-.7,0,0.8>, 1
          strength 2
          inverse
          }
        warp {  // right eye
          black_hole <.7,0,0.8>, 1
          strength 2
          inverse
          }
        }
      }
    texture {
      pigment {
        radial
        color_map{
          [0.078 color rgb 1]
          [0.109 color rgbf 1]
          [0.891 color rgbf 1]
          [0.922 color rgb 1]
          }
        turbulence 0.2
        rotate<0,-90,0>
        rotate<65,0,0>
        }
      }
    texture {
      pigment {
        gradient z
        color_map {
          [0.078 color rgb 0]
          [0.156 color rgbf <0,0,0,1>]
          }
        turbulence 0.1
        scale 6
        rotate <20,0,0>
        translate <0,0,-2>
        }
      }
    texture {
      pigment {
        gradient y
        color_map {
          [0.125 color rgb 1]
          [0.156 color rgbf 1]
          }
        turbulence 0.2
        scale 6
        rotate <-15,0,0>
        translate <0,-1.75,0>
        }
      }
    }  // end blob

  object { Eye  // right
    rotate <0,0,0>
    translate <0.7,0.4,0.8>
    }
  object { Eye  // left
    rotate <0,0,0>
    translate <-0.7,0.4,0.8>
    }
  }  // end head
