// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions      

#declare Radios = on;
#declare arealight = on;
#declare fltr = on;

#include"hostextures.inc"

global_settings {
  assumed_gamma 2.5
//  max_trace_level 200

 #if (Radios)

   radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 100
      nearest_count 4
      error_bound 0.6 //0.6
      recursion_limit 1      
      low_error_factor 0.4
      gray_threshold 1.0
      minimum_reuse 0.015
      brightness .75
      adc_bailout 0.01/2 
      always_sample on
      normal on
   }
 #end
}

//cam sig

#declare Rat = image_width/image_height;
#include "screen.inc"

#declare locCam =  <0,1.5,-14>; 
#declare lookCam = <0,1.4,0>;
#declare aspCam = Rat;
#declare angleCam = 20;

Set_Camera(locCam, lookCam, angleCam)
Set_Camera_Aspect_Ratio(aspCam)

#declare Sig = text{
     ttf "arial.ttf" "Emkaah (c) 2005" .4, 0 no_shadow no_reflection
     pigment { rgb .6} finish{ambient 1 diffuse 0}
     scale .014
    }

Screen_Object (Sig, <1,0>, <0.02,0.02>, true, 0.02)

//--*


// perspective (default) camera
#declare cam1 = camera {
  location  <0.0, 1.5, -15.0>
  look_at   <0.0, 1.4,  0.0>
  right     x*image_width/image_height
  angle 20
}
#declare cam2 = camera {
  location  <0.0, 1.5, -14.0>
  look_at   <0.0, 1.4,  0.0>
  right     x*image_width/image_height
  angle 20.5
}
//normal perspective
#declare cam5 = camera {
  location  <0.0, 1.5, -9.0>
  look_at   <0.0, 1.35,  0.0>
  right     x*image_width/image_height
  angle 30
}
//3 quart
#declare cam3 = camera {
  location  <10.0, 10.5, -14.0>*2
  look_at   <0.0, 1.4,  0.0>
  right     x*image_width/image_height
//  angle 20.5
}
//top
#declare cam4 = camera {
  location  <0.0, 7.5, -0.0>*2
  look_at   <0.0, 1.4,  0.0>
  right     x*image_width/image_height
//  angle 20.5
}

//camera{cam2}

#if (fltr)
 box{<-500,-500,-12.95><500,500,-13> 
  texture{
    pigment{      
        spotted
        color_map {
          [0.0 color rgbf<1,1,1,1>]
          [0.5 color rgbf<1,1,1,1>]
//          [0.9 color rgbf<.9,.9,.7,.9>]
          [1.0 color rgbf<.9,.9,.7,.9>]
        }
    scale .00005
    turbulence 0 
    }
  }
 }
// pigment{rgbt <.9,.9,.7,.9>}}
#end
            
// create a regular point light source


#if (arealight=off)
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,.9>*.9    // light's color
  translate <0, 3, -20>
} 

#else

light_source {
  0*x                 // light's position (translated below)
  color rgb <1,1,.9>*.8       // light's color
  area_light
  <4, 0, 0> <0, 0, 4> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <0, 3, -20>   // <x y z> position of light
}

#end


 
// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane {
  y, -1 // distance from the origin in the direction of the surface normal
  hollow on // has an inside pigment?  
  pigment{rgb .3}  
  finish{specular 1.75 roughness 0.15 ambient 0 diffuse 1}
}  


#local cloudlayer=10;
#local cloudlite=0.45;
#local cloudcolor= <1, 1, 1,0>;
//first the basic definition
#macro m_cloud(cloudlayer, cloudlite)
   sphere { <0, 0, 0>, cloudlayer + 50000
      hollow on 
      pigment {
         bozo
         turbulence 1.1
         octaves 6
         omega 0.7
         lambda 2
         color_map {
            [0.0 0.1 color rgbt <1, 1, 1,0> color rgbt <1, .95, .95, .5>]
            [0.1 0.5 color rgbt <1, .95, .95, .5> color rgbt <1, 1, 1, .25>]
            [0.5 1.0 color rgbt <1, 1, 1, .25>      color rgbt <1, 1, 1, .1>]
         }
         scale 3000
      }
      finish { ambient cloudlite diffuse 0.0 reflection 0}
   }
#end

m_cloud(1000, 1.00)

m_cloud(2000, 0.20)
m_cloud(3000, 0.30)
m_cloud(4000, 0.40)
m_cloud(5000, 0.50)
m_cloud(6000, 0.60)
m_cloud(7000, 0.70)
m_cloud(8000, 0.80)
m_cloud(9000, 0.90)
/*
fog {
  fog_type   2
  distance   500
  color      rgb .5
  fog_offset .75
  fog_alt    3.75
  turbulence 0.5
}
*/


//voormuur
/*
union{
//box{<-1,0,0><1,4,.5> translate <-2,0,2>}

//box{<-1,0,0><1,1.5,.5> translate <-0,0,2>}
//box{<-1,0,0><.5,2.5,.5> translate <-0,1.5,2>}

//box{<-1,0,0><1,2,.5> translate <2,0,2>}
box{<-1,0,0><1,.5,.5> translate <2.5,2,2>}
box{<-1,0,0><1,1,.5> translate <3.5,2.5,2>} 
pigment{ brick rgb <.5,.5,.5>, <.55,.5,.5>*.5
   brick_size .2 mortar .01 scale<2,1,1>*.8
} finish{ambient 0 diffuse 1}
} 
*/
//achtermuur
union{
box{<-3,0,0><2,4,.5> translate <-2,0,4>}

//box{<-1,0,0><4,2.5,.5> translate <1,0,4>}
//box{<-1,0,0><1,.75,.5> translate <2.5,2.5,4>}

//------

box{<-3,0,0><-4,3.1,-30> translate <-2,0,4>}
box{<-3,0,0><-2,4,-25> translate < 7,0,2>}
box{<-3,0,0><7,2.5,.5> translate <0,0,-22>}
box{<-3,5,0><7,4,-25> translate < -2,0,-0>}
box{<-3,5,0><2,4,-15> translate < -2,0,4>}


pigment{Gray10} finish{ambient 0 diffuse 1}
}           



      
      
//door frame
#declare dframe = union{
 #declare FnSw =function{- f_superellipsoid (x*10,y/2,z*20,0.01,0.5) - f_wrinkles(x * 10, y * 10, z * 10) * 0.5}
  isosurface { function{FnSw(x,y,z) }
    contained_by { box {<-1,-2,-1>,<1,2,1>} } 
    max_gradient 24
    threshold 0
    scale<.6,1,1>
  }
 superellipsoid{<.25,.5> scale <.085,.08,.05> translate <-2.49,0.05,1.98>}
 texture{T_Wood3 scale .5 translate x*5} texture{TextureDoor2 scale .25} texture{TextureWall2 scale .1}
 normal{wrinkles scale<.1,.1,1>}
 finish{ambient 0 diffuse 1}
}           
object{dframe translate <-2.51,1.15,2.03> }
object{dframe scale<.8,1,1> rotate z*-90 translate<-4.58,3.1,2.032>}

//wall lining detail
#declare walldetail = object{
 isosurface { function{FnSw(x,y,z) }
    contained_by { box {<-1,0,-1>,<1,2,1>} } 
    max_gradient 20
    threshold 0
    scale<.7,1,1>
    
  }
 texture{TextureWall} texture{TextureWall2 scale .1}
}           
object{walldetail translate <2.7,1.5,2.05> }
object{walldetail scale<.8,1,1> rotate z*-90 translate<-4.57,3.15,2.0475>}

#include"hosWall.inc"

#include"hosbackwall.inc"
#include"hosdoor.inc"


 #declare Fnr = function { f_sphere(x,y,z,1)-f_noise3d(x*1, y*1, z*1)*1 }
 #declare ffr = isosurface { function{Fnr(x,y,z)+f_crackle(x*1, y*2, z*2.5)*1}
    contained_by { box {-1.5,1.5} } 
    max_gradient 15
    threshold 0
  } 

#declare tt = 0;
 #while (tt<500)
  #declare rndr1=rand(seed(tt*tt*2768));
  #declare rndr2=rand(seed(tt*tt*1590));
  #declare rndr3=rand(seed(tt*tt*9550));
  object{ffr  scale (rndr3*.025) rotate x*(360*rndr3) rotate y*(360*rndr2) texture{TextureWall scale (5*rndr3)}
       translate<rndr1*-2-.5,rndr3*.001,rndr2*4-2>
      }
 #declare tt=tt+1;
#end

#declare tt = 0;
 #while (tt<500)
  #declare rndr1=rand(seed(tt*tt*4967));
  #declare rndr2=rand(seed(tt*tt*1284));
  #declare rndr3=rand(seed(tt*tt*9855));
  object{ffr  scale (rndr3*.025) rotate x*(360*rndr3) rotate y*(360*rndr2) texture{TextureWall scale (5*rndr3)}
       translate<rndr1*3-1.5,rndr3*.001+.01,rndr2*1-.5> translate<0.25,.07,-1.2>
      }
 #declare tt=tt+1;
#end

#declare tt = 0;
 #while (tt<500)
  #declare rndr1=rand(seed(tt*tt*1565));
  #declare rndr2=rand(seed(tt*tt*5967));
  #declare rndr3=rand(seed(tt*tt*4892));
  object{ffr  scale (rndr3*.025) rotate x*(360*rndr3) rotate y*(360*rndr2) texture{TextureWall scale (5*rndr3)}
       translate<rndr1*3-1.5,rndr3*.001,rndr2*1-.5> translate<0.25,0,-1.5>
      }
 #declare tt=tt+1;
#end

//box{<-1.5,-1,-.5><1.5,.02,.5> translate<0.25,.07,-1.15> pigment{rgb 5}}

object{WDoorB scale <.9,1,1>*1.55 rotate y*-10 rotate x*15 rotate z*7 translate<-2.9,0,1.15>}
object{hosslab scale<1,1,.8>*.75 translate<0.25,.07,-1.15>}

object{BackWall scale<1,1.05,1> translate <1.7,3.5,4.1>}
object{backbuilding scale 7.5 translate<22,32,500>}//translate<2.75,5.5,50>}scale.8
object{backbuilding rotate y*180 scale 7.5 translate<22,32,575>}

object{RubbleM1 scale <1,2,2>*1 translate<3,0,.9>}
object{RubbleM2 scale <1,1,2>*1 translate<2.5,0,1>}
object{RubbleM3 scale <1,1,1>*.7 rotate y*90 translate<2.0,0,-1.5>}

object{RubbleM3 scale <1,1,1>*1 rotate y*0 translate<0.5,0,.1>}
object{RubbleM2 scale <1,.8,1>*.8 rotate y*90 translate<-0.8,-.1,-1.25>}
object{RubbleM2 scale <1.1,1.5,1>*1 rotate y*-90 translate<-3,0,-2>}

object{ceilingRubbleB scale .35 rotate z*5 rotate x*-30 translate<-.35,1.8,-4>}
object{ceilingRubble  no_shadow scale .5 rotate z*90 rotate x*-60 rotate z*10 translate<-1.2,2.6,-4>}

object{wallpiece1 scale .9 rotate x*25 rotate y*-45 rotate z*20 translate<2.1,.25,-1.75>}

object{WoodBlock1  scale <-1,1,-1>*.5   texture{T_Wood3c scale .5} texture{TextureWall2 scale 1.5}
          rotate x*-110 rotate y*-50 rotate z*5 translate<-1.5,.15,-1.75>}
object{WoodBlock1  scale <-1,1,-1>*.5   texture{T_Wood3c scale .5} texture{TextureWall2 scale 1.5}
          rotate x*-90 rotate y*70 rotate z*5 rotate x*-10 translate<1.05,.15,-2.25>}

object{rubbleIron scale .6 rotate z*-45 translate<-2,.25,-1.5>}
object{rubbleIron scale .7 rotate y*50 rotate z*-65 translate<-.0,.25,-2>}
object{rubbleIron scale .6 rotate y*80 rotate z*50 rotate y*45 translate<1.75,1,.5>}

object{ffpatch1 rotate z*130 rotate x*80 translate<-1.75,-.01,0.96> }
object{ffpatch1 scale 1 rotate z*80 rotate x*-20 translate<0.5,-.01,-.5> }

object{#include"paardastraw19a.pov" scale 1.1 translate y*(1.25*1.1) translate z*-1}
