/*
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions      
#include "hostextures.inc"

// perspective (default) camera
camera {
  location  <0.0, 0.0, -7.2>
  look_at   <0.0, 0.0,  0.0>
  right     x*image_width/image_height
}
                   
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 20, -20>
}  
// create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <20, -20, -20>
}  
*/

#include"hosBricks.pov"
#include"brickred.is2"

//*** front wall ***

#declare FWall=union{

//plint
object{  
#declare FnSpr =function{- f_superellipsoid (x/5,y*17.5,z*5,0.1,0.1) - f_noise3d(x * 10, y * 10, z * 10) * 0.25}
isosurface { function{FnSpr(x,y,z) }
    contained_by { box {<-2.5,-1,-1>,<3,1,1>} } 
    max_gradient 6
    threshold 0
  }
translate <0,.05,2.20>
texture{pigment{rgb<.8,1,.8>*.5} normal{bumps 0.5 scale .0005} finish{ambient 0 diffuse 1}} texture{TextureWall2 scale .5 translate z*-3}
} 

//bricks

object{ Make_StoneWall(12,7.20,1235,false,true,false) scale .1 translate <-2,.05,2.04>}
object{ Make_StoneWall(5,5.20,35,false,true,false) scale .1 translate <-2.15,.9,2.04>}
object{ Make_StoneWall(6,5.20,5,false,true,false) scale .1 translate <-0.62,.9,2.04>}
object{ Make_StoneWall(7,4.20,25,false,true,false) scale .1 translate <-0.62,.9+.13*4,2.04>}
object{ Make_StoneWall(7,5.20,23,false,true,false) scale .1 translate <-0.80,.86+.13*8,2.04>}
object{ Make_StoneWall(11,7.20,158,false,true,false) scale .1 translate <-1.7,.89+.13*14,2.04>}

object{ Make_StoneWall(11,1.20,185,false,true,false) scale .1 translate <-1.6,.89+.13*13,2.04>}
object{ Make_StoneWall(14,17,8235,false,true,false) scale .1 translate <1,.05,2.04>}

#declare wallrim = union{
 #declare T=0; #while (T<4) object{ Make_StoneWall( 1.8,1.02,T*T*45,false,true,false) scale .1 translate < .9-2.05-(T*.075),.9+.13*T,2.04>} #declare T=T+1; #end
 #declare T=0; #while (T<3) object{ Make_StoneWall( 1.8,1.05,T*T*98,false,true,false) scale .1 translate < .5-2.05-(T*.075),.9+.13*(T+4),2.04>} #declare T=T+1; #end
 #declare T=0; #while (T<4) object{ Make_StoneWall( 1.8,1.05,T*T*78,false,true,false) scale .1 translate < .1-2.05-(T*.075),.9+.13*(T+7),2.04>} #declare T=T+1; #end
 #declare T=0; #while (T<2) object{ Make_StoneWall( 1.8,1.05,T*T*11,false,true,false) scale .1 translate <-.3-2.05-(T*.075),.9+.13*(T+11),2.04>} #declare T=T+1; #end
}
object{wallrim translate y*-.025}
object{wallrim scale<.9,1,1> translate x*.18}

#declare wallrim2 = union{
 #declare T=0; #while (T<4) object{ Make_StoneWall( 1.8,1.02,T*T*89,false,true,false) scale .1 translate < .9+2.05+(T*.15),.9+.13*T,2.04>} #declare T=T+1; #end
 #declare T=0; #while (T<5) object{ Make_StoneWall( 1.8,1.05,T*T*55,false,true,false) scale .1 translate < 1.5+2.05+(T*.075),.9+.13*(T+4),2.04>} #declare T=T+1; #end
 #declare T=0; #while (T<4) object{ Make_StoneWall( 1.8,1.05,T*T*44,false,true,false) scale .1 translate < 1.7+2.05+(T*.075),.9+.13*(T+9),2.04>} #declare T=T+1; #end
}
object{wallrim2 translate y*1.065 translate x*-1.65 }
 
object{ Make_StoneWall(8,4,498,false,true,false) scale .1 translate <2,0.93+.13*8,2.04>}
object{ Make_StoneWall(6,4,48,false,true,false) scale .1 translate <2.25,0.93+.13*11,2.04>}
object{ Make_StoneWall(6,7,4498,false,true,false) scale .1 translate <2.6,0.88+.16*11,2.04>}

object{ Make_StoneWall(4,4.20,158,false,true,false) scale .1 translate <-2.7,.92+.13*17,2.04>}
} //--end FWall

//plaster
#declare Fn = function {f_hetero_mf(x,y,z,1.1, 2.05, 10, 0.0, .5,3)}
#local WD = .125;

#declare ffa =  isosurface { function{y-Fn(x*1.15,1,z)}
    contained_by { box {<-1.75,-(WD+.175),-3.25>,<2,-WD,1.6>} } 
    max_gradient 6
    threshold 0
  } 
#declare ffa2 =  isosurface { function{y-Fn(x*1.15,1,z)}
    contained_by { box {<-1.75,-(WD-.005),-3.25>,<2,-WD,1.6>} } 
    max_gradient 6
    threshold 0
  } 

#declare ffb =  isosurface { function{y-Fn(x*1.15,1,z)}
    contained_by { box {<2,-(WD+.175),-3.25>,<6,-WD,-1.0>} } 
    max_gradient 6
    threshold 0
  } 
#declare ffb2 =  isosurface { function{y-Fn(x*1.15,1,z)}
    contained_by { box {<2,-(WD-.005),-3.25>,<5,-WD,-1.0>} } 
    max_gradient 6
    threshold 0
  } 
#declare ffc =  isosurface { function{y-Fn(x*1.15,1,z)}
    contained_by { box {<3.75,-(WD+.175),-1.0>,<6,-WD,-0.25>} } 
    max_gradient 6
    threshold 0
  } 
#declare ffc2 =  isosurface { function{y-Fn(x*1.15,1,z)}
    contained_by { box {<3.75,-(WD-.005),-1.0>,<5,-WD,-0.25>} } 
    max_gradient 6
    threshold 0
  } 
#declare ffp1 =  isosurface { function{y-Fn(x*1.5,1,z)}
    contained_by { box {<-.5,-(WD+.100),-1>,<.5,-WD,-.1>} } 
    max_gradient 6
    threshold -.5
  } 
#declare ffp1_2 =  isosurface { function{y-Fn(x*1.5,1,z)}
    contained_by { box {<-.5,-(WD-.005),-1>,<.5,-WD,-.1>} } 
    max_gradient 6
    threshold -.5
  } 
#declare ffp2 =  isosurface { function{y-Fn(x*1.5+1.5,1,z-2)}
    contained_by { box {<-0,-(WD+.100),-1.2>,<1.5,-WD,0>} } 
    max_gradient 6
    threshold -.5
  } 
#declare ffp2_2 =  isosurface { function{y-Fn(x*1.5+1.5,1,z-2)}
    contained_by { box {<-0,-(WD-.005),-1.2>,<1.5,-WD,0>} } 
    max_gradient 6
    threshold -.5
  } 

#declare Plaster = union{
union{
 object{ffa texture{pigment{rgb .8} finish{ambient 0 diffuse 1}}}
 object{ffa2 texture{TextureWall translate z*-3} texture{TextureWall2 translate z*-3}}
         scale<1.05,.25,1.05>*.8  rotate x*-90   translate<-1.1,2.5,1.96> 
}

union{
 object{ffb texture{pigment{rgb .8} finish{ambient 0 diffuse 1}}}
 object{ffb2 texture{TextureWall translate z*-3} texture{TextureWall2 translate z*-3}}
         scale<1.05,.25,1.05>*.8  rotate x*-90   translate<-1.1,2.5,1.96> 
}
union{
 object{ffc texture{pigment{rgb .8} finish{ambient 0 diffuse 1}}}
 object{ffc2 texture{TextureWall translate z*-3} texture{TextureWall2 translate z*-3}}
         scale<1.05,.25,1.05>*.8  rotate x*-90   translate<-1.1,2.5,1.96> 
} 
} //--end Plaster

#declare ffpatch1 = union{
 object{ffp1 texture{pigment{rgb .8} finish{ambient 0 diffuse 1}}}
 object{ffp1_2 texture{TextureWall translate z*-3} texture{TextureWall2 translate z*-3}}
         scale<1.05,.25,1.05>*.8  rotate x*-90  rotate z*45 
}
#declare ffpatch2 = union{
 object{ffp2 texture{pigment{rgb .8} finish{ambient 0 diffuse 1}}}
 object{ffp2_2 texture{TextureWall translate z*-3} texture{TextureWall2 translate z*-3}}
         scale<1.05,.25,1.05>*.8  rotate x*-90  rotate z*45 
}


//**** 

//*** floor***

#declare Fnfl = function {f_hetero_mf(x,y,z,1.1, 2.05, 10, 0.1, 0,2)}
#declare WD = .25;

#declare fffla =  isosurface { function{y-Fnfl(x*1.15,1,z)}
    contained_by { box {<-4,-(WD+1.175),-4>,<4,-WD,4>} } 
    max_gradient 6
    threshold 0
  } 
#declare ffflb =  isosurface { function{y-Fnfl(x*1.15,1,z)}
    contained_by { box {<-4,-(WD+0.005),-4>,<4,-WD,4>} } 
    max_gradient 6
    threshold 0
  } 

#declare Floor = union{
  object{fffla texture{pigment{rgb .8} finish{ambient 0 diffuse 1}}}
  object{ffflb texture{TextureFloor translate z*-3} texture{TextureWall2 translate z*-3}}
         scale<1.05,.2,1.05>*.8  translate<0,0.04,1> 
 } 

object{FWall}
object{Plaster}
object{Floor}

object{ffpatch1 translate<.125,2.5,1.96> }
object{ffpatch1 rotate z*150 translate<2.4,2.6,1.96> }
object{ffpatch1 rotate z*130 translate<1.55,1.7,1.96> }
object{ffpatch2 translate<1.6,2.25,1.96> }

//****

#declare wallpiece1 = union{
 object{ Make_StoneWall(5,4.25,35,false,true,false) scale <1,1,2>*.1} //translate <-2,.05,2.04>}
 object{ Make_StoneWall(5,4.25,1235,false,true,false) scale <1,-1,2>*.1 translate <0,.4,.2>}
 object{ Make_StoneWall(4,4.25,8235,false,true,false) scale <1,1,2>*.1 translate <0,.05,.4>}
 
 object{ffpatch1 rotate z*100 scale <1.1,1,1>*1.15 translate<0,-.2,-.127> }
}

//object{wallpiece rotate x*30 rotate y*-45}