
#declare md=0.1;
#declare sd=0.06;

#macro vs(posn,height)
cylinder{posn,posn+y*height,md}
#end

#macro hs1(posa,posb,h)
cylinder{posa+h*y,posb+h*y,sd}
cylinder{posa+h*y,posb+h*y-y*2,sd }
#end
#macro hs2(posa,posb,h)
cylinder{posa+h*y,posb+h*y,sd}
cylinder{posa+h*y-y*2,posb+h*y,sd }
#end

#macro tower(ch,sh)
union
{
#declare b1=<1,0,1>*0.75;
#declare b2=<1,0,-1>*0.75;
#declare b3=<-1,0,-1>*0.75;
#declare b4=<-1,0,1>*0.75;

vs(b1,ch)
vs(b2,ch)
vs(b3,ch)
vs(b4,ch)
#local i=0;
#while(i<=ch)
hs1(b1,b2,i)
hs2(b2,b3,i)
hs1(b3,b4,i)
hs2(b4,b1,i)
#local i=i+2;
#end
cylinder{<0,ch+0.25,0> <0,ch+0.5,0> 0.75}
cylinder{<0,ch+0.5,0> <0,ch+sh,0> md}
}
#end

//tower(16)


#macro boom(len,sh,pos,rot,carry)
union
{
	cylinder{<-len/2,0,1>,<len,0,1> md }
	cylinder{<-len/2,0,-1>,<len,0,-1> md }
	cylinder{<1-len/2,1,0>,<len-1,1,0> md }
#local i=(-len/2)+1;
#while(i<=len)
	cylinder{<i,1,0>,<i-1,0,1> sd }
	cylinder{<i,1,0>,<i-1,0,-1> sd }
	cylinder{<i,1,0>,<i+1,0,1> sd }
	cylinder{<i,1,0>,<i+1,0,-1> sd }
	cylinder{<i+1,0,1>,<i+1,0,-1> sd }
	#local i=i+2;
#end
	cylinder{<-len/2,0,1>,<0,sh-0.5,0> sd}
	cylinder{<-len/2,0,-1>,<0,sh-0.5,0> sd}
	cylinder{<len-1,1,0>,<0,sh-0.5,0> sd}
	cylinder{<len/2-1,1,0>,<0,sh-0.5,0> sd}
#local mb=<-len/4,0,0>;
	box{<0,-1.75,-0.8> <0.5,-0.25,0.8> translate mb}
	box{<0,-1.75,-0.8> <0.5,-0.25,0.8> translate mb-<0.9,0,0>}
	box{<0,-1.75,-0.8> <0.5,-0.25,0.8> translate mb-<1.8,0,0>}
	box{<len*3/4,-0.5,-0.8> <len*3/4+0.5,-0.25,0.8> }
#if(carry=1)
#declare ct=len*3/4+0.25;
#declare cr=<ct,0,0>-<0,5,0>;
	cylinder {<ct,0,0> cr sd}
	sphere {cr md}
	cylinder {cr cr+<1.2,-1.5,0.6> sd}
	cylinder {cr cr+<1.2,-1.5,-0.6> sd}
	cylinder {cr cr+<-1.2,-1.5,0.6> sd}
	cylinder {cr cr+<-1.2,-1.5,-0.6> sd}

#local i=33;
#local jr=sqrt((30*30)-(i-30)*(i-30));
	object
	{
		sphere_part(i,5,32,jr,0,0)
		translate <0,-(i+1.5),1.5>
		translate <0,0,-jr>
		scale 1/1.5
		translate cr+<0,-1,0>
	}
#end
	translate <0,0.5,0>
	translate pos
	rotate rot
}
#end

#declare crane1=
union
{
	tower(28,8)
	boom(28,8,<0,28,0>,<0,57,0>,1)
	pigment {White}
}

#declare crane2a=
union
{
	tower(24,8)
	boom(24,8,<0,24,0>,<0,90,0>,0)
	pigment {White}
}


#declare box1=
box{<-2,0,-2>, <2,2.7,2>}

#declare box2=
box{<-2,2.3,-2>, <2,10.5,2>}

#declare box3=
box{<-2,10.5,-2>, <2,22,2>}
	
#declare box4=
box{<-3,22,-25> <3,35,5>}

#declare box5=
box{<-3,22,5> <3,35,15>}

#declare crane2=
union
{
object
{
	object{crane2a}
	bounded_by{box1}
	clipped_by{bounded_by}
}

object
{
	object{crane2a}
	bounded_by{box2}
	clipped_by{bounded_by}
	translate <0,-2.5,0>
	rotate <0,0,112>
	translate <0,2.4,0>
}


object
{
	object{crane2a}
	bounded_by{box3}
	clipped_by{bounded_by}
	translate <0,-3,0>
	rotate <0,0,87>
	translate <-0.6,-1.05,0>
}
object
{
	object{crane2a}
	bounded_by{box4}
	clipped_by{bounded_by}
	translate <0,-4,0>
	rotate <0,-2.5,80>
	translate <0,-2.75,0>
}
object
{
	object{crane2a}
	bounded_by{box5}
	clipped_by{bounded_by}
	translate <0,-4,0>
	rotate <0,-12.5,80>
	translate <0,-2,0>
}
}



#declare crane3a=
union
{
	tower(24,8)
	boom(16,8,<0,24,0>,<0,70,0>,0)
	pigment {White}
}


#declare box6=
box{<-2,0,-2>, <2,12.25,2>}

#declare box7=
box{<-7,11.3,-25> <7,35,15>}

#declare crane3=
union
{
object
{
	object{crane3a}
	bounded_by{box6}
	clipped_by{bounded_by}
	translate <0,0.8,0>
}

object
{
	object{crane3a}
	bounded_by{box7}
	clipped_by{bounded_by}
	rotate <0,30,0>
	translate <0,-12,0>
	rotate <0,0,-162>
	translate <0,13,0>
}
}
