#include "colors.inc"
#include "mgrass.inc"
#include "Tower.inc"
#include "functions.inc"

// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=10;               // size of patch
#declare nBlade=3;               // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;             // initial y rotation of blade
#declare segBlade= 15;            // number of blade segments
#declare lBlade = 50;             // length of blade
#declare wBlade = 1;              // width of blade at start
#declare wBladeEnd = 0.3;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,-0.5,0>;      // force bending the blade (<0,1,1> = 45)
#declare pwBend = 3;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;          // standard deviation of blade scale;
#declare stdBend = 2;             // standard deviation of blade bending;
#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = false;          // true creates a mesh file
#declare fname = "fgrass1.inc"    // name of the mesh file to create

// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=3;             // number of patches for the first line
#declare addPatches=3;            // number of patches to add at each line
#declare nzPrairie=5;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
#if (dofile=true) // if the patch is already created, turn off the next line
         MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        


#declare Green1=rgb<230,170,50>/355;
#declare Green2=rgb<110,160,8>/355;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
#declare txtGrass=texture {                  

                pigment {
                        bozo
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.3 pigGreen]
                                    [0.9 pigSpotted]
                                    [1.00 pigEarth]
                                }
                        }

        finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
        scale <0.001,1,0.001>
 
}  

                                           

#macro ring(L) 
union{   

 #declare N = 29 - (L-12)*1.1 ;
 #while (N<120)
  
  object{
    MakePrairie(lPatch,nxPrairie,addPatches,1,objectPatch,rd,stdscale,stdrotate,doTest)
    scale 0.025 
    #declare h = -(L/3-4)*.7*(1+cos(radians(N-25)));
    translate <0,h,-L>
    rotate -N*y
  }  
  #declare N = N + 5;
 #end 
 
 #declare N = 180 ;
 #while (N<352 + (L-12)*1.1)
  
  object{
    MakePrairie(lPatch,nxPrairie,addPatches,1,objectPatch,rd,stdscale,stdrotate,doTest)
    scale 0.025 
    #declare h = -(L/3-4)*.7*(1 + 0.6 * sin(radians(N-10)) );
    translate <0,h,-L>
    rotate -N*y
  }  
  #declare N = N + 5;
 #end  
 
 
}
#end

union{
  #declare M = 12;
  #while (M < 35) 
    object{ring(M)}
    #declare M = M + 0.5;
  #end
 texture{txtGrass} 
}

