#declare highDef = true;

#include "colors.inc"
#include "Tower.inc"   
#include "MySkies.inc"
        
#declare R = seed(0);

#declare blank1 = object{TowerBlanker(20, 5, 1.75,   1,  .3, 20, .2, 100)           rotate   3*x translate <3,11,-7>  rotate -7*y                           }
#declare blank2 = object{TowerBlanker(20, 5, 1.75,   1,  .3, 20, .1,  50) scale 0.5 rotate 180*y translate <5,20,-12>                                       }
#declare blank3 = object{TowerBlanker(20, 5, 1.75,   1,  .3, 20, .1,  50) scale 0.5 rotate 180*y rotate -10*x         translate <4,28,-12.5>                }
#declare blank4 = object{TowerBlanker(20, 5, 1.75,   1,  .3, 20, .1,  50) scale 0.5 rotate 190*y rotate -30*z         rotate -30*x     translate <-1,31,-7> }
#declare blank5 = object{TowerBlanker(20, 5, 1.75,   1,  .4, 10, .2,  50) scale 0.5 rotate  90*y translate <4,32,-17.5>                                       }
                                                        
#declare theTower = object{Tower(R)}

#declare FrontChunk =
intersection{
  object{theTower}     
  blank1 
  translate <0,  10,-4> 
  rotate -6*x       
  translate <0, -10, 6.6>
}


#declare Lump1 =    
  intersection{
     object{FrontChunk}
     blank3
     translate <0,-40, 10>  
     rotate -20*y
     rotate -60*x       
     translate <0, 13,-11>
     rotate -5*y 
     translate <3,2,3>
  }

#declare SplitFront1 =   
   difference{
     object{FrontChunk}     
     blank3   
   }

#declare Lump2 =    
  intersection{  
    intersection{
      object{SplitFront1}
      object{blank5}
    }
    object{blank5 translate <-5,5,0>}
    translate <0,-40, 10>  
    rotate  10*y
    rotate -20*x
    rotate -10*z       
    translate <2, 15.5,-7>  
    rotate -5*y 
  }

#declare SplitFront =   
   difference{
     object{SplitFront1}     
     blank5   
   }


#declare split1 =
difference{
  object{theTower}     
  blank1
}

#declare split2 = 
union{
  difference{
    object{split1}     
    blank2
  }
  intersection{
    object{split1}     
    blank2
    translate<-5,-20,0>
    rotate -8*z 
    translate< 4.5, 20,1>  
  }
} 

#declare SplitTower =
difference{
  object{split2}
  blank4
}

#declare B = 2.175; 

#declare lightningPig =
pigment{
   gradient x
   turbulence .5
   color_map{
                
     [0       rgbt<B,B,B,0>        ]  
     [0.002   rgbt<B*.65,B*.6,B,.8>]  
        
     [0.05    rgbt<1,1,1,1>        ]
     [0.95    rgbt<1,1,1,1>        ]
        
     [0.998   rgbt<B*.65,B*.6,B,.8>]
     [1       rgbt<B,B,B,0>        ]  
   }
   scale <100,100,300>
   scale .8
   scale y/100
}    

#declare clearPig = pigment{rgbt<0,0,0,1>}

#declare lightning =
box{<-10,-100,0> <17,200,.00001> 
   rotate 4*y
   
   texture{
     pigment{ 
      gradient y
      pigment_map{
         [0     clearPig    ]
         [0.625 clearPig    ]
         [0.675 lightningPig]
         [1     lightningPig]  
      }
      translate .05*y 
      scale 100*y
    }       
   }
   texture{
     pigment{ 
      gradient y
      pigment_map{
         [0    clearPig    ]
         [0.3  clearPig    ]
         [0.35 lightningPig]
         [1    lightningPig]  
      }
      translate .06*y 
      scale <1,50,1>
      rotate 80*z 
      translate<-14,-0,0>
    }       
   }
   rotate 180*y
   rotate 10*x  
   translate <15.45,-41.25,-22> 
   scale<1,1.3,1>
   no_shadow
}

#include "Mound.inc"

union{
  #include "Stones.inc"  
//  #include "FallenFigure1_pov.inc" object{FallenFigure1  scale 11  rotate 180*y rotate -20*x rotate -10*y translate <11.8,19.5,-12.3> }
//  #include "FallenFigure2_pov.inc" object{FallenFigure2  scale 11  rotate  20*y translate <9.5,24,-13.3>  } 
  object{SplitTower}
  object{SplitFront}
  object{Lump1} 
  object{Lump2}  

  object{lightning }
  
  rotate -10*y   
}


light_source {
       <90, 100, -200>         
       color rgb <1,1,1>*2.3
}  


light_source{
    <0,6,-50>
    color  <1,1,1>*.4
    shadowless
}


light_source{
   <0,68,-4>
   color <.8,.8,1>*10
}


cylinder{<0,0,0><0,42,0>6 }

sphere{<0,0,0>20
   hollow
   texture {
      pigment {rgbt <1,1,1,1>}
      finish {ambient 0 diffuse 0}
   }
   interior {
     media {
	emission 1
	density { spherical
	  color_map{
		[0.00 color  rgb<0,        0,     0>   ] 
		[0.85 color  rgb<0.65,     0.6,   1>*.1] 
		[0.88 color  rgb<0.65,     0.6,   1>*.5] 
		[1    color  rgb<0.2,      0.2, 0.2>   ] 
	  }
	turbulence .3 
	scale 13
	omega 0.9 
      }
    }
   } 
   translate<-2,55,0>
}

camera { 
   location <0, 6, -50> 
   look_at  < 0,25.5, 0> 
   angle 80                   
   
   right x
   up y
   angle 64                   
}

