#include "TowerText.inc"   
#include "Window.inc" 
#include "Door.inc"
#include "Shapes.inc"
 
#declare TowerRad        = 10;
#declare TowerHeight     = 44; 
#declare TowerInset      = 10;
#declare TowerWallThick  = 1.9;


#macro BattlementSupport(R)
  
  #declare w = 1;
  #declare rad = 1;
  #declare l = 1.7;
  #declare r = 0.25;
  
     
     difference{
        object{lumpyBox(w,l,l,r,.2,R) translate<0,-l/2,-l/2>}
        cylinder{<-100,0,0><100,0,0>rad translate<0,-l,-l>}
     }

  
#end 
  

 
#macro Battlement(R)

union{

  #declare H1 = 8;
  #declare H2 = 5;
  #declare Rad = TowerRad + 1.5;
  #declare d =  1;
  #declare r =  .25;
  #declare w =  5;
  
  #declare Angle = 0; 
  #declare inc = 20;
  #while (Angle < 360)
     object{lumpySill(Rad,w,H1,d,r,0.15,R) translate <0, TowerHeight + H1/2, -Rad> rotate Angle*y }
     #declare Angle = Angle + inc;
     object{lumpySill(Rad,w,H2,d,r,0.15,R) translate <0, TowerHeight + H2/2, -Rad> rotate Angle*y }
     #declare Angle = Angle + inc;
  #end

  #declare H  = 1.2;
  #declare Rad = TowerRad +0.05 ;
  #declare d =  4;
  #declare r =  .25;
  #declare w =  4;
  
  #declare Angle = 10; 
  #declare inc = 20;
  #while (Angle < 370)
     object{lumpySill(Rad,w,H,d,r,0.05,R) translate <0, TowerHeight -H/2 + 0.5, -Rad> rotate Angle*y texture{StoneTex}}
     #declare Angle = Angle + inc;
  #end

  
#if (highDef)   
  #declare Angle = 5; 
  #declare inc = 10;
  #while (Angle < 370)
      object{BattlementSupport(R) translate <0, TowerHeight -H/2 , -Rad+.5> rotate Angle*y texture{StoneTex}}
     #declare Angle = Angle + inc;
  #end
   
#end   
}

#end //Battlement 
 

#macro Tower(R)        

union{ 
  
  difference{ 
    union{

      cylinder{<0,0,0><0,TowerHeight,0>TowerRad} 
   
      difference{
         cylinder{<0,-1,0><0,TowerInset,0>TowerRad+TowerInset} 
         torus{TowerRad + TowerInset, TowerInset scale <1,2,1> translate TowerInset*y}
      }
          
    
    }
  
    union{
      cylinder{<0,-1,0><0,TowerHeight+1,0>TowerRad - TowerWallThick}
    
      object{WindowBlank  translate 18.5*y rotate -45*y}
      object{WindowBlank  translate 18.5*y rotate  45*y}
      object{WindowBlank  translate 32*y rotate  0*y} 
    
      object{DoorBlank }
    }
     
   } 

    
#if (highDef)   
    object{Window(R,  true)  translate 32*y rotate   0*y} 
    object{Window(R, false)  translate 18.5*y rotate -45*y}
    object{Window(R, false)  translate 18.5*y rotate  45*y}
    
    
    object{ leftDoorArch(60,DoorWidth,R) translate <0, 3, 0.1 > texture{StoneTex}}
    object{rightDoorArch(60,DoorWidth,R) translate <0, 3, 0.1 > texture{StoneTex}}  
    
  
    object{ lumpySegment(60, 1, 1.5, 1, .2, 2, R) translate<0,9.4,-TowerRad-0.125> texture{StoneTex}}
   
    object{ leftDoorPillar(R) translate <0, 0.1, 0.1 >}
    object{ rightDoorPillar(R)translate <0, 0.1, 0.1 > }   
#end    
    object{Door(R)}        
   
    //Do the steps 
    #declare Count = 0;
    #while  (Count < 4)     
       object{DoorSteps1(R)
           //   rotate -5*(Count)*y 
              translate<0, Count*-StepHeight, Count*-StepDepth>}
       object{DoorSteps2(R) 
            //  rotate -5*(Count+1)*y 
              translate<0, (Count+1)*-StepHeight, (Count+1)*-StepDepth>}
       #declare Count = Count + 2;
    #end
    
    //Do the left curbs
    #declare L = 1.25;
    #while (L < 10)
       #declare cw = 1+rand(R)/3;
       object{Curb(R, cw) translate (-DoorWidth/2-1)*x translate <0,.75-L/3,-L>}
       #declare L = L + cw + .2;
    #end
    
    //Do the rightt curbs
    #declare L = 1.25;
    #while (L < 10)
    
       #declare cw = 1+rand(R)/3;
       object{Curb(R, cw) translate (DoorWidth/2+1.5) *x translate <0,.75-L/3,-L>}
       #declare L = L + cw + .2;
    #end
    
    object{Battlement(R)}
    
    pigment{image_map{ png "stonemap.png" } scale 10} 
}

#end //Tower