///////////////////////////////////////
//
//  bot.inc
//  Copyright R.P. Stolk. augustus. 2004
//
// robot
//
///////////////////////////////////////  


#include "shapes.inc"
    
    
#declare lh =  x*-30;
#declare lk =  x*-lh;
#declare le =  x* 0;

#declare rh =  x* 0;
#declare rk =  x* 30;
#declare re =  x*-rk;

///////////////// 

#declare boven_been_ruw =
  difference{
   union{
     cone     {<0,5-8, 0>,8<0,-35,0>,6 }
     sphere   {<0,5-8, 0>,8 }
   }
  box   {< 10,-5,10>,< 2.5,5.1,-10> }
  box   {<-10,-5,10>,<-2.5,5.1,-10> }
}

#declare boven_been_l =
union{
  object{boven_been_ruw} 
  material {material_been}
}
#declare boven_been_r =
difference{
  object{boven_been_ruw} 
  cylinder {<25,-20,-20>,<15,-20,20>,17 }
  cone     {<0,-5.1,0>,7<0,-25,0>,5.5 }
  material {material_been}
}

///////////////// 

#declare knie =
union{
  sphere   {<0, 0, 0>,6.5 }
  material{material_knie}
}   

///////////////// 
   
#declare onder_been =
union{
  cone     {<0, 0, 0>,6<0,-40,0>,3 }
}   

#declare onder_been_l =
difference{
  object{onder_been } 
  cylinder {<-13,-20,-20>,<-23,-20,20>,17 }
  cone     {<0, 0, 0>,5.5<0,-40,0 >,2.5 }
  material{material_been}
}   
#declare onder_been_r =
union{
  object{onder_been } 
  material{material_been}
}   
    
///////////////// 
      
#declare voet =
  union{
    prism {    
//   linear_sweep
    linear_spline
    -10, // sweep the following shape from here ...
     -4, // ... up through here
    13// the number of points making up the shape ...
    <0,0>,<-3,5>,<-3,15>,<-6,15>,<-6,2.5>,<-3,-5>,<-3,-10>,<3,-10>,<3,-5>,<6,2.5>,<6,15>,<3,15>,<3,5>  
   }    
 } 
#declare enkel = 
union{
  box     {<2,-4,-2>,<-2,-1,4>   material {material_voet_2}}
  cylinder{<2,-4, 2>,<-2,-4,2>,6 material {material_voet_2}}     
}
  
#declare enkel_geknipt =
difference{
  object{enkel  }
  cylinder{<-4,-4,8.5>,<4, -4,8.5>,6 }
  box     {<-4,-4, -5>,<4, -4, 13>   }
  box     {<-4, 0, -5>,<4,  5, 13>   }
  box     {<-4,-4,2.5>,<4,-10,  7>   }
}
#declare enkel_af =
union{
  object{enkel_geknipt material {material_voet_2}}
  cylinder{<-3,0,0>,<3,0,0>,3 material {material_voet}}      
  sphere  {<0,0,0>,3 scale <0.3,1,1> translate < 3,0,0> material {material_voet}}
  sphere  {<0,0,0>,3 scale <0.3,1,1> translate <-3,0,0> material {material_voet}}
} 
  
#declare voet2 =
union{
  difference{
    object{ voet }
    box   {<-7,-4,6>,<7,4,-6> rotate x*-45 translate<0,-2,17>}
    box   {<-7,-4,7>,<7,4,-7> rotate x*45 translate<0,-1,-13>}
  }
  object{enkel_af}
  material {material_voet}
}
///////////////BEEN_L////////
#declare onder_been_voet_l =
union{
  object{voet2        rotate le translate <0,-40,0>} 
  object{onder_been_l translate <0,  0,0>}
  object{knie         translate <0,  0,0>}
}
#declare been_af_l =
union{
  object{onder_been_voet_l  rotate lk translate <0,-35,0>} 
  object{boven_been_l translate <0,0,0>} 
}
#declare been_l =
union{
  object{been_af_l rotate lh translate <10,-30,0> }
}

///////////////BEEN_R////////
#declare onder_been_voet_r =
union{
  object{voet2        rotate re translate <0,-40,0>} 
  object{onder_been_r translate <0,  0,0>}
  object{knie         translate <0,  0,0>}
}
#declare been_af_r =
union{
  object{onder_been_voet_r  rotate rk translate <0,-35,0>} 
  object{boven_been_r  translate <0,0,0>} 
}
#declare been_r =
union{
  object{been_af_r rotate rh translate <-10,-30,0> }

}
///////////////boven_lichaam////////
 
#declare borst =  
union{ 
  sphere {<0, 0, 0>,26 scale <0.85,0.75,0.5> translate <0, 5.5,0> material {material_borst}}  		
}
#declare schanier =  
union{
  cylinder {<1.5,-25,0>,<-1.5,-25,0>,8  material{material_buik}}
  sphere   {<0,0,0>,8 scale <0.3,1,1> translate <1.5,-25,0> material {material_buik}}  		
  
  cylinder {<1.5,-25,0>,<-1.5,-25,0>,7  translate<1,0,0> material{material_buik_2}}
  sphere   {<0,0,0>,7 scale <0.3,1,1> translate <1.5,-25,0> translate<1,0,0> material {material_buik_2}}  		


}

#declare buik =  
union{
  cone   {<0, 0, 0>,18  <0, 5,0>,16   translate <0,-25,0> scale <1,1,0.49> material {material_buik}}
  cone   {<0, 0, 0>,18  <0, 5,0>,16   translate <0,-21,0> scale <1,1,0.49> material {material_buik}}
  cone   {<0, 0, 0>,18.5<0, 5,0>,16.5 translate <0,-17,0> scale <1,1,0.49> material {material_buik}}
  cone   {<0, 0, 0>,19.5<0, 5,0>,17.5 translate <0,-13,0> scale <1,1,0.49> material {material_buik}}
  cone   {<0, 0, 0>,19  <0, 5,0>,17   translate <0, -9,0> scale <1,1,0.49> material {material_buik}}
  cone   {<0, 0, 0>,18  <0, 5,0>,16   translate <0, -6,0> scale <1,1,0.49> material {material_buik}}
  object{schanier translate< 14.5,0,0>}
  object{schanier rotate y*180 translate<  5.5,0,0>}
  object{schanier translate< 14.5,0,0> scale <-1,1,1>} 
  object{schanier rotate y*180 translate<  5.5,0,0> scale <-1,1,1>}
  
}  
  
#declare borst_geknipt =  
difference{
  object{borst}
//  cylinder {<-10,10,0>,<-10,10,28>,5 material{material_borst}} 
  prism {
    cubic_spline
    -10, // sweep the following shape from here ...
     10, // ... up through here
    9, // the number of points making up the shape ...
    <   2, -2.5>, // point#1 (control point... not on curve)
    <   4,    3>, // point#2  ... THIS POINT ...
    <   0,    0>, // point#3
    <  -4,    1>, // point#4 //
    <  -4,   -4>, // point#5 //
    <   3,   -7>, // point#6
    <   1,   -3>, // point#6
    <   4,    3>, // point#7 ... MUST MATCH THIS POINT
    <   2,  8.5>  // point#8 (control point... not on curve)
    rotate x*90 translate<-8,10,13> material{goud}
    }
  torus { 26, 2  rotate x*90 rotate y*90 scale <0.85,0.75,0.5> translate <0, 5.5,0> material {material_borst}}
}
 
#declare hoofd =
union{
  sphere { < 0,0,0>,7.5   scale <0.75,1,0.75>  } 
}
#declare nek =
union{
  cone     {<0, 0, 0>,5<0, 3,0>,4 translate <0,25,0> }
  cone     {<0, 0, 0>,5<0, 3,0>,4 translate <0,27,0> }
  cone     {<0, 0, 0>,5<0, 3,0>,4 translate <0,29,0> }
  cone     {<0, 0, 0>,5<0, 3,0>,4 translate <0,31,0> }
  cone     {<0, 0, 0>,5<0, 3,0>,4 translate <0,33,0> }
  cone     {<0, 0, 0>,5<0, 3,0>,4 translate <0,35,0> }
  cone     {<0, 0, 0>,5<0, 3,0>,4 translate <0,37,0> }
}
#declare hoofd_2 =
union{
  sphere { < 0,0,0>,8  scale <0.75,1,0.75>  } 
}
#declare hoofd_3 =
difference{
  object{ hoofd_2 }
  box   {<0,10,10>,<10,-10,-10> material{material_hoofd2}} 
  box   {<0,10,10>,<10,-10,-10> rotate z*-50 translate<0,0,0> material{material_hoofd2}}
  cylinder {< -2,3,-1>,<-2,3,8>,1.25 material{zilver}}
}
#declare boven_arm =
union{     
  sphere { < 0,0,0>,6   material {material_s} } 
  cone   { <0, 0, 0>,5<0,-25 ,0>,4  material {material_arm}  }
}
#declare onder_arm =
union{     
  sphere { < 0,0,0>,5   material {material_e} } 
  cone     {<0,0, 0>,4<0,-30,0>,2  material {material_arm}  }
}
#declare onder_arm_geknipt =
difference{
  object{onder_arm}
  cylinder {<-5,-15,-7>,<5,-15,-7>,6 material {material_arm}}
  cone     {<0,0, 0>,3.5<0,-30 ,0>,1.5   material {material_arm}}
}    
#declare boven_arm_2 =
difference{
  object{ boven_arm }
  cylinder {<-10,-12.5,20>,<10,-12.5,8>,10 }
  cone     {<0, -2, 0>,4.5<0,-23 ,0>,3.5    }
}
     

#declare kaak =
union{
 prism {    
//  linear_sweep
  linear_spline
  0, // sweep the following shape from here ...
  10, // ... up through here
  4, // the number of points making up the shape ...
  <-4,-5>, <4,-5>, <3,5>, <-3,5>
 }
}     
#declare kaak2 =
difference{
  object{kaak}
  prism {    
//    linear_sweep
    linear_spline
    1, // sweep the following shape from here ...
    11, // ... up through here
    4, // the number of points making up the shape ...
    <-3,-4>, <3,-4>, <2,4>, <-2,4>  material {material_kaak}
  }
} 
#declare kaak3 =
union{ 
  object{ kaak2 material {material_kaak}}
//onder  
  cone  {<-1,9,4>,1 <-1,9 ,-4>,0.1  material {goud}  }
  cone  {< 1,9,4>,1 < 1,9 ,-4>,0.1  material {goud}  }
//boven
  cone  {< 2,9,-4>,1 < 2,9 ,4>,0.1  material {goud}  }
  cone  {<-2,9,-4>,1 <-2,9 ,4>,0.1  material {goud}  }
  cone  {< 0,9,-4>,1 < 0,9 ,4>,0.1  material {goud}  }
}

#declare vinger =
union{
  prism {    
//    linear_sweep
    linear_spline
    -1, // sweep the following shape from here ...
     1, // ... up through here
    5, // the number of points making up the shape ...
    <-2,0>,<-2,5>,<4,10>,<0,4><2,0>  
  }      
}
#declare hand =
union{
  object{ vinger rotate y*-80 translate <0,0,0>material{material_vinger}}
  object{ vinger rotate z*180 translate <0,2,0>material{material_vinger2}}
  object{ vinger rotate z*180 translate <0,-2,0>material{material_vinger2}}
  cylinder {<0,4.25,0>,<0,-4.25,0>,1.5 material{material_vinger}}
  cylinder {<0,4.5 ,0>,<0,-4.5 ,0>,0.5 material{material_vinger2}}
}
#declare hand_dicht =
union{
  object{ vinger rotate y*-40 translate <0,0,0>material{material_vinger}}
  object{ vinger rotate z*180 translate <0,2,0>material{material_vinger2}}
  object{ vinger rotate z*180 translate <0,-2,0>material{material_vinger2}}
  cylinder {<0,4.25,0>,<0,-4.25,0>,1.5 material{material_vinger}}
  cylinder {<0,4.5 ,0>,<0,-4.5 ,0>,0.5 material{material_vinger2}}
}       

       
#declare bot =
union{      
  object{ been_l   translate<0,0,0> }
  object{ been_r   translate<0,0,0> }
  

  object{ borst_geknipt    }
  object{ buik    }
  object{ hoofd   scale 1.5625 translate <0,41.5,0> material {material_hoofd1}}
  object{ hoofd_3 scale 1.5625 translate <0,41.5,0> }
  object{ boven_arm_2  rotate z*50 translate < 17,20,0> material {material_been}}
  object{ boven_arm  rotate y*180 rotate x*-90 translate <-17,20,0> }
  object{ onder_arm  rotate z*-20 rotate x*-45 translate < 35,4,0> }
  object{ onder_arm_geknipt  rotate y*180 rotate x*-90 translate <-17,20,25> }  
  object{ nek translate <0,-6,0> material {material_nek}}
  object{ kaak3 rotate x*100 scale <1,0.85,1> translate <0,34.5,-1> }
  object{ hand  rotate x*90 rotate z*20 rotate y*45  translate<0,-30,0> rotate x*-90 translate<-17,20,25>}
  object{ hand_dicht rotate x*90  rotate z*50 translate<0,-30,0> rotate z*-20 rotate x*-45 translate<35,4,0>}
  hollow
 
}

  





/*//  Round_Box_Union(<  0,  0,  0>,<500,60,150>,5  ) //hoofd
#declare hoofd =
union{

  blob {
    threshold 0.5
    sphere { < 0,5,0>,15,1       } 
    cylinder {<-4,0,7>,<-2,-6.25,7>,1,1 }
    cylinder {< 4,0,7>,< 2,-6.25,7>,1,1 }
//    sphere { <-3,2,6>,2   ,1} 
//    finish { phong 1 }
  }
}
*/


