/////////////////////////////////////////////////////////////
//
//  bruggen.inc
//
//  Copyright R.P. Stolk. oktober 2004. <rpstolk@yahoo.com>
//
//  License: GNU GENERAL PUBLIC LICENSE Version 2, June 1991
//
//  PovComp 2004 entry nr: 409389
//
/////////////////////////////////////////////////////////////
/*
   torus {7.5, 0.25 rotate -90*x rotate 90*y rotate-45*z  translate<4,44,0> material{goud}}
   cylinder{< 0,41.5, 0>,< 4.5,46.2,7>,2.5 material{material_hoofd2}}
 sphere_sweep {
   b_spline                         
   7,                             // number of specified sphere positions
   <  0, 40, 0>, 0.5              // position, radius 
   < -3, 40, 8>, 0.5              // position, radius
   < -9, 35, 6>, 0.5              // position, radius
   < -5, 43, 6>, 0.5              // position, radius
   <-13, 40,10>, 0.5              // position, radius
   < -5, 50,-5>, 0.5              // position, radius
   <  0, 50,-5>, 0.5              // position, radius
   tolerance 0.1             // optional 
   material{goud}
 }
  sphere {<0, 0, 0>,27 scale <0.85,0.75,0.5> translate <0, 5.5,0> material {goud}}  
  box   {<30,7.5,30>,< 10,-28,-30> } 
*/  

// -------------------
  
#declare r_buiten = 40;
#declare r_binnen = 39.8;

#declare hoek = radians(-75);  // een paar spaken:  (radiaal gespaakt)

#declare frame =
union{
  #declare hoek = radians(-75);  // een paar spaken:  (radiaal gespaakt)
  #while(hoek < radians(75) )
    cylinder { < sin(hoek)*r_binnen, cos(hoek)*r_binnen, 0>,
               < sin(hoek)*r_buiten, cos(hoek)*r_buiten, 0>,
               0.0625   }
  #declare hoek = hoek + radians(360/240);
  #end 
}

// -------------------
   
#declare weg_dek =
difference{   
  cylinder{< 0,0,-0.5>,< 0,0,0.5>,40+0.0625 }
  cylinder{< 0,0,-0.6>,< 0,0,0.6>,40-0.0625 }

}   

// -------------------

#declare brug_dek =
union{
  torus {40, 0.0625 rotate 90*x translate<0,0,-0.5> }
  torus {40, 0.0625 rotate 90*x translate<0,0, 0.5> }
  torus {39.8, 0.0625 rotate 90*x translate<0,0,-0.5> }
  torus {39.8, 0.0625 rotate 90*x translate<0,0, 0.5> }
 
}

//union{
//  object{frame translate <0,0, 0.5>material{geel}}
//  object{frame translate <0,0,-0.5>material{geel}}
//  object{weg_dek  material{snoer_rood}}
//  object{brug_dek material{snoer_rood}}
  
//  scale 10
//  translate<50,-350,-8> material{snoer_rood}
//}
  
// -------------------

#declare toren_klein_ruw =
union{
  cylinder{< 0,0,-7>,< 0,20,-7>,0.5 }
  cylinder{< 0,0, 7>,< 0,20, 7>,0.5 }
  box   {<2,0,7>,<-2,20,-7> } 
//  cylinder{<2,20,0>,<-2,20,0>,7 }
//  torus {7, 0.5 rotate 90*x rotate 90*y translate<0,20,0> }

}
// -------------------

#declare toren_klein =
difference{
  object  {toren_klein_ruw }
  box     {<3, 2, 5>,<-3,13,-5>   } 
  cylinder{<3,13, 0>,<-3,13, 0>,5 }
  
}
// -------------------

#declare toren_groot =
union{
  object  {toren_klein translate<0, 0,0>}
  object  {toren_klein translate<0,20,0>}
  object  {toren_klein translate<0,40,0>}
  object  {toren_klein translate<0,60,0>}
  object  {toren_klein translate<0,80,0>}
  cylinder{<2,100,0>,<-2,100,0>,7 }
  torus {7, 0.5 rotate 90*x rotate 90*y translate<0,100,0> }
  
}
// -------------------

#declare toren_groot_af =
difference{
 object{toren_groot}
  cylinder{<3,93, 0>,<-3,93, 0>,5 }

}
// object{toren_groot_af translate<125,2,-8> material{snoer_rood}}
 
// -------------------
#declare draden =
union{
  cylinder{<125,100,-14.5>,<50,50,-12.5>,0.25 }
  cylinder{<125,100, -1.5>,<50,50, -3>,0.25 }

  cylinder{<125,100,-14.5>,<175,30,-12.5>,0.25 }
  cylinder{<125,100, -1.5>,<175,30,   -3>,0.25 }

  cylinder{<125,102,-14.5>,<-50,37.65,-12.5>,0.25 }
  cylinder{<125,102, -1.5>,<-50,37.65,   -3>,0.25 }

}


// object{draden  material{geel}}

// -------------------
// -------------------



union{
  object{frame translate <0,0, 0.5>material{zwart}}
  object{frame translate <0,0,-0.5>material{zwart}}
  object{weg_dek  material{zwart}}
  object{brug_dek material{grijs}}
  
  scale 10
  translate<50,-350,-215>
}
//  object{toren_groot_af translate<50,2,-208> material{snoer_rood}}

// -------------------


declare toren_klein_ruw_2 =
union{
  prism {
    linear_sweep
    linear_spline
    -11.5, // sweep the following shape from here ...
     11.5, // ... up through here
        6, // the number of points making up the shape ...
    <3,8>, <0,10>, <-3,8>, <-3,-8>,<0,-10>, <3,-8>
  }
}
// -------------------

declare toren_klein_2 =
difference{
 object{toren_klein_ruw_2}
  prism {
    linear_sweep
    linear_spline
    -5, // sweep the following shape from here ...
     5, // ... up through here
     5, // the number of points making up the shape ...
    <-9.5,5>, <5,4>, <9.5,0>, <5,-5>,<-9.5,-5>
    rotate z*90
   }
  }
 

// -------------------

declare toren_2 =
union{             
  object{toren_klein_2 translate <0,11.5   ,0>}            
  object{toren_klein_2 translate <0,11.5+23,0>}
  object{toren_klein_2 translate <0,11.5+46,0>}
  object{toren_klein_2 translate <0,11.5+69,0>}
  object{toren_klein_2 translate <0,11.5+92,0>}

  
}
 
// -------------------
 
declare toren_2_af =
union{             
 object{toren_2} 
 prism {       
    linear_sweep
    linear_spline
    -3, // sweep the following shape from here ...
     3, // ... up through here
     3, // the number of points making up the shape ...
    <5,0>,<-5,-8>,<-5,8>
    rotate z*90   translate<0,92+28,0>
   }
  }
 

object{toren_2_af  translate<50,2,-215> material{grijs} } 

// -------------------
// -------------------



declare toren_schuin =
union{             
  box{<2, -40,1>,<-2,40,-1>   } 
  rotate z*-45   
}

// -------------------

declare schuin_draden =
union{             
  cylinder{<    0,    0, 0>,<-28.25,18,0>,0.25 }
  cylinder{<28.25,27.25, 0>,<-28.25,38,0>,0.25 }
}

// -------------------

declare toren_schuin_af =
union{             
  object{schuin_draden material{grijs}}
  object{toren_schuin  material{zwart}}
}

  object{toren_schuin_af translate<28.25+50,28.25+50,-208>} 
  object{toren_schuin_af translate<28.25+50,28.25+50,-222>} 
  object{toren_schuin_af rotate y*180 translate<-28.25+50,28.25+50,-207.1>} 
  object{toren_schuin_af rotate y*180 translate<-28.25+50,28.25+50,-207.1>} 

  





 