// ================ //
// === Couleurs === //
// ================ //

#declare C_RougeManteau = <1.0,.30,.05,.25> ;
#declare C_JauneManteau = <1.0,.90,.05,.25> ;
#declare C_Surface = <.3, .3, .3, .00> ;
#declare C_Crevasse = <.00, .00, .00, .99> ;

#declare C_RougeSoleil = <1.0,.15,.02,.1> ;
#declare C_Lumiere = <1.0,.35,.05> ;
#declare C_JauneSoleil = <1.0,.90,.05,.1> ;

#declare C_EtoileBlanche = <1,1,1> ;
#declare C_EtoileBleue = <.8,.85,1> ;
#declare C_EtoileJaune = <1,1,.8> ;
#declare C_EtoileRouge = <1,.85,.8> ;


// ================ //
// === Textures === //
// ================ //

#declare T_Manteau = texture {
  pigment {
    bozo
    turbulence .2
    scale .02
    color_map {
      [.00, .18 color rgbf C_RougeManteau
                color rgbf C_RougeManteau]
      [.18, .28 color rgbf C_RougeManteau
                color rgbf C_JauneManteau]
      [.28, .32 color rgbf C_JauneManteau
                color rgbf C_JauneManteau]
      [.32, .42 color rgbf C_JauneManteau
                color rgbf C_RougeManteau]
      [.42, 1.0 color rgbf C_RougeManteau
                color rgbf C_RougeManteau]
      }
    }
  finish {
    ambient .6
    diffuse .01
    } 
  }

#declare T_Surface = texture 
 {pigment {
    crackle
    turbulence .5
    scale .8
    color_map {
      [.00, .026 color rgbt C_Crevasse
                color rgbt C_Crevasse]
      [.026, .99 color rgbt C_Surface
                color rgbt C_Surface]
      [.99, 1.0 color rgbt C_Crevasse
                color rgbt C_Crevasse]
      } 
    rotate -15*x
    }
  finish {
    ambient .22
    diffuse .05
    } 
  } 

#declare T_Soleil = texture 
 {pigment {
    crackle
    turbulence .5
    scale 30
    color_map {
      [.00, .05 color rgbf C_JauneSoleil
                color rgbf C_JauneSoleil]
      [.05, .15 color rgbf C_JauneSoleil
                color rgbf C_RougeSoleil]
      [.15, .94 color rgbf C_RougeSoleil
                color rgbf C_RougeSoleil]
      [.94, .99 color rgbf C_RougeSoleil
                color rgbf C_JauneSoleil]
      [.99, 1.0 color rgbf C_JauneSoleil
                color rgbf C_JauneSoleil]
      } 
    }
  finish {
    ambient .8
    diffuse .01
    } 
  } 
         
// ================ //
// === Normales === //
// ================ //

#declare N_Surface = normal 
 {agate .5 
  agate_turb 1.4
  scale .3
  
 }
      
// ============= //
// === Terre === //
// ============= //

#declare Terre = union 
 {sphere {<0,0,0> .98 texture {T_Manteau}}
  sphere 
   {<0,0,0> .99 
    texture {T_Surface} 
   }
  sphere {<0,0,0> 1. texture {T_Surface} normal {N_Surface}}
  light_source {
    <0,0,0>
    color rgb <280,280,280>
    fade_power 10 fade_distance 50 
    }
  }
  
#declare HaloTerre = sphere 
 {<0,0,0> 1
  hollow
  texture {
    pigment {rgbt <1,1,1,1>}
    finish {ambient 0 diffuse 0} }
  interior {
    media {
      scattering {4 rgb <1,1,1>*.2}
      confidence .7
      density {
        spherical
        density_map {
          [.00 color rgb 0.0 ]
          [.50 color rgb .1 ]
          [1.0 color rgb .2 ]
          } 
	}
      density {
        bozo
	scale .2
	turbulence 1
        density_map {
          [.00 color rgb 0.2 ]
          [1.0 color rgb 1]
          } 
	} 
      } 
    }
  scale 2.3
  }


// ============== //
// === Soleil === //
// ============== //

#declare Soleil = union
  {sphere
   {<-1000,0,0> 885
    texture {T_Soleil}
   }
  light_source 
    {<-1000,0,0> 
     color rgb <1,1,1>*50
     fade_power 2 fade_distance 1000
    }
  light_source 
    {<-1000,0,0> 
     color rgb C_Lumiere*15
     fade_power 2 fade_distance 1000
     area_light <0,1000,0> <0,0,1000> 5 5 jitter
     shadowless
    }
  }

#declare HaloSoleil = sphere 
   {<0,0,0> 1
    hollow
    texture {
      pigment {rgbt <1,1,1,1>}
      finish {ambient 0 diffuse 0} }
    interior {
      media {
	scattering {3 rgb <1,1,1>*.2}
	confidence .5
        density {
          spherical
          density_map {
            [.00 color rgb .00 ]
	    [.1 color rgb .05 ]
            [1.0 color rgb 1 ] 
            } 
          }
	density {
          bozo
	  scale .5
          turbulence 2
          density_map {
            [.00 color rgb .3 ]
            [1.0 color rgb 1 ] 
            } 
          } 
        } 
      } 
    scale 920 translate <-1000,0,0>
    }

// =============== //
// === Etoiles === //
// =============== //

#declare VoieLactee = sphere
 {<0,0,0> 1
  hollow
  pigment {color rgbt <1,1,1,1>}
  finish {ambient 0 diffuse 0}
  interior
   {media
     {emission <.95,.95,1>*1.2/10000
      density
       {spherical
	density_map
         {[.00 color rgb 0.0]
          [1.0 color rgb 1]
         }
	warp{turbulence 1}
       }
      density
       {bozo
        turbulence 2
	scale 1
	density_map
         {[.00 color rgb 0.0]
          [1.0 color rgb 1]
         }
       }
     }
   }


  translate <-.2,0,1.2>
  scale <8000,800,6000> 
  rotate 8*x
  rotate 12*z 
  }

#declare taille = 100000 ;

#macro Etoile(Couleur,Eclat,Distance,PX,PY)
  sphere 
   {<0,0,Distance*taille> taille/2500 
    pigment {color rgb Couleur} 
    finish {ambient Eclat diffuse 0}
    rotate PX*x rotate PY*y
    translate <taille*.03,0,0>
   } 
#end

#declare S= seed(0);
#declare Index = 0 ;

#declare PBc = .65 ;
#declare PBe = .10 ;
#declare PJa = .15 ;


#macro C_Alea(r)
  #if(r<PBc)
    C_EtoileBlanche
  #else
    #if (r<PBc+PBe)
      C_EtoileBleue
    #else
      #if (r<PBc+PBe+PJa)
        C_EtoileJaune
      #else
        C_EtoileRouge
      #end
    #end
  #end
#end


#declare N=5000 ;
#declare Etoiles = object
   {Etoile(
     (C_Alea(rand(S))),
     2*rand(S),
     (.4+rand(S)),
     90*(rand(S)-.5),
     60*(rand(S)-.5))
   }
#while(Index<N)
    #declare Etoiles = union
     {object{Etoiles}
      Etoile(
      (C_Alea(rand(S))),
      rand(S),
      (.4+rand(S)),
      90*(rand(S)-.5),
      60*(rand(S)-.5))
     }
    #declare Index = Index +1 ;
#end

// === bitoniau === //

#declare bitoniau = box
 {<20,20,20> <21,-20,-20>
  pigment {color rgb <1,1,1>}
  finish {ambient 20 diffuse 0}
 } 

    
// ============= //
// === Scne === //
// ============= //

// == Objets == //


object{Terre translate <-.5,1,0>}
object{HaloTerre translate <-.5,1,0>}
//object{bitoniau}
object{Soleil}
object{HaloSoleil}

object{VoieLactee}
object{Etoiles}

// == Paramtres == //

//global_settings {radiosity {count 100 normal on}}

background {<0,0,0>}

camera {location <-4,0,-10> look_at <-4,0,0>}
//camera {location <-4,0,0> look_at <-4,0,1>}


