// Ant_Splat.pov Copyright 2005 by M. R. Seavey - All Rights Reserved
//        Remember in PovRay X,Y,z=left-right,up-down,back-forward but camera location effects screen orientation !
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "glass.inc"
#include "woods.inc"
#declare ispov_not_inc=off;  // set to on for pov file
// #declare ispov_not_inc=on;  // set to off for inc file
#if (ispov_not_inc)
  camera { location  // uncomment only one line below 
  // <0, 0, -45>  angle 50 look_at  <18, 6, 0> } 
  <0,30,60 >  angle 25 look_at  <0, 5, 0> }
  // <0, 80, -40>  angle (10) look_at  <27, 20, 12> }
  // <0, 80, -40>  angle (20) look_at  <27, 20, 12> }
//
  background { color Gray70 }
//
  light_source { <2, 50, 10> color White  }
  //light_source { <20, 10, -20> color White  }
  light_source { <50, 0, 0> color White}
// Floor - remove if desired - but checkerboard helps size and orientation visualization
  plane { <0, 1, 0>, -.05 pigment { checker color Gray60, color Gray70 }  scale 12 }
#end
#declare hl=4;      // Ant Body rough overall length
// Define geometry
#declare aleg = sphere_sweep { b_spline 7 <0,0,0> 0.10                  // Ant Leg
                                          <0,0,0> 0.10 
                                          <0,-.3,.9*hl/5> 0.10
                                          <0,-1.3,1+.9*hl/5> 0.10
                                          <0,-2,1.3+.9*hl/5> 0.10
                                          <0,-2.5,1.5+.9*hl/5> 0.10
                                          <0,-2.5,1.5+.9*hl/5> 0.10  texture { pigment { color Black }  } }
#declare ajaw = object { aleg scale <.7,.5,.5> rotate <-90,90,0>  texture { pigment { color Black } } }                                         
//
#declare tanna = union { sphere { <1.1,-2.3,1.5+.9*hl/5,>, .2}
                         sphere_sweep { b_spline 7 <0,0,0> 0.06                  // Antanna
                                                   <0,0,0> 0.06 
                                                   <0.3,-.3,.9*hl/5> 0.06
                                                   <0.6,-1.3,1+.9*hl/5> 0.06
                                                   <0.9,-2,1.3+.9*hl/5> 0.06
                                                   <1.1,-2.3,1.5+.9*hl/5> 0.06
                                                   <1.1,-2.3,1.5+.9*hl/5> 0.06 } rotate <180,0,0>  texture { pigment { color Black } }  }
//
#declare ant = union { union {sphere { <-hl/3,0,0>, hl/4  scale <1.3,.9,.9> } // Ant Body made from 3 spheres
                              sphere { <0,0,0>, hl/4  scale <1.3,.9,.9> }     // center sphere
                              sphere { <.5+hl/3,0.5,0>, hl/4.5 }              // Final sphere for Ant Head
                       pigment  { agate agate_turb 0.3 color_map  { [ 1.0 rgbt <0,0,0,0> ]
                                                   [ 0.7 rgbt <1,0,0,.2> ]
                                                  [ 0.3 rgbt <1,0,0,0> ] } scale .3 } //{ color Black }  } // T_Chrome_3C } // Base coat
                       finish { brilliance 9 specular 0.99 roughness 0.01  reflection {.2 } phong 0.3 phong_size 60 }
                        } 
                      object { ajaw translate <hl/1.7,hl/8,hl/8> } 
                      object { ajaw rotate <180,0,0> translate <hl/1.7,hl/5,-hl/8> }
                      object { aleg translate <.5,0,0>}
                      object { aleg rotate <0,180,0> translate <.5,0,0>}
                      object { aleg translate <-hl/4,0,0>}
                      object { aleg rotate <0,181,0> translate <-hl/4,0,0> }
                      object { aleg translate <1.7*-hl/3,0,0>}
                      object { aleg rotate <0,179,0> translate <1.7*-hl/3,0,0> }
                      object { tanna  translate <hl/2.8,hl/4,hl/8> } // translate <.5,0,0>}
                      object { tanna rotate <0,179,0> translate <hl/2.1,hl/4,-hl/8>} // translate <0,0,-hl/4>}
               translate <0,2.5,0>
          //     texture { pigment { color Black }  }               // Paint it
               pigment { agate agate_turb 0.3 color_map  { [ 1.0 rgbt <0,0,0,0> ]
                                                           [ 0.7 rgbt <1,0,0,.2> ]
                                                           [ 0.3 rgbt <1,0,0,0> ] } scale .3 } 
               finish { brilliance 9 specular 0.99 roughness 0.01  reflection {.2 } phong 0.3 phong_size 60 } } // Shine it
//                           
// Make one . . .           
#if (ispov_not_inc)                             
object { ant }
object { ant rotate <90,0,0> translate <hl+5,0,0> }
object { ant rotate <0,90,0> translate <0,hl+5,0> }
object { ant rotate <-90,90,0> translate <hl+5,hl+5,0> }
object { ant rotate <0,0,90> translate <-hl-5,hl+4,0> }
//object { ant rotate <0,40,60> translate <7+hl/2,9+hl/2,0> }
#end               
