// Floor_Pump.pov Copyright 2005 by M. R. Seavey 
//        Remember in PovRay X,Y,z=left-right,up-down,back-forward but camera location effects screen orientation !
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "glass.inc"
#include "woods.inc"
#declare ispov_not_inc=off;  // set to on for pov file
// #declare ispov_not_inc=on;  // set to off for inc file
#if (ispov_not_inc)
  camera { location  // uncomment only one line below 
  // <0, 0, -45>  angle 50 look_at  <18, 6, 0> } 
  <0,50,80 >  angle 45 look_at  <0, 15, 0> }
  // <0, 80, -40>  angle (10) look_at  <27, 20, 12> }
  // <0, 80, -40>  angle (20) look_at  <27, 20, 12> }
//
  background { color Gray70 }
//
  light_source { <2, 50, 10> color White  }
  //light_source { <20, 10, -20> color White  }
  light_source { <50, 0, 0> color White}
// Floor - remove if desired - but checkerboard helps size and orientation visualization
  plane { <0, 1, 0>, -.05 pigment { checker color Gray60, color Gray70 }  scale 12 }
#end
#declare bsl=9;     // Pump base length in inches
#declare bsw=2.2;   // base width
#declare bst=.35;  // base thickness
#declare brh=26;    // Pump barrel ( main body ) height
#declare brr=.75; // Barrel radius
#declare sftr=.125; // Shaft radius
#declare stfex=1.2; // Shaft extension above barrel top cap as % of barrel height plus 100%
#declare hl=4;      // Rough Handle length

// Calcs
#declare bcc=bsl-2*bsw; //base cyl geo c-c
#declare bsr=bsw/2;     // base cyl geo radius
// Define geometry
#declare floorpump = union { union { cylinder { <-bcc/2,0,0>, <-bcc/2,bst,0>, bsr    }// round base end
                                          box { <-bcc/2,0,-bsw/2>, <bcc/2,bst,bsw/2> }// rectangular middle base
                                     cylinder { <bcc/2,0,0>, <bcc/2,bst,0>, bsr      }// complete a round ended rectangular bas
                                     cylinder { <0,0,0>, <0,brh-.25,0>, brr          }// Pump Barrel 
                             texture { pigment { color Blue }                          // Paint it 
                             finish { brilliance 9 specular 0.99 roughness 0.01  reflection .2 phong 0.3 phong_size 60 } } } // Shine the base, Baby!
                             union { cylinder { <0,brh-.26,0>, <0,brh,0>, brr }       // Pump Barrel Top end cap 
                                     cylinder { <0,brh-1,0>, <0,brh*stfex,0>, sftr }  // Pump Shaft
                             texture { T_Chrome_3C }  } // Clean metal shaft          // pigment  { color Silver_Metal }
                             union {sphere { <-hl/3,0,0>, hl/4 }               // Handle made from 3 spheres
                                    sphere { <0,0,0>, hl/4 }                   // center sphere
                                    sphere { <hl/3,0,0>, hl/4 }                // Final sphere
                                    scale <1.3,.8,.8> translate <0,brh*stfex,0>// oval-ize the handle and position result
                             texture { pigment { color Black }                 // Paint it 
                             finish { brilliance 9 specular 0.99 roughness 0.01  reflection {.2 } phong 0.3 phong_size 60 } } } // Shine the handle
                             sphere_sweep { b_spline 10 <0,bsw+.5,0> 0.25                  // hose curls around on floor
                                                   <0,bsw+.5,0> 0.25 
                                                   <0,bsw,2> 0.25
                                                   <-2,.25,4> 0.25
                                                   <-6,.15,8> 0.25 
                                                   <-8,0.0,10> 0.25 
                                                   <-8,0.0,12> 0.25
                                                   <-6,0,14> 0.25
                                                   <-3,0,7> 0.25 
                                                   <-3,0,7> 0.25 pigment { color Black } } // color hose black
                              cylinder { <-2.4,.125,7.8>, <-5.4,.125,7.8>, .4 pigment { color Black }   }  // Push on end cap for hose                    
                                                    } 
//                           
// Make one . . .           
#if (ispov_not_inc)                             
object { floorpump }
#end               
