//=========================================
// Main Declarations
//-----------------------------------------
//+W1024 +H512 +AM2 +A0.2 +R5
//+W640 +H320 +AM2
#include "colors.inc"
#declare radiosityrender=1;
#declare CamPos = <0,4,-90>;
#declare Look = <0,25,0>;
#declare Sun_Pos = <-400,500,500>*2;
#declare Sun_Col = <1,1,1>;
#declare SunBeam_Col = <1,.5,.3>;                                
#declare Grass = 
      texture {
         pigment {
            granite scale 15
            turbulence 3
            color_map {[0.5,rgbt <0.6,0.7,0.5,.5>][1.0,rgbt <0.6,0.7,0.5,0.1>]}
         }
      }
texture { 
    pigment {
        dents scale 20
        turbulence 1
        color_map {
            [0.0 rgbt <0.59, 0.81, 0.28, .7>]
            [0.4 rgbt <0.10, 0.73, 0.00, .6>]
            [0.5 rgbt <0.49, 0.61, 0.08, .7>]
            [0.6 rgbt <0.39, 0.41, 0.28, 01>]
            [1.0 rgbt <0.59, 0.81, 0.28, .7>]
        }
    }
}                                  

//-----------------------------------------
//=========================================
//-----------------------------------------


//=========================================
// Camera
//-----------------------------------------
camera {
	location CamPos
	up y right x*16/9//use 16:9 aspect ratio
	look_at Look
	angle 90
}


//-----------------------------------------
//=========================================
//-----------------------------------------


//=========================================
// Inclusion Of The Tree
//-----------------------------------------
#include "tree.inc"


//-----------------------------------------
//=========================================
//-----------------------------------------


//=========================================
// Ground & Sky
//-----------------------------------------
plane { y, 0 pigment {color LightWood } texture { Grass } }
#include "land.inc"

#include "sky.inc"
light_source{CamPos color White*1.4  shadowless}
//light_source{Sun_Pos color White*1  shadowless}
//light_source{<130,40,-200> color White*1.8}

object { HF_Object scale 20 texture { pigment { color LightWood } } texture { Grass }
        rotate x*3 scale y*1.8 rotate y*90 translate y*-20 translate <0,0,600> 
        scale <6,1,1> translate x*-700}
object { HF_Object scale 20 texture { pigment { color LightWood } } texture { Grass }
        rotate x*3 scale y*3 rotate y*90 translate y*-20 translate <0,0,1000> 
        scale <6,1,1> translate x*-700}       


//-----------------------------------------
//=========================================
//-----------------------------------------

#if (radiosityrender=1)
global_settings {
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.04
    count 35           
    nearest_count 5    
    error_bound 1.8    
    recursion_limit 3  
    low_error_factor .5
    gray_threshold 0.0 
    minimum_reuse 0.015
    brightness 1

    adc_bailout 0.01/2
  }
}

#end