// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Checkered Floor Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.1

#include "colors.inc"
#include "functions.inc"
#include "textures.inc"	// Standard Texture definitions
#include "SKIES.INC"   // Binding include-file for STONES1 and STONES2
#include "STONES1.INC"  // Great stone-textures created by Mike Miller
#include "STONES2.INC"  // More, done by Dan Farmer and Paul Novak
#include "METALS.INC"
#include "GLASS.INC"  
#include "mgrass.pov"

global_settings
{
  assumed_gamma 1.0 
  radiosity{}
  max_trace_level 25
}

sky_sphere { 
        pigment {rgb <0, 0, 0.1>} 
}

fog
{
  fog_type   2
  distance   20000 
  fog_offset 0
  fog_alt    1000
  color      rgb <0.,0 0.0, 0.0>
  turbulence 1.5
}


camera
{
  location  <0.0, 1.7, 0.0>
  direction z
  right     4/3*x
  look_at   <0.0, 2000,  7000>
}


light_source
{
  0*x
  color red 1.0  green 1.0  blue 1.8
  translate <-20000, 30000, 10000>
}

#declare S0=seed(0);
#declare Count=0;  
#declare Diameter=100;
#declare Distance=100000;
#while (Count < 500)
sphere { z*Distance,Diameter*(1 + rand(S0))/2
  no_shadow
  pigment { rgb <rand(S0), rand(S0), rand(S0)> }
  finish { ambient 1 diffuse 0 specular 0 phong 0 reflection 0 }
  rotate < -90*rand(S0),-45 + 90*rand(S0),0 >
  translate <0.0, 1.7, 0.0>
}
#declare Count=Count+1;
#end 

//#declare upper_cloudlet = sphere {<0,0,0> 1000 scale <1, 1/0.7, 1> pigment{color White}}
//#declare lower_cloudlet = sphere {<0,0,0> 1500 scale <1, 1/1.5, 1> pigment{color White}}
//#declare bottom_cloudlet = sphere {<0,0,0> 3000 scale <1, 1/6, 1> pigment{color White}}

#declare upper_cloudlet = isosurface {
  function { f_sphere(x, y*0.7, z, 1000) + 0.2*f_sphere(x*f_noise_generator(0.008*x, 0.008*y, 0.008*z, 3), y*f_noise_generator(0.01*x, 0.01*y, 0.01*z, 3), z*f_noise_generator(0.005*x, 0.005*y, 0.005*z, 3), 100)} 
  threshold 0  
  max_gradient 2
  contained_by{sphere{<0,0,0> 10000}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{scattering{1 color rgb<1,1,1> } absorption 0.0 density{color rgb 0.002}}}
  hollow
}
#declare lower_cloudlet = isosurface {
  function { f_sphere(x, y*1.5, z, 1500) + 0.2*f_sphere(x*f_noise_generator(0.008*x, 0.008*y, 0.008*z, 3), y*f_noise_generator(0.01*x, 0.01*y, 0.008*z, 3), z*f_noise_generator(0.005*x, 0.005*y, 0.005*z, 3), 100)} 
  threshold 0  
  max_gradient 2
  contained_by{sphere{<0,0,0> 10000}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{scattering{1 color rgb<1,1,1> } absorption 0.0 density{color rgb 0.002}}}
  hollow
}
#declare bottom_cloudlet = isosurface {
  function { f_sphere(x, y*6, z, 3000) + 0.1*f_sphere(x*f_noise_generator(0.008*x, 0.008*y, 0.008*z, 3), y*f_noise_generator(0.008*x, 0.008*y, 0.008*z, 3), z*f_noise_generator(0.005*x, 0.005*y, 0.005*z, 3), 100)} 
  threshold 0  
  max_gradient 4
  contained_by{sphere{<0,0,0> 10000}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{scattering{2 color rgb<1,1,1> } absorption 1.0 density{color rgb 0.002}}}
  hollow
}

#declare thunderstorm = union {
        object{bottom_cloudlet rotate y*90 translate <-3000, 550, 0>}
        object{bottom_cloudlet rotate y*300 translate <0, 550, 0>}
        object{bottom_cloudlet rotate y*180 translate <3000, 550, 0>}
        object{lower_cloudlet rotate y*90 translate <-1000, 1200, 0>}
        object{upper_cloudlet rotate y*90 translate <-2000, 2500, -300>}
        object{upper_cloudlet rotate y*270 translate <0, 2000, -100>}
        object{upper_cloudlet rotate y*200 translate <2500, 1500, 0>} 
        object{upper_cloudlet rotate y*100 translate <2000, 1600, -300>} 
        object{upper_cloudlet rotate y*270 translate <0, 3000, 100>}
        object{upper_cloudlet rotate y*30 translate <1200, 2300, -300>}
        object{upper_cloudlet rotate y*200 translate <2200, 3100, 200>} 
}


#declare lightning = union{
        difference {
                cylinder{<0, 0, 0> <0, 500, 0> 2000}
                cylinder{<0, -1, 0> <0, 501, 0> 1999}
                texture {
                        pigment{agate 
                                color_map {
                                        [0.0, 0.99   color rgbt <0, 0, 0, 1>
                                                color rgbt <0, 0, 0, 1>]
                                        [0.99, 0.9999   color rgbt <0, 0, 0, 1>
                                                color rgbt <0.5, 0.5, 0.2,0.8> ]
                                        [0.9999, 1   color rgb <5, 5, 2>
                                                color rgb <5, 5, 2> ]
                                }
                                scale 3800
                        }
                        finish { ambient 1 diffuse 0 specular 0 phong 0 reflection 0 }
                }
        }
        light_source{
                        0*x
                        color rgb <1, 1, 0.3>
                        fade_power 2
                        fade_distance 2000
                        translate <0, 200, 0>
        }
        
}


#declare Fgranite = function { 
    pigment { granite color_map { [0 rgb 1] [1 rgb 0] }}
} 
#declare isoground = isosurface {
  function{y - Fgranite(x,0,z).gray - 0.01*Fgranite(100*x, 0, 100*(z+0.1)).gray + 0.001* f_noise_generator(10000*x, 10000*y, 10000*z, 3)} 
  threshold 0  
  max_gradient 20
  texture{ 
        pigment{
                bozo
                color_map {
                        [0.0, 0.01   color rgb <0.3, 0.29, 0.28>
                                        color rgb <0.4, 0.39, 0.38>]
                        [0.01, 0.05   color rgb <0.2, 0.19, 0.18>
                                        color rgb <0.3, 0.29, 0.28> ]
                        [0.05, 1.0    color rgb <0.2, 0.19, 0.18>
                                        color rgb <0.3, 0.29, 0.28>]
                }
                scale 0.005
        
        } 
        normal {bumps 1 scale 0.0001}
  }
}
#declare isorock = isosurface {
  function{f_sphere(x, y*1.4, z, 10) + f_noise_generator(0.5*x, 0.5*y, 0.5*z, 3) + 0.1*f_noise_generator(2*x, 2*y, 2*z, 3) + 0.01*f_noise_generator(8*x, 8*y, 8*z, 3)} 
  threshold 0  
  max_gradient 50
  contained_by{sphere{<0,0,0> 100}}
  texture{ 
        pigment{
                bozo
                color_map {
                        [0.0, 0.01   color rgb <0.3, 0.29, 0.28>
                                        color rgb <0.4, 0.39, 0.38>]
                        [0.01, 0.05   color rgb <0.2, 0.19, 0.18>
                                        color rgb <0.3, 0.29, 0.28> ]
                        [0.05, 1.0    color rgb <0.2, 0.19, 0.18>
                                        color rgb <0.3, 0.29, 0.28>]
                }
                scale 0.005
        
        } 
        normal {bumps 1 scale 0.0001}
  }
}
#declare isoroad = isosurface {
  function{f_rounded_box(x,y,z, 0.1, 1, 1, 1) + 0.000005*f_noise_generator(400000*x, 400000*y, 400000*z, 3)} 
  threshold 0  
  max_gradient 5
  texture{ 
        pigment{
                bozo
                color_map {
                        [0.0, 0.01   color rgb <0.1, 0.1, 0.1>
                                        color rgb <0.2, 0.2, 0.2>]
                        [0.01, 0.05   color rgb <0.2, 0.2, 0.2>
                                        color rgb <0.2, 0.2, 0.2> ]
                        [0.05, 1.0    color rgb <0.2, 0.2, 0.2>
                                        color rgb <0.1, 0.1, 0.1>]
                }
                scale 0.000005
        
        } 
  }
}
#declare sidewalk = box {<-1000, -10, 0> <1000, 0, 10000>
  texture{ 
        pigment{
                bozo
                color_map {
                        [0.0, 0.01   color rgb <0.3, 0.3, 0.3>
                                        color rgb <0.4, 0.4, 0.4>]
                        [0.01, 0.05   color rgb <0.4, 0.4, 0.4>
                                        color rgb <0.3, 0.3, 0.3> ]
                        [0.05, 1.0    color rgb <0.3, 0.3, 0.3>
                                        color rgb <0.4, 0.4, 0.4>]
                }
                scale 0.05
        
        }
        normal {bumps 0.2 scale 0.01}
  } 
}
#declare isoline = isosurface {
  function{f_rounded_box(x,y,z, 0.1, 1, 1, 1) + 0.005*f_noise_generator(20*x, 20*y, 20*z, 3)} 
  threshold 0  
  max_gradient 5
  texture{ 
        pigment{color White        
        } 
  }
}
#declare lines = union{
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 0>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 6>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 12>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 18>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 24>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 30>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 36>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 42>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 48>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 54>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 60>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 66>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 72>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 78>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 84>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 90>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 96>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 102>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 108>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 114>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 120>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 126>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 132>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 138>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 144>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 150>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 156>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 162>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 168>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 174>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 180>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 186>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 192>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 198>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 204>}
        object{isoline scale <0.1, 1, 1.5> translate<0, -0, 210>}
}
#declare cornerstones = union {
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 0>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 6>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 12>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 18>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 24>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 30>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 36>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 42>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 48>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 54>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 60>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 66>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 72>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 78>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 84>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 90>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 96>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 102>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 108>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 114>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 120>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 126>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 132>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 138>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 144>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 150>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 156>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 162>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 168>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 174>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 180>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 186>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 192>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 198>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 204>}
        object{isoline scale <0.1, 1, 2.9> translate<0, -0, 210>}
}

//Grass made with Gilles Tran's MakeGrass
#declare Blanc1=rgb<0.90,0.81,0.81>;
#declare Green1=rgb<0.5,1,0.6>*0.4;
#declare Green2=rgb<60,160,100>/255;
#declare P_Spotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare P_Earth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare P_Green=pigment{Green2*1.3}
#declare T_Grass=texture {                  
    pigment {
        gradient y
        turbulence 0.2
        pigment_map {                                
            [0.0 P_Earth]
            [0.3 P_Green]
            [0.9 P_Spotted]
            [1.00 P_Earth]
        }
    }

    finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
    scale <0.001,1,0.001>
 
} 
#declare lPatch=100;               // size of patch
#declare nBlade=7;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 10;            // number of blade segments
#declare lBlade = 20;             // length of blade
#declare wBlade = 0.8;            // width of blade at start
#declare wBladeEnd = 0.3;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,1,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 4;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale
#declare stdBend = 3;            // standard deviation of blade bending
#declare dofold = false;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass2.inc"     // name of the mesh file to create
#declare nxPrairie=150;             // number of patches for the first line
#declare addPatches=0;            // number of patches to add at each line
#declare nzPrairie=500;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

#if (dofile=true) // if the patch is already created, turn off the next line
    MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
    #declare objectPatch=#include fname
#else        
    #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        

#declare oldgreypaint = texture{
        pigment{agate 
              color_map {
                      [0.0, 0.2   color rgb <0.3, 0.3, 0.3>
                                      color rgb <0.4, 0.4, 0.4>]
                      [0.2, 0.4   color rgb <0.3, 0.3, 0.3>
                                      color rgb <0.4, 0.4, 0.4>]
                      [0.4, 0.6   color rgb <0.3, 0.3, 0.3>
                                      color rgb <0.4, 0.4, 0.4>]
                      [0.6, 0.8   color rgb <0.3, 0.3, 0.3>
                                      color rgb <0.4, 0.4, 0.4>]
                      [0.8, 1.0   color rgb <0.4, 0.4, 0.4>
                                      color rgb <0.4, 0.4, 0.4>]
              }
              scale 0.2
        }
        finish{phong 0.5}
        normal{bumps 0.2 scale 0.01}
}
#declare oldsmokedpaint = texture{
        pigment{agate 
              color_map {
                      [0.0, 0.2   color rgb <0.3, 0.3, 0.3>*0.5
                                      color rgb <0.4, 0.4, 0.4>*0.5]
                      [0.2, 0.4   color rgb <0.3, 0.3, 0.3>*0.5
                                      color rgb <0.4, 0.4, 0.4>*0.5]
                      [0.4, 0.6   color rgb <0.3, 0.3, 0.3>*0.5
                                      color rgb <0.4, 0.4, 0.4>*0.5]
                      [0.6, 0.8   color rgb <0.3, 0.3, 0.3>*0.5
                                      color rgb <0.4, 0.4, 0.4>*0.5]
                      [0.8, 1.0   color rgb <0.4, 0.4, 0.4>*0.5
                                      color rgb <0.4, 0.4, 0.4>*0.5]
              }
              scale 0.2
        }
        finish{phong 0.5}
        normal{bumps 0.2 scale 0.01}
}
#declare lamprod = union{
        cylinder{<0, 0, 0> <0, 0.8, 0> 0.05}
        sphere{<0, -0.04, 0> 0.06}
        sphere{<0, 0.84, 0> 0.06}
        texture{oldgreypaint}
}
#declare smokedlamprod = union{
        cylinder{<0, 0, 0> <0, 0.8, 0> 0.05 texture{oldsmokedpaint}}
        sphere{<0, -0.04, 0> 0.06 texture{oldgreypaint}}
        sphere{<0, 0.84, 0> 0.06 texture{oldsmokedpaint}}        
}
#declare lamp = union{
        union{
                torus {0.3000, 0.05 translate <0, 0, 0>}
                torus {0.25, 0.05 translate <0, 0.05, 0>}
                torus {0.20, 0.05 translate <0, 0.10, 0>}
                torus {0.15, 0.05 translate <0, 0.15, 0>}
                torus {0.10, 0.05 translate <0, 0.20, 0>}
                cylinder{<0, 0.20, 0> <0, 5.5, 0> 0.1}
                torus {0.10, 0.05 translate <0, 5, 0>}
                difference{
                        cone{<0, 5, 0> 0.10 <0, 5.2, 0> 0.5}
                        cone{<0, 5.001, 0> 0.10 <0, 5.201, 0> 0.5}
                }
                difference{
                        cone{<0, 6.25, 0> 0 <0, 6, 0> 0.5}
                        cone{<0, 6.249, 0> 0 <0, 5.999, 0> 0.5}
                }
                texture{oldgreypaint}
        }
        object{lamprod translate <0.4, 5.2, 0> rotate y*0}
        object{lamprod translate <0.4, 5.2, 0> rotate y*90}
        object{lamprod translate <0.4, 5.2, 0> rotate y*180}
        object{lamprod translate <0.4, 5.2, 0> rotate y*270}
        difference{
                cylinder{<0, 5.2, 0> <0, 6, 0> 0.34}
                cylinder{<0, 5.2, 0> <0, 6, 0> 0.32}
                texture{T_Glass3}
        }
        light_source{
              0*x
              color rgb <5, 5, 1>
              translate <0, 5.6, 0>
              looks_like {cylinder{<0, -0.1, 0> <0, 0.1, 0> 0.15 texture{pigment {color rgbt<10,10,5,0.8>}}}}
              fade_power 2
              fade_distance 5
        }        
}
#declare isosmoke1 = isosurface {
  function { f_sphere(x, y, z, 1) - 1.3 * f_noise3d(x, y, z) - 1.3* f_noise3d(10*x, 10*y, 10*z)} 
  threshold 0  
  max_gradient 2
  contained_by{sphere{<0,0,0> 5}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{absorption 10 density{color rgb 0.2}}}
  hollow
}
#declare isosmoke2 = isosurface {
  function { f_sphere(x, y, z, 1) - 1.3 * f_noise3d(x, y, z) - 1.3* f_noise3d(10*x, 10*y, 10*z)} 
  threshold 0  
  max_gradient 2
  contained_by{sphere{<0,0,0> 5}}
  pigment { color rgbf<1, 1, 1, 1> }
  finish { ambient 0 diffuse 0 }
  interior{media{absorption 3 density{color rgb 0.2}}}
  hollow
}
#declare S1=seed(0);
#declare ShardDistance=2;
#declare ShardCount=0;  
#declare blownlamp1 = union{
        union{
                torus {0.3000, 0.05 translate <0, 0, 0>}
                torus {0.25, 0.05 translate <0, 0.05, 0>}
                torus {0.20, 0.05 translate <0, 0.10, 0>}
                torus {0.15, 0.05 translate <0, 0.15, 0>}
                torus {0.10, 0.05 translate <0, 0.20, 0>}
                cylinder{<0, 0.20, 0> <0, 5.5, 0> 0.1}
                torus {0.10, 0.05 translate <0, 5, 0>}
                difference{
                        cone{<0, 5, 0> 0.10 <0, 5.2, 0> 0.5}
                        cone{<0, 5.001, 0> 0.10 <0, 5.201, 0> 0.5}
                }
                difference{
                        cone{<0, 6.25, 0> 0 <0, 6, 0> 0.5}
                        cone{<0, 6.249, 0> 0 <0, 5.999, 0> 0.5}
                }
                texture{oldgreypaint}
        }
        object{lamprod translate <0.4, 5.2, 0> rotate y*0}
        object{lamprod translate <0.4, 5.2, 0> rotate y*90}
        object{lamprod translate <0.4, 5.2, 0> rotate y*180}
        object{lamprod translate <0.4, 5.2, 0> rotate y*270}
        #while (ShardCount < 2000)
        box { <-0.03, -0.02, -0.002> <0.03, 0.02, 0.002>
                texture{T_Glass3}
                rotate < 360*rand(S1),360*rand(S1),360*rand(S1) >
                translate <ShardDistance*rand(S1), 5 + rand(S1), 0.0>
                rotate <0,360*rand(S1),0>
        }
        #declare ShardCount=ShardCount+1;
        #end
        object{isosmoke1 scale <0.5, 0.3, 0.5> translate<0, 5.5, 0>} 
}
#declare ShardCount=0;  
#declare blownlamp2 = union{
        union{
                torus {0.3000, 0.05 translate <0, 0, 0>}
                torus {0.25, 0.05 translate <0, 0.05, 0>}
                torus {0.20, 0.05 translate <0, 0.10, 0>}
                torus {0.15, 0.05 translate <0, 0.15, 0>}
                torus {0.10, 0.05 translate <0, 0.20, 0>}
                cylinder{<0, 0.20, 0> <0, 5.5, 0> 0.1}
                torus {0.10, 0.05 translate <0, 5, 0>}
                difference{
                        cone{<0, 5, 0> 0.10 <0, 5.2, 0> 0.5}
                        cone{<0, 5.001, 0> 0.10 <0, 5.201, 0> 0.5}
                }
                texture{oldgreypaint}
        }
        union{
                difference{
                        cone{<0, 6.25, 0> 0 <0, 6, 0> 0.5}
                        cone{<0, 6.249, 0> 0 <0, 5.999, 0> 0.5}
                }
                texture{oldsmokedpaint}
        }
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*0}
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*90}
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*180}
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*270}
        object{isosmoke2 scale <0.3, 0.2, 0.3> translate<1, 5.5, 0>} 
}
#declare blownlamp3 = union{
        union{
                torus {0.3000, 0.05 translate <0, 0, 0>}
                torus {0.25, 0.05 translate <0, 0.05, 0>}
                torus {0.20, 0.05 translate <0, 0.10, 0>}
                torus {0.15, 0.05 translate <0, 0.15, 0>}
                torus {0.10, 0.05 translate <0, 0.20, 0>}
                cylinder{<0, 0.20, 0> <0, 5.5, 0> 0.1}
                torus {0.10, 0.05 translate <0, 5, 0>}
                difference{
                        cone{<0, 5, 0> 0.10 <0, 5.2, 0> 0.5}
                        cone{<0, 5.001, 0> 0.10 <0, 5.201, 0> 0.5}
                }
                texture{oldgreypaint}
        }
        union{
                difference{
                        cone{<0, 6.25, 0> 0 <0, 6, 0> 0.5}
                        cone{<0, 6.249, 0> 0 <0, 5.999, 0> 0.5}
                }
                texture{oldsmokedpaint}
        }
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*0}
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*90}
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*180}
        object{smokedlamprod translate <0.4, 5.2, 0> rotate y*270}
}

#declare roadarrows=height_field{ png "roadarrows.png" scale <18, 1, 18> 
          texture{ 
                pigment{color White}
                normal {bumps 0.2 scale 0.01}
          }       
}
object{thunderstorm rotate <0, 50, 0> translate <0, 0, 7000>}
object{lightning rotate y*30 translate <0, 0, 7000>}  
object{isoroad scale <10000, 10000, 10000> translate <0, -10000, 9000>}
object{lines translate <-3, -0.99, 13>}
object{sidewalk translate <1005.5, 0.1, 0>}
object{sidewalk translate <-1011.5, 0.1, 0>}
object{cornerstones translate <-11.5, -0.89, 3>}
object{cornerstones translate <5.5, -0.89, 3>}
object{roadarrows translate <-11, -0.995, 20>}

object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
    texture{T_Grass scale 40}
    scale 0.01
    translate <85, 0.1, 9>
}  
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
    texture{T_Grass scale 40}
    scale 0.01
    translate <-91, 0.1, 9>
}  

object{lamp rotate y*80 translate <6.5, 0, 15>}
object{blownlamp1 rotate y*80 translate <6.5, 0.1, 25>}
object{blownlamp2 rotate y*10 translate <6.5, 0.1, 35>}
object{blownlamp3 rotate y*110 translate <6.5, 0.1, 45>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 55>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 65>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 75>}
object{blownlamp3 rotate y*100 translate <6.5, 0.1, 85>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 95>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 105>}
object{blownlamp3 rotate y*100 translate <6.5, 0.1, 115>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 125>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 135>}
object{blownlamp3 rotate y*100 translate <6.5, 0.1, 145>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 155>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 165>}
object{blownlamp3 rotate y*100 translate <6.5, 0.1, 175>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 185>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 195>}
object{blownlamp3 rotate y*100 translate <6.5, 0.1, 205>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 215>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 225>}
object{blownlamp3 rotate y*100 translate <6.5, 0.1, 235>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 245>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 255>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 265>}
object{blownlamp3 rotate y*100 translate <6.5, 0.1, 275>}
object{blownlamp3 rotate y*300 translate <6.5, 0.1, 285>}
object{blownlamp3 rotate y*200 translate <6.5, 0.1, 295>}
object{blownlamp3 rotate <0, 0, 10> translate <6.5, 0.1, 305>}
object{blownlamp3 rotate <0, 0, -20> translate <6.5, 0.1, 315>}
object{blownlamp3 rotate <0, 0, 40> translate <6.5, 0.1, 325>}
object{blownlamp3 rotate <0, 0, 10> translate <6.5, 0.1, 335>}
object{blownlamp3 rotate <0, 0, 70> translate <6.5, 0.1, 345>}
#declare S3=seed(0);
#declare Count=0;  
#declare Diameter=100;
#declare Distance=355;
#while (Count < 500)
        object{blownlamp3 rotate <360*rand(S3), 360*rand(S3), rand(S3)> translate <6.5 + Count*(-0.5 + rand(S3)), Count*rand(S3), Distance + 10*(Count + rand(S3))>}
#declare Count=Count+1;
#end 
