#include "functions.inc"
#include "math.inc"
#include "Electron.pov"

// --------------------------------- //
// --- Paramtres de bourrinisme --- //
// --------------------------------- //

#declare halo = true ;
  #declare area = false ;
  #declare intervales = false ;
#declare alea = 300 ;
#declare elec = true ;

// ---------------- //
// --- Couleurs --- //
// ---------------- //

#declare C_Proton = <.92,.52,.39>;
#declare C_Neutron = <.39,.52,.92>;

#declare C_NRJ = <1,.6,.1> ;

// ------------------ //
// --- Particules --- //
// ------------------ //

#macro Particule(couleur) 
  sphere {0 1
  
    pigment {color rgb couleur}
    finish {ambient .1 diffuse .85 specular .05 roughness .1}
  }
#end

#declare Proton = Particule(C_Proton)

#declare Neutron = Particule(C_Neutron)

// ------------- //
// --- Noyau --- //
// ------------- //

#declare rds = seed(1);

#macro Placement()
  scale .2
  translate (1-pow(rand(rds),4))*y
  #declare the = rand(rds) ;
  #declare theta = acosd(1-2*the) ;
  rotate theta*z
  rotate (360*rand(rds))*y
#end
  
#declare Noyau = union {
  #declare p = 0 ;
  #while(p<92)
    object {
      Proton 
      Placement()
    }
    #declare p=p+1 ;
  #end
  
  #declare n = 0 ;
   #while(n<143)
    object {
      Neutron 
      Placement()
    }
    #declare n=n+1 ;
  #end
}

// -------------------- //
// --- Noyau clat --- //
// -------------------- //

 #macro PlacementE(d)
  scale .2
  translate (1-pow(rand(rds),3))*y
  #declare the = rand(rds) ;
  #declare theta = acosd(1-2*the) ;
  rotate theta*z
  rotate (360*rand(rds))*y
  #if(theta<=90) 
    translate d*y 
  #else 
    translate -d*y
  #end
#end
 
#declare dist = .25;
#declare NoyauE = union {
  #declare p = 0 ;
  #while(p<92)
    object {
      Proton 
      PlacementE(dist)
    }
    #declare p=p+1 ;
  #end
  
  #declare n = 0 ;
   #while(n<143)
    object {
      Neutron 
      PlacementE(dist)
    }
    #declare n=n+1 ;
  #end
}
   
// -- Halo -- //

#declare Halo = sphere {
  0 1
  
  pigment {color rgbt <1,1,1,1>}
  finish {ambient 0 diffuse 0}
  hollow
  interior {media {
    scattering {1 color rgb 1}
    #if(intervales) intervals 2 #end
    density {
      spherical
      density_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
    density {
      wrinkles
      scale .05
      density_map {
        [0 color rgb .15]
        [1 color rgb 1]
      }
    } 
  }}
  
  scale <5,2*dist,5>
}

// -- NE -- //

#macro NoyauEclate(h,Inte) 
  #if(h)
    union{ 
      light_group {
        light_source {
          <0,0,0> 
          color rgb C_NRJ*35*Inte
          fade_power 2 fade_distance 1.5
          #if(area)
            area_light x*.1 z*.1 5 5 jitter
          #end
        }
        object{Halo}
        sphere {
          0 1
          pigment {
            bumps
            scale .04
            color_map {
              [0 color rgbt <0,0,0,0>]
              [.2 color rgbt <0,0,0,0>]
              [1 color rgbt <1,1,1,1>]
            }
          }
          finish {ambient 0 diffuse 0}
          scale .02
        }
      global_lights off
    }
    object {NoyauE}
  }
  #else
    object{NoyauE}
  #end
#end

// --------------- //
// --- Traine --- //
// --------------- //


#macro Traine(L_Traine,Int)
merge {
  cylinder {<0,0,0> <0,.8,0> .2}
  sphere {0 .2 scale <1,1/L_Traine,1>}
  
  pigment {color rgbt <1,1,1,1>}
  finish  {ambient 0 diffuse 0}
  hollow
  interior {media {
    emission C_NRJ*25*Int
    
    // - cylindrique quadratique - //
    
    density {
      cylindrical
      density_map {
        [0 color rgbf <0,0,0,0>]
        [1 color rgbf <1,1,1,1>]
      }
    }
    density {
      cylindrical
      density_map {
        [0 color rgbf <0,0,0,0>]
        [1 color rgbf <1,1,1,1>]
      }
    }
    
    // - Motifs - //
    
    density {
      wrinkles
      scale <1,10/L_Traine,1>*.05
      density_map {
        [0 color rgbf <0,0,0,0>]
        [1 color rgbf <1,1,1,1>]
      }
    }
    
    // - Gradient quadratique - //
    
    density {
      gradient y
      density_map {
        [0 color rgbf <1,1,1,1>]
        [1 color rgbf <0,0,0,0>]
      }
    } 
    density {
      gradient y
      density_map {
        [0 color rgbf <1,1,1,1>]
        [1 color rgbf <0,0,0,0>]
      }
    }
  }}

  scale <1,L_Traine,1>
  rotate 90*z
}
#end


// ------------- //
// --- Scne --- //
// ------------- //

// -- Noyau au premier plan -- //

union{
    #if(halo)
      NoyauEclate(true,.8)
    #else
      NoyauEclate(false,.8)
    #end

    #if(elec)
      NuagE(92,1)
    #end
      
    object{
      Traine(15,.85)
      translate <-1,-3*dist,3*dist>
    }
        
  object{
    Traine(6.5,.85)
    translate 10*x
    rotate 72*y
  }
  
  object{
    Traine(18,.85)
    translate 23*x
    rotate -40*y
  }

  rotate -40*x
  translate 3.5*x
}

// -- Noyaux alatoires -- //

#declare profondeur = 200 ;
#declare rds2 = seed(4) ;


#macro Noyau_A(position) 
  #if(rand(rds2)<.15)
    #declare eclate = true ;
  #else
    #declare eclate = false ;
  #end 
    
  #if(eclate) union{
    
    #if(halo)
      NoyauEclate(true,1) 
    #else
      NoyauEclate(false,1)
    #end
    
    Traine(8+10*rand(rds2),1)
    
    #if(rand(rds2)<.6)
      object{
        #declare long = 5+10*rand(rds2);
        Traine(long,1)
        translate (long+4+15*pow(rand(rds2),4))*x
        rotate (90-180*rand(rds2))*y
      }
      object{
        #declare long = 5+10*rand(rds2) ;
        Traine(long,1)
        translate (long+4+15*pow(rand(rds2),4))*x
        rotate (90-180*rand(rds2))*y
      }
    #end
    
    #if(rand(rds2)<.6)
      object{
        #declare long = 5+10*rand(rds2) ;
        Traine(long,1)
        translate (long+4+15*pow(rand(rds2),4))*x
        rotate (90-180*rand(rds2))*y
      }
    #end
     
    #if(elec)
      object{NuagE(92,.75)}
    #end
   
    #declare the2 = rand(rds2) ;
    #declare theta2 = acosd(1-2*the2) ;
    rotate theta2*z
    rotate (360*rand(rds2))*y
    
    translate position
    }
  #else
    #if(elec) 
      union {
        object{Noyau}
        NuagE(92,.75)
        translate position
      }
    #else
      object{Noyau translate position}
    #end
  #end
#end


#declare j = 0 ;
#while(j<alea) 
  #declare prof = (.4+.6*rand(rds2))*profondeur;    
  Noyau_A(<(.5-rand(rds2))*prof*1.6,(.5-rand(rds2))*prof*1.2,prof>)
  #declare j=j+1 ;    
#end

// -- Paramtres de vue -- //  
  
camera {location <0,0,-28> look_at 0}
fog{
  distance profondeur
  color rgbft <0,0,0,.04,.5>
}
sky_sphere {pigment {
  gradient y
  color_map {
    [0 color rgb <.08,.18,.33>]
    [1 color rgb <.03,.08,.15>]
   }
  rotate 35*x
  rotate -20*z
}}
light_source {<2,1,-50> color rgb 1.5 shadowless}  

global_settings {
  max_trace_level 256
}