// THE SNOWFLAKE MELTING ON THE WARM WIND
// by GENA OBUKHOV
// May 2005

global_settings {
	max_trace_level 30
	photons {
		spacing 0.05
		autostop 0
		jitter 0
	}
}

camera {
	location <0, -0.2, -3>
	look_at <0, -0.2, 0>     
  
	normal{wrinkles 0.2 turbulence 0.2}
}

// left red
light_source {
	<-10, 10, -18>
	color rgb <6, 1, 0>
	fade_power 2
	fade_distance 45
    
	photons {
		reflection on
		refraction on
	}   
}

// front blue
light_source {
	<2, 1, -8>
	color rgb <0, 0.3, 0.7>*3
	fade_power 2
	fade_distance 45
    
	photons {
		reflection on
		refraction on
	}     
}

// left pink
light_source {
	<-13, 0, 2>
	color rgb <3, 2, 5>
	spotlight
	point_at 0
	tightness 20
	radius 11
	falloff 35
	
	fade_power 2
	fade_distance 45
    
	photons {
		reflection on
		refraction on
	}
}

// right pink
light_source {
	<8, 0, 2.5>
	color rgb <4, 2, 6>
	spotlight
	point_at 0
	tightness 20
	radius 11
	falloff 35
	
	fade_power 2
	fade_distance 45
    
	photons {
		reflection on
		refraction on
	}
} 
  
// back blue
light_source {
	<0, 2, 2.5>
	color rgb <2, 3, 5>*2
	spotlight
	point_at 0
	tightness 20
	radius 11
	falloff 35
	
	fade_power 2
	fade_distance 45
    
	photons {
		reflection on
		refraction on
	}
}
  
// top white
light_source {
	<2, 10, 2.5>
	color rgb 3
	spotlight
	point_at 0
	tightness 20
	radius 11
	falloff 35
	
	fade_power 2
	fade_distance 45
    
	photons {
		reflection on
		refraction on
	}
}

// right pink
light_source {
	<10, 0, -12>
	color rgb<5, 3, 7>*0.1
	spotlight
	point_at 0
	tightness 20
	radius 11
	falloff 35
	
	fade_power 2
	fade_distance 45
    
	photons {
		reflection on
		refraction on
	}
} 

#declare sbr = 0.4;

sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 0.4 color rgb 1*sbr color rgb 1*sbr]
			[0.4 1 color rgb 1*sbr color rgb <0.5, 0.2, 0.6>*sbr]
		}
	}
}    
  
#declare Half = height_field {
	tga "sf.tga"
	water_level 0.2
	smooth
    
	translate -y*0.2
	translate <-0.5, 0, -0.5>
	scale<4/3, 1, 1>
	scale <0.3, 0.01, 0.3>
	scale 7
	
	no_shadow
}             
  
#declare Whole = union {
	object{Half}	
	object{Half scale<1, -1, 1>}
	
	material {
		texture {
			pigment {color rgbft<1, 1, 1, 0, 1>}
			finish {
				specular 0.6
				roughness 0.002
				ambient 0
				diffuse 0.05
				brilliance 5
				reflection {
					0, 1.0
					fresnel on
				}
				conserve_energy
			}
			normal {
				wrinkles 0.6
				scale 0.1
			}
		}
		interior {
			ior 3
			fade_distance 2
			fade_power 2
			fade_color color rgb <0.3, 0.8, 1>
		} 
		
	}
	photons {
		target
		reflection on
		refraction on
		collect off
	}
} 

object{Whole scale<1, 0.5, 1> translate y*0.02 rotate -x*90 rotate z*5 translate -z*0.2}

#local brtns = 2.5;
                   
union {            
	cylinder {
		<0, 0, -0.0001>, <0, 0, 1>, 1    
		pigment {
			onion
			color_map {
				[0 0.2 color rgb<0, 0.05, 0.1>*brtns color rgb<0, 0.05, 0.1>*brtns]
				[0.2 1 color rgb<0, 0.05, 0.1>*brtns color rgb 0]
			}
		}
		finish{reflection 0}
		
		scale <2.8, 1.7, 1>
		scale 3
		
		no_shadow
	}
       
	plane{-z, 0 translate z*3 pigment {color rgb 0} finish{reflection 0}}
	
	translate z*3      
}


