/************************************************************\
  _______________________________________________
 /                                               \
 | Asymmetrical Scaling Macro                    |
 |                                               |
 | version 1.0   Copyright  Julius Klatte 1999  |
 | POV-Ray 3.1   Bug reports or comments:        |
 |               http://surf.to/JKhome           |
 |               klatte@hotmail.com              |                                     
 \_______________________________________________/
                                                              
Include this file in the scene to make use of the macro.
(#include "asm.inc")

The Asymmetrical Scaling Macro (ASM) can be used to scale
different parts of objects separate ways. For example, this 
makes it easier to create egg forms by scaling a sphere.

Usage: asm(Object,x_neg,x_pos,y_neg,y_pos,z_neg,z_pos)
       (7 macro parameters)

Object: the name of the pre-defined object that will be scaled.
x_neg: scales the part of the object left of the origin in x-direction.
x_pos: scales the part of the object right of the origin in x-direction.
y_neg: scales the part of the object below the origin in y-direction.
y_pos: scales the part of the object above the origin in y-direction.
z_neg: scales the part of the object in front of the origin in z-direction.
z_pos: scales the part of the object behind the origin in z-direction.

The macro call can be placed inside an object statement to add textures etc. 
Three examples:

#declare MyObject = sphere { <1,1,0> , 2 }

1) asm(MyObject,1,2,3,4,5,6} // no texture now, but this could have been added 
                             // to the MyObject definition.

2) object { asm(MyObject,1,3,4,2,1,1) texture {...} }

3) union { object { asm(MyObject,2,3,4,1,2,1) }
           object { asm(MyObject,1,2,2,1,3,1) translate <1,2,3> }
           texture {...}
         }

NOTE: As a default, the ASM uses the 'union' CSG operation to combine 
      the parts of the new object. If you are using transparent objects, 
      this sometimes leads to an unsatisfying result. If you type 
      " #declare Merge=1; " before invoking the macro, the 'merge' CSG 
      operation is used instead. 
      To change the default setting, change the indicated value below.
      
\************************************************************/

#macro asm(Object,x1,x2,y1,y2,z1,z2)

#ifndef (Merge) 
#local Merge=0; // Change this number to 1 for default object merging.
#end

#if (Merge!=0 & Merge!=1) #local Merge=0; #end
#if (Merge=0) #debug "\n   Asm uses object union.\n" #end
#if (Merge=1) #debug "\n   Asm uses object merging.\n" #end

 #local Xp1=object { Object clipped_by { plane { x, 0 } } scale <x1,1,1> }
 #local Xp2=object { Object clipped_by { plane { x, 0 scale -1 } } scale <x2,1,1> }
 #if (Merge=0) #local Xpart=union { object { Xp1 } object { Xp2 } } #end
 #if (Merge=1) #local Xpart=merge { object { Xp1 } object { Xp2 } } #end
 
 #local XYp1=object { Xpart clipped_by { plane { y, 0 } } scale <1,y1,1> }
 #local XYp2=object { Xpart clipped_by { plane { y, 0 scale -1 } } scale <1,y2,1> }
 #if (Merge=0) #local XYpart=union { object { XYp1 } object { XYp2 } } #end
 #if (Merge=1) #local XYpart=merge { object { XYp1 } object { XYp2 } } #end
 
 #local XYZp1=object { XYpart clipped_by { plane { z, 0 } } scale <1,1,z1> }
 #local XYZp2=object { XYpart clipped_by { plane { z, 0 scale -1 } } scale <1,1,z2> }
 #if (Merge=0) #local XYZpart=union { object { XYZp1 } object { XYZp2 } } #end
 #if (Merge=1) #local XYZpart=merge { object { XYZp1 } object { XYZp2 } } #end
 
object { XYZpart }

#end
