
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : Again(st) Minimalism.pov
 Version     : 3.6 / MegaPOV 1.0
 Description : Coming from and going beyond minimalism
               
 Date        : July 2005
 Author      : Thomas A. M. de Groot
 E-mail      : t.degroot@inter.nl.net
 
 Copyright (C) 2005. All rights reserved.
**********************************************************************************/

#include "rad_def.inc"
#include "plaque.pov"

global_settings {
  assumed_gamma 1.0
  ambient_light 0
  max_trace_level 50 
  radiosity {Rad_Settings (Radiosity_IndoorLQ, on, off)}  //Radiosity_IndoorHQ
  photons {
    adc_bailout       0.01
    count             50000
    gather            20, 100
    media             1, 1.0
    jitter            0.4
    //max_trace_level   5
    autostop          0.5
    radius            0.0
    expand_thresholds 0.2, 35.0
    load_file "minimalism.ph"
  }
}

default {finish {ambient 0}}

background { color rgb <0.1, 0.1, 0.1> }


camera {
	location <0, 9.5, -0.2>
	up <0.0, 1.0, 0.0>
  right     x*image_width/image_height
	angle 30
	look_at <0, 0, -0.2>
	}

//----------------------------------------------------
// three alternative lights:

/*light_source {
	<-3, 0.9, 4>
	color rgb <1, 1, 1>
  photons {
    refraction on
  }
	}*/

light_source {
  0*x                 // light's position (translated below)
  color rgb 2.0       // light's color
  area_light
  <0.3, 0, 0> <0, 0, 0.3> // lights spread out across this distance (x * z)
  3, 3                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  photons {
    refraction on
  }
  translate <-3, 1.5, 4>   // <x y z> position of light
}

/*light_source {
  0*x                     // light's position (translated below)
  color rgb 2       // light's color
  spotlight               // this kind of light source
  translate <-30, 1.5, 40> // <x y z> position of light
  point_at <0, 0.5, 0>      // direction of spotlight
  radius 45                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10               // intensity falloff radius (outer, in degrees)
  photons {
    refraction on
  }
}*/

//----------------------------------------------------
#declare Material0 =
texture {pigment {rgb 0.5}}

//----------------------------------------------------
#declare Dark =
//blue/green underground:
texture{
	pigment {
    wrinkles
    color_map {
       [ 0.0     rgb <0.01, 0.01, 0.2> ]
       [ 0.2     rgb <0.01, 0.01, 0.2> ]
       [ 0.8     rgb <0.01, 0.2, 0.01> ]
       [ 1.0     rgb <0.01, 0.2, 0.01> ]
    }
	}
  normal {
    wrinkles, 1
    bump_size 0.1
  }
  scale  <0.2, 0.1, 5.0>
}
//white paint covering:
texture {
  pigment {
    wrinkles
    color_map {
       [ 0.0  rgbt <0, 0, 0, 1> ]
       [ 0.4  rgbt <1, 1, 1, 0.1> ]
       [ 0.46 rgbt <1, 1, 1, 0> ]
       [ 0.48 rgbt <0.8, 0.8, 0.8, 0> ]
       [ 0.5  rgbt <1, 1, 1, 0.1> ]
       [ 1.0  rgbt <0, 0, 0, 1> ]
    }
  }
  normal {
    wrinkles, 1
    bump_size 2
  }
  scale  <0.2, 2, 5.0>
  finish {
    reflection {0, 0.5}
  }
}
//red paint drops:
texture {
  pigment {
    wrinkles
    color_map {
       [ 0.0  rgbt <0, 0, 0, 1> ]
       [ 0.85 rgbt <1, 1, 1, 1> ]
       [ 0.85 rgbt <1, 0, 0, 0> ]
       [ 1.00 rgbt <1, 0, 0, 0> ]
    }
  }
  normal {
    granite
    bump_size 2
    warp {turbulence 1}
  }
  scale  <0.2, 2, 0.2>
  finish {
    reflection {0, 0.5}
  }
}
//crackles on the surface:
texture {   
  pigment {
    color rgbt <0.9, 0.9, 0.9, 0.9>
  }   
  normal {
    crackle solid 
    scale  <0.08, 0.5, 0.08>
    warp {turbulence 0.5}
  }
}

//----------------------------------------------------
#declare Cross =
//blue/green underground:
texture{
	pigment {
    wrinkles
    color_map {
       [ 0.0     rgb <0.01, 0.01, 0.2> ]
       [ 0.2     rgb <0.01, 0.01, 0.2> ]
       [ 0.8     rgb <0.01, 0.2, 0.01> ]
       [ 1.0     rgb <0.01, 0.2, 0.01> ]
    }
	}
  normal {
    wrinkles, 1
    //bump_size 0.5
  }
  scale  <0.2, 0.1, 5.0>
  translate 1
}
//white paint covering:
texture {
  pigment {
    wrinkles
    color_map {
       [ 0.0  rgbt <0, 0, 0, 1> ]
       [ 0.44 rgbt <1, 1, 1, 0.01> ]
       [ 0.46 rgbt <1, 1, 1, 0> ]
       [ 0.48 rgbt <0.8, 0.8, 0.8, 0> ]
       [ 0.5  rgbt <1, 1, 1, 0.01> ]
       [ 1.0  rgbt <0, 0, 0, 1> ]
    }
  }
  normal {
    wrinkles, 1
    //bump_size 0.5
    warp {turbulence <1,0,1>}
  }
  scale  <0.2, 0.1, 3.0>
  finish {
    reflection {0, 0.5}
    //diffuse 0.1
  }
}
//crackles on the surface:
texture {   
  pigment {
    color rgbt <0.5, 0.5, 0.5, 0.9>
  }   
  normal {
    crackle solid 
    scale  <0.08, 0.5, 0.08>
    warp {turbulence 1}
  }
}

//----------------------------------------------------
#declare White =
texture{
	pigment {
		color rgb <1, 1, 1>
	}
}

//----------------------------------------------------
plane { y, 0.0 
  texture {   
    pigment {
      color rgb 0.95
    }   
    normal {
      crackle form <-1, 1, 0> 
      scale  <0.02, 0.02, 0.02>
      warp {turbulence 0.1}
    }
  }
  photons{collect off}
}

//----------------------------------------------------
mesh2 {
	vertex_vectors {
		4034,
		<-1.56839, -0.00274934, 1.03095>,
		<-1.56839, -0.00274934, 0.764448>,
		<-1.56839, -0.00274934, 0.477763>,
		<-1.56839, -0.00274934, 0.173932>,
		<-1.56839, -0.00274934, -0.138559>,
		<-1.56839, -0.00274934, -0.448079>,
		<-1.56839, -0.00274934, -0.744117>,
		<-1.56839, -0.00274934, -1.02101>,
		<-1.56839, -0.00274934, -1.29036>,
		<-1.52488, -0.00274934, -1.52941>,
		<-1.30875, -0.00274934, -1.57888>,
		<-1.04893, -0.00274934, -1.57888>,
		<-0.774984, -0.00274934, -1.57888>,
		<-0.504943, -0.00274934, -1.57888>,
		<-0.284339, -0.00274934, -1.57888>,
		<-0.0126493, -0.00274934, -1.57888>,
		<0.398093, -0.00274934, -1.57888>,
		<0.734344, -0.00274934, -1.57888>,
		<1.00597, -0.00274934, -1.57888>,
		<1.26734, -0.00274934, -1.57888>,
		<1.4924, -0.00274934, -1.5323>,
		<1.53838, -0.00274934, -1.30471>,
		<1.53838, -0.00274934, -1.04166>,
		<1.53838, -0.00274934, -0.769731>,
		<1.53838, -0.00274934, -0.522627>,
		<1.53838, -0.00274934, -0.340368>,
		<1.53838, -0.00274934, -0.0380832>,
		<1.53838, -0.00274934, 0.384018>,
		<1.53838, -0.00274934, 0.715993>,
		<1.53838, -0.00274934, 0.986657>,
		<1.53838, -0.00274934, 1.24923>,
		<1.4942, -0.00274934, 1.47821>,
		<1.27625, -0.00274934, 1.52523>,
		<1.01886, -0.00274934, 1.52523>,
		<0.751057, -0.00274934, 1.52523>,
		<0.466836, -0.00274934, 1.52523>,
		<0.169666, -0.00274934, 1.52523>,
		<-0.133567, -0.00274934, 1.52523>,
		<-0.434244, -0.00274934, 1.52523>,
		<-0.72455, -0.00274934, 1.52523>,
		<-0.999647, -0.00274934, 1.52523>,
		<-1.27163, -0.00274934, 1.52523>,
		<-1.51724, -0.00274934, 1.4847>,
		<-1.56839, -0.00274934, 1.28123>,
		<-1.74123, 0.0929658, -1.58894>,
		<-1.63235, 0.0929983, -1.70575>,
		<-1.77146, 0.0902439, -1.95758>,
		<-1.97396, 0.0888537, -1.96984>,
		<-1.96338, 0.0902464, -1.74369>,
		<-1.8181, 0.0969391, -1.26944>,
		<-1.78771, 0.0946262, -1.42368>,
		<-1.98507, 0.0913825, -1.55576>,
		<-1.99724, 0.0926117, -1.38454>,
		<-1.87204, 0.10177, -0.951739>,
		<-1.84431, 0.0994219, -1.11409>,
		<-2.00668, 0.0938747, -1.21428>,
		<-2.01673, 0.095104, -1.03714>,
		<-1.93032, 0.105734, -0.60743>,
		<-1.90081, 0.103858, -0.78273>,
		<-2.02724, 0.0962238, -0.8532>,
		<-2.03767, 0.0972117, -0.662926>,
		<-1.98679, 0.109315, -0.243976>,
		<-1.96045, 0.107617, -0.426234>,
		<-2.04707, 0.0980987, -0.467161>,
		<-2.05423, 0.0987957, -0.268469>,
		<-1.99701, 0.11002, 0.0994023>,
		<-2.00071, 0.110222, -0.069919>,
		<-2.05768, 0.0990937, -0.0711353>,
		<-2.05641, 0.0988905, 0.124705>,
		<-1.93666, 0.10653, 0.471753>,
		<-1.97398, 0.108681, 0.280189>,
		<-2.04983, 0.0981909, 0.32307>,
		<-2.03893, 0.0971198, 0.522491>,
		<-1.86024, 0.10206, 0.827926>,
		<-1.89689, 0.104246, 0.656523>,
		<-2.02624, 0.0959217, 0.716006>,
		<-2.01334, 0.0947048, 0.900732>,
		<-1.79405, 0.0972614, 1.1461>,
		<-1.826, 0.0997488, 0.990395>,
		<-2.00092, 0.0934407, 1.07786>,
		<-1.98938, 0.0921478, 1.24808>,
		<-1.73219, 0.0924188, 1.44104>,
		<-1.76487, 0.0947165, 1.29496>,
		<-1.97888, 0.0908917, 1.41162>,
		<-1.9657, 0.0897633, 1.57303>,
		<-1.72246, 0.0889763, 1.92179>,
		<-1.5647, 0.0908037, 1.6971>,
		<-1.68302, 0.0908591, 1.59259>,
		<-1.94227, 0.0888789, 1.74122>,
		<-1.95517, 0.0880229, 1.93553>,
		<-1.33094, 0.097154, -1.7851>,
		<-1.43113, 0.0927473, -1.99318>,
		<-1.59666, 0.0914279, -1.98058>,
		<-1.47805, 0.0947372, -1.7539>,
		<-1.17347, 0.128352, -1.05728>,
		<-1.14814, 0.120176, -1.18784>,
		<-1.26791, 0.113087, -1.16369>,
		<-1.2934, 0.120013, -1.03338>,
		<-1.25596, 0.143856, -0.804632>,
		<-1.21475, 0.136284, -0.934833>,
		<-1.33477, 0.126787, -0.910054>,
		<-1.37622, 0.133199, -0.779815>,
		<-1.34813, 0.156822, -0.520462>,
		<-1.29535, 0.150741, -0.66707>,
		<-1.41611, 0.13898, -0.643091>,
		<-1.46965, 0.144239, -0.498606>,
		<-1.59092, 0.16708, -0.190618>,
		<-1.44643, 0.162198, -0.361047>,
		<-1.56892, 0.149464, -0.34338>,
		<-1.71849, 0.155428, -0.176487>,
		<-1.65578, 0.150822, 0.0251777>,
		<-1.66204, 0.150812, -0.0611226>,
		<-1.7953, 0.140195, -0.0482715>,
		<-1.78944, 0.140192, 0.0370153>,
		<-1.38693, 0.160695, 0.371289>,
		<-1.56208, 0.166579, 0.172413>,
		<-1.69156, 0.154922, 0.1804>,
		<-1.51338, 0.148011, 0.372052>,
		<-1.19396, 0.147593, 0.69417>,
		<-1.26411, 0.154431, 0.545857>,
		<-1.39133, 0.141968, 0.540313>,
		<-1.32175, 0.136029, 0.684818>,
		<-1.0924, 0.131901, 0.955097>,
		<-1.14222, 0.140046, 0.828543>,
		<-1.27045, 0.129666, 0.816874>,
		<-1.22093, 0.12276, 0.942073>,
		<-1.02006, 0.115148, 1.20005>,
		<-1.04574, 0.123515, 1.07376>,
		<-1.17435, 0.115598, 1.0603>,
		<-1.14817, 0.108518, 1.18501>,
		<-1.13552, 0.0996034, 1.56606>,
		<-1.04971, 0.10696, 1.36508>,
		<-1.1761, 0.101904, 1.34325>,
		<-1.26844, 0.0962162, 1.53641>,
		<-1.02493, 0.102254, -1.84146>,
		<-1.09036, 0.0954988, -2.01341>,
		<-1.26416, 0.0941301, -2.00289>,
		<-1.18148, 0.0997628, -1.81218>,
		<-0.936136, 0.144258, -1.15063>,
		<-0.910117, 0.13375, -1.28016>,
		<-1.03287, 0.127142, -1.23261>,
		<-1.05895, 0.136482, -1.10246>,
		<-1.01207, 0.164365, -0.894408>,
		<-0.974187, 0.154454, -1.02732>,
		<-1.09912, 0.145537, -0.979396>,
		<-1.13919, 0.154249, -0.847625>,
		<-1.09173, 0.181743, -0.59697>,
		<-1.04818, 0.173623, -0.751883>,
		<-1.17746, 0.162218, -0.707377>,
		<-1.22666, 0.16914, -0.556501>,
		<-1.26177, 0.192972, -0.2357>,
		<-1.16271, 0.188123, -0.424108>,
		<-1.31387, 0.174797, -0.390462>,
		<-1.43975, 0.179426, -0.211349>,
		<-1.29709, 0.176173, -0.00571464>,
		<-1.30411, 0.176136, -0.0951658>,
		<-1.49874, 0.162928, -0.0766109>,
		<-1.49209, 0.162954, 0.0110629>,
		<-1.09793, 0.186758, 0.376078>,
		<-1.23013, 0.192559, 0.155014>,
		<-1.40948, 0.178956, 0.164908>,
		<-1.25164, 0.173316, 0.374791>,
		<-0.937038, 0.170441, 0.731>,
		<-1.00005, 0.17945, 0.568962>,
		<-1.13868, 0.166734, 0.558334>,
		<-1.07103, 0.158992, 0.713254>,
		<-0.839859, 0.149698, 1.00977>,
		<-0.887101, 0.16035, 0.875646>,
		<-1.01962, 0.150283, 0.852547>,
		<-0.970517, 0.140922, 0.982744>,
		<-0.77042, 0.128091, 1.26357>,
		<-0.796347, 0.138905, 1.13364>,
		<-0.924882, 0.131348, 1.10391>,
		<-0.898637, 0.121767, 1.23183>,
		<-0.8513, 0.106628, 1.63133>,
		<-0.788759, 0.117075, 1.43185>,
		<-0.922443, 0.112156, 1.39801>,
		<-0.996624, 0.103223, 1.59768>,
		<-0.698561, 0.106493, -1.90647>,
		<-0.731234, 0.0978959, -2.03645>,
		<-0.909747, 0.0967708, -2.02469>,
		<-0.861381, 0.104492, -1.87274>,
		<-0.667854, 0.157504, -1.27083>,
		<-0.646052, 0.145063, -1.39815>,
		<-0.77984, 0.139712, -1.32989>,
		<-0.804904, 0.151331, -1.20118>,
		<-0.72599, 0.182031, -1.00827>,
		<-0.697128, 0.169629, -1.14581>,
		<-0.839845, 0.162614, -1.07792>,
		<-0.874539, 0.173812, -0.944147>,
		<-0.780477, 0.207489, -0.694085>,
		<-0.752796, 0.195126, -0.859011>,
		<-0.907359, 0.184899, -0.799739>,
		<-0.944034, 0.195015, -0.641121>,
		<-0.861716, 0.220002, -0.294004>,
		<-0.816544, 0.215856, -0.504805>,
		<-0.997651, 0.202468, -0.461279>,
		<-1.06888, 0.20729, -0.26289>,
		<-0.867889, 0.198543, -0.0454396>,
		<-0.875733, 0.198527, -0.139083>,
		<-1.09559, 0.188621, -0.115888>,
		<-1.08819, 0.188654, -0.0244077>,
		<-0.745289, 0.215048, 0.369772>,
		<-0.826808, 0.219723, 0.127927>,
		<-1.03584, 0.206946, 0.142882>,
		<-0.930229, 0.201343, 0.374569>,
		<-0.629656, 0.192638, 0.760604>,
		<-0.67937, 0.205941, 0.581737>,
		<-0.848614, 0.193005, 0.576675>,
		<-0.791615, 0.181917, 0.746139>,
		<-0.547231, 0.165245, 1.06598>,
		<-0.586956, 0.178558, 0.919853>,
		<-0.744459, 0.169877, 0.896555>,
		<-0.700262, 0.157828, 1.03494>,
		<-0.489652, 0.139447, 1.33402>,
		<-0.511592, 0.152365, 1.19849>,
		<-0.660028, 0.145857, 1.16175>,
		<-0.635433, 0.133856, 1.29405>,
		<-0.54044, 0.112599, 1.70377>,
		<-0.499524, 0.125887, 1.50631>,
		<-0.648823, 0.12151, 1.46555>,
		<-0.699815, 0.109661, 1.66628>,
		<-0.423242, 0.110088, -1.98027>,
		<-0.435499, 0.0995811, -2.05889>,
		<-0.572692, 0.0988566, -2.04821>,
		<-0.551831, 0.108421, -1.94369>,
		<-0.394391, 0.167246, -1.56915>,
		<-0.393747, 0.155785, -1.69306>,
		<-0.51682, 0.150161, -1.51827>,
		<-0.53031, 0.162735, -1.39366>,
		<-0.394951, 0.192823, -1.25011>,
		<-0.395502, 0.17941, -1.42287>,
		<-0.548224, 0.175147, -1.26099>,
		<-0.565257, 0.188296, -1.11047>,
		<-0.388389, 0.21989, -0.858649>,
		<-0.392609, 0.207114, -1.06199>,
		<-0.580244, 0.202518, -0.946672>,
		<-0.594226, 0.215852, -0.76687>,
		<-0.374673, 0.2275, -0.376224>,
		<-0.382256, 0.226743, -0.629243>,
		<-0.610447, 0.224045, -0.561058>,
		<-0.629567, 0.226785, -0.331986>,
		<-0.357108, 0.205312, -0.0989151>,
		<-0.366187, 0.205312, -0.197008>,
		<-0.632167, 0.203955, -0.166267>,
		<-0.623765, 0.203958, -0.0704039>,
		<-0.293878, 0.226387, 0.349852>,
		<-0.332499, 0.227287, 0.0861101>,
		<-0.591606, 0.226551, 0.108823>,
		<-0.532191, 0.223504, 0.361275>,
		<-0.229525, 0.207167, 0.803727>,
		<-0.259437, 0.219669, 0.58953>,
		<-0.481927, 0.214917, 0.585735>,
		<-0.441325, 0.201056, 0.77953>,
		<-0.176652, 0.178957, 1.19615>,
		<-0.202054, 0.192834, 1.00565>,
		<-0.405303, 0.18615, 0.955982>,
		<-0.371943, 0.172218, 1.11951>,
		<-0.139712, 0.154047, 1.51272>,
		<-0.154662, 0.166167, 1.36371>,
		<-0.342484, 0.159071, 1.26563>,
		<-0.325014, 0.145898, 1.40624>,
		<-0.194994, 0.119872, 1.7886>,
		<-0.155831, 0.138096, 1.6521>,
		<-0.334468, 0.131268, 1.56964>,
		<-0.369448, 0.116155, 1.74707>,
		<-0.157224, 0.110735, -2.01719>,
		<-0.147055, 0.0998457, -2.0706>,
		<-0.304544, 0.099943, -2.06685>,
		<-0.301524, 0.110953, -2.00688>,
		<-0.196154, 0.15086, -1.67175>,
		<-0.204554, 0.140351, -1.79608>,
		<-0.289676, 0.140578, -1.77938>,
		<-0.282482, 0.15106, -1.65267>,
		<-0.172035, 0.176082, -1.32579>,
		<-0.185433, 0.162904, -1.51551>,
		<-0.273324, 0.163065, -1.49584>,
		<-0.261843, 0.176194, -1.3073>,
		<-0.139618, 0.198504, -0.904442>,
		<-0.156796, 0.188574, -1.12067>,
		<-0.248625, 0.188636, -1.10391>,
		<-0.233496, 0.198529, -0.889295>,
		<-0.0967079, 0.205312, -0.411691>,
		<-0.11947, 0.20395, -0.667586>,
		<-0.215521, 0.203955, -0.653833>,
		<-0.195061, 0.205312, -0.399131>,
		<-0.0699087, 0.205312, -0.130552>,
		<-0.0798971, 0.205312, -0.230565>,
		<-0.179606, 0.205312, -0.218836>,
		<-0.169986, 0.205312, -0.119359>,
		<-0.0227648, 0.204013, 0.324588>,
		<-0.050569, 0.205312, 0.0568204>,
		<-0.150422, 0.205312, 0.0674254>,
		<-0.121737, 0.20401, 0.334622>,
		<0.0245243, 0.189233, 0.79666>,
		<0.00237809, 0.198816, 0.57146>,
		<-0.0955168, 0.198801, 0.581137>,
		<-0.072017, 0.189202, 0.806234>,
		<0.063167, 0.163553, 1.21766>,
		<0.0447773, 0.176888, 1.01256>,
		<-0.0501039, 0.176845, 1.02223>,
		<-0.0298813, 0.163506, 1.22756>,
		<0.0915616, 0.140166, 1.55011>,
		<0.0786499, 0.151149, 1.39659>,
		<-0.0126907, 0.1511, 1.40676>,
		<0.00172286, 0.140113, 1.56058>,
		<0.107147, 0.122059, 1.8021>,
		<0.102148, 0.142236, 1.68575>,
		<-0.00879383, 0.142232, 1.69559>,
		<-0.0371089, 0.122121, 1.81004>,
		<0.325705, 0.107312, -1.98218>,
		<0.379943, 0.0981723, -2.06171>,
		<0.0874024, 0.0992227, -2.06876>,
		<0.0572976, 0.109416, -2.00784>,
		<0.214207, 0.161176, -1.47923>,
		<0.209435, 0.148549, -1.5969>,
		<-0.0339525, 0.154927, -1.74232>,
		<-0.027281, 0.166438, -1.62396>,
		<0.245304, 0.187074, -1.20508>,
		<0.228661, 0.173723, -1.3518>,
		<-0.0151514, 0.178699, -1.48046>,
		<-0.000410929, 0.192242, -1.30764>,
		<0.285771, 0.215138, -0.866622>,
		<0.263803, 0.201545, -1.04399>,
		<0.0162925, 0.206659, -1.1183>,
		<0.0356198, 0.219539, -0.913602>,
		<0.350368, 0.226446, -0.440075>,
		<0.314767, 0.223545, -0.664324>,
		<0.0595408, 0.226469, -0.683078>,
		<0.0876457, 0.227283, -0.429254>,
		<0.383394, 0.204004, -0.176424>,
		<0.371291, 0.204003, -0.275036>,
		<0.106126, 0.205312, -0.249728>,
		<0.116928, 0.205312, -0.149974>,
		<0.406831, 0.223133, 0.275332>,
		<0.39825, 0.226256, 0.0104258>,
		<0.135219, 0.227109, 0.038462>,
		<0.15683, 0.226215, 0.307041>,
		<0.414713, 0.200477, 0.707781>,
		<0.412643, 0.214446, 0.508694>,
		<0.175339, 0.219503, 0.550162>,
		<0.190154, 0.207006, 0.766328>,
		<0.40784, 0.171533, 1.05541>,
		<0.412938, 0.185493, 0.888163>,
		<0.202155, 0.192669, 0.969515>,
		<0.211706, 0.178787, 1.16102>,
		<0.397091, 0.145279, 1.35003>,
		<0.400564, 0.158403, 1.20511>,
		<0.218649, 0.166004, 1.32947>,
		<0.225344, 0.153903, 1.47967>,
		<0.435619, 0.115648, 1.70766>,
		<0.408234, 0.130711, 1.52013>,
		<0.24118, 0.137915, 1.62219>,
		<0.263685, 0.119628, 1.76458>,
		<0.758049, 0.102925, -1.91747>,
		<0.847409, 0.0956948, -2.03988>,
		<0.642361, 0.0969574, -2.05154>,
		<0.567686, 0.105077, -1.95024>,
		<0.578746, 0.148784, -1.32169>,
		<0.570091, 0.137153, -1.44032>,
		<0.410762, 0.142877, -1.49741>,
		<0.416875, 0.155358, -1.37878>,
		<0.627477, 0.171623, -1.08022>,
		<0.602058, 0.160203, -1.2064>,
		<0.435168, 0.167633, -1.26074>,
		<0.455489, 0.180269, -1.12956>,
		<0.688077, 0.193545, -0.79265>,
		<0.654699, 0.183005, -0.942714>,
		<0.477617, 0.19367, -0.985744>,
		<0.504325, 0.206404, -0.826586>,
		<0.799909, 0.207393, -0.451617>,
		<0.736618, 0.201669, -0.62799>,
		<0.541383, 0.215193, -0.646217>,
		<0.588366, 0.219795, -0.447738>,
		<0.851097, 0.189162, -0.218049>,
		<0.835969, 0.189159, -0.313482>,
		<0.614943, 0.198769, -0.296473>,
		<0.628469, 0.198774, -0.199276>,
		<0.821073, 0.200561, 0.226173>,
		<0.849283, 0.20701, -0.0340243>,
		<0.636837, 0.219537, -0.0138875>,
		<0.629204, 0.214484, 0.248215>,
		<0.779777, 0.180349, 0.626771>,
		<0.798282, 0.191671, 0.447429>,
		<0.621414, 0.205084, 0.474274>,
		<0.612315, 0.191589, 0.661074>,
		<0.736136, 0.156209, 0.92982>,
		<0.759682, 0.168242, 0.784213>,
		<0.599706, 0.17741, 0.826212>,
		<0.583446, 0.164076, 0.978185>,
		<0.696382, 0.132454, 1.20414>,
		<0.711285, 0.14432, 1.06371>,
		<0.565455, 0.151237, 1.11639>,
		<0.554625, 0.13841, 1.25849>,
		<0.758735, 0.108641, 1.60528>,
		<0.711779, 0.120293, 1.38756>,
		<0.56682, 0.124978, 1.44043>,
		<0.603265, 0.11182, 1.65184>,
		<1.08856, 0.0981271, -1.853>,
		<1.20342, 0.09296, -2.01639>,
		<1.0288, 0.0943556, -2.02791>,
		<0.926719, 0.100627, -1.88475>,
		<0.856732, 0.133459, -1.22916>,
		<0.844587, 0.124184, -1.3477>,
		<0.710844, 0.130948, -1.3951>,
		<0.721741, 0.141432, -1.27663>,
		<0.921121, 0.151413, -0.992159>,
		<0.887826, 0.142576, -1.11513>,
		<0.749579, 0.151732, -1.16193>,
		<0.779618, 0.161823, -1.03729>,
		<1.00214, 0.166878, -0.722235>,
		<0.956137, 0.159562, -0.860107>,
		<0.811443, 0.171326, -0.902473>,
		<0.851682, 0.179874, -0.758498>,
		<1.18371, 0.179606, -0.451345>,
		<1.07812, 0.173485, -0.585218>,
		<0.914004, 0.187112, -0.607672>,
		<0.998013, 0.193237, -0.45257>,
		<1.26323, 0.16366, -0.248137>,
		<1.24488, 0.163739, -0.339283>,
		<1.04648, 0.176889, -0.327532>,
		<1.06342, 0.176864, -0.234182>,
		<1.15532, 0.171794, 0.190135>,
		<1.2346, 0.178918, -0.0670138>,
		<1.0485, 0.1927, -0.0515597>,
		<0.995109, 0.185652, 0.207117>,
		<1.06534, 0.156389, 0.571745>,
		<1.09923, 0.164349, 0.403771>,
		<0.955531, 0.17759, 0.424514>,
		<0.928706, 0.168341, 0.598098>,
		<1.00418, 0.138491, 0.85708>,
		<1.0362, 0.14773, 0.718768>,
		<0.903327, 0.15824, 0.750328>,
		<0.874817, 0.147656, 0.892373>,
		<0.953044, 0.119734, 1.12414>,
		<0.971377, 0.129089, 0.986446>,
		<0.845335, 0.136991, 1.02412>,
		<0.828201, 0.126358, 1.1632>,
		<1.04674, 0.101829, 1.52544>,
		<0.977548, 0.110424, 1.30496>,
		<0.847901, 0.115584, 1.34504>,
		<0.905935, 0.105401, 1.56378>,
		<1.39635, 0.0931756, -1.78961>,
		<1.53925, 0.0903027, -1.99223>,
		<1.37138, 0.0915784, -2.00564>,
		<1.24339, 0.0955414, -1.82317>,
		<1.11917, 0.116863, -1.15093>,
		<1.10497, 0.11007, -1.26982>,
		<0.971031, 0.117129, -1.30049>,
		<0.983544, 0.125202, -1.18174>,
		<1.18991, 0.13004, -0.915586>,
		<1.15351, 0.123612, -1.03675>,
		<1.01675, 0.133153, -1.06849>,
		<1.05206, 0.140797, -0.947349>,
		<1.27893, 0.141408, -0.65928>,
		<1.22792, 0.135869, -0.787405>,
		<1.08896, 0.147795, -0.818218>,
		<1.13877, 0.154224, -0.686388>,
		<1.49022, 0.155148, -0.446827>,
		<1.3662, 0.147551, -0.545381>,
		<1.22458, 0.160578, -0.562507>,
		<1.34606, 0.167062, -0.448583>,
		<1.57664, 0.140594, -0.268475>,
		<1.56048, 0.140778, -0.35599>,
		<1.41584, 0.151552, -0.348583>,
		<1.43395, 0.151417, -0.259408>,
		<1.43343, 0.145701, 0.171425>,
		<1.53493, 0.154264, -0.0866281>,
		<1.39494, 0.166255, -0.079852>,
		<1.29707, 0.15876, 0.175494>,
		<1.32128, 0.132718, 0.538972>,
		<1.36255, 0.138795, 0.37944>,
		<1.22925, 0.151587, 0.385332>,
		<1.19052, 0.14456, 0.547856>,
		<1.25159, 0.119807, 0.811231>,
		<1.28763, 0.126506, 0.678249>,
		<1.15898, 0.137115, 0.689792>,
		<1.12469, 0.129138, 0.824362>,
		<1.19484, 0.106096, 1.07226>,
		<1.21508, 0.112887, 0.937615>,
		<1.08968, 0.120963, 0.951289>,
		<1.071, 0.112861, 1.08767>,
		<1.30886, 0.0946301, 1.45954>,
		<1.22241, 0.0998672, 1.2452>,
		<1.10065, 0.105032, 1.26798>,
		<1.18097, 0.0980867, 1.49074>,
		<1.66973, 0.0914569, -1.62724>,
		<1.92094, 0.0892843, -1.76589>,
		<1.93623, 0.0881493, -1.97847>,
		<1.72015, 0.0892465, -1.96899>,
		<1.55797, 0.0915235, -1.74008>,
		<1.51758, 0.100799, -1.2332>,
		<1.48775, 0.0973043, -1.35971>,
		<1.27629, 0.103306, -1.28594>,
		<1.29776, 0.108506, -1.16734>,
		<1.58537, 0.108056, -0.961079>,
		<1.55005, 0.104534, -1.10043>,
		<1.33247, 0.113831, -1.04685>,
		<1.3696, 0.118866, -0.919807>,
		<1.66613, 0.114175, -0.673919>,
		<1.62338, 0.111192, -0.815344>,
		<1.40882, 0.123388, -0.786265>,
		<1.45793, 0.12776, -0.655033>,
		<1.77234, 0.121144, -0.463047>,
		<1.71791, 0.117644, -0.558016>,
		<1.53295, 0.13293, -0.543649>,
		<1.62984, 0.139359, -0.450927>,
		<1.82713, 0.12281, -0.21598>,
		<1.8124, 0.123128, -0.358624>,
		<1.69318, 0.143123, -0.358494>,
		<1.70826, 0.142859, -0.249557>,
		<1.77279, 0.116022, 0.243437>,
		<1.81164, 0.120165, -0.00796275>,
		<1.67187, 0.138391, -0.0583403>,
		<1.59521, 0.131138, 0.194127>,
		<1.68886, 0.108789, 0.641825>,
		<1.72916, 0.112066, 0.467089>,
		<1.53327, 0.125323, 0.40645>,
		<1.49078, 0.120521, 0.570027>,
		<1.61074, 0.101873, 0.945102>,
		<1.64954, 0.105483, 0.796441>,
		<1.45342, 0.115714, 0.713583>,
		<1.4149, 0.110494, 0.85129>,
		<1.53948, 0.0946358, 1.22329>,
		<1.57393, 0.0981074, 1.08734>,
		<1.37697, 0.105065, 0.982767>,
		<1.35005, 0.0998785, 1.11415>,
		<1.50677, 0.0922047, 1.35365>,
		<1.3533, 0.0956296, 1.2581>,
		<1.43103, 0.0922044, 1.43113>,
		<-1.65695, 0.164801, 0.0687749>,
		<-1.65408, 0.155485, 0.0684769>,
		<-1.78771, 0.144823, 0.0798015>,
		<-1.79011, 0.154088, 0.080087>,
		<-1.8018, 0.154096, -0.0904283>,
		<-1.79942, 0.14483, -0.0907527>,
		<-1.66659, 0.155465, -0.104096>,
		<-1.66944, 0.164781, -0.103744>,
		<-1.85456, 0.148977, 0.0429925>,
		<-1.85236, 0.139744, 0.0427005>,
		<-1.85802, 0.139754, -0.0421315>,
		<-1.86021, 0.148988, -0.0418233>,
		<-1.29986, 0.190454, 0.0395914>,
		<-1.29567, 0.180946, 0.0392044>,
		<-1.49055, 0.16763, 0.0550689>,
		<-1.4941, 0.176956, 0.0554071>,
		<-1.50737, 0.176905, -0.119822>,
		<-1.50383, 0.167579, -0.120239>,
		<-1.30971, 0.180873, -0.139645>,
		<-1.31388, 0.190385, -0.139151>,
		<-0.868618, 0.21563, 0.00186468>,
		<-0.865517, 0.204244, 0.0015431>,
		<-1.08652, 0.193826, 0.0215264>,
		<-1.09061, 0.204136, 0.0219147>,
		<-1.1054, 0.204098, -0.160861>,
		<-1.10133, 0.193768, -0.161372>,
		<-0.881197, 0.204232, -0.185683>,
		<-0.884279, 0.215658, -0.185239>,
		<-0.352522, 0.221404, -0.0497959>,
		<-0.352553, 0.210676, -0.0498445>,
		<-0.620382, 0.209757, -0.0223716>,
		<-0.62202, 0.221353, -0.0221695>,
		<-0.638799, 0.221423, -0.21373>,
		<-0.637178, 0.209776, -0.214042>,
		<-0.370704, 0.210699, -0.245985>,
		<-0.370662, 0.221475, -0.245848>,
		<-0.162936, 0.153881, -1.8188>,
		<-0.162307, 0.144785, -1.80922>,
		<-0.153366, 0.155314, -1.68689>,
		<-0.154118, 0.164422, -1.6981>,
		<-0.293629, 0.149211, -1.85124>,
		<-0.293174, 0.14013, -1.84223>,
		<-0.208633, 0.139894, -1.85736>,
		<-0.209165, 0.148976, -1.86621>,
		<-0.326438, 0.164826, -1.66003>,
		<-0.32591, 0.155716, -1.64876>,
		<-0.332464, 0.145238, -1.77594>,
		<-0.332916, 0.154331, -1.78575>,
		<-0.142828, 0.176456, -1.54463>,
		<-0.141934, 0.167367, -1.53178>,
		<-0.127645, 0.180658, -1.34213>,
		<-0.128675, 0.189921, -1.35633>,
		<-0.307839, 0.19016, -1.31915>,
		<-0.307111, 0.180886, -1.30509>,
		<-0.317579, 0.167692, -1.4924>,
		<-0.318196, 0.176785, -1.5052>,
		<-0.112529, 0.203702, -1.15086>,
		<-0.111431, 0.193596, -1.13632>,
		<-0.0931894, 0.204123, -0.918574>,
		<-0.0942112, 0.215385, -0.931691>,
		<-0.281764, 0.215527, -0.901208>,
		<-0.280878, 0.204204, -0.888218>,
		<-0.294974, 0.193737, -1.10272>,
		<-0.295842, 0.203876, -1.11708>,
		<-0.0724915, 0.221257, -0.688038>,
		<-0.0717933, 0.209717, -0.678988>,
		<-0.0476075, 0.210667, -0.419308>,
		<-0.0477598, 0.221377, -0.421981>,
		<-0.243636, 0.221462, -0.397753>,
		<-0.244037, 0.210695, -0.394485>,
		<-0.263779, 0.209763, -0.651548>,
		<-0.264245, 0.221372, -0.660732>,
		<-0.000438299, 0.221246, 0.0527049>,
		<-0.00057425, 0.210623, 0.0519136>,
		<0.026847, 0.209718, 0.320593>,
		<0.0270986, 0.221125, 0.322638>,
		<-0.170695, 0.221177, 0.342649>,
		<-0.171047, 0.209731, 0.340643>,
		<-0.200002, 0.210644, 0.0730839>,
		<-0.199308, 0.221308, 0.073796>,
		<0.0517798, 0.215691, 0.570709>,
		<0.0514769, 0.204446, 0.567984>,
		<0.0729415, 0.194406, 0.793298>,
		<0.0732345, 0.204721, 0.79615>,
		<-0.119857, 0.204675, 0.815283>,
		<-0.120144, 0.194349, 0.812442>,
		<-0.144353, 0.204431, 0.58733>,
		<-0.144129, 0.215704, 0.590039>,
		<0.0926253, 0.191307, 1.012>,
		<0.0923537, 0.181709, 1.00915>,
		<0.109823, 0.168277, 1.21417>,
		<0.110086, 0.17768, 1.21709>,
		<-0.0758561, 0.177587, 1.23687>,
		<-0.0762223, 0.168184, 1.23396>,
		<-0.097366, 0.181623, 1.02848>,
		<-0.0970089, 0.191224, 1.03132>,
		<0.0980527, 0.148746, 1.62756>,
		<0.0977435, 0.139523, 1.62428>,
		<0.00864456, 0.139468, 1.63489>,
		<0.00900012, 0.148691, 1.63816>,
		<0.12472, 0.165202, 1.39606>,
		<0.124453, 0.15585, 1.39302>,
		<0.13662, 0.144827, 1.54648>,
		<0.136899, 0.154097, 1.54968>,
		<-0.0426374, 0.153992, 1.57059>,
		<-0.0430101, 0.144722, 1.56741>,
		<-0.0581788, 0.155752, 1.41337>,
		<-0.0578146, 0.165104, 1.4164>,
		<0.392485, 0.221169, -0.127243>,
		<0.390459, 0.209726, -0.127159>,
		<0.122721, 0.21063, -0.10009>,
		<0.123505, 0.221267, -0.100077>,
		<0.101978, 0.221331, -0.298745>,
		<0.101142, 0.210651, -0.299318>,
		<0.366246, 0.209747, -0.324329>,
		<0.368262, 0.221234, -0.324304>,
		<0.862884, 0.204661, -0.170543>,
		<0.860069, 0.19433, -0.170403>,
		<0.636581, 0.204417, -0.150744>,
		<0.639279, 0.215698, -0.150879>,
		<0.612179, 0.215741, -0.345377>,
		<0.609513, 0.204425, -0.345173>,
		<0.829807, 0.194332, -0.361268>,
		<0.832611, 0.20468, -0.361409>,
		<1.27668, 0.177726, -0.202772>,
		<1.27383, 0.168322, -0.202634>,
		<1.07329, 0.181652, -0.187574>,
		<1.07609, 0.191254, -0.18771>,
		<1.04223, 0.19131, -0.374282>,
		<1.03942, 0.181705, -0.374232>,
		<1.23714, 0.168481, -0.384875>,
		<1.24001, 0.177884, -0.384913>,
		<1.58931, 0.154409, -0.224948>,
		<1.58625, 0.145138, -0.224794>,
		<1.44448, 0.156026, -0.214893>,
		<1.44742, 0.16538, -0.215037>,
		<1.63316, 0.149463, -0.359529>,
		<1.63, 0.140239, -0.359428>,
		<1.64488, 0.140032, -0.27271>,
		<1.64802, 0.149257, -0.27285>,
		<1.41125, 0.165649, -0.393253>,
		<1.40827, 0.156296, -0.393198>,
		<1.55395, 0.145505, -0.399784>,
		<1.55707, 0.154776, -0.399856>,
		<-1.82541, 0.066144, -2.09587>,
		<-1.82509, 0.0202151, -2.09587>,
		<-1.99844, 0.0199376, -2.09587>,
		<-1.99855, 0.0653114, -2.09587>,
		<-2.08539, 0.0653221, -1.99707>,
		<-2.08539, 0.0199412, -1.99697>,
		<-2.08539, 0.020222, -1.8025>,
		<-2.08539, 0.0661647, -1.80279>,
		<-2.08539, 0.0668527, -1.61843>,
		<-2.08539, 0.0204513, -1.61799>,
		<-2.08539, 0.0206318, -1.44179>,
		<-2.08539, 0.067394, -1.44231>,
		<-2.08539, 0.0679072, -1.26447>,
		<-2.08539, 0.0208028, -1.26392>,
		<-2.08539, 0.0209781, -1.07935>,
		<-2.08539, 0.0684329, -1.07987>,
		<-2.08539, 0.0689334, -0.888439>,
		<-2.08539, 0.0211449, -0.88798>,
		<-2.08539, 0.02129, -0.690255>,
		<-2.08539, 0.0693686, -0.690634>,
		<-2.08539, 0.0696958, -0.487434>,
		<-2.08539, 0.021399, -0.487154>,
		<-2.08539, 0.021461, -0.280117>,
		<-2.08539, 0.0698816, -0.280284>,
		<-2.08539, 0.069902, -0.071093>,
		<-2.08539, 0.0214678, -0.0710478>,
		<-2.08539, 0.0214175, 0.138045>,
		<-2.08539, 0.0697512, 0.138123>,
		<-2.08539, 0.0694416, 0.345244>,
		<-2.08539, 0.0213143, 0.345047>,
		<-2.08539, 0.0211671, 0.548153>,
		<-2.08539, 0.0689999, 0.548456>,
		<-2.08539, 0.0684673, 0.746258>,
		<-2.08539, 0.0209895, 0.745864>,
		<-2.08539, 0.0207961, 0.937187>,
		<-2.08539, 0.0678869, 0.937652>,
		<-2.08539, 0.0673034, 1.12215>,
		<-2.08539, 0.0206016, 1.12163>,
		<-2.08539, 0.0204184, 1.29916>,
		<-2.08539, 0.0667539, 1.2997>,
		<-2.08539, 0.0662675, 1.47072>,
		<-2.08539, 0.0202563, 1.47021>,
		<-2.08539, 0.0201102, 1.6362>,
		<-2.08539, 0.0658293, 1.63662>,
		<-1.98325, 0.0649629, 2.04294>,
		<-1.98315, 0.0198214, 2.04294>,
		<-1.78271, 0.0200128, 2.04294>,
		<-1.78298, 0.0655372, 2.04294>,
		<-2.08539, 0.0653798, 1.79986>,
		<-2.08539, 0.0199604, 1.79959>,
		<-2.08539, 0.0198003, 1.96194>,
		<-2.08539, 0.0648996, 1.96203>,
		<-1.48222, 0.0674618, -2.09587>,
		<-1.48165, 0.0206544, -2.09587>,
		<-1.65337, 0.0204527, -2.09587>,
		<-1.65385, 0.0668567, -2.09587>,
		<-1.59479, 0.0659835, 2.04294>,
		<-1.59438, 0.0201616, 2.04294>,
		<-1.41673, 0.0202708, 2.04294>,
		<-1.41723, 0.0663111, 2.04294>,
		<-1.12354, 0.0686946, -2.09587>,
		<-1.12298, 0.0210653, -2.09587>,
		<-1.30559, 0.0208551, -2.09587>,
		<-1.30619, 0.0680641, -2.09587>,
		<-1.23939, 0.0666242, 2.04294>,
		<-1.23887, 0.0203752, 2.04294>,
		<-1.05541, 0.0204873, 2.04294>,
		<-1.0559, 0.0669606, 2.04294>,
		<-0.747672, 0.0698531, -2.09587>,
		<-0.747267, 0.0214515, -2.09587>,
		<-0.933705, 0.0212708, -2.09587>,
		<-0.934194, 0.069311, -2.09587>,
		<-0.866929, 0.0672919, 2.04294>,
		<-0.866501, 0.0205978, 2.04294>,
		<-0.672645, 0.0206965, 2.04294>,
		<-0.672997, 0.0675882, 2.04294>,
		<-0.441557, 0.0704677, -2.09587>,
		<-0.441318, 0.0216564, -2.09587>,
		<-0.582778, 0.0215816, -2.09587>,
		<-0.583098, 0.0702434, -2.09587>,
		<-0.474937, 0.0678182, 2.04294>,
		<-0.474678, 0.0207732, 2.04294>,
		<-0.273713, 0.0208194, 2.04294>,
		<-0.273869, 0.0679569, 2.04294>,
		<-0.142179, 0.0705547, -2.09587>,
		<-0.142117, 0.0216853, -2.09587>,
		<-0.305936, 0.0216923, -2.09587>,
		<-0.306094, 0.0705755, -2.09587>,
		<-0.0711831, 0.0679858, 2.04294>,
		<-0.0711376, 0.020829, 2.04294>,
		<0.131585, 0.0208001, 2.04294>,
		<0.131651, 0.067899, 2.04294>,
		<0.407156, 0.0699048, -2.09587>,
		<0.406915, 0.0214687, -2.09587>,
		<0.102218, 0.0216112, -2.09587>,
		<0.102295, 0.0703322, -2.09587>,
		<0.333092, 0.0677034, 2.04294>,
		<0.332917, 0.0207349, 2.04294>,
		<0.531484, 0.0206393, 2.04294>,
		<0.531761, 0.0674167, 2.04294>,
		<0.892342, 0.0686927, -2.09587>,
		<0.891891, 0.0210647, -2.09587>,
		<0.679585, 0.02128, -2.09587>,
		<0.679957, 0.0693388, -2.09587>,
		<0.726442, 0.0670674, 2.04294>,
		<0.726076, 0.0205229, 2.04294>,
		<0.915792, 0.0203961, 2.04294>,
		<0.916231, 0.0666869, 2.04294>,
		<1.26107, 0.0673544, -2.09587>,
		<1.26055, 0.0206186, -2.09587>,
		<1.07955, 0.0208394, -2.09587>,
		<1.08005, 0.0680169, -2.09587>,
		<1.10054, 0.0663089, 2.04294>,
		<1.10004, 0.0202701, 2.04294>,
		<1.27855, 0.0201547, 2.04294>,
		<1.27908, 0.0659627, 2.04294>,
		<1.60745, 0.0661604, -2.09587>,
		<1.60705, 0.0202206, -2.09587>,
		<1.43517, 0.0204138, -2.09587>,
		<1.43566, 0.0667401, -2.09587>,
		<1.45193, 0.065673, 2.04294>,
		<1.45143, 0.0200581, 2.04294>,
		<1.62126, 0.019971, 2.04294>,
		<1.62168, 0.0654118, 2.04294>,
		<2.05696, 0.0656404, -1.81897>,
		<2.05696, 0.0200473, -1.81867>,
		<2.05696, 0.0198158, -2.00276>,
		<2.05696, 0.064946, -2.00287>,
		<1.96514, 0.0649009, -2.09587>,
		<1.96505, 0.0198007, -2.09587>,
		<1.78315, 0.020018, -2.09587>,
		<1.78342, 0.0655528, -2.09587>,
		<2.05696, 0.0664789, -1.46855>,
		<2.05696, 0.0203267, -1.468>,
		<2.05696, 0.0202163, -1.64092>,
		<2.05696, 0.0661476, -1.64137>,
		<2.05696, 0.0671161, -1.11193>,
		<2.05696, 0.0205391, -1.1114>,
		<2.05696, 0.0204279, -1.29271>,
		<2.05696, 0.0667822, -1.29327>,
		<2.05696, 0.067738, -0.748291>,
		<2.05696, 0.0207464, -0.747909>,
		<2.05696, 0.0206503, -0.924096>,
		<2.05696, 0.0674496, -0.924554>,
		<2.05696, 0.0679984, -0.517102>,
		<2.05696, 0.0208333, -0.516837>,
		<2.05696, 0.0208077, -0.61709>,
		<2.05696, 0.0679218, -0.61741>,
		<2.05696, 0.0679825, -0.182923>,
		<2.05696, 0.0208279, -0.182845>,
		<2.05696, 0.0208408, -0.383295>,
		<2.05696, 0.0680212, -0.383485>,
		<2.05696, 0.0675099, 0.394105>,
		<2.05696, 0.0206704, 0.393879>,
		<2.05696, 0.0207718, 0.0879011>,
		<2.05696, 0.0678139, 0.0879701>,
		<2.05696, 0.0667142, 0.871863>,
		<2.05696, 0.0204052, 0.87144>,
		<2.05696, 0.0205431, 0.661569>,
		<2.05696, 0.0671279, 0.661916>,
		<2.05696, 0.0659252, 1.23886>,
		<2.05696, 0.0201422, 1.23837>,
		<2.05696, 0.0202682, 1.05795>,
		<2.05696, 0.0663034, 1.05842>,
		<2.05696, 0.0653227, 1.58554>,
		<2.05696, 0.0199414, 1.58517>,
		<2.05696, 0.0200351, 1.41279>,
		<2.05696, 0.065604, 1.41324>,
		<1.79348, 0.0650988, 2.04294>,
		<1.79321, 0.0198667, 2.04294>,
		<1.96865, 0.0197394, 2.04294>,
		<1.96875, 0.0647169, 2.04294>,
		<2.05696, 0.064688, 1.94903>,
		<2.05696, 0.0197298, 1.94894>,
		<2.05696, 0.0198415, 1.7634>,
		<2.05696, 0.0650232, 1.76364>,
		<1.97376, 0.0907489, 1.17905>,
		<1.98474, 0.0917865, 1.00489>,
		<1.83104, 0.0974845, 0.898675>,
		<1.80131, 0.0952924, 1.06019>,
		<1.95124, 0.0888329, 1.5155>,
		<1.96366, 0.0897359, 1.34695>,
		<1.77376, 0.0930273, 1.21519>,
		<1.7429, 0.0909814, 1.36895>,
		<1.73557, 0.0882183, 1.90327>,
		<1.94231, 0.0875469, 1.91927>,
		<1.92972, 0.0881558, 1.69865>,
		<1.69683, 0.0896383, 1.53233>,
		<1.58736, 0.0896521, 1.64553>,
		<1.39553, 0.0897998, 1.93593>,
		<1.5599, 0.0889165, 1.92434>,
		<1.43178, 0.0910069, 1.68992>,
		<1.28462, 0.0930405, 1.71848>,
		<1.06029, 0.0917808, 1.95554>,
		<1.23091, 0.0907792, 1.94516>,
		<1.13594, 0.0952841, 1.74388>,
		<0.98082, 0.0974479, 1.77232>,
		<0.700921, 0.0936769, 1.9786>,
		<0.883705, 0.0927456, 1.967>,
		<0.819417, 0.0994206, 1.80353>,
		<0.650545, 0.10131, 1.83605>,
		<0.317614, 0.0955368, 1.99595>,
		<0.511419, 0.0946402, 1.98857>,
		<0.471682, 0.103444, 1.86715>,
		<0.288149, 0.105574, 1.89329>,
		<-0.0661485, 0.0962105, 2.0024>,
		<0.124852, 0.0961043, 2.00058>,
		<0.113112, 0.106882, 1.91006>,
		<-0.0542716, 0.106968, 1.91527>,
		<-0.454209, 0.0951575, 1.99743>,
		<-0.259294, 0.0958541, 2.0014>,
		<-0.228852, 0.105852, 1.90899>,
		<-0.412228, 0.103937, 1.89274>,
		<-0.832948, 0.0935704, 1.98042>,
		<-0.646233, 0.0943673, 1.99015>,
		<-0.592748, 0.102013, 1.86952>,
		<-0.765286, 0.100306, 1.84257>,
		<-1.18971, 0.0917328, 1.9609>,
		<-1.01417, 0.092694, 1.97031>,
		<-0.931238, 0.0984768, 1.81536>,
		<-1.09116, 0.0964117, 1.78981>,
		<-1.5313, 0.0898076, 1.94143>,
		<-1.35932, 0.090749, 1.95232>,
		<-1.24477, 0.0942212, 1.76633>,
		<-1.39834, 0.0921954, 1.7393>,
		<-1.31286, 0.0976135, 1.35184>,
		<-1.47606, 0.0938937, 1.43444>,
		<-1.39652, 0.0937965, 1.50789>,
		<-1.30997, 0.102183, 1.21904>,
		<-1.34143, 0.107656, 1.09652>,
		<-1.5479, 0.100304, 1.18441>,
		<-1.51052, 0.096564, 1.31261>,
		<-1.38677, 0.113355, 0.972943>,
		<-1.43526, 0.118828, 0.84274>,
		<-1.6331, 0.108263, 0.907844>,
		<-1.5888, 0.104358, 1.04951>,
		<-1.48589, 0.123848, 0.706077>,
		<-1.55066, 0.128627, 0.558207>,
		<-1.73442, 0.115251, 0.601282>,
		<-1.68008, 0.111845, 0.759621>,
		<-1.65458, 0.133816, 0.389466>,
		<-1.79354, 0.139829, 0.205127>,
		<-1.88394, 0.122526, 0.242291>,
		<-1.80633, 0.118948, 0.425508>,
		<-1.87787, 0.143413, 0.0567272>,
		<-1.88398, 0.143503, -0.051429>,
		<-1.93905, 0.124888, -0.0649359>,
		<-1.93334, 0.124704, 0.0789366>,
		<-1.81806, 0.140402, -0.187565>,
		<-1.70298, 0.135164, -0.351782>,
		<-1.84388, 0.120162, -0.385005>,
		<-1.90399, 0.12317, -0.217395>,
		<-1.61884, 0.130668, -0.509695>,
		<-1.56808, 0.126455, -0.658851>,
		<-1.74397, 0.114019, -0.71366>,
		<-1.78725, 0.116998, -0.552826>,
		<-1.52758, 0.121905, -0.801117>,
		<-1.48644, 0.116816, -0.9372>,
		<-1.66713, 0.107118, -1.01606>,
		<-1.70524, 0.110772, -0.868058>,
		<-1.446, 0.111406, -1.06664>,
		<-1.41608, 0.106056, -1.19519>,
		<-1.59545, 0.0995592, -1.29187>,
		<-1.6305, 0.103229, -1.15721>,
		<-1.41496, 0.101312, -1.33479>,
		<-1.48562, 0.0968883, -1.50053>,
		<-1.56126, 0.0968477, -1.42119>,
		<-1.28823, 0.10616, -1.32923>,
		<-1.16902, 0.111658, -1.35862>,
		<-1.23846, 0.10349, -1.56889>,
		<-1.36523, 0.0996965, -1.53343>,
		<-1.04754, 0.117241, -1.40172>,
		<-0.918942, 0.122509, -1.44763>,
		<-0.963934, 0.111336, -1.64838>,
		<-1.10477, 0.107525, -1.60722>,
		<-0.78327, 0.127228, -1.49583>,
		<-0.645835, 0.13154, -1.55819>,
		<-0.667707, 0.11783, -1.74305>,
		<-0.816072, 0.114739, -1.69203>,
		<-0.517196, 0.135958, -1.65897>,
		<-0.39973, 0.140949, -1.79427>,
		<-0.411283, 0.123869, -1.88766>,
		<-0.531784, 0.120985, -1.8116>,
		<-0.296084, 0.143794, -1.88099>,
		<-0.192271, 0.14353, -1.89598>,
		<-0.16883, 0.125156, -1.95519>,
		<-0.299223, 0.125437, -1.94108>,
		<-0.0122458, 0.140056, -1.83874>,
		<0.229004, 0.134387, -1.72875>,
		<0.272753, 0.119572, -1.86901>,
		<0.0264624, 0.123009, -1.92682>,
		<0.436911, 0.129464, -1.64459>,
		<0.600897, 0.124848, -1.59028>,
		<0.671557, 0.112718, -1.76383>,
		<0.495678, 0.116021, -1.81105>,
		<0.745956, 0.11995, -1.54445>,
		<0.884406, 0.114584, -1.49749>,
		<0.976518, 0.105369, -1.67631>,
		<0.827394, 0.109216, -1.7199>,
		<1.01589, 0.10896, -1.45148>,
		<1.1466, 0.103502, -1.4168>,
		<1.25384, 0.0975922, -1.59543>,
		<1.11858, 0.101342, -1.63465>,
		<1.28931, 0.098839, -1.4121>,
		<1.4599, 0.0947837, -1.4807>,
		<1.38313, 0.0948695, -1.55815>,
		<1.9529, 0.0911628, -1.41915>,
		<1.94171, 0.0901938, -1.58568>,
		<1.71347, 0.0929238, -1.46985>,
		<1.74097, 0.0950194, -1.32235>,
		<1.97103, 0.0931573, -1.08051>,
		<1.96151, 0.0921661, -1.25296>,
		<1.76467, 0.0972878, -1.17374>,
		<1.79078, 0.0994404, -1.0186>,
		<1.99199, 0.094882, -0.732877>,
		<1.98146, 0.0940684, -0.901904>,
		<1.81925, 0.101356, -0.857138>,
		<1.84886, 0.103119, -0.70236>,
		<2.00811, 0.0962447, -0.504953>,
		<2.00102, 0.0956314, -0.604783>,
		<1.87727, 0.105017, -0.580085>,
		<1.90234, 0.106821, -0.481833>,
		<2.01811, 0.0964161, -0.18776>,
		<2.01399, 0.0965452, -0.376701>,
		<1.9221, 0.107782, -0.364832>,
		<1.93329, 0.107522, -0.199163>,
		<2.01495, 0.0948201, 0.363604>,
		<2.01869, 0.0958, 0.0697204>,
		<1.93136, 0.106031, 0.0322426>,
		<1.9161, 0.103729, 0.302835>,
		<1.99627, 0.0927935, 0.824584>,
		<2.00708, 0.0937798, 0.621772>,
		<1.89163, 0.101468, 0.542452>,
		<1.86196, 0.0995024, 0.731044>,
		<-1.82493, -0.00274934, -2.09587>,
		<-1.99839, -0.00274934, -2.09587>,
		<-2.08539, -0.00274934, -1.99692>,
		<-2.08539, -0.00274934, -1.80236>,
		<-2.08539, -0.00274934, -1.61778>,
		<-2.08539, -0.00274934, -1.44153>,
		<-2.08539, -0.00274934, -1.26364>,
		<-2.08539, -0.00274934, -1.07909>,
		<-2.08539, -0.00274934, -0.887751>,
		<-2.08539, -0.00274934, -0.690066>,
		<-2.08539, -0.00274934, -0.487014>,
		<-2.08539, -0.00274934, -0.280033>,
		<-2.08539, -0.00274934, -0.0710252>,
		<-2.08539, -0.00274934, 0.138006>,
		<-2.08539, -0.00274934, 0.344949>,
		<-2.08539, -0.00274934, 0.548001>,
		<-2.08539, -0.00274934, 0.745667>,
		<-2.08539, -0.00274934, 0.936954>,
		<-2.08539, -0.00274934, 1.12137>,
		<-2.08539, -0.00274934, 1.29889>,
		<-2.08539, -0.00274934, 1.46995>,
		<-2.08539, -0.00274934, 1.63599>,
		<-1.98311, -0.00274934, 2.04294>,
		<-1.78258, -0.00274934, 2.04294>,
		<-2.08539, -0.00274934, 1.79945>,
		<-2.08539, -0.00274934, 1.96189>,
		<-1.48136, -0.00274934, -2.09587>,
		<-1.65312, -0.00274934, -2.09587>,
		<-1.59417, -0.00274934, 2.04294>,
		<-1.41648, -0.00274934, 2.04294>,
		<-1.1227, -0.00274934, -2.09587>,
		<-1.30529, -0.00274934, -2.09587>,
		<-1.2386, -0.00274934, 2.04294>,
		<-1.05516, -0.00274934, 2.04294>,
		<-0.747065, -0.00274934, -2.09587>,
		<-0.93346, -0.00274934, -2.09587>,
		<-0.866287, -0.00274934, 2.04294>,
		<-0.67247, -0.00274934, 2.04294>,
		<-0.441199, -0.00274934, -2.09587>,
		<-0.582618, -0.00274934, -2.09587>,
		<-0.474549, -0.00274934, 2.04294>,
		<-0.273635, -0.00274934, 2.04294>,
		<-0.142086, -0.00274934, -2.09587>,
		<-0.305857, -0.00274934, -2.09587>,
		<-0.0711149, -0.00274934, 2.04294>,
		<0.131552, -0.00274934, 2.04294>,
		<0.406795, -0.00274934, -2.09587>,
		<0.10218, -0.00274934, -2.09587>,
		<0.33283, -0.00274934, 2.04294>,
		<0.531346, -0.00274934, 2.04294>,
		<0.891665, -0.00274934, -2.09587>,
		<0.679399, -0.00274934, -2.09587>,
		<0.725894, -0.00274934, 2.04294>,
		<0.915572, -0.00274934, 2.04294>,
		<1.26029, -0.00274934, -2.09587>,
		<1.0793, -0.00274934, -2.09587>,
		<1.09979, -0.00274934, 2.04294>,
		<1.27829, -0.00274934, 2.04294>,
		<1.60685, -0.00274934, -2.09587>,
		<1.43493, -0.00274934, -2.09587>,
		<1.45117, -0.00274934, 2.04294>,
		<1.62106, -0.00274934, 2.04294>,
		<2.05696, -0.00274934, -1.81852>,
		<2.05696, -0.00274934, -2.00271>,
		<1.965, -0.00274934, -2.09587>,
		<1.78302, -0.00274934, -2.09587>,
		<2.05696, -0.00274934, -1.46773>,
		<2.05696, -0.00274934, -1.64069>,
		<2.05696, -0.00274934, -1.11114>,
		<2.05696, -0.00274934, -1.29242>,
		<2.05696, -0.00274934, -0.747718>,
		<2.05696, -0.00274934, -0.923867>,
		<2.05696, -0.00274934, -0.516704>,
		<2.05696, -0.00274934, -0.61693>,
		<2.05696, -0.00274934, -0.182807>,
		<2.05696, -0.00274934, -0.3832>,
		<2.05696, -0.00274934, 0.393766>,
		<2.05696, -0.00274934, 0.0878666>,
		<2.05696, -0.00274934, 0.871229>,
		<2.05696, -0.00274934, 0.661395>,
		<2.05696, -0.00274934, 1.23813>,
		<2.05696, -0.00274934, 1.05772>,
		<2.05696, -0.00274934, 1.58499>,
		<2.05696, -0.00274934, 1.41256>,
		<1.79307, -0.00274934, 2.04294>,
		<1.96861, -0.00274934, 2.04294>,
		<2.05696, -0.00274934, 1.9489>,
		<2.05696, -0.00274934, 1.76327>,
		<-1.57829, 0.0980375, -1.35712>,
		<-1.41078, 0.103574, -1.26286>,
		<-1.55371, 0.0937527, -1.73275>,
		<-1.68223, 0.0908145, -1.97085>,
		<-1.82557, 0.0891085, -2.09587>,
		<-1.99861, 0.0879983, -2.09587>,
		<-2.08539, 0.0880126, -1.99712>,
		<-2.08539, 0.089136, -1.80293>,
		<-1.64857, 0.105192, -1.08752>,
		<-1.46605, 0.114138, -1.00278>,
		<-1.36391, 0.115747, -1.04062>,
		<-1.33695, 0.109553, -1.17029>,
		<-2.08539, 0.0900533, -1.61864>,
		<-2.08539, 0.0907751, -1.44257>,
		<-1.72459, 0.112457, -0.791629>,
		<-1.54799, 0.12426, -0.730728>,
		<-1.44629, 0.127655, -0.782955>,
		<-1.40494, 0.121876, -0.915128>,
		<-2.08539, 0.0914594, -1.26474>,
		<-2.08539, 0.0921603, -1.08013>,
		<-1.81335, 0.118529, -0.469823>,
		<-1.6553, 0.132842, -0.43195>,
		<-1.53906, 0.137622, -0.49886>,
		<-1.48642, 0.132843, -0.64454>,
		<-2.08539, 0.0928276, -0.888668>,
		<-2.08539, 0.0934079, -0.690823>,
		<-1.92643, 0.124261, -0.138338>,
		<-1.86543, 0.142598, -0.112112>,
		<-1.77347, 0.148755, -0.176873>,
		<-1.63315, 0.142599, -0.343427>,
		<-2.08539, 0.0938442, -0.487574>,
		<-2.08539, 0.0940919, -0.280367>,
		<-1.91428, 0.12387, 0.156424>,
		<-1.85166, 0.142343, 0.121256>,
		<-1.8613, 0.153605, -0.0416692>,
		<-1.85566, 0.153594, 0.0431385>,
		<-2.08539, 0.0941191, -0.0711156>,
		<-2.08539, 0.0939181, 0.138162>,
		<-1.76755, 0.117034, 0.516032>,
		<-1.59617, 0.13113, 0.477049>,
		<-1.58067, 0.141192, 0.377904>,
		<-1.74772, 0.148233, 0.189007>,
		<-2.08539, 0.0935052, 0.345342>,
		<-2.08539, 0.0929163, 0.548608>,
		<-1.65631, 0.110105, 0.834539>,
		<-1.46037, 0.121409, 0.775205>,
		<-1.39731, 0.130044, 0.690317>,
		<-1.46509, 0.135452, 0.545298>,
		<-2.08539, 0.0922062, 0.746455>,
		<-2.08539, 0.0914323, 0.937884>,
		<-1.56787, 0.102339, 1.11782>,
		<-1.36364, 0.110519, 1.03557>,
		<-1.29727, 0.118099, 0.950192>,
		<-1.34635, 0.124324, 0.82354>,
		<-2.08539, 0.0906543, 1.12241>,
		<-2.08539, 0.0899217, 1.29997>,
		<-1.49296, 0.0950479, 1.3743>,
		<-1.30585, 0.0997433, 1.28345>,
		<-1.22317, 0.105295, 1.19387>,
		<-1.25116, 0.111627, 1.07014>,
		<-2.08539, 0.0892732, 1.47097>,
		<-2.08539, 0.0886888, 1.63683>,
		<-1.98329, 0.0875337, 2.04294>,
		<-1.78312, 0.0882994, 2.04294>,
		<-1.33301, 0.0948395, 1.52206>,
		<-1.24248, 0.0996243, 1.34253>,
		<-2.08539, 0.0880895, 1.8>,
		<-2.08539, 0.0874493, 1.96208>,
		<-1.27047, 0.109614, -1.24029>,
		<-1.15091, 0.115966, -1.2662>,
		<-1.2571, 0.0984648, -1.79836>,
		<-1.34849, 0.0934352, -1.99793>,
		<-1.48251, 0.0908655, -2.09587>,
		<-1.65409, 0.0900587, -2.09587>,
		<-1.31397, 0.123429, -0.972607>,
		<-1.19401, 0.132342, -0.997051>,
		<-1.11724, 0.132439, -1.07946>,
		<-1.09144, 0.123686, -1.20984>,
		<-1.39646, 0.136185, -0.712237>,
		<-1.27599, 0.147405, -0.736746>,
		<-1.19886, 0.149062, -0.825603>,
		<-1.15809, 0.140926, -0.95665>,
		<-1.51156, 0.146825, -0.422522>,
		<-1.38959, 0.159592, -0.44259>,
		<-1.28912, 0.162969, -0.537881>,
		<-1.23782, 0.156485, -0.686646>,
		<-1.67087, 0.169439, -0.103567>,
		<-1.80299, 0.158729, -0.0902661>,
		<-1.51943, 0.173076, -0.200482>,
		<-1.38276, 0.168425, -0.375181>,
		<-1.79131, 0.158721, 0.0802297>,
		<-1.65838, 0.169459, 0.068924>,
		<-1.57894, 0.156638, 0.0184998>,
		<-1.58539, 0.156621, -0.0684272>,
		<-1.44366, 0.144944, 0.459858>,
		<-1.3168, 0.157626, 0.462624>,
		<-1.32186, 0.166923, 0.373281>,
		<-1.48986, 0.172587, 0.168969>,
		<-1.29595, 0.132934, 0.751696>,
		<-1.16793, 0.143917, 0.762329>,
		<-1.13385, 0.153285, 0.7038>,
		<-1.20307, 0.160557, 0.55226>,
		<-1.19719, 0.119193, 1.00206>,
		<-1.0686, 0.127716, 1.01542>,
		<-1.03254, 0.136417, 0.968922>,
		<-1.08215, 0.145163, 0.840578>,
		<-1.15327, 0.105129, 1.25825>,
		<-1.02582, 0.111022, 1.27578>,
		<-0.960198, 0.118478, 1.21587>,
		<-0.986265, 0.127446, 1.08881>,
		<-1.59499, 0.0888944, 2.04294>,
		<-1.41747, 0.0893312, 2.04294>,
		<-1.06689, 0.10143, 1.58157>,
		<-0.98689, 0.10958, 1.38136>,
		<-1.03345, 0.122279, -1.31031>,
		<-0.908749, 0.128247, -1.35717>,
		<-0.944025, 0.103413, -1.85686>,
		<-1.00091, 0.0961521, -2.01896>,
		<-1.12382, 0.0925093, -2.09587>,
		<-1.30649, 0.0916685, -2.09587>,
		<-1.07894, 0.141028, -1.04203>,
		<-0.955083, 0.149369, -1.09018>,
		<-0.87158, 0.147904, -1.17564>,
		<-0.845922, 0.13683, -1.30479>,
		<-1.15865, 0.158351, -0.778546>,
		<-1.03044, 0.169098, -0.824346>,
		<-0.944608, 0.169197, -0.91896>,
		<-0.9082, 0.158655, -1.05233>,
		<-1.26381, 0.17214, -0.47566>,
		<-1.12254, 0.185188, -0.51313>,
		<-1.01944, 0.188272, -0.618631>,
		<-0.979223, 0.17928, -0.775445>,
		<-1.31597, 0.195141, -0.138904>,
		<-1.50914, 0.181568, -0.119614>,
		<-1.16644, 0.200061, -0.248989>,
		<-1.08163, 0.19515, -0.442297>,
		<-1.49588, 0.181619, 0.0555761>,
		<-1.30195, 0.195209, 0.0397849>,
		<-1.19328, 0.18262, -0.0148684>,
		<-1.2005, 0.182582, -0.105312>,
		<-1.18768, 0.170182, 0.470953>,
		<-1.04327, 0.183355, 0.477216>,
		<-1.01555, 0.193888, 0.375709>,
		<-1.13412, 0.199682, 0.149218>,
		<-1.04511, 0.154746, 0.784042>,
		<-0.911797, 0.165492, 0.804656>,
		<-0.865778, 0.176177, 0.738975>,
		<-0.925908, 0.186096, 0.573249>,
		<-0.947192, 0.136135, 1.04445>,
		<-0.817572, 0.144292, 1.07297>,
		<-0.771188, 0.153868, 1.02266>,
		<-0.817057, 0.165204, 0.886455>,
		<-0.902367, 0.116967, 1.30817>,
		<-0.772389, 0.122619, 1.3409>,
		<-0.703771, 0.13106, 1.27904>,
		<-0.729167, 0.142477, 1.14798>,
		<-1.23965, 0.0897487, 2.04294>,
		<-1.05614, 0.0901973, 2.04294>,
		<-0.776311, 0.108201, 1.64869>,
		<-0.719562, 0.119366, 1.44879>,
		<-0.77683, 0.133611, -1.40622>,
		<-0.642363, 0.138484, -1.47218>,
		<-0.622224, 0.107456, -1.92458>,
		<-0.64835, 0.0983979, -2.04236>,
		<-0.747874, 0.0940539, -2.09587>,
		<-0.934438, 0.0933311, -2.09587>,
		<-0.822304, 0.156981, -1.14085>,
		<-0.682439, 0.163558, -1.20993>,
		<-0.598811, 0.16024, -1.32347>,
		<-0.580362, 0.147621, -1.44964>,
		<-0.891285, 0.179371, -0.873281>,
		<-0.739753, 0.188466, -0.935056>,
		<-0.647219, 0.185453, -1.05313>,
		<-0.623312, 0.172597, -1.19561>,
		<-0.967906, 0.19918, -0.554291>,
		<-0.796993, 0.212376, -0.603032>,
		<-0.690615, 0.212392, -0.727311>,
		<-0.669034, 0.199288, -0.898232>,
		<-0.885819, 0.221371, -0.185016>,
		<-1.10744, 0.209262, -0.160605>,
		<-0.749432, 0.224405, -0.311953>,
		<-0.717178, 0.220866, -0.530943>,
		<-1.09265, 0.209291, 0.0221088>,
		<-0.870168, 0.221323, 0.00202547>,
		<-0.749582, 0.201928, -0.0573306>,
		<-0.757686, 0.201919, -0.152082>,
		<-0.885421, 0.19763, 0.480552>,
		<-0.70973, 0.211233, 0.480734>,
		<-0.642942, 0.220205, 0.366011>,
		<-0.713191, 0.224152, 0.118977>,
		<-0.76773, 0.175904, 0.822878>,
		<-0.608004, 0.185481, 0.841838>,
		<-0.539402, 0.197231, 0.769189>,
		<-0.584823, 0.211133, 0.58377>,
		<-0.679587, 0.151827, 1.09977>,
		<-0.528831, 0.158772, 1.13397>,
		<-0.46292, 0.168771, 1.08889>,
		<-0.499729, 0.182505, 0.935661>,
		<-0.635983, 0.127745, 1.37279>,
		<-0.48948, 0.132785, 1.41346>,
		<-0.410195, 0.1425, 1.36468>,
		<-0.430157, 0.155653, 1.2269>,
		<-0.867144, 0.090639, 2.04294>,
		<-0.673172, 0.0910341, 2.04294>,
		<-0.456629, 0.114255, 1.72449>,
		<-0.419365, 0.128386, 1.53418>,
		<-0.514684, 0.143354, -1.5851>,
		<-0.395398, 0.149206, -1.74776>,
		<-0.362229, 0.110654, -1.9954>,
		<-0.370186, 0.0998153, -2.06332>,
		<-0.441676, 0.0948734, -2.09587>,
		<-0.583258, 0.0945743, -2.09587>,
		<-0.539304, 0.16887, -1.32984>,
		<-0.395146, 0.173148, -1.50001>,
		<-0.333143, 0.158878, -1.79066>,
		<-0.326702, 0.169381, -1.66567>,
		<-0.573079, 0.195252, -1.02995>,
		<-0.394012, 0.199882, -1.15728>,
		<-0.318505, 0.181332, -1.5116>,
		<-0.308203, 0.194797, -1.32617>,
		<-0.601853, 0.220857, -0.66784>,
		<-0.385564, 0.224333, -0.747881>,
		<-0.296277, 0.208946, -1.12426>,
		<-0.282207, 0.221188, -0.907704>,
		<-0.37064, 0.226862, -0.24578>,
		<-0.63961, 0.227246, -0.213574>,
		<-0.264477, 0.227177, -0.665324>,
		<-0.243435, 0.226846, -0.399386>,
		<-0.622839, 0.22715, -0.0220684>,
		<-0.352506, 0.226767, -0.0497716>,
		<-0.220025, 0.205312, -0.113762>,
		<-0.229461, 0.205312, -0.212971>,
		<-0.505534, 0.220134, 0.478171>,
		<-0.275961, 0.223997, 0.473702>,
		<-0.198961, 0.22664, 0.074152>,
		<-0.170519, 0.226899, 0.343652>,
		<-0.423059, 0.193469, 0.869092>,
		<-0.215615, 0.199983, 0.905398>,
		<-0.144018, 0.22134, 0.591394>,
		<-0.119714, 0.209839, 0.816704>,
		<-0.356648, 0.165558, 1.19503>,
		<-0.165147, 0.172387, 1.28352>,
		<-0.0968304, 0.196025, 1.03274>,
		<-0.075673, 0.182288, 1.23833>,
		<-0.325443, 0.138854, 1.48332>,
		<-0.141254, 0.147021, 1.58376>,
		<-0.0576325, 0.169781, 1.41791>,
		<-0.042451, 0.158626, 1.57219>,
		<-0.475067, 0.0913407, 2.04294>,
		<-0.273946, 0.0915256, 2.04294>,
		<-0.112728, 0.121281, 1.80298>,
		<-0.0733866, 0.141008, 1.68458>,
		<-0.20943, 0.153517, -1.87063>,
		<-0.293857, 0.153751, -1.85574>,
		<-0.0617185, 0.110215, -2.01518>,
		<-0.0425997, 0.0996041, -2.07046>,
		<-0.14221, 0.0949893, -2.09587>,
		<-0.306173, 0.0950171, -2.09587>,
		<-0.27823, 0.156809, -1.57927>,
		<-0.19118, 0.156626, -1.59895>,
		<-0.154495, 0.168977, -1.7037>,
		<-0.16325, 0.158428, -1.82359>,
		<-0.255414, 0.182614, -1.20641>,
		<-0.164593, 0.182528, -1.22402>,
		<-0.12919, 0.194552, -1.36342>,
		<-0.143275, 0.181, -1.55106>,
		<-0.224923, 0.201921, -0.774771>,
		<-0.12998, 0.201908, -0.789187>,
		<-0.094722, 0.221016, -0.938249>,
		<-0.113079, 0.208755, -1.15813>,
		<-0.184416, 0.205312, -0.268574>,
		<-0.0848912, 0.205312, -0.280571>,
		<-0.0478359, 0.226733, -0.423317>,
		<-0.0728405, 0.227026, -0.692563>,
		<-0.165176, 0.205312, -0.0696201>,
		<-0.0649146, 0.205312, -0.0805459>,
		<-0.01987, 0.205312, -0.136149>,
		<-0.0300424, 0.205312, -0.236429>,
		<-0.108216, 0.202057, 0.461327>,
		<-0.00974983, 0.202064, 0.451507>,
		<0.0272244, 0.226829, 0.32366>,
		<-0.000370325, 0.226557, 0.0531006>,
		<-0.060933, 0.183266, 0.9146>,
		<0.0348185, 0.183305, 0.904999>,
		<0.073381, 0.209878, 0.797576>,
		<0.0519312, 0.221314, 0.572071>,
		<-0.0208231, 0.157067, 1.32139>,
		<0.071337, 0.157114, 1.31136>,
		<0.110217, 0.182381, 1.21855>,
		<0.0927611, 0.196106, 1.01342>,
		<0.0091779, 0.153302, 1.6398>,
		<0.0982073, 0.153358, 1.6292>,
		<0.137038, 0.158732, 1.55128>,
		<0.124853, 0.169878, 1.39759>,
		<-0.0712059, 0.0915641, 2.04294>,
		<0.131685, 0.0914485, 2.04294>,
		<0.182261, 0.121143, 1.78705>,
		<0.164544, 0.140967, 1.66481>,
		<-0.029196, 0.148332, -1.7942>,
		<0.215261, 0.141751, -1.65956>,
		<0.455019, 0.10617, -1.96637>,
		<0.520431, 0.097569, -2.05688>,
		<0.407277, 0.0941228, -2.09587>,
		<0.102333, 0.0946927, -2.09587>,
		<-0.021583, 0.172383, -1.55668>,
		<0.221139, 0.167369, -1.41823>,
		<0.322011, 0.15836, -1.42162>,
		<0.316812, 0.145693, -1.53995>,
		<0.0077359, 0.199366, -1.21423>,
		<0.254342, 0.194149, -1.12603>,
		<0.356318, 0.183944, -1.16282>,
		<0.338132, 0.170864, -1.3>,
		<0.046883, 0.224023, -0.802224>,
		<0.299168, 0.22026, -0.769132>,
		<0.400314, 0.211493, -0.845447>,
		<0.376326, 0.198068, -1.01219>,
		<0.369269, 0.226978, -0.324292>,
		<0.102395, 0.22667, -0.298458>,
		<0.473488, 0.22409, -0.444433>,
		<0.432843, 0.220274, -0.655163>,
		<0.123897, 0.226586, -0.10007>,
		<0.393499, 0.22689, -0.127285>,
		<0.509497, 0.202043, -0.188449>,
		<0.496702, 0.20204, -0.286399>,
		<0.166601, 0.223829, 0.432844>,
		<0.410198, 0.219717, 0.39727>,
		<0.522622, 0.219736, 0.261008>,
		<0.521618, 0.223874, -0.00235131>,
		<0.196451, 0.199821, 0.868671>,
		<0.414313, 0.192845, 0.799337>,
		<0.518007, 0.196426, 0.682454>,
		<0.521784, 0.210483, 0.490309>,
		<0.215513, 0.172218, 1.24884>,
		<0.404403, 0.164876, 1.13273>,
		<0.499065, 0.167838, 1.01207>,
		<0.510324, 0.181603, 0.853954>,
		<0.231251, 0.146873, 1.55188>,
		<0.40016, 0.138266, 1.43006>,
		<0.478195, 0.141665, 1.29813>,
		<0.485847, 0.154747, 1.15481>,
		<0.33318, 0.0911877, 2.04294>,
		<0.531899, 0.0908054, 2.04294>,
		<0.521208, 0.113609, 1.67833>,
		<0.48953, 0.127647, 1.4759>,
		<0.418548, 0.136332, -1.56569>,
		<0.579011, 0.131113, -1.50963>,
		<0.843225, 0.101809, -1.90105>,
		<0.938954, 0.0950366, -2.03386>,
		<0.892567, 0.0925067, -2.09587>,
		<0.680143, 0.0933681, -2.09587>,
		<0.425754, 0.161475, -1.32143>,
		<0.59012, 0.154491, -1.26538>,
		<0.651232, 0.145207, -1.29962>,
		<0.641326, 0.134137, -1.41813>,
		<0.466341, 0.186848, -1.0592>,
		<0.640882, 0.177321, -1.01291>,
		<0.704881, 0.166824, -1.05919>,
		<0.676974, 0.156079, -1.18461>,
		<0.5212, 0.211496, -0.73942>,
		<0.709889, 0.198007, -0.712272>,
		<0.771482, 0.186604, -0.775996>,
		<0.734589, 0.177181, -0.923022>,
		<0.834013, 0.209854, -0.361479>,
		<0.613512, 0.221399, -0.345479>,
		<0.899827, 0.200284, -0.452406>,
		<0.826697, 0.194262, -0.618215>,
		<0.640627, 0.221339, -0.150946>,
		<0.864291, 0.209827, -0.170613>,
		<0.957788, 0.183243, -0.226356>,
		<0.941782, 0.183249, -0.320785>,
		<0.625335, 0.210509, 0.367251>,
		<0.808774, 0.196523, 0.343292>,
		<0.909529, 0.192961, 0.216403>,
		<0.949737, 0.199826, -0.0430187>,
		<0.606586, 0.184372, 0.745251>,
		<0.770295, 0.174291, 0.706978>,
		<0.855833, 0.174342, 0.612154>,
		<0.878591, 0.184502, 0.435708>,
		<0.574547, 0.157616, 1.04905>,
		<0.723739, 0.150242, 0.998222>,
		<0.806671, 0.152036, 0.910854>,
		<0.832893, 0.16333, 0.766996>,
		<0.556852, 0.131809, 1.34224>,
		<0.699021, 0.12643, 1.2882>,
		<0.763169, 0.129489, 1.18348>,
		<0.779328, 0.140749, 1.04371>,
		<0.726624, 0.0903397, 2.04294>,
		<0.916451, 0.0898322, 2.04294>,
		<0.833124, 0.107073, 1.58416>,
		<0.780645, 0.118008, 1.36604>,
		<0.720832, 0.125534, -1.46422>,
		<0.855937, 0.119435, -1.41701>,
		<1.16687, 0.0968377, -1.83778>,
		<1.28823, 0.0922631, -2.0109>,
		<1.26133, 0.0907223, -2.09587>,
		<1.0803, 0.0916057, -2.09587>,
		<0.735359, 0.146584, -1.2205>,
		<0.871974, 0.138026, -1.17325>,
		<0.921172, 0.129344, -1.20529>,
		<0.908739, 0.120676, -1.32392>,
		<0.795333, 0.166671, -0.97117>,
		<0.938443, 0.155599, -0.927278>,
		<0.987905, 0.146106, -0.969556>,
		<0.953456, 0.137871, -1.09164>,
		<0.879229, 0.183679, -0.683798>,
		<1.03519, 0.170262, -0.653203>,
		<1.07222, 0.160529, -0.704102>,
		<1.02402, 0.153674, -0.838941>,
		<1.24145, 0.182586, -0.384932>,
		<1.04363, 0.196113, -0.374306>,
		<1.26849, 0.173163, -0.450116>,
		<1.15383, 0.166954, -0.573777>,
		<1.07749, 0.196055, -0.187778>,
		<1.2781, 0.182427, -0.202841>,
		<1.35326, 0.157302, -0.25414>,
		<1.33475, 0.15741, -0.344249>,
		<0.973019, 0.18179, 0.322696>,
		<1.12341, 0.168125, 0.304206>,
		<1.2288, 0.165188, 0.182505>,
		<1.31878, 0.17241, -0.0737933>,
		<0.916543, 0.163376, 0.675479>,
		<1.05126, 0.152158, 0.646331>,
		<1.12931, 0.150455, 0.559483>,
		<1.16596, 0.157931, 0.394255>,
		<0.860062, 0.142309, 0.95954>,
		<0.987742, 0.133784, 0.922896>,
		<1.06551, 0.133811, 0.840373>,
		<1.09881, 0.14241, 0.703941>,
		<0.831917, 0.120999, 1.24656>,
		<0.958169, 0.115073, 1.20699>,
		<1.01288, 0.116311, 1.10554>,
		<1.03148, 0.125033, 0.968517>,
		<1.10079, 0.0893283, 2.04294>,
		<1.27935, 0.0888667, 2.04294>,
		<1.11468, 0.0999686, 1.5076>,
		<1.03992, 0.107744, 1.28604>,
		<0.983995, 0.113055, -1.37029>,
		<1.11658, 0.106741, -1.33834>,
		<1.47542, 0.0922294, -1.76761>,
		<1.62726, 0.08974, -1.98229>,
		<1.60765, 0.0891303, -2.09587>,
		<1.4359, 0.0899032, -2.09587>,
		<0.999852, 0.129194, -1.1261>,
		<1.13605, 0.12026, -1.09471>,
		<1.20096, 0.112683, -1.15132>,
		<1.18409, 0.106632, -1.27014>,
		<1.07034, 0.144399, -0.883787>,
		<1.20875, 0.133047, -0.852375>,
		<1.27235, 0.124522, -0.911765>,
		<1.23556, 0.118759, -1.03489>,
		<1.17573, 0.157379, -0.622788>,
		<1.31658, 0.144348, -0.599666>,
		<1.36137, 0.13473, -0.653416>,
		<1.31089, 0.129723, -0.781964>,
		<1.55862, 0.159412, -0.399892>,
		<1.41274, 0.170326, -0.39328>,
		<1.56022, 0.148209, -0.447816>,
		<1.44456, 0.140532, -0.541978>,
		<1.44889, 0.170056, -0.21511>,
		<1.59083, 0.159045, -0.225025>,
		<1.64958, 0.153869, -0.27292>,
		<1.63475, 0.154076, -0.359579>,
		<1.25815, 0.15512, 0.287998>,
		<1.39292, 0.142084, 0.283257>,
		<1.50922, 0.1387, 0.178417>,
		<1.60308, 0.147289, -0.0800951>,
		<1.17522, 0.140925, 0.619727>,
		<1.30487, 0.129689, 0.609378>,
		<1.39911, 0.126685, 0.547949>,
		<1.4411, 0.132184, 0.38756>,
		<1.10715, 0.125054, 0.888799>,
		<1.23327, 0.116358, 0.875267>,
		<1.32682, 0.115148, 0.822512>,
		<1.36393, 0.121144, 0.688216>,
		<1.07778, 0.1089, 1.17018>,
		<1.20068, 0.102884, 1.15207>,
		<1.26694, 0.102892, 1.08378>,
		<1.28963, 0.108932, 0.950504>,
		<1.45218, 0.0884804, 2.04294>,
		<1.62189, 0.0881321, 2.04294>,
		<1.37062, 0.0932418, 1.44503>,
		<1.28606, 0.0975887, 1.24584>,
		<1.69441, 0.0920833, -1.54662>,
		<1.93296, 0.0897301, -1.67324>,
		<2.05696, 0.0884371, -1.81912>,
		<2.05696, 0.0875111, -2.00292>,
		<1.96519, 0.087451, -2.09587>,
		<1.78355, 0.0883202, -2.09587>,
		<1.75252, 0.0961605, -1.24887>,
		<1.95709, 0.0916617, -1.33685>,
		<2.05696, 0.089555, -1.46883>,
		<2.05696, 0.0891133, -1.6416>,
		<1.80472, 0.100435, -0.938647>,
		<1.97613, 0.0936271, -0.991969>,
		<2.05696, 0.0904046, -1.1122>,
		<2.05696, 0.0899594, -1.29356>,
		<1.86336, 0.104033, -0.635546>,
		<1.99679, 0.0952627, -0.661754>,
		<2.05696, 0.0912337, -0.748482>,
		<2.05696, 0.0908493, -0.924783>,
		<1.91301, 0.107454, -0.428349>,
		<2.01116, 0.0964451, -0.447923>,
		<2.05696, 0.091581, -0.517235>,
		<2.05696, 0.0914789, -0.61757>,
		<1.93425, 0.106931, -0.0927436>,
		<2.01895, 0.0961725, -0.0680779>,
		<2.05696, 0.0915598, -0.182961>,
		<2.05696, 0.0916114, -0.38358>,
		<1.90476, 0.10254, 0.430901>,
		<2.01152, 0.0942885, 0.50166>,
		<2.05696, 0.0909297, 0.394218>,
		<2.05696, 0.091335, 0.0880046>,
		<1.84641, 0.0985215, 0.815601>,
		<1.99046, 0.0922972, 0.915496>,
		<2.05696, 0.0898686, 0.872074>,
		<2.05696, 0.0904204, 0.66209>,
		<1.7872, 0.0941626, 1.13853>,
		<1.96858, 0.0902359, 1.26379>,
		<2.05696, 0.0888167, 1.2391>,
		<2.05696, 0.089321, 1.05866>,
		<1.72251, 0.0901918, 1.44876>,
		<1.94204, 0.0884589, 1.60438>,
		<2.05696, 0.0880134, 1.58573>,
		<2.05696, 0.0883884, 1.41347>,
		<1.79362, 0.0877148, 2.04294>,
		<1.9688, 0.0872056, 2.04294>,
		<2.05696, 0.0871671, 1.94907>,
		<2.05696, 0.087614, 1.76376>,
		<-1.7865, 0.14019, 0.0796587>,
		<-1.65265, 0.150827, 0.0683278>,
		<-1.79823, 0.140197, -0.0909149>,
		<-1.66516, 0.150808, -0.104273>,
		<-1.85126, 0.135127, 0.0425545>,
		<-1.85693, 0.135137, -0.0422855>,
		<-1.48877, 0.162966, 0.0548998>,
		<-1.29358, 0.176192, 0.039011>,
		<-1.50206, 0.162916, -0.120448>,
		<-1.30762, 0.176117, -0.139891>,
		<-1.08448, 0.188671, 0.0213323>,
		<-0.863967, 0.198551, 0.00138231>,
		<-1.0993, 0.188604, -0.161628>,
		<-0.879656, 0.198519, -0.185905>,
		<-0.619563, 0.20396, -0.0224726>,
		<-0.352569, 0.205312, -0.0498688>,
		<-0.636368, 0.203953, -0.214198>,
		<-0.370726, 0.205312, -0.246054>,
		<-0.15299, 0.15076, -1.68129>,
		<-0.161993, 0.140238, -1.80443>,
		<-0.292947, 0.13559, -1.83773>,
		<-0.208368, 0.135353, -1.85294>,
		<-0.325646, 0.151161, -1.64313>,
		<-0.332238, 0.140691, -1.77103>,
		<-0.127131, 0.176027, -1.33503>,
		<-0.141487, 0.162823, -1.52535>,
		<-0.306747, 0.176249, -1.29806>,
		<-0.31727, 0.163146, -1.48601>,
		<-0.0926786, 0.198491, -0.912015>,
		<-0.110881, 0.188542, -1.12905>,
		<-0.280435, 0.198542, -0.881722>,
		<-0.294539, 0.188668, -1.09554>,
		<-0.0475314, 0.205312, -0.417971>,
		<-0.0714443, 0.203948, -0.674462>,
		<-0.244237, 0.205312, -0.392852>,
		<-0.263547, 0.203958, -0.646956>,
		<0.0267212, 0.204014, 0.319571>,
		<-0.000642225, 0.205312, 0.0515179>,
		<-0.171223, 0.204008, 0.339639>,
		<-0.200349, 0.205312, 0.0727279>,
		<0.072795, 0.189249, 0.791873>,
		<0.0513255, 0.198823, 0.566622>,
		<-0.120288, 0.189186, 0.811021>,
		<-0.144464, 0.198794, 0.585975>,
		<0.109691, 0.163576, 1.21271>,
		<0.0922179, 0.17691, 1.00773>,
		<-0.0764054, 0.163483, 1.23251>,
		<-0.0975445, 0.176823, 1.02707>,
		<0.00846677, 0.134856, 1.63326>,
		<0.0975889, 0.134911, 1.62264>,
		<0.136481, 0.140193, 1.54487>,
		<0.12432, 0.151174, 1.3915>,
		<-0.0431965, 0.140087, 1.56582>,
		<-0.058361, 0.151076, 1.41185>,
		<0.122329, 0.205312, -0.100096>,
		<0.389445, 0.204005, -0.127118>,
		<0.100724, 0.205312, -0.299605>,
		<0.365239, 0.204003, -0.324342>,
		<0.635233, 0.198777, -0.150677>,
		<0.858661, 0.189164, -0.170333>,
		<0.60818, 0.198766, -0.345071>,
		<0.828405, 0.189157, -0.361198>,
		<1.07189, 0.176851, -0.187506>,
		<1.27241, 0.163621, -0.202565>,
		<1.03801, 0.176902, -0.374208>,
		<1.2357, 0.163779, -0.384856>,
		<1.443, 0.15135, -0.214821>,
		<1.58472, 0.140502, -0.224717>,
		<1.64331, 0.135419, -0.27264>,
		<1.62841, 0.135626, -0.359378>,
		<1.40678, 0.15162, -0.393171>,
		<1.5524, 0.14087, -0.399747>,
		<-1.58047, 0.170638, 0.0624336>,
		<-1.5773, 0.16131, 0.0621201>,
		<-1.84953, 0.139739, 0.0851165>,
		<-1.85174, 0.148972, 0.0854004>,
		<-1.86303, 0.148993, -0.0842312>,
		<-1.86085, 0.139759, -0.0845475>,
		<-1.5902, 0.161276, -0.111701>,
		<-1.59336, 0.170603, -0.111322>,
		<-1.19609, 0.197345, 0.030949>,
		<-1.19181, 0.187541, 0.0305519>,
		<-1.20623, 0.187469, -0.150277>,
		<-1.21049, 0.197283, -0.149763>,
		<-0.749136, 0.219437, -0.00955369>,
		<-0.746732, 0.207767, -0.00982117>,
		<-0.76293, 0.207774, -0.199265>,
		<-0.765315, 0.219493, -0.19888>,
		<-0.213955, 0.220484, -0.0642078>,
		<-0.214857, 0.210369, -0.0641741>,
		<-0.233725, 0.210391, -0.262555>,
		<-0.232816, 0.220548, -0.262512>,
		<-0.166932, 0.148858, -1.87369>,
		<-0.166363, 0.139775, -1.86492>,
		<-0.148065, 0.161086, -1.6148>,
		<-0.148885, 0.17019, -1.62683>,
		<-0.335862, 0.149328, -1.84376>,
		<-0.335445, 0.140249, -1.83467>,
		<-0.322611, 0.170562, -1.58747>,
		<-0.322041, 0.161454, -1.57545>,
		<-0.119721, 0.187271, -1.2401>,
		<-0.120797, 0.196842, -1.25463>,
		<-0.302016, 0.197043, -1.21916>,
		<-0.301222, 0.187452, -1.20479>,
		<-0.0829563, 0.207694, -0.80213>,
		<-0.0838533, 0.219279, -0.813599>,
		<-0.273519, 0.219409, -0.784721>,
		<-0.272769, 0.207754, -0.773282>,
		<-0.0350497, 0.210368, -0.286119>,
		<-0.034892, 0.220479, -0.285218>,
		<-0.0146827, 0.220421, -0.0859051>,
		<-0.0147501, 0.210348, -0.0859742>,
		<0.0396272, 0.20781, 0.447837>,
		<0.0399151, 0.219294, 0.450317>,
		<-0.157071, 0.21933, 0.469921>,
		<-0.157323, 0.207812, 0.467465>,
		<0.0828346, 0.188258, 0.901619>,
		<0.0831153, 0.198126, 0.904459>,
		<-0.10831, 0.198057, 0.923645>,
		<-0.108642, 0.188183, 0.920815>,
		<0.117549, 0.161829, 1.30783>,
		<0.117812, 0.171212, 1.3108>,
		<-0.066358, 0.171117, 1.33086>,
		<-0.0667215, 0.161734, 1.32789>,
		<0.142579, 0.148773, 1.62226>,
		<0.142293, 0.13955, 1.61897>,
		<-0.0359049, 0.13944, 1.6402>,
		<-0.0355262, 0.148663, 1.64347>,
		<0.51958, 0.219329, -0.139649>,
		<0.517123, 0.207806, -0.139533>,
		<0.491519, 0.207822, -0.335446>,
		<0.493948, 0.219387, -0.335589>,
		<0.969988, 0.198054, -0.179347>,
		<0.96719, 0.188178, -0.17921>,
		<0.935179, 0.188195, -0.368041>,
		<0.937979, 0.19808, -0.368122>,
		<1.36685, 0.171323, -0.209297>,
		<1.36396, 0.16194, -0.209156>,
		<1.32695, 0.162156, -0.389326>,
		<1.32987, 0.17154, -0.389372>,
		<1.65544, 0.149153, -0.229511>,
		<1.65232, 0.139928, -0.229351>,
		<1.62574, 0.149567, -0.402868>,
		<1.62255, 0.140342, -0.402787>,
		<-1.73895, 0.0203406, -2.09587>,
		<-1.73936, 0.0665203, -2.09587>,
		<-2.08539, 0.0648751, -2.09587>,
		<-2.08539, 0.0197921, -2.09587>,
		<-2.08539, 0.0665344, -1.70895>,
		<-2.08539, 0.0203452, -1.70859>,
		<-2.08539, 0.0676467, -1.35423>,
		<-2.08539, 0.020716, -1.35369>,
		<-2.08539, 0.0686886, -0.985011>,
		<-2.08539, 0.0210633, -0.98452>,
		<-2.08539, 0.0695484, -0.589647>,
		<-2.08539, 0.0213499, -0.589315>,
		<-2.08539, 0.069914, -0.175824>,
		<-2.08539, 0.0214718, -0.175717>,
		<-2.08539, 0.0696155, 0.242078>,
		<-2.08539, 0.0213723, 0.24194>,
		<-2.08539, 0.0687424, 0.648127>,
		<-2.08539, 0.0210812, 0.647776>,
		<-2.08539, 0.0675927, 1.03079>,
		<-2.08539, 0.020698, 1.0303>,
		<-2.08539, 0.066501, 1.386>,
		<-2.08539, 0.0203341, 1.38547>,
		<-2.08539, 0.0656096, 1.71842>,
		<-2.08539, 0.020037, 1.71807>,
		<-2.08539, 0.0197186, 2.04294>,
		<-2.08539, 0.0646545, 2.04294>,
		<-1.68687, 0.0657817, 2.04294>,
		<-1.68653, 0.0200943, 2.04294>,
		<-1.39443, 0.0207527, -2.09587>,
		<-1.39503, 0.0677567, -2.09587>,
		<-1.32902, 0.0664629, 2.04294>,
		<-1.32851, 0.0203214, 2.04294>,
		<-1.02918, 0.0211695, -2.09587>,
		<-1.02971, 0.0690072, -2.09587>,
		<-0.962086, 0.0671287, 2.04294>,
		<-0.961625, 0.0205433, 2.04294>,
		<-0.661085, 0.0215245, -2.09587>,
		<-0.661446, 0.0700721, -2.09587>,
		<-0.57443, 0.0677135, 2.04294>,
		<-0.574123, 0.0207383, 2.04294>,
		<-0.373927, 0.0216781, -2.09587>,
		<-0.374126, 0.0705331, -2.09587>,
		<-0.172641, 0.0679862, 2.04294>,
		<-0.17254, 0.0208292, 2.04294>,
		<-0.0332687, 0.0216582, -2.09587>,
		<-0.0332685, 0.0704732, -2.09587>,
		<0.232643, 0.0678144, 2.04294>,
		<0.232521, 0.0207719, 2.04294>,
		<0.553028, 0.0213788, -2.09587>,
		<0.553342, 0.0696349, -2.09587>,
		<0.629675, 0.0672481, 2.04294>,
		<0.629353, 0.0205831, 2.04294>,
		<0.986567, 0.0209522, -2.09587>,
		<0.987045, 0.0683554, -2.09587>,
		<1.00911, 0.0664954, 2.04294>,
		<1.00864, 0.0203322, 2.04294>,
		<1.34864, 0.0205134, -2.09587>,
		<1.34915, 0.067039, -2.09587>,
		<1.36622, 0.0658093, 2.04294>,
		<1.36569, 0.0201035, 2.04294>,
		<1.69414, 0.0201218, -2.09587>,
		<1.69447, 0.065864, -2.09587>,
		<1.707, 0.0652668, 2.04294>,
		<1.70665, 0.0199227, 2.04294>,
		<2.05696, 0.0201422, -1.72874>,
		<2.05696, 0.0659253, -1.72912>,
		<2.05696, 0.0645675, -2.09587>,
		<2.05696, 0.0196896, -2.09587>,
		<2.05696, 0.0203754, -1.38111>,
		<2.05696, 0.0666248, -1.38167>,
		<2.05696, 0.0205954, -1.0185>,
		<2.05696, 0.0672848, -1.019>,
		<2.05696, 0.0207827, -0.674688>,
		<2.05696, 0.0678466, -0.675036>,
		<2.05696, 0.0208382, -0.458218>,
		<2.05696, 0.0680132, -0.45845>,
		<2.05696, 0.0208067, -0.0564709>,
		<2.05696, 0.0679187, -0.0564793>,
		<2.05696, 0.0206088, 0.537105>,
		<2.05696, 0.0673251, 0.537399>,
		<2.05696, 0.0203358, 0.965462>,
		<2.05696, 0.0665062, 0.96591>,
		<2.05696, 0.0200858, 1.32632>,
		<2.05696, 0.0657559, 1.32681>,
		<2.05696, 0.0198934, 1.67306>,
		<2.05696, 0.0651789, 1.67337>,
		<2.05696, 0.0645144, 2.04294>,
		<2.05696, 0.0196719, 2.04294>,
		<-1.76722, 0.0936843, -1.50418>,
		<-1.97584, 0.0907991, -1.64665>,
		<-1.42619, 0.0981227, -1.51668>,
		<-1.35005, 0.103619, -1.32632>,
		<-1.83099, 0.0981895, -1.19266>,
		<-2.00187, 0.0932427, -1.30028>,
		<-1.88632, 0.102855, -0.868046>,
		<-2.02194, 0.0956823, -0.946014>,
		<-1.94532, 0.10666, -0.517544>,
		<-2.04256, 0.0976659, -0.565677>,
		<-1.99585, 0.109906, -0.155343>,
		<-2.05651, 0.0990077, -0.169364>,
		<-1.98802, 0.109495, 0.18735>,
		<-2.05382, 0.0986025, 0.223321>,
		<-1.91634, 0.105362, 0.566086>,
		<-2.03265, 0.0965213, 0.620421>,
		<-1.84286, 0.100934, 0.91>,
		<-2.00703, 0.0940805, 0.99017>,
		<-1.77909, 0.0959887, 1.22139>,
		<-1.98399, 0.0915111, 1.33067>,
		<-1.71048, 0.0915161, 1.51562>,
		<-1.95574, 0.0892833, 1.65572>,
		<-1.47912, 0.0913909, 1.72082>,
		<-1.62343, 0.089374, 1.9331>,
		<-1.17251, 0.105524, -1.58768>,
		<-1.10917, 0.114475, -1.37978>,
		<-1.16877, 0.0953252, 1.77779>,
		<-1.27527, 0.0912398, 1.9565>,
		<-0.890875, 0.1131, -1.66992>,
		<-0.851987, 0.124952, -1.47148>,
		<-0.848998, 0.0994279, 1.82878>,
		<-0.924258, 0.0931467, 1.97529>,
		<-0.597381, 0.119376, -1.7745>,
		<-0.579755, 0.133703, -1.60227>,
		<-0.503573, 0.102927, 1.88181>,
		<-0.550874, 0.0947586, 1.99422>,
		<-0.354635, 0.124883, -1.91908>,
		<-0.345486, 0.143005, -1.85208>,
		<-0.139734, 0.106559, 1.91357>,
		<-0.162209, 0.0960902, 2.00225>,
		<-0.0822062, 0.124317, -1.94651>,
		<-0.118848, 0.142452, -1.88194>,
		<0.198746, 0.106382, 1.90312>,
		<0.220769, 0.0958781, 1.99862>,
		<0.391784, 0.117737, -1.83822>,
		<0.34001, 0.131851, -1.68161>,
		<0.56252, 0.102326, 1.85194>,
		<0.607041, 0.0941505, 1.9839>,
		<0.750292, 0.11102, -1.74192>,
		<0.674231, 0.122471, -1.56764>,
		<0.900894, 0.0984651, 1.78759>,
		<0.97274, 0.0922714, 1.96114>,
		<1.04845, 0.103368, -1.65514>,
		<0.951039, 0.111791, -1.47423>,
		<1.2111, 0.0941654, 1.73079>,
		<1.31397, 0.0902831, 1.9404>,
		<1.31918, 0.0960555, -1.57658>,
		<1.21566, 0.101032, -1.40954>,
		<1.50789, 0.0902154, 1.6705>,
		<1.6456, 0.0885387, 1.91544>,
		<1.47362, 0.0958763, -1.42084>,
		<1.27716, 0.100943, -1.34749>,
		<1.53345, 0.102683, -1.16765>,
		<1.31479, 0.111191, -1.10792>,
		<1.60405, 0.109683, -0.888998>,
		<1.38897, 0.121205, -0.853843>,
		<1.69062, 0.115809, -0.611451>,
		<1.4912, 0.130186, -0.595764>,
		<1.79523, 0.122422, -0.413916>,
		<1.67113, 0.142063, -0.405726>,
		<1.82347, 0.12178, -0.12184>,
		<1.70049, 0.14149, -0.171408>,
		<1.75041, 0.113915, 0.363177>,
		<1.56091, 0.12804, 0.308177>,
		<1.66922, 0.107184, 0.719848>,
		<1.47236, 0.118182, 0.642512>,
		<1.592, 0.1, 1.01705>,
		<1.39575, 0.107793, 0.917831>,
		<1.52295, 0.0932435, 1.28912>,
		<1.34671, 0.0975933, 1.18376>,
		<1.70905, 0.0982431, 1.00201>,
		<1.74492, 0.1011, 0.846895>,
		<1.64074, 0.0925595, 1.29437>,
		<1.67549, 0.0952692, 1.15062>,
		<1.5032, 0.0907553, 1.53289>,
		<1.5965, 0.0907503, 1.43706>,
		<1.23159, 0.0952627, 1.60633>,
		<1.36798, 0.0925658, 1.57442>,
		<0.942614, 0.101043, 1.67226>,
		<1.09038, 0.0982164, 1.63752>,
		<0.626389, 0.106086, 1.75088>,
		<0.788474, 0.103607, 1.7102>,
		<0.275084, 0.111931, 1.83328>,
		<0.453039, 0.108979, 1.79375>,
		<-0.0465713, 0.113812, 1.86567>,
		<0.109167, 0.113737, 1.85898>,
		<-0.390971, 0.109473, 1.82673>,
		<-0.212492, 0.112191, 1.85346>,
		<-0.732186, 0.104547, 1.76083>,
		<-0.566398, 0.106816, 1.79417>,
		<-1.04322, 0.0994619, 1.69726>,
		<-0.890769, 0.102158, 1.72819>,
		<-1.33123, 0.0939379, 1.63827>,
		<-1.18926, 0.0965939, 1.66858>,
		<-1.4741, 0.0921272, 1.59803>,
		<-1.57321, 0.0922132, 1.50812>,
		<-1.61986, 0.0942457, 1.37484>,
		<-1.65688, 0.0972165, 1.23866>,
		<-1.69308, 0.100479, 1.09691>,
		<-1.73254, 0.103638, 0.948301>,
		<-1.77466, 0.106547, 0.793024>,
		<-1.82118, 0.109302, 0.628196>,
		<-1.87617, 0.112237, 0.447882>,
		<-1.93132, 0.115044, 0.260409>,
		<-1.96589, 0.11677, 0.0883633>,
		<-1.97066, 0.116966, -0.0680552>,
		<-1.94795, 0.115687, -0.231033>,
		<-1.90716, 0.113385, -0.40567>,
		<-1.86474, 0.110909, -0.579979>,
		<-1.82746, 0.108517, -0.747962>,
		<-1.79232, 0.105882, -0.909612>,
		<-1.75819, 0.102912, -1.06471>,
		<-1.72572, 0.099757, -1.21285>,
		<-1.69112, 0.0968167, -1.35613>,
		<-1.64617, 0.0947407, -1.49924>,
		<-1.55317, 0.0947803, -1.59767>,
		<-1.41926, 0.0969471, -1.64309>,
		<-1.28342, 0.100001, -1.67835>,
		<-1.14213, 0.103289, -1.71208>,
		<-0.993691, 0.106407, -1.74844>,
		<-0.838217, 0.109194, -1.78718>,
		<-0.68283, 0.111705, -1.83033>,
		<-0.541672, 0.114203, -1.88224>,
		<-0.417213, 0.116433, -1.93629>,
		<-0.300254, 0.117616, -1.97495>,
		<-0.162788, 0.117357, -1.98762>,
		<0.0420018, 0.115646, -1.97068>,
		<0.299015, 0.112921, -1.9312>,
		<0.531238, 0.110078, -1.88696>,
		<0.714325, 0.107395, -1.84586>,
		<0.876598, 0.104535, -1.80594>,
		<1.03207, 0.101402, -1.76687>,
		<1.18045, 0.0981355, -1.72991>,
		<1.32347, 0.09513, -1.69157>,
		<1.46486, 0.0930354, -1.64358>,
		<1.55969, 0.0929512, -1.5479>,
		<1.63118, 0.0975889, -1.2765>,
		<1.60054, 0.0948436, -1.41235>,
		<1.69227, 0.103359, -0.989108>,
		<1.66033, 0.100557, -1.1361>,
		<1.76409, 0.108177, -0.687794>,
		<1.72692, 0.105849, -0.835745>,
		<1.84138, 0.113358, -0.471717>,
		<1.80353, 0.11079, -0.568612>,
		<1.88377, 0.114469, -0.206669>,
		<1.87022, 0.114771, -0.360785>,
		<1.85186, 0.109311, 0.272908>,
		<1.8769, 0.112447, 0.0125945>,
		<1.78188, 0.103716, 0.685714>,
		<1.81823, 0.106283, 0.504111>,
		<-1.30988, -0.00274934, 0.959544>,
		<-1.30988, -0.00274934, 0.744819>,
		<-1.30988, -0.00274934, 0.514315>,
		<-1.30988, -0.00274934, 0.267853>,
		<-1.30988, -0.00274934, 0.0103014>,
		<-1.30988, -0.00274934, -0.249706>,
		<-1.30988, -0.00274934, -0.502621>,
		<-1.30988, -0.00274934, -0.741522>,
		<-1.30988, -0.00274934, -0.967024>,
		<-1.29901, -0.00274934, -1.18642>,
		<-1.1906, -0.00274934, -1.30802>,
		<-0.985707, -0.00274934, -1.32039>,
		<-0.764233, -0.00274934, -1.32039>,
		<-0.533615, -0.00274934, -1.32039>,
		<-0.328731, -0.00274934, -1.32039>,
		<-0.137986, -0.00274934, -1.32039>,
		<0.154755, -0.00274934, -1.32039>,
		<0.477805, -0.00274934, -1.32039>,
		<0.72359, -0.00274934, -1.32039>,
		<0.94416, -0.00274934, -1.32039>,
		<1.15385, -0.00274934, -1.30874>,
		<1.26759, -0.00274934, -1.19362>,
		<1.27909, -0.00274934, -0.982047>,
		<1.27909, -0.00274934, -0.760647>,
		<1.27909, -0.00274934, -0.537252>,
		<1.27909, -0.00274934, -0.364517>,
		<1.27909, -0.00274934, -0.176629>,
		<1.27909, -0.00274934, 0.139804>,
		<1.27909, -0.00274934, 0.462137>,
		<1.27909, -0.00274934, 0.70604>,
		<1.27909, -0.00274934, 0.926565>,
		<1.26804, -0.00274934, 1.1386>,
		<1.15833, -0.00274934, 1.25461>,
		<0.95349, -0.00274934, 1.26637>,
		<0.73575, -0.00274934, 1.26637>,
		<0.505637, -0.00274934, 1.26637>,
		<0.263015, -0.00274934, 1.26637>,
		<0.0122756, -0.00274934, 1.26637>,
		<-0.239962, -0.00274934, 1.26637>,
		<-0.486669, -0.00274934, 1.26637>,
		<-0.722456, -0.00274934, 1.26637>,
		<-0.948165, -0.00274934, 1.26637>,
		<-1.17177, -0.00274934, 1.25624>,
		<-1.2971, -0.00274934, 1.15471>,
		<-1.84684, 0.0914815, -1.67538>,
		<-1.69964, 0.0926706, -1.66159>,
		<-1.70963, 0.0915002, -1.82548>,
		<-1.86762, 0.0896218, -1.95313>,
		<-1.95899, 0.0896296, -1.85028>,
		<-1.90838, 0.0946119, -1.32675>,
		<-1.80417, 0.0957313, -1.34594>,
		<-1.88557, 0.092858, -1.4913>,
		<-1.99192, 0.0919892, -1.46904>,
		<-1.94622, 0.0982424, -0.994297>,
		<-1.85801, 0.100621, -1.03377>,
		<-1.92673, 0.0964692, -1.16401>,
		<-2.01164, 0.0944983, -1.12657>,
		<-1.98697, 0.101244, -0.635104>,
		<-1.91548, 0.104809, -0.695842>,
		<-1.96656, 0.0998305, -0.817848>,
		<-2.03252, 0.0967323, -0.758802>,
		<-2.02179, 0.103778, -0.256396>,
		<-1.97463, 0.108527, -0.334659>,
		<-2.00625, 0.102606, -0.446723>,
		<-2.05102, 0.098484, -0.367913>,
		<-2.02707, 0.104159, 0.111651>,
		<-2.00117, 0.110262, 0.0143211>,
		<-2.02959, 0.104363, -0.070841>,
		<-2.05767, 0.0990545, 0.0267204>,
		<-1.99013, 0.101574, 0.496748>,
		<-1.95636, 0.107664, 0.375722>,
		<-2.01308, 0.103156, 0.301214>,
		<-2.04476, 0.0976865, 0.423084>,
		<-1.93904, 0.0981799, 0.863954>,
		<-1.87822, 0.103155, 0.743618>,
		<-1.96432, 0.0998606, 0.685911>,
		<-2.01977, 0.0953174, 0.809393>,
		<-1.89254, 0.0945393, 1.19664>,
		<-1.80971, 0.0985197, 1.0691>,
		<-1.91496, 0.0964109, 1.03372>,
		<-1.99503, 0.0927938, 1.16382>,
		<-1.84748, 0.0909644, 1.50814>,
		<-1.74978, 0.0935061, 1.36783>,
		<-1.87212, 0.0926572, 1.35278>,
		<-1.9731, 0.0903043, 1.49204>,
		<-1.83188, 0.0885481, 1.91882>,
		<-1.6527, 0.0897716, 1.80504>,
		<-1.63827, 0.0905783, 1.6578>,
		<-1.8059, 0.0897686, 1.67467>,
		<-1.93788, 0.0884816, 1.83325>,
		<-1.4042, 0.0958912, -1.77082>,
		<-1.38039, 0.0947898, -1.88982>,
		<-1.5134, 0.0920752, -1.98771>,
		<-1.53829, 0.0929398, -1.86626>,
		<-1.23106, 0.124213, -1.04043>,
		<-1.15693, 0.124301, -1.11954>,
		<-1.20597, 0.116636, -1.171>,
		<-1.2768, 0.11656, -1.09589>,
		<-1.31393, 0.138584, -0.788205>,
		<-1.23547, 0.140135, -0.870677>,
		<-1.27251, 0.13158, -0.917962>,
		<-1.35559, 0.130055, -0.845773>,
		<-1.40716, 0.150609, -0.506589>,
		<-1.31806, 0.153876, -0.595132>,
		<-1.3536, 0.144926, -0.651576>,
		<-1.43917, 0.141644, -0.572005>,
		<-1.65651, 0.161258, -0.182403>,
		<-1.51483, 0.16468, -0.276751>,
		<-1.50758, 0.155937, -0.34985>,
		<-1.63885, 0.152287, -0.261321>,
		<-1.72511, 0.145382, 0.0312863>,
		<-1.65891, 0.150817, -0.0179725>,
		<-1.73117, 0.145379, -0.0544773>,
		<-1.79237, 0.140194, -0.00562812>,
		<-1.44979, 0.154451, 0.370364>,
		<-1.47015, 0.163669, 0.273877>,
		<-1.62852, 0.160752, 0.175978>,
		<-1.59714, 0.151295, 0.278398>,
		<-1.25528, 0.14186, 0.686973>,
		<-1.22459, 0.151092, 0.622525>,
		<-1.3256, 0.148264, 0.541186>,
		<-1.35212, 0.139019, 0.614828>,
		<-1.15391, 0.127354, 0.944927>,
		<-1.11699, 0.136026, 0.892801>,
		<-1.2037, 0.134894, 0.819591>,
		<-1.24539, 0.126263, 0.880338>,
		<-1.08159, 0.111815, 1.18842>,
		<-1.02813, 0.119319, 1.13401>,
		<-1.10716, 0.119563, 1.06288>,
		<-1.1566, 0.112024, 1.12015>,
		<-1.20266, 0.0978348, 1.55104>,
		<-1.08764, 0.103107, 1.46337>,
		<-1.11231, 0.104376, 1.35157>,
		<-1.21504, 0.0989114, 1.43698>,
		<-1.10408, 0.101031, -1.82656>,
		<-1.05728, 0.0986823, -1.9292>,
		<-1.17811, 0.0948214, -2.00805>,
		<-1.22232, 0.096769, -1.90873>,
		<-0.998587, 0.140436, -1.12621>,
		<-0.920197, 0.13907, -1.21264>,
		<-0.972432, 0.130509, -1.25608>,
		<-1.04248, 0.131865, -1.16466>,
		<-1.07692, 0.159366, -0.870595>,
		<-0.993248, 0.159468, -0.962068>,
		<-1.03782, 0.150064, -1.00298>,
		<-1.11927, 0.149961, -0.914585>,
		<-1.16083, 0.175382, -0.576228>,
		<-1.06778, 0.177863, -0.676322>,
		<-1.11426, 0.167933, -0.729158>,
		<-1.199, 0.165823, -0.633551>,
		<-1.35336, 0.186076, -0.223121>,
		<-1.2099, 0.190675, -0.331199>,
		<-1.24032, 0.181351, -0.4068>,
		<-1.37358, 0.177197, -0.301995>,
		<-1.39742, 0.169542, 0.00296026>,
		<-1.3006, 0.176154, -0.0504402>,
		<-1.40425, 0.169509, -0.0855613>,
		<-1.49541, 0.162941, -0.032774>,
		<-1.17681, 0.179914, 0.375748>,
		<-1.16117, 0.189784, 0.267894>,
		<-1.32241, 0.185632, 0.16025>,
		<-1.32682, 0.176214, 0.272045>,
		<-1.00544, 0.164712, 0.722374>,
		<-0.965547, 0.175119, 0.652996>,
		<-1.07099, 0.173013, 0.563946>,
		<-1.10101, 0.162996, 0.63856>,
		<-0.906295, 0.145366, 0.99641>,
		<-0.863079, 0.155068, 0.944005>,
		<-0.954615, 0.155361, 0.86429>,
		<-0.994709, 0.145657, 0.918779>,
		<-0.835377, 0.124983, 1.24778>,
		<-0.779518, 0.133512, 1.19583>,
		<-0.86158, 0.135181, 1.11891>,
		<-0.907419, 0.12656, 1.16506>,
		<-0.924748, 0.104962, 1.6143>,
		<-0.816179, 0.111672, 1.53061>,
		<-0.856393, 0.114663, 1.41488>,
		<-0.955113, 0.107514, 1.49622>,
		<-0.77892, 0.105512, -1.88924>,
		<-0.714746, 0.101966, -1.97425>,
		<-0.819111, 0.0973528, -2.03054>,
		<-0.885309, 0.100421, -1.95111>,
		<-0.736774, 0.154532, -1.23149>,
		<-0.655137, 0.151371, -1.3323>,
		<-0.71288, 0.142441, -1.35962>,
		<-0.789974, 0.145596, -1.26287>,
		<-0.801715, 0.178121, -0.97293>,
		<-0.711713, 0.175769, -1.07856>,
		<-0.769396, 0.166287, -1.10783>,
		<-0.857325, 0.168225, -1.01235>,
		<-0.864665, 0.201559, -0.665813>,
		<-0.766057, 0.201603, -0.779049>,
		<-0.83206, 0.190255, -0.826887>,
		<-0.924396, 0.190184, -0.722645>,
		<-0.967754, 0.214117, -0.277773>,
		<-0.838371, 0.218281, -0.401198>,
		<-0.909662, 0.209547, -0.48185>,
		<-1.0318, 0.205098, -0.36363>,
		<-0.980239, 0.194041, -0.0345317>,
		<-0.871811, 0.198535, -0.0922615>,
		<-0.987855, 0.194015, -0.127082>,
		<-1.09189, 0.188638, -0.0701477>,
		<-0.840596, 0.208578, 0.372607>,
		<-0.784749, 0.217755, 0.251339>,
		<-0.933884, 0.213807, 0.135841>,
		<-0.981037, 0.204372, 0.261191>,
		<-0.713317, 0.187469, 0.753135>,
		<-0.653062, 0.1996, 0.674465>,
		<-0.766868, 0.199759, 0.579439>,
		<-0.817961, 0.187692, 0.664638>,
		<-0.625977, 0.161609, 1.04869>,
		<-0.566652, 0.171827, 0.994587>,
		<-0.668146, 0.174339, 0.907253>,
		<-0.721928, 0.163848, 0.967225>,
		<-0.564396, 0.136609, 1.31143>,
		<-0.497778, 0.145948, 1.26377>,
		<-0.58786, 0.149127, 1.17768>,
		<-0.644379, 0.13988, 1.2251>,
		<-0.621346, 0.111097, 1.6845>,
		<-0.51733, 0.119057, 1.60545>,
		<-0.575744, 0.123639, 1.48408>,
		<-0.671064, 0.115398, 1.56561>,
		<-0.485973, 0.109321, -1.96264>,
		<-0.429346, 0.104562, -2.02074>,
		<-0.502371, 0.0992563, -2.05379>,
		<-0.562194, 0.103389, -1.99825>,
		<-0.462215, 0.165051, -1.47701>,
		<-0.393753, 0.161519, -1.63269>,
		<-0.454817, 0.152832, -1.60057>,
		<-0.522422, 0.15656, -1.45546>,
		<-0.480902, 0.190704, -1.17717>,
		<-0.395443, 0.185984, -1.33911>,
		<-0.472181, 0.177383, -1.33804>,
		<-0.556924, 0.181608, -1.18767>,
		<-0.492939, 0.218232, -0.811176>,
		<-0.390736, 0.213967, -0.962901>,
		<-0.487683, 0.205049, -1.00203>,
		<-0.587158, 0.209562, -0.859397>,
		<-0.504016, 0.227648, -0.353584>,
		<-0.378585, 0.22763, -0.504701>,
		<-0.498193, 0.225852, -0.594156>,
		<-0.619766, 0.225869, -0.44846>,
		<-0.492314, 0.204973, -0.084364>,
		<-0.361648, 0.205312, -0.147961>,
		<-0.501045, 0.204973, -0.181341>,
		<-0.627966, 0.203956, -0.118335>,
		<-0.415136, 0.22541, 0.355808>,
		<-0.31284, 0.227322, 0.219986>,
		<-0.464045, 0.227426, 0.0977674>,
		<-0.561136, 0.225489, 0.237382>,
		<-0.337381, 0.204304, 0.791189>,
		<-0.244045, 0.213894, 0.698988>,
		<-0.372769, 0.217645, 0.587649>,
		<-0.460736, 0.208381, 0.685633>,
		<-0.275964, 0.175607, 1.15591>,
		<-0.189011, 0.185799, 1.10305>,
		<-0.305479, 0.189568, 0.979689>,
		<-0.388213, 0.179074, 1.03964>,
		<-0.234668, 0.149719, 1.45637>,
		<-0.145938, 0.160115, 1.43927>,
		<-0.250132, 0.162587, 1.31209>,
		<-0.331317, 0.152577, 1.33486>,
		<-0.281402, 0.118095, 1.7692>,
		<-0.17617, 0.128603, 1.71972>,
		<-0.246176, 0.134512, 1.60987>,
		<-0.349875, 0.12356, 1.65946>,
		<-0.235175, 0.110981, -2.01428>,
		<-0.15202, 0.104996, -2.04461>,
		<-0.232268, 0.0999559, -2.06934>,
		<-0.302974, 0.105158, -2.03735>,
		<-0.239318, 0.15096, -1.66221>,
		<-0.200547, 0.145478, -1.73657>,
		<-0.247115, 0.140464, -1.78773>,
		<-0.286243, 0.145692, -1.71853>,
		<-0.216939, 0.176138, -1.31655>,
		<-0.179016, 0.169465, -1.42371>,
		<-0.229378, 0.162984, -1.50568>,
		<-0.267837, 0.169602, -1.40448>,
		<-0.186557, 0.198517, -0.896869>,
		<-0.148514, 0.193979, -1.01454>,
		<-0.20271, 0.188605, -1.11229>,
		<-0.241358, 0.194021, -0.998609>,
		<-0.145884, 0.205312, -0.405411>,
		<-0.108307, 0.204971, -0.541225>,
		<-0.167495, 0.203953, -0.660709>,
		<-0.205498, 0.204973, -0.528085>,
		<-0.119948, 0.205312, -0.124955>,
		<-0.0749029, 0.205312, -0.180558>,
		<-0.129752, 0.205312, -0.2247>,
		<-0.174796, 0.205312, -0.169097>,
		<-0.0722509, 0.204011, 0.329605>,
		<-0.0364451, 0.204987, 0.192445>,
		<-0.100496, 0.205312, 0.0621229>,
		<-0.135874, 0.204986, 0.202747>,
		<-0.0237463, 0.189217, 0.801447>,
		<0.0137568, 0.194471, 0.685996>,
		<-0.0465693, 0.198809, 0.576298>,
		<-0.0834977, 0.194448, 0.695593>,
		<0.0166428, 0.163529, 1.22261>,
		<0.0542703, 0.170224, 1.11742>,
		<-0.0026633, 0.176866, 1.0174>,
		<-0.0396974, 0.170178, 1.12719>,
		<0.0466422, 0.14014, 1.55535>,
		<0.08532, 0.145539, 1.47546>,
		<0.0329796, 0.151125, 1.40167>,
		<-0.00525249, 0.145489, 1.48579>,
		<0.0351032, 0.122382, 1.80975>,
		<0.105369, 0.13163, 1.74312>,
		<0.0467751, 0.142423, 1.69327>,
		<-0.0248585, 0.131669, 1.7521>,
		<0.189785, 0.108421, -1.99642>,
		<0.352717, 0.102482, -2.02475>,
		<0.231925, 0.0987345, -2.06576>,
		<0.0724109, 0.104036, -2.03997>,
		<0.0966977, 0.163854, -1.5479>,
		<0.209694, 0.154963, -1.53779>,
		<0.0915432, 0.151581, -1.66534>,
		<-0.0316144, 0.160681, -1.68496>,
		<0.125407, 0.189794, -1.25411>,
		<0.23673, 0.180278, -1.28054>,
		<0.109864, 0.176304, -1.413>,
		<-0.00806701, 0.185335, -1.39692>,
		<0.163329, 0.2177, -0.889533>,
		<0.274131, 0.20872, -0.957879>,
		<0.142856, 0.204332, -1.0798>,
		<0.0255051, 0.213566, -1.01852>,
		<0.221067, 0.227349, -0.434928>,
		<0.332017, 0.225454, -0.554029>,
		<0.189538, 0.22546, -0.673647>,
		<0.0732446, 0.227386, -0.558108>,
		<0.251943, 0.204985, -0.163498>,
		<0.377342, 0.204004, -0.22573>,
		<0.240501, 0.204985, -0.262704>,
		<0.111527, 0.205312, -0.199851>,
		<0.284133, 0.225138, 0.290804>,
		<0.402771, 0.225158, 0.145508>,
		<0.268772, 0.227171, 0.0241337>,
		<0.146283, 0.227147, 0.174873>,
		<0.30468, 0.203938, 0.736068>,
		<0.414152, 0.207855, 0.611548>,
		<0.296369, 0.217334, 0.528841>,
		<0.183153, 0.213731, 0.660741>,
		<0.311484, 0.175177, 1.10585>,
		<0.410733, 0.178397, 0.973706>,
		<0.309548, 0.189157, 0.927222>,
		<0.207247, 0.185631, 1.06744>,
		<0.312434, 0.149332, 1.41146>,
		<0.397677, 0.151931, 1.2763>,
		<0.311025, 0.162167, 1.26432>,
		<0.221722, 0.159961, 1.40554>,
		<0.348958, 0.117725, 1.73726>,
		<0.420369, 0.123032, 1.61455>,
		<0.324822, 0.134143, 1.56995>,
		<0.252776, 0.128382, 1.69247>,
		<0.66745, 0.104005, -1.9339>,
		<0.80249, 0.0990966, -1.98128>,
		<0.74995, 0.0963339, -2.04582>,
		<0.604802, 0.100782, -2.00405>,
		<0.50154, 0.152167, -1.34677>,
		<0.571036, 0.143024, -1.37884>,
		<0.494212, 0.140048, -1.46547>,
		<0.411041, 0.149188, -1.43627>,
		<0.545111, 0.176133, -1.10286>,
		<0.614523, 0.165915, -1.1447>,
		<0.5223, 0.164067, -1.23066>,
		<0.445089, 0.17388, -1.19676>,
		<0.599635, 0.200283, -0.80925>,
		<0.670056, 0.188478, -0.86938>,
		<0.569725, 0.188575, -0.963104>,
		<0.490038, 0.200325, -0.908449>,
		<0.696631, 0.214063, -0.450097>,
		<0.767034, 0.204731, -0.540779>,
		<0.642078, 0.208819, -0.637242>,
		<0.564048, 0.217843, -0.548487>,
		<0.74183, 0.19441, -0.209083>,
		<0.843533, 0.18916, -0.265766>,
		<0.727527, 0.194404, -0.305439>,
		<0.621706, 0.198772, -0.247874>,
		<0.728159, 0.207914, 0.23669>,
		<0.834727, 0.203989, 0.0993196>,
		<0.745521, 0.213748, -0.0243795>,
		<0.633033, 0.217373, 0.120167>,
		<0.699088, 0.186164, 0.642795>,
		<0.78886, 0.186211, 0.541088>,
		<0.713068, 0.198672, 0.460133>,
		<0.617165, 0.198635, 0.571482>,
		<0.662099, 0.160211, 0.951517>,
		<0.748206, 0.162212, 0.858489>,
		<0.682389, 0.172946, 0.803459>,
		<0.591912, 0.170659, 0.903882>,
		<0.62711, 0.135384, 1.22816>,
		<0.701318, 0.138404, 1.13083>,
		<0.640298, 0.147789, 1.08698>,
		<0.558153, 0.14486, 1.18471>,
		<0.682278, 0.110194, 1.62767>,
		<0.732426, 0.114283, 1.4955>,
		<0.640703, 0.122572, 1.41167>,
		<0.58285, 0.118217, 1.54599>,
		<1.00851, 0.0993953, -1.8687>,
		<1.14576, 0.0953707, -1.9358>,
		<1.11695, 0.0936604, -2.02207>,
		<0.977529, 0.0972985, -1.95814>,
		<0.790248, 0.137502, -1.25304>,
		<0.846228, 0.128851, -1.28619>,
		<0.77861, 0.127619, -1.37152>,
		<0.712358, 0.136234, -1.3337>,
		<0.851694, 0.156669, -1.01484>,
		<0.904228, 0.147055, -1.05477>,
		<0.819865, 0.147213, -1.13866>,
		<0.764349, 0.156827, -1.10086>,
		<0.928594, 0.173312, -0.740473>,
		<0.976576, 0.163316, -0.791482>,
		<0.885285, 0.165449, -0.881393>,
		<0.829657, 0.175741, -0.831486>,
		<1.0931, 0.186321, -0.452189>,
		<1.12845, 0.176586, -0.518019>,
		<0.997994, 0.180196, -0.596594>,
		<0.954201, 0.190267, -0.530477>,
		<1.16593, 0.170259, -0.241463>,
		<1.25405, 0.1637, -0.29371>,
		<1.14815, 0.170309, -0.333704>,
		<1.05495, 0.176876, -0.280857>,
		<1.07723, 0.178606, 0.198351>,
		<1.19303, 0.175383, 0.0651869>,
		<1.14398, 0.185706, -0.0595803>,
		<1.02065, 0.189261, 0.0812189>,
		<0.998505, 0.162353, 0.584623>,
		<1.0806, 0.160445, 0.491921>,
		<1.02908, 0.170887, 0.413863>,
		<0.941231, 0.173092, 0.515379>,
		<0.940633, 0.143124, 0.874431>,
		<1.02042, 0.143157, 0.789028>,
		<0.97107, 0.153023, 0.734241>,
		<0.889329, 0.152984, 0.822631>,
		<0.891489, 0.123094, 1.14339>,
		<0.958629, 0.124406, 1.05208>,
		<0.90934, 0.13309, 1.005>,
		<0.833694, 0.131681, 1.09053>,
		<0.977146, 0.103646, 1.54418>,
		<1.0081, 0.105954, 1.41285>,
		<0.913538, 0.113047, 1.32465>,
		<0.873469, 0.110316, 1.45274>,
		<1.31945, 0.0943001, -1.80762>,
		<1.46933, 0.0916071, -1.88976>,
		<1.45451, 0.0909202, -1.99972>,
		<1.30712, 0.0934068, -1.91491>,
		<1.04812, 0.121039, -1.16235>,
		<1.10732, 0.113455, -1.20832>,
		<1.0352, 0.113581, -1.2812>,
		<0.972409, 0.121179, -1.23876>,
		<1.11794, 0.135453, -0.928403>,
		<1.17148, 0.126883, -0.977044>,
		<1.082, 0.128404, -1.04908>,
		<1.03417, 0.137035, -1.00891>,
		<1.2062, 0.147878, -0.670859>,
		<1.25035, 0.138619, -0.72245>,
		<1.15544, 0.141877, -0.800265>,
		<1.11081, 0.15105, -0.751975>,
		<1.41908, 0.161119, -0.447301>,
		<1.42501, 0.151117, -0.494932>,
		<1.29413, 0.154171, -0.552633>,
		<1.28235, 0.163809, -0.504715>,
		<1.50763, 0.145887, -0.264125>,
		<1.56856, 0.140686, -0.312232>,
		<1.49035, 0.146047, -0.352444>,
		<1.42489, 0.151485, -0.303996>,
		<1.364, 0.152326, 0.171126>,
		<1.4816, 0.149732, 0.0470835>,
		<1.46601, 0.160268, -0.0843952>,
		<1.3435, 0.162481, 0.0516133>,
		<1.25313, 0.138662, 0.53998>,
		<1.33959, 0.135713, 0.463502>,
		<1.29336, 0.145235, 0.379546>,
		<1.20762, 0.148091, 0.470838>,
		<1.18546, 0.12447, 0.813248>,
		<1.26979, 0.1232, 0.745546>,
		<1.22062, 0.131822, 0.680001>,
		<1.14205, 0.133172, 0.758015>,
		<1.13059, 0.109437, 1.07507>,
		<1.20096, 0.109448, 1.00203>,
		<1.14966, 0.116906, 0.939433>,
		<1.0763, 0.11689, 1.01614>,
		<1.24567, 0.0962762, 1.47475>,
		<1.25886, 0.0970979, 1.34868>,
		<1.16104, 0.102378, 1.25347>,
		<1.13618, 0.101386, 1.3764>,
		<1.62805, 0.0912139, -1.69672>,
		<1.79012, 0.0902511, -1.70461>,
		<1.91793, 0.0887822, -1.86663>,
		<1.82185, 0.0887427, -1.96388>,
		<1.64791, 0.0902788, -1.84833>,
		<1.40487, 0.104492, -1.19573>,
		<1.50238, 0.0989759, -1.29719>,
		<1.37852, 0.10017, -1.31616>,
		<1.28404, 0.105852, -1.22629>,
		<1.47588, 0.113301, -0.937112>,
		<1.56736, 0.106333, -1.03156>,
		<1.43903, 0.109025, -1.06969>,
		<1.35075, 0.116399, -0.984147>,
		<1.5618, 0.120805, -0.662433>,
		<1.64389, 0.112663, -0.742767>,
		<1.51516, 0.117125, -0.798121>,
		<1.43114, 0.125533, -0.719264>,
		<1.70017, 0.129903, -0.456043>,
		<1.74585, 0.119487, -0.509814>,
		<1.62589, 0.125163, -0.549345>,
		<1.58016, 0.13599, -0.4962>,
		<1.76731, 0.132341, -0.229481>,
		<1.82323, 0.123258, -0.293777>,
		<1.7522, 0.132648, -0.357983>,
		<1.70317, 0.143176, -0.307135>,
		<1.68516, 0.123438, 0.216488>,
		<1.79398, 0.118175, 0.11676>,
		<1.74137, 0.128905, -0.0310631>,
		<1.63319, 0.134596, 0.0700402>,
		<1.58959, 0.114473, 0.60229>,
		<1.70874, 0.110387, 0.558771>,
		<1.63173, 0.118515, 0.433747>,
		<1.51049, 0.122859, 0.492536>,
		<1.51112, 0.106013, 0.893507>,
		<1.62998, 0.103707, 0.871545>,
		<1.5505, 0.110424, 0.750831>,
		<1.4342, 0.113143, 0.783192>,
		<1.44173, 0.0971092, 1.16133>,
		<1.55645, 0.0962882, 1.15606>,
		<1.47307, 0.101415, 1.02989>,
		<1.36094, 0.102398, 1.04768>,
		<1.47982, 0.0917735, 1.40495>,
		<1.42618, 0.0938736, 1.29102>,
		<1.37851, 0.0938718, 1.33971>,
		<-1.726, 0.159324, 0.0746023>,
		<-1.65552, 0.160143, 0.0686259>,
		<-1.72339, 0.15003, 0.0743128>,
		<-1.78891, 0.149455, 0.0799442>,
		<-1.7381, 0.159319, -0.0968557>,
		<-1.80061, 0.149463, -0.0905905>,
		<-1.7355, 0.150025, -0.0971913>,
		<-1.66802, 0.160123, -0.10392>,
		<-1.85738, 0.148983, 0.000584576>,
		<-1.85346, 0.144361, 0.0428465>,
		<-1.85519, 0.139749, 0.000284526>,
		<-1.85911, 0.144371, -0.0419774>,
		<-1.39988, 0.18361, 0.0477685>,
		<-1.29776, 0.1857, 0.0393979>,
		<-1.39596, 0.174242, 0.0474035>,
		<-1.49232, 0.172293, 0.055238>,
		<-1.41353, 0.183546, -0.129135>,
		<-1.5056, 0.172242, -0.120031>,
		<-1.40962, 0.174177, -0.129593>,
		<-1.31179, 0.185629, -0.139398>,
		<-0.981948, 0.210381, 0.012287>,
		<-0.867067, 0.209937, 0.00170389>,
		<-0.97827, 0.199496, 0.0119245>,
		<-1.08857, 0.198981, 0.0217205>,
		<-0.997153, 0.210375, -0.172626>,
		<-1.10337, 0.198933, -0.161116>,
		<-0.993493, 0.19946, -0.173113>,
		<-0.882738, 0.209945, -0.185461>,
		<-0.489179, 0.221851, -0.0356833>,
		<-0.352538, 0.21604, -0.0498202>,
		<-0.488359, 0.210599, -0.0358115>,
		<-0.621201, 0.215555, -0.0222705>,
		<-0.506619, 0.221925, -0.229487>,
		<-0.637989, 0.2156, -0.213886>,
		<-0.505813, 0.210623, -0.229715>,
		<-0.370683, 0.216087, -0.245917>,
		<-0.158733, 0.159027, -1.76118>,
		<-0.162621, 0.149333, -1.81401>,
		<-0.158044, 0.149923, -1.75079>,
		<-0.153742, 0.159868, -1.6925>,
		<-0.251397, 0.149093, -1.85872>,
		<-0.293402, 0.144671, -1.84673>,
		<-0.250904, 0.140012, -1.84979>,
		<-0.208899, 0.144435, -1.86178>,
		<-0.329824, 0.159457, -1.72532>,
		<-0.326174, 0.160271, -1.6544>,
		<-0.329335, 0.150352, -1.71478>,
		<-0.33269, 0.149785, -1.78085>,
		<-0.136055, 0.183079, -1.45373>,
		<-0.142381, 0.171912, -1.53821>,
		<-0.135089, 0.173957, -1.44012>,
		<-0.12816, 0.18529, -1.34923>,
		<-0.313252, 0.183363, -1.41512>,
		<-0.307475, 0.185523, -1.31212>,
		<-0.312583, 0.174235, -1.40162>,
		<-0.317887, 0.172239, -1.4988>,
		<-0.103719, 0.210038, -1.04366>,
		<-0.11198, 0.198649, -1.14359>,
		<-0.102634, 0.199318, -1.02956>,
		<-0.0937003, 0.209754, -0.925132>,
		<-0.289148, 0.210193, -1.01154>,
		<-0.281321, 0.209865, -0.894713>,
		<-0.288236, 0.199426, -0.997611>,
		<-0.295408, 0.198807, -1.1099>,
		<-0.0603766, 0.221796, -0.556876>,
		<-0.0721424, 0.215487, -0.683513>,
		<-0.0599329, 0.210579, -0.550822>,
		<-0.0476837, 0.216022, -0.420644>,
		<-0.254198, 0.221897, -0.531118>,
		<-0.243836, 0.216079, -0.396119>,
		<-0.254128, 0.210615, -0.524716>,
		<-0.264012, 0.215568, -0.65614>,
		<0.0135681, 0.221628, 0.189493>,
		<-0.000506275, 0.215935, 0.0523093>,
		<0.013369, 0.210534, 0.188027>,
		<0.0269728, 0.215421, 0.321615>,
		<-0.184831, 0.221687, 0.210011>,
		<-0.170871, 0.215454, 0.341646>,
		<-0.185336, 0.210553, 0.208603>,
		<-0.199655, 0.215976, 0.0734399>,
		<0.0628378, 0.210705, 0.685443>,
		<0.0516283, 0.210069, 0.569346>,
		<0.0625353, 0.19989, 0.682612>,
		<0.073088, 0.199564, 0.794724>,
		<-0.131761, 0.210688, 0.70462>,
		<-0.120001, 0.199512, 0.813862>,
		<-0.132004, 0.199854, 0.701801>,
		<-0.144241, 0.210067, 0.588684>,
		<0.101653, 0.184435, 1.11685>,
		<0.0924895, 0.186508, 1.01058>,
		<0.101387, 0.174976, 1.11397>,
		<0.109954, 0.172978, 1.21563>,
		<-0.0861321, 0.184345, 1.13638>,
		<-0.0760392, 0.172885, 1.23542>,
		<-0.0864982, 0.174885, 1.13351>,
		<-0.0971874, 0.186424, 1.0299>,
		<0.0535264, 0.148718, 1.63286>,
		<0.0978981, 0.144134, 1.62592>,
		<0.053194, 0.139495, 1.62959>,
		<0.00882234, 0.144079, 1.63653>,
		<0.131014, 0.159535, 1.47498>,
		<0.124587, 0.160526, 1.39454>,
		<0.130742, 0.150221, 1.47186>,
		<0.136759, 0.149462, 1.54808>,
		<-0.0499873, 0.159434, 1.49561>,
		<-0.0428238, 0.149357, 1.569>,
		<-0.0503549, 0.15012, 1.4925>,
		<-0.0579967, 0.160428, 1.41488>,
		<0.259844, 0.221666, -0.113954>,
		<0.391472, 0.215448, -0.127201>,
		<0.258391, 0.210545, -0.113915>,
		<0.123113, 0.215949, -0.100083>,
		<0.236983, 0.221732, -0.311899>,
		<0.10156, 0.215991, -0.299032>,
		<0.235514, 0.210567, -0.312171>,
		<0.367254, 0.215491, -0.324317>,
		<0.75318, 0.210676, -0.161115>,
		<0.861476, 0.199495, -0.170473>,
		<0.750381, 0.199834, -0.160975>,
		<0.63793, 0.210058, -0.150812>,
		<0.724539, 0.210703, -0.353905>,
		<0.610846, 0.210083, -0.345275>,
		<0.721763, 0.199835, -0.353713>,
		<0.831209, 0.199506, -0.361339>,
		<1.17904, 0.184424, -0.195547>,
		<1.27525, 0.173024, -0.202703>,
		<1.17622, 0.174963, -0.195411>,
		<1.07469, 0.186453, -0.187642>,
		<1.14352, 0.184526, -0.379881>,
		<1.04082, 0.186507, -0.374257>,
		<1.14068, 0.175065, -0.379844>,
		<1.23857, 0.173182, -0.384894>,
		<1.52076, 0.15978, -0.220189>,
		<1.58778, 0.149774, -0.224871>,
		<1.51777, 0.150465, -0.22004>,
		<1.44595, 0.160703, -0.214965>,
		<1.64059, 0.14936, -0.316189>,
		<1.63158, 0.144851, -0.359478>,
		<1.63744, 0.140135, -0.316069>,
		<1.64645, 0.144644, -0.27278>,
		<1.48628, 0.160099, -0.396699>,
		<1.40976, 0.160973, -0.393225>,
		<1.48323, 0.150785, -0.396636>,
		<1.55551, 0.150141, -0.39982>,
		<-1.91185, 0.0657377, -2.09587>,
		<-1.82525, 0.0431796, -2.09587>,
		<-1.91163, 0.0200797, -2.09587>,
		<-1.9985, 0.0426245, -2.09587>,
		<-2.08539, 0.0657563, -1.8991>,
		<-2.08539, 0.0426316, -1.99702>,
		<-2.08539, 0.0200859, -1.89891>,
		<-2.08539, 0.0431933, -1.80264>,
		<-2.08539, 0.0671343, -1.52996>,
		<-2.08539, 0.043652, -1.61821>,
		<-2.08539, 0.0205452, -1.52948>,
		<-2.08539, 0.0440129, -1.44205>,
		<-2.08539, 0.0681708, -1.17302>,
		<-2.08539, 0.044355, -1.26419>,
		<-2.08539, 0.0208907, -1.17248>,
		<-2.08539, 0.0447055, -1.07961>,
		<-2.08539, 0.0691618, -0.790272>,
		<-2.08539, 0.0450391, -0.888209>,
		<-2.08539, 0.021221, -0.789851>,
		<-2.08539, 0.0453293, -0.690445>,
		<-2.08539, 0.0698079, -0.384233>,
		<-2.08539, 0.0455474, -0.487294>,
		<-2.08539, 0.0214364, -0.384008>,
		<-2.08539, 0.0456713, -0.2802>,
		<-2.08539, 0.0698472, 0.0336446>,
		<-2.08539, 0.0456849, -0.0710704>,
		<-2.08539, 0.0214495, 0.0336278>,
		<-2.08539, 0.0455844, 0.138084>,
		<-2.08539, 0.0692347, 0.447432>,
		<-2.08539, 0.0453779, 0.345145>,
		<-2.08539, 0.0212453, 0.447181>,
		<-2.08539, 0.0450835, 0.548304>,
		<-2.08539, 0.0681803, 0.842786>,
		<-2.08539, 0.0447284, 0.746061>,
		<-2.08539, 0.0208939, 0.842355>,
		<-2.08539, 0.0443415, 0.937419>,
		<-2.08539, 0.0670226, 1.21177>,
		<-2.08539, 0.0439525, 1.12189>,
		<-2.08539, 0.020508, 1.21123>,
		<-2.08539, 0.0435862, 1.29943>,
		<-2.08539, 0.0660461, 1.55415>,
		<-2.08539, 0.0432619, 1.47046>,
		<-2.08539, 0.0201825, 1.55368>,
		<-2.08539, 0.0429697, 1.63641>,
		<-1.88211, 0.0652607, 2.04294>,
		<-1.9832, 0.0423922, 2.04294>,
		<-1.88192, 0.0199207, 2.04294>,
		<-1.78285, 0.042775, 2.04294>,
		<-2.08539, 0.0651423, 1.88104>,
		<-2.08539, 0.0426701, 1.79973>,
		<-2.08539, 0.0198812, 1.88085>,
		<-2.08539, 0.04235, 1.96199>,
		<-1.56831, 0.0671661, -2.09587>,
		<-1.48193, 0.0440581, -2.09587>,
		<-1.56778, 0.0205558, -2.09587>,
		<-1.65361, 0.0436547, -2.09587>,
		<-1.50536, 0.0661556, 2.04294>,
		<-1.59458, 0.0430725, 2.04294>,
		<-1.5049, 0.020219, 2.04294>,
		<-1.41698, 0.0432909, 2.04294>,
		<-1.2157, 0.0683785, -2.09587>,
		<-1.12326, 0.04488, -2.09587>,
		<-1.21511, 0.0209599, -2.09587>,
		<-1.30589, 0.0444596, -2.09587>,
		<-1.14834, 0.0667913, 2.04294>,
		<-1.23913, 0.0434997, 2.04294>,
		<-1.14783, 0.0204309, 2.04294>,
		<-1.05565, 0.043724, 2.04294>,
		<-0.839384, 0.0695962, -2.09587>,
		<-0.747469, 0.0456523, -2.09587>,
		<-0.838937, 0.0213658, -2.09587>,
		<-0.933949, 0.0452909, -2.09587>,
		<-0.770531, 0.0674464, 2.04294>,
		<-0.866715, 0.0439448, 2.04294>,
		<-0.77014, 0.0206492, 2.04294>,
		<-0.672821, 0.0441424, 2.04294>,
		<-0.510508, 0.0703732, -2.09587>,
		<-0.441438, 0.046062, -2.09587>,
		<-0.510229, 0.0216248, -2.09587>,
		<-0.582938, 0.0459125, -2.09587>,
		<-0.374692, 0.0679001, 2.04294>,
		<-0.474808, 0.0442957, 2.04294>,
		<-0.374484, 0.0208005, 2.04294>,
		<-0.273791, 0.0443881, 2.04294>,
		<-0.23095, 0.0705857, -2.09587>,
		<-0.142148, 0.04612, -2.09587>,
		<-0.230836, 0.0216957, -2.09587>,
		<-0.306015, 0.0461339, -2.09587>,
		<0.030312, 0.0679564, 2.04294>,
		<-0.0711604, 0.0444074, 2.04294>,
		<0.0303015, 0.0208192, 2.04294>,
		<0.131618, 0.0443496, 2.04294>,
		<0.252955, 0.07014, -2.09587>,
		<0.407036, 0.0456867, -2.09587>,
		<0.252796, 0.0215471, -2.09587>,
		<0.102257, 0.0459717, -2.09587>,
		<0.432849, 0.0675697, 2.04294>,
		<0.333005, 0.0442192, 2.04294>,
		<0.432622, 0.0206903, 2.04294>,
		<0.531622, 0.044028, 2.04294>,
		<0.791468, 0.0690226, -2.09587>,
		<0.892116, 0.0448787, -2.09587>,
		<0.791051, 0.0211746, -2.09587>,
		<0.679771, 0.0453094, -2.09587>,
		<0.821985, 0.0668789, 2.04294>,
		<0.726259, 0.0437952, 2.04294>,
		<0.821581, 0.0204601, 2.04294>,
		<0.916012, 0.0435415, 2.04294>,
		<1.17137, 0.0676818, -2.09587>,
		<1.26081, 0.0439865, -2.09587>,
		<1.17086, 0.0207277, -2.09587>,
		<1.0798, 0.0444282, -2.09587>,
		<1.19053, 0.0661303, 2.04294>,
		<1.10029, 0.0432895, 2.04294>,
		<1.19001, 0.0202105, 2.04294>,
		<1.27882, 0.0430587, 2.04294>,
		<1.52147, 0.0664498, -2.09587>,
		<1.60725, 0.0431905, -2.09587>,
		<1.52102, 0.020317, -2.09587>,
		<1.43541, 0.0435769, -2.09587>,
		<1.53687, 0.0655438, 2.04294>,
		<1.45168, 0.0428655, 2.04294>,
		<1.5364, 0.020015, 2.04294>,
		<1.62147, 0.0426914, 2.04294>,
		<2.05696, 0.0653088, -1.9104>,
		<2.05696, 0.0428439, -1.81882>,
		<2.05696, 0.0199367, -1.91019>,
		<2.05696, 0.0423809, -2.00282>,
		<1.8738, 0.0652306, -2.09587>,
		<1.96509, 0.0423508, -2.09587>,
		<1.87362, 0.0199106, -2.09587>,
		<1.78329, 0.0427854, -2.09587>,
		<2.05696, 0.066326, -1.55482>,
		<2.05696, 0.0434028, -1.46828>,
		<2.05696, 0.0202758, -1.55431>,
		<2.05696, 0.043182, -1.64114>,
		<2.05696, 0.0669473, -1.20336>,
		<2.05696, 0.0438276, -1.11167>,
		<2.05696, 0.0204829, -1.2028>,
		<2.05696, 0.043605, -1.29299>,
		<2.05696, 0.0676031, -0.832892>,
		<2.05696, 0.0442422, -0.7481>,
		<2.05696, 0.0207015, -0.832472>,
		<2.05696, 0.04405, -0.924325>,
		<2.05696, 0.0679702, -0.567427>,
		<2.05696, 0.0444158, -0.51697>,
		<2.05696, 0.0208238, -0.567134>,
		<2.05696, 0.0443648, -0.61725>,
		<2.05696, 0.0680138, -0.291784>,
		<2.05696, 0.0444052, -0.182884>,
		<2.05696, 0.0208384, -0.291646>,
		<2.05696, 0.044431, -0.38339>,
		<2.05696, 0.0676753, 0.24123>,
		<2.05696, 0.0440902, 0.393992>,
		<2.05696, 0.0207255, 0.241081>,
		<2.05696, 0.0442928, 0.0879356>,
		<2.05696, 0.0669228, 0.771968>,
		<2.05696, 0.0435597, 0.871652>,
		<2.05696, 0.0204747, 0.771578>,
		<2.05696, 0.0438355, 0.661743>,
		<2.05696, 0.0661087, 1.1494>,
		<2.05696, 0.0430337, 1.23862>,
		<2.05696, 0.0202033, 1.14892>,
		<2.05696, 0.0432858, 1.05819>,
		<2.05696, 0.065462, 1.49916>,
		<2.05696, 0.042632, 1.58536>,
		<2.05696, 0.0199878, 1.49874>,
		<2.05696, 0.0428195, 1.41302>,
		<1.88082, 0.0649136, 2.04294>,
		<1.79334, 0.0424827, 2.04294>,
		<1.88064, 0.019805, 2.04294>,
		<1.9687, 0.0422281, 2.04294>,
		<2.05696, 0.0648585, 1.85572>,
		<2.05696, 0.0422089, 1.94899>,
		<2.05696, 0.0197866, 1.85556>,
		<2.05696, 0.0424323, 1.76352>,
		<1.88905, 0.0928509, 1.1193>,
		<1.97916, 0.0912681, 1.09274>,
		<1.91021, 0.0944438, 0.95145>,
		<1.81597, 0.0964039, 0.98022>,
		<1.84629, 0.0897798, 1.44375>,
		<1.95816, 0.0892634, 1.43027>,
		<1.86954, 0.0912325, 1.28075>,
		<1.75948, 0.0919467, 1.29155>,
		<1.66949, 0.0888285, 1.769>,
		<1.8333, 0.0879047, 1.90038>,
		<1.92592, 0.0878697, 1.80229>,
		<1.80787, 0.0887973, 1.62451>,
		<1.6553, 0.0894241, 1.60336>,
		<1.33947, 0.0912697, 1.82807>,
		<1.47702, 0.0893406, 1.93088>,
		<1.49687, 0.0898313, 1.80644>,
		<1.35777, 0.0919682, 1.70539>,
		<1.02017, 0.0944238, 1.86604>,
		<1.14634, 0.0912809, 1.95021>,
		<1.18294, 0.0928617, 1.84595>,
		<1.05918, 0.0963829, 1.75773>,
		<0.675475, 0.0972539, 1.91079>,
		<0.793121, 0.0932113, 1.97289>,
		<0.85126, 0.095871, 1.88816>,
		<0.736072, 0.100355, 1.81979>,
		<0.302465, 0.100221, 1.94679>,
		<0.41472, 0.0951132, 1.9926>,
		<0.491244, 0.0987584, 1.93104>,
		<0.379677, 0.10456, 1.88112>,
		<-0.0606505, 0.101223, 1.96034>,
		<0.0293758, 0.0962152, 2.00184>,
		<0.118501, 0.101127, 1.95677>,
		<0.0293915, 0.107077, 1.91411>,
		<-0.433285, 0.0992607, 1.9485>,
		<-0.356822, 0.0955329, 1.99981>,
		<-0.244358, 0.100518, 1.95753>,
		<-0.320168, 0.104945, 1.90192>,
		<-0.798935, 0.09672, 1.9147>,
		<-0.740266, 0.0939742, 1.98546>,
		<-0.619393, 0.0979454, 1.93359>,
		<-0.679928, 0.101154, 1.8563>,
		<-1.1401, 0.0938945, 1.87711>,
		<-1.10267, 0.0922201, 1.96551>,
		<-0.972456, 0.095388, 1.89526>,
		<-1.01197, 0.0974668, 1.80235>,
		<-1.46621, 0.0908611, 1.84014>,
		<-1.44396, 0.0902688, 1.94757>,
		<-1.3016, 0.0923259, 1.86052>,
		<-1.32075, 0.0931583, 1.75399>,
		<-1.34007, 0.0956719, 1.42604>,
		<-1.38985, 0.0957455, 1.37964>,
		<-1.44789, 0.0933828, 1.48249>,
		<-1.40646, 0.099251, 1.25909>,
		<-1.32269, 0.104849, 1.1572>,
		<-1.44155, 0.103833, 1.13582>,
		<-1.52881, 0.0983476, 1.24932>,
		<-1.48532, 0.108712, 1.00712>,
		<-1.41068, 0.116134, 0.90866>,
		<-1.53243, 0.1134, 0.871749>,
		<-1.61057, 0.10634, 0.97951>,
		<-1.58198, 0.117697, 0.729908>,
		<-1.51495, 0.126227, 0.634147>,
		<-1.64235, 0.121793, 0.57741>,
		<-1.70569, 0.113541, 0.682173>,
		<-1.73114, 0.126271, 0.405685>,
		<-1.72176, 0.136708, 0.297983>,
		<-1.83646, 0.130872, 0.224356>,
		<-1.84654, 0.120832, 0.333123>,
		<-1.90284, 0.133645, 0.0690739>,
		<-1.88452, 0.143609, 0.00225954>,
		<-1.90909, 0.133798, -0.0596855>,
		<-1.94147, 0.12504, 0.00631941>,
		<-1.85925, 0.131498, -0.202945>,
		<-1.7584, 0.137672, -0.270037>,
		<-1.77453, 0.127553, -0.366342>,
		<-1.87528, 0.121756, -0.30024>,
		<-1.70343, 0.123689, -0.528541>,
		<-1.59073, 0.128564, -0.585251>,
		<-1.65572, 0.120089, -0.682924>,
		<-1.76449, 0.115514, -0.634082>,
		<-1.61545, 0.116195, -0.830689>,
		<-1.507, 0.119414, -0.86996>,
		<-1.57519, 0.111825, -0.972201>,
		<-1.68605, 0.108985, -0.942888>,
		<-1.53606, 0.107173, -1.10699>,
		<-1.42858, 0.10869, -1.13028>,
		<-1.50301, 0.102693, -1.23638>,
		<-1.61282, 0.10132, -1.22528>,
		<-1.48477, 0.0991001, -1.36348>,
		<-1.43709, 0.0991296, -1.41325>,
		<-1.53386, 0.0963459, -1.47277>,
		<-1.32016, 0.102822, -1.42784>,
		<-1.2283, 0.108863, -1.34089>,
		<-1.19926, 0.107438, -1.46092>,
		<-1.30268, 0.101517, -1.55083>,
		<-1.07228, 0.112249, -1.50223>,
		<-0.98413, 0.119929, -1.42435>,
		<-0.938178, 0.116787, -1.54641>,
		<-1.03524, 0.10947, -1.62747>,
		<-0.797054, 0.120843, -1.59301>,
		<-0.714113, 0.129403, -1.52373>,
		<-0.654829, 0.124548, -1.65041>,
		<-0.741144, 0.1163, -1.71599>,
		<-0.52326, 0.128369, -1.73582>,
		<-0.457429, 0.138356, -1.72431>,
		<-0.405455, 0.13213, -1.83883>,
		<-0.470042, 0.122526, -1.85057>,
		<-0.297983, 0.134226, -1.90863>,
		<-0.246641, 0.143806, -1.89196>,
		<-0.17783, 0.133944, -1.92346>,
		<-0.239228, 0.125529, -1.95324>,
		<0.00895482, 0.131235, -1.8812>,
		<0.109662, 0.137111, -1.78236>,
		<0.248792, 0.126861, -1.80005>,
		<0.147881, 0.121378, -1.89977>,
		<0.463428, 0.122588, -1.72832>,
		<0.522832, 0.127154, -1.61504>,
		<0.632747, 0.118626, -1.67682>,
		<0.58781, 0.114367, -1.78656>,
		<0.782662, 0.114432, -1.6312>,
		<0.81603, 0.117312, -1.52098>,
		<0.925947, 0.109829, -1.58522>,
		<0.902816, 0.107325, -1.69796>,
		<1.06224, 0.105003, -1.54072>,
		<1.08054, 0.106171, -1.43156>,
		<1.19302, 0.100428, -1.50317>,
		<1.18701, 0.0993858, -1.61476>,
		<1.32166, 0.0968595, -1.48169>,
		<1.36993, 0.0967983, -1.43299>,
		<1.43396, 0.0943427, -1.52967>,
		<1.84789, 0.0929308, -1.37011>,
		<1.94807, 0.0906724, -1.50154>,
		<1.82703, 0.0914166, -1.52877>,
		<1.72847, 0.0939215, -1.39555>,
		<1.88301, 0.0961045, -1.04919>,
		<1.96616, 0.0926675, -1.16751>,
		<1.86457, 0.0945499, -1.21286>,
		<1.77743, 0.0983861, -1.09697>,
		<1.92372, 0.0987654, -0.717446>,
		<1.98681, 0.0944853, -0.814234>,
		<1.90316, 0.0974999, -0.879273>,
		<1.83405, 0.102238, -0.7773>,
		<1.95725, 0.101221, -0.493032>,
		<2.00477, 0.0959661, -0.554878>,
		<1.94212, 0.100054, -0.592215>,
		<1.89035, 0.105977, -0.530629>,
		<1.97748, 0.101621, -0.19301>,
		<2.01638, 0.0965379, -0.290308>,
		<1.96953, 0.101821, -0.370295>,
		<1.92905, 0.107806, -0.289147>,
		<1.96923, 0.0989925, 0.333106>,
		<2.01735, 0.0953365, 0.21662>,
		<1.97773, 0.10059, 0.0512088>,
		<1.92514, 0.104928, 0.167026>,
		<1.93235, 0.0959331, 0.777454>,
		<2.0019, 0.0932846, 0.728044>,
		<1.95327, 0.0973817, 0.581782>,
		<1.8772, 0.10047, 0.641247>,
		<-0.0173712, -0.00274933, -0.0279175>,
		<-1.81523, 0.090896, -1.7916>,
		<-1.89825, 0.0937049, -1.40769>,
		<-1.93635, 0.0973726, -1.08001>,
		<-1.97683, 0.100551, -0.727222>,
		<-2.01474, 0.10324, -0.351383>,
		<-2.02969, 0.10436, 0.0201542>,
		<-2.00235, 0.10241, 0.399006>,
		<-1.95158, 0.0990237, 0.776145>,
		<-1.90352, 0.0954822, 1.11603>,
		<-1.86113, 0.0917679, 1.42981>,
		<-1.77143, 0.0893414, 1.77682>,
		<-1.45851, 0.0938311, -1.87941>,
		<-1.21453, 0.120449, -1.10275>,
		<-1.29333, 0.135146, -0.853969>,
		<-1.37658, 0.147831, -0.580339>,
		<-1.57784, 0.158574, -0.267123>,
		<-1.72814, 0.145381, -0.0115955>,
		<-1.53445, 0.157567, 0.27519>,
		<-1.2859, 0.145111, 0.616467>,
		<-1.1785, 0.131175, 0.883176>,
		<-1.08953, 0.115667, 1.12283>,
		<-1.15181, 0.100936, 1.4488>,
		<-1.14067, 0.0977407, -1.91877>,
		<-0.982327, 0.135532, -1.18833>,
		<-1.05749, 0.154781, -0.937928>,
		<-1.13491, 0.17182, -0.654443>,
		<-1.29405, 0.183817, -0.316148>,
		<-1.40083, 0.169525, -0.0413005>,
		<-1.24629, 0.182872, 0.270274>,
		<-1.03478, 0.169016, 0.646053>,
		<-0.930073, 0.150416, 0.931564>,
		<-0.84437, 0.13009, 1.18056>,
		<-0.886433, 0.109636, 1.51328>,
		<-0.798814, 0.101213, -1.96255>,
		<-0.722711, 0.148567, -1.29302>,
		<-0.785698, 0.17218, -1.04178>,
		<-0.847447, 0.196166, -0.74872>,
		<-0.937617, 0.212117, -0.381487>,
		<-0.984047, 0.194028, -0.0808067>,
		<-0.88561, 0.211492, 0.256718>,
		<-0.738307, 0.193883, 0.669581>,
		<-0.646621, 0.167933, 0.979541>,
		<-0.573036, 0.142898, 1.24183>,
		<-0.595593, 0.117179, 1.58434>,
		<-0.494133, 0.104027, -2.00996>,
		<-0.457762, 0.159035, -1.53944>,
		<-0.476741, 0.183918, -1.25986>,
		<-0.490407, 0.212061, -0.909219>,
		<-0.501057, 0.227235, -0.475833>,
		<-0.496679, 0.204973, -0.132852>,
		<-0.439045, 0.226897, 0.228971>,
		<-0.354421, 0.21141, 0.692128>,
		<-0.290342, 0.18248, 1.06982>,
		<-0.24035, 0.156242, 1.38422>,
		<-0.262552, 0.12611, 1.69038>,
		<-0.233626, 0.105175, -2.04231>,
		<-0.243395, 0.145585, -1.72755>,
		<-0.223427, 0.169533, -1.41409>,
		<-0.194936, 0.194, -1.00657>,
		<-0.156902, 0.204972, -0.534655>,
		<-0.12485, 0.205312, -0.174828>,
		<-0.0861597, 0.204987, 0.197596>,
		<-0.0348704, 0.19446, 0.690794>,
		<0.00728641, 0.170201, 1.12231>,
		<0.0400338, 0.145514, 1.48063>,
		<0.0403984, 0.13196, 1.75177>,
		<0.210836, 0.103305, -2.03336>,
		<0.0924444, 0.157803, -1.60746>,
		<0.117368, 0.182919, -1.33601>,
		<0.152545, 0.211439, -0.987266>,
		<0.204859, 0.226893, -0.55619>,
		<0.246222, 0.204985, -0.213101>,
		<0.276713, 0.226635, 0.159855>,
		<0.300985, 0.211072, 0.635384>,
		<0.310849, 0.182056, 1.01858>,
		<0.310997, 0.155837, 1.33773>,
		<0.335965, 0.12574, 1.65408>,
		<0.708461, 0.0999454, -1.99281>,
		<0.49479, 0.14617, -1.40403>,
		<0.533465, 0.170066, -1.16823>,
		<0.583566, 0.194673, -0.888193>,
		<0.668345, 0.211715, -0.544931>,
		<0.734679, 0.194407, -0.257261>,
		<0.736651, 0.211115, 0.109291>,
		<0.706178, 0.192667, 0.555388>,
		<0.672563, 0.166529, 0.879063>,
		<0.631492, 0.141611, 1.15456>,
		<0.658978, 0.116197, 1.51913>,
		<1.0625, 0.0963449, -1.94683>,
		<0.780239, 0.132598, -1.31009>,
		<0.835531, 0.151999, -1.07794>,
		<0.904702, 0.169499, -0.811585>,
		<1.0434, 0.183321, -0.524436>,
		<1.15704, 0.170284, -0.287584>,
		<1.10906, 0.182208, 0.07292>,
		<1.0125, 0.166721, 0.503361>,
		<0.956093, 0.148117, 0.805527>,
		<0.897081, 0.128093, 1.07103>,
		<0.941593, 0.108172, 1.4324>,
		<1.38715, 0.0924672, -1.90362>,
		<1.03671, 0.117313, -1.21945>,
		<1.09974, 0.131988, -0.989669>,
		<1.17767, 0.144886, -0.734942>,
		<1.35348, 0.157563, -0.498919>,
		<1.49899, 0.145967, -0.308285>,
		<1.41238, 0.156198, 0.047419>,
		<1.27086, 0.141933, 0.464038>,
		<1.20325, 0.128191, 0.747489>,
		<1.13599, 0.11314, 1.00399>,
		<1.19805, 0.0991579, 1.36082>,
		<1.75977, 0.0897684, -1.81447>,
		<1.3901, 0.102258, -1.25652>,
		<1.45713, 0.111207, -1.00421>,
		<1.53693, 0.118932, -0.728658>,
		<1.66329, 0.127573, -0.501778>,
		<1.76368, 0.132799, -0.299239>,
		<1.71449, 0.126201, 0.0924016>,
		<1.60977, 0.116439, 0.522314>,
		<1.53074, 0.108253, 0.822929>,
		<1.45599, 0.099177, 1.09603>,
		<1.42744, 0.0931152, 1.34443>,
		<-1.72469, 0.154677, 0.0744575>,
		<-1.7368, 0.154672, -0.0970235>,
		<-1.85629, 0.144366, 0.000434551>,
		<-1.39792, 0.178926, 0.047586>,
		<-1.41157, 0.178861, -0.129364>,
		<-0.980109, 0.204938, 0.0121058>,
		<-0.995323, 0.204917, -0.172869>,
		<-0.488769, 0.216225, -0.0357474>,
		<-0.506216, 0.216274, -0.229601>,
		<-0.158389, 0.154475, -1.75598>,
		<-0.25115, 0.144553, -1.85426>,
		<-0.32958, 0.154904, -1.72005>,
		<-0.135572, 0.178518, -1.44693>,
		<-0.312918, 0.178799, -1.40837>,
		<-0.103176, 0.204678, -1.03661>,
		<-0.288692, 0.20481, -1.00458>,
		<-0.0601548, 0.216188, -0.553849>,
		<-0.254163, 0.216256, -0.527917>,
		<0.0134686, 0.216081, 0.18876>,
		<-0.185083, 0.21612, 0.209307>,
		<0.0626866, 0.205297, 0.684028>,
		<-0.131882, 0.205271, 0.703211>,
		<0.10152, 0.179706, 1.11541>,
		<-0.0863152, 0.179615, 1.13495>,
		<0.0533602, 0.144107, 1.63122>,
		<0.130878, 0.154878, 1.47342>,
		<-0.0501711, 0.154777, 1.49405>,
		<0.259118, 0.216105, -0.113935>,
		<0.236249, 0.21615, -0.312035>,
		<0.751781, 0.205255, -0.161045>,
		<0.723151, 0.205269, -0.353809>,
		<1.17763, 0.179693, -0.195479>,
		<1.1421, 0.179795, -0.379862>,
		<1.51927, 0.155122, -0.220114>,
		<1.63901, 0.144748, -0.316129>,
		<1.48476, 0.155442, -0.396667>,
		<-1.91174, 0.0429087, -2.09587>,
		<-2.08539, 0.0429211, -1.899>,
		<-2.08539, 0.0438397, -1.52972>,
		<-2.08539, 0.0445308, -1.17275>,
		<-2.08539, 0.0451914, -0.790061>,
		<-2.08539, 0.0456221, -0.384121>,
		<-2.08539, 0.0456484, 0.0336362>,
		<-2.08539, 0.04524, 0.447306>,
		<-2.08539, 0.0445371, 0.842571>,
		<-2.08539, 0.0437653, 1.2115>,
		<-2.08539, 0.0431143, 1.55392>,
		<-1.88201, 0.0425907, 2.04294>,
		<-2.08539, 0.0425117, 1.88094>,
		<-1.56805, 0.043861, -2.09587>,
		<-1.50513, 0.0431873, 2.04294>,
		<-1.21541, 0.0446692, -2.09587>,
		<-1.14808, 0.0436111, 2.04294>,
		<-0.839161, 0.045481, -2.09587>,
		<-0.770335, 0.0440478, 2.04294>,
		<-0.510369, 0.045999, -2.09587>,
		<-0.374588, 0.0443503, 2.04294>,
		<-0.230893, 0.0461407, -2.09587>,
		<0.0303067, 0.0443878, 2.04294>,
		<0.252875, 0.0458435, -2.09587>,
		<0.432735, 0.04413, 2.04294>,
		<0.79126, 0.0450986, -2.09587>,
		<0.821783, 0.0436695, 2.04294>,
		<1.17112, 0.0442048, -2.09587>,
		<1.19027, 0.0431704, 2.04294>,
		<1.52124, 0.0433834, -2.09587>,
		<1.53664, 0.0427794, 2.04294>,
		<2.05696, 0.0426228, -1.91029>,
		<1.87371, 0.0425706, -2.09587>,
		<2.05696, 0.0433009, -1.55456>,
		<2.05696, 0.0437151, -1.20308>,
		<2.05696, 0.0441523, -0.832682>,
		<2.05696, 0.044397, -0.56728>,
		<2.05696, 0.0444261, -0.291715>,
		<2.05696, 0.0442004, 0.241155>,
		<2.05696, 0.0436988, 0.771773>,
		<2.05696, 0.043156, 1.14916>,
		<2.05696, 0.0427249, 1.49895>,
		<1.88073, 0.0423593, 2.04294>,
		<2.05696, 0.0423226, 1.85564>,
		<1.89946, 0.0936554, 1.03616>,
		<1.8591, 0.0904664, 1.36104>,
		<1.77691, 0.0884746, 1.73837>,
		<1.41717, 0.0905137, 1.81847>,
		<1.10233, 0.0936518, 1.85573>,
		<0.764325, 0.0965589, 1.8996>,
		<0.396838, 0.099527, 1.93955>,
		<0.028909, 0.101276, 1.95936>,
		<-0.338671, 0.0999274, 1.95377>,
		<-0.709951, 0.0973337, 1.92443>,
		<-1.05703, 0.0946561, 1.88601>,
		<-1.38234, 0.0915636, 1.85148>,
		<-1.39175, 0.0948775, 1.42872>,
		<-1.42231, 0.101456, 1.19796>,
		<-1.50851, 0.111093, 0.940256>,
		<-1.60971, 0.119734, 0.655527>,
		<-1.78432, 0.128624, 0.314482>,
		<-1.91178, 0.133972, 0.00403697>,
		<-1.8174, 0.129573, -0.283891>,
		<-1.67765, 0.121891, -0.606634>,
		<-1.59525, 0.114058, -0.902256>,
		<-1.51823, 0.104866, -1.17217>,
		<-1.48456, 0.0981394, -1.41572>,
		<-1.26034, 0.10506, -1.44271>,
		<-1.00611, 0.114565, -1.52398>,
		<-0.725344, 0.12271, -1.61929>,
		<-0.462984, 0.130308, -1.7875>,
		<-0.242286, 0.134322, -1.92167>,
		<0.127889, 0.129095, -1.8417>,
		<0.552133, 0.120602, -1.70094>,
		<0.855156, 0.11217, -1.60814>,
		<1.12811, 0.102637, -1.52051>,
		<1.37443, 0.0959455, -1.48072>,
		<1.83872, 0.0921454, -1.44828>,
		<1.87357, 0.0953411, -1.13182>,
		<1.91355, 0.0981393, -0.795567>,
		<1.95006, 0.10068, -0.542467>,
		<1.97425, 0.101823, -0.289245>,
		<1.97449, 0.0998276, 0.191879>,
		<1.9432, 0.0966498, 0.684286>,
		<-1.91152, -0.00274934, -2.09587>,
		<-2.08539, -0.00274934, -1.89881>,
		<-2.08539, -0.00274934, -1.52923>,
		<-2.08539, -0.00274934, -1.17221>,
		<-2.08539, -0.00274934, -0.78964>,
		<-2.08539, -0.00274934, -0.383896>,
		<-2.08539, -0.00274934, 0.0336194>,
		<-2.08539, -0.00274934, 0.447055>,
		<-2.08539, -0.00274934, 0.842139>,
		<-2.08539, -0.00274934, 1.21097>,
		<-2.08539, -0.00274934, 1.55345>,
		<-1.88183, -0.00274934, 2.04294>,
		<-2.08539, -0.00274934, 1.88075>,
		<-1.56751, -0.00274934, -2.09587>,
		<-1.50467, -0.00274934, 2.04294>,
		<-1.21482, -0.00274934, -2.09587>,
		<-1.14757, -0.00274934, 2.04294>,
		<-0.838713, -0.00274934, -2.09587>,
		<-0.769944, -0.00274934, 2.04294>,
		<-0.51009, -0.00274934, -2.09587>,
		<-0.37438, -0.00274934, 2.04294>,
		<-0.230779, -0.00274934, -2.09587>,
		<0.0302963, -0.00274934, 2.04294>,
		<0.252716, -0.00274934, -2.09587>,
		<0.432508, -0.00274934, 2.04294>,
		<0.790843, -0.00274934, -2.09587>,
		<0.821379, -0.00274934, 2.04294>,
		<1.1706, -0.00274934, -2.09587>,
		<1.18975, -0.00274934, 2.04294>,
		<1.52079, -0.00274934, -2.09587>,
		<1.53617, -0.00274934, 2.04294>,
		<2.05696, -0.00274934, -1.91009>,
		<1.87353, -0.00274934, -2.09587>,
		<2.05696, -0.00274934, -1.55405>,
		<2.05696, -0.00274934, -1.20253>,
		<2.05696, -0.00274934, -0.832262>,
		<2.05696, -0.00274934, -0.566987>,
		<2.05696, -0.00274934, -0.291577>,
		<2.05696, -0.00274934, 0.241006>,
		<2.05696, -0.00274934, 0.771384>,
		<2.05696, -0.00274934, 1.14867>,
		<2.05696, -0.00274934, 1.49853>,
		<1.88054, -0.00274934, 2.04294>,
		<2.05696, -0.00274934, 1.85548>,
		<-1.49149, 0.100741, -1.30002>,
		<-1.62143, 0.0921511, -1.84881>,
		<-1.91196, 0.0885667, -2.09587>,
		<-2.08539, 0.0885915, -1.8992>,
		<-1.55541, 0.109522, -1.04047>,
		<-1.34705, 0.112638, -1.10355>,
		<-2.08539, 0.0904288, -1.5302>,
		<-1.63565, 0.118214, -0.757558>,
		<-1.42567, 0.124824, -0.849849>,
		<-2.08539, 0.0918109, -1.17329>,
		<-1.73506, 0.125553, -0.448493>,
		<-1.50937, 0.135246, -0.572764>,
		<-2.08539, 0.0931322, -0.790483>,
		<-1.89237, 0.133011, -0.127033>,
		<-1.69874, 0.145445, -0.261555>,
		<-2.08539, 0.0939936, -0.384346>,
		<-1.87887, 0.132663, 0.140742>,
		<-1.85848, 0.1536, 0.000734601>,
		<-2.08539, 0.0940461, 0.033653>,
		<-1.68209, 0.123948, 0.494487>,
		<-1.65924, 0.144469, 0.285372>,
		<-2.08539, 0.0932293, 0.447558>,
		<-1.55695, 0.11561, 0.801625>,
		<-1.42716, 0.132747, 0.619943>,
		<-2.08539, 0.0918235, 0.843002>,
		<-1.46296, 0.106284, 1.07231>,
		<-1.3215, 0.121259, 0.887696>,
		<-2.08539, 0.0902799, 1.21203>,
		<-1.39523, 0.097315, 1.31954>,
		<-1.23308, 0.10841, 1.13021>,
		<-2.08539, 0.0889779, 1.55439>,
		<-1.8822, 0.0879308, 2.04294>,
		<-1.27768, 0.0971257, 1.42902>,
		<-2.08539, 0.0877728, 1.88113>,
		<-1.20927, 0.112773, -1.24908>,
		<-1.30223, 0.0957809, -1.89907>,
		<-1.56858, 0.0904713, -2.09587>,
		<-1.25168, 0.127923, -0.980132>,
		<-1.10068, 0.128108, -1.1417>,
		<-1.33409, 0.141856, -0.720723>,
		<-1.17859, 0.145061, -0.892136>,
		<-1.44945, 0.153299, -0.4299>,
		<-1.26005, 0.15985, -0.613747>,
		<-1.7394, 0.163966, -0.0966879>,
		<-1.44751, 0.170817, -0.288832>,
		<-1.72731, 0.163971, 0.074747>,
		<-1.58217, 0.156629, -0.0249637>,
		<-1.37877, 0.151363, 0.459646>,
		<-1.40176, 0.169813, 0.273236>,
		<-1.22934, 0.138469, 0.754186>,
		<-1.16427, 0.157031, 0.630668>,
		<-1.13008, 0.12347, 1.00483>,
		<-1.05701, 0.140843, 0.905805>,
		<-1.08772, 0.10804, 1.26342>,
		<-0.968671, 0.122957, 1.14949>,
		<-1.50559, 0.0891239, 2.04294>,
		<-1.02219, 0.10533, 1.47955>,
		<-0.972001, 0.125323, -1.33343>,
		<-0.972155, 0.0995803, -1.93998>,
		<-1.21599, 0.0920877, -2.09587>,
		<-1.01812, 0.145266, -1.06575>,
		<-0.856083, 0.142438, -1.23751>,
		<-1.09591, 0.163767, -0.801>,
		<-0.92653, 0.163968, -0.986908>,
		<-1.19498, 0.178574, -0.493889>,
		<-0.997607, 0.183976, -0.69909>,
		<-1.41548, 0.18823, -0.128906>,
		<-1.12215, 0.19777, -0.347057>,
		<-1.40184, 0.188294, 0.047951>,
		<-1.19689, 0.182601, -0.0600903>,
		<-1.11727, 0.176661, 0.474397>,
		<-1.07242, 0.196951, 0.264876>,
		<-0.979783, 0.160145, 0.794567>,
		<-0.893286, 0.181335, 0.659241>,
		<-0.883418, 0.140269, 1.05885>,
		<-0.793704, 0.159563, 0.955944>,
		<-0.838188, 0.119844, 1.32457>,
		<-0.712856, 0.136787, 1.21073>,
		<-1.14859, 0.0899715, 2.04294>,
		<-0.74438, 0.113601, 1.54809>,
		<-0.709331, 0.136079, -1.43521>,
		<-0.63518, 0.102688, -1.98616>,
		<-0.839608, 0.0937113, -2.09587>,
		<-0.753019, 0.160413, -1.17107>,
		<-0.588093, 0.154028, -1.38501>,
		<-0.817239, 0.184136, -0.901297>,
		<-0.635434, 0.178933, -1.12606>,
		<-0.884981, 0.206122, -0.577184>,
		<-0.679528, 0.206175, -0.815363>,
		<-0.998983, 0.215832, -0.172382>,
		<-0.732831, 0.223047, -0.423333>,
		<-0.983787, 0.215823, 0.0124682>,
		<-0.753634, 0.201923, -0.104706>,
		<-0.800472, 0.204767, 0.481012>,
		<-0.677056, 0.222605, 0.244934>,
		<-0.690421, 0.180844, 0.831794>,
		<-0.56096, 0.204535, 0.679685>,
		<-0.606347, 0.155346, 1.11473>,
		<-0.480893, 0.175538, 1.01406>,
		<-0.564458, 0.130206, 1.39075>,
		<-0.417555, 0.149139, 1.29382>,
		<-0.770727, 0.090845, 2.04294>,
		<-0.435636, 0.121146, 1.6301>,
		<-0.454375, 0.146065, -1.66175>,
		<-0.366177, 0.104952, -2.03006>,
		<-0.510648, 0.0947474, -2.09587>,
		<-0.46731, 0.171095, -1.41074>,
		<-0.330069, 0.164009, -1.73059>,
		<-0.484579, 0.197747, -1.09091>,
		<-0.313587, 0.187927, -1.42188>,
		<-0.495471, 0.223012, -0.706591>,
		<-0.289604, 0.215577, -1.01851>,
		<-0.507022, 0.227576, -0.229373>,
		<-0.254232, 0.227538, -0.534318>,
		<-0.489589, 0.227476, -0.0356193>,
		<-0.224743, 0.205312, -0.163367>,
		<-0.392862, 0.222485, 0.476095>,
		<-0.184578, 0.227255, 0.210715>,
		<-0.321212, 0.196849, 0.88649>,
		<-0.13164, 0.216106, 0.70603>,
		<-0.262507, 0.168969, 1.23699>,
		<-0.085949, 0.189075, 1.13781>,
		<-0.23573, 0.142611, 1.53082>,
		<-0.0498035, 0.164091, 1.49716>,
		<-0.374796, 0.0914499, 2.04294>,
		<-0.0953864, 0.130602, 1.74208>,
		<-0.251644, 0.153634, -1.86319>,
		<-0.052045, 0.104618, -2.04393>,
		<-0.231007, 0.0950307, -2.09587>,
		<-0.234705, 0.156717, -1.58911>,
		<-0.159078, 0.163579, -1.76638>,
		<-0.210004, 0.182571, -1.21522>,
		<-0.136538, 0.18764, -1.46053>,
		<-0.177451, 0.201914, -0.781979>,
		<-0.104261, 0.215398, -1.05071>,
		<-0.134654, 0.205312, -0.274572>,
		<-0.0605985, 0.227405, -0.559904>,
		<-0.115045, 0.205312, -0.075083>,
		<-0.0249562, 0.205312, -0.186289>,
		<-0.0589829, 0.20206, 0.456417>,
		<0.0136677, 0.227175, 0.190226>,
		<-0.0130572, 0.183285, 0.909799>,
		<0.062989, 0.216112, 0.686858>,
		<0.0252569, 0.157091, 1.31637>,
		<0.101786, 0.189164, 1.11829>,
		<0.0536926, 0.15333, 1.6345>,
		<0.13115, 0.164192, 1.47654>,
		<0.0303172, 0.091525, 2.04294>,
		<0.174634, 0.130499, 1.72404>,
		<0.0964604, 0.14481, -1.72311>,
		<0.487543, 0.101622, -2.01476>,
		<0.253035, 0.0944364, -2.09587>,
		<0.102954, 0.169949, -1.48398>,
		<0.316954, 0.15211, -1.47953>,
		<0.133923, 0.196932, -1.16835>,
		<0.346982, 0.177303, -1.23322>,
		<0.175547, 0.222558, -0.785396>,
		<0.387538, 0.205114, -0.931295>,
		<0.237718, 0.227315, -0.311762>,
		<0.452489, 0.222595, -0.551502>,
		<0.260571, 0.227226, -0.113974>,
		<0.503099, 0.202042, -0.237424>,
		<0.290771, 0.222198, 0.414594>,
		<0.522273, 0.222232, 0.132167>,
		<0.307514, 0.196458, 0.832733>,
		<0.520323, 0.203802, 0.589994>,
		<0.31152, 0.16854, 1.18808>,
		<0.50504, 0.174612, 0.934809>,
		<0.316616, 0.142238, 1.48803>,
		<0.480487, 0.148264, 1.22428>,
		<0.432962, 0.0910093, 2.04294>,
		<0.503495, 0.120457, 1.57737>,
		<0.502622, 0.133733, -1.53463>,
		<0.890857, 0.0982196, -1.96965>,
		<0.791676, 0.0929466, -2.09587>,
		<0.511648, 0.158109, -1.29016>,
		<0.642614, 0.139722, -1.35672>,
		<0.557208, 0.182294, -1.03449>,
		<0.69068, 0.161484, -1.12322>,
		<0.618838, 0.205099, -0.725769>,
		<0.751441, 0.182061, -0.85086>,
		<0.725927, 0.216137, -0.354001>,
		<0.861769, 0.197409, -0.535979>,
		<0.75458, 0.216097, -0.161186>,
		<0.949785, 0.183246, -0.273571>,
		<0.720235, 0.203861, 0.354683>,
		<0.92886, 0.196527, 0.0900351>,
		<0.691317, 0.179484, 0.724703>,
		<0.866712, 0.179582, 0.52796>,
		<0.651257, 0.153971, 1.02082>,
		<0.820057, 0.1577, 0.840299>,
		<0.629424, 0.129055, 1.31233>,
		<0.768447, 0.135131, 1.11049>,
		<0.822187, 0.0900884, 2.04294>,
		<0.803741, 0.112361, 1.4738>,
		<0.789245, 0.122534, -1.4407>,
		<1.2273, 0.0943874, -1.92513>,
		<1.17163, 0.0911589, -2.09587>,
		<0.804752, 0.142363, -1.19702>,
		<0.910294, 0.125032, -1.26231>,
		<0.868298, 0.16117, -0.949334>,
		<0.970441, 0.142049, -1.03166>,
		<0.95901, 0.17688, -0.668621>,
		<1.04528, 0.157173, -0.771503>,
		<1.14493, 0.189257, -0.379899>,
		<1.20841, 0.170077, -0.511391>,
		<1.18045, 0.189154, -0.195616>,
		<1.344, 0.157356, -0.299194>,
		<1.05006, 0.17485, 0.313176>,
		<1.27153, 0.168802, 0.0580685>,
		<0.985297, 0.157787, 0.660599>,
		<1.14561, 0.154242, 0.481075>,
		<0.92496, 0.138096, 0.940932>,
		<1.08238, 0.138157, 0.773177>,
		<0.895873, 0.118083, 1.22647>,
		<1.01836, 0.120659, 1.03376>,
		<1.19079, 0.0890902, 2.04294>,
		<1.07297, 0.103683, 1.39416>,
		<1.04825, 0.109862, -1.35082>,
		<1.5556, 0.0908648, -1.87183>,
		<1.52169, 0.0895162, -2.09587>,
		<1.06477, 0.124742, -1.10663>,
		<1.18839, 0.109628, -1.20929>,
		<1.13652, 0.138763, -0.865271>,
		<1.25371, 0.121695, -0.974162>,
		<1.24403, 0.150943, -0.60957>,
		<1.33334, 0.132189, -0.716542>,
		<1.4878, 0.164757, -0.396731>,
		<1.49966, 0.144062, -0.493708>,
		<1.52226, 0.164437, -0.220263>,
		<1.64217, 0.153973, -0.316249>,
		<1.32346, 0.148667, 0.283057>,
		<1.55419, 0.142669, 0.0536196>,
		<1.23733, 0.135325, 0.610819>,
		<1.41805, 0.129374, 0.472059>,
		<1.16752, 0.120696, 0.877242>,
		<1.3455, 0.118188, 0.756131>,
		<1.13758, 0.105837, 1.15684>,
		<1.27476, 0.105855, 1.01501>,
		<1.53711, 0.0883082, 2.04294>,
		<1.31891, 0.0953034, 1.34122>,
		<1.81132, 0.0907751, -1.61355>,
		<2.05696, 0.0879949, -1.9105>,
		<1.87389, 0.0878905, -2.09587>,
		<1.85601, 0.0937425, -1.2923>,
		<2.05696, 0.0893511, -1.55507>,
		<1.89287, 0.096828, -0.965002>,
		<2.05696, 0.0901795, -1.20364>,
		<1.93335, 0.0993972, -0.648474>,
		<2.05696, 0.091054, -0.833101>,
		<1.96372, 0.101619, -0.437708>,
		<2.05696, 0.0915434, -0.567574>,
		<1.97878, 0.101211, -0.0800415>,
		<2.05696, 0.0916015, -0.291853>,
		<1.96211, 0.0981541, 0.466028>,
		<2.05696, 0.0911501, 0.241304>,
		<1.9212, 0.0952062, 0.865203>,
		<2.05696, 0.0901469, 0.772163>,
		<1.87904, 0.09204, 1.20084>,
		<2.05696, 0.0890614, 1.14964>,
		<1.82969, 0.0892107, 1.5309>,
		<2.05696, 0.0881991, 1.49937>,
		<1.88092, 0.0874679, 2.04294>,
		<2.05696, 0.0873945, 1.85581>,
		<-1.72208, 0.145383, 0.074168>,
		<-1.7342, 0.145378, -0.0973591>,
		<-1.85409, 0.135132, 0.000134502>,
		<-1.394, 0.169558, 0.047221>,
		<-1.40766, 0.169492, -0.129822>,
		<-0.976431, 0.194053, 0.0117433>,
		<-0.991663, 0.194002, -0.173357>,
		<-0.487949, 0.204974, -0.0358756>,
		<-0.50541, 0.204972, -0.229829>,
		<-0.1577, 0.14537, -1.74559>,
		<-0.250657, 0.135471, -1.84533>,
		<-0.32909, 0.1458, -1.70952>,
		<-0.134605, 0.169397, -1.43332>,
		<-0.312248, 0.16967, -1.39487>,
		<-0.102091, 0.193958, -1.02251>,
		<-0.28778, 0.194043, -0.990644>,
		<-0.059711, 0.204971, -0.547795>,
		<-0.254094, 0.204973, -0.521515>,
		<0.0132694, 0.204987, 0.187294>,
		<-0.185589, 0.204986, 0.207898>,
		<0.0623841, 0.194483, 0.681197>,
		<-0.132125, 0.194437, 0.700391>,
		<0.101254, 0.170247, 1.11254>,
		<-0.0866813, 0.170156, 1.13208>,
		<0.0530278, 0.134884, 1.62795>,
		<0.130606, 0.145565, 1.4703>,
		<-0.0505387, 0.145463, 1.49095>,
		<0.257665, 0.204985, -0.113895>,
		<0.234779, 0.204985, -0.312308>,
		<0.748982, 0.194413, -0.160904>,
		<0.720376, 0.194401, -0.353617>,
		<1.17481, 0.170233, -0.195343>,
		<1.13926, 0.170334, -0.379825>,
		<1.51627, 0.145807, -0.219965>,
		<1.63586, 0.135523, -0.316009>,
		<1.48171, 0.146127, -0.396604>,
		<-1.57889, 0.165974, 0.0622769>,
		<-1.85064, 0.144355, 0.0852585>,
		<-1.86194, 0.144376, -0.0843893>,
		<-1.59178, 0.16594, -0.111512>,
		<-1.19395, 0.192443, 0.0307505>,
		<-1.20836, 0.192376, -0.15002>,
		<-0.747934, 0.213602, -0.00968743>,
		<-0.764123, 0.213634, -0.199072>,
		<-0.214406, 0.215426, -0.064191>,
		<-0.23327, 0.215469, -0.262533>,
		<-0.166647, 0.144317, -1.86931>,
		<-0.148475, 0.165638, -1.62081>,
		<-0.335653, 0.144788, -1.83921>,
		<-0.322326, 0.166008, -1.58146>,
		<-0.120259, 0.192056, -1.24736>,
		<-0.301619, 0.192248, -1.21198>,
		<-0.0834048, 0.213487, -0.807864>,
		<-0.273144, 0.213582, -0.779001>,
		<-0.0349708, 0.215423, -0.285668>,
		<-0.0147164, 0.215384, -0.0859396>,
		<0.0397712, 0.213552, 0.449077>,
		<-0.157197, 0.213571, 0.468693>,
		<0.0829749, 0.193192, 0.903039>,
		<-0.108476, 0.19312, 0.92223>,
		<0.11768, 0.166521, 1.30932>,
		<-0.0665397, 0.166426, 1.32937>,
		<0.142436, 0.144162, 1.62062>,
		<-0.0357156, 0.144052, 1.64183>,
		<0.518351, 0.213567, -0.139591>,
		<0.492734, 0.213605, -0.335517>,
		<0.968589, 0.193116, -0.179278>,
		<0.936579, 0.193138, -0.368082>,
		<1.36541, 0.166632, -0.209227>,
		<1.32841, 0.166848, -0.389349>,
		<1.65388, 0.144541, -0.229431>,
		<1.62415, 0.144954, -0.402828>,
		<-1.73916, 0.0434304, -2.09587>,
		<-2.08539, 0.0423336, -2.09587>,
		<-2.08539, 0.0434398, -1.70877>,
		<-2.08539, 0.0441814, -1.35396>,
		<-2.08539, 0.044876, -0.984766>,
		<-2.08539, 0.0454491, -0.589481>,
		<-2.08539, 0.0456929, -0.175771>,
		<-2.08539, 0.0454939, 0.242009>,
		<-2.08539, 0.0449118, 0.647952>,
		<-2.08539, 0.0441454, 1.03055>,
		<-2.08539, 0.0434176, 1.38573>,
		<-2.08539, 0.0428233, 1.71824>,
		<-2.08539, 0.0421865, 2.04294>,
		<-1.6867, 0.042938, 2.04294>,
		<-1.39473, 0.0442547, -2.09587>,
		<-1.32876, 0.0433922, 2.04294>,
		<-1.02945, 0.0450884, -2.09587>,
		<-0.961855, 0.043836, 2.04294>,
		<-0.661265, 0.0457983, -2.09587>,
		<-0.574277, 0.0442259, 2.04294>,
		<-0.374026, 0.0461056, -2.09587>,
		<-0.17259, 0.0444077, 2.04294>,
		<-0.0332686, 0.0460657, -2.09587>,
		<0.232582, 0.0442931, 2.04294>,
		<0.553185, 0.0455068, -2.09587>,
		<0.629514, 0.0439156, 2.04294>,
		<0.986806, 0.0446538, -2.09587>,
		<1.00887, 0.0434138, 2.04294>,
		<1.34889, 0.0437762, -2.09587>,
		<1.36595, 0.0429564, 2.04294>,
		<1.6943, 0.0429929, -2.09587>,
		<1.70683, 0.0425947, 2.04294>,
		<2.05696, 0.0430337, -1.72893>,
		<2.05696, 0.0421286, -2.09587>,
		<2.05696, 0.0435001, -1.38139>,
		<2.05696, 0.0439401, -1.01875>,
		<2.05696, 0.0443146, -0.674862>,
		<2.05696, 0.0444257, -0.458334>,
		<2.05696, 0.0443627, -0.0564751>,
		<2.05696, 0.0439669, 0.537252>,
		<2.05696, 0.043421, 0.965686>,
		<2.05696, 0.0429208, 1.32656>,
		<2.05696, 0.0425361, 1.67322>,
		<2.05696, 0.0420932, 2.04294>,
		<-1.86892, 0.0921055, -1.57979>,
		<-1.37899, 0.100815, -1.41759>,
		<-1.91739, 0.0955447, -1.24626>,
		<-1.9563, 0.0990659, -0.906901>,
		<-1.99683, 0.101924, -0.541576>,
		<-2.02691, 0.104168, -0.162602>,
		<-2.02158, 0.103758, 0.204915>,
		<-1.9772, 0.100706, 0.592897>,
		<-1.92681, 0.097314, 0.949693>,
		<-1.88207, 0.0935938, 1.27556>,
		<-1.8296, 0.0902852, 1.58926>,
		<-1.55555, 0.0902525, 1.82511>,
		<-1.13666, 0.109865, -1.48119>,
		<-1.22163, 0.0931142, 1.86861>,
		<-0.868488, 0.118889, -1.56943>,
		<-0.886414, 0.0960796, 1.90483>,
		<-0.586978, 0.126415, -1.68854>,
		<-0.527194, 0.0985795, 1.94176>,
		<-0.350509, 0.133535, -1.88185>,
		<-0.151349, 0.10097, 1.95973>,
		<-0.0967166, 0.132958, -1.91097>,
		<0.209296, 0.100775, 1.95258>,
		<0.363395, 0.124652, -1.76076>,
		<0.584514, 0.0979793, 1.92139>,
		<0.70851, 0.116592, -1.65417>,
		<0.936477, 0.0951671, 1.87686>,
		<0.99499, 0.107432, -1.56267>,
		<1.26199, 0.0920642, 1.83672>,
		<1.2574, 0.0984703, -1.48986>,
		<1.58038, 0.0892578, 1.79045>,
		<1.37138, 0.0983195, -1.3749>,
		<1.4216, 0.106778, -1.13353>,
		<1.49523, 0.115282, -0.86841>,
		<1.59103, 0.122848, -0.601858>,
		<1.73149, 0.131734, -0.409117>,
		<1.76068, 0.131101, -0.142244>,
		<1.65652, 0.120811, 0.333002>,
		<1.57018, 0.112505, 0.677266>,
		<1.49183, 0.103726, 0.962511>,
		<1.43141, 0.0953089, 1.2262>,
		<1.72677, 0.0996941, 0.925241>,
		<1.65878, 0.0938416, 1.22286>,
		<1.56041, 0.0904516, 1.49679>,
		<1.30016, 0.0938428, 1.59102>,
		<1.0173, 0.0996544, 1.65447>,
		<0.708633, 0.104826, 1.73024>,
		<0.363596, 0.110523, 1.81459>,
		<0.0312981, 0.113989, 1.8647>,
		<-0.301137, 0.110897, 1.84137>,
		<-0.650345, 0.105665, 1.7775>,
		<-0.96778, 0.10084, 1.71248>,
		<-1.26044, 0.0951998, 1.65415>,
		<-1.53502, 0.0918413, 1.56373>,
		<-1.63902, 0.0956542, 1.30728>,
		<-1.71244, 0.102081, 1.02345>,
		<-1.79712, 0.107923, 0.712174>,
		<-1.90502, 0.113716, 0.353629>,
		<-1.97185, 0.117056, 0.00958729>,
		<-1.92879, 0.114611, -0.317644>,
		<-1.84564, 0.109723, -0.664762>,
		<-1.77509, 0.104429, -0.988008>,
		<-1.7092, 0.0982194, -1.2848>,
		<-1.60987, 0.0943803, -1.5599>,
		<-1.3518, 0.0984038, -1.66146>,
		<-1.0688, 0.104879, -1.72995>,
		<-0.759629, 0.110468, -1.80794>,
		<-0.47793, 0.1154, -1.91009>,
		<-0.23701, 0.117668, -1.98476>,
		<0.168794, 0.114354, -1.95265>,
		<0.627153, 0.108738, -1.86614>,
		<0.955202, 0.102994, -1.78622>,
		<1.2524, 0.0965595, -1.71143>,
		<1.52395, 0.0926451, -1.60593>,
		<1.61659, 0.096149, -1.34473>,
		<1.67595, 0.101988, -1.06341>,
		<1.74521, 0.107005, -0.759633>,
		<1.82311, 0.112149, -0.519649>,
		<1.87922, 0.114835, -0.290497>,
		<1.86605, 0.110942, 0.142005>,
		<1.80026, 0.104973, 0.599289>,
		<-2.08539, -0.00274934, -2.09587>,
		<-1.73875, -0.00274934, -2.09587>,
		<-1.39414, -0.00274934, -2.09587>,
		<-1.02892, -0.00274934, -2.09587>,
		<-0.660904, -0.00274934, -2.09587>,
		<-0.373828, -0.00274934, -2.09587>,
		<-0.0332689, -0.00274934, -2.09587>,
		<0.552871, -0.00274934, -2.09587>,
		<0.986328, -0.00274934, -2.09587>,
		<1.34838, -0.00274934, -2.09587>,
		<1.69397, -0.00274934, -2.09587>,
		<2.05696, -0.00274934, -2.09587>,
		<-2.08539, -0.00274934, -1.7084>,
		<2.05696, -0.00274934, -1.72854>,
		<-2.08539, -0.00274934, -1.35341>,
		<2.05696, -0.00274934, -1.38082>,
		<-2.08539, -0.00274934, -0.984274>,
		<2.05696, -0.00274934, -1.01825>,
		<-2.08539, -0.00274934, -0.589149>,
		<2.05696, -0.00274934, -0.674514>,
		<-2.08539, -0.00274934, -0.175664>,
		<2.05696, -0.00274934, -0.458102>,
		<-2.08539, -0.00274934, 0.24187>,
		<2.05696, -0.00274934, -0.0564668>,
		<-2.08539, -0.00274934, 0.647601>,
		<2.05696, -0.00274934, 0.536958>,
		<-2.08539, -0.00274934, 1.03005>,
		<2.05696, -0.00274934, 0.965238>,
		<-2.08539, -0.00274934, 1.3852>,
		<2.05696, -0.00274934, 1.32608>,
		<-2.08539, -0.00274934, 1.71789>,
		<2.05696, -0.00274934, 1.67291>,
		<-2.08539, -0.00274934, 2.04294>,
		<-1.68635, -0.00274934, 2.04294>,
		<-1.32825, -0.00274934, 2.04294>,
		<-0.961394, -0.00274934, 2.04294>,
		<-0.57397, -0.00274934, 2.04294>,
		<-0.172489, -0.00274934, 2.04294>,
		<0.232461, -0.00274934, 2.04294>,
		<0.629191, -0.00274934, 2.04294>,
		<1.0084, -0.00274934, 2.04294>,
		<1.36543, -0.00274934, 2.04294>,
		<1.70648, -0.00274934, 2.04294>,
		<2.05696, -0.00274934, 2.04294>,
		<-2.08539, 0.0874166, -2.09587>,
		<-1.73957, 0.0896102, -2.09587>,
		<-1.39533, 0.0912588, -2.09587>,
		<-1.02997, 0.0929261, -2.09587>,
		<-0.661627, 0.0943459, -2.09587>,
		<-0.374225, 0.0949606, -2.09587>,
		<-0.0332684, 0.0948807, -2.09587>,
		<0.553499, 0.093763, -2.09587>,
		<0.987284, 0.0920569, -2.09587>,
		<1.34941, 0.0903018, -2.09587>,
		<1.69464, 0.0887351, -2.09587>,
		<2.05696, 0.0870065, -2.09587>,
		<-2.08539, 0.089629, -1.70913>,
		<-1.33687, 0.106533, -1.24362>,
		<-1.09308, 0.11915, -1.28787>,
		<-0.843691, 0.131021, -1.38146>,
		<-0.577091, 0.140889, -1.52089>,
		<-0.33607, 0.153868, -1.8483>,
		<-0.167217, 0.1534, -1.87807>,
		<0.323769, 0.138982, -1.6062>,
		<0.650741, 0.128404, -1.48729>,
		<0.920868, 0.116265, -1.39345>,
		<1.1919, 0.103749, -1.33613>,
		<2.05696, 0.0888168, -1.72931>,
		<-2.08539, 0.091112, -1.3545>,
		<-1.3843, 0.11884, -0.978736>,
		<-1.13756, 0.136704, -1.0191>,
		<-0.889817, 0.15329, -1.11524>,
		<-0.611042, 0.166386, -1.26151>,
		<-0.322896, 0.175115, -1.59348>,
		<-0.149296, 0.174743, -1.63284>,
		<0.329798, 0.164569, -1.36289>,
		<0.66381, 0.150643, -1.24339>,
		<0.937013, 0.133621, -1.14951>,
		<1.21796, 0.115744, -1.09394>,
		<2.05696, 0.0897496, -1.38196>,
		<-2.08539, 0.0925013, -0.985257>,
		<-1.4666, 0.130338, -0.7145>,
		<-1.21868, 0.152886, -0.757092>,
		<-0.962239, 0.174311, -0.848476>,
		<-0.658482, 0.192218, -0.977095>,
		<-0.302413, 0.201838, -1.22635>,
		<-0.121335, 0.201627, -1.2619>,
		<0.36611, 0.190846, -1.08905>,
		<0.719533, 0.172067, -0.992468>,
		<1.00579, 0.149997, -0.905323>,
		<1.29142, 0.127208, -0.847699>,
		<2.05696, 0.0906295, -1.01924>,
		<-2.08539, 0.0936476, -0.589813>,
		<-1.57911, 0.140048, -0.422518>,
		<-1.32877, 0.165831, -0.458531>,
		<-1.04676, 0.192039, -0.533293>,
		<-0.702948, 0.217451, -0.632897>,
		<-0.273894, 0.225236, -0.79044>,
		<-0.0843018, 0.225072, -0.819333>,
		<0.415226, 0.216711, -0.753712>,
		<0.796103, 0.190705, -0.698444>,
		<1.10752, 0.163778, -0.637829>,
		<1.39758, 0.13747, -0.594567>,
		<2.05696, 0.0913786, -0.67521>,
		<-2.08539, 0.0941351, -0.175878>,
		<-1.86412, 0.15361, -0.0840731>,
		<-1.59494, 0.175267, -0.111133>,
		<-1.21262, 0.202189, -0.149506>,
		<-0.766508, 0.225352, -0.198687>,
		<-0.232362, 0.225627, -0.262491>,
		<-0.0348131, 0.225535, -0.284767>,
		<0.495162, 0.22517, -0.33566>,
		<0.939379, 0.203023, -0.368163>,
		<1.33133, 0.176231, -0.389395>,
		<1.62733, 0.154179, -0.402909>,
		<2.05696, 0.0916007, -0.458566>,
		<-2.08539, 0.0937371, 0.242147>,
		<-1.85284, 0.153589, 0.0855423>,
		<-1.58206, 0.175302, 0.0625904>,
		<-1.19822, 0.202247, 0.0311475>,
		<-0.750338, 0.225272, -0.00941995>,
		<-0.213505, 0.225541, -0.0642247>,
		<-0.014649, 0.225457, -0.0858705>,
		<0.520809, 0.225091, -0.139708>,
		<0.971386, 0.202993, -0.179416>,
		<1.3683, 0.176015, -0.209367>,
		<1.657, 0.153766, -0.22959>,
		<2.05696, 0.0914748, -0.0564834>,
		<-2.08539, 0.0925729, 0.648303>,
		<-1.51496, 0.138241, 0.465059>,
		<-1.25427, 0.163857, 0.466993>,
		<-0.965909, 0.190324, 0.479304>,
		<-0.611861, 0.216523, 0.47977>,
		<-0.156945, 0.22509, 0.47115>,
		<0.0400591, 0.225036, 0.451557>,
		<0.52251, 0.215962, 0.381335>,
		<0.892515, 0.188998, 0.332742>,
		<1.19285, 0.161565, 0.295805>,
		<1.47069, 0.135249, 0.290873>,
		<2.05696, 0.0906832, 0.537546>,
		<-2.08539, 0.0910401, 1.03104>,
		<-1.37166, 0.127263, 0.757741>,
		<-1.10782, 0.149326, 0.773242>,
		<-0.841123, 0.170756, 0.814147>,
		<-0.519281, 0.189721, 0.853956>,
		<-0.108143, 0.202994, 0.92506>,
		<0.0832556, 0.20306, 0.905879>,
		<0.514714, 0.188858, 0.769753>,
		<0.844908, 0.168889, 0.690947>,
		<1.11454, 0.146525, 0.632699>,
		<1.38188, 0.123986, 0.618808>,
		<2.05696, 0.0895914, 0.966134>,
		<-2.08539, 0.0895845, 1.38627>,
		<-1.27377, 0.114878, 1.01101>,
		<-1.00891, 0.131935, 1.02992>,
		<-0.749635, 0.14816, 1.08666>,
		<-0.445959, 0.162158, 1.15992>,
		<-0.0661763, 0.175809, 1.33234>,
		<0.117944, 0.175903, 1.31229>,
		<0.492599, 0.161232, 1.08549>,
		<0.793004, 0.146373, 0.978658>,
		<1.04846, 0.129421, 0.905497>,
		<1.30812, 0.112053, 0.887317>,
		<2.05696, 0.088591, 1.32705>,
		<-2.08539, 0.088396, 1.7186>,
		<-1.22509, 0.102344, 1.26377>,
		<-0.964915, 0.114016, 1.29186>,
		<-0.704983, 0.125263, 1.35702>,
		<-0.410118, 0.135621, 1.44347>,
		<-0.0353368, 0.153275, 1.6451>,
		<0.142722, 0.153385, 1.6239>,
		<0.48065, 0.134832, 1.38059>,
		<0.7663, 0.123792, 1.26717>,
		<1.0188, 0.112002, 1.18819>,
		<1.26956, 0.100113, 1.15974>,
		<2.05696, 0.0878216, 1.67353>,
		<-2.08539, 0.0871224, 2.04294>,
		<-1.68704, 0.0886253, 2.04294>,
		<-1.32928, 0.0895337, 2.04294>,
		<-0.962317, 0.0904214, 2.04294>,
		<-0.574584, 0.0912011, 2.04294>,
		<-0.172691, 0.0915647, 2.04294>,
		<0.232703, 0.0913356, 2.04294>,
		<0.629837, 0.0905806, 2.04294>,
		<1.00934, 0.089577, 2.04294>,
		<1.36648, 0.0886621, 2.04294>,
		<1.70718, 0.0879388, 2.04294>,
		<2.05696, 0.0869357, 2.04294>,
		<-1.84843, 0.135122, 0.0849746>,
		<-1.57571, 0.156647, 0.0619633>,
		<-1.85976, 0.135142, -0.0847056>,
		<-1.58862, 0.156612, -0.111891>,
		<-1.18968, 0.18264, 0.0303534>,
		<-1.2041, 0.182563, -0.150534>,
		<-0.74553, 0.201932, -0.00995491>,
		<-0.761737, 0.201915, -0.199458>,
		<-0.215307, 0.205312, -0.0641572>,
		<-0.234179, 0.205312, -0.262576>,
		<-0.147655, 0.156534, -1.60878>,
		<-0.166078, 0.135234, -1.86054>,
		<-0.335236, 0.135709, -1.83012>,
		<-0.321755, 0.156901, -1.56944>,
		<-0.119183, 0.182485, -1.23283>,
		<-0.300825, 0.182657, -1.19761>,
		<-0.0825078, 0.201902, -0.796395>,
		<-0.272395, 0.201927, -0.767562>,
		<-0.0351286, 0.205312, -0.286569>,
		<0.0394832, 0.202067, 0.446597>,
		<-0.0147838, 0.205312, -0.0860088>,
		<-0.157449, 0.202053, 0.466237>,
		<0.0826943, 0.183324, 0.900198>,
		<-0.108809, 0.183246, 0.9194>,
		<0.117417, 0.157138, 1.30634>,
		<-0.0669032, 0.157043, 1.32641>,
		<-0.0360943, 0.134829, 1.63857>,
		<0.14215, 0.134939, 1.61733>,
		<0.515894, 0.202044, -0.139474>,
		<0.490305, 0.202039, -0.335374>,
		<0.965791, 0.183239, -0.179141>,
		<0.933779, 0.183252, -0.368>,
		<1.36252, 0.157248, -0.209086>,
		<1.32549, 0.157464, -0.389303>,
		<1.65076, 0.135316, -0.229272>,
		<1.62096, 0.13573, -0.402746>,
		<-1.67045, 0.0956301, -1.42742>,
		<-1.48624, 0.0957122, -1.62219>,
		<-1.7417, 0.101348, -1.13968>,
		<-1.80981, 0.107251, -0.829579>,
		<-1.88512, 0.112116, -0.493615>,
		<-1.9626, 0.116507, -0.147338>,
		<-1.95247, 0.116102, 0.171046>,
		<-1.84736, 0.110726, 0.540345>,
		<-1.75331, 0.105133, 0.871485>,
		<-1.67453, 0.0988518, 1.16865>,
		<-1.59829, 0.0930717, 1.44167>,
		<-1.40224, 0.0928873, 1.61991>,
		<-1.21367, 0.101656, -1.69487>,
		<-1.11706, 0.098041, 1.6826>,
		<-0.916827, 0.107852, -1.76753>,
		<-0.812226, 0.103399, 1.74433>,
		<-0.609589, 0.112939, -1.85492>,
		<-0.480042, 0.108064, 1.81064>,
		<-0.358371, 0.117204, -1.95864>,
		<-0.126986, 0.113211, 1.86192>,
		<-0.0717342, 0.116684, -1.98308>,
		<0.18958, 0.113053, 1.84851>,
		<0.423038, 0.111459, -1.90856>,
		<0.54133, 0.10745, 1.77208>,
		<0.796293, 0.106008, -1.82587>,
		<0.86633, 0.102367, 1.69086>,
		<1.10717, 0.0997769, -1.74805>,
		<1.16181, 0.0967468, 1.62146>,
		<1.39414, 0.0939282, -1.6693>,
		<1.43551, 0.0915104, 1.55541>,
		<1.58193, 0.0937515, -1.47989>,
		<1.6454, 0.0990844, -1.20714>,
		<1.70926, 0.104653, -0.91321>,
		<1.78354, 0.10942, -0.623147>,
		<1.85739, 0.114278, -0.420276>,
		<1.88321, 0.113674, -0.106553>,
		<1.83552, 0.107707, 0.396533>,
		<1.76334, 0.102446, 0.767034>,
		<1.6919, 0.0967629, 1.07716>,
		<1.62032, 0.0915026, 1.36561>
		}
	uv_vectors {
		24192,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>,
		<0, 0>
		}
	texture_list {
		4,
		texture { Material0 }
		texture { Dark }
		texture { Cross }
		texture { White }
		}

	face_indices {
		8064,
		<0, 2016, 3276>, 0,
		<0, 3276, 1028>, 0,
		<0, 1028, 3798>, 0,
		<0, 3798, 1027>, 0,
		<0, 1027, 3275>, 0,
		<0, 3275, 2017>, 0,
		<0, 2017, 3024>, 0,
		<0, 3024, 2016>, 0,
		<1, 2017, 3275>, 0,
		<1, 3275, 1026>, 0,
		<1, 1026, 3796>, 0,
		<1, 3796, 1025>, 0,
		<1, 1025, 3274>, 0,
		<1, 3274, 2018>, 0,
		<1, 2018, 3024>, 0,
		<1, 3024, 2017>, 0,
		<2, 2018, 3274>, 0,
		<2, 3274, 1024>, 0,
		<2, 1024, 3794>, 0,
		<2, 3794, 1023>, 0,
		<2, 1023, 3273>, 0,
		<2, 3273, 2019>, 0,
		<2, 2019, 3024>, 0,
		<2, 3024, 2018>, 0,
		<3, 2019, 3273>, 0,
		<3, 3273, 1022>, 0,
		<3, 1022, 3792>, 0,
		<3, 3792, 1021>, 0,
		<3, 1021, 3272>, 0,
		<3, 3272, 2020>, 0,
		<3, 2020, 3024>, 0,
		<3, 3024, 2019>, 0,
		<4, 2020, 3272>, 0,
		<4, 3272, 1020>, 0,
		<4, 1020, 3790>, 0,
		<4, 3790, 1019>, 0,
		<4, 1019, 3271>, 0,
		<4, 3271, 2021>, 0,
		<4, 2021, 3024>, 0,
		<4, 3024, 2020>, 0,
		<5, 2021, 3271>, 0,
		<5, 3271, 1018>, 0,
		<5, 1018, 3788>, 0,
		<5, 3788, 1017>, 0,
		<5, 1017, 3270>, 0,
		<5, 3270, 2022>, 0,
		<5, 2022, 3024>, 0,
		<5, 3024, 2021>, 0,
		<6, 2022, 3270>, 0,
		<6, 3270, 1016>, 0,
		<6, 1016, 3786>, 0,
		<6, 3786, 1015>, 0,
		<6, 1015, 3269>, 0,
		<6, 3269, 2023>, 0,
		<6, 2023, 3024>, 0,
		<6, 3024, 2022>, 0,
		<7, 2023, 3269>, 0,
		<7, 3269, 1014>, 0,
		<7, 1014, 3784>, 0,
		<7, 3784, 1013>, 0,
		<7, 1013, 3268>, 0,
		<7, 3268, 2024>, 0,
		<7, 2024, 3024>, 0,
		<7, 3024, 2023>, 0,
		<8, 2024, 3268>, 0,
		<8, 3268, 1012>, 0,
		<8, 1012, 3782>, 0,
		<8, 3782, 1011>, 0,
		<8, 1011, 3267>, 0,
		<8, 3267, 2025>, 0,
		<8, 2025, 3024>, 0,
		<8, 3024, 2024>, 0,
		<9, 2025, 3267>, 0,
		<9, 3267, 1010>, 0,
		<9, 1010, 3770>, 0,
		<9, 3770, 1009>, 0,
		<9, 1009, 3266>, 0,
		<9, 3266, 2026>, 0,
		<9, 2026, 3024>, 0,
		<9, 3024, 2025>, 0,
		<10, 2026, 3266>, 0,
		<10, 3266, 1008>, 0,
		<10, 1008, 3771>, 0,
		<10, 3771, 1035>, 0,
		<10, 1035, 3279>, 0,
		<10, 3279, 2027>, 0,
		<10, 2027, 3024>, 0,
		<10, 3024, 2026>, 0,
		<11, 2027, 3279>, 0,
		<11, 3279, 1034>, 0,
		<11, 1034, 3772>, 0,
		<11, 3772, 1039>, 0,
		<11, 1039, 3281>, 0,
		<11, 3281, 2028>, 0,
		<11, 2028, 3024>, 0,
		<11, 3024, 2027>, 0,
		<12, 2028, 3281>, 0,
		<12, 3281, 1038>, 0,
		<12, 1038, 3773>, 0,
		<12, 3773, 1043>, 0,
		<12, 1043, 3283>, 0,
		<12, 3283, 2029>, 0,
		<12, 2029, 3024>, 0,
		<12, 3024, 2028>, 0,
		<13, 2029, 3283>, 0,
		<13, 3283, 1042>, 0,
		<13, 1042, 3774>, 0,
		<13, 3774, 1047>, 0,
		<13, 1047, 3285>, 0,
		<13, 3285, 2030>, 0,
		<13, 2030, 3024>, 0,
		<13, 3024, 2029>, 0,
		<14, 2030, 3285>, 0,
		<14, 3285, 1046>, 0,
		<14, 1046, 3775>, 0,
		<14, 3775, 1051>, 0,
		<14, 1051, 3287>, 0,
		<14, 3287, 2031>, 0,
		<14, 2031, 3024>, 0,
		<14, 3024, 2030>, 0,
		<15, 2031, 3287>, 0,
		<15, 3287, 1050>, 0,
		<15, 1050, 3776>, 0,
		<15, 3776, 1055>, 0,
		<15, 1055, 3289>, 0,
		<15, 3289, 2032>, 0,
		<15, 2032, 3024>, 0,
		<15, 3024, 2031>, 0,
		<16, 2032, 3289>, 0,
		<16, 3289, 1054>, 0,
		<16, 1054, 3777>, 0,
		<16, 3777, 1059>, 0,
		<16, 1059, 3291>, 0,
		<16, 3291, 2033>, 0,
		<16, 2033, 3024>, 0,
		<16, 3024, 2032>, 0,
		<17, 2033, 3291>, 0,
		<17, 3291, 1058>, 0,
		<17, 1058, 3778>, 0,
		<17, 3778, 1063>, 0,
		<17, 1063, 3293>, 0,
		<17, 3293, 2034>, 0,
		<17, 2034, 3024>, 0,
		<17, 3024, 2033>, 0,
		<18, 2034, 3293>, 0,
		<18, 3293, 1062>, 0,
		<18, 1062, 3779>, 0,
		<18, 3779, 1067>, 0,
		<18, 1067, 3295>, 0,
		<18, 3295, 2035>, 0,
		<18, 2035, 3024>, 0,
		<18, 3024, 2034>, 0,
		<19, 2035, 3295>, 0,
		<19, 3295, 1066>, 0,
		<19, 1066, 3780>, 0,
		<19, 3780, 1073>, 0,
		<19, 1073, 3298>, 0,
		<19, 3298, 2036>, 0,
		<19, 2036, 3024>, 0,
		<19, 3024, 2035>, 0,
		<20, 2036, 3298>, 0,
		<20, 3298, 1072>, 0,
		<20, 1072, 3781>, 0,
		<20, 3781, 1071>, 0,
		<20, 1071, 3297>, 0,
		<20, 3297, 2037>, 0,
		<20, 2037, 3024>, 0,
		<20, 3024, 2036>, 0,
		<21, 2037, 3297>, 0,
		<21, 3297, 1070>, 0,
		<21, 1070, 3783>, 0,
		<21, 3783, 1075>, 0,
		<21, 1075, 3299>, 0,
		<21, 3299, 2038>, 0,
		<21, 2038, 3024>, 0,
		<21, 3024, 2037>, 0,
		<22, 2038, 3299>, 0,
		<22, 3299, 1074>, 0,
		<22, 1074, 3785>, 0,
		<22, 3785, 1077>, 0,
		<22, 1077, 3300>, 0,
		<22, 3300, 2039>, 0,
		<22, 2039, 3024>, 0,
		<22, 3024, 2038>, 0,
		<23, 2039, 3300>, 0,
		<23, 3300, 1076>, 0,
		<23, 1076, 3787>, 0,
		<23, 3787, 1079>, 0,
		<23, 1079, 3301>, 0,
		<23, 3301, 2040>, 0,
		<23, 2040, 3024>, 0,
		<23, 3024, 2039>, 0,
		<24, 2040, 3301>, 0,
		<24, 3301, 1078>, 0,
		<24, 1078, 3789>, 0,
		<24, 3789, 1081>, 0,
		<24, 1081, 3302>, 0,
		<24, 3302, 2041>, 0,
		<24, 2041, 3024>, 0,
		<24, 3024, 2040>, 0,
		<25, 2041, 3302>, 0,
		<25, 3302, 1080>, 0,
		<25, 1080, 3791>, 0,
		<25, 3791, 1083>, 0,
		<25, 1083, 3303>, 0,
		<25, 3303, 2042>, 0,
		<25, 2042, 3024>, 0,
		<25, 3024, 2041>, 0,
		<26, 2042, 3303>, 0,
		<26, 3303, 1082>, 0,
		<26, 1082, 3793>, 0,
		<26, 3793, 1085>, 0,
		<26, 1085, 3304>, 0,
		<26, 3304, 2043>, 0,
		<26, 2043, 3024>, 0,
		<26, 3024, 2042>, 0,
		<27, 2043, 3304>, 0,
		<27, 3304, 1084>, 0,
		<27, 1084, 3795>, 0,
		<27, 3795, 1087>, 0,
		<27, 1087, 3305>, 0,
		<27, 3305, 2044>, 0,
		<27, 2044, 3024>, 0,
		<27, 3024, 2043>, 0,
		<28, 2044, 3305>, 0,
		<28, 3305, 1086>, 0,
		<28, 1086, 3797>, 0,
		<28, 3797, 1089>, 0,
		<28, 1089, 3306>, 0,
		<28, 3306, 2045>, 0,
		<28, 2045, 3024>, 0,
		<28, 3024, 2044>, 0,
		<29, 2045, 3306>, 0,
		<29, 3306, 1088>, 0,
		<29, 1088, 3799>, 0,
		<29, 3799, 1091>, 0,
		<29, 1091, 3307>, 0,
		<29, 3307, 2046>, 0,
		<29, 2046, 3024>, 0,
		<29, 3024, 2045>, 0,
		<30, 2046, 3307>, 0,
		<30, 3307, 1090>, 0,
		<30, 1090, 3801>, 0,
		<30, 3801, 1095>, 0,
		<30, 1095, 3309>, 0,
		<30, 3309, 2047>, 0,
		<30, 2047, 3024>, 0,
		<30, 3024, 2046>, 0,
		<31, 2047, 3309>, 0,
		<31, 3309, 1094>, 0,
		<31, 1094, 3813>, 0,
		<31, 3813, 1093>, 0,
		<31, 1093, 3308>, 0,
		<31, 3308, 2048>, 0,
		<31, 2048, 3024>, 0,
		<31, 3024, 2047>, 0,
		<32, 2048, 3308>, 0,
		<32, 3308, 1092>, 0,
		<32, 1092, 3812>, 0,
		<32, 3812, 1069>, 0,
		<32, 1069, 3296>, 0,
		<32, 3296, 2049>, 0,
		<32, 2049, 3024>, 0,
		<32, 3024, 2048>, 0,
		<33, 2049, 3296>, 0,
		<33, 3296, 1068>, 0,
		<33, 1068, 3811>, 0,
		<33, 3811, 1065>, 0,
		<33, 1065, 3294>, 0,
		<33, 3294, 2050>, 0,
		<33, 2050, 3024>, 0,
		<33, 3024, 2049>, 0,
		<34, 2050, 3294>, 0,
		<34, 3294, 1064>, 0,
		<34, 1064, 3810>, 0,
		<34, 3810, 1061>, 0,
		<34, 1061, 3292>, 0,
		<34, 3292, 2051>, 0,
		<34, 2051, 3024>, 0,
		<34, 3024, 2050>, 0,
		<35, 2051, 3292>, 0,
		<35, 3292, 1060>, 0,
		<35, 1060, 3809>, 0,
		<35, 3809, 1057>, 0,
		<35, 1057, 3290>, 0,
		<35, 3290, 2052>, 0,
		<35, 2052, 3024>, 0,
		<35, 3024, 2051>, 0,
		<36, 2052, 3290>, 0,
		<36, 3290, 1056>, 0,
		<36, 1056, 3808>, 0,
		<36, 3808, 1053>, 0,
		<36, 1053, 3288>, 0,
		<36, 3288, 2053>, 0,
		<36, 2053, 3024>, 0,
		<36, 3024, 2052>, 0,
		<37, 2053, 3288>, 0,
		<37, 3288, 1052>, 0,
		<37, 1052, 3807>, 0,
		<37, 3807, 1049>, 0,
		<37, 1049, 3286>, 0,
		<37, 3286, 2054>, 0,
		<37, 2054, 3024>, 0,
		<37, 3024, 2053>, 0,
		<38, 2054, 3286>, 0,
		<38, 3286, 1048>, 0,
		<38, 1048, 3806>, 0,
		<38, 3806, 1045>, 0,
		<38, 1045, 3284>, 0,
		<38, 3284, 2055>, 0,
		<38, 2055, 3024>, 0,
		<38, 3024, 2054>, 0,
		<39, 2055, 3284>, 0,
		<39, 3284, 1044>, 0,
		<39, 1044, 3805>, 0,
		<39, 3805, 1041>, 0,
		<39, 1041, 3282>, 0,
		<39, 3282, 2056>, 0,
		<39, 2056, 3024>, 0,
		<39, 3024, 2055>, 0,
		<40, 2056, 3282>, 0,
		<40, 3282, 1040>, 0,
		<40, 1040, 3804>, 0,
		<40, 3804, 1037>, 0,
		<40, 1037, 3280>, 0,
		<40, 3280, 2057>, 0,
		<40, 2057, 3024>, 0,
		<40, 3024, 2056>, 0,
		<41, 2057, 3280>, 0,
		<41, 3280, 1036>, 0,
		<41, 1036, 3803>, 0,
		<41, 3803, 1031>, 0,
		<41, 1031, 3277>, 0,
		<41, 3277, 2058>, 0,
		<41, 2058, 3024>, 0,
		<41, 3024, 2057>, 0,
		<42, 2058, 3277>, 0,
		<42, 3277, 1030>, 0,
		<42, 1030, 3802>, 0,
		<42, 3802, 1033>, 0,
		<42, 1033, 3278>, 0,
		<42, 3278, 2059>, 0,
		<42, 2059, 3024>, 0,
		<42, 3024, 2058>, 0,
		<43, 2059, 3278>, 0,
		<43, 3278, 1032>, 0,
		<43, 1032, 3800>, 0,
		<43, 3800, 1029>, 0,
		<43, 1029, 3276>, 0,
		<43, 3276, 2016>, 0,
		<43, 2016, 3024>, 0,
		<43, 3024, 2059>, 0,
		<44, 2060, 3690>, 1,
		<44, 3690, 1856>, 1,
		<44, 1856, 3994>, 1,
		<44, 3994, 1980>, 1,
		<44, 1980, 3752>, 1,
		<44, 3752, 2061>, 1,
		<44, 2061, 3025>, 1,
		<44, 3025, 2060>, 1,
		<45, 2061, 3752>, 1,
		<45, 3752, 1981>, 1,
		<45, 1981, 3995>, 1,
		<45, 3995, 1098>, 1,
		<45, 1098, 3311>, 1,
		<45, 3311, 2062>, 1,
		<45, 2062, 3025>, 1,
		<45, 3025, 2061>, 1,
		<46, 2062, 3311>, 1,
		<46, 3311, 1099>, 1,
		<46, 1099, 3815>, 1,
		<46, 3815, 1100>, 1,
		<46, 1100, 3312>, 1,
		<46, 3312, 2063>, 1,
		<46, 2063, 3025>, 1,
		<46, 3025, 2062>, 1,
		<47, 2063, 3312>, 1,
		<47, 3312, 1101>, 1,
		<47, 1101, 3814>, 1,
		<47, 3814, 1102>, 1,
		<47, 1102, 3313>, 1,
		<47, 3313, 2064>, 1,
		<47, 2064, 3025>, 1,
		<47, 3025, 2063>, 1,
		<48, 2064, 3313>, 1,
		<48, 3313, 1103>, 1,
		<48, 1103, 3826>, 1,
		<48, 3826, 1857>, 1,
		<48, 1857, 3690>, 1,
		<48, 3690, 2060>, 1,
		<48, 2060, 3025>, 1,
		<48, 3025, 2064>, 1,
		<49, 2065, 3692>, 1,
		<49, 3692, 1860>, 1,
		<49, 1860, 3996>, 1,
		<49, 3996, 1978>, 1,
		<49, 1978, 3751>, 1,
		<49, 3751, 2066>, 1,
		<49, 2066, 3026>, 1,
		<49, 3026, 2065>, 1,
		<50, 2066, 3751>, 1,
		<50, 3751, 1979>, 1,
		<50, 1979, 3994>, 1,
		<50, 3994, 1856>, 1,
		<50, 1856, 3690>, 1,
		<50, 3690, 2067>, 1,
		<50, 2067, 3026>, 1,
		<50, 3026, 2066>, 1,
		<51, 2067, 3690>, 1,
		<51, 3690, 1857>, 1,
		<51, 1857, 3826>, 1,
		<51, 3826, 1108>, 1,
		<51, 1108, 3316>, 1,
		<51, 3316, 2068>, 1,
		<51, 2068, 3026>, 1,
		<51, 3026, 2067>, 1,
		<52, 2068, 3316>, 1,
		<52, 3316, 1109>, 1,
		<52, 1109, 3838>, 1,
		<52, 3838, 1861>, 1,
		<52, 1861, 3692>, 1,
		<52, 3692, 2065>, 1,
		<52, 2065, 3026>, 1,
		<52, 3026, 2068>, 1,
		<53, 2069, 3693>, 1,
		<53, 3693, 1862>, 1,
		<53, 1862, 3997>, 1,
		<53, 3997, 1976>, 1,
		<53, 1976, 3750>, 1,
		<53, 3750, 2070>, 1,
		<53, 2070, 3027>, 1,
		<53, 3027, 2069>, 1,
		<54, 2070, 3750>, 1,
		<54, 3750, 1977>, 1,
		<54, 1977, 3996>, 1,
		<54, 3996, 1860>, 1,
		<54, 1860, 3692>, 1,
		<54, 3692, 2071>, 1,
		<54, 2071, 3027>, 1,
		<54, 3027, 2070>, 1,
		<55, 2071, 3692>, 1,
		<55, 3692, 1861>, 1,
		<55, 1861, 3838>, 1,
		<55, 3838, 1114>, 1,
		<55, 1114, 3319>, 1,
		<55, 3319, 2072>, 1,
		<55, 2072, 3027>, 1,
		<55, 3027, 2071>, 1,
		<56, 2072, 3319>, 1,
		<56, 3319, 1115>, 1,
		<56, 1115, 3850>, 1,
		<56, 3850, 1863>, 1,
		<56, 1863, 3693>, 1,
		<56, 3693, 2069>, 1,
		<56, 2069, 3027>, 1,
		<56, 3027, 2072>, 1,
		<57, 2073, 3694>, 1,
		<57, 3694, 1864>, 1,
		<57, 1864, 3998>, 1,
		<57, 3998, 1974>, 1,
		<57, 1974, 3749>, 1,
		<57, 3749, 2074>, 1,
		<57, 2074, 3028>, 1,
		<57, 3028, 2073>, 1,
		<58, 2074, 3749>, 1,
		<58, 3749, 1975>, 1,
		<58, 1975, 3997>, 1,
		<58, 3997, 1862>, 1,
		<58, 1862, 3693>, 1,
		<58, 3693, 2075>, 1,
		<58, 2075, 3028>, 1,
		<58, 3028, 2074>, 1,
		<59, 2075, 3693>, 1,
		<59, 3693, 1863>, 1,
		<59, 1863, 3850>, 1,
		<59, 3850, 1120>, 1,
		<59, 1120, 3322>, 1,
		<59, 3322, 2076>, 1,
		<59, 2076, 3028>, 1,
		<59, 3028, 2075>, 1,
		<60, 2076, 3322>, 1,
		<60, 3322, 1121>, 1,
		<60, 1121, 3862>, 1,
		<60, 3862, 1865>, 1,
		<60, 1865, 3694>, 1,
		<60, 3694, 2073>, 1,
		<60, 2073, 3028>, 1,
		<60, 3028, 2076>, 1,
		<61, 2077, 3695>, 1,
		<61, 3695, 1866>, 1,
		<61, 1866, 3999>, 1,
		<61, 3999, 1972>, 1,
		<61, 1972, 3748>, 1,
		<61, 3748, 2078>, 1,
		<61, 2078, 3029>, 1,
		<61, 3029, 2077>, 1,
		<62, 2078, 3748>, 1,
		<62, 3748, 1973>, 1,
		<62, 1973, 3998>, 1,
		<62, 3998, 1864>, 1,
		<62, 1864, 3694>, 1,
		<62, 3694, 2079>, 1,
		<62, 2079, 3029>, 1,
		<62, 3029, 2078>, 1,
		<63, 2079, 3694>, 1,
		<63, 3694, 1865>, 1,
		<63, 1865, 3862>, 1,
		<63, 3862, 1126>, 1,
		<63, 1126, 3325>, 1,
		<63, 3325, 2080>, 1,
		<63, 2080, 3029>, 1,
		<63, 3029, 2079>, 1,
		<64, 2080, 3325>, 1,
		<64, 3325, 1127>, 1,
		<64, 1127, 3874>, 1,
		<64, 3874, 1867>, 1,
		<64, 1867, 3695>, 1,
		<64, 3695, 2077>, 1,
		<64, 2077, 3029>, 1,
		<64, 3029, 2080>, 1,
		<65, 2081, 3696>, 1,
		<65, 3696, 1868>, 1,
		<65, 1868, 4000>, 1,
		<65, 4000, 1970>, 1,
		<65, 1970, 3747>, 1,
		<65, 3747, 2082>, 1,
		<65, 2082, 3030>, 1,
		<65, 3030, 2081>, 1,
		<66, 2082, 3747>, 1,
		<66, 3747, 1971>, 1,
		<66, 1971, 3999>, 1,
		<66, 3999, 1866>, 1,
		<66, 1866, 3695>, 1,
		<66, 3695, 2083>, 1,
		<66, 2083, 3030>, 1,
		<66, 3030, 2082>, 1,
		<67, 2083, 3695>, 1,
		<67, 3695, 1867>, 1,
		<67, 1867, 3874>, 1,
		<67, 3874, 1132>, 1,
		<67, 1132, 3328>, 1,
		<67, 3328, 2084>, 1,
		<67, 2084, 3030>, 1,
		<67, 3030, 2083>, 1,
		<68, 2084, 3328>, 1,
		<68, 3328, 1133>, 1,
		<68, 1133, 3886>, 1,
		<68, 3886, 1869>, 1,
		<68, 1869, 3696>, 1,
		<68, 3696, 2081>, 1,
		<68, 2081, 3030>, 1,
		<68, 3030, 2084>, 1,
		<69, 2085, 3697>, 1,
		<69, 3697, 1870>, 1,
		<69, 1870, 4001>, 1,
		<69, 4001, 1968>, 1,
		<69, 1968, 3746>, 1,
		<69, 3746, 2086>, 1,
		<69, 2086, 3031>, 1,
		<69, 3031, 2085>, 1,
		<70, 2086, 3746>, 1,
		<70, 3746, 1969>, 1,
		<70, 1969, 4000>, 1,
		<70, 4000, 1868>, 1,
		<70, 1868, 3696>, 1,
		<70, 3696, 2087>, 1,
		<70, 2087, 3031>, 1,
		<70, 3031, 2086>, 1,
		<71, 2087, 3696>, 1,
		<71, 3696, 1869>, 1,
		<71, 1869, 3886>, 1,
		<71, 3886, 1138>, 1,
		<71, 1138, 3331>, 1,
		<71, 3331, 2088>, 1,
		<71, 2088, 3031>, 1,
		<71, 3031, 2087>, 1,
		<72, 2088, 3331>, 1,
		<72, 3331, 1139>, 1,
		<72, 1139, 3898>, 1,
		<72, 3898, 1871>, 1,
		<72, 1871, 3697>, 1,
		<72, 3697, 2085>, 1,
		<72, 2085, 3031>, 1,
		<72, 3031, 2088>, 1,
		<73, 2089, 3698>, 1,
		<73, 3698, 1872>, 1,
		<73, 1872, 4002>, 1,
		<73, 4002, 1966>, 1,
		<73, 1966, 3745>, 1,
		<73, 3745, 2090>, 1,
		<73, 2090, 3032>, 1,
		<73, 3032, 2089>, 1,
		<74, 2090, 3745>, 1,
		<74, 3745, 1967>, 1,
		<74, 1967, 4001>, 1,
		<74, 4001, 1870>, 1,
		<74, 1870, 3697>, 1,
		<74, 3697, 2091>, 1,
		<74, 2091, 3032>, 1,
		<74, 3032, 2090>, 1,
		<75, 2091, 3697>, 1,
		<75, 3697, 1871>, 1,
		<75, 1871, 3898>, 1,
		<75, 3898, 1144>, 1,
		<75, 1144, 3334>, 1,
		<75, 3334, 2092>, 1,
		<75, 2092, 3032>, 1,
		<75, 3032, 2091>, 1,
		<76, 2092, 3334>, 1,
		<76, 3334, 1145>, 1,
		<76, 1145, 3910>, 1,
		<76, 3910, 1873>, 1,
		<76, 1873, 3698>, 1,
		<76, 3698, 2089>, 1,
		<76, 2089, 3032>, 1,
		<76, 3032, 2092>, 1,
		<77, 2093, 3699>, 1,
		<77, 3699, 1874>, 1,
		<77, 1874, 4003>, 1,
		<77, 4003, 1964>, 1,
		<77, 1964, 3744>, 1,
		<77, 3744, 2094>, 1,
		<77, 2094, 3033>, 1,
		<77, 3033, 2093>, 1,
		<78, 2094, 3744>, 1,
		<78, 3744, 1965>, 1,
		<78, 1965, 4002>, 1,
		<78, 4002, 1872>, 1,
		<78, 1872, 3698>, 1,
		<78, 3698, 2095>, 1,
		<78, 2095, 3033>, 1,
		<78, 3033, 2094>, 1,
		<79, 2095, 3698>, 1,
		<79, 3698, 1873>, 1,
		<79, 1873, 3910>, 1,
		<79, 3910, 1150>, 1,
		<79, 1150, 3337>, 1,
		<79, 3337, 2096>, 1,
		<79, 2096, 3033>, 1,
		<79, 3033, 2095>, 1,
		<80, 2096, 3337>, 1,
		<80, 3337, 1151>, 1,
		<80, 1151, 3922>, 1,
		<80, 3922, 1875>, 1,
		<80, 1875, 3699>, 1,
		<80, 3699, 2093>, 1,
		<80, 2093, 3033>, 1,
		<80, 3033, 2096>, 1,
		<81, 2097, 3700>, 1,
		<81, 3700, 1876>, 1,
		<81, 1876, 4004>, 1,
		<81, 4004, 1962>, 1,
		<81, 1962, 3743>, 1,
		<81, 3743, 2098>, 1,
		<81, 2098, 3034>, 1,
		<81, 3034, 2097>, 1,
		<82, 2098, 3743>, 1,
		<82, 3743, 1963>, 1,
		<82, 1963, 4003>, 1,
		<82, 4003, 1874>, 1,
		<82, 1874, 3699>, 1,
		<82, 3699, 2099>, 1,
		<82, 2099, 3034>, 1,
		<82, 3034, 2098>, 1,
		<83, 2099, 3699>, 1,
		<83, 3699, 1875>, 1,
		<83, 1875, 3922>, 1,
		<83, 3922, 1156>, 1,
		<83, 1156, 3340>, 1,
		<83, 3340, 2100>, 1,
		<83, 2100, 3034>, 1,
		<83, 3034, 2099>, 1,
		<84, 2100, 3340>, 1,
		<84, 3340, 1157>, 1,
		<84, 1157, 3934>, 1,
		<84, 3934, 1877>, 1,
		<84, 1877, 3700>, 1,
		<84, 3700, 2097>, 1,
		<84, 2097, 3034>, 1,
		<84, 3034, 2100>, 1,
		<85, 2101, 3341>, 1,
		<85, 3341, 1159>, 1,
		<85, 1159, 3947>, 1,
		<85, 3947, 1879>, 1,
		<85, 1879, 3701>, 1,
		<85, 3701, 2102>, 1,
		<85, 2102, 3035>, 1,
		<85, 3035, 2101>, 1,
		<86, 2102, 3701>, 1,
		<86, 3701, 1878>, 1,
		<86, 1878, 4005>, 1,
		<86, 4005, 1960>, 1,
		<86, 1960, 3742>, 1,
		<86, 3742, 2103>, 1,
		<86, 2103, 3035>, 1,
		<86, 3035, 2102>, 1,
		<87, 2103, 3742>, 1,
		<87, 3742, 1961>, 1,
		<87, 1961, 4004>, 1,
		<87, 4004, 1876>, 1,
		<87, 1876, 3700>, 1,
		<87, 3700, 2104>, 1,
		<87, 2104, 3035>, 1,
		<87, 3035, 2103>, 1,
		<88, 2104, 3700>, 1,
		<88, 3700, 1877>, 1,
		<88, 1877, 3934>, 1,
		<88, 3934, 1162>, 1,
		<88, 1162, 3343>, 1,
		<88, 3343, 2105>, 1,
		<88, 2105, 3035>, 1,
		<88, 3035, 2104>, 1,
		<89, 2105, 3343>, 1,
		<89, 3343, 1163>, 1,
		<89, 1163, 3946>, 1,
		<89, 3946, 1158>, 1,
		<89, 1158, 3341>, 1,
		<89, 3341, 2101>, 1,
		<89, 2101, 3035>, 1,
		<89, 3035, 2105>, 1,
		<90, 2106, 3753>, 1,
		<90, 3753, 1983>, 1,
		<90, 1983, 4006>, 1,
		<90, 4006, 1166>, 1,
		<90, 1166, 3345>, 1,
		<90, 3345, 2107>, 1,
		<90, 2107, 3036>, 1,
		<90, 3036, 2106>, 1,
		<91, 2107, 3345>, 1,
		<91, 3345, 1167>, 1,
		<91, 1167, 3816>, 1,
		<91, 3816, 1168>, 1,
		<91, 1168, 3346>, 1,
		<91, 3346, 2108>, 1,
		<91, 2108, 3036>, 1,
		<91, 3036, 2107>, 1,
		<92, 2108, 3346>, 1,
		<92, 3346, 1169>, 1,
		<92, 1169, 3815>, 1,
		<92, 3815, 1099>, 1,
		<92, 1099, 3311>, 1,
		<92, 3311, 2109>, 1,
		<92, 2109, 3036>, 1,
		<92, 3036, 2108>, 1,
		<93, 2109, 3311>, 1,
		<93, 3311, 1098>, 1,
		<93, 1098, 3995>, 1,
		<93, 3995, 1982>, 1,
		<93, 1982, 3753>, 1,
		<93, 3753, 2106>, 1,
		<93, 2106, 3036>, 1,
		<93, 3036, 2109>, 1,
		<94, 2110, 3347>, 1,
		<94, 3347, 1171>, 1,
		<94, 1171, 3840>, 1,
		<94, 3840, 1172>, 1,
		<94, 1172, 3348>, 1,
		<94, 3348, 2111>, 1,
		<94, 2111, 3037>, 1,
		<94, 3037, 2110>, 1,
		<95, 2111, 3348>, 1,
		<95, 3348, 1173>, 1,
		<95, 1173, 3828>, 1,
		<95, 3828, 1165>, 1,
		<95, 1165, 3344>, 1,
		<95, 3344, 2112>, 1,
		<95, 2112, 3037>, 1,
		<95, 3037, 2111>, 1,
		<96, 2112, 3344>, 1,
		<96, 3344, 1164>, 1,
		<96, 1164, 3827>, 1,
		<96, 3827, 1107>, 1,
		<96, 1107, 3315>, 1,
		<96, 3315, 2113>, 1,
		<96, 2113, 3037>, 1,
		<96, 3037, 2112>, 1,
		<97, 2113, 3315>, 1,
		<97, 3315, 1106>, 1,
		<97, 1106, 3839>, 1,
		<97, 3839, 1170>, 1,
		<97, 1170, 3347>, 1,
		<97, 3347, 2110>, 1,
		<97, 2110, 3037>, 1,
		<97, 3037, 2113>, 1,
		<98, 2114, 3349>, 1,
		<98, 3349, 1175>, 1,
		<98, 1175, 3852>, 1,
		<98, 3852, 1176>, 1,
		<98, 1176, 3350>, 1,
		<98, 3350, 2115>, 1,
		<98, 2115, 3038>, 1,
		<98, 3038, 2114>, 1,
		<99, 2115, 3350>, 1,
		<99, 3350, 1177>, 1,
		<99, 1177, 3840>, 1,
		<99, 3840, 1171>, 1,
		<99, 1171, 3347>, 1,
		<99, 3347, 2116>, 1,
		<99, 2116, 3038>, 1,
		<99, 3038, 2115>, 1,
		<100, 2116, 3347>, 1,
		<100, 3347, 1170>, 1,
		<100, 1170, 3839>, 1,
		<100, 3839, 1113>, 1,
		<100, 1113, 3318>, 1,
		<100, 3318, 2117>, 1,
		<100, 2117, 3038>, 1,
		<100, 3038, 2116>, 1,
		<101, 2117, 3318>, 1,
		<101, 3318, 1112>, 1,
		<101, 1112, 3851>, 1,
		<101, 3851, 1174>, 1,
		<101, 1174, 3349>, 1,
		<101, 3349, 2114>, 1,
		<101, 2114, 3038>, 1,
		<101, 3038, 2117>, 1,
		<102, 2118, 3351>, 1,
		<102, 3351, 1179>, 1,
		<102, 1179, 3864>, 1,
		<102, 3864, 1180>, 1,
		<102, 1180, 3352>, 1,
		<102, 3352, 2119>, 1,
		<102, 2119, 3039>, 1,
		<102, 3039, 2118>, 1,
		<103, 2119, 3352>, 1,
		<103, 3352, 1181>, 1,
		<103, 1181, 3852>, 1,
		<103, 3852, 1175>, 1,
		<103, 1175, 3349>, 1,
		<103, 3349, 2120>, 1,
		<103, 2120, 3039>, 1,
		<103, 3039, 2119>, 1,
		<104, 2120, 3349>, 1,
		<104, 3349, 1174>, 1,
		<104, 1174, 3851>, 1,
		<104, 3851, 1119>, 1,
		<104, 1119, 3321>, 1,
		<104, 3321, 2121>, 1,
		<104, 2121, 3039>, 1,
		<104, 3039, 2120>, 1,
		<105, 2121, 3321>, 1,
		<105, 3321, 1118>, 1,
		<105, 1118, 3863>, 1,
		<105, 3863, 1178>, 1,
		<105, 1178, 3351>, 1,
		<105, 3351, 2118>, 1,
		<105, 2118, 3039>, 1,
		<105, 3039, 2121>, 1,
		<106, 2122, 3353>, 1,
		<106, 3353, 1182>, 1,
		<106, 1182, 3876>, 1,
		<106, 3876, 1184>, 1,
		<106, 1184, 3354>, 1,
		<106, 3354, 2123>, 1,
		<106, 2123, 3040>, 1,
		<106, 3040, 2122>, 1,
		<107, 2123, 3354>, 1,
		<107, 3354, 1185>, 1,
		<107, 1185, 3864>, 1,
		<107, 3864, 1179>, 1,
		<107, 1179, 3351>, 1,
		<107, 3351, 2124>, 1,
		<107, 2124, 3040>, 1,
		<107, 3040, 2123>, 1,
		<108, 2124, 3351>, 1,
		<108, 3351, 1178>, 1,
		<108, 1178, 3863>, 1,
		<108, 3863, 1125>, 1,
		<108, 1125, 3324>, 1,
		<108, 3324, 2125>, 1,
		<108, 2125, 3040>, 1,
		<108, 3040, 2124>, 1,
		<109, 2125, 3324>, 1,
		<109, 3324, 1124>, 1,
		<109, 1124, 3875>, 1,
		<109, 3875, 1183>, 1,
		<109, 1183, 3353>, 1,
		<109, 3353, 2122>, 1,
		<109, 2122, 3040>, 1,
		<109, 3040, 2125>, 1,
		<110, 2126, 3574>, 2,
		<110, 3574, 1625>, 2,
		<110, 1625, 3959>, 2,
		<110, 3959, 1188>, 2,
		<110, 1188, 3356>, 2,
		<110, 3356, 2127>, 2,
		<110, 2127, 3041>, 2,
		<110, 3041, 2126>, 2,
		<111, 2127, 3356>, 2,
		<111, 3356, 1189>, 2,
		<111, 1189, 3961>, 2,
		<111, 3961, 1627>, 2,
		<111, 1627, 3575>, 2,
		<111, 3575, 2128>, 2,
		<111, 2128, 3041>, 2,
		<111, 3041, 2127>, 2,
		<112, 2128, 3575>, 2,
		<112, 3575, 1626>, 2,
		<112, 1626, 3960>, 2,
		<112, 3960, 1629>, 2,
		<112, 1629, 3576>, 2,
		<112, 3576, 2129>, 2,
		<112, 2129, 3041>, 2,
		<112, 3041, 2128>, 2,
		<113, 2129, 3576>, 2,
		<113, 3576, 1628>, 2,
		<113, 1628, 3958>, 2,
		<113, 3958, 1624>, 2,
		<113, 1624, 3574>, 2,
		<113, 3574, 2126>, 2,
		<113, 2126, 3041>, 2,
		<113, 3041, 2129>, 2,
		<114, 2130, 3357>, 1,
		<114, 3357, 1191>, 1,
		<114, 1191, 3900>, 1,
		<114, 3900, 1192>, 1,
		<114, 1192, 3358>, 1,
		<114, 3358, 2131>, 1,
		<114, 2131, 3042>, 1,
		<114, 3042, 2130>, 1,
		<115, 2131, 3358>, 1,
		<115, 3358, 1193>, 1,
		<115, 1193, 3888>, 1,
		<115, 3888, 1187>, 1,
		<115, 1187, 3355>, 1,
		<115, 3355, 2132>, 1,
		<115, 2132, 3042>, 1,
		<115, 3042, 2131>, 1,
		<116, 2132, 3355>, 1,
		<116, 3355, 1186>, 1,
		<116, 1186, 3887>, 1,
		<116, 3887, 1137>, 1,
		<116, 1137, 3330>, 1,
		<116, 3330, 2133>, 1,
		<116, 2133, 3042>, 1,
		<116, 3042, 2132>, 1,
		<117, 2133, 3330>, 1,
		<117, 3330, 1136>, 1,
		<117, 1136, 3899>, 1,
		<117, 3899, 1190>, 1,
		<117, 1190, 3357>, 1,
		<117, 3357, 2130>, 1,
		<117, 2130, 3042>, 1,
		<117, 3042, 2133>, 1,
		<118, 2134, 3359>, 1,
		<118, 3359, 1195>, 1,
		<118, 1195, 3912>, 1,
		<118, 3912, 1196>, 1,
		<118, 1196, 3360>, 1,
		<118, 3360, 2135>, 1,
		<118, 2135, 3043>, 1,
		<118, 3043, 2134>, 1,
		<119, 2135, 3360>, 1,
		<119, 3360, 1197>, 1,
		<119, 1197, 3900>, 1,
		<119, 3900, 1191>, 1,
		<119, 1191, 3357>, 1,
		<119, 3357, 2136>, 1,
		<119, 2136, 3043>, 1,
		<119, 3043, 2135>, 1,
		<120, 2136, 3357>, 1,
		<120, 3357, 1190>, 1,
		<120, 1190, 3899>, 1,
		<120, 3899, 1143>, 1,
		<120, 1143, 3333>, 1,
		<120, 3333, 2137>, 1,
		<120, 2137, 3043>, 1,
		<120, 3043, 2136>, 1,
		<121, 2137, 3333>, 1,
		<121, 3333, 1142>, 1,
		<121, 1142, 3911>, 1,
		<121, 3911, 1194>, 1,
		<121, 1194, 3359>, 1,
		<121, 3359, 2134>, 1,
		<121, 2134, 3043>, 1,
		<121, 3043, 2137>, 1,
		<122, 2138, 3361>, 1,
		<122, 3361, 1199>, 1,
		<122, 1199, 3924>, 1,
		<122, 3924, 1200>, 1,
		<122, 1200, 3362>, 1,
		<122, 3362, 2139>, 1,
		<122, 2139, 3044>, 1,
		<122, 3044, 2138>, 1,
		<123, 2139, 3362>, 1,
		<123, 3362, 1201>, 1,
		<123, 1201, 3912>, 1,
		<123, 3912, 1195>, 1,
		<123, 1195, 3359>, 1,
		<123, 3359, 2140>, 1,
		<123, 2140, 3044>, 1,
		<123, 3044, 2139>, 1,
		<124, 2140, 3359>, 1,
		<124, 3359, 1194>, 1,
		<124, 1194, 3911>, 1,
		<124, 3911, 1149>, 1,
		<124, 1149, 3336>, 1,
		<124, 3336, 2141>, 1,
		<124, 2141, 3044>, 1,
		<124, 3044, 2140>, 1,
		<125, 2141, 3336>, 1,
		<125, 3336, 1148>, 1,
		<125, 1148, 3923>, 1,
		<125, 3923, 1198>, 1,
		<125, 1198, 3361>, 1,
		<125, 3361, 2138>, 1,
		<125, 2138, 3044>, 1,
		<125, 3044, 2141>, 1,
		<126, 2142, 3363>, 1,
		<126, 3363, 1203>, 1,
		<126, 1203, 3936>, 1,
		<126, 3936, 1204>, 1,
		<126, 1204, 3364>, 1,
		<126, 3364, 2143>, 1,
		<126, 2143, 3045>, 1,
		<126, 3045, 2142>, 1,
		<127, 2143, 3364>, 1,
		<127, 3364, 1205>, 1,
		<127, 1205, 3924>, 1,
		<127, 3924, 1199>, 1,
		<127, 1199, 3361>, 1,
		<127, 3361, 2144>, 1,
		<127, 2144, 3045>, 1,
		<127, 3045, 2143>, 1,
		<128, 2144, 3361>, 1,
		<128, 3361, 1198>, 1,
		<128, 1198, 3923>, 1,
		<128, 3923, 1155>, 1,
		<128, 1155, 3339>, 1,
		<128, 3339, 2145>, 1,
		<128, 2145, 3045>, 1,
		<128, 3045, 2144>, 1,
		<129, 2145, 3339>, 1,
		<129, 3339, 1154>, 1,
		<129, 1154, 3935>, 1,
		<129, 3935, 1202>, 1,
		<129, 1202, 3363>, 1,
		<129, 3363, 2142>, 1,
		<129, 2142, 3045>, 1,
		<129, 3045, 2145>, 1,
		<130, 2146, 3741>, 1,
		<130, 3741, 1959>, 1,
		<130, 1959, 4007>, 1,
		<130, 4007, 1208>, 1,
		<130, 1208, 3366>, 1,
		<130, 3366, 2147>, 1,
		<130, 2147, 3046>, 1,
		<130, 3046, 2146>, 1,
		<131, 2147, 3366>, 1,
		<131, 3366, 1209>, 1,
		<131, 1209, 3936>, 1,
		<131, 3936, 1203>, 1,
		<131, 1203, 3363>, 1,
		<131, 3363, 2148>, 1,
		<131, 2148, 3046>, 1,
		<131, 3046, 2147>, 1,
		<132, 2148, 3363>, 1,
		<132, 3363, 1202>, 1,
		<132, 1202, 3935>, 1,
		<132, 3935, 1161>, 1,
		<132, 1161, 3342>, 1,
		<132, 3342, 2149>, 1,
		<132, 2149, 3046>, 1,
		<132, 3046, 2148>, 1,
		<133, 2149, 3342>, 1,
		<133, 3342, 1160>, 1,
		<133, 1160, 4005>, 1,
		<133, 4005, 1958>, 1,
		<133, 1958, 3741>, 1,
		<133, 3741, 2146>, 1,
		<133, 2146, 3046>, 1,
		<133, 3046, 2149>, 1,
		<134, 2150, 3754>, 1,
		<134, 3754, 1985>, 1,
		<134, 1985, 4008>, 1,
		<134, 4008, 1212>, 1,
		<134, 1212, 3368>, 1,
		<134, 3368, 2151>, 1,
		<134, 2151, 3047>, 1,
		<134, 3047, 2150>, 1,
		<135, 2151, 3368>, 1,
		<135, 3368, 1213>, 1,
		<135, 1213, 3817>, 1,
		<135, 3817, 1214>, 1,
		<135, 1214, 3369>, 1,
		<135, 3369, 2152>, 1,
		<135, 2152, 3047>, 1,
		<135, 3047, 2151>, 1,
		<136, 2152, 3369>, 1,
		<136, 3369, 1215>, 1,
		<136, 1215, 3816>, 1,
		<136, 3816, 1167>, 1,
		<136, 1167, 3345>, 1,
		<136, 3345, 2153>, 1,
		<136, 2153, 3047>, 1,
		<136, 3047, 2152>, 1,
		<137, 2153, 3345>, 1,
		<137, 3345, 1166>, 1,
		<137, 1166, 4006>, 1,
		<137, 4006, 1984>, 1,
		<137, 1984, 3754>, 1,
		<137, 3754, 2150>, 1,
		<137, 2150, 3047>, 1,
		<137, 3047, 2153>, 1,
		<138, 2154, 3370>, 1,
		<138, 3370, 1217>, 1,
		<138, 1217, 3841>, 1,
		<138, 3841, 1218>, 1,
		<138, 1218, 3371>, 1,
		<138, 3371, 2155>, 1,
		<138, 2155, 3048>, 1,
		<138, 3048, 2154>, 1,
		<139, 2155, 3371>, 1,
		<139, 3371, 1219>, 1,
		<139, 1219, 3829>, 1,
		<139, 3829, 1211>, 1,
		<139, 1211, 3367>, 1,
		<139, 3367, 2156>, 1,
		<139, 2156, 3048>, 1,
		<139, 3048, 2155>, 1,
		<140, 2156, 3367>, 1,
		<140, 3367, 1210>, 1,
		<140, 1210, 3828>, 1,
		<140, 3828, 1173>, 1,
		<140, 1173, 3348>, 1,
		<140, 3348, 2157>, 1,
		<140, 2157, 3048>, 1,
		<140, 3048, 2156>, 1,
		<141, 2157, 3348>, 1,
		<141, 3348, 1172>, 1,
		<141, 1172, 3840>, 1,
		<141, 3840, 1216>, 1,
		<141, 1216, 3370>, 1,
		<141, 3370, 2154>, 1,
		<141, 2154, 3048>, 1,
		<141, 3048, 2157>, 1,
		<142, 2158, 3372>, 1,
		<142, 3372, 1221>, 1,
		<142, 1221, 3853>, 1,
		<142, 3853, 1222>, 1,
		<142, 1222, 3373>, 1,
		<142, 3373, 2159>, 1,
		<142, 2159, 3049>, 1,
		<142, 3049, 2158>, 1,
		<143, 2159, 3373>, 1,
		<143, 3373, 1223>, 1,
		<143, 1223, 3841>, 1,
		<143, 3841, 1217>, 1,
		<143, 1217, 3370>, 1,
		<143, 3370, 2160>, 1,
		<143, 2160, 3049>, 1,
		<143, 3049, 2159>, 1,
		<144, 2160, 3370>, 1,
		<144, 3370, 1216>, 1,
		<144, 1216, 3840>, 1,
		<144, 3840, 1177>, 1,
		<144, 1177, 3350>, 1,
		<144, 3350, 2161>, 1,
		<144, 2161, 3049>, 1,
		<144, 3049, 2160>, 1,
		<145, 2161, 3350>, 1,
		<145, 3350, 1176>, 1,
		<145, 1176, 3852>, 1,
		<145, 3852, 1220>, 1,
		<145, 1220, 3372>, 1,
		<145, 3372, 2158>, 1,
		<145, 2158, 3049>, 1,
		<145, 3049, 2161>, 1,
		<146, 2162, 3374>, 1,
		<146, 3374, 1225>, 1,
		<146, 1225, 3865>, 1,
		<146, 3865, 1226>, 1,
		<146, 1226, 3375>, 1,
		<146, 3375, 2163>, 1,
		<146, 2163, 3050>, 1,
		<146, 3050, 2162>, 1,
		<147, 2163, 3375>, 1,
		<147, 3375, 1227>, 1,
		<147, 1227, 3853>, 1,
		<147, 3853, 1221>, 1,
		<147, 1221, 3372>, 1,
		<147, 3372, 2164>, 1,
		<147, 2164, 3050>, 1,
		<147, 3050, 2163>, 1,
		<148, 2164, 3372>, 1,
		<148, 3372, 1220>, 1,
		<148, 1220, 3852>, 1,
		<148, 3852, 1181>, 1,
		<148, 1181, 3352>, 1,
		<148, 3352, 2165>, 1,
		<148, 2165, 3050>, 1,
		<148, 3050, 2164>, 1,
		<149, 2165, 3352>, 1,
		<149, 3352, 1180>, 1,
		<149, 1180, 3864>, 1,
		<149, 3864, 1224>, 1,
		<149, 1224, 3374>, 1,
		<149, 3374, 2162>, 1,
		<149, 2162, 3050>, 1,
		<149, 3050, 2165>, 1,
		<150, 2166, 3376>, 1,
		<150, 3376, 1228>, 1,
		<150, 1228, 3877>, 1,
		<150, 3877, 1230>, 1,
		<150, 1230, 3377>, 1,
		<150, 3377, 2167>, 1,
		<150, 2167, 3051>, 1,
		<150, 3051, 2166>, 1,
		<151, 2167, 3377>, 1,
		<151, 3377, 1231>, 1,
		<151, 1231, 3865>, 1,
		<151, 3865, 1225>, 1,
		<151, 1225, 3374>, 1,
		<151, 3374, 2168>, 1,
		<151, 2168, 3051>, 1,
		<151, 3051, 2167>, 1,
		<152, 2168, 3374>, 1,
		<152, 3374, 1224>, 1,
		<152, 1224, 3864>, 1,
		<152, 3864, 1185>, 1,
		<152, 1185, 3354>, 1,
		<152, 3354, 2169>, 1,
		<152, 2169, 3051>, 1,
		<152, 3051, 2168>, 1,
		<153, 2169, 3354>, 1,
		<153, 3354, 1184>, 1,
		<153, 1184, 3876>, 1,
		<153, 3876, 1229>, 1,
		<153, 1229, 3376>, 1,
		<153, 3376, 2166>, 1,
		<153, 2166, 3051>, 1,
		<153, 3051, 2169>, 1,
		<154, 2170, 3577>, 2,
		<154, 3577, 1631>, 2,
		<154, 1631, 3962>, 2,
		<154, 3962, 1234>, 2,
		<154, 1234, 3379>, 2,
		<154, 3379, 2171>, 2,
		<154, 2171, 3052>, 2,
		<154, 3052, 2170>, 2,
		<155, 2171, 3379>, 2,
		<155, 3379, 1235>, 2,
		<155, 1235, 3963>, 2,
		<155, 3963, 1633>, 2,
		<155, 1633, 3578>, 2,
		<155, 3578, 2172>, 2,
		<155, 2172, 3052>, 2,
		<155, 3052, 2171>, 2,
		<156, 2172, 3578>, 2,
		<156, 3578, 1632>, 2,
		<156, 1632, 3961>, 2,
		<156, 3961, 1189>, 2,
		<156, 1189, 3356>, 2,
		<156, 3356, 2173>, 2,
		<156, 2173, 3052>, 2,
		<156, 3052, 2172>, 2,
		<157, 2173, 3356>, 2,
		<157, 3356, 1188>, 2,
		<157, 1188, 3959>, 2,
		<157, 3959, 1630>, 2,
		<157, 1630, 3577>, 2,
		<157, 3577, 2170>, 2,
		<157, 2170, 3052>, 2,
		<157, 3052, 2173>, 2,
		<158, 2174, 3380>, 1,
		<158, 3380, 1237>, 1,
		<158, 1237, 3901>, 1,
		<158, 3901, 1238>, 1,
		<158, 1238, 3381>, 1,
		<158, 3381, 2175>, 1,
		<158, 2175, 3053>, 1,
		<158, 3053, 2174>, 1,
		<159, 2175, 3381>, 1,
		<159, 3381, 1239>, 1,
		<159, 1239, 3889>, 1,
		<159, 3889, 1233>, 1,
		<159, 1233, 3378>, 1,
		<159, 3378, 2176>, 1,
		<159, 2176, 3053>, 1,
		<159, 3053, 2175>, 1,
		<160, 2176, 3378>, 1,
		<160, 3378, 1232>, 1,
		<160, 1232, 3888>, 1,
		<160, 3888, 1193>, 1,
		<160, 1193, 3358>, 1,
		<160, 3358, 2177>, 1,
		<160, 2177, 3053>, 1,
		<160, 3053, 2176>, 1,
		<161, 2177, 3358>, 1,
		<161, 3358, 1192>, 1,
		<161, 1192, 3900>, 1,
		<161, 3900, 1236>, 1,
		<161, 1236, 3380>, 1,
		<161, 3380, 2174>, 1,
		<161, 2174, 3053>, 1,
		<161, 3053, 2177>, 1,
		<162, 2178, 3382>, 1,
		<162, 3382, 1241>, 1,
		<162, 1241, 3913>, 1,
		<162, 3913, 1242>, 1,
		<162, 1242, 3383>, 1,
		<162, 3383, 2179>, 1,
		<162, 2179, 3054>, 1,
		<162, 3054, 2178>, 1,
		<163, 2179, 3383>, 1,
		<163, 3383, 1243>, 1,
		<163, 1243, 3901>, 1,
		<163, 3901, 1237>, 1,
		<163, 1237, 3380>, 1,
		<163, 3380, 2180>, 1,
		<163, 2180, 3054>, 1,
		<163, 3054, 2179>, 1,
		<164, 2180, 3380>, 1,
		<164, 3380, 1236>, 1,
		<164, 1236, 3900>, 1,
		<164, 3900, 1197>, 1,
		<164, 1197, 3360>, 1,
		<164, 3360, 2181>, 1,
		<164, 2181, 3054>, 1,
		<164, 3054, 2180>, 1,
		<165, 2181, 3360>, 1,
		<165, 3360, 1196>, 1,
		<165, 1196, 3912>, 1,
		<165, 3912, 1240>, 1,
		<165, 1240, 3382>, 1,
		<165, 3382, 2178>, 1,
		<165, 2178, 3054>, 1,
		<165, 3054, 2181>, 1,
		<166, 2182, 3384>, 1,
		<166, 3384, 1245>, 1,
		<166, 1245, 3925>, 1,
		<166, 3925, 1246>, 1,
		<166, 1246, 3385>, 1,
		<166, 3385, 2183>, 1,
		<166, 2183, 3055>, 1,
		<166, 3055, 2182>, 1,
		<167, 2183, 3385>, 1,
		<167, 3385, 1247>, 1,
		<167, 1247, 3913>, 1,
		<167, 3913, 1241>, 1,
		<167, 1241, 3382>, 1,
		<167, 3382, 2184>, 1,
		<167, 2184, 3055>, 1,
		<167, 3055, 2183>, 1,
		<168, 2184, 3382>, 1,
		<168, 3382, 1240>, 1,
		<168, 1240, 3912>, 1,
		<168, 3912, 1201>, 1,
		<168, 1201, 3362>, 1,
		<168, 3362, 2185>, 1,
		<168, 2185, 3055>, 1,
		<168, 3055, 2184>, 1,
		<169, 2185, 3362>, 1,
		<169, 3362, 1200>, 1,
		<169, 1200, 3924>, 1,
		<169, 3924, 1244>, 1,
		<169, 1244, 3384>, 1,
		<169, 3384, 2182>, 1,
		<169, 2182, 3055>, 1,
		<169, 3055, 2185>, 1,
		<170, 2186, 3386>, 1,
		<170, 3386, 1249>, 1,
		<170, 1249, 3937>, 1,
		<170, 3937, 1250>, 1,
		<170, 1250, 3387>, 1,
		<170, 3387, 2187>, 1,
		<170, 2187, 3056>, 1,
		<170, 3056, 2186>, 1,
		<171, 2187, 3387>, 1,
		<171, 3387, 1251>, 1,
		<171, 1251, 3925>, 1,
		<171, 3925, 1245>, 1,
		<171, 1245, 3384>, 1,
		<171, 3384, 2188>, 1,
		<171, 2188, 3056>, 1,
		<171, 3056, 2187>, 1,
		<172, 2188, 3384>, 1,
		<172, 3384, 1244>, 1,
		<172, 1244, 3924>, 1,
		<172, 3924, 1205>, 1,
		<172, 1205, 3364>, 1,
		<172, 3364, 2189>, 1,
		<172, 2189, 3056>, 1,
		<172, 3056, 2188>, 1,
		<173, 2189, 3364>, 1,
		<173, 3364, 1204>, 1,
		<173, 1204, 3936>, 1,
		<173, 3936, 1248>, 1,
		<173, 1248, 3386>, 1,
		<173, 3386, 2186>, 1,
		<173, 2186, 3056>, 1,
		<173, 3056, 2189>, 1,
		<174, 2190, 3740>, 1,
		<174, 3740, 1957>, 1,
		<174, 1957, 4009>, 1,
		<174, 4009, 1254>, 1,
		<174, 1254, 3389>, 1,
		<174, 3389, 2191>, 1,
		<174, 2191, 3057>, 1,
		<174, 3057, 2190>, 1,
		<175, 2191, 3389>, 1,
		<175, 3389, 1255>, 1,
		<175, 1255, 3937>, 1,
		<175, 3937, 1249>, 1,
		<175, 1249, 3386>, 1,
		<175, 3386, 2192>, 1,
		<175, 2192, 3057>, 1,
		<175, 3057, 2191>, 1,
		<176, 2192, 3386>, 1,
		<176, 3386, 1248>, 1,
		<176, 1248, 3936>, 1,
		<176, 3936, 1209>, 1,
		<176, 1209, 3366>, 1,
		<176, 3366, 2193>, 1,
		<176, 2193, 3057>, 1,
		<176, 3057, 2192>, 1,
		<177, 2193, 3366>, 1,
		<177, 3366, 1208>, 1,
		<177, 1208, 4007>, 1,
		<177, 4007, 1956>, 1,
		<177, 1956, 3740>, 1,
		<177, 3740, 2190>, 1,
		<177, 2190, 3057>, 1,
		<177, 3057, 2193>, 1,
		<178, 2194, 3755>, 1,
		<178, 3755, 1987>, 1,
		<178, 1987, 4010>, 1,
		<178, 4010, 1258>, 1,
		<178, 1258, 3391>, 1,
		<178, 3391, 2195>, 1,
		<178, 2195, 3058>, 1,
		<178, 3058, 2194>, 1,
		<179, 2195, 3391>, 1,
		<179, 3391, 1259>, 1,
		<179, 1259, 3818>, 1,
		<179, 3818, 1260>, 1,
		<179, 1260, 3392>, 1,
		<179, 3392, 2196>, 1,
		<179, 2196, 3058>, 1,
		<179, 3058, 2195>, 1,
		<180, 2196, 3392>, 1,
		<180, 3392, 1261>, 1,
		<180, 1261, 3817>, 1,
		<180, 3817, 1213>, 1,
		<180, 1213, 3368>, 1,
		<180, 3368, 2197>, 1,
		<180, 2197, 3058>, 1,
		<180, 3058, 2196>, 1,
		<181, 2197, 3368>, 1,
		<181, 3368, 1212>, 1,
		<181, 1212, 4008>, 1,
		<181, 4008, 1986>, 1,
		<181, 1986, 3755>, 1,
		<181, 3755, 2194>, 1,
		<181, 2194, 3058>, 1,
		<181, 3058, 2197>, 1,
		<182, 2198, 3393>, 1,
		<182, 3393, 1263>, 1,
		<182, 1263, 3842>, 1,
		<182, 3842, 1264>, 1,
		<182, 1264, 3394>, 1,
		<182, 3394, 2199>, 1,
		<182, 2199, 3059>, 1,
		<182, 3059, 2198>, 1,
		<183, 2199, 3394>, 1,
		<183, 3394, 1265>, 1,
		<183, 1265, 3830>, 1,
		<183, 3830, 1257>, 1,
		<183, 1257, 3390>, 1,
		<183, 3390, 2200>, 1,
		<183, 2200, 3059>, 1,
		<183, 3059, 2199>, 1,
		<184, 2200, 3390>, 1,
		<184, 3390, 1256>, 1,
		<184, 1256, 3829>, 1,
		<184, 3829, 1219>, 1,
		<184, 1219, 3371>, 1,
		<184, 3371, 2201>, 1,
		<184, 2201, 3059>, 1,
		<184, 3059, 2200>, 1,
		<185, 2201, 3371>, 1,
		<185, 3371, 1218>, 1,
		<185, 1218, 3841>, 1,
		<185, 3841, 1262>, 1,
		<185, 1262, 3393>, 1,
		<185, 3393, 2198>, 1,
		<185, 2198, 3059>, 1,
		<185, 3059, 2201>, 1,
		<186, 2202, 3395>, 1,
		<186, 3395, 1267>, 1,
		<186, 1267, 3854>, 1,
		<186, 3854, 1268>, 1,
		<186, 1268, 3396>, 1,
		<186, 3396, 2203>, 1,
		<186, 2203, 3060>, 1,
		<186, 3060, 2202>, 1,
		<187, 2203, 3396>, 1,
		<187, 3396, 1269>, 1,
		<187, 1269, 3842>, 1,
		<187, 3842, 1263>, 1,
		<187, 1263, 3393>, 1,
		<187, 3393, 2204>, 1,
		<187, 2204, 3060>, 1,
		<187, 3060, 2203>, 1,
		<188, 2204, 3393>, 1,
		<188, 3393, 1262>, 1,
		<188, 1262, 3841>, 1,
		<188, 3841, 1223>, 1,
		<188, 1223, 3373>, 1,
		<188, 3373, 2205>, 1,
		<188, 2205, 3060>, 1,
		<188, 3060, 2204>, 1,
		<189, 2205, 3373>, 1,
		<189, 3373, 1222>, 1,
		<189, 1222, 3853>, 1,
		<189, 3853, 1266>, 1,
		<189, 1266, 3395>, 1,
		<189, 3395, 2202>, 1,
		<189, 2202, 3060>, 1,
		<189, 3060, 2205>, 1,
		<190, 2206, 3397>, 1,
		<190, 3397, 1271>, 1,
		<190, 1271, 3866>, 1,
		<190, 3866, 1272>, 1,
		<190, 1272, 3398>, 1,
		<190, 3398, 2207>, 1,
		<190, 2207, 3061>, 1,
		<190, 3061, 2206>, 1,
		<191, 2207, 3398>, 1,
		<191, 3398, 1273>, 1,
		<191, 1273, 3854>, 1,
		<191, 3854, 1267>, 1,
		<191, 1267, 3395>, 1,
		<191, 3395, 2208>, 1,
		<191, 2208, 3061>, 1,
		<191, 3061, 2207>, 1,
		<192, 2208, 3395>, 1,
		<192, 3395, 1266>, 1,
		<192, 1266, 3853>, 1,
		<192, 3853, 1227>, 1,
		<192, 1227, 3375>, 1,
		<192, 3375, 2209>, 1,
		<192, 2209, 3061>, 1,
		<192, 3061, 2208>, 1,
		<193, 2209, 3375>, 1,
		<193, 3375, 1226>, 1,
		<193, 1226, 3865>, 1,
		<193, 3865, 1270>, 1,
		<193, 1270, 3397>, 1,
		<193, 3397, 2206>, 1,
		<193, 2206, 3061>, 1,
		<193, 3061, 2209>, 1,
		<194, 2210, 3399>, 1,
		<194, 3399, 1274>, 1,
		<194, 1274, 3878>, 1,
		<194, 3878, 1276>, 1,
		<194, 1276, 3400>, 1,
		<194, 3400, 2211>, 1,
		<194, 2211, 3062>, 1,
		<194, 3062, 2210>, 1,
		<195, 2211, 3400>, 1,
		<195, 3400, 1277>, 1,
		<195, 1277, 3866>, 1,
		<195, 3866, 1271>, 1,
		<195, 1271, 3397>, 1,
		<195, 3397, 2212>, 1,
		<195, 2212, 3062>, 1,
		<195, 3062, 2211>, 1,
		<196, 2212, 3397>, 1,
		<196, 3397, 1270>, 1,
		<196, 1270, 3865>, 1,
		<196, 3865, 1231>, 1,
		<196, 1231, 3377>, 1,
		<196, 3377, 2213>, 1,
		<196, 2213, 3062>, 1,
		<196, 3062, 2212>, 1,
		<197, 2213, 3377>, 1,
		<197, 3377, 1230>, 1,
		<197, 1230, 3877>, 1,
		<197, 3877, 1275>, 1,
		<197, 1275, 3399>, 1,
		<197, 3399, 2210>, 1,
		<197, 2210, 3062>, 1,
		<197, 3062, 2213>, 1,
		<198, 2214, 3579>, 2,
		<198, 3579, 1635>, 2,
		<198, 1635, 3964>, 2,
		<198, 3964, 1280>, 2,
		<198, 1280, 3402>, 2,
		<198, 3402, 2215>, 2,
		<198, 2215, 3063>, 2,
		<198, 3063, 2214>, 2,
		<199, 2215, 3402>, 2,
		<199, 3402, 1281>, 2,
		<199, 1281, 3965>, 2,
		<199, 3965, 1637>, 2,
		<199, 1637, 3580>, 2,
		<199, 3580, 2216>, 2,
		<199, 2216, 3063>, 2,
		<199, 3063, 2215>, 2,
		<200, 2216, 3580>, 2,
		<200, 3580, 1636>, 2,
		<200, 1636, 3963>, 2,
		<200, 3963, 1235>, 2,
		<200, 1235, 3379>, 2,
		<200, 3379, 2217>, 2,
		<200, 2217, 3063>, 2,
		<200, 3063, 2216>, 2,
		<201, 2217, 3379>, 2,
		<201, 3379, 1234>, 2,
		<201, 1234, 3962>, 2,
		<201, 3962, 1634>, 2,
		<201, 1634, 3579>, 2,
		<201, 3579, 2214>, 2,
		<201, 2214, 3063>, 2,
		<201, 3063, 2217>, 2,
		<202, 2218, 3403>, 1,
		<202, 3403, 1283>, 1,
		<202, 1283, 3902>, 1,
		<202, 3902, 1284>, 1,
		<202, 1284, 3404>, 1,
		<202, 3404, 2219>, 1,
		<202, 2219, 3064>, 1,
		<202, 3064, 2218>, 1,
		<203, 2219, 3404>, 1,
		<203, 3404, 1285>, 1,
		<203, 1285, 3890>, 1,
		<203, 3890, 1279>, 1,
		<203, 1279, 3401>, 1,
		<203, 3401, 2220>, 1,
		<203, 2220, 3064>, 1,
		<203, 3064, 2219>, 1,
		<204, 2220, 3401>, 1,
		<204, 3401, 1278>, 1,
		<204, 1278, 3889>, 1,
		<204, 3889, 1239>, 1,
		<204, 1239, 3381>, 1,
		<204, 3381, 2221>, 1,
		<204, 2221, 3064>, 1,
		<204, 3064, 2220>, 1,
		<205, 2221, 3381>, 1,
		<205, 3381, 1238>, 1,
		<205, 1238, 3901>, 1,
		<205, 3901, 1282>, 1,
		<205, 1282, 3403>, 1,
		<205, 3403, 2218>, 1,
		<205, 2218, 3064>, 1,
		<205, 3064, 2221>, 1,
		<206, 2222, 3405>, 1,
		<206, 3405, 1287>, 1,
		<206, 1287, 3914>, 1,
		<206, 3914, 1288>, 1,
		<206, 1288, 3406>, 1,
		<206, 3406, 2223>, 1,
		<206, 2223, 3065>, 1,
		<206, 3065, 2222>, 1,
		<207, 2223, 3406>, 1,
		<207, 3406, 1289>, 1,
		<207, 1289, 3902>, 1,
		<207, 3902, 1283>, 1,
		<207, 1283, 3403>, 1,
		<207, 3403, 2224>, 1,
		<207, 2224, 3065>, 1,
		<207, 3065, 2223>, 1,
		<208, 2224, 3403>, 1,
		<208, 3403, 1282>, 1,
		<208, 1282, 3901>, 1,
		<208, 3901, 1243>, 1,
		<208, 1243, 3383>, 1,
		<208, 3383, 2225>, 1,
		<208, 2225, 3065>, 1,
		<208, 3065, 2224>, 1,
		<209, 2225, 3383>, 1,
		<209, 3383, 1242>, 1,
		<209, 1242, 3913>, 1,
		<209, 3913, 1286>, 1,
		<209, 1286, 3405>, 1,
		<209, 3405, 2222>, 1,
		<209, 2222, 3065>, 1,
		<209, 3065, 2225>, 1,
		<210, 2226, 3407>, 1,
		<210, 3407, 1291>, 1,
		<210, 1291, 3926>, 1,
		<210, 3926, 1292>, 1,
		<210, 1292, 3408>, 1,
		<210, 3408, 2227>, 1,
		<210, 2227, 3066>, 1,
		<210, 3066, 2226>, 1,
		<211, 2227, 3408>, 1,
		<211, 3408, 1293>, 1,
		<211, 1293, 3914>, 1,
		<211, 3914, 1287>, 1,
		<211, 1287, 3405>, 1,
		<211, 3405, 2228>, 1,
		<211, 2228, 3066>, 1,
		<211, 3066, 2227>, 1,
		<212, 2228, 3405>, 1,
		<212, 3405, 1286>, 1,
		<212, 1286, 3913>, 1,
		<212, 3913, 1247>, 1,
		<212, 1247, 3385>, 1,
		<212, 3385, 2229>, 1,
		<212, 2229, 3066>, 1,
		<212, 3066, 2228>, 1,
		<213, 2229, 3385>, 1,
		<213, 3385, 1246>, 1,
		<213, 1246, 3925>, 1,
		<213, 3925, 1290>, 1,
		<213, 1290, 3407>, 1,
		<213, 3407, 2226>, 1,
		<213, 2226, 3066>, 1,
		<213, 3066, 2229>, 1,
		<214, 2230, 3409>, 1,
		<214, 3409, 1295>, 1,
		<214, 1295, 3938>, 1,
		<214, 3938, 1296>, 1,
		<214, 1296, 3410>, 1,
		<214, 3410, 2231>, 1,
		<214, 2231, 3067>, 1,
		<214, 3067, 2230>, 1,
		<215, 2231, 3410>, 1,
		<215, 3410, 1297>, 1,
		<215, 1297, 3926>, 1,
		<215, 3926, 1291>, 1,
		<215, 1291, 3407>, 1,
		<215, 3407, 2232>, 1,
		<215, 2232, 3067>, 1,
		<215, 3067, 2231>, 1,
		<216, 2232, 3407>, 1,
		<216, 3407, 1290>, 1,
		<216, 1290, 3925>, 1,
		<216, 3925, 1251>, 1,
		<216, 1251, 3387>, 1,
		<216, 3387, 2233>, 1,
		<216, 2233, 3067>, 1,
		<216, 3067, 2232>, 1,
		<217, 2233, 3387>, 1,
		<217, 3387, 1250>, 1,
		<217, 1250, 3937>, 1,
		<217, 3937, 1294>, 1,
		<217, 1294, 3409>, 1,
		<217, 3409, 2230>, 1,
		<217, 2230, 3067>, 1,
		<217, 3067, 2233>, 1,
		<218, 2234, 3739>, 1,
		<218, 3739, 1955>, 1,
		<218, 1955, 4011>, 1,
		<218, 4011, 1300>, 1,
		<218, 1300, 3412>, 1,
		<218, 3412, 2235>, 1,
		<218, 2235, 3068>, 1,
		<218, 3068, 2234>, 1,
		<219, 2235, 3412>, 1,
		<219, 3412, 1301>, 1,
		<219, 1301, 3938>, 1,
		<219, 3938, 1295>, 1,
		<219, 1295, 3409>, 1,
		<219, 3409, 2236>, 1,
		<219, 2236, 3068>, 1,
		<219, 3068, 2235>, 1,
		<220, 2236, 3409>, 1,
		<220, 3409, 1294>, 1,
		<220, 1294, 3937>, 1,
		<220, 3937, 1255>, 1,
		<220, 1255, 3389>, 1,
		<220, 3389, 2237>, 1,
		<220, 2237, 3068>, 1,
		<220, 3068, 2236>, 1,
		<221, 2237, 3389>, 1,
		<221, 3389, 1254>, 1,
		<221, 1254, 4009>, 1,
		<221, 4009, 1954>, 1,
		<221, 1954, 3739>, 1,
		<221, 3739, 2234>, 1,
		<221, 2234, 3068>, 1,
		<221, 3068, 2237>, 1,
		<222, 2238, 3756>, 1,
		<222, 3756, 1989>, 1,
		<222, 1989, 4012>, 1,
		<222, 4012, 1304>, 1,
		<222, 1304, 3414>, 1,
		<222, 3414, 2239>, 1,
		<222, 2239, 3069>, 1,
		<222, 3069, 2238>, 1,
		<223, 2239, 3414>, 1,
		<223, 3414, 1305>, 1,
		<223, 1305, 3819>, 1,
		<223, 3819, 1306>, 1,
		<223, 1306, 3415>, 1,
		<223, 3415, 2240>, 1,
		<223, 2240, 3069>, 1,
		<223, 3069, 2239>, 1,
		<224, 2240, 3415>, 1,
		<224, 3415, 1307>, 1,
		<224, 1307, 3818>, 1,
		<224, 3818, 1259>, 1,
		<224, 1259, 3391>, 1,
		<224, 3391, 2241>, 1,
		<224, 2241, 3069>, 1,
		<224, 3069, 2240>, 1,
		<225, 2241, 3391>, 1,
		<225, 3391, 1258>, 1,
		<225, 1258, 4010>, 1,
		<225, 4010, 1988>, 1,
		<225, 1988, 3756>, 1,
		<225, 3756, 2238>, 1,
		<225, 2238, 3069>, 1,
		<225, 3069, 2241>, 1,
		<226, 2242, 3416>, 1,
		<226, 3416, 1309>, 1,
		<226, 1309, 3843>, 1,
		<226, 3843, 1311>, 1,
		<226, 1311, 3417>, 1,
		<226, 3417, 2243>, 1,
		<226, 2243, 3070>, 1,
		<226, 3070, 2242>, 1,
		<227, 2243, 3417>, 1,
		<227, 3417, 1310>, 1,
		<227, 1310, 3831>, 1,
		<227, 3831, 1303>, 1,
		<227, 1303, 3413>, 1,
		<227, 3413, 2244>, 1,
		<227, 2244, 3070>, 1,
		<227, 3070, 2243>, 1,
		<228, 2244, 3413>, 1,
		<228, 3413, 1302>, 1,
		<228, 1302, 3830>, 1,
		<228, 3830, 1265>, 1,
		<228, 1265, 3394>, 1,
		<228, 3394, 2245>, 1,
		<228, 2245, 3070>, 1,
		<228, 3070, 2244>, 1,
		<229, 2245, 3394>, 1,
		<229, 3394, 1264>, 1,
		<229, 1264, 3842>, 1,
		<229, 3842, 1308>, 1,
		<229, 1308, 3416>, 1,
		<229, 3416, 2242>, 1,
		<229, 2242, 3070>, 1,
		<229, 3070, 2245>, 1,
		<230, 2246, 3418>, 1,
		<230, 3418, 1313>, 1,
		<230, 1313, 3855>, 1,
		<230, 3855, 1315>, 1,
		<230, 1315, 3419>, 1,
		<230, 3419, 2247>, 1,
		<230, 2247, 3071>, 1,
		<230, 3071, 2246>, 1,
		<231, 2247, 3419>, 1,
		<231, 3419, 1314>, 1,
		<231, 1314, 3843>, 1,
		<231, 3843, 1309>, 1,
		<231, 1309, 3416>, 1,
		<231, 3416, 2248>, 1,
		<231, 2248, 3071>, 1,
		<231, 3071, 2247>, 1,
		<232, 2248, 3416>, 1,
		<232, 3416, 1308>, 1,
		<232, 1308, 3842>, 1,
		<232, 3842, 1269>, 1,
		<232, 1269, 3396>, 1,
		<232, 3396, 2249>, 1,
		<232, 2249, 3071>, 1,
		<232, 3071, 2248>, 1,
		<233, 2249, 3396>, 1,
		<233, 3396, 1268>, 1,
		<233, 1268, 3854>, 1,
		<233, 3854, 1312>, 1,
		<233, 1312, 3418>, 1,
		<233, 3418, 2246>, 1,
		<233, 2246, 3071>, 1,
		<233, 3071, 2249>, 1,
		<234, 2250, 3420>, 1,
		<234, 3420, 1317>, 1,
		<234, 1317, 3867>, 1,
		<234, 3867, 1319>, 1,
		<234, 1319, 3421>, 1,
		<234, 3421, 2251>, 1,
		<234, 2251, 3072>, 1,
		<234, 3072, 2250>, 1,
		<235, 2251, 3421>, 1,
		<235, 3421, 1318>, 1,
		<235, 1318, 3855>, 1,
		<235, 3855, 1313>, 1,
		<235, 1313, 3418>, 1,
		<235, 3418, 2252>, 1,
		<235, 2252, 3072>, 1,
		<235, 3072, 2251>, 1,
		<236, 2252, 3418>, 1,
		<236, 3418, 1312>, 1,
		<236, 1312, 3854>, 1,
		<236, 3854, 1273>, 1,
		<236, 1273, 3398>, 1,
		<236, 3398, 2253>, 1,
		<236, 2253, 3072>, 1,
		<236, 3072, 2252>, 1,
		<237, 2253, 3398>, 1,
		<237, 3398, 1272>, 1,
		<237, 1272, 3866>, 1,
		<237, 3866, 1316>, 1,
		<237, 1316, 3420>, 1,
		<237, 3420, 2250>, 1,
		<237, 2250, 3072>, 1,
		<237, 3072, 2253>, 1,
		<238, 2254, 3422>, 1,
		<238, 3422, 1320>, 1,
		<238, 1320, 3879>, 1,
		<238, 3879, 1323>, 1,
		<238, 1323, 3423>, 1,
		<238, 3423, 2255>, 1,
		<238, 2255, 3073>, 1,
		<238, 3073, 2254>, 1,
		<239, 2255, 3423>, 1,
		<239, 3423, 1322>, 1,
		<239, 1322, 3867>, 1,
		<239, 3867, 1317>, 1,
		<239, 1317, 3420>, 1,
		<239, 3420, 2256>, 1,
		<239, 2256, 3073>, 1,
		<239, 3073, 2255>, 1,
		<240, 2256, 3420>, 1,
		<240, 3420, 1316>, 1,
		<240, 1316, 3866>, 1,
		<240, 3866, 1277>, 1,
		<240, 1277, 3400>, 1,
		<240, 3400, 2257>, 1,
		<240, 2257, 3073>, 1,
		<240, 3073, 2256>, 1,
		<241, 2257, 3400>, 1,
		<241, 3400, 1276>, 1,
		<241, 1276, 3878>, 1,
		<241, 3878, 1321>, 1,
		<241, 1321, 3422>, 1,
		<241, 3422, 2254>, 1,
		<241, 2254, 3073>, 1,
		<241, 3073, 2257>, 1,
		<242, 2258, 3581>, 2,
		<242, 3581, 1639>, 2,
		<242, 1639, 3966>, 2,
		<242, 3966, 1326>, 2,
		<242, 1326, 3425>, 2,
		<242, 3425, 2259>, 2,
		<242, 2259, 3074>, 2,
		<242, 3074, 2258>, 2,
		<243, 2259, 3425>, 2,
		<243, 3425, 1327>, 2,
		<243, 1327, 3967>, 2,
		<243, 3967, 1641>, 2,
		<243, 1641, 3582>, 2,
		<243, 3582, 2260>, 2,
		<243, 2260, 3074>, 2,
		<243, 3074, 2259>, 2,
		<244, 2260, 3582>, 2,
		<244, 3582, 1640>, 2,
		<244, 1640, 3965>, 2,
		<244, 3965, 1281>, 2,
		<244, 1281, 3402>, 2,
		<244, 3402, 2261>, 2,
		<244, 2261, 3074>, 2,
		<244, 3074, 2260>, 2,
		<245, 2261, 3402>, 2,
		<245, 3402, 1280>, 2,
		<245, 1280, 3964>, 2,
		<245, 3964, 1638>, 2,
		<245, 1638, 3581>, 2,
		<245, 3581, 2258>, 2,
		<245, 2258, 3074>, 2,
		<245, 3074, 2261>, 2,
		<246, 2262, 3426>, 1,
		<246, 3426, 1329>, 1,
		<246, 1329, 3903>, 1,
		<246, 3903, 1331>, 1,
		<246, 1331, 3427>, 1,
		<246, 3427, 2263>, 1,
		<246, 2263, 3075>, 1,
		<246, 3075, 2262>, 1,
		<247, 2263, 3427>, 1,
		<247, 3427, 1330>, 1,
		<247, 1330, 3891>, 1,
		<247, 3891, 1325>, 1,
		<247, 1325, 3424>, 1,
		<247, 3424, 2264>, 1,
		<247, 2264, 3075>, 1,
		<247, 3075, 2263>, 1,
		<248, 2264, 3424>, 1,
		<248, 3424, 1324>, 1,
		<248, 1324, 3890>, 1,
		<248, 3890, 1285>, 1,
		<248, 1285, 3404>, 1,
		<248, 3404, 2265>, 1,
		<248, 2265, 3075>, 1,
		<248, 3075, 2264>, 1,
		<249, 2265, 3404>, 1,
		<249, 3404, 1284>, 1,
		<249, 1284, 3902>, 1,
		<249, 3902, 1328>, 1,
		<249, 1328, 3426>, 1,
		<249, 3426, 2262>, 1,
		<249, 2262, 3075>, 1,
		<249, 3075, 2265>, 1,
		<250, 2266, 3428>, 1,
		<250, 3428, 1333>, 1,
		<250, 1333, 3915>, 1,
		<250, 3915, 1335>, 1,
		<250, 1335, 3429>, 1,
		<250, 3429, 2267>, 1,
		<250, 2267, 3076>, 1,
		<250, 3076, 2266>, 1,
		<251, 2267, 3429>, 1,
		<251, 3429, 1334>, 1,
		<251, 1334, 3903>, 1,
		<251, 3903, 1329>, 1,
		<251, 1329, 3426>, 1,
		<251, 3426, 2268>, 1,
		<251, 2268, 3076>, 1,
		<251, 3076, 2267>, 1,
		<252, 2268, 3426>, 1,
		<252, 3426, 1328>, 1,
		<252, 1328, 3902>, 1,
		<252, 3902, 1289>, 1,
		<252, 1289, 3406>, 1,
		<252, 3406, 2269>, 1,
		<252, 2269, 3076>, 1,
		<252, 3076, 2268>, 1,
		<253, 2269, 3406>, 1,
		<253, 3406, 1288>, 1,
		<253, 1288, 3914>, 1,
		<253, 3914, 1332>, 1,
		<253, 1332, 3428>, 1,
		<253, 3428, 2266>, 1,
		<253, 2266, 3076>, 1,
		<253, 3076, 2269>, 1,
		<254, 2270, 3430>, 1,
		<254, 3430, 1337>, 1,
		<254, 1337, 3927>, 1,
		<254, 3927, 1339>, 1,
		<254, 1339, 3431>, 1,
		<254, 3431, 2271>, 1,
		<254, 2271, 3077>, 1,
		<254, 3077, 2270>, 1,
		<255, 2271, 3431>, 1,
		<255, 3431, 1338>, 1,
		<255, 1338, 3915>, 1,
		<255, 3915, 1333>, 1,
		<255, 1333, 3428>, 1,
		<255, 3428, 2272>, 1,
		<255, 2272, 3077>, 1,
		<255, 3077, 2271>, 1,
		<256, 2272, 3428>, 1,
		<256, 3428, 1332>, 1,
		<256, 1332, 3914>, 1,
		<256, 3914, 1293>, 1,
		<256, 1293, 3408>, 1,
		<256, 3408, 2273>, 1,
		<256, 2273, 3077>, 1,
		<256, 3077, 2272>, 1,
		<257, 2273, 3408>, 1,
		<257, 3408, 1292>, 1,
		<257, 1292, 3926>, 1,
		<257, 3926, 1336>, 1,
		<257, 1336, 3430>, 1,
		<257, 3430, 2270>, 1,
		<257, 2270, 3077>, 1,
		<257, 3077, 2273>, 1,
		<258, 2274, 3432>, 1,
		<258, 3432, 1341>, 1,
		<258, 1341, 3939>, 1,
		<258, 3939, 1343>, 1,
		<258, 1343, 3433>, 1,
		<258, 3433, 2275>, 1,
		<258, 2275, 3078>, 1,
		<258, 3078, 2274>, 1,
		<259, 2275, 3433>, 1,
		<259, 3433, 1342>, 1,
		<259, 1342, 3927>, 1,
		<259, 3927, 1337>, 1,
		<259, 1337, 3430>, 1,
		<259, 3430, 2276>, 1,
		<259, 2276, 3078>, 1,
		<259, 3078, 2275>, 1,
		<260, 2276, 3430>, 1,
		<260, 3430, 1336>, 1,
		<260, 1336, 3926>, 1,
		<260, 3926, 1297>, 1,
		<260, 1297, 3410>, 1,
		<260, 3410, 2277>, 1,
		<260, 2277, 3078>, 1,
		<260, 3078, 2276>, 1,
		<261, 2277, 3410>, 1,
		<261, 3410, 1296>, 1,
		<261, 1296, 3938>, 1,
		<261, 3938, 1340>, 1,
		<261, 1340, 3432>, 1,
		<261, 3432, 2274>, 1,
		<261, 2274, 3078>, 1,
		<261, 3078, 2277>, 1,
		<262, 2278, 3738>, 1,
		<262, 3738, 1953>, 1,
		<262, 1953, 4013>, 1,
		<262, 4013, 1346>, 1,
		<262, 1346, 3435>, 1,
		<262, 3435, 2279>, 1,
		<262, 2279, 3079>, 1,
		<262, 3079, 2278>, 1,
		<263, 2279, 3435>, 1,
		<263, 3435, 1347>, 1,
		<263, 1347, 3939>, 1,
		<263, 3939, 1341>, 1,
		<263, 1341, 3432>, 1,
		<263, 3432, 2280>, 1,
		<263, 2280, 3079>, 1,
		<263, 3079, 2279>, 1,
		<264, 2280, 3432>, 1,
		<264, 3432, 1340>, 1,
		<264, 1340, 3938>, 1,
		<264, 3938, 1301>, 1,
		<264, 1301, 3412>, 1,
		<264, 3412, 2281>, 1,
		<264, 2281, 3079>, 1,
		<264, 3079, 2280>, 1,
		<265, 2281, 3412>, 1,
		<265, 3412, 1300>, 1,
		<265, 1300, 4011>, 1,
		<265, 4011, 1952>, 1,
		<265, 1952, 3738>, 1,
		<265, 3738, 2278>, 1,
		<265, 2278, 3079>, 1,
		<265, 3079, 2281>, 1,
		<266, 2282, 3757>, 1,
		<266, 3757, 1991>, 1,
		<266, 1991, 4014>, 1,
		<266, 4014, 1350>, 1,
		<266, 1350, 3437>, 1,
		<266, 3437, 2283>, 1,
		<266, 2283, 3080>, 1,
		<266, 3080, 2282>, 1,
		<267, 2283, 3437>, 1,
		<267, 3437, 1351>, 1,
		<267, 1351, 3820>, 1,
		<267, 3820, 1352>, 1,
		<267, 1352, 3438>, 1,
		<267, 3438, 2284>, 1,
		<267, 2284, 3080>, 1,
		<267, 3080, 2283>, 1,
		<268, 2284, 3438>, 1,
		<268, 3438, 1353>, 1,
		<268, 1353, 3819>, 1,
		<268, 3819, 1305>, 1,
		<268, 1305, 3414>, 1,
		<268, 3414, 2285>, 1,
		<268, 2285, 3080>, 1,
		<268, 3080, 2284>, 1,
		<269, 2285, 3414>, 1,
		<269, 3414, 1304>, 1,
		<269, 1304, 4012>, 1,
		<269, 4012, 1990>, 1,
		<269, 1990, 3757>, 1,
		<269, 3757, 2282>, 1,
		<269, 2282, 3080>, 1,
		<269, 3080, 2285>, 1,
		<270, 2286, 3439>, 2,
		<270, 3439, 1355>, 2,
		<270, 1355, 3968>, 2,
		<270, 3968, 1642>, 2,
		<270, 1642, 3583>, 2,
		<270, 3583, 2287>, 2,
		<270, 2287, 3081>, 2,
		<270, 3081, 2286>, 2,
		<271, 2287, 3583>, 2,
		<271, 3583, 1643>, 2,
		<271, 1643, 3969>, 2,
		<271, 3969, 1645>, 2,
		<271, 1645, 3584>, 2,
		<271, 3584, 2288>, 2,
		<271, 2288, 3081>, 2,
		<271, 3081, 2287>, 2,
		<272, 2288, 3584>, 2,
		<272, 3584, 1644>, 2,
		<272, 1644, 3970>, 2,
		<272, 3970, 1647>, 2,
		<272, 1647, 3585>, 2,
		<272, 3585, 2289>, 2,
		<272, 2289, 3081>, 2,
		<272, 3081, 2288>, 2,
		<273, 2289, 3585>, 2,
		<273, 3585, 1646>, 2,
		<273, 1646, 3971>, 2,
		<273, 3971, 1354>, 2,
		<273, 1354, 3439>, 2,
		<273, 3439, 2286>, 2,
		<273, 2286, 3081>, 2,
		<273, 3081, 2289>, 2,
		<274, 2290, 3441>, 2,
		<274, 3441, 1359>, 2,
		<274, 1359, 3972>, 2,
		<274, 3972, 1648>, 2,
		<274, 1648, 3586>, 2,
		<274, 3586, 2291>, 2,
		<274, 2291, 3082>, 2,
		<274, 3082, 2290>, 2,
		<275, 2291, 3586>, 2,
		<275, 3586, 1649>, 2,
		<275, 1649, 3968>, 2,
		<275, 3968, 1355>, 2,
		<275, 1355, 3439>, 2,
		<275, 3439, 2292>, 2,
		<275, 2292, 3082>, 2,
		<275, 3082, 2291>, 2,
		<276, 2292, 3439>, 2,
		<276, 3439, 1354>, 2,
		<276, 1354, 3971>, 2,
		<276, 3971, 1651>, 2,
		<276, 1651, 3587>, 2,
		<276, 3587, 2293>, 2,
		<276, 2293, 3082>, 2,
		<276, 3082, 2292>, 2,
		<277, 2293, 3587>, 2,
		<277, 3587, 1650>, 2,
		<277, 1650, 3973>, 2,
		<277, 3973, 1358>, 2,
		<277, 1358, 3441>, 2,
		<277, 3441, 2290>, 2,
		<277, 2290, 3082>, 2,
		<277, 3082, 2293>, 2,
		<278, 2294, 3443>, 2,
		<278, 3443, 1363>, 2,
		<278, 1363, 3974>, 2,
		<278, 3974, 1652>, 2,
		<278, 1652, 3588>, 2,
		<278, 3588, 2295>, 2,
		<278, 2295, 3083>, 2,
		<278, 3083, 2294>, 2,
		<279, 2295, 3588>, 2,
		<279, 3588, 1653>, 2,
		<279, 1653, 3972>, 2,
		<279, 3972, 1359>, 2,
		<279, 1359, 3441>, 2,
		<279, 3441, 2296>, 2,
		<279, 2296, 3083>, 2,
		<279, 3083, 2295>, 2,
		<280, 2296, 3441>, 2,
		<280, 3441, 1358>, 2,
		<280, 1358, 3973>, 2,
		<280, 3973, 1655>, 2,
		<280, 1655, 3589>, 2,
		<280, 3589, 2297>, 2,
		<280, 2297, 3083>, 2,
		<280, 3083, 2296>, 2,
		<281, 2297, 3589>, 2,
		<281, 3589, 1654>, 2,
		<281, 1654, 3975>, 2,
		<281, 3975, 1362>, 2,
		<281, 1362, 3443>, 2,
		<281, 3443, 2294>, 2,
		<281, 2294, 3083>, 2,
		<281, 3083, 2297>, 2,
		<282, 2298, 3445>, 2,
		<282, 3445, 1367>, 2,
		<282, 1367, 3976>, 2,
		<282, 3976, 1656>, 2,
		<282, 1656, 3590>, 2,
		<282, 3590, 2299>, 2,
		<282, 2299, 3084>, 2,
		<282, 3084, 2298>, 2,
		<283, 2299, 3590>, 2,
		<283, 3590, 1657>, 2,
		<283, 1657, 3974>, 2,
		<283, 3974, 1363>, 2,
		<283, 1363, 3443>, 2,
		<283, 3443, 2300>, 2,
		<283, 2300, 3084>, 2,
		<283, 3084, 2299>, 2,
		<284, 2300, 3443>, 2,
		<284, 3443, 1362>, 2,
		<284, 1362, 3975>, 2,
		<284, 3975, 1659>, 2,
		<284, 1659, 3591>, 2,
		<284, 3591, 2301>, 2,
		<284, 2301, 3084>, 2,
		<284, 3084, 2300>, 2,
		<285, 2301, 3591>, 2,
		<285, 3591, 1658>, 2,
		<285, 1658, 3967>, 2,
		<285, 3967, 1366>, 2,
		<285, 1366, 3445>, 2,
		<285, 3445, 2298>, 2,
		<285, 2298, 3084>, 2,
		<285, 3084, 2301>, 2,
		<286, 2302, 3447>, 2,
		<286, 3447, 1371>, 2,
		<286, 1371, 3978>, 2,
		<286, 3978, 1372>, 2,
		<286, 1372, 3448>, 2,
		<286, 3448, 2303>, 2,
		<286, 2303, 3085>, 2,
		<286, 3085, 2302>, 2,
		<287, 2303, 3448>, 2,
		<287, 3448, 1373>, 2,
		<287, 1373, 3976>, 2,
		<287, 3976, 1367>, 2,
		<287, 1367, 3445>, 2,
		<287, 3445, 2304>, 2,
		<287, 2304, 3085>, 2,
		<287, 3085, 2303>, 2,
		<288, 2304, 3445>, 2,
		<288, 3445, 1366>, 2,
		<288, 1366, 3967>, 2,
		<288, 3967, 1327>, 2,
		<288, 1327, 3425>, 2,
		<288, 3425, 2305>, 2,
		<288, 2305, 3085>, 2,
		<288, 3085, 2304>, 2,
		<289, 2305, 3425>, 2,
		<289, 3425, 1326>, 2,
		<289, 1326, 3966>, 2,
		<289, 3966, 1370>, 2,
		<289, 1370, 3447>, 2,
		<289, 3447, 2302>, 2,
		<289, 2302, 3085>, 2,
		<289, 3085, 2305>, 2,
		<290, 2306, 3449>, 2,
		<290, 3449, 1375>, 2,
		<290, 1375, 3977>, 2,
		<290, 3977, 1660>, 2,
		<290, 1660, 3592>, 2,
		<290, 3592, 2307>, 2,
		<290, 2307, 3086>, 2,
		<290, 3086, 2306>, 2,
		<291, 2307, 3592>, 2,
		<291, 3592, 1661>, 2,
		<291, 1661, 3978>, 2,
		<291, 3978, 1371>, 2,
		<291, 1371, 3447>, 2,
		<291, 3447, 2308>, 2,
		<291, 2308, 3086>, 2,
		<291, 3086, 2307>, 2,
		<292, 2308, 3447>, 2,
		<292, 3447, 1370>, 2,
		<292, 1370, 3966>, 2,
		<292, 3966, 1663>, 2,
		<292, 1663, 3593>, 2,
		<292, 3593, 2309>, 2,
		<292, 2309, 3086>, 2,
		<292, 3086, 2308>, 2,
		<293, 2309, 3593>, 2,
		<293, 3593, 1662>, 2,
		<293, 1662, 3979>, 2,
		<293, 3979, 1374>, 2,
		<293, 1374, 3449>, 2,
		<293, 3449, 2306>, 2,
		<293, 2306, 3086>, 2,
		<293, 3086, 2309>, 2,
		<294, 2310, 3451>, 2,
		<294, 3451, 1379>, 2,
		<294, 1379, 3980>, 2,
		<294, 3980, 1664>, 2,
		<294, 1664, 3594>, 2,
		<294, 3594, 2311>, 2,
		<294, 2311, 3087>, 2,
		<294, 3087, 2310>, 2,
		<295, 2311, 3594>, 2,
		<295, 3594, 1665>, 2,
		<295, 1665, 3977>, 2,
		<295, 3977, 1375>, 2,
		<295, 1375, 3449>, 2,
		<295, 3449, 2312>, 2,
		<295, 2312, 3087>, 2,
		<295, 3087, 2311>, 2,
		<296, 2312, 3449>, 2,
		<296, 3449, 1374>, 2,
		<296, 1374, 3979>, 2,
		<296, 3979, 1667>, 2,
		<296, 1667, 3595>, 2,
		<296, 3595, 2313>, 2,
		<296, 2313, 3087>, 2,
		<296, 3087, 2312>, 2,
		<297, 2313, 3595>, 2,
		<297, 3595, 1666>, 2,
		<297, 1666, 3981>, 2,
		<297, 3981, 1378>, 2,
		<297, 1378, 3451>, 2,
		<297, 3451, 2310>, 2,
		<297, 2310, 3087>, 2,
		<297, 3087, 2313>, 2,
		<298, 2314, 3453>, 2,
		<298, 3453, 1383>, 2,
		<298, 1383, 3982>, 2,
		<298, 3982, 1668>, 2,
		<298, 1668, 3596>, 2,
		<298, 3596, 2315>, 2,
		<298, 2315, 3088>, 2,
		<298, 3088, 2314>, 2,
		<299, 2315, 3596>, 2,
		<299, 3596, 1669>, 2,
		<299, 1669, 3980>, 2,
		<299, 3980, 1379>, 2,
		<299, 1379, 3451>, 2,
		<299, 3451, 2316>, 2,
		<299, 2316, 3088>, 2,
		<299, 3088, 2315>, 2,
		<300, 2316, 3451>, 2,
		<300, 3451, 1378>, 2,
		<300, 1378, 3981>, 2,
		<300, 3981, 1671>, 2,
		<300, 1671, 3597>, 2,
		<300, 3597, 2317>, 2,
		<300, 2317, 3088>, 2,
		<300, 3088, 2316>, 2,
		<301, 2317, 3597>, 2,
		<301, 3597, 1670>, 2,
		<301, 1670, 3983>, 2,
		<301, 3983, 1382>, 2,
		<301, 1382, 3453>, 2,
		<301, 3453, 2314>, 2,
		<301, 2314, 3088>, 2,
		<301, 3088, 2317>, 2,
		<302, 2318, 3598>, 2,
		<302, 3598, 1673>, 2,
		<302, 1673, 3985>, 2,
		<302, 3985, 1674>, 2,
		<302, 1674, 3599>, 2,
		<302, 3599, 2319>, 2,
		<302, 2319, 3089>, 2,
		<302, 3089, 2318>, 2,
		<303, 2319, 3599>, 2,
		<303, 3599, 1675>, 2,
		<303, 1675, 3982>, 2,
		<303, 3982, 1383>, 2,
		<303, 1383, 3453>, 2,
		<303, 3453, 2320>, 2,
		<303, 2320, 3089>, 2,
		<303, 3089, 2319>, 2,
		<304, 2320, 3453>, 2,
		<304, 3453, 1382>, 2,
		<304, 1382, 3983>, 2,
		<304, 3983, 1677>, 2,
		<304, 1677, 3600>, 2,
		<304, 3600, 2321>, 2,
		<304, 2321, 3089>, 2,
		<304, 3089, 2320>, 2,
		<305, 2321, 3600>, 2,
		<305, 3600, 1676>, 2,
		<305, 1676, 3984>, 2,
		<305, 3984, 1672>, 2,
		<305, 1672, 3598>, 2,
		<305, 3598, 2318>, 2,
		<305, 2318, 3089>, 2,
		<305, 3089, 2321>, 2,
		<306, 2322, 3737>, 1,
		<306, 3737, 1951>, 1,
		<306, 1951, 4015>, 1,
		<306, 4015, 1392>, 1,
		<306, 1392, 3458>, 1,
		<306, 3458, 2323>, 1,
		<306, 2323, 3090>, 1,
		<306, 3090, 2322>, 1,
		<307, 2323, 3458>, 1,
		<307, 3458, 1393>, 1,
		<307, 1393, 3940>, 1,
		<307, 3940, 1387>, 1,
		<307, 1387, 3455>, 1,
		<307, 3455, 2324>, 1,
		<307, 2324, 3090>, 1,
		<307, 3090, 2323>, 1,
		<308, 2324, 3455>, 1,
		<308, 3455, 1386>, 1,
		<308, 1386, 3939>, 1,
		<308, 3939, 1347>, 1,
		<308, 1347, 3435>, 1,
		<308, 3435, 2325>, 1,
		<308, 2325, 3090>, 1,
		<308, 3090, 2324>, 1,
		<309, 2325, 3435>, 1,
		<309, 3435, 1346>, 1,
		<309, 1346, 4013>, 1,
		<309, 4013, 1950>, 1,
		<309, 1950, 3737>, 1,
		<309, 3737, 2322>, 1,
		<309, 2322, 3090>, 1,
		<309, 3090, 2325>, 1,
		<310, 2326, 3758>, 1,
		<310, 3758, 1993>, 1,
		<310, 1993, 4016>, 1,
		<310, 4016, 1396>, 1,
		<310, 1396, 3460>, 1,
		<310, 3460, 2327>, 1,
		<310, 2327, 3091>, 1,
		<310, 3091, 2326>, 1,
		<311, 2327, 3460>, 1,
		<311, 3460, 1397>, 1,
		<311, 1397, 3821>, 1,
		<311, 3821, 1398>, 1,
		<311, 1398, 3461>, 1,
		<311, 3461, 2328>, 1,
		<311, 2328, 3091>, 1,
		<311, 3091, 2327>, 1,
		<312, 2328, 3461>, 1,
		<312, 3461, 1399>, 1,
		<312, 1399, 3820>, 1,
		<312, 3820, 1351>, 1,
		<312, 1351, 3437>, 1,
		<312, 3437, 2329>, 1,
		<312, 2329, 3091>, 1,
		<312, 3091, 2328>, 1,
		<313, 2329, 3437>, 1,
		<313, 3437, 1350>, 1,
		<313, 1350, 4014>, 1,
		<313, 4014, 1992>, 1,
		<313, 1992, 3758>, 1,
		<313, 3758, 2326>, 1,
		<313, 2326, 3091>, 1,
		<313, 3091, 2329>, 1,
		<314, 2330, 3462>, 1,
		<314, 3462, 1401>, 1,
		<314, 1401, 3845>, 1,
		<314, 3845, 1402>, 1,
		<314, 1402, 3463>, 1,
		<314, 3463, 2331>, 1,
		<314, 2331, 3092>, 1,
		<314, 3092, 2330>, 1,
		<315, 2331, 3463>, 1,
		<315, 3463, 1403>, 1,
		<315, 1403, 3833>, 1,
		<315, 3833, 1395>, 1,
		<315, 1395, 3459>, 1,
		<315, 3459, 2332>, 1,
		<315, 2332, 3092>, 1,
		<315, 3092, 2331>, 1,
		<316, 2332, 3459>, 1,
		<316, 3459, 1394>, 1,
		<316, 1394, 3832>, 1,
		<316, 3832, 1357>, 1,
		<316, 1357, 3440>, 1,
		<316, 3440, 2333>, 1,
		<316, 2333, 3092>, 1,
		<316, 3092, 2332>, 1,
		<317, 2333, 3440>, 1,
		<317, 3440, 1356>, 1,
		<317, 1356, 3844>, 1,
		<317, 3844, 1400>, 1,
		<317, 1400, 3462>, 1,
		<317, 3462, 2330>, 1,
		<317, 2330, 3092>, 1,
		<317, 3092, 2333>, 1,
		<318, 2334, 3464>, 1,
		<318, 3464, 1405>, 1,
		<318, 1405, 3857>, 1,
		<318, 3857, 1406>, 1,
		<318, 1406, 3465>, 1,
		<318, 3465, 2335>, 1,
		<318, 2335, 3093>, 1,
		<318, 3093, 2334>, 1,
		<319, 2335, 3465>, 1,
		<319, 3465, 1407>, 1,
		<319, 1407, 3845>, 1,
		<319, 3845, 1401>, 1,
		<319, 1401, 3462>, 1,
		<319, 3462, 2336>, 1,
		<319, 2336, 3093>, 1,
		<319, 3093, 2335>, 1,
		<320, 2336, 3462>, 1,
		<320, 3462, 1400>, 1,
		<320, 1400, 3844>, 1,
		<320, 3844, 1361>, 1,
		<320, 1361, 3442>, 1,
		<320, 3442, 2337>, 1,
		<320, 2337, 3093>, 1,
		<320, 3093, 2336>, 1,
		<321, 2337, 3442>, 1,
		<321, 3442, 1360>, 1,
		<321, 1360, 3856>, 1,
		<321, 3856, 1404>, 1,
		<321, 1404, 3464>, 1,
		<321, 3464, 2334>, 1,
		<321, 2334, 3093>, 1,
		<321, 3093, 2337>, 1,
		<322, 2338, 3466>, 1,
		<322, 3466, 1409>, 1,
		<322, 1409, 3869>, 1,
		<322, 3869, 1410>, 1,
		<322, 1410, 3467>, 1,
		<322, 3467, 2339>, 1,
		<322, 2339, 3094>, 1,
		<322, 3094, 2338>, 1,
		<323, 2339, 3467>, 1,
		<323, 3467, 1411>, 1,
		<323, 1411, 3857>, 1,
		<323, 3857, 1405>, 1,
		<323, 1405, 3464>, 1,
		<323, 3464, 2340>, 1,
		<323, 2340, 3094>, 1,
		<323, 3094, 2339>, 1,
		<324, 2340, 3464>, 1,
		<324, 3464, 1404>, 1,
		<324, 1404, 3856>, 1,
		<324, 3856, 1365>, 1,
		<324, 1365, 3444>, 1,
		<324, 3444, 2341>, 1,
		<324, 2341, 3094>, 1,
		<324, 3094, 2340>, 1,
		<325, 2341, 3444>, 1,
		<325, 3444, 1364>, 1,
		<325, 1364, 3868>, 1,
		<325, 3868, 1408>, 1,
		<325, 1408, 3466>, 1,
		<325, 3466, 2338>, 1,
		<325, 2338, 3094>, 1,
		<325, 3094, 2341>, 1,
		<326, 2342, 3468>, 1,
		<326, 3468, 1412>, 1,
		<326, 1412, 3881>, 1,
		<326, 3881, 1414>, 1,
		<326, 1414, 3469>, 1,
		<326, 3469, 2343>, 1,
		<326, 2343, 3095>, 1,
		<326, 3095, 2342>, 1,
		<327, 2343, 3469>, 1,
		<327, 3469, 1415>, 1,
		<327, 1415, 3869>, 1,
		<327, 3869, 1409>, 1,
		<327, 1409, 3466>, 1,
		<327, 3466, 2344>, 1,
		<327, 2344, 3095>, 1,
		<327, 3095, 2343>, 1,
		<328, 2344, 3466>, 1,
		<328, 3466, 1408>, 1,
		<328, 1408, 3868>, 1,
		<328, 3868, 1369>, 1,
		<328, 1369, 3446>, 1,
		<328, 3446, 2345>, 1,
		<328, 2345, 3095>, 1,
		<328, 3095, 2344>, 1,
		<329, 2345, 3446>, 1,
		<329, 3446, 1368>, 1,
		<329, 1368, 3880>, 1,
		<329, 3880, 1413>, 1,
		<329, 1413, 3468>, 1,
		<329, 3468, 2342>, 1,
		<329, 2342, 3095>, 1,
		<329, 3095, 2345>, 1,
		<330, 2346, 3601>, 2,
		<330, 3601, 1679>, 2,
		<330, 1679, 3986>, 2,
		<330, 3986, 1418>, 2,
		<330, 1418, 3471>, 2,
		<330, 3471, 2347>, 2,
		<330, 2347, 3096>, 2,
		<330, 3096, 2346>, 2,
		<331, 2347, 3471>, 2,
		<331, 3471, 1419>, 2,
		<331, 1419, 3987>, 2,
		<331, 3987, 1681>, 2,
		<331, 1681, 3602>, 2,
		<331, 3602, 2348>, 2,
		<331, 2348, 3096>, 2,
		<331, 3096, 2347>, 2,
		<332, 2348, 3602>, 2,
		<332, 3602, 1680>, 2,
		<332, 1680, 3976>, 2,
		<332, 3976, 1373>, 2,
		<332, 1373, 3448>, 2,
		<332, 3448, 2349>, 2,
		<332, 2349, 3096>, 2,
		<332, 3096, 2348>, 2,
		<333, 2349, 3448>, 2,
		<333, 3448, 1372>, 2,
		<333, 1372, 3978>, 2,
		<333, 3978, 1678>, 2,
		<333, 1678, 3601>, 2,
		<333, 3601, 2346>, 2,
		<333, 2346, 3096>, 2,
		<333, 3096, 2349>, 2,
		<334, 2350, 3472>, 1,
		<334, 3472, 1421>, 1,
		<334, 1421, 3905>, 1,
		<334, 3905, 1422>, 1,
		<334, 1422, 3473>, 1,
		<334, 3473, 2351>, 1,
		<334, 2351, 3097>, 1,
		<334, 3097, 2350>, 1,
		<335, 2351, 3473>, 1,
		<335, 3473, 1423>, 1,
		<335, 1423, 3893>, 1,
		<335, 3893, 1417>, 1,
		<335, 1417, 3470>, 1,
		<335, 3470, 2352>, 1,
		<335, 2352, 3097>, 1,
		<335, 3097, 2351>, 1,
		<336, 2352, 3470>, 1,
		<336, 3470, 1416>, 1,
		<336, 1416, 3892>, 1,
		<336, 3892, 1377>, 1,
		<336, 1377, 3450>, 1,
		<336, 3450, 2353>, 1,
		<336, 2353, 3097>, 1,
		<336, 3097, 2352>, 1,
		<337, 2353, 3450>, 1,
		<337, 3450, 1376>, 1,
		<337, 1376, 3904>, 1,
		<337, 3904, 1420>, 1,
		<337, 1420, 3472>, 1,
		<337, 3472, 2350>, 1,
		<337, 2350, 3097>, 1,
		<337, 3097, 2353>, 1,
		<338, 2354, 3474>, 1,
		<338, 3474, 1425>, 1,
		<338, 1425, 3917>, 1,
		<338, 3917, 1426>, 1,
		<338, 1426, 3475>, 1,
		<338, 3475, 2355>, 1,
		<338, 2355, 3098>, 1,
		<338, 3098, 2354>, 1,
		<339, 2355, 3475>, 1,
		<339, 3475, 1427>, 1,
		<339, 1427, 3905>, 1,
		<339, 3905, 1421>, 1,
		<339, 1421, 3472>, 1,
		<339, 3472, 2356>, 1,
		<339, 2356, 3098>, 1,
		<339, 3098, 2355>, 1,
		<340, 2356, 3472>, 1,
		<340, 3472, 1420>, 1,
		<340, 1420, 3904>, 1,
		<340, 3904, 1381>, 1,
		<340, 1381, 3452>, 1,
		<340, 3452, 2357>, 1,
		<340, 2357, 3098>, 1,
		<340, 3098, 2356>, 1,
		<341, 2357, 3452>, 1,
		<341, 3452, 1380>, 1,
		<341, 1380, 3916>, 1,
		<341, 3916, 1424>, 1,
		<341, 1424, 3474>, 1,
		<341, 3474, 2354>, 1,
		<341, 2354, 3098>, 1,
		<341, 3098, 2357>, 1,
		<342, 2358, 3476>, 1,
		<342, 3476, 1429>, 1,
		<342, 1429, 3929>, 1,
		<342, 3929, 1430>, 1,
		<342, 1430, 3477>, 1,
		<342, 3477, 2359>, 1,
		<342, 2359, 3099>, 1,
		<342, 3099, 2358>, 1,
		<343, 2359, 3477>, 1,
		<343, 3477, 1431>, 1,
		<343, 1431, 3917>, 1,
		<343, 3917, 1425>, 1,
		<343, 1425, 3474>, 1,
		<343, 3474, 2360>, 1,
		<343, 2360, 3099>, 1,
		<343, 3099, 2359>, 1,
		<344, 2360, 3474>, 1,
		<344, 3474, 1424>, 1,
		<344, 1424, 3916>, 1,
		<344, 3916, 1385>, 1,
		<344, 1385, 3454>, 1,
		<344, 3454, 2361>, 1,
		<344, 2361, 3099>, 1,
		<344, 3099, 2360>, 1,
		<345, 2361, 3454>, 1,
		<345, 3454, 1384>, 1,
		<345, 1384, 3928>, 1,
		<345, 3928, 1428>, 1,
		<345, 1428, 3476>, 1,
		<345, 3476, 2358>, 1,
		<345, 2358, 3099>, 1,
		<345, 3099, 2361>, 1,
		<346, 2362, 3478>, 1,
		<346, 3478, 1433>, 1,
		<346, 1433, 3941>, 1,
		<346, 3941, 1434>, 1,
		<346, 1434, 3479>, 1,
		<346, 3479, 2363>, 1,
		<346, 2363, 3100>, 1,
		<346, 3100, 2362>, 1,
		<347, 2363, 3479>, 1,
		<347, 3479, 1435>, 1,
		<347, 1435, 3929>, 1,
		<347, 3929, 1429>, 1,
		<347, 1429, 3476>, 1,
		<347, 3476, 2364>, 1,
		<347, 2364, 3100>, 1,
		<347, 3100, 2363>, 1,
		<348, 2364, 3476>, 1,
		<348, 3476, 1428>, 1,
		<348, 1428, 3928>, 1,
		<348, 3928, 1389>, 1,
		<348, 1389, 3456>, 1,
		<348, 3456, 2365>, 1,
		<348, 2365, 3100>, 1,
		<348, 3100, 2364>, 1,
		<349, 2365, 3456>, 1,
		<349, 3456, 1388>, 1,
		<349, 1388, 3940>, 1,
		<349, 3940, 1432>, 1,
		<349, 1432, 3478>, 1,
		<349, 3478, 2362>, 1,
		<349, 2362, 3100>, 1,
		<349, 3100, 2365>, 1,
		<350, 2366, 3736>, 1,
		<350, 3736, 1949>, 1,
		<350, 1949, 4017>, 1,
		<350, 4017, 1438>, 1,
		<350, 1438, 3481>, 1,
		<350, 3481, 2367>, 1,
		<350, 2367, 3101>, 1,
		<350, 3101, 2366>, 1,
		<351, 2367, 3481>, 1,
		<351, 3481, 1439>, 1,
		<351, 1439, 3941>, 1,
		<351, 3941, 1433>, 1,
		<351, 1433, 3478>, 1,
		<351, 3478, 2368>, 1,
		<351, 2368, 3101>, 1,
		<351, 3101, 2367>, 1,
		<352, 2368, 3478>, 1,
		<352, 3478, 1432>, 1,
		<352, 1432, 3940>, 1,
		<352, 3940, 1393>, 1,
		<352, 1393, 3458>, 1,
		<352, 3458, 2369>, 1,
		<352, 2369, 3101>, 1,
		<352, 3101, 2368>, 1,
		<353, 2369, 3458>, 1,
		<353, 3458, 1392>, 1,
		<353, 1392, 4015>, 1,
		<353, 4015, 1948>, 1,
		<353, 1948, 3736>, 1,
		<353, 3736, 2366>, 1,
		<353, 2366, 3101>, 1,
		<353, 3101, 2369>, 1,
		<354, 2370, 3759>, 1,
		<354, 3759, 1995>, 1,
		<354, 1995, 4018>, 1,
		<354, 4018, 1442>, 1,
		<354, 1442, 3483>, 1,
		<354, 3483, 2371>, 1,
		<354, 2371, 3102>, 1,
		<354, 3102, 2370>, 1,
		<355, 2371, 3483>, 1,
		<355, 3483, 1443>, 1,
		<355, 1443, 3822>, 1,
		<355, 3822, 1444>, 1,
		<355, 1444, 3484>, 1,
		<355, 3484, 2372>, 1,
		<355, 2372, 3102>, 1,
		<355, 3102, 2371>, 1,
		<356, 2372, 3484>, 1,
		<356, 3484, 1445>, 1,
		<356, 1445, 3821>, 1,
		<356, 3821, 1397>, 1,
		<356, 1397, 3460>, 1,
		<356, 3460, 2373>, 1,
		<356, 2373, 3102>, 1,
		<356, 3102, 2372>, 1,
		<357, 2373, 3460>, 1,
		<357, 3460, 1396>, 1,
		<357, 1396, 4016>, 1,
		<357, 4016, 1994>, 1,
		<357, 1994, 3759>, 1,
		<357, 3759, 2370>, 1,
		<357, 2370, 3102>, 1,
		<357, 3102, 2373>, 1,
		<358, 2374, 3485>, 1,
		<358, 3485, 1447>, 1,
		<358, 1447, 3846>, 1,
		<358, 3846, 1448>, 1,
		<358, 1448, 3486>, 1,
		<358, 3486, 2375>, 1,
		<358, 2375, 3103>, 1,
		<358, 3103, 2374>, 1,
		<359, 2375, 3486>, 1,
		<359, 3486, 1449>, 1,
		<359, 1449, 3834>, 1,
		<359, 3834, 1441>, 1,
		<359, 1441, 3482>, 1,
		<359, 3482, 2376>, 1,
		<359, 2376, 3103>, 1,
		<359, 3103, 2375>, 1,
		<360, 2376, 3482>, 1,
		<360, 3482, 1440>, 1,
		<360, 1440, 3833>, 1,
		<360, 3833, 1403>, 1,
		<360, 1403, 3463>, 1,
		<360, 3463, 2377>, 1,
		<360, 2377, 3103>, 1,
		<360, 3103, 2376>, 1,
		<361, 2377, 3463>, 1,
		<361, 3463, 1402>, 1,
		<361, 1402, 3845>, 1,
		<361, 3845, 1446>, 1,
		<361, 1446, 3485>, 1,
		<361, 3485, 2374>, 1,
		<361, 2374, 3103>, 1,
		<361, 3103, 2377>, 1,
		<362, 2378, 3487>, 1,
		<362, 3487, 1451>, 1,
		<362, 1451, 3858>, 1,
		<362, 3858, 1452>, 1,
		<362, 1452, 3488>, 1,
		<362, 3488, 2379>, 1,
		<362, 2379, 3104>, 1,
		<362, 3104, 2378>, 1,
		<363, 2379, 3488>, 1,
		<363, 3488, 1453>, 1,
		<363, 1453, 3846>, 1,
		<363, 3846, 1447>, 1,
		<363, 1447, 3485>, 1,
		<363, 3485, 2380>, 1,
		<363, 2380, 3104>, 1,
		<363, 3104, 2379>, 1,
		<364, 2380, 3485>, 1,
		<364, 3485, 1446>, 1,
		<364, 1446, 3845>, 1,
		<364, 3845, 1407>, 1,
		<364, 1407, 3465>, 1,
		<364, 3465, 2381>, 1,
		<364, 2381, 3104>, 1,
		<364, 3104, 2380>, 1,
		<365, 2381, 3465>, 1,
		<365, 3465, 1406>, 1,
		<365, 1406, 3857>, 1,
		<365, 3857, 1450>, 1,
		<365, 1450, 3487>, 1,
		<365, 3487, 2378>, 1,
		<365, 2378, 3104>, 1,
		<365, 3104, 2381>, 1,
		<366, 2382, 3489>, 1,
		<366, 3489, 1455>, 1,
		<366, 1455, 3870>, 1,
		<366, 3870, 1456>, 1,
		<366, 1456, 3490>, 1,
		<366, 3490, 2383>, 1,
		<366, 2383, 3105>, 1,
		<366, 3105, 2382>, 1,
		<367, 2383, 3490>, 1,
		<367, 3490, 1457>, 1,
		<367, 1457, 3858>, 1,
		<367, 3858, 1451>, 1,
		<367, 1451, 3487>, 1,
		<367, 3487, 2384>, 1,
		<367, 2384, 3105>, 1,
		<367, 3105, 2383>, 1,
		<368, 2384, 3487>, 1,
		<368, 3487, 1450>, 1,
		<368, 1450, 3857>, 1,
		<368, 3857, 1411>, 1,
		<368, 1411, 3467>, 1,
		<368, 3467, 2385>, 1,
		<368, 2385, 3105>, 1,
		<368, 3105, 2384>, 1,
		<369, 2385, 3467>, 1,
		<369, 3467, 1410>, 1,
		<369, 1410, 3869>, 1,
		<369, 3869, 1454>, 1,
		<369, 1454, 3489>, 1,
		<369, 3489, 2382>, 1,
		<369, 2382, 3105>, 1,
		<369, 3105, 2385>, 1,
		<370, 2386, 3491>, 1,
		<370, 3491, 1458>, 1,
		<370, 1458, 3882>, 1,
		<370, 3882, 1460>, 1,
		<370, 1460, 3492>, 1,
		<370, 3492, 2387>, 1,
		<370, 2387, 3106>, 1,
		<370, 3106, 2386>, 1,
		<371, 2387, 3492>, 1,
		<371, 3492, 1461>, 1,
		<371, 1461, 3870>, 1,
		<371, 3870, 1455>, 1,
		<371, 1455, 3489>, 1,
		<371, 3489, 2388>, 1,
		<371, 2388, 3106>, 1,
		<371, 3106, 2387>, 1,
		<372, 2388, 3489>, 1,
		<372, 3489, 1454>, 1,
		<372, 1454, 3869>, 1,
		<372, 3869, 1415>, 1,
		<372, 1415, 3469>, 1,
		<372, 3469, 2389>, 1,
		<372, 2389, 3106>, 1,
		<372, 3106, 2388>, 1,
		<373, 2389, 3469>, 1,
		<373, 3469, 1414>, 1,
		<373, 1414, 3881>, 1,
		<373, 3881, 1459>, 1,
		<373, 1459, 3491>, 1,
		<373, 3491, 2386>, 1,
		<373, 2386, 3106>, 1,
		<373, 3106, 2389>, 1,
		<374, 2390, 3603>, 2,
		<374, 3603, 1683>, 2,
		<374, 1683, 3988>, 2,
		<374, 3988, 1464>, 2,
		<374, 1464, 3494>, 2,
		<374, 3494, 2391>, 2,
		<374, 2391, 3107>, 2,
		<374, 3107, 2390>, 2,
		<375, 2391, 3494>, 2,
		<375, 3494, 1465>, 2,
		<375, 1465, 3989>, 2,
		<375, 3989, 1685>, 2,
		<375, 1685, 3604>, 2,
		<375, 3604, 2392>, 2,
		<375, 2392, 3107>, 2,
		<375, 3107, 2391>, 2,
		<376, 2392, 3604>, 2,
		<376, 3604, 1684>, 2,
		<376, 1684, 3987>, 2,
		<376, 3987, 1419>, 2,
		<376, 1419, 3471>, 2,
		<376, 3471, 2393>, 2,
		<376, 2393, 3107>, 2,
		<376, 3107, 2392>, 2,
		<377, 2393, 3471>, 2,
		<377, 3471, 1418>, 2,
		<377, 1418, 3986>, 2,
		<377, 3986, 1682>, 2,
		<377, 1682, 3603>, 2,
		<377, 3603, 2390>, 2,
		<377, 2390, 3107>, 2,
		<377, 3107, 2393>, 2,
		<378, 2394, 3495>, 1,
		<378, 3495, 1467>, 1,
		<378, 1467, 3906>, 1,
		<378, 3906, 1468>, 1,
		<378, 1468, 3496>, 1,
		<378, 3496, 2395>, 1,
		<378, 2395, 3108>, 1,
		<378, 3108, 2394>, 1,
		<379, 2395, 3496>, 1,
		<379, 3496, 1469>, 1,
		<379, 1469, 3894>, 1,
		<379, 3894, 1463>, 1,
		<379, 1463, 3493>, 1,
		<379, 3493, 2396>, 1,
		<379, 2396, 3108>, 1,
		<379, 3108, 2395>, 1,
		<380, 2396, 3493>, 1,
		<380, 3493, 1462>, 1,
		<380, 1462, 3893>, 1,
		<380, 3893, 1423>, 1,
		<380, 1423, 3473>, 1,
		<380, 3473, 2397>, 1,
		<380, 2397, 3108>, 1,
		<380, 3108, 2396>, 1,
		<381, 2397, 3473>, 1,
		<381, 3473, 1422>, 1,
		<381, 1422, 3905>, 1,
		<381, 3905, 1466>, 1,
		<381, 1466, 3495>, 1,
		<381, 3495, 2394>, 1,
		<381, 2394, 3108>, 1,
		<381, 3108, 2397>, 1,
		<382, 2398, 3497>, 1,
		<382, 3497, 1471>, 1,
		<382, 1471, 3918>, 1,
		<382, 3918, 1472>, 1,
		<382, 1472, 3498>, 1,
		<382, 3498, 2399>, 1,
		<382, 2399, 3109>, 1,
		<382, 3109, 2398>, 1,
		<383, 2399, 3498>, 1,
		<383, 3498, 1473>, 1,
		<383, 1473, 3906>, 1,
		<383, 3906, 1467>, 1,
		<383, 1467, 3495>, 1,
		<383, 3495, 2400>, 1,
		<383, 2400, 3109>, 1,
		<383, 3109, 2399>, 1,
		<384, 2400, 3495>, 1,
		<384, 3495, 1466>, 1,
		<384, 1466, 3905>, 1,
		<384, 3905, 1427>, 1,
		<384, 1427, 3475>, 1,
		<384, 3475, 2401>, 1,
		<384, 2401, 3109>, 1,
		<384, 3109, 2400>, 1,
		<385, 2401, 3475>, 1,
		<385, 3475, 1426>, 1,
		<385, 1426, 3917>, 1,
		<385, 3917, 1470>, 1,
		<385, 1470, 3497>, 1,
		<385, 3497, 2398>, 1,
		<385, 2398, 3109>, 1,
		<385, 3109, 2401>, 1,
		<386, 2402, 3499>, 1,
		<386, 3499, 1475>, 1,
		<386, 1475, 3930>, 1,
		<386, 3930, 1476>, 1,
		<386, 1476, 3500>, 1,
		<386, 3500, 2403>, 1,
		<386, 2403, 3110>, 1,
		<386, 3110, 2402>, 1,
		<387, 2403, 3500>, 1,
		<387, 3500, 1477>, 1,
		<387, 1477, 3918>, 1,
		<387, 3918, 1471>, 1,
		<387, 1471, 3497>, 1,
		<387, 3497, 2404>, 1,
		<387, 2404, 3110>, 1,
		<387, 3110, 2403>, 1,
		<388, 2404, 3497>, 1,
		<388, 3497, 1470>, 1,
		<388, 1470, 3917>, 1,
		<388, 3917, 1431>, 1,
		<388, 1431, 3477>, 1,
		<388, 3477, 2405>, 1,
		<388, 2405, 3110>, 1,
		<388, 3110, 2404>, 1,
		<389, 2405, 3477>, 1,
		<389, 3477, 1430>, 1,
		<389, 1430, 3929>, 1,
		<389, 3929, 1474>, 1,
		<389, 1474, 3499>, 1,
		<389, 3499, 2402>, 1,
		<389, 2402, 3110>, 1,
		<389, 3110, 2405>, 1,
		<390, 2406, 3501>, 1,
		<390, 3501, 1479>, 1,
		<390, 1479, 3942>, 1,
		<390, 3942, 1480>, 1,
		<390, 1480, 3502>, 1,
		<390, 3502, 2407>, 1,
		<390, 2407, 3111>, 1,
		<390, 3111, 2406>, 1,
		<391, 2407, 3502>, 1,
		<391, 3502, 1481>, 1,
		<391, 1481, 3930>, 1,
		<391, 3930, 1475>, 1,
		<391, 1475, 3499>, 1,
		<391, 3499, 2408>, 1,
		<391, 2408, 3111>, 1,
		<391, 3111, 2407>, 1,
		<392, 2408, 3499>, 1,
		<392, 3499, 1474>, 1,
		<392, 1474, 3929>, 1,
		<392, 3929, 1435>, 1,
		<392, 1435, 3479>, 1,
		<392, 3479, 2409>, 1,
		<392, 2409, 3111>, 1,
		<392, 3111, 2408>, 1,
		<393, 2409, 3479>, 1,
		<393, 3479, 1434>, 1,
		<393, 1434, 3941>, 1,
		<393, 3941, 1478>, 1,
		<393, 1478, 3501>, 1,
		<393, 3501, 2406>, 1,
		<393, 2406, 3111>, 1,
		<393, 3111, 2409>, 1,
		<394, 2410, 3735>, 1,
		<394, 3735, 1947>, 1,
		<394, 1947, 4019>, 1,
		<394, 4019, 1484>, 1,
		<394, 1484, 3504>, 1,
		<394, 3504, 2411>, 1,
		<394, 2411, 3112>, 1,
		<394, 3112, 2410>, 1,
		<395, 2411, 3504>, 1,
		<395, 3504, 1485>, 1,
		<395, 1485, 3942>, 1,
		<395, 3942, 1479>, 1,
		<395, 1479, 3501>, 1,
		<395, 3501, 2412>, 1,
		<395, 2412, 3112>, 1,
		<395, 3112, 2411>, 1,
		<396, 2412, 3501>, 1,
		<396, 3501, 1478>, 1,
		<396, 1478, 3941>, 1,
		<396, 3941, 1439>, 1,
		<396, 1439, 3481>, 1,
		<396, 3481, 2413>, 1,
		<396, 2413, 3112>, 1,
		<396, 3112, 2412>, 1,
		<397, 2413, 3481>, 1,
		<397, 3481, 1438>, 1,
		<397, 1438, 4017>, 1,
		<397, 4017, 1946>, 1,
		<397, 1946, 3735>, 1,
		<397, 3735, 2410>, 1,
		<397, 2410, 3112>, 1,
		<397, 3112, 2413>, 1,
		<398, 2414, 3760>, 1,
		<398, 3760, 1997>, 1,
		<398, 1997, 4020>, 1,
		<398, 4020, 1488>, 1,
		<398, 1488, 3506>, 1,
		<398, 3506, 2415>, 1,
		<398, 2415, 3113>, 1,
		<398, 3113, 2414>, 1,
		<399, 2415, 3506>, 1,
		<399, 3506, 1489>, 1,
		<399, 1489, 3823>, 1,
		<399, 3823, 1490>, 1,
		<399, 1490, 3507>, 1,
		<399, 3507, 2416>, 1,
		<399, 2416, 3113>, 1,
		<399, 3113, 2415>, 1,
		<400, 2416, 3507>, 1,
		<400, 3507, 1491>, 1,
		<400, 1491, 3822>, 1,
		<400, 3822, 1443>, 1,
		<400, 1443, 3483>, 1,
		<400, 3483, 2417>, 1,
		<400, 2417, 3113>, 1,
		<400, 3113, 2416>, 1,
		<401, 2417, 3483>, 1,
		<401, 3483, 1442>, 1,
		<401, 1442, 4018>, 1,
		<401, 4018, 1996>, 1,
		<401, 1996, 3760>, 1,
		<401, 3760, 2414>, 1,
		<401, 2414, 3113>, 1,
		<401, 3113, 2417>, 1,
		<402, 2418, 3508>, 1,
		<402, 3508, 1493>, 1,
		<402, 1493, 3847>, 1,
		<402, 3847, 1494>, 1,
		<402, 1494, 3509>, 1,
		<402, 3509, 2419>, 1,
		<402, 2419, 3114>, 1,
		<402, 3114, 2418>, 1,
		<403, 2419, 3509>, 1,
		<403, 3509, 1495>, 1,
		<403, 1495, 3835>, 1,
		<403, 3835, 1487>, 1,
		<403, 1487, 3505>, 1,
		<403, 3505, 2420>, 1,
		<403, 2420, 3114>, 1,
		<403, 3114, 2419>, 1,
		<404, 2420, 3505>, 1,
		<404, 3505, 1486>, 1,
		<404, 1486, 3834>, 1,
		<404, 3834, 1449>, 1,
		<404, 1449, 3486>, 1,
		<404, 3486, 2421>, 1,
		<404, 2421, 3114>, 1,
		<404, 3114, 2420>, 1,
		<405, 2421, 3486>, 1,
		<405, 3486, 1448>, 1,
		<405, 1448, 3846>, 1,
		<405, 3846, 1492>, 1,
		<405, 1492, 3508>, 1,
		<405, 3508, 2418>, 1,
		<405, 2418, 3114>, 1,
		<405, 3114, 2421>, 1,
		<406, 2422, 3510>, 1,
		<406, 3510, 1497>, 1,
		<406, 1497, 3859>, 1,
		<406, 3859, 1498>, 1,
		<406, 1498, 3511>, 1,
		<406, 3511, 2423>, 1,
		<406, 2423, 3115>, 1,
		<406, 3115, 2422>, 1,
		<407, 2423, 3511>, 1,
		<407, 3511, 1499>, 1,
		<407, 1499, 3847>, 1,
		<407, 3847, 1493>, 1,
		<407, 1493, 3508>, 1,
		<407, 3508, 2424>, 1,
		<407, 2424, 3115>, 1,
		<407, 3115, 2423>, 1,
		<408, 2424, 3508>, 1,
		<408, 3508, 1492>, 1,
		<408, 1492, 3846>, 1,
		<408, 3846, 1453>, 1,
		<408, 1453, 3488>, 1,
		<408, 3488, 2425>, 1,
		<408, 2425, 3115>, 1,
		<408, 3115, 2424>, 1,
		<409, 2425, 3488>, 1,
		<409, 3488, 1452>, 1,
		<409, 1452, 3858>, 1,
		<409, 3858, 1496>, 1,
		<409, 1496, 3510>, 1,
		<409, 3510, 2422>, 1,
		<409, 2422, 3115>, 1,
		<409, 3115, 2425>, 1,
		<410, 2426, 3512>, 1,
		<410, 3512, 1501>, 1,
		<410, 1501, 3871>, 1,
		<410, 3871, 1502>, 1,
		<410, 1502, 3513>, 1,
		<410, 3513, 2427>, 1,
		<410, 2427, 3116>, 1,
		<410, 3116, 2426>, 1,
		<411, 2427, 3513>, 1,
		<411, 3513, 1503>, 1,
		<411, 1503, 3859>, 1,
		<411, 3859, 1497>, 1,
		<411, 1497, 3510>, 1,
		<411, 3510, 2428>, 1,
		<411, 2428, 3116>, 1,
		<411, 3116, 2427>, 1,
		<412, 2428, 3510>, 1,
		<412, 3510, 1496>, 1,
		<412, 1496, 3858>, 1,
		<412, 3858, 1457>, 1,
		<412, 1457, 3490>, 1,
		<412, 3490, 2429>, 1,
		<412, 2429, 3116>, 1,
		<412, 3116, 2428>, 1,
		<413, 2429, 3490>, 1,
		<413, 3490, 1456>, 1,
		<413, 1456, 3870>, 1,
		<413, 3870, 1500>, 1,
		<413, 1500, 3512>, 1,
		<413, 3512, 2426>, 1,
		<413, 2426, 3116>, 1,
		<413, 3116, 2429>, 1,
		<414, 2430, 3514>, 1,
		<414, 3514, 1504>, 1,
		<414, 1504, 3883>, 1,
		<414, 3883, 1506>, 1,
		<414, 1506, 3515>, 1,
		<414, 3515, 2431>, 1,
		<414, 2431, 3117>, 1,
		<414, 3117, 2430>, 1,
		<415, 2431, 3515>, 1,
		<415, 3515, 1507>, 1,
		<415, 1507, 3871>, 1,
		<415, 3871, 1501>, 1,
		<415, 1501, 3512>, 1,
		<415, 3512, 2432>, 1,
		<415, 2432, 3117>, 1,
		<415, 3117, 2431>, 1,
		<416, 2432, 3512>, 1,
		<416, 3512, 1500>, 1,
		<416, 1500, 3870>, 1,
		<416, 3870, 1461>, 1,
		<416, 1461, 3492>, 1,
		<416, 3492, 2433>, 1,
		<416, 2433, 3117>, 1,
		<416, 3117, 2432>, 1,
		<417, 2433, 3492>, 1,
		<417, 3492, 1460>, 1,
		<417, 1460, 3882>, 1,
		<417, 3882, 1505>, 1,
		<417, 1505, 3514>, 1,
		<417, 3514, 2430>, 1,
		<417, 2430, 3117>, 1,
		<417, 3117, 2433>, 1,
		<418, 2434, 3605>, 2,
		<418, 3605, 1687>, 2,
		<418, 1687, 3990>, 2,
		<418, 3990, 1510>, 2,
		<418, 1510, 3517>, 2,
		<418, 3517, 2435>, 2,
		<418, 2435, 3118>, 2,
		<418, 3118, 2434>, 2,
		<419, 2435, 3517>, 2,
		<419, 3517, 1511>, 2,
		<419, 1511, 3991>, 2,
		<419, 3991, 1689>, 2,
		<419, 1689, 3606>, 2,
		<419, 3606, 2436>, 2,
		<419, 2436, 3118>, 2,
		<419, 3118, 2435>, 2,
		<420, 2436, 3606>, 2,
		<420, 3606, 1688>, 2,
		<420, 1688, 3989>, 2,
		<420, 3989, 1465>, 2,
		<420, 1465, 3494>, 2,
		<420, 3494, 2437>, 2,
		<420, 2437, 3118>, 2,
		<420, 3118, 2436>, 2,
		<421, 2437, 3494>, 2,
		<421, 3494, 1464>, 2,
		<421, 1464, 3988>, 2,
		<421, 3988, 1686>, 2,
		<421, 1686, 3605>, 2,
		<421, 3605, 2434>, 2,
		<421, 2434, 3118>, 2,
		<421, 3118, 2437>, 2,
		<422, 2438, 3518>, 1,
		<422, 3518, 1513>, 1,
		<422, 1513, 3907>, 1,
		<422, 3907, 1514>, 1,
		<422, 1514, 3519>, 1,
		<422, 3519, 2439>, 1,
		<422, 2439, 3119>, 1,
		<422, 3119, 2438>, 1,
		<423, 2439, 3519>, 1,
		<423, 3519, 1515>, 1,
		<423, 1515, 3895>, 1,
		<423, 3895, 1509>, 1,
		<423, 1509, 3516>, 1,
		<423, 3516, 2440>, 1,
		<423, 2440, 3119>, 1,
		<423, 3119, 2439>, 1,
		<424, 2440, 3516>, 1,
		<424, 3516, 1508>, 1,
		<424, 1508, 3894>, 1,
		<424, 3894, 1469>, 1,
		<424, 1469, 3496>, 1,
		<424, 3496, 2441>, 1,
		<424, 2441, 3119>, 1,
		<424, 3119, 2440>, 1,
		<425, 2441, 3496>, 1,
		<425, 3496, 1468>, 1,
		<425, 1468, 3906>, 1,
		<425, 3906, 1512>, 1,
		<425, 1512, 3518>, 1,
		<425, 3518, 2438>, 1,
		<425, 2438, 3119>, 1,
		<425, 3119, 2441>, 1,
		<426, 2442, 3520>, 1,
		<426, 3520, 1517>, 1,
		<426, 1517, 3919>, 1,
		<426, 3919, 1518>, 1,
		<426, 1518, 3521>, 1,
		<426, 3521, 2443>, 1,
		<426, 2443, 3120>, 1,
		<426, 3120, 2442>, 1,
		<427, 2443, 3521>, 1,
		<427, 3521, 1519>, 1,
		<427, 1519, 3907>, 1,
		<427, 3907, 1513>, 1,
		<427, 1513, 3518>, 1,
		<427, 3518, 2444>, 1,
		<427, 2444, 3120>, 1,
		<427, 3120, 2443>, 1,
		<428, 2444, 3518>, 1,
		<428, 3518, 1512>, 1,
		<428, 1512, 3906>, 1,
		<428, 3906, 1473>, 1,
		<428, 1473, 3498>, 1,
		<428, 3498, 2445>, 1,
		<428, 2445, 3120>, 1,
		<428, 3120, 2444>, 1,
		<429, 2445, 3498>, 1,
		<429, 3498, 1472>, 1,
		<429, 1472, 3918>, 1,
		<429, 3918, 1516>, 1,
		<429, 1516, 3520>, 1,
		<429, 3520, 2442>, 1,
		<429, 2442, 3120>, 1,
		<429, 3120, 2445>, 1,
		<430, 2446, 3522>, 1,
		<430, 3522, 1521>, 1,
		<430, 1521, 3931>, 1,
		<430, 3931, 1522>, 1,
		<430, 1522, 3523>, 1,
		<430, 3523, 2447>, 1,
		<430, 2447, 3121>, 1,
		<430, 3121, 2446>, 1,
		<431, 2447, 3523>, 1,
		<431, 3523, 1523>, 1,
		<431, 1523, 3919>, 1,
		<431, 3919, 1517>, 1,
		<431, 1517, 3520>, 1,
		<431, 3520, 2448>, 1,
		<431, 2448, 3121>, 1,
		<431, 3121, 2447>, 1,
		<432, 2448, 3520>, 1,
		<432, 3520, 1516>, 1,
		<432, 1516, 3918>, 1,
		<432, 3918, 1477>, 1,
		<432, 1477, 3500>, 1,
		<432, 3500, 2449>, 1,
		<432, 2449, 3121>, 1,
		<432, 3121, 2448>, 1,
		<433, 2449, 3500>, 1,
		<433, 3500, 1476>, 1,
		<433, 1476, 3930>, 1,
		<433, 3930, 1520>, 1,
		<433, 1520, 3522>, 1,
		<433, 3522, 2446>, 1,
		<433, 2446, 3121>, 1,
		<433, 3121, 2449>, 1,
		<434, 2450, 3524>, 1,
		<434, 3524, 1525>, 1,
		<434, 1525, 3943>, 1,
		<434, 3943, 1526>, 1,
		<434, 1526, 3525>, 1,
		<434, 3525, 2451>, 1,
		<434, 2451, 3122>, 1,
		<434, 3122, 2450>, 1,
		<435, 2451, 3525>, 1,
		<435, 3525, 1527>, 1,
		<435, 1527, 3931>, 1,
		<435, 3931, 1521>, 1,
		<435, 1521, 3522>, 1,
		<435, 3522, 2452>, 1,
		<435, 2452, 3122>, 1,
		<435, 3122, 2451>, 1,
		<436, 2452, 3522>, 1,
		<436, 3522, 1520>, 1,
		<436, 1520, 3930>, 1,
		<436, 3930, 1481>, 1,
		<436, 1481, 3502>, 1,
		<436, 3502, 2453>, 1,
		<436, 2453, 3122>, 1,
		<436, 3122, 2452>, 1,
		<437, 2453, 3502>, 1,
		<437, 3502, 1480>, 1,
		<437, 1480, 3942>, 1,
		<437, 3942, 1524>, 1,
		<437, 1524, 3524>, 1,
		<437, 3524, 2450>, 1,
		<437, 2450, 3122>, 1,
		<437, 3122, 2453>, 1,
		<438, 2454, 3734>, 1,
		<438, 3734, 1945>, 1,
		<438, 1945, 4021>, 1,
		<438, 4021, 1530>, 1,
		<438, 1530, 3527>, 1,
		<438, 3527, 2455>, 1,
		<438, 2455, 3123>, 1,
		<438, 3123, 2454>, 1,
		<439, 2455, 3527>, 1,
		<439, 3527, 1531>, 1,
		<439, 1531, 3943>, 1,
		<439, 3943, 1525>, 1,
		<439, 1525, 3524>, 1,
		<439, 3524, 2456>, 1,
		<439, 2456, 3123>, 1,
		<439, 3123, 2455>, 1,
		<440, 2456, 3524>, 1,
		<440, 3524, 1524>, 1,
		<440, 1524, 3942>, 1,
		<440, 3942, 1485>, 1,
		<440, 1485, 3504>, 1,
		<440, 3504, 2457>, 1,
		<440, 2457, 3123>, 1,
		<440, 3123, 2456>, 1,
		<441, 2457, 3504>, 1,
		<441, 3504, 1484>, 1,
		<441, 1484, 4019>, 1,
		<441, 4019, 1944>, 1,
		<441, 1944, 3734>, 1,
		<441, 3734, 2454>, 1,
		<441, 2454, 3123>, 1,
		<441, 3123, 2457>, 1,
		<442, 2458, 3761>, 1,
		<442, 3761, 1999>, 1,
		<442, 1999, 4022>, 1,
		<442, 4022, 1534>, 1,
		<442, 1534, 3529>, 1,
		<442, 3529, 2459>, 1,
		<442, 2459, 3124>, 1,
		<442, 3124, 2458>, 1,
		<443, 2459, 3529>, 1,
		<443, 3529, 1535>, 1,
		<443, 1535, 3824>, 1,
		<443, 3824, 1536>, 1,
		<443, 1536, 3530>, 1,
		<443, 3530, 2460>, 1,
		<443, 2460, 3124>, 1,
		<443, 3124, 2459>, 1,
		<444, 2460, 3530>, 1,
		<444, 3530, 1537>, 1,
		<444, 1537, 3823>, 1,
		<444, 3823, 1489>, 1,
		<444, 1489, 3506>, 1,
		<444, 3506, 2461>, 1,
		<444, 2461, 3124>, 1,
		<444, 3124, 2460>, 1,
		<445, 2461, 3506>, 1,
		<445, 3506, 1488>, 1,
		<445, 1488, 4020>, 1,
		<445, 4020, 1998>, 1,
		<445, 1998, 3761>, 1,
		<445, 3761, 2458>, 1,
		<445, 2458, 3124>, 1,
		<445, 3124, 2461>, 1,
		<446, 2462, 3531>, 1,
		<446, 3531, 1539>, 1,
		<446, 1539, 3848>, 1,
		<446, 3848, 1540>, 1,
		<446, 1540, 3532>, 1,
		<446, 3532, 2463>, 1,
		<446, 2463, 3125>, 1,
		<446, 3125, 2462>, 1,
		<447, 2463, 3532>, 1,
		<447, 3532, 1541>, 1,
		<447, 1541, 3836>, 1,
		<447, 3836, 1533>, 1,
		<447, 1533, 3528>, 1,
		<447, 3528, 2464>, 1,
		<447, 2464, 3125>, 1,
		<447, 3125, 2463>, 1,
		<448, 2464, 3528>, 1,
		<448, 3528, 1532>, 1,
		<448, 1532, 3835>, 1,
		<448, 3835, 1495>, 1,
		<448, 1495, 3509>, 1,
		<448, 3509, 2465>, 1,
		<448, 2465, 3125>, 1,
		<448, 3125, 2464>, 1,
		<449, 2465, 3509>, 1,
		<449, 3509, 1494>, 1,
		<449, 1494, 3847>, 1,
		<449, 3847, 1538>, 1,
		<449, 1538, 3531>, 1,
		<449, 3531, 2462>, 1,
		<449, 2462, 3125>, 1,
		<449, 3125, 2465>, 1,
		<450, 2466, 3533>, 1,
		<450, 3533, 1543>, 1,
		<450, 1543, 3860>, 1,
		<450, 3860, 1544>, 1,
		<450, 1544, 3534>, 1,
		<450, 3534, 2467>, 1,
		<450, 2467, 3126>, 1,
		<450, 3126, 2466>, 1,
		<451, 2467, 3534>, 1,
		<451, 3534, 1545>, 1,
		<451, 1545, 3848>, 1,
		<451, 3848, 1539>, 1,
		<451, 1539, 3531>, 1,
		<451, 3531, 2468>, 1,
		<451, 2468, 3126>, 1,
		<451, 3126, 2467>, 1,
		<452, 2468, 3531>, 1,
		<452, 3531, 1538>, 1,
		<452, 1538, 3847>, 1,
		<452, 3847, 1499>, 1,
		<452, 1499, 3511>, 1,
		<452, 3511, 2469>, 1,
		<452, 2469, 3126>, 1,
		<452, 3126, 2468>, 1,
		<453, 2469, 3511>, 1,
		<453, 3511, 1498>, 1,
		<453, 1498, 3859>, 1,
		<453, 3859, 1542>, 1,
		<453, 1542, 3533>, 1,
		<453, 3533, 2466>, 1,
		<453, 2466, 3126>, 1,
		<453, 3126, 2469>, 1,
		<454, 2470, 3535>, 1,
		<454, 3535, 1547>, 1,
		<454, 1547, 3872>, 1,
		<454, 3872, 1548>, 1,
		<454, 1548, 3536>, 1,
		<454, 3536, 2471>, 1,
		<454, 2471, 3127>, 1,
		<454, 3127, 2470>, 1,
		<455, 2471, 3536>, 1,
		<455, 3536, 1549>, 1,
		<455, 1549, 3860>, 1,
		<455, 3860, 1543>, 1,
		<455, 1543, 3533>, 1,
		<455, 3533, 2472>, 1,
		<455, 2472, 3127>, 1,
		<455, 3127, 2471>, 1,
		<456, 2472, 3533>, 1,
		<456, 3533, 1542>, 1,
		<456, 1542, 3859>, 1,
		<456, 3859, 1503>, 1,
		<456, 1503, 3513>, 1,
		<456, 3513, 2473>, 1,
		<456, 2473, 3127>, 1,
		<456, 3127, 2472>, 1,
		<457, 2473, 3513>, 1,
		<457, 3513, 1502>, 1,
		<457, 1502, 3871>, 1,
		<457, 3871, 1546>, 1,
		<457, 1546, 3535>, 1,
		<457, 3535, 2470>, 1,
		<457, 2470, 3127>, 1,
		<457, 3127, 2473>, 1,
		<458, 2474, 3537>, 1,
		<458, 3537, 1550>, 1,
		<458, 1550, 3884>, 1,
		<458, 3884, 1552>, 1,
		<458, 1552, 3538>, 1,
		<458, 3538, 2475>, 1,
		<458, 2475, 3128>, 1,
		<458, 3128, 2474>, 1,
		<459, 2475, 3538>, 1,
		<459, 3538, 1553>, 1,
		<459, 1553, 3872>, 1,
		<459, 3872, 1547>, 1,
		<459, 1547, 3535>, 1,
		<459, 3535, 2476>, 1,
		<459, 2476, 3128>, 1,
		<459, 3128, 2475>, 1,
		<460, 2476, 3535>, 1,
		<460, 3535, 1546>, 1,
		<460, 1546, 3871>, 1,
		<460, 3871, 1507>, 1,
		<460, 1507, 3515>, 1,
		<460, 3515, 2477>, 1,
		<460, 2477, 3128>, 1,
		<460, 3128, 2476>, 1,
		<461, 2477, 3515>, 1,
		<461, 3515, 1506>, 1,
		<461, 1506, 3883>, 1,
		<461, 3883, 1551>, 1,
		<461, 1551, 3537>, 1,
		<461, 3537, 2474>, 1,
		<461, 2474, 3128>, 1,
		<461, 3128, 2477>, 1,
		<462, 2478, 3607>, 2,
		<462, 3607, 1691>, 2,
		<462, 1691, 3992>, 2,
		<462, 3992, 1692>, 2,
		<462, 1692, 3608>, 2,
		<462, 3608, 2479>, 2,
		<462, 2479, 3129>, 2,
		<462, 3129, 2478>, 2,
		<463, 2479, 3608>, 2,
		<463, 3608, 1693>, 2,
		<463, 1693, 3993>, 2,
		<463, 3993, 1695>, 2,
		<463, 1695, 3609>, 2,
		<463, 3609, 2480>, 2,
		<463, 2480, 3129>, 2,
		<463, 3129, 2479>, 2,
		<464, 2480, 3609>, 2,
		<464, 3609, 1694>, 2,
		<464, 1694, 3991>, 2,
		<464, 3991, 1511>, 2,
		<464, 1511, 3517>, 2,
		<464, 3517, 2481>, 2,
		<464, 2481, 3129>, 2,
		<464, 3129, 2480>, 2,
		<465, 2481, 3517>, 2,
		<465, 3517, 1510>, 2,
		<465, 1510, 3990>, 2,
		<465, 3990, 1690>, 2,
		<465, 1690, 3607>, 2,
		<465, 3607, 2478>, 2,
		<465, 2478, 3129>, 2,
		<465, 3129, 2481>, 2,
		<466, 2482, 3541>, 1,
		<466, 3541, 1559>, 1,
		<466, 1559, 3908>, 1,
		<466, 3908, 1560>, 1,
		<466, 1560, 3542>, 1,
		<466, 3542, 2483>, 1,
		<466, 2483, 3130>, 1,
		<466, 3130, 2482>, 1,
		<467, 2483, 3542>, 1,
		<467, 3542, 1561>, 1,
		<467, 1561, 3896>, 1,
		<467, 3896, 1555>, 1,
		<467, 1555, 3539>, 1,
		<467, 3539, 2484>, 1,
		<467, 2484, 3130>, 1,
		<467, 3130, 2483>, 1,
		<468, 2484, 3539>, 1,
		<468, 3539, 1554>, 1,
		<468, 1554, 3895>, 1,
		<468, 3895, 1515>, 1,
		<468, 1515, 3519>, 1,
		<468, 3519, 2485>, 1,
		<468, 2485, 3130>, 1,
		<468, 3130, 2484>, 1,
		<469, 2485, 3519>, 1,
		<469, 3519, 1514>, 1,
		<469, 1514, 3907>, 1,
		<469, 3907, 1558>, 1,
		<469, 1558, 3541>, 1,
		<469, 3541, 2482>, 1,
		<469, 2482, 3130>, 1,
		<469, 3130, 2485>, 1,
		<470, 2486, 3543>, 1,
		<470, 3543, 1563>, 1,
		<470, 1563, 3920>, 1,
		<470, 3920, 1564>, 1,
		<470, 1564, 3544>, 1,
		<470, 3544, 2487>, 1,
		<470, 2487, 3131>, 1,
		<470, 3131, 2486>, 1,
		<471, 2487, 3544>, 1,
		<471, 3544, 1565>, 1,
		<471, 1565, 3908>, 1,
		<471, 3908, 1559>, 1,
		<471, 1559, 3541>, 1,
		<471, 3541, 2488>, 1,
		<471, 2488, 3131>, 1,
		<471, 3131, 2487>, 1,
		<472, 2488, 3541>, 1,
		<472, 3541, 1558>, 1,
		<472, 1558, 3907>, 1,
		<472, 3907, 1519>, 1,
		<472, 1519, 3521>, 1,
		<472, 3521, 2489>, 1,
		<472, 2489, 3131>, 1,
		<472, 3131, 2488>, 1,
		<473, 2489, 3521>, 1,
		<473, 3521, 1518>, 1,
		<473, 1518, 3919>, 1,
		<473, 3919, 1562>, 1,
		<473, 1562, 3543>, 1,
		<473, 3543, 2486>, 1,
		<473, 2486, 3131>, 1,
		<473, 3131, 2489>, 1,
		<474, 2490, 3545>, 1,
		<474, 3545, 1567>, 1,
		<474, 1567, 3932>, 1,
		<474, 3932, 1568>, 1,
		<474, 1568, 3546>, 1,
		<474, 3546, 2491>, 1,
		<474, 2491, 3132>, 1,
		<474, 3132, 2490>, 1,
		<475, 2491, 3546>, 1,
		<475, 3546, 1569>, 1,
		<475, 1569, 3920>, 1,
		<475, 3920, 1563>, 1,
		<475, 1563, 3543>, 1,
		<475, 3543, 2492>, 1,
		<475, 2492, 3132>, 1,
		<475, 3132, 2491>, 1,
		<476, 2492, 3543>, 1,
		<476, 3543, 1562>, 1,
		<476, 1562, 3919>, 1,
		<476, 3919, 1523>, 1,
		<476, 1523, 3523>, 1,
		<476, 3523, 2493>, 1,
		<476, 2493, 3132>, 1,
		<476, 3132, 2492>, 1,
		<477, 2493, 3523>, 1,
		<477, 3523, 1522>, 1,
		<477, 1522, 3931>, 1,
		<477, 3931, 1566>, 1,
		<477, 1566, 3545>, 1,
		<477, 3545, 2490>, 1,
		<477, 2490, 3132>, 1,
		<477, 3132, 2493>, 1,
		<478, 2494, 3547>, 1,
		<478, 3547, 1571>, 1,
		<478, 1571, 3944>, 1,
		<478, 3944, 1572>, 1,
		<478, 1572, 3548>, 1,
		<478, 3548, 2495>, 1,
		<478, 2495, 3133>, 1,
		<478, 3133, 2494>, 1,
		<479, 2495, 3548>, 1,
		<479, 3548, 1573>, 1,
		<479, 1573, 3932>, 1,
		<479, 3932, 1567>, 1,
		<479, 1567, 3545>, 1,
		<479, 3545, 2496>, 1,
		<479, 2496, 3133>, 1,
		<479, 3133, 2495>, 1,
		<480, 2496, 3545>, 1,
		<480, 3545, 1566>, 1,
		<480, 1566, 3931>, 1,
		<480, 3931, 1527>, 1,
		<480, 1527, 3525>, 1,
		<480, 3525, 2497>, 1,
		<480, 2497, 3133>, 1,
		<480, 3133, 2496>, 1,
		<481, 2497, 3525>, 1,
		<481, 3525, 1526>, 1,
		<481, 1526, 3943>, 1,
		<481, 3943, 1570>, 1,
		<481, 1570, 3547>, 1,
		<481, 3547, 2494>, 1,
		<481, 2494, 3133>, 1,
		<481, 3133, 2497>, 1,
		<482, 2498, 3733>, 1,
		<482, 3733, 1943>, 1,
		<482, 1943, 4023>, 1,
		<482, 4023, 1576>, 1,
		<482, 1576, 3550>, 1,
		<482, 3550, 2499>, 1,
		<482, 2499, 3134>, 1,
		<482, 3134, 2498>, 1,
		<483, 2499, 3550>, 1,
		<483, 3550, 1577>, 1,
		<483, 1577, 3944>, 1,
		<483, 3944, 1571>, 1,
		<483, 1571, 3547>, 1,
		<483, 3547, 2500>, 1,
		<483, 2500, 3134>, 1,
		<483, 3134, 2499>, 1,
		<484, 2500, 3547>, 1,
		<484, 3547, 1570>, 1,
		<484, 1570, 3943>, 1,
		<484, 3943, 1531>, 1,
		<484, 1531, 3527>, 1,
		<484, 3527, 2501>, 1,
		<484, 2501, 3134>, 1,
		<484, 3134, 2500>, 1,
		<485, 2501, 3527>, 1,
		<485, 3527, 1530>, 1,
		<485, 1530, 4021>, 1,
		<485, 4021, 1942>, 1,
		<485, 1942, 3733>, 1,
		<485, 3733, 2498>, 1,
		<485, 2498, 3134>, 1,
		<485, 3134, 2501>, 1,
		<486, 2502, 3762>, 1,
		<486, 3762, 2001>, 1,
		<486, 2001, 4024>, 1,
		<486, 4024, 1578>, 1,
		<486, 1578, 3551>, 1,
		<486, 3551, 2503>, 1,
		<486, 2503, 3135>, 1,
		<486, 3135, 2502>, 1,
		<487, 2503, 3551>, 1,
		<487, 3551, 1579>, 1,
		<487, 1579, 3837>, 1,
		<487, 3837, 1580>, 1,
		<487, 1580, 3552>, 1,
		<487, 3552, 2504>, 1,
		<487, 2504, 3135>, 1,
		<487, 3135, 2503>, 1,
		<488, 2504, 3552>, 1,
		<488, 3552, 1581>, 1,
		<488, 1581, 3825>, 1,
		<488, 3825, 1582>, 1,
		<488, 1582, 3553>, 1,
		<488, 3553, 2505>, 1,
		<488, 2505, 3135>, 1,
		<488, 3135, 2504>, 1,
		<489, 2505, 3553>, 1,
		<489, 3553, 1583>, 1,
		<489, 1583, 3824>, 1,
		<489, 3824, 1535>, 1,
		<489, 1535, 3529>, 1,
		<489, 3529, 2506>, 1,
		<489, 2506, 3135>, 1,
		<489, 3135, 2505>, 1,
		<490, 2506, 3529>, 1,
		<490, 3529, 1534>, 1,
		<490, 1534, 4022>, 1,
		<490, 4022, 2000>, 1,
		<490, 2000, 3762>, 1,
		<490, 3762, 2502>, 1,
		<490, 2502, 3135>, 1,
		<490, 3135, 2506>, 1,
		<491, 2507, 3721>, 1,
		<491, 3721, 1918>, 1,
		<491, 1918, 4025>, 1,
		<491, 4025, 2002>, 1,
		<491, 2002, 3763>, 1,
		<491, 3763, 2508>, 1,
		<491, 2508, 3136>, 1,
		<491, 3136, 2507>, 1,
		<492, 2508, 3763>, 1,
		<492, 3763, 2003>, 1,
		<492, 2003, 4024>, 1,
		<492, 4024, 1916>, 1,
		<492, 1916, 3720>, 1,
		<492, 3720, 2509>, 1,
		<492, 2509, 3136>, 1,
		<492, 3136, 2508>, 1,
		<493, 2509, 3720>, 1,
		<493, 3720, 1917>, 1,
		<493, 1917, 3836>, 1,
		<493, 3836, 1541>, 1,
		<493, 1541, 3532>, 1,
		<493, 3532, 2510>, 1,
		<493, 2510, 3136>, 1,
		<493, 3136, 2509>, 1,
		<494, 2510, 3532>, 1,
		<494, 3532, 1540>, 1,
		<494, 1540, 3848>, 1,
		<494, 3848, 1919>, 1,
		<494, 1919, 3721>, 1,
		<494, 3721, 2507>, 1,
		<494, 2507, 3136>, 1,
		<494, 3136, 2510>, 1,
		<495, 2511, 3722>, 1,
		<495, 3722, 1920>, 1,
		<495, 1920, 4026>, 1,
		<495, 4026, 2004>, 1,
		<495, 2004, 3764>, 1,
		<495, 3764, 2512>, 1,
		<495, 2512, 3137>, 1,
		<495, 3137, 2511>, 1,
		<496, 2512, 3764>, 1,
		<496, 3764, 2005>, 1,
		<496, 2005, 4025>, 1,
		<496, 4025, 1918>, 1,
		<496, 1918, 3721>, 1,
		<496, 3721, 2513>, 1,
		<496, 2513, 3137>, 1,
		<496, 3137, 2512>, 1,
		<497, 2513, 3721>, 1,
		<497, 3721, 1919>, 1,
		<497, 1919, 3848>, 1,
		<497, 3848, 1545>, 1,
		<497, 1545, 3534>, 1,
		<497, 3534, 2514>, 1,
		<497, 2514, 3137>, 1,
		<497, 3137, 2513>, 1,
		<498, 2514, 3534>, 1,
		<498, 3534, 1544>, 1,
		<498, 1544, 3860>, 1,
		<498, 3860, 1921>, 1,
		<498, 1921, 3722>, 1,
		<498, 3722, 2511>, 1,
		<498, 2511, 3137>, 1,
		<498, 3137, 2514>, 1,
		<499, 2515, 3723>, 1,
		<499, 3723, 1922>, 1,
		<499, 1922, 4027>, 1,
		<499, 4027, 2006>, 1,
		<499, 2006, 3765>, 1,
		<499, 3765, 2516>, 1,
		<499, 2516, 3138>, 1,
		<499, 3138, 2515>, 1,
		<500, 2516, 3765>, 1,
		<500, 3765, 2007>, 1,
		<500, 2007, 4026>, 1,
		<500, 4026, 1920>, 1,
		<500, 1920, 3722>, 1,
		<500, 3722, 2517>, 1,
		<500, 2517, 3138>, 1,
		<500, 3138, 2516>, 1,
		<501, 2517, 3722>, 1,
		<501, 3722, 1921>, 1,
		<501, 1921, 3860>, 1,
		<501, 3860, 1549>, 1,
		<501, 1549, 3536>, 1,
		<501, 3536, 2518>, 1,
		<501, 2518, 3138>, 1,
		<501, 3138, 2517>, 1,
		<502, 2518, 3536>, 1,
		<502, 3536, 1548>, 1,
		<502, 1548, 3872>, 1,
		<502, 3872, 1923>, 1,
		<502, 1923, 3723>, 1,
		<502, 3723, 2515>, 1,
		<502, 2515, 3138>, 1,
		<502, 3138, 2518>, 1,
		<503, 2519, 3724>, 1,
		<503, 3724, 1924>, 1,
		<503, 1924, 4028>, 1,
		<503, 4028, 2008>, 1,
		<503, 2008, 3766>, 1,
		<503, 3766, 2520>, 1,
		<503, 2520, 3139>, 1,
		<503, 3139, 2519>, 1,
		<504, 2520, 3766>, 1,
		<504, 3766, 2009>, 1,
		<504, 2009, 4027>, 1,
		<504, 4027, 1922>, 1,
		<504, 1922, 3723>, 1,
		<504, 3723, 2521>, 1,
		<504, 2521, 3139>, 1,
		<504, 3139, 2520>, 1,
		<505, 2521, 3723>, 1,
		<505, 3723, 1923>, 1,
		<505, 1923, 3872>, 1,
		<505, 3872, 1553>, 1,
		<505, 1553, 3538>, 1,
		<505, 3538, 2522>, 1,
		<505, 2522, 3139>, 1,
		<505, 3139, 2521>, 1,
		<506, 2522, 3538>, 1,
		<506, 3538, 1552>, 1,
		<506, 1552, 3884>, 1,
		<506, 3884, 1925>, 1,
		<506, 1925, 3724>, 1,
		<506, 3724, 2519>, 1,
		<506, 2519, 3139>, 1,
		<506, 3139, 2522>, 1,
		<507, 2523, 3725>, 1,
		<507, 3725, 1926>, 1,
		<507, 1926, 4029>, 1,
		<507, 4029, 2010>, 1,
		<507, 2010, 3767>, 1,
		<507, 3767, 2524>, 1,
		<507, 2524, 3140>, 1,
		<507, 3140, 2523>, 1,
		<508, 2524, 3767>, 1,
		<508, 3767, 2011>, 1,
		<508, 2011, 4028>, 1,
		<508, 4028, 1924>, 1,
		<508, 1924, 3724>, 1,
		<508, 3724, 2525>, 1,
		<508, 2525, 3140>, 1,
		<508, 3140, 2524>, 1,
		<509, 2525, 3724>, 1,
		<509, 3724, 1925>, 1,
		<509, 1925, 3884>, 1,
		<509, 3884, 1557>, 1,
		<509, 1557, 3540>, 1,
		<509, 3540, 2526>, 1,
		<509, 2526, 3140>, 1,
		<509, 3140, 2525>, 1,
		<510, 2526, 3540>, 1,
		<510, 3540, 1556>, 1,
		<510, 1556, 3896>, 1,
		<510, 3896, 1927>, 1,
		<510, 1927, 3725>, 1,
		<510, 3725, 2523>, 1,
		<510, 2523, 3140>, 1,
		<510, 3140, 2526>, 1,
		<511, 2527, 3726>, 1,
		<511, 3726, 1928>, 1,
		<511, 1928, 4030>, 1,
		<511, 4030, 2012>, 1,
		<511, 2012, 3768>, 1,
		<511, 3768, 2528>, 1,
		<511, 2528, 3141>, 1,
		<511, 3141, 2527>, 1,
		<512, 2528, 3768>, 1,
		<512, 3768, 2013>, 1,
		<512, 2013, 4029>, 1,
		<512, 4029, 1926>, 1,
		<512, 1926, 3725>, 1,
		<512, 3725, 2529>, 1,
		<512, 2529, 3141>, 1,
		<512, 3141, 2528>, 1,
		<513, 2529, 3725>, 1,
		<513, 3725, 1927>, 1,
		<513, 1927, 3896>, 1,
		<513, 3896, 1561>, 1,
		<513, 1561, 3542>, 1,
		<513, 3542, 2530>, 1,
		<513, 2530, 3141>, 1,
		<513, 3141, 2529>, 1,
		<514, 2530, 3542>, 1,
		<514, 3542, 1560>, 1,
		<514, 1560, 3908>, 1,
		<514, 3908, 1929>, 1,
		<514, 1929, 3726>, 1,
		<514, 3726, 2527>, 1,
		<514, 2527, 3141>, 1,
		<514, 3141, 2530>, 1,
		<515, 2531, 3727>, 1,
		<515, 3727, 1930>, 1,
		<515, 1930, 4031>, 1,
		<515, 4031, 2014>, 1,
		<515, 2014, 3769>, 1,
		<515, 3769, 2532>, 1,
		<515, 2532, 3142>, 1,
		<515, 3142, 2531>, 1,
		<516, 2532, 3769>, 1,
		<516, 3769, 2015>, 1,
		<516, 2015, 4030>, 1,
		<516, 4030, 1928>, 1,
		<516, 1928, 3726>, 1,
		<516, 3726, 2533>, 1,
		<516, 2533, 3142>, 1,
		<516, 3142, 2532>, 1,
		<517, 2533, 3726>, 1,
		<517, 3726, 1929>, 1,
		<517, 1929, 3908>, 1,
		<517, 3908, 1565>, 1,
		<517, 1565, 3544>, 1,
		<517, 3544, 2534>, 1,
		<517, 2534, 3142>, 1,
		<517, 3142, 2533>, 1,
		<518, 2534, 3544>, 1,
		<518, 3544, 1564>, 1,
		<518, 1564, 3920>, 1,
		<518, 3920, 1931>, 1,
		<518, 1931, 3727>, 1,
		<518, 3727, 2531>, 1,
		<518, 2531, 3142>, 1,
		<518, 3142, 2534>, 1,
		<519, 2535, 3728>, 1,
		<519, 3728, 1932>, 1,
		<519, 1932, 4032>, 1,
		<519, 4032, 1936>, 1,
		<519, 1936, 3730>, 1,
		<519, 3730, 2536>, 1,
		<519, 2536, 3143>, 1,
		<519, 3143, 2535>, 1,
		<520, 2536, 3730>, 1,
		<520, 3730, 1937>, 1,
		<520, 1937, 4031>, 1,
		<520, 4031, 1930>, 1,
		<520, 1930, 3727>, 1,
		<520, 3727, 2537>, 1,
		<520, 2537, 3143>, 1,
		<520, 3143, 2536>, 1,
		<521, 2537, 3727>, 1,
		<521, 3727, 1931>, 1,
		<521, 1931, 3920>, 1,
		<521, 3920, 1569>, 1,
		<521, 1569, 3546>, 1,
		<521, 3546, 2538>, 1,
		<521, 2538, 3143>, 1,
		<521, 3143, 2537>, 1,
		<522, 2538, 3546>, 1,
		<522, 3546, 1568>, 1,
		<522, 1568, 3932>, 1,
		<522, 3932, 1933>, 1,
		<522, 1933, 3728>, 1,
		<522, 3728, 2535>, 1,
		<522, 2535, 3143>, 1,
		<522, 3143, 2538>, 1,
		<523, 2539, 3729>, 1,
		<523, 3729, 1934>, 1,
		<523, 1934, 4033>, 1,
		<523, 4033, 1938>, 1,
		<523, 1938, 3731>, 1,
		<523, 3731, 2540>, 1,
		<523, 2540, 3144>, 1,
		<523, 3144, 2539>, 1,
		<524, 2540, 3731>, 1,
		<524, 3731, 1939>, 1,
		<524, 1939, 4032>, 1,
		<524, 4032, 1932>, 1,
		<524, 1932, 3728>, 1,
		<524, 3728, 2541>, 1,
		<524, 2541, 3144>, 1,
		<524, 3144, 2540>, 1,
		<525, 2541, 3728>, 1,
		<525, 3728, 1933>, 1,
		<525, 1933, 3932>, 1,
		<525, 3932, 1573>, 1,
		<525, 1573, 3548>, 1,
		<525, 3548, 2542>, 1,
		<525, 2542, 3144>, 1,
		<525, 3144, 2541>, 1,
		<526, 2542, 3548>, 1,
		<526, 3548, 1572>, 1,
		<526, 1572, 3944>, 1,
		<526, 3944, 1935>, 1,
		<526, 1935, 3729>, 1,
		<526, 3729, 2539>, 1,
		<526, 2539, 3144>, 1,
		<526, 3144, 2542>, 1,
		<527, 2543, 3732>, 1,
		<527, 3732, 1941>, 1,
		<527, 1941, 4033>, 1,
		<527, 4033, 1934>, 1,
		<527, 1934, 3729>, 1,
		<527, 3729, 2544>, 1,
		<527, 2544, 3145>, 1,
		<527, 3145, 2543>, 1,
		<528, 2544, 3729>, 1,
		<528, 3729, 1935>, 1,
		<528, 1935, 3944>, 1,
		<528, 3944, 1577>, 1,
		<528, 1577, 3550>, 1,
		<528, 3550, 2545>, 1,
		<528, 2545, 3145>, 1,
		<528, 3145, 2544>, 1,
		<529, 2545, 3550>, 1,
		<529, 3550, 1576>, 1,
		<529, 1576, 4023>, 1,
		<529, 4023, 1940>, 1,
		<529, 1940, 3732>, 1,
		<529, 3732, 2543>, 1,
		<529, 2543, 3145>, 1,
		<529, 3145, 2545>, 1,
		<530, 2546, 3355>, 3,
		<530, 3355, 1187>, 3,
		<530, 1187, 3888>, 3,
		<530, 3888, 1696>, 3,
		<530, 1696, 3610>, 3,
		<530, 3610, 2547>, 3,
		<530, 2547, 3146>, 3,
		<530, 3146, 2546>, 3,
		<531, 2547, 3610>, 3,
		<531, 3610, 1697>, 3,
		<531, 1697, 3959>, 3,
		<531, 3959, 1625>, 3,
		<531, 1625, 3574>, 3,
		<531, 3574, 2548>, 3,
		<531, 2548, 3146>, 3,
		<531, 3146, 2547>, 3,
		<532, 2548, 3574>, 3,
		<532, 3574, 1624>, 3,
		<532, 1624, 3958>, 3,
		<532, 3958, 1698>, 3,
		<532, 1698, 3611>, 3,
		<532, 3611, 2549>, 3,
		<532, 2549, 3146>, 3,
		<532, 3146, 2548>, 3,
		<533, 2549, 3611>, 3,
		<533, 3611, 1699>, 3,
		<533, 1699, 3887>, 3,
		<533, 3887, 1186>, 3,
		<533, 1186, 3355>, 3,
		<533, 3355, 2546>, 3,
		<533, 2546, 3146>, 3,
		<533, 3146, 2549>, 3,
		<534, 2550, 3353>, 3,
		<534, 3353, 1183>, 3,
		<534, 1183, 3875>, 3,
		<534, 3875, 1700>, 3,
		<534, 1700, 3612>, 3,
		<534, 3612, 2551>, 3,
		<534, 2551, 3147>, 3,
		<534, 3147, 2550>, 3,
		<535, 2551, 3612>, 3,
		<535, 3612, 1701>, 3,
		<535, 1701, 3960>, 3,
		<535, 3960, 1626>, 3,
		<535, 1626, 3575>, 3,
		<535, 3575, 2552>, 3,
		<535, 2552, 3147>, 3,
		<535, 3147, 2551>, 3,
		<536, 2552, 3575>, 3,
		<536, 3575, 1627>, 3,
		<536, 1627, 3961>, 3,
		<536, 3961, 1702>, 3,
		<536, 1702, 3613>, 3,
		<536, 3613, 2553>, 3,
		<536, 2553, 3147>, 3,
		<536, 3147, 2552>, 3,
		<537, 2553, 3613>, 3,
		<537, 3613, 1703>, 3,
		<537, 1703, 3876>, 3,
		<537, 3876, 1182>, 3,
		<537, 1182, 3353>, 3,
		<537, 3353, 2550>, 3,
		<537, 2550, 3147>, 3,
		<537, 3147, 2553>, 3,
		<538, 2554, 3327>, 3,
		<538, 3327, 1131>, 3,
		<538, 1131, 3887>, 3,
		<538, 3887, 1699>, 3,
		<538, 1699, 3611>, 3,
		<538, 3611, 2555>, 3,
		<538, 2555, 3148>, 3,
		<538, 3148, 2554>, 3,
		<539, 2555, 3611>, 3,
		<539, 3611, 1698>, 3,
		<539, 1698, 3958>, 3,
		<539, 3958, 1628>, 3,
		<539, 1628, 3576>, 3,
		<539, 3576, 2556>, 3,
		<539, 2556, 3148>, 3,
		<539, 3148, 2555>, 3,
		<540, 2556, 3576>, 3,
		<540, 3576, 1629>, 3,
		<540, 1629, 3960>, 3,
		<540, 3960, 1701>, 3,
		<540, 1701, 3612>, 3,
		<540, 3612, 2557>, 3,
		<540, 2557, 3148>, 3,
		<540, 3148, 2556>, 3,
		<541, 2557, 3612>, 3,
		<541, 3612, 1700>, 3,
		<541, 1700, 3875>, 3,
		<541, 3875, 1130>, 3,
		<541, 1130, 3327>, 3,
		<541, 3327, 2554>, 3,
		<541, 2554, 3148>, 3,
		<541, 3148, 2557>, 3,
		<542, 2558, 3378>, 3,
		<542, 3378, 1233>, 3,
		<542, 1233, 3889>, 3,
		<542, 3889, 1704>, 3,
		<542, 1704, 3614>, 3,
		<542, 3614, 2559>, 3,
		<542, 2559, 3149>, 3,
		<542, 3149, 2558>, 3,
		<543, 2559, 3614>, 3,
		<543, 3614, 1705>, 3,
		<543, 1705, 3962>, 3,
		<543, 3962, 1631>, 3,
		<543, 1631, 3577>, 3,
		<543, 3577, 2560>, 3,
		<543, 2560, 3149>, 3,
		<543, 3149, 2559>, 3,
		<544, 2560, 3577>, 3,
		<544, 3577, 1630>, 3,
		<544, 1630, 3959>, 3,
		<544, 3959, 1697>, 3,
		<544, 1697, 3610>, 3,
		<544, 3610, 2561>, 3,
		<544, 2561, 3149>, 3,
		<544, 3149, 2560>, 3,
		<545, 2561, 3610>, 3,
		<545, 3610, 1696>, 3,
		<545, 1696, 3888>, 3,
		<545, 3888, 1232>, 3,
		<545, 1232, 3378>, 3,
		<545, 3378, 2558>, 3,
		<545, 2558, 3149>, 3,
		<545, 3149, 2561>, 3,
		<546, 2562, 3376>, 3,
		<546, 3376, 1229>, 3,
		<546, 1229, 3876>, 3,
		<546, 3876, 1703>, 3,
		<546, 1703, 3613>, 3,
		<546, 3613, 2563>, 3,
		<546, 2563, 3150>, 3,
		<546, 3150, 2562>, 3,
		<547, 2563, 3613>, 3,
		<547, 3613, 1702>, 3,
		<547, 1702, 3961>, 3,
		<547, 3961, 1632>, 3,
		<547, 1632, 3578>, 3,
		<547, 3578, 2564>, 3,
		<547, 2564, 3150>, 3,
		<547, 3150, 2563>, 3,
		<548, 2564, 3578>, 3,
		<548, 3578, 1633>, 3,
		<548, 1633, 3963>, 3,
		<548, 3963, 1706>, 3,
		<548, 1706, 3615>, 3,
		<548, 3615, 2565>, 3,
		<548, 2565, 3150>, 3,
		<548, 3150, 2564>, 3,
		<549, 2565, 3615>, 3,
		<549, 3615, 1707>, 3,
		<549, 1707, 3877>, 3,
		<549, 3877, 1228>, 3,
		<549, 1228, 3376>, 3,
		<549, 3376, 2562>, 3,
		<549, 2562, 3150>, 3,
		<549, 3150, 2565>, 3,
		<550, 2566, 3401>, 3,
		<550, 3401, 1279>, 3,
		<550, 1279, 3890>, 3,
		<550, 3890, 1708>, 3,
		<550, 1708, 3616>, 3,
		<550, 3616, 2567>, 3,
		<550, 2567, 3151>, 3,
		<550, 3151, 2566>, 3,
		<551, 2567, 3616>, 3,
		<551, 3616, 1709>, 3,
		<551, 1709, 3964>, 3,
		<551, 3964, 1635>, 3,
		<551, 1635, 3579>, 3,
		<551, 3579, 2568>, 3,
		<551, 2568, 3151>, 3,
		<551, 3151, 2567>, 3,
		<552, 2568, 3579>, 3,
		<552, 3579, 1634>, 3,
		<552, 1634, 3962>, 3,
		<552, 3962, 1705>, 3,
		<552, 1705, 3614>, 3,
		<552, 3614, 2569>, 3,
		<552, 2569, 3151>, 3,
		<552, 3151, 2568>, 3,
		<553, 2569, 3614>, 3,
		<553, 3614, 1704>, 3,
		<553, 1704, 3889>, 3,
		<553, 3889, 1278>, 3,
		<553, 1278, 3401>, 3,
		<553, 3401, 2566>, 3,
		<553, 2566, 3151>, 3,
		<553, 3151, 2569>, 3,
		<554, 2570, 3399>, 3,
		<554, 3399, 1275>, 3,
		<554, 1275, 3877>, 3,
		<554, 3877, 1707>, 3,
		<554, 1707, 3615>, 3,
		<554, 3615, 2571>, 3,
		<554, 2571, 3152>, 3,
		<554, 3152, 2570>, 3,
		<555, 2571, 3615>, 3,
		<555, 3615, 1706>, 3,
		<555, 1706, 3963>, 3,
		<555, 3963, 1636>, 3,
		<555, 1636, 3580>, 3,
		<555, 3580, 2572>, 3,
		<555, 2572, 3152>, 3,
		<555, 3152, 2571>, 3,
		<556, 2572, 3580>, 3,
		<556, 3580, 1637>, 3,
		<556, 1637, 3965>, 3,
		<556, 3965, 1710>, 3,
		<556, 1710, 3617>, 3,
		<556, 3617, 2573>, 3,
		<556, 2573, 3152>, 3,
		<556, 3152, 2572>, 3,
		<557, 2573, 3617>, 3,
		<557, 3617, 1711>, 3,
		<557, 1711, 3878>, 3,
		<557, 3878, 1274>, 3,
		<557, 1274, 3399>, 3,
		<557, 3399, 2570>, 3,
		<557, 2570, 3152>, 3,
		<557, 3152, 2573>, 3,
		<558, 2574, 3424>, 3,
		<558, 3424, 1325>, 3,
		<558, 1325, 3891>, 3,
		<558, 3891, 1712>, 3,
		<558, 1712, 3618>, 3,
		<558, 3618, 2575>, 3,
		<558, 2575, 3153>, 3,
		<558, 3153, 2574>, 3,
		<559, 2575, 3618>, 3,
		<559, 3618, 1713>, 3,
		<559, 1713, 3966>, 3,
		<559, 3966, 1639>, 3,
		<559, 1639, 3581>, 3,
		<559, 3581, 2576>, 3,
		<559, 2576, 3153>, 3,
		<559, 3153, 2575>, 3,
		<560, 2576, 3581>, 3,
		<560, 3581, 1638>, 3,
		<560, 1638, 3964>, 3,
		<560, 3964, 1709>, 3,
		<560, 1709, 3616>, 3,
		<560, 3616, 2577>, 3,
		<560, 2577, 3153>, 3,
		<560, 3153, 2576>, 3,
		<561, 2577, 3616>, 3,
		<561, 3616, 1708>, 3,
		<561, 1708, 3890>, 3,
		<561, 3890, 1324>, 3,
		<561, 1324, 3424>, 3,
		<561, 3424, 2574>, 3,
		<561, 2574, 3153>, 3,
		<561, 3153, 2577>, 3,
		<562, 2578, 3422>, 3,
		<562, 3422, 1321>, 3,
		<562, 1321, 3878>, 3,
		<562, 3878, 1711>, 3,
		<562, 1711, 3617>, 3,
		<562, 3617, 2579>, 3,
		<562, 2579, 3154>, 3,
		<562, 3154, 2578>, 3,
		<563, 2579, 3617>, 3,
		<563, 3617, 1710>, 3,
		<563, 1710, 3965>, 3,
		<563, 3965, 1640>, 3,
		<563, 1640, 3582>, 3,
		<563, 3582, 2580>, 3,
		<563, 2580, 3154>, 3,
		<563, 3154, 2579>, 3,
		<564, 2580, 3582>, 3,
		<564, 3582, 1641>, 3,
		<564, 1641, 3967>, 3,
		<564, 3967, 1714>, 3,
		<564, 1714, 3619>, 3,
		<564, 3619, 2581>, 3,
		<564, 2581, 3154>, 3,
		<564, 3154, 2580>, 3,
		<565, 2581, 3619>, 3,
		<565, 3619, 1715>, 3,
		<565, 1715, 3879>, 3,
		<565, 3879, 1320>, 3,
		<565, 1320, 3422>, 3,
		<565, 3422, 2578>, 3,
		<565, 2578, 3154>, 3,
		<565, 3154, 2581>, 3,
		<566, 2582, 3440>, 3,
		<566, 3440, 1357>, 3,
		<566, 1357, 3832>, 3,
		<566, 3832, 1716>, 3,
		<566, 1716, 3620>, 3,
		<566, 3620, 2583>, 3,
		<566, 2583, 3155>, 3,
		<566, 3155, 2582>, 3,
		<567, 2583, 3620>, 3,
		<567, 3620, 1717>, 3,
		<567, 1717, 3969>, 3,
		<567, 3969, 1643>, 3,
		<567, 1643, 3583>, 3,
		<567, 3583, 2584>, 3,
		<567, 2584, 3155>, 3,
		<567, 3155, 2583>, 3,
		<568, 2584, 3583>, 3,
		<568, 3583, 1642>, 3,
		<568, 1642, 3968>, 3,
		<568, 3968, 1718>, 3,
		<568, 1718, 3621>, 3,
		<568, 3621, 2585>, 3,
		<568, 2585, 3155>, 3,
		<568, 3155, 2584>, 3,
		<569, 2585, 3621>, 3,
		<569, 3621, 1719>, 3,
		<569, 1719, 3844>, 3,
		<569, 3844, 1356>, 3,
		<569, 1356, 3440>, 3,
		<569, 3440, 2582>, 3,
		<569, 2582, 3155>, 3,
		<569, 3155, 2585>, 3,
		<570, 2586, 3436>, 3,
		<570, 3436, 1349>, 3,
		<570, 1349, 3831>, 3,
		<570, 3831, 1720>, 3,
		<570, 1720, 3622>, 3,
		<570, 3622, 2587>, 3,
		<570, 2587, 3156>, 3,
		<570, 3156, 2586>, 3,
		<571, 2587, 3622>, 3,
		<571, 3622, 1721>, 3,
		<571, 1721, 3970>, 3,
		<571, 3970, 1644>, 3,
		<571, 1644, 3584>, 3,
		<571, 3584, 2588>, 3,
		<571, 2588, 3156>, 3,
		<571, 3156, 2587>, 3,
		<572, 2588, 3584>, 3,
		<572, 3584, 1645>, 3,
		<572, 1645, 3969>, 3,
		<572, 3969, 1717>, 3,
		<572, 1717, 3620>, 3,
		<572, 3620, 2589>, 3,
		<572, 2589, 3156>, 3,
		<572, 3156, 2588>, 3,
		<573, 2589, 3620>, 3,
		<573, 3620, 1716>, 3,
		<573, 1716, 3832>, 3,
		<573, 3832, 1348>, 3,
		<573, 1348, 3436>, 3,
		<573, 3436, 2586>, 3,
		<573, 2586, 3156>, 3,
		<573, 3156, 2589>, 3,
		<574, 2590, 3417>, 3,
		<574, 3417, 1311>, 3,
		<574, 1311, 3843>, 3,
		<574, 3843, 1722>, 3,
		<574, 1722, 3623>, 3,
		<574, 3623, 2591>, 3,
		<574, 2591, 3157>, 3,
		<574, 3157, 2590>, 3,
		<575, 2591, 3623>, 3,
		<575, 3623, 1723>, 3,
		<575, 1723, 3971>, 3,
		<575, 3971, 1646>, 3,
		<575, 1646, 3585>, 3,
		<575, 3585, 2592>, 3,
		<575, 2592, 3157>, 3,
		<575, 3157, 2591>, 3,
		<576, 2592, 3585>, 3,
		<576, 3585, 1647>, 3,
		<576, 1647, 3970>, 3,
		<576, 3970, 1721>, 3,
		<576, 1721, 3622>, 3,
		<576, 3622, 2593>, 3,
		<576, 2593, 3157>, 3,
		<576, 3157, 2592>, 3,
		<577, 2593, 3622>, 3,
		<577, 3622, 1720>, 3,
		<577, 1720, 3831>, 3,
		<577, 3831, 1310>, 3,
		<577, 1310, 3417>, 3,
		<577, 3417, 2590>, 3,
		<577, 2590, 3157>, 3,
		<577, 3157, 2593>, 3,
		<578, 2594, 3442>, 3,
		<578, 3442, 1361>, 3,
		<578, 1361, 3844>, 3,
		<578, 3844, 1719>, 3,
		<578, 1719, 3621>, 3,
		<578, 3621, 2595>, 3,
		<578, 2595, 3158>, 3,
		<578, 3158, 2594>, 3,
		<579, 2595, 3621>, 3,
		<579, 3621, 1718>, 3,
		<579, 1718, 3968>, 3,
		<579, 3968, 1649>, 3,
		<579, 1649, 3586>, 3,
		<579, 3586, 2596>, 3,
		<579, 2596, 3158>, 3,
		<579, 3158, 2595>, 3,
		<580, 2596, 3586>, 3,
		<580, 3586, 1648>, 3,
		<580, 1648, 3972>, 3,
		<580, 3972, 1724>, 3,
		<580, 1724, 3624>, 3,
		<580, 3624, 2597>, 3,
		<580, 2597, 3158>, 3,
		<580, 3158, 2596>, 3,
		<581, 2597, 3624>, 3,
		<581, 3624, 1725>, 3,
		<581, 1725, 3856>, 3,
		<581, 3856, 1360>, 3,
		<581, 1360, 3442>, 3,
		<581, 3442, 2594>, 3,
		<581, 2594, 3158>, 3,
		<581, 3158, 2597>, 3,
		<582, 2598, 3419>, 3,
		<582, 3419, 1315>, 3,
		<582, 1315, 3855>, 3,
		<582, 3855, 1726>, 3,
		<582, 1726, 3625>, 3,
		<582, 3625, 2599>, 3,
		<582, 2599, 3159>, 3,
		<582, 3159, 2598>, 3,
		<583, 2599, 3625>, 3,
		<583, 3625, 1727>, 3,
		<583, 1727, 3973>, 3,
		<583, 3973, 1650>, 3,
		<583, 1650, 3587>, 3,
		<583, 3587, 2600>, 3,
		<583, 2600, 3159>, 3,
		<583, 3159, 2599>, 3,
		<584, 2600, 3587>, 3,
		<584, 3587, 1651>, 3,
		<584, 1651, 3971>, 3,
		<584, 3971, 1723>, 3,
		<584, 1723, 3623>, 3,
		<584, 3623, 2601>, 3,
		<584, 2601, 3159>, 3,
		<584, 3159, 2600>, 3,
		<585, 2601, 3623>, 3,
		<585, 3623, 1722>, 3,
		<585, 1722, 3843>, 3,
		<585, 3843, 1314>, 3,
		<585, 1314, 3419>, 3,
		<585, 3419, 2598>, 3,
		<585, 2598, 3159>, 3,
		<585, 3159, 2601>, 3,
		<586, 2602, 3444>, 3,
		<586, 3444, 1365>, 3,
		<586, 1365, 3856>, 3,
		<586, 3856, 1725>, 3,
		<586, 1725, 3624>, 3,
		<586, 3624, 2603>, 3,
		<586, 2603, 3160>, 3,
		<586, 3160, 2602>, 3,
		<587, 2603, 3624>, 3,
		<587, 3624, 1724>, 3,
		<587, 1724, 3972>, 3,
		<587, 3972, 1653>, 3,
		<587, 1653, 3588>, 3,
		<587, 3588, 2604>, 3,
		<587, 2604, 3160>, 3,
		<587, 3160, 2603>, 3,
		<588, 2604, 3588>, 3,
		<588, 3588, 1652>, 3,
		<588, 1652, 3974>, 3,
		<588, 3974, 1728>, 3,
		<588, 1728, 3626>, 3,
		<588, 3626, 2605>, 3,
		<588, 2605, 3160>, 3,
		<588, 3160, 2604>, 3,
		<589, 2605, 3626>, 3,
		<589, 3626, 1729>, 3,
		<589, 1729, 3868>, 3,
		<589, 3868, 1364>, 3,
		<589, 1364, 3444>, 3,
		<589, 3444, 2602>, 3,
		<589, 2602, 3160>, 3,
		<589, 3160, 2605>, 3,
		<590, 2606, 3421>, 3,
		<590, 3421, 1319>, 3,
		<590, 1319, 3867>, 3,
		<590, 3867, 1730>, 3,
		<590, 1730, 3627>, 3,
		<590, 3627, 2607>, 3,
		<590, 2607, 3161>, 3,
		<590, 3161, 2606>, 3,
		<591, 2607, 3627>, 3,
		<591, 3627, 1731>, 3,
		<591, 1731, 3975>, 3,
		<591, 3975, 1654>, 3,
		<591, 1654, 3589>, 3,
		<591, 3589, 2608>, 3,
		<591, 2608, 3161>, 3,
		<591, 3161, 2607>, 3,
		<592, 2608, 3589>, 3,
		<592, 3589, 1655>, 3,
		<592, 1655, 3973>, 3,
		<592, 3973, 1727>, 3,
		<592, 1727, 3625>, 3,
		<592, 3625, 2609>, 3,
		<592, 2609, 3161>, 3,
		<592, 3161, 2608>, 3,
		<593, 2609, 3625>, 3,
		<593, 3625, 1726>, 3,
		<593, 1726, 3855>, 3,
		<593, 3855, 1318>, 3,
		<593, 1318, 3421>, 3,
		<593, 3421, 2606>, 3,
		<593, 2606, 3161>, 3,
		<593, 3161, 2609>, 3,
		<594, 2610, 3446>, 3,
		<594, 3446, 1369>, 3,
		<594, 1369, 3868>, 3,
		<594, 3868, 1729>, 3,
		<594, 1729, 3626>, 3,
		<594, 3626, 2611>, 3,
		<594, 2611, 3162>, 3,
		<594, 3162, 2610>, 3,
		<595, 2611, 3626>, 3,
		<595, 3626, 1728>, 3,
		<595, 1728, 3974>, 3,
		<595, 3974, 1657>, 3,
		<595, 1657, 3590>, 3,
		<595, 3590, 2612>, 3,
		<595, 2612, 3162>, 3,
		<595, 3162, 2611>, 3,
		<596, 2612, 3590>, 3,
		<596, 3590, 1656>, 3,
		<596, 1656, 3976>, 3,
		<596, 3976, 1732>, 3,
		<596, 1732, 3628>, 3,
		<596, 3628, 2613>, 3,
		<596, 2613, 3162>, 3,
		<596, 3162, 2612>, 3,
		<597, 2613, 3628>, 3,
		<597, 3628, 1733>, 3,
		<597, 1733, 3880>, 3,
		<597, 3880, 1368>, 3,
		<597, 1368, 3446>, 3,
		<597, 3446, 2610>, 3,
		<597, 2610, 3162>, 3,
		<597, 3162, 2613>, 3,
		<598, 2614, 3423>, 3,
		<598, 3423, 1323>, 3,
		<598, 1323, 3879>, 3,
		<598, 3879, 1715>, 3,
		<598, 1715, 3619>, 3,
		<598, 3619, 2615>, 3,
		<598, 2615, 3163>, 3,
		<598, 3163, 2614>, 3,
		<599, 2615, 3619>, 3,
		<599, 3619, 1714>, 3,
		<599, 1714, 3967>, 3,
		<599, 3967, 1658>, 3,
		<599, 1658, 3591>, 3,
		<599, 3591, 2616>, 3,
		<599, 2616, 3163>, 3,
		<599, 3163, 2615>, 3,
		<600, 2616, 3591>, 3,
		<600, 3591, 1659>, 3,
		<600, 1659, 3975>, 3,
		<600, 3975, 1731>, 3,
		<600, 1731, 3627>, 3,
		<600, 3627, 2617>, 3,
		<600, 2617, 3163>, 3,
		<600, 3163, 2616>, 3,
		<601, 2617, 3627>, 3,
		<601, 3627, 1730>, 3,
		<601, 1730, 3867>, 3,
		<601, 3867, 1322>, 3,
		<601, 1322, 3423>, 3,
		<601, 3423, 2614>, 3,
		<601, 2614, 3163>, 3,
		<601, 3163, 2617>, 3,
		<602, 2618, 3450>, 3,
		<602, 3450, 1377>, 3,
		<602, 1377, 3892>, 3,
		<602, 3892, 1734>, 3,
		<602, 1734, 3629>, 3,
		<602, 3629, 2619>, 3,
		<602, 2619, 3164>, 3,
		<602, 3164, 2618>, 3,
		<603, 2619, 3629>, 3,
		<603, 3629, 1735>, 3,
		<603, 1735, 3978>, 3,
		<603, 3978, 1661>, 3,
		<603, 1661, 3592>, 3,
		<603, 3592, 2620>, 3,
		<603, 2620, 3164>, 3,
		<603, 3164, 2619>, 3,
		<604, 2620, 3592>, 3,
		<604, 3592, 1660>, 3,
		<604, 1660, 3977>, 3,
		<604, 3977, 1736>, 3,
		<604, 1736, 3630>, 3,
		<604, 3630, 2621>, 3,
		<604, 2621, 3164>, 3,
		<604, 3164, 2620>, 3,
		<605, 2621, 3630>, 3,
		<605, 3630, 1737>, 3,
		<605, 1737, 3904>, 3,
		<605, 3904, 1376>, 3,
		<605, 1376, 3450>, 3,
		<605, 3450, 2618>, 3,
		<605, 2618, 3164>, 3,
		<605, 3164, 2621>, 3,
		<606, 2622, 3427>, 3,
		<606, 3427, 1331>, 3,
		<606, 1331, 3903>, 3,
		<606, 3903, 1738>, 3,
		<606, 1738, 3631>, 3,
		<606, 3631, 2623>, 3,
		<606, 2623, 3165>, 3,
		<606, 3165, 2622>, 3,
		<607, 2623, 3631>, 3,
		<607, 3631, 1739>, 3,
		<607, 1739, 3979>, 3,
		<607, 3979, 1662>, 3,
		<607, 1662, 3593>, 3,
		<607, 3593, 2624>, 3,
		<607, 2624, 3165>, 3,
		<607, 3165, 2623>, 3,
		<608, 2624, 3593>, 3,
		<608, 3593, 1663>, 3,
		<608, 1663, 3966>, 3,
		<608, 3966, 1713>, 3,
		<608, 1713, 3618>, 3,
		<608, 3618, 2625>, 3,
		<608, 2625, 3165>, 3,
		<608, 3165, 2624>, 3,
		<609, 2625, 3618>, 3,
		<609, 3618, 1712>, 3,
		<609, 1712, 3891>, 3,
		<609, 3891, 1330>, 3,
		<609, 1330, 3427>, 3,
		<609, 3427, 2622>, 3,
		<609, 2622, 3165>, 3,
		<609, 3165, 2625>, 3,
		<610, 2626, 3452>, 3,
		<610, 3452, 1381>, 3,
		<610, 1381, 3904>, 3,
		<610, 3904, 1737>, 3,
		<610, 1737, 3630>, 3,
		<610, 3630, 2627>, 3,
		<610, 2627, 3166>, 3,
		<610, 3166, 2626>, 3,
		<611, 2627, 3630>, 3,
		<611, 3630, 1736>, 3,
		<611, 1736, 3977>, 3,
		<611, 3977, 1665>, 3,
		<611, 1665, 3594>, 3,
		<611, 3594, 2628>, 3,
		<611, 2628, 3166>, 3,
		<611, 3166, 2627>, 3,
		<612, 2628, 3594>, 3,
		<612, 3594, 1664>, 3,
		<612, 1664, 3980>, 3,
		<612, 3980, 1740>, 3,
		<612, 1740, 3632>, 3,
		<612, 3632, 2629>, 3,
		<612, 2629, 3166>, 3,
		<612, 3166, 2628>, 3,
		<613, 2629, 3632>, 3,
		<613, 3632, 1741>, 3,
		<613, 1741, 3916>, 3,
		<613, 3916, 1380>, 3,
		<613, 1380, 3452>, 3,
		<613, 3452, 2626>, 3,
		<613, 2626, 3166>, 3,
		<613, 3166, 2629>, 3,
		<614, 2630, 3429>, 3,
		<614, 3429, 1335>, 3,
		<614, 1335, 3915>, 3,
		<614, 3915, 1742>, 3,
		<614, 1742, 3633>, 3,
		<614, 3633, 2631>, 3,
		<614, 2631, 3167>, 3,
		<614, 3167, 2630>, 3,
		<615, 2631, 3633>, 3,
		<615, 3633, 1743>, 3,
		<615, 1743, 3981>, 3,
		<615, 3981, 1666>, 3,
		<615, 1666, 3595>, 3,
		<615, 3595, 2632>, 3,
		<615, 2632, 3167>, 3,
		<615, 3167, 2631>, 3,
		<616, 2632, 3595>, 3,
		<616, 3595, 1667>, 3,
		<616, 1667, 3979>, 3,
		<616, 3979, 1739>, 3,
		<616, 1739, 3631>, 3,
		<616, 3631, 2633>, 3,
		<616, 2633, 3167>, 3,
		<616, 3167, 2632>, 3,
		<617, 2633, 3631>, 3,
		<617, 3631, 1738>, 3,
		<617, 1738, 3903>, 3,
		<617, 3903, 1334>, 3,
		<617, 1334, 3429>, 3,
		<617, 3429, 2630>, 3,
		<617, 2630, 3167>, 3,
		<617, 3167, 2633>, 3,
		<618, 2634, 3454>, 3,
		<618, 3454, 1385>, 3,
		<618, 1385, 3916>, 3,
		<618, 3916, 1741>, 3,
		<618, 1741, 3632>, 3,
		<618, 3632, 2635>, 3,
		<618, 2635, 3168>, 3,
		<618, 3168, 2634>, 3,
		<619, 2635, 3632>, 3,
		<619, 3632, 1740>, 3,
		<619, 1740, 3980>, 3,
		<619, 3980, 1669>, 3,
		<619, 1669, 3596>, 3,
		<619, 3596, 2636>, 3,
		<619, 2636, 3168>, 3,
		<619, 3168, 2635>, 3,
		<620, 2636, 3596>, 3,
		<620, 3596, 1668>, 3,
		<620, 1668, 3982>, 3,
		<620, 3982, 1744>, 3,
		<620, 1744, 3634>, 3,
		<620, 3634, 2637>, 3,
		<620, 2637, 3168>, 3,
		<620, 3168, 2636>, 3,
		<621, 2637, 3634>, 3,
		<621, 3634, 1745>, 3,
		<621, 1745, 3928>, 3,
		<621, 3928, 1384>, 3,
		<621, 1384, 3454>, 3,
		<621, 3454, 2634>, 3,
		<621, 2634, 3168>, 3,
		<621, 3168, 2637>, 3,
		<622, 2638, 3431>, 3,
		<622, 3431, 1339>, 3,
		<622, 1339, 3927>, 3,
		<622, 3927, 1746>, 3,
		<622, 1746, 3635>, 3,
		<622, 3635, 2639>, 3,
		<622, 2639, 3169>, 3,
		<622, 3169, 2638>, 3,
		<623, 2639, 3635>, 3,
		<623, 3635, 1747>, 3,
		<623, 1747, 3983>, 3,
		<623, 3983, 1670>, 3,
		<623, 1670, 3597>, 3,
		<623, 3597, 2640>, 3,
		<623, 2640, 3169>, 3,
		<623, 3169, 2639>, 3,
		<624, 2640, 3597>, 3,
		<624, 3597, 1671>, 3,
		<624, 1671, 3981>, 3,
		<624, 3981, 1743>, 3,
		<624, 1743, 3633>, 3,
		<624, 3633, 2641>, 3,
		<624, 2641, 3169>, 3,
		<624, 3169, 2640>, 3,
		<625, 2641, 3633>, 3,
		<625, 3633, 1742>, 3,
		<625, 1742, 3915>, 3,
		<625, 3915, 1338>, 3,
		<625, 1338, 3431>, 3,
		<625, 3431, 2638>, 3,
		<625, 2638, 3169>, 3,
		<625, 3169, 2641>, 3,
		<626, 2642, 3455>, 3,
		<626, 3455, 1387>, 3,
		<626, 1387, 3940>, 3,
		<626, 3940, 1748>, 3,
		<626, 1748, 3636>, 3,
		<626, 3636, 2643>, 3,
		<626, 2643, 3170>, 3,
		<626, 3170, 2642>, 3,
		<627, 2643, 3636>, 3,
		<627, 3636, 1749>, 3,
		<627, 1749, 3985>, 3,
		<627, 3985, 1673>, 3,
		<627, 1673, 3598>, 3,
		<627, 3598, 2644>, 3,
		<627, 2644, 3170>, 3,
		<627, 3170, 2643>, 3,
		<628, 2644, 3598>, 3,
		<628, 3598, 1672>, 3,
		<628, 1672, 3984>, 3,
		<628, 3984, 1750>, 3,
		<628, 1750, 3637>, 3,
		<628, 3637, 2645>, 3,
		<628, 2645, 3170>, 3,
		<628, 3170, 2644>, 3,
		<629, 2645, 3637>, 3,
		<629, 3637, 1751>, 3,
		<629, 1751, 3939>, 3,
		<629, 3939, 1386>, 3,
		<629, 1386, 3455>, 3,
		<629, 3455, 2642>, 3,
		<629, 2642, 3170>, 3,
		<629, 3170, 2645>, 3,
		<630, 2646, 3456>, 3,
		<630, 3456, 1389>, 3,
		<630, 1389, 3928>, 3,
		<630, 3928, 1745>, 3,
		<630, 1745, 3634>, 3,
		<630, 3634, 2647>, 3,
		<630, 2647, 3171>, 3,
		<630, 3171, 2646>, 3,
		<631, 2647, 3634>, 3,
		<631, 3634, 1744>, 3,
		<631, 1744, 3982>, 3,
		<631, 3982, 1675>, 3,
		<631, 1675, 3599>, 3,
		<631, 3599, 2648>, 3,
		<631, 2648, 3171>, 3,
		<631, 3171, 2647>, 3,
		<632, 2648, 3599>, 3,
		<632, 3599, 1674>, 3,
		<632, 1674, 3985>, 3,
		<632, 3985, 1749>, 3,
		<632, 1749, 3636>, 3,
		<632, 3636, 2649>, 3,
		<632, 2649, 3171>, 3,
		<632, 3171, 2648>, 3,
		<633, 2649, 3636>, 3,
		<633, 3636, 1748>, 3,
		<633, 1748, 3940>, 3,
		<633, 3940, 1388>, 3,
		<633, 1388, 3456>, 3,
		<633, 3456, 2646>, 3,
		<633, 2646, 3171>, 3,
		<633, 3171, 2649>, 3,
		<634, 2650, 3433>, 3,
		<634, 3433, 1343>, 3,
		<634, 1343, 3939>, 3,
		<634, 3939, 1751>, 3,
		<634, 1751, 3637>, 3,
		<634, 3637, 2651>, 3,
		<634, 2651, 3172>, 3,
		<634, 3172, 2650>, 3,
		<635, 2651, 3637>, 3,
		<635, 3637, 1750>, 3,
		<635, 1750, 3984>, 3,
		<635, 3984, 1676>, 3,
		<635, 1676, 3600>, 3,
		<635, 3600, 2652>, 3,
		<635, 2652, 3172>, 3,
		<635, 3172, 2651>, 3,
		<636, 2652, 3600>, 3,
		<636, 3600, 1677>, 3,
		<636, 1677, 3983>, 3,
		<636, 3983, 1747>, 3,
		<636, 1747, 3635>, 3,
		<636, 3635, 2653>, 3,
		<636, 2653, 3172>, 3,
		<636, 3172, 2652>, 3,
		<637, 2653, 3635>, 3,
		<637, 3635, 1746>, 3,
		<637, 1746, 3927>, 3,
		<637, 3927, 1342>, 3,
		<637, 1342, 3433>, 3,
		<637, 3433, 2650>, 3,
		<637, 2650, 3172>, 3,
		<637, 3172, 2653>, 3,
		<638, 2654, 3470>, 3,
		<638, 3470, 1417>, 3,
		<638, 1417, 3893>, 3,
		<638, 3893, 1752>, 3,
		<638, 1752, 3638>, 3,
		<638, 3638, 2655>, 3,
		<638, 2655, 3173>, 3,
		<638, 3173, 2654>, 3,
		<639, 2655, 3638>, 3,
		<639, 3638, 1753>, 3,
		<639, 1753, 3986>, 3,
		<639, 3986, 1679>, 3,
		<639, 1679, 3601>, 3,
		<639, 3601, 2656>, 3,
		<639, 2656, 3173>, 3,
		<639, 3173, 2655>, 3,
		<640, 2656, 3601>, 3,
		<640, 3601, 1678>, 3,
		<640, 1678, 3978>, 3,
		<640, 3978, 1735>, 3,
		<640, 1735, 3629>, 3,
		<640, 3629, 2657>, 3,
		<640, 2657, 3173>, 3,
		<640, 3173, 2656>, 3,
		<641, 2657, 3629>, 3,
		<641, 3629, 1734>, 3,
		<641, 1734, 3892>, 3,
		<641, 3892, 1416>, 3,
		<641, 1416, 3470>, 3,
		<641, 3470, 2654>, 3,
		<641, 2654, 3173>, 3,
		<641, 3173, 2657>, 3,
		<642, 2658, 3468>, 3,
		<642, 3468, 1413>, 3,
		<642, 1413, 3880>, 3,
		<642, 3880, 1733>, 3,
		<642, 1733, 3628>, 3,
		<642, 3628, 2659>, 3,
		<642, 2659, 3174>, 3,
		<642, 3174, 2658>, 3,
		<643, 2659, 3628>, 3,
		<643, 3628, 1732>, 3,
		<643, 1732, 3976>, 3,
		<643, 3976, 1680>, 3,
		<643, 1680, 3602>, 3,
		<643, 3602, 2660>, 3,
		<643, 2660, 3174>, 3,
		<643, 3174, 2659>, 3,
		<644, 2660, 3602>, 3,
		<644, 3602, 1681>, 3,
		<644, 1681, 3987>, 3,
		<644, 3987, 1754>, 3,
		<644, 1754, 3639>, 3,
		<644, 3639, 2661>, 3,
		<644, 2661, 3174>, 3,
		<644, 3174, 2660>, 3,
		<645, 2661, 3639>, 3,
		<645, 3639, 1755>, 3,
		<645, 1755, 3881>, 3,
		<645, 3881, 1412>, 3,
		<645, 1412, 3468>, 3,
		<645, 3468, 2658>, 3,
		<645, 2658, 3174>, 3,
		<645, 3174, 2661>, 3,
		<646, 2662, 3493>, 3,
		<646, 3493, 1463>, 3,
		<646, 1463, 3894>, 3,
		<646, 3894, 1756>, 3,
		<646, 1756, 3640>, 3,
		<646, 3640, 2663>, 3,
		<646, 2663, 3175>, 3,
		<646, 3175, 2662>, 3,
		<647, 2663, 3640>, 3,
		<647, 3640, 1757>, 3,
		<647, 1757, 3988>, 3,
		<647, 3988, 1683>, 3,
		<647, 1683, 3603>, 3,
		<647, 3603, 2664>, 3,
		<647, 2664, 3175>, 3,
		<647, 3175, 2663>, 3,
		<648, 2664, 3603>, 3,
		<648, 3603, 1682>, 3,
		<648, 1682, 3986>, 3,
		<648, 3986, 1753>, 3,
		<648, 1753, 3638>, 3,
		<648, 3638, 2665>, 3,
		<648, 2665, 3175>, 3,
		<648, 3175, 2664>, 3,
		<649, 2665, 3638>, 3,
		<649, 3638, 1752>, 3,
		<649, 1752, 3893>, 3,
		<649, 3893, 1462>, 3,
		<649, 1462, 3493>, 3,
		<649, 3493, 2662>, 3,
		<649, 2662, 3175>, 3,
		<649, 3175, 2665>, 3,
		<650, 2666, 3491>, 3,
		<650, 3491, 1459>, 3,
		<650, 1459, 3881>, 3,
		<650, 3881, 1755>, 3,
		<650, 1755, 3639>, 3,
		<650, 3639, 2667>, 3,
		<650, 2667, 3176>, 3,
		<650, 3176, 2666>, 3,
		<651, 2667, 3639>, 3,
		<651, 3639, 1754>, 3,
		<651, 1754, 3987>, 3,
		<651, 3987, 1684>, 3,
		<651, 1684, 3604>, 3,
		<651, 3604, 2668>, 3,
		<651, 2668, 3176>, 3,
		<651, 3176, 2667>, 3,
		<652, 2668, 3604>, 3,
		<652, 3604, 1685>, 3,
		<652, 1685, 3989>, 3,
		<652, 3989, 1758>, 3,
		<652, 1758, 3641>, 3,
		<652, 3641, 2669>, 3,
		<652, 2669, 3176>, 3,
		<652, 3176, 2668>, 3,
		<653, 2669, 3641>, 3,
		<653, 3641, 1759>, 3,
		<653, 1759, 3882>, 3,
		<653, 3882, 1458>, 3,
		<653, 1458, 3491>, 3,
		<653, 3491, 2666>, 3,
		<653, 2666, 3176>, 3,
		<653, 3176, 2669>, 3,
		<654, 2670, 3516>, 3,
		<654, 3516, 1509>, 3,
		<654, 1509, 3895>, 3,
		<654, 3895, 1760>, 3,
		<654, 1760, 3642>, 3,
		<654, 3642, 2671>, 3,
		<654, 2671, 3177>, 3,
		<654, 3177, 2670>, 3,
		<655, 2671, 3642>, 3,
		<655, 3642, 1761>, 3,
		<655, 1761, 3990>, 3,
		<655, 3990, 1687>, 3,
		<655, 1687, 3605>, 3,
		<655, 3605, 2672>, 3,
		<655, 2672, 3177>, 3,
		<655, 3177, 2671>, 3,
		<656, 2672, 3605>, 3,
		<656, 3605, 1686>, 3,
		<656, 1686, 3988>, 3,
		<656, 3988, 1757>, 3,
		<656, 1757, 3640>, 3,
		<656, 3640, 2673>, 3,
		<656, 2673, 3177>, 3,
		<656, 3177, 2672>, 3,
		<657, 2673, 3640>, 3,
		<657, 3640, 1756>, 3,
		<657, 1756, 3894>, 3,
		<657, 3894, 1508>, 3,
		<657, 1508, 3516>, 3,
		<657, 3516, 2670>, 3,
		<657, 2670, 3177>, 3,
		<657, 3177, 2673>, 3,
		<658, 2674, 3514>, 3,
		<658, 3514, 1505>, 3,
		<658, 1505, 3882>, 3,
		<658, 3882, 1759>, 3,
		<658, 1759, 3641>, 3,
		<658, 3641, 2675>, 3,
		<658, 2675, 3178>, 3,
		<658, 3178, 2674>, 3,
		<659, 2675, 3641>, 3,
		<659, 3641, 1758>, 3,
		<659, 1758, 3989>, 3,
		<659, 3989, 1688>, 3,
		<659, 1688, 3606>, 3,
		<659, 3606, 2676>, 3,
		<659, 2676, 3178>, 3,
		<659, 3178, 2675>, 3,
		<660, 2676, 3606>, 3,
		<660, 3606, 1689>, 3,
		<660, 1689, 3991>, 3,
		<660, 3991, 1762>, 3,
		<660, 1762, 3643>, 3,
		<660, 3643, 2677>, 3,
		<660, 2677, 3178>, 3,
		<660, 3178, 2676>, 3,
		<661, 2677, 3643>, 3,
		<661, 3643, 1763>, 3,
		<661, 1763, 3883>, 3,
		<661, 3883, 1504>, 3,
		<661, 1504, 3514>, 3,
		<661, 3514, 2674>, 3,
		<661, 2674, 3178>, 3,
		<661, 3178, 2677>, 3,
		<662, 2678, 3539>, 3,
		<662, 3539, 1555>, 3,
		<662, 1555, 3896>, 3,
		<662, 3896, 1764>, 3,
		<662, 1764, 3644>, 3,
		<662, 3644, 2679>, 3,
		<662, 2679, 3179>, 3,
		<662, 3179, 2678>, 3,
		<663, 2679, 3644>, 3,
		<663, 3644, 1765>, 3,
		<663, 1765, 3992>, 3,
		<663, 3992, 1691>, 3,
		<663, 1691, 3607>, 3,
		<663, 3607, 2680>, 3,
		<663, 2680, 3179>, 3,
		<663, 3179, 2679>, 3,
		<664, 2680, 3607>, 3,
		<664, 3607, 1690>, 3,
		<664, 1690, 3990>, 3,
		<664, 3990, 1761>, 3,
		<664, 1761, 3642>, 3,
		<664, 3642, 2681>, 3,
		<664, 2681, 3179>, 3,
		<664, 3179, 2680>, 3,
		<665, 2681, 3642>, 3,
		<665, 3642, 1760>, 3,
		<665, 1760, 3895>, 3,
		<665, 3895, 1554>, 3,
		<665, 1554, 3539>, 3,
		<665, 3539, 2678>, 3,
		<665, 2678, 3179>, 3,
		<665, 3179, 2681>, 3,
		<666, 2682, 3540>, 3,
		<666, 3540, 1557>, 3,
		<666, 1557, 3884>, 3,
		<666, 3884, 1766>, 3,
		<666, 1766, 3645>, 3,
		<666, 3645, 2683>, 3,
		<666, 2683, 3180>, 3,
		<666, 3180, 2682>, 3,
		<667, 2683, 3645>, 3,
		<667, 3645, 1767>, 3,
		<667, 1767, 3993>, 3,
		<667, 3993, 1693>, 3,
		<667, 1693, 3608>, 3,
		<667, 3608, 2684>, 3,
		<667, 2684, 3180>, 3,
		<667, 3180, 2683>, 3,
		<668, 2684, 3608>, 3,
		<668, 3608, 1692>, 3,
		<668, 1692, 3992>, 3,
		<668, 3992, 1765>, 3,
		<668, 1765, 3644>, 3,
		<668, 3644, 2685>, 3,
		<668, 2685, 3180>, 3,
		<668, 3180, 2684>, 3,
		<669, 2685, 3644>, 3,
		<669, 3644, 1764>, 3,
		<669, 1764, 3896>, 3,
		<669, 3896, 1556>, 3,
		<669, 1556, 3540>, 3,
		<669, 3540, 2682>, 3,
		<669, 2682, 3180>, 3,
		<669, 3180, 2685>, 3,
		<670, 2686, 3537>, 3,
		<670, 3537, 1551>, 3,
		<670, 1551, 3883>, 3,
		<670, 3883, 1763>, 3,
		<670, 1763, 3643>, 3,
		<670, 3643, 2687>, 3,
		<670, 2687, 3181>, 3,
		<670, 3181, 2686>, 3,
		<671, 2687, 3643>, 3,
		<671, 3643, 1762>, 3,
		<671, 1762, 3991>, 3,
		<671, 3991, 1694>, 3,
		<671, 1694, 3609>, 3,
		<671, 3609, 2688>, 3,
		<671, 2688, 3181>, 3,
		<671, 3181, 2687>, 3,
		<672, 2688, 3609>, 3,
		<672, 3609, 1695>, 3,
		<672, 1695, 3993>, 3,
		<672, 3993, 1767>, 3,
		<672, 1767, 3645>, 3,
		<672, 3645, 2689>, 3,
		<672, 2689, 3181>, 3,
		<672, 3181, 2688>, 3,
		<673, 2689, 3645>, 3,
		<673, 3645, 1766>, 3,
		<673, 1766, 3884>, 3,
		<673, 3884, 1550>, 3,
		<673, 1550, 3537>, 3,
		<673, 3537, 2686>, 3,
		<673, 2686, 3181>, 3,
		<673, 3181, 2689>, 3,
		<674, 2690, 3312>, 0,
		<674, 3312, 1100>, 0,
		<674, 1100, 3815>, 0,
		<674, 3815, 1769>, 0,
		<674, 1769, 3646>, 0,
		<674, 3646, 2691>, 0,
		<674, 2691, 3182>, 0,
		<674, 3182, 2690>, 0,
		<675, 2691, 3646>, 0,
		<675, 3646, 1768>, 0,
		<675, 1768, 3771>, 0,
		<675, 3771, 1008>, 0,
		<675, 1008, 3266>, 0,
		<675, 3266, 2692>, 0,
		<675, 2692, 3182>, 0,
		<675, 3182, 2691>, 0,
		<676, 2692, 3266>, 0,
		<676, 3266, 1009>, 0,
		<676, 1009, 3770>, 0,
		<676, 3770, 1771>, 0,
		<676, 1771, 3647>, 0,
		<676, 3647, 2693>, 0,
		<676, 2693, 3182>, 0,
		<676, 3182, 2692>, 0,
		<677, 2693, 3647>, 0,
		<677, 3647, 1770>, 0,
		<677, 1770, 3814>, 0,
		<677, 3814, 1101>, 0,
		<677, 1101, 3312>, 0,
		<677, 3312, 2690>, 0,
		<677, 2690, 3182>, 0,
		<677, 3182, 2693>, 0,
		<678, 2694, 3313>, 0,
		<678, 3313, 1102>, 0,
		<678, 1102, 3814>, 0,
		<678, 3814, 1770>, 0,
		<678, 1770, 3647>, 0,
		<678, 3647, 2695>, 0,
		<678, 2695, 3183>, 0,
		<678, 3183, 2694>, 0,
		<679, 2695, 3647>, 0,
		<679, 3647, 1771>, 0,
		<679, 1771, 3770>, 0,
		<679, 3770, 1010>, 0,
		<679, 1010, 3267>, 0,
		<679, 3267, 2696>, 0,
		<679, 2696, 3183>, 0,
		<679, 3183, 2695>, 0,
		<680, 2696, 3267>, 0,
		<680, 3267, 1011>, 0,
		<680, 1011, 3782>, 0,
		<680, 3782, 1773>, 0,
		<680, 1773, 3648>, 0,
		<680, 3648, 2697>, 0,
		<680, 2697, 3183>, 0,
		<680, 3183, 2696>, 0,
		<681, 2697, 3648>, 0,
		<681, 3648, 1772>, 0,
		<681, 1772, 3826>, 0,
		<681, 3826, 1103>, 0,
		<681, 1103, 3313>, 0,
		<681, 3313, 2694>, 0,
		<681, 2694, 3183>, 0,
		<681, 3183, 2697>, 0,
		<682, 2698, 3316>, 0,
		<682, 3316, 1108>, 0,
		<682, 1108, 3826>, 0,
		<682, 3826, 1772>, 0,
		<682, 1772, 3648>, 0,
		<682, 3648, 2699>, 0,
		<682, 2699, 3184>, 0,
		<682, 3184, 2698>, 0,
		<683, 2699, 3648>, 0,
		<683, 3648, 1773>, 0,
		<683, 1773, 3782>, 0,
		<683, 3782, 1012>, 0,
		<683, 1012, 3268>, 0,
		<683, 3268, 2700>, 0,
		<683, 2700, 3184>, 0,
		<683, 3184, 2699>, 0,
		<684, 2700, 3268>, 0,
		<684, 3268, 1013>, 0,
		<684, 1013, 3784>, 0,
		<684, 3784, 1775>, 0,
		<684, 1775, 3649>, 0,
		<684, 3649, 2701>, 0,
		<684, 2701, 3184>, 0,
		<684, 3184, 2700>, 0,
		<685, 2701, 3649>, 0,
		<685, 3649, 1774>, 0,
		<685, 1774, 3838>, 0,
		<685, 3838, 1109>, 0,
		<685, 1109, 3316>, 0,
		<685, 3316, 2698>, 0,
		<685, 2698, 3184>, 0,
		<685, 3184, 2701>, 0,
		<686, 2702, 3319>, 0,
		<686, 3319, 1114>, 0,
		<686, 1114, 3838>, 0,
		<686, 3838, 1774>, 0,
		<686, 1774, 3649>, 0,
		<686, 3649, 2703>, 0,
		<686, 2703, 3185>, 0,
		<686, 3185, 2702>, 0,
		<687, 2703, 3649>, 0,
		<687, 3649, 1775>, 0,
		<687, 1775, 3784>, 0,
		<687, 3784, 1014>, 0,
		<687, 1014, 3269>, 0,
		<687, 3269, 2704>, 0,
		<687, 2704, 3185>, 0,
		<687, 3185, 2703>, 0,
		<688, 2704, 3269>, 0,
		<688, 3269, 1015>, 0,
		<688, 1015, 3786>, 0,
		<688, 3786, 1777>, 0,
		<688, 1777, 3650>, 0,
		<688, 3650, 2705>, 0,
		<688, 2705, 3185>, 0,
		<688, 3185, 2704>, 0,
		<689, 2705, 3650>, 0,
		<689, 3650, 1776>, 0,
		<689, 1776, 3850>, 0,
		<689, 3850, 1115>, 0,
		<689, 1115, 3319>, 0,
		<689, 3319, 2702>, 0,
		<689, 2702, 3185>, 0,
		<689, 3185, 2705>, 0,
		<690, 2706, 3322>, 0,
		<690, 3322, 1120>, 0,
		<690, 1120, 3850>, 0,
		<690, 3850, 1776>, 0,
		<690, 1776, 3650>, 0,
		<690, 3650, 2707>, 0,
		<690, 2707, 3186>, 0,
		<690, 3186, 2706>, 0,
		<691, 2707, 3650>, 0,
		<691, 3650, 1777>, 0,
		<691, 1777, 3786>, 0,
		<691, 3786, 1016>, 0,
		<691, 1016, 3270>, 0,
		<691, 3270, 2708>, 0,
		<691, 2708, 3186>, 0,
		<691, 3186, 2707>, 0,
		<692, 2708, 3270>, 0,
		<692, 3270, 1017>, 0,
		<692, 1017, 3788>, 0,
		<692, 3788, 1779>, 0,
		<692, 1779, 3651>, 0,
		<692, 3651, 2709>, 0,
		<692, 2709, 3186>, 0,
		<692, 3186, 2708>, 0,
		<693, 2709, 3651>, 0,
		<693, 3651, 1778>, 0,
		<693, 1778, 3862>, 0,
		<693, 3862, 1121>, 0,
		<693, 1121, 3322>, 0,
		<693, 3322, 2706>, 0,
		<693, 2706, 3186>, 0,
		<693, 3186, 2709>, 0,
		<694, 2710, 3325>, 0,
		<694, 3325, 1126>, 0,
		<694, 1126, 3862>, 0,
		<694, 3862, 1778>, 0,
		<694, 1778, 3651>, 0,
		<694, 3651, 2711>, 0,
		<694, 2711, 3187>, 0,
		<694, 3187, 2710>, 0,
		<695, 2711, 3651>, 0,
		<695, 3651, 1779>, 0,
		<695, 1779, 3788>, 0,
		<695, 3788, 1018>, 0,
		<695, 1018, 3271>, 0,
		<695, 3271, 2712>, 0,
		<695, 2712, 3187>, 0,
		<695, 3187, 2711>, 0,
		<696, 2712, 3271>, 0,
		<696, 3271, 1019>, 0,
		<696, 1019, 3790>, 0,
		<696, 3790, 1781>, 0,
		<696, 1781, 3652>, 0,
		<696, 3652, 2713>, 0,
		<696, 2713, 3187>, 0,
		<696, 3187, 2712>, 0,
		<697, 2713, 3652>, 0,
		<697, 3652, 1780>, 0,
		<697, 1780, 3874>, 0,
		<697, 3874, 1127>, 0,
		<697, 1127, 3325>, 0,
		<697, 3325, 2710>, 0,
		<697, 2710, 3187>, 0,
		<697, 3187, 2713>, 0,
		<698, 2714, 3328>, 0,
		<698, 3328, 1132>, 0,
		<698, 1132, 3874>, 0,
		<698, 3874, 1780>, 0,
		<698, 1780, 3652>, 0,
		<698, 3652, 2715>, 0,
		<698, 2715, 3188>, 0,
		<698, 3188, 2714>, 0,
		<699, 2715, 3652>, 0,
		<699, 3652, 1781>, 0,
		<699, 1781, 3790>, 0,
		<699, 3790, 1020>, 0,
		<699, 1020, 3272>, 0,
		<699, 3272, 2716>, 0,
		<699, 2716, 3188>, 0,
		<699, 3188, 2715>, 0,
		<700, 2716, 3272>, 0,
		<700, 3272, 1021>, 0,
		<700, 1021, 3792>, 0,
		<700, 3792, 1783>, 0,
		<700, 1783, 3653>, 0,
		<700, 3653, 2717>, 0,
		<700, 2717, 3188>, 0,
		<700, 3188, 2716>, 0,
		<701, 2717, 3653>, 0,
		<701, 3653, 1782>, 0,
		<701, 1782, 3886>, 0,
		<701, 3886, 1133>, 0,
		<701, 1133, 3328>, 0,
		<701, 3328, 2714>, 0,
		<701, 2714, 3188>, 0,
		<701, 3188, 2717>, 0,
		<702, 2718, 3331>, 0,
		<702, 3331, 1138>, 0,
		<702, 1138, 3886>, 0,
		<702, 3886, 1782>, 0,
		<702, 1782, 3653>, 0,
		<702, 3653, 2719>, 0,
		<702, 2719, 3189>, 0,
		<702, 3189, 2718>, 0,
		<703, 2719, 3653>, 0,
		<703, 3653, 1783>, 0,
		<703, 1783, 3792>, 0,
		<703, 3792, 1022>, 0,
		<703, 1022, 3273>, 0,
		<703, 3273, 2720>, 0,
		<703, 2720, 3189>, 0,
		<703, 3189, 2719>, 0,
		<704, 2720, 3273>, 0,
		<704, 3273, 1023>, 0,
		<704, 1023, 3794>, 0,
		<704, 3794, 1785>, 0,
		<704, 1785, 3654>, 0,
		<704, 3654, 2721>, 0,
		<704, 2721, 3189>, 0,
		<704, 3189, 2720>, 0,
		<705, 2721, 3654>, 0,
		<705, 3654, 1784>, 0,
		<705, 1784, 3898>, 0,
		<705, 3898, 1139>, 0,
		<705, 1139, 3331>, 0,
		<705, 3331, 2718>, 0,
		<705, 2718, 3189>, 0,
		<705, 3189, 2721>, 0,
		<706, 2722, 3334>, 0,
		<706, 3334, 1144>, 0,
		<706, 1144, 3898>, 0,
		<706, 3898, 1784>, 0,
		<706, 1784, 3654>, 0,
		<706, 3654, 2723>, 0,
		<706, 2723, 3190>, 0,
		<706, 3190, 2722>, 0,
		<707, 2723, 3654>, 0,
		<707, 3654, 1785>, 0,
		<707, 1785, 3794>, 0,
		<707, 3794, 1024>, 0,
		<707, 1024, 3274>, 0,
		<707, 3274, 2724>, 0,
		<707, 2724, 3190>, 0,
		<707, 3190, 2723>, 0,
		<708, 2724, 3274>, 0,
		<708, 3274, 1025>, 0,
		<708, 1025, 3796>, 0,
		<708, 3796, 1787>, 0,
		<708, 1787, 3655>, 0,
		<708, 3655, 2725>, 0,
		<708, 2725, 3190>, 0,
		<708, 3190, 2724>, 0,
		<709, 2725, 3655>, 0,
		<709, 3655, 1786>, 0,
		<709, 1786, 3910>, 0,
		<709, 3910, 1145>, 0,
		<709, 1145, 3334>, 0,
		<709, 3334, 2722>, 0,
		<709, 2722, 3190>, 0,
		<709, 3190, 2725>, 0,
		<710, 2726, 3337>, 0,
		<710, 3337, 1150>, 0,
		<710, 1150, 3910>, 0,
		<710, 3910, 1786>, 0,
		<710, 1786, 3655>, 0,
		<710, 3655, 2727>, 0,
		<710, 2727, 3191>, 0,
		<710, 3191, 2726>, 0,
		<711, 2727, 3655>, 0,
		<711, 3655, 1787>, 0,
		<711, 1787, 3796>, 0,
		<711, 3796, 1026>, 0,
		<711, 1026, 3275>, 0,
		<711, 3275, 2728>, 0,
		<711, 2728, 3191>, 0,
		<711, 3191, 2727>, 0,
		<712, 2728, 3275>, 0,
		<712, 3275, 1027>, 0,
		<712, 1027, 3798>, 0,
		<712, 3798, 1789>, 0,
		<712, 1789, 3656>, 0,
		<712, 3656, 2729>, 0,
		<712, 2729, 3191>, 0,
		<712, 3191, 2728>, 0,
		<713, 2729, 3656>, 0,
		<713, 3656, 1788>, 0,
		<713, 1788, 3922>, 0,
		<713, 3922, 1151>, 0,
		<713, 1151, 3337>, 0,
		<713, 3337, 2726>, 0,
		<713, 2726, 3191>, 0,
		<713, 3191, 2729>, 0,
		<714, 2730, 3340>, 0,
		<714, 3340, 1156>, 0,
		<714, 1156, 3922>, 0,
		<714, 3922, 1788>, 0,
		<714, 1788, 3656>, 0,
		<714, 3656, 2731>, 0,
		<714, 2731, 3192>, 0,
		<714, 3192, 2730>, 0,
		<715, 2731, 3656>, 0,
		<715, 3656, 1789>, 0,
		<715, 1789, 3798>, 0,
		<715, 3798, 1028>, 0,
		<715, 1028, 3276>, 0,
		<715, 3276, 2732>, 0,
		<715, 2732, 3192>, 0,
		<715, 3192, 2731>, 0,
		<716, 2732, 3276>, 0,
		<716, 3276, 1029>, 0,
		<716, 1029, 3800>, 0,
		<716, 3800, 1791>, 0,
		<716, 1791, 3657>, 0,
		<716, 3657, 2733>, 0,
		<716, 2733, 3192>, 0,
		<716, 3192, 2732>, 0,
		<717, 2733, 3657>, 0,
		<717, 3657, 1790>, 0,
		<717, 1790, 3934>, 0,
		<717, 3934, 1157>, 0,
		<717, 1157, 3340>, 0,
		<717, 3340, 2730>, 0,
		<717, 2730, 3192>, 0,
		<717, 3192, 2733>, 0,
		<718, 2734, 3341>, 0,
		<718, 3341, 1158>, 0,
		<718, 1158, 3946>, 0,
		<718, 3946, 1793>, 0,
		<718, 1793, 3658>, 0,
		<718, 3658, 2735>, 0,
		<718, 2735, 3193>, 0,
		<718, 3193, 2734>, 0,
		<719, 2735, 3658>, 0,
		<719, 3658, 1792>, 0,
		<719, 1792, 3802>, 0,
		<719, 3802, 1030>, 0,
		<719, 1030, 3277>, 0,
		<719, 3277, 2736>, 0,
		<719, 2736, 3193>, 0,
		<719, 3193, 2735>, 0,
		<720, 2736, 3277>, 0,
		<720, 3277, 1031>, 0,
		<720, 1031, 3803>, 0,
		<720, 3803, 1795>, 0,
		<720, 1795, 3659>, 0,
		<720, 3659, 2737>, 0,
		<720, 2737, 3193>, 0,
		<720, 3193, 2736>, 0,
		<721, 2737, 3659>, 0,
		<721, 3659, 1794>, 0,
		<721, 1794, 3947>, 0,
		<721, 3947, 1159>, 0,
		<721, 1159, 3341>, 0,
		<721, 3341, 2734>, 0,
		<721, 2734, 3193>, 0,
		<721, 3193, 2737>, 0,
		<722, 2738, 3343>, 0,
		<722, 3343, 1162>, 0,
		<722, 1162, 3934>, 0,
		<722, 3934, 1790>, 0,
		<722, 1790, 3657>, 0,
		<722, 3657, 2739>, 0,
		<722, 2739, 3194>, 0,
		<722, 3194, 2738>, 0,
		<723, 2739, 3657>, 0,
		<723, 3657, 1791>, 0,
		<723, 1791, 3800>, 0,
		<723, 3800, 1032>, 0,
		<723, 1032, 3278>, 0,
		<723, 3278, 2740>, 0,
		<723, 2740, 3194>, 0,
		<723, 3194, 2739>, 0,
		<724, 2740, 3278>, 0,
		<724, 3278, 1033>, 0,
		<724, 1033, 3802>, 0,
		<724, 3802, 1792>, 0,
		<724, 1792, 3658>, 0,
		<724, 3658, 2741>, 0,
		<724, 2741, 3194>, 0,
		<724, 3194, 2740>, 0,
		<725, 2741, 3658>, 0,
		<725, 3658, 1793>, 0,
		<725, 1793, 3946>, 0,
		<725, 3946, 1163>, 0,
		<725, 1163, 3343>, 0,
		<725, 3343, 2738>, 0,
		<725, 2738, 3194>, 0,
		<725, 3194, 2741>, 0,
		<726, 2742, 3346>, 0,
		<726, 3346, 1168>, 0,
		<726, 1168, 3816>, 0,
		<726, 3816, 1797>, 0,
		<726, 1797, 3660>, 0,
		<726, 3660, 2743>, 0,
		<726, 2743, 3195>, 0,
		<726, 3195, 2742>, 0,
		<727, 2743, 3660>, 0,
		<727, 3660, 1796>, 0,
		<727, 1796, 3772>, 0,
		<727, 3772, 1034>, 0,
		<727, 1034, 3279>, 0,
		<727, 3279, 2744>, 0,
		<727, 2744, 3195>, 0,
		<727, 3195, 2743>, 0,
		<728, 2744, 3279>, 0,
		<728, 3279, 1035>, 0,
		<728, 1035, 3771>, 0,
		<728, 3771, 1768>, 0,
		<728, 1768, 3646>, 0,
		<728, 3646, 2745>, 0,
		<728, 2745, 3195>, 0,
		<728, 3195, 2744>, 0,
		<729, 2745, 3646>, 0,
		<729, 3646, 1769>, 0,
		<729, 1769, 3815>, 0,
		<729, 3815, 1169>, 0,
		<729, 1169, 3346>, 0,
		<729, 3346, 2742>, 0,
		<729, 2742, 3195>, 0,
		<729, 3195, 2745>, 0,
		<730, 2746, 3365>, 0,
		<730, 3365, 1206>, 0,
		<730, 1206, 3947>, 0,
		<730, 3947, 1794>, 0,
		<730, 1794, 3659>, 0,
		<730, 3659, 2747>, 0,
		<730, 2747, 3196>, 0,
		<730, 3196, 2746>, 0,
		<731, 2747, 3659>, 0,
		<731, 3659, 1795>, 0,
		<731, 1795, 3803>, 0,
		<731, 3803, 1036>, 0,
		<731, 1036, 3280>, 0,
		<731, 3280, 2748>, 0,
		<731, 2748, 3196>, 0,
		<731, 3196, 2747>, 0,
		<732, 2748, 3280>, 0,
		<732, 3280, 1037>, 0,
		<732, 1037, 3804>, 0,
		<732, 3804, 1799>, 0,
		<732, 1799, 3661>, 0,
		<732, 3661, 2749>, 0,
		<732, 2749, 3196>, 0,
		<732, 3196, 2748>, 0,
		<733, 2749, 3661>, 0,
		<733, 3661, 1798>, 0,
		<733, 1798, 3948>, 0,
		<733, 3948, 1207>, 0,
		<733, 1207, 3365>, 0,
		<733, 3365, 2746>, 0,
		<733, 2746, 3196>, 0,
		<733, 3196, 2749>, 0,
		<734, 2750, 3369>, 0,
		<734, 3369, 1214>, 0,
		<734, 1214, 3817>, 0,
		<734, 3817, 1801>, 0,
		<734, 1801, 3662>, 0,
		<734, 3662, 2751>, 0,
		<734, 2751, 3197>, 0,
		<734, 3197, 2750>, 0,
		<735, 2751, 3662>, 0,
		<735, 3662, 1800>, 0,
		<735, 1800, 3773>, 0,
		<735, 3773, 1038>, 0,
		<735, 1038, 3281>, 0,
		<735, 3281, 2752>, 0,
		<735, 2752, 3197>, 0,
		<735, 3197, 2751>, 0,
		<736, 2752, 3281>, 0,
		<736, 3281, 1039>, 0,
		<736, 1039, 3772>, 0,
		<736, 3772, 1796>, 0,
		<736, 1796, 3660>, 0,
		<736, 3660, 2753>, 0,
		<736, 2753, 3197>, 0,
		<736, 3197, 2752>, 0,
		<737, 2753, 3660>, 0,
		<737, 3660, 1797>, 0,
		<737, 1797, 3816>, 0,
		<737, 3816, 1215>, 0,
		<737, 1215, 3369>, 0,
		<737, 3369, 2750>, 0,
		<737, 2750, 3197>, 0,
		<737, 3197, 2753>, 0,
		<738, 2754, 3388>, 0,
		<738, 3388, 1252>, 0,
		<738, 1252, 3948>, 0,
		<738, 3948, 1798>, 0,
		<738, 1798, 3661>, 0,
		<738, 3661, 2755>, 0,
		<738, 2755, 3198>, 0,
		<738, 3198, 2754>, 0,
		<739, 2755, 3661>, 0,
		<739, 3661, 1799>, 0,
		<739, 1799, 3804>, 0,
		<739, 3804, 1040>, 0,
		<739, 1040, 3282>, 0,
		<739, 3282, 2756>, 0,
		<739, 2756, 3198>, 0,
		<739, 3198, 2755>, 0,
		<740, 2756, 3282>, 0,
		<740, 3282, 1041>, 0,
		<740, 1041, 3805>, 0,
		<740, 3805, 1803>, 0,
		<740, 1803, 3663>, 0,
		<740, 3663, 2757>, 0,
		<740, 2757, 3198>, 0,
		<740, 3198, 2756>, 0,
		<741, 2757, 3663>, 0,
		<741, 3663, 1802>, 0,
		<741, 1802, 3949>, 0,
		<741, 3949, 1253>, 0,
		<741, 1253, 3388>, 0,
		<741, 3388, 2754>, 0,
		<741, 2754, 3198>, 0,
		<741, 3198, 2757>, 0,
		<742, 2758, 3392>, 0,
		<742, 3392, 1260>, 0,
		<742, 1260, 3818>, 0,
		<742, 3818, 1805>, 0,
		<742, 1805, 3664>, 0,
		<742, 3664, 2759>, 0,
		<742, 2759, 3199>, 0,
		<742, 3199, 2758>, 0,
		<743, 2759, 3664>, 0,
		<743, 3664, 1804>, 0,
		<743, 1804, 3774>, 0,
		<743, 3774, 1042>, 0,
		<743, 1042, 3283>, 0,
		<743, 3283, 2760>, 0,
		<743, 2760, 3199>, 0,
		<743, 3199, 2759>, 0,
		<744, 2760, 3283>, 0,
		<744, 3283, 1043>, 0,
		<744, 1043, 3773>, 0,
		<744, 3773, 1800>, 0,
		<744, 1800, 3662>, 0,
		<744, 3662, 2761>, 0,
		<744, 2761, 3199>, 0,
		<744, 3199, 2760>, 0,
		<745, 2761, 3662>, 0,
		<745, 3662, 1801>, 0,
		<745, 1801, 3817>, 0,
		<745, 3817, 1261>, 0,
		<745, 1261, 3392>, 0,
		<745, 3392, 2758>, 0,
		<745, 2758, 3199>, 0,
		<745, 3199, 2761>, 0,
		<746, 2762, 3411>, 0,
		<746, 3411, 1298>, 0,
		<746, 1298, 3949>, 0,
		<746, 3949, 1802>, 0,
		<746, 1802, 3663>, 0,
		<746, 3663, 2763>, 0,
		<746, 2763, 3200>, 0,
		<746, 3200, 2762>, 0,
		<747, 2763, 3663>, 0,
		<747, 3663, 1803>, 0,
		<747, 1803, 3805>, 0,
		<747, 3805, 1044>, 0,
		<747, 1044, 3284>, 0,
		<747, 3284, 2764>, 0,
		<747, 2764, 3200>, 0,
		<747, 3200, 2763>, 0,
		<748, 2764, 3284>, 0,
		<748, 3284, 1045>, 0,
		<748, 1045, 3806>, 0,
		<748, 3806, 1807>, 0,
		<748, 1807, 3665>, 0,
		<748, 3665, 2765>, 0,
		<748, 2765, 3200>, 0,
		<748, 3200, 2764>, 0,
		<749, 2765, 3665>, 0,
		<749, 3665, 1806>, 0,
		<749, 1806, 3950>, 0,
		<749, 3950, 1299>, 0,
		<749, 1299, 3411>, 0,
		<749, 3411, 2762>, 0,
		<749, 2762, 3200>, 0,
		<749, 3200, 2765>, 0,
		<750, 2766, 3415>, 0,
		<750, 3415, 1306>, 0,
		<750, 1306, 3819>, 0,
		<750, 3819, 1809>, 0,
		<750, 1809, 3666>, 0,
		<750, 3666, 2767>, 0,
		<750, 2767, 3201>, 0,
		<750, 3201, 2766>, 0,
		<751, 2767, 3666>, 0,
		<751, 3666, 1808>, 0,
		<751, 1808, 3775>, 0,
		<751, 3775, 1046>, 0,
		<751, 1046, 3285>, 0,
		<751, 3285, 2768>, 0,
		<751, 2768, 3201>, 0,
		<751, 3201, 2767>, 0,
		<752, 2768, 3285>, 0,
		<752, 3285, 1047>, 0,
		<752, 1047, 3774>, 0,
		<752, 3774, 1804>, 0,
		<752, 1804, 3664>, 0,
		<752, 3664, 2769>, 0,
		<752, 2769, 3201>, 0,
		<752, 3201, 2768>, 0,
		<753, 2769, 3664>, 0,
		<753, 3664, 1805>, 0,
		<753, 1805, 3818>, 0,
		<753, 3818, 1307>, 0,
		<753, 1307, 3415>, 0,
		<753, 3415, 2766>, 0,
		<753, 2766, 3201>, 0,
		<753, 3201, 2769>, 0,
		<754, 2770, 3434>, 0,
		<754, 3434, 1344>, 0,
		<754, 1344, 3950>, 0,
		<754, 3950, 1806>, 0,
		<754, 1806, 3665>, 0,
		<754, 3665, 2771>, 0,
		<754, 2771, 3202>, 0,
		<754, 3202, 2770>, 0,
		<755, 2771, 3665>, 0,
		<755, 3665, 1807>, 0,
		<755, 1807, 3806>, 0,
		<755, 3806, 1048>, 0,
		<755, 1048, 3286>, 0,
		<755, 3286, 2772>, 0,
		<755, 2772, 3202>, 0,
		<755, 3202, 2771>, 0,
		<756, 2772, 3286>, 0,
		<756, 3286, 1049>, 0,
		<756, 1049, 3807>, 0,
		<756, 3807, 1811>, 0,
		<756, 1811, 3667>, 0,
		<756, 3667, 2773>, 0,
		<756, 2773, 3202>, 0,
		<756, 3202, 2772>, 0,
		<757, 2773, 3667>, 0,
		<757, 3667, 1810>, 0,
		<757, 1810, 3951>, 0,
		<757, 3951, 1345>, 0,
		<757, 1345, 3434>, 0,
		<757, 3434, 2770>, 0,
		<757, 2770, 3202>, 0,
		<757, 3202, 2773>, 0,
		<758, 2774, 3438>, 0,
		<758, 3438, 1352>, 0,
		<758, 1352, 3820>, 0,
		<758, 3820, 1813>, 0,
		<758, 1813, 3668>, 0,
		<758, 3668, 2775>, 0,
		<758, 2775, 3203>, 0,
		<758, 3203, 2774>, 0,
		<759, 2775, 3668>, 0,
		<759, 3668, 1812>, 0,
		<759, 1812, 3776>, 0,
		<759, 3776, 1050>, 0,
		<759, 1050, 3287>, 0,
		<759, 3287, 2776>, 0,
		<759, 2776, 3203>, 0,
		<759, 3203, 2775>, 0,
		<760, 2776, 3287>, 0,
		<760, 3287, 1051>, 0,
		<760, 1051, 3775>, 0,
		<760, 3775, 1808>, 0,
		<760, 1808, 3666>, 0,
		<760, 3666, 2777>, 0,
		<760, 2777, 3203>, 0,
		<760, 3203, 2776>, 0,
		<761, 2777, 3666>, 0,
		<761, 3666, 1809>, 0,
		<761, 1809, 3819>, 0,
		<761, 3819, 1353>, 0,
		<761, 1353, 3438>, 0,
		<761, 3438, 2774>, 0,
		<761, 2774, 3203>, 0,
		<761, 3203, 2777>, 0,
		<762, 2778, 3457>, 0,
		<762, 3457, 1390>, 0,
		<762, 1390, 3951>, 0,
		<762, 3951, 1810>, 0,
		<762, 1810, 3667>, 0,
		<762, 3667, 2779>, 0,
		<762, 2779, 3204>, 0,
		<762, 3204, 2778>, 0,
		<763, 2779, 3667>, 0,
		<763, 3667, 1811>, 0,
		<763, 1811, 3807>, 0,
		<763, 3807, 1052>, 0,
		<763, 1052, 3288>, 0,
		<763, 3288, 2780>, 0,
		<763, 2780, 3204>, 0,
		<763, 3204, 2779>, 0,
		<764, 2780, 3288>, 0,
		<764, 3288, 1053>, 0,
		<764, 1053, 3808>, 0,
		<764, 3808, 1815>, 0,
		<764, 1815, 3669>, 0,
		<764, 3669, 2781>, 0,
		<764, 2781, 3204>, 0,
		<764, 3204, 2780>, 0,
		<765, 2781, 3669>, 0,
		<765, 3669, 1814>, 0,
		<765, 1814, 3952>, 0,
		<765, 3952, 1391>, 0,
		<765, 1391, 3457>, 0,
		<765, 3457, 2778>, 0,
		<765, 2778, 3204>, 0,
		<765, 3204, 2781>, 0,
		<766, 2782, 3461>, 0,
		<766, 3461, 1398>, 0,
		<766, 1398, 3821>, 0,
		<766, 3821, 1817>, 0,
		<766, 1817, 3670>, 0,
		<766, 3670, 2783>, 0,
		<766, 2783, 3205>, 0,
		<766, 3205, 2782>, 0,
		<767, 2783, 3670>, 0,
		<767, 3670, 1816>, 0,
		<767, 1816, 3777>, 0,
		<767, 3777, 1054>, 0,
		<767, 1054, 3289>, 0,
		<767, 3289, 2784>, 0,
		<767, 2784, 3205>, 0,
		<767, 3205, 2783>, 0,
		<768, 2784, 3289>, 0,
		<768, 3289, 1055>, 0,
		<768, 1055, 3776>, 0,
		<768, 3776, 1812>, 0,
		<768, 1812, 3668>, 0,
		<768, 3668, 2785>, 0,
		<768, 2785, 3205>, 0,
		<768, 3205, 2784>, 0,
		<769, 2785, 3668>, 0,
		<769, 3668, 1813>, 0,
		<769, 1813, 3820>, 0,
		<769, 3820, 1399>, 0,
		<769, 1399, 3461>, 0,
		<769, 3461, 2782>, 0,
		<769, 2782, 3205>, 0,
		<769, 3205, 2785>, 0,
		<770, 2786, 3480>, 0,
		<770, 3480, 1436>, 0,
		<770, 1436, 3952>, 0,
		<770, 3952, 1814>, 0,
		<770, 1814, 3669>, 0,
		<770, 3669, 2787>, 0,
		<770, 2787, 3206>, 0,
		<770, 3206, 2786>, 0,
		<771, 2787, 3669>, 0,
		<771, 3669, 1815>, 0,
		<771, 1815, 3808>, 0,
		<771, 3808, 1056>, 0,
		<771, 1056, 3290>, 0,
		<771, 3290, 2788>, 0,
		<771, 2788, 3206>, 0,
		<771, 3206, 2787>, 0,
		<772, 2788, 3290>, 0,
		<772, 3290, 1057>, 0,
		<772, 1057, 3809>, 0,
		<772, 3809, 1819>, 0,
		<772, 1819, 3671>, 0,
		<772, 3671, 2789>, 0,
		<772, 2789, 3206>, 0,
		<772, 3206, 2788>, 0,
		<773, 2789, 3671>, 0,
		<773, 3671, 1818>, 0,
		<773, 1818, 3953>, 0,
		<773, 3953, 1437>, 0,
		<773, 1437, 3480>, 0,
		<773, 3480, 2786>, 0,
		<773, 2786, 3206>, 0,
		<773, 3206, 2789>, 0,
		<774, 2790, 3484>, 0,
		<774, 3484, 1444>, 0,
		<774, 1444, 3822>, 0,
		<774, 3822, 1821>, 0,
		<774, 1821, 3672>, 0,
		<774, 3672, 2791>, 0,
		<774, 2791, 3207>, 0,
		<774, 3207, 2790>, 0,
		<775, 2791, 3672>, 0,
		<775, 3672, 1820>, 0,
		<775, 1820, 3778>, 0,
		<775, 3778, 1058>, 0,
		<775, 1058, 3291>, 0,
		<775, 3291, 2792>, 0,
		<775, 2792, 3207>, 0,
		<775, 3207, 2791>, 0,
		<776, 2792, 3291>, 0,
		<776, 3291, 1059>, 0,
		<776, 1059, 3777>, 0,
		<776, 3777, 1816>, 0,
		<776, 1816, 3670>, 0,
		<776, 3670, 2793>, 0,
		<776, 2793, 3207>, 0,
		<776, 3207, 2792>, 0,
		<777, 2793, 3670>, 0,
		<777, 3670, 1817>, 0,
		<777, 1817, 3821>, 0,
		<777, 3821, 1445>, 0,
		<777, 1445, 3484>, 0,
		<777, 3484, 2790>, 0,
		<777, 2790, 3207>, 0,
		<777, 3207, 2793>, 0,
		<778, 2794, 3503>, 0,
		<778, 3503, 1482>, 0,
		<778, 1482, 3953>, 0,
		<778, 3953, 1818>, 0,
		<778, 1818, 3671>, 0,
		<778, 3671, 2795>, 0,
		<778, 2795, 3208>, 0,
		<778, 3208, 2794>, 0,
		<779, 2795, 3671>, 0,
		<779, 3671, 1819>, 0,
		<779, 1819, 3809>, 0,
		<779, 3809, 1060>, 0,
		<779, 1060, 3292>, 0,
		<779, 3292, 2796>, 0,
		<779, 2796, 3208>, 0,
		<779, 3208, 2795>, 0,
		<780, 2796, 3292>, 0,
		<780, 3292, 1061>, 0,
		<780, 1061, 3810>, 0,
		<780, 3810, 1823>, 0,
		<780, 1823, 3673>, 0,
		<780, 3673, 2797>, 0,
		<780, 2797, 3208>, 0,
		<780, 3208, 2796>, 0,
		<781, 2797, 3673>, 0,
		<781, 3673, 1822>, 0,
		<781, 1822, 3954>, 0,
		<781, 3954, 1483>, 0,
		<781, 1483, 3503>, 0,
		<781, 3503, 2794>, 0,
		<781, 2794, 3208>, 0,
		<781, 3208, 2797>, 0,
		<782, 2798, 3507>, 0,
		<782, 3507, 1490>, 0,
		<782, 1490, 3823>, 0,
		<782, 3823, 1825>, 0,
		<782, 1825, 3674>, 0,
		<782, 3674, 2799>, 0,
		<782, 2799, 3209>, 0,
		<782, 3209, 2798>, 0,
		<783, 2799, 3674>, 0,
		<783, 3674, 1824>, 0,
		<783, 1824, 3779>, 0,
		<783, 3779, 1062>, 0,
		<783, 1062, 3293>, 0,
		<783, 3293, 2800>, 0,
		<783, 2800, 3209>, 0,
		<783, 3209, 2799>, 0,
		<784, 2800, 3293>, 0,
		<784, 3293, 1063>, 0,
		<784, 1063, 3778>, 0,
		<784, 3778, 1820>, 0,
		<784, 1820, 3672>, 0,
		<784, 3672, 2801>, 0,
		<784, 2801, 3209>, 0,
		<784, 3209, 2800>, 0,
		<785, 2801, 3672>, 0,
		<785, 3672, 1821>, 0,
		<785, 1821, 3822>, 0,
		<785, 3822, 1491>, 0,
		<785, 1491, 3507>, 0,
		<785, 3507, 2798>, 0,
		<785, 2798, 3209>, 0,
		<785, 3209, 2801>, 0,
		<786, 2802, 3526>, 0,
		<786, 3526, 1528>, 0,
		<786, 1528, 3954>, 0,
		<786, 3954, 1822>, 0,
		<786, 1822, 3673>, 0,
		<786, 3673, 2803>, 0,
		<786, 2803, 3210>, 0,
		<786, 3210, 2802>, 0,
		<787, 2803, 3673>, 0,
		<787, 3673, 1823>, 0,
		<787, 1823, 3810>, 0,
		<787, 3810, 1064>, 0,
		<787, 1064, 3294>, 0,
		<787, 3294, 2804>, 0,
		<787, 2804, 3210>, 0,
		<787, 3210, 2803>, 0,
		<788, 2804, 3294>, 0,
		<788, 3294, 1065>, 0,
		<788, 1065, 3811>, 0,
		<788, 3811, 1827>, 0,
		<788, 1827, 3675>, 0,
		<788, 3675, 2805>, 0,
		<788, 2805, 3210>, 0,
		<788, 3210, 2804>, 0,
		<789, 2805, 3675>, 0,
		<789, 3675, 1826>, 0,
		<789, 1826, 3955>, 0,
		<789, 3955, 1529>, 0,
		<789, 1529, 3526>, 0,
		<789, 3526, 2802>, 0,
		<789, 2802, 3210>, 0,
		<789, 3210, 2805>, 0,
		<790, 2806, 3530>, 0,
		<790, 3530, 1536>, 0,
		<790, 1536, 3824>, 0,
		<790, 3824, 1829>, 0,
		<790, 1829, 3676>, 0,
		<790, 3676, 2807>, 0,
		<790, 2807, 3211>, 0,
		<790, 3211, 2806>, 0,
		<791, 2807, 3676>, 0,
		<791, 3676, 1828>, 0,
		<791, 1828, 3780>, 0,
		<791, 3780, 1066>, 0,
		<791, 1066, 3295>, 0,
		<791, 3295, 2808>, 0,
		<791, 2808, 3211>, 0,
		<791, 3211, 2807>, 0,
		<792, 2808, 3295>, 0,
		<792, 3295, 1067>, 0,
		<792, 1067, 3779>, 0,
		<792, 3779, 1824>, 0,
		<792, 1824, 3674>, 0,
		<792, 3674, 2809>, 0,
		<792, 2809, 3211>, 0,
		<792, 3211, 2808>, 0,
		<793, 2809, 3674>, 0,
		<793, 3674, 1825>, 0,
		<793, 1825, 3823>, 0,
		<793, 3823, 1537>, 0,
		<793, 1537, 3530>, 0,
		<793, 3530, 2806>, 0,
		<793, 2806, 3211>, 0,
		<793, 3211, 2809>, 0,
		<794, 2810, 3549>, 0,
		<794, 3549, 1574>, 0,
		<794, 1574, 3955>, 0,
		<794, 3955, 1826>, 0,
		<794, 1826, 3675>, 0,
		<794, 3675, 2811>, 0,
		<794, 2811, 3212>, 0,
		<794, 3212, 2810>, 0,
		<795, 2811, 3675>, 0,
		<795, 3675, 1827>, 0,
		<795, 1827, 3811>, 0,
		<795, 3811, 1068>, 0,
		<795, 1068, 3296>, 0,
		<795, 3296, 2812>, 0,
		<795, 2812, 3212>, 0,
		<795, 3212, 2811>, 0,
		<796, 2812, 3296>, 0,
		<796, 3296, 1069>, 0,
		<796, 1069, 3812>, 0,
		<796, 3812, 1831>, 0,
		<796, 1831, 3677>, 0,
		<796, 3677, 2813>, 0,
		<796, 2813, 3212>, 0,
		<796, 3212, 2812>, 0,
		<797, 2813, 3677>, 0,
		<797, 3677, 1830>, 0,
		<797, 1830, 3956>, 0,
		<797, 3956, 1575>, 0,
		<797, 1575, 3549>, 0,
		<797, 3549, 2810>, 0,
		<797, 2810, 3212>, 0,
		<797, 3212, 2813>, 0,
		<798, 2814, 3552>, 0,
		<798, 3552, 1580>, 0,
		<798, 1580, 3837>, 0,
		<798, 3837, 1833>, 0,
		<798, 1833, 3678>, 0,
		<798, 3678, 2815>, 0,
		<798, 2815, 3213>, 0,
		<798, 3213, 2814>, 0,
		<799, 2815, 3678>, 0,
		<799, 3678, 1832>, 0,
		<799, 1832, 3783>, 0,
		<799, 3783, 1070>, 0,
		<799, 1070, 3297>, 0,
		<799, 3297, 2816>, 0,
		<799, 2816, 3213>, 0,
		<799, 3213, 2815>, 0,
		<800, 2816, 3297>, 0,
		<800, 3297, 1071>, 0,
		<800, 1071, 3781>, 0,
		<800, 3781, 1835>, 0,
		<800, 1835, 3679>, 0,
		<800, 3679, 2817>, 0,
		<800, 2817, 3213>, 0,
		<800, 3213, 2816>, 0,
		<801, 2817, 3679>, 0,
		<801, 3679, 1834>, 0,
		<801, 1834, 3825>, 0,
		<801, 3825, 1581>, 0,
		<801, 1581, 3552>, 0,
		<801, 3552, 2814>, 0,
		<801, 2814, 3213>, 0,
		<801, 3213, 2817>, 0,
		<802, 2818, 3553>, 0,
		<802, 3553, 1582>, 0,
		<802, 1582, 3825>, 0,
		<802, 3825, 1834>, 0,
		<802, 1834, 3679>, 0,
		<802, 3679, 2819>, 0,
		<802, 2819, 3214>, 0,
		<802, 3214, 2818>, 0,
		<803, 2819, 3679>, 0,
		<803, 3679, 1835>, 0,
		<803, 1835, 3781>, 0,
		<803, 3781, 1072>, 0,
		<803, 1072, 3298>, 0,
		<803, 3298, 2820>, 0,
		<803, 2820, 3214>, 0,
		<803, 3214, 2819>, 0,
		<804, 2820, 3298>, 0,
		<804, 3298, 1073>, 0,
		<804, 1073, 3780>, 0,
		<804, 3780, 1828>, 0,
		<804, 1828, 3676>, 0,
		<804, 3676, 2821>, 0,
		<804, 2821, 3214>, 0,
		<804, 3214, 2820>, 0,
		<805, 2821, 3676>, 0,
		<805, 3676, 1829>, 0,
		<805, 1829, 3824>, 0,
		<805, 3824, 1583>, 0,
		<805, 1583, 3553>, 0,
		<805, 3553, 2818>, 0,
		<805, 2818, 3214>, 0,
		<805, 3214, 2821>, 0,
		<806, 2822, 3555>, 0,
		<806, 3555, 1586>, 0,
		<806, 1586, 3849>, 0,
		<806, 3849, 1837>, 0,
		<806, 1837, 3680>, 0,
		<806, 3680, 2823>, 0,
		<806, 2823, 3215>, 0,
		<806, 3215, 2822>, 0,
		<807, 2823, 3680>, 0,
		<807, 3680, 1836>, 0,
		<807, 1836, 3785>, 0,
		<807, 3785, 1074>, 0,
		<807, 1074, 3299>, 0,
		<807, 3299, 2824>, 0,
		<807, 2824, 3215>, 0,
		<807, 3215, 2823>, 0,
		<808, 2824, 3299>, 0,
		<808, 3299, 1075>, 0,
		<808, 1075, 3783>, 0,
		<808, 3783, 1832>, 0,
		<808, 1832, 3678>, 0,
		<808, 3678, 2825>, 0,
		<808, 2825, 3215>, 0,
		<808, 3215, 2824>, 0,
		<809, 2825, 3678>, 0,
		<809, 3678, 1833>, 0,
		<809, 1833, 3837>, 0,
		<809, 3837, 1587>, 0,
		<809, 1587, 3555>, 0,
		<809, 3555, 2822>, 0,
		<809, 2822, 3215>, 0,
		<809, 3215, 2825>, 0,
		<810, 2826, 3557>, 0,
		<810, 3557, 1590>, 0,
		<810, 1590, 3861>, 0,
		<810, 3861, 1839>, 0,
		<810, 1839, 3681>, 0,
		<810, 3681, 2827>, 0,
		<810, 2827, 3216>, 0,
		<810, 3216, 2826>, 0,
		<811, 2827, 3681>, 0,
		<811, 3681, 1838>, 0,
		<811, 1838, 3787>, 0,
		<811, 3787, 1076>, 0,
		<811, 1076, 3300>, 0,
		<811, 3300, 2828>, 0,
		<811, 2828, 3216>, 0,
		<811, 3216, 2827>, 0,
		<812, 2828, 3300>, 0,
		<812, 3300, 1077>, 0,
		<812, 1077, 3785>, 0,
		<812, 3785, 1836>, 0,
		<812, 1836, 3680>, 0,
		<812, 3680, 2829>, 0,
		<812, 2829, 3216>, 0,
		<812, 3216, 2828>, 0,
		<813, 2829, 3680>, 0,
		<813, 3680, 1837>, 0,
		<813, 1837, 3849>, 0,
		<813, 3849, 1591>, 0,
		<813, 1591, 3557>, 0,
		<813, 3557, 2826>, 0,
		<813, 2826, 3216>, 0,
		<813, 3216, 2829>, 0,
		<814, 2830, 3559>, 0,
		<814, 3559, 1594>, 0,
		<814, 1594, 3873>, 0,
		<814, 3873, 1841>, 0,
		<814, 1841, 3682>, 0,
		<814, 3682, 2831>, 0,
		<814, 2831, 3217>, 0,
		<814, 3217, 2830>, 0,
		<815, 2831, 3682>, 0,
		<815, 3682, 1840>, 0,
		<815, 1840, 3789>, 0,
		<815, 3789, 1078>, 0,
		<815, 1078, 3301>, 0,
		<815, 3301, 2832>, 0,
		<815, 2832, 3217>, 0,
		<815, 3217, 2831>, 0,
		<816, 2832, 3301>, 0,
		<816, 3301, 1079>, 0,
		<816, 1079, 3787>, 0,
		<816, 3787, 1838>, 0,
		<816, 1838, 3681>, 0,
		<816, 3681, 2833>, 0,
		<816, 2833, 3217>, 0,
		<816, 3217, 2832>, 0,
		<817, 2833, 3681>, 0,
		<817, 3681, 1839>, 0,
		<817, 1839, 3861>, 0,
		<817, 3861, 1595>, 0,
		<817, 1595, 3559>, 0,
		<817, 3559, 2830>, 0,
		<817, 2830, 3217>, 0,
		<817, 3217, 2833>, 0,
		<818, 2834, 3561>, 0,
		<818, 3561, 1598>, 0,
		<818, 1598, 3885>, 0,
		<818, 3885, 1843>, 0,
		<818, 1843, 3683>, 0,
		<818, 3683, 2835>, 0,
		<818, 2835, 3218>, 0,
		<818, 3218, 2834>, 0,
		<819, 2835, 3683>, 0,
		<819, 3683, 1842>, 0,
		<819, 1842, 3791>, 0,
		<819, 3791, 1080>, 0,
		<819, 1080, 3302>, 0,
		<819, 3302, 2836>, 0,
		<819, 2836, 3218>, 0,
		<819, 3218, 2835>, 0,
		<820, 2836, 3302>, 0,
		<820, 3302, 1081>, 0,
		<820, 1081, 3789>, 0,
		<820, 3789, 1840>, 0,
		<820, 1840, 3682>, 0,
		<820, 3682, 2837>, 0,
		<820, 2837, 3218>, 0,
		<820, 3218, 2836>, 0,
		<821, 2837, 3682>, 0,
		<821, 3682, 1841>, 0,
		<821, 1841, 3873>, 0,
		<821, 3873, 1599>, 0,
		<821, 1599, 3561>, 0,
		<821, 3561, 2834>, 0,
		<821, 2834, 3218>, 0,
		<821, 3218, 2837>, 0,
		<822, 2838, 3563>, 0,
		<822, 3563, 1602>, 0,
		<822, 1602, 3897>, 0,
		<822, 3897, 1845>, 0,
		<822, 1845, 3684>, 0,
		<822, 3684, 2839>, 0,
		<822, 2839, 3219>, 0,
		<822, 3219, 2838>, 0,
		<823, 2839, 3684>, 0,
		<823, 3684, 1844>, 0,
		<823, 1844, 3793>, 0,
		<823, 3793, 1082>, 0,
		<823, 1082, 3303>, 0,
		<823, 3303, 2840>, 0,
		<823, 2840, 3219>, 0,
		<823, 3219, 2839>, 0,
		<824, 2840, 3303>, 0,
		<824, 3303, 1083>, 0,
		<824, 1083, 3791>, 0,
		<824, 3791, 1842>, 0,
		<824, 1842, 3683>, 0,
		<824, 3683, 2841>, 0,
		<824, 2841, 3219>, 0,
		<824, 3219, 2840>, 0,
		<825, 2841, 3683>, 0,
		<825, 3683, 1843>, 0,
		<825, 1843, 3885>, 0,
		<825, 3885, 1603>, 0,
		<825, 1603, 3563>, 0,
		<825, 3563, 2838>, 0,
		<825, 2838, 3219>, 0,
		<825, 3219, 2841>, 0,
		<826, 2842, 3565>, 0,
		<826, 3565, 1606>, 0,
		<826, 1606, 3909>, 0,
		<826, 3909, 1847>, 0,
		<826, 1847, 3685>, 0,
		<826, 3685, 2843>, 0,
		<826, 2843, 3220>, 0,
		<826, 3220, 2842>, 0,
		<827, 2843, 3685>, 0,
		<827, 3685, 1846>, 0,
		<827, 1846, 3795>, 0,
		<827, 3795, 1084>, 0,
		<827, 1084, 3304>, 0,
		<827, 3304, 2844>, 0,
		<827, 2844, 3220>, 0,
		<827, 3220, 2843>, 0,
		<828, 2844, 3304>, 0,
		<828, 3304, 1085>, 0,
		<828, 1085, 3793>, 0,
		<828, 3793, 1844>, 0,
		<828, 1844, 3684>, 0,
		<828, 3684, 2845>, 0,
		<828, 2845, 3220>, 0,
		<828, 3220, 2844>, 0,
		<829, 2845, 3684>, 0,
		<829, 3684, 1845>, 0,
		<829, 1845, 3897>, 0,
		<829, 3897, 1607>, 0,
		<829, 1607, 3565>, 0,
		<829, 3565, 2842>, 0,
		<829, 2842, 3220>, 0,
		<829, 3220, 2845>, 0,
		<830, 2846, 3567>, 0,
		<830, 3567, 1610>, 0,
		<830, 1610, 3921>, 0,
		<830, 3921, 1849>, 0,
		<830, 1849, 3686>, 0,
		<830, 3686, 2847>, 0,
		<830, 2847, 3221>, 0,
		<830, 3221, 2846>, 0,
		<831, 2847, 3686>, 0,
		<831, 3686, 1848>, 0,
		<831, 1848, 3797>, 0,
		<831, 3797, 1086>, 0,
		<831, 1086, 3305>, 0,
		<831, 3305, 2848>, 0,
		<831, 2848, 3221>, 0,
		<831, 3221, 2847>, 0,
		<832, 2848, 3305>, 0,
		<832, 3305, 1087>, 0,
		<832, 1087, 3795>, 0,
		<832, 3795, 1846>, 0,
		<832, 1846, 3685>, 0,
		<832, 3685, 2849>, 0,
		<832, 2849, 3221>, 0,
		<832, 3221, 2848>, 0,
		<833, 2849, 3685>, 0,
		<833, 3685, 1847>, 0,
		<833, 1847, 3909>, 0,
		<833, 3909, 1611>, 0,
		<833, 1611, 3567>, 0,
		<833, 3567, 2846>, 0,
		<833, 2846, 3221>, 0,
		<833, 3221, 2849>, 0,
		<834, 2850, 3569>, 0,
		<834, 3569, 1614>, 0,
		<834, 1614, 3933>, 0,
		<834, 3933, 1851>, 0,
		<834, 1851, 3687>, 0,
		<834, 3687, 2851>, 0,
		<834, 2851, 3222>, 0,
		<834, 3222, 2850>, 0,
		<835, 2851, 3687>, 0,
		<835, 3687, 1850>, 0,
		<835, 1850, 3799>, 0,
		<835, 3799, 1088>, 0,
		<835, 1088, 3306>, 0,
		<835, 3306, 2852>, 0,
		<835, 2852, 3222>, 0,
		<835, 3222, 2851>, 0,
		<836, 2852, 3306>, 0,
		<836, 3306, 1089>, 0,
		<836, 1089, 3797>, 0,
		<836, 3797, 1848>, 0,
		<836, 1848, 3686>, 0,
		<836, 3686, 2853>, 0,
		<836, 2853, 3222>, 0,
		<836, 3222, 2852>, 0,
		<837, 2853, 3686>, 0,
		<837, 3686, 1849>, 0,
		<837, 1849, 3921>, 0,
		<837, 3921, 1615>, 0,
		<837, 1615, 3569>, 0,
		<837, 3569, 2850>, 0,
		<837, 2850, 3222>, 0,
		<837, 3222, 2853>, 0,
		<838, 2854, 3571>, 0,
		<838, 3571, 1618>, 0,
		<838, 1618, 3945>, 0,
		<838, 3945, 1853>, 0,
		<838, 1853, 3688>, 0,
		<838, 3688, 2855>, 0,
		<838, 2855, 3223>, 0,
		<838, 3223, 2854>, 0,
		<839, 2855, 3688>, 0,
		<839, 3688, 1852>, 0,
		<839, 1852, 3801>, 0,
		<839, 3801, 1090>, 0,
		<839, 1090, 3307>, 0,
		<839, 3307, 2856>, 0,
		<839, 2856, 3223>, 0,
		<839, 3223, 2855>, 0,
		<840, 2856, 3307>, 0,
		<840, 3307, 1091>, 0,
		<840, 1091, 3799>, 0,
		<840, 3799, 1850>, 0,
		<840, 1850, 3687>, 0,
		<840, 3687, 2857>, 0,
		<840, 2857, 3223>, 0,
		<840, 3223, 2856>, 0,
		<841, 2857, 3687>, 0,
		<841, 3687, 1851>, 0,
		<841, 1851, 3933>, 0,
		<841, 3933, 1619>, 0,
		<841, 1619, 3571>, 0,
		<841, 3571, 2854>, 0,
		<841, 2854, 3223>, 0,
		<841, 3223, 2857>, 0,
		<842, 2858, 3572>, 0,
		<842, 3572, 1620>, 0,
		<842, 1620, 3956>, 0,
		<842, 3956, 1830>, 0,
		<842, 1830, 3677>, 0,
		<842, 3677, 2859>, 0,
		<842, 2859, 3224>, 0,
		<842, 3224, 2858>, 0,
		<843, 2859, 3677>, 0,
		<843, 3677, 1831>, 0,
		<843, 1831, 3812>, 0,
		<843, 3812, 1092>, 0,
		<843, 1092, 3308>, 0,
		<843, 3308, 2860>, 0,
		<843, 2860, 3224>, 0,
		<843, 3224, 2859>, 0,
		<844, 2860, 3308>, 0,
		<844, 3308, 1093>, 0,
		<844, 1093, 3813>, 0,
		<844, 3813, 1855>, 0,
		<844, 1855, 3689>, 0,
		<844, 3689, 2861>, 0,
		<844, 2861, 3224>, 0,
		<844, 3224, 2860>, 0,
		<845, 2861, 3689>, 0,
		<845, 3689, 1854>, 0,
		<845, 1854, 3957>, 0,
		<845, 3957, 1621>, 0,
		<845, 1621, 3572>, 0,
		<845, 3572, 2858>, 0,
		<845, 2858, 3224>, 0,
		<845, 3224, 2861>, 0,
		<846, 2862, 3573>, 0,
		<846, 3573, 1622>, 0,
		<846, 1622, 3957>, 0,
		<846, 3957, 1854>, 0,
		<846, 1854, 3689>, 0,
		<846, 3689, 2863>, 0,
		<846, 2863, 3225>, 0,
		<846, 3225, 2862>, 0,
		<847, 2863, 3689>, 0,
		<847, 3689, 1855>, 0,
		<847, 1855, 3813>, 0,
		<847, 3813, 1094>, 0,
		<847, 1094, 3309>, 0,
		<847, 3309, 2864>, 0,
		<847, 2864, 3225>, 0,
		<847, 3225, 2863>, 0,
		<848, 2864, 3309>, 0,
		<848, 3309, 1095>, 0,
		<848, 1095, 3801>, 0,
		<848, 3801, 1852>, 0,
		<848, 1852, 3688>, 0,
		<848, 3688, 2865>, 0,
		<848, 2865, 3225>, 0,
		<848, 3225, 2864>, 0,
		<849, 2865, 3688>, 0,
		<849, 3688, 1853>, 0,
		<849, 1853, 3945>, 0,
		<849, 3945, 1623>, 0,
		<849, 1623, 3573>, 0,
		<849, 3573, 2862>, 0,
		<849, 2862, 3225>, 0,
		<849, 3225, 2865>, 0,
		<850, 2866, 3568>, 1,
		<850, 3568, 1613>, 1,
		<850, 1613, 3933>, 1,
		<850, 3933, 1614>, 1,
		<850, 1614, 3569>, 1,
		<850, 3569, 2867>, 1,
		<850, 2867, 3226>, 1,
		<850, 3226, 2866>, 1,
		<851, 2867, 3569>, 1,
		<851, 3569, 1615>, 1,
		<851, 1615, 3921>, 1,
		<851, 3921, 1609>, 1,
		<851, 1609, 3566>, 1,
		<851, 3566, 2868>, 1,
		<851, 2868, 3226>, 1,
		<851, 3226, 2867>, 1,
		<852, 2868, 3566>, 1,
		<852, 3566, 1608>, 1,
		<852, 1608, 4031>, 1,
		<852, 4031, 1937>, 1,
		<852, 1937, 3730>, 1,
		<852, 3730, 2869>, 1,
		<852, 2869, 3226>, 1,
		<852, 3226, 2868>, 1,
		<853, 2869, 3730>, 1,
		<853, 3730, 1936>, 1,
		<853, 1936, 4032>, 1,
		<853, 4032, 1612>, 1,
		<853, 1612, 3568>, 1,
		<853, 3568, 2866>, 1,
		<853, 2866, 3226>, 1,
		<853, 3226, 2869>, 1,
		<854, 2870, 3570>, 1,
		<854, 3570, 1617>, 1,
		<854, 1617, 3945>, 1,
		<854, 3945, 1618>, 1,
		<854, 1618, 3571>, 1,
		<854, 3571, 2871>, 1,
		<854, 2871, 3227>, 1,
		<854, 3227, 2870>, 1,
		<855, 2871, 3571>, 1,
		<855, 3571, 1619>, 1,
		<855, 1619, 3933>, 1,
		<855, 3933, 1613>, 1,
		<855, 1613, 3568>, 1,
		<855, 3568, 2872>, 1,
		<855, 2872, 3227>, 1,
		<855, 3227, 2871>, 1,
		<856, 2872, 3568>, 1,
		<856, 3568, 1612>, 1,
		<856, 1612, 4032>, 1,
		<856, 4032, 1939>, 1,
		<856, 1939, 3731>, 1,
		<856, 3731, 2873>, 1,
		<856, 2873, 3227>, 1,
		<856, 3227, 2872>, 1,
		<857, 2873, 3731>, 1,
		<857, 3731, 1938>, 1,
		<857, 1938, 4033>, 1,
		<857, 4033, 1616>, 1,
		<857, 1616, 3570>, 1,
		<857, 3570, 2870>, 1,
		<857, 2870, 3227>, 1,
		<857, 3227, 2873>, 1,
		<858, 2874, 3719>, 1,
		<858, 3719, 1915>, 1,
		<858, 1915, 3956>, 1,
		<858, 3956, 1620>, 1,
		<858, 1620, 3572>, 1,
		<858, 3572, 2875>, 1,
		<858, 2875, 3228>, 1,
		<858, 3228, 2874>, 1,
		<859, 2875, 3572>, 1,
		<859, 3572, 1621>, 1,
		<859, 1621, 3957>, 1,
		<859, 3957, 1622>, 1,
		<859, 1622, 3573>, 1,
		<859, 3573, 2876>, 1,
		<859, 2876, 3228>, 1,
		<859, 3228, 2875>, 1,
		<860, 2876, 3573>, 1,
		<860, 3573, 1623>, 1,
		<860, 1623, 3945>, 1,
		<860, 3945, 1617>, 1,
		<860, 1617, 3570>, 1,
		<860, 3570, 2877>, 1,
		<860, 2877, 3228>, 1,
		<860, 3228, 2876>, 1,
		<861, 2877, 3570>, 1,
		<861, 3570, 1616>, 1,
		<861, 1616, 4033>, 1,
		<861, 4033, 1941>, 1,
		<861, 1941, 3732>, 1,
		<861, 3732, 2878>, 1,
		<861, 2878, 3228>, 1,
		<861, 3228, 2877>, 1,
		<862, 2878, 3732>, 1,
		<862, 3732, 1940>, 1,
		<862, 1940, 4023>, 1,
		<862, 4023, 1914>, 1,
		<862, 1914, 3719>, 1,
		<862, 3719, 2874>, 1,
		<862, 2874, 3228>, 1,
		<862, 3228, 2878>, 1,
		<863, 2879, 3717>, 1,
		<863, 3717, 1911>, 1,
		<863, 1911, 3955>, 1,
		<863, 3955, 1574>, 1,
		<863, 1574, 3549>, 1,
		<863, 3549, 2880>, 1,
		<863, 2880, 3229>, 1,
		<863, 3229, 2879>, 1,
		<864, 2880, 3549>, 1,
		<864, 3549, 1575>, 1,
		<864, 1575, 3956>, 1,
		<864, 3956, 1915>, 1,
		<864, 1915, 3719>, 1,
		<864, 3719, 2881>, 1,
		<864, 2881, 3229>, 1,
		<864, 3229, 2880>, 1,
		<865, 2881, 3719>, 1,
		<865, 3719, 1914>, 1,
		<865, 1914, 4023>, 1,
		<865, 4023, 1943>, 1,
		<865, 1943, 3733>, 1,
		<865, 3733, 2882>, 1,
		<865, 2882, 3229>, 1,
		<865, 3229, 2881>, 1,
		<866, 2882, 3733>, 1,
		<866, 3733, 1942>, 1,
		<866, 1942, 4021>, 1,
		<866, 4021, 1910>, 1,
		<866, 1910, 3717>, 1,
		<866, 3717, 2879>, 1,
		<866, 2879, 3229>, 1,
		<866, 3229, 2882>, 1,
		<867, 2883, 3715>, 1,
		<867, 3715, 1907>, 1,
		<867, 1907, 3954>, 1,
		<867, 3954, 1528>, 1,
		<867, 1528, 3526>, 1,
		<867, 3526, 2884>, 1,
		<867, 2884, 3230>, 1,
		<867, 3230, 2883>, 1,
		<868, 2884, 3526>, 1,
		<868, 3526, 1529>, 1,
		<868, 1529, 3955>, 1,
		<868, 3955, 1911>, 1,
		<868, 1911, 3717>, 1,
		<868, 3717, 2885>, 1,
		<868, 2885, 3230>, 1,
		<868, 3230, 2884>, 1,
		<869, 2885, 3717>, 1,
		<869, 3717, 1910>, 1,
		<869, 1910, 4021>, 1,
		<869, 4021, 1945>, 1,
		<869, 1945, 3734>, 1,
		<869, 3734, 2886>, 1,
		<869, 2886, 3230>, 1,
		<869, 3230, 2885>, 1,
		<870, 2886, 3734>, 1,
		<870, 3734, 1944>, 1,
		<870, 1944, 4019>, 1,
		<870, 4019, 1906>, 1,
		<870, 1906, 3715>, 1,
		<870, 3715, 2883>, 1,
		<870, 2883, 3230>, 1,
		<870, 3230, 2886>, 1,
		<871, 2887, 3713>, 1,
		<871, 3713, 1903>, 1,
		<871, 1903, 3953>, 1,
		<871, 3953, 1482>, 1,
		<871, 1482, 3503>, 1,
		<871, 3503, 2888>, 1,
		<871, 2888, 3231>, 1,
		<871, 3231, 2887>, 1,
		<872, 2888, 3503>, 1,
		<872, 3503, 1483>, 1,
		<872, 1483, 3954>, 1,
		<872, 3954, 1907>, 1,
		<872, 1907, 3715>, 1,
		<872, 3715, 2889>, 1,
		<872, 2889, 3231>, 1,
		<872, 3231, 2888>, 1,
		<873, 2889, 3715>, 1,
		<873, 3715, 1906>, 1,
		<873, 1906, 4019>, 1,
		<873, 4019, 1947>, 1,
		<873, 1947, 3735>, 1,
		<873, 3735, 2890>, 1,
		<873, 2890, 3231>, 1,
		<873, 3231, 2889>, 1,
		<874, 2890, 3735>, 1,
		<874, 3735, 1946>, 1,
		<874, 1946, 4017>, 1,
		<874, 4017, 1902>, 1,
		<874, 1902, 3713>, 1,
		<874, 3713, 2887>, 1,
		<874, 2887, 3231>, 1,
		<874, 3231, 2890>, 1,
		<875, 2891, 3711>, 1,
		<875, 3711, 1899>, 1,
		<875, 1899, 3952>, 1,
		<875, 3952, 1436>, 1,
		<875, 1436, 3480>, 1,
		<875, 3480, 2892>, 1,
		<875, 2892, 3232>, 1,
		<875, 3232, 2891>, 1,
		<876, 2892, 3480>, 1,
		<876, 3480, 1437>, 1,
		<876, 1437, 3953>, 1,
		<876, 3953, 1903>, 1,
		<876, 1903, 3713>, 1,
		<876, 3713, 2893>, 1,
		<876, 2893, 3232>, 1,
		<876, 3232, 2892>, 1,
		<877, 2893, 3713>, 1,
		<877, 3713, 1902>, 1,
		<877, 1902, 4017>, 1,
		<877, 4017, 1949>, 1,
		<877, 1949, 3736>, 1,
		<877, 3736, 2894>, 1,
		<877, 2894, 3232>, 1,
		<877, 3232, 2893>, 1,
		<878, 2894, 3736>, 1,
		<878, 3736, 1948>, 1,
		<878, 1948, 4015>, 1,
		<878, 4015, 1898>, 1,
		<878, 1898, 3711>, 1,
		<878, 3711, 2891>, 1,
		<878, 2891, 3232>, 1,
		<878, 3232, 2894>, 1,
		<879, 2895, 3709>, 1,
		<879, 3709, 1895>, 1,
		<879, 1895, 3951>, 1,
		<879, 3951, 1390>, 1,
		<879, 1390, 3457>, 1,
		<879, 3457, 2896>, 1,
		<879, 2896, 3233>, 1,
		<879, 3233, 2895>, 1,
		<880, 2896, 3457>, 1,
		<880, 3457, 1391>, 1,
		<880, 1391, 3952>, 1,
		<880, 3952, 1899>, 1,
		<880, 1899, 3711>, 1,
		<880, 3711, 2897>, 1,
		<880, 2897, 3233>, 1,
		<880, 3233, 2896>, 1,
		<881, 2897, 3711>, 1,
		<881, 3711, 1898>, 1,
		<881, 1898, 4015>, 1,
		<881, 4015, 1951>, 1,
		<881, 1951, 3737>, 1,
		<881, 3737, 2898>, 1,
		<881, 2898, 3233>, 1,
		<881, 3233, 2897>, 1,
		<882, 2898, 3737>, 1,
		<882, 3737, 1950>, 1,
		<882, 1950, 4013>, 1,
		<882, 4013, 1894>, 1,
		<882, 1894, 3709>, 1,
		<882, 3709, 2895>, 1,
		<882, 2895, 3233>, 1,
		<882, 3233, 2898>, 1,
		<883, 2899, 3707>, 1,
		<883, 3707, 1891>, 1,
		<883, 1891, 3950>, 1,
		<883, 3950, 1344>, 1,
		<883, 1344, 3434>, 1,
		<883, 3434, 2900>, 1,
		<883, 2900, 3234>, 1,
		<883, 3234, 2899>, 1,
		<884, 2900, 3434>, 1,
		<884, 3434, 1345>, 1,
		<884, 1345, 3951>, 1,
		<884, 3951, 1895>, 1,
		<884, 1895, 3709>, 1,
		<884, 3709, 2901>, 1,
		<884, 2901, 3234>, 1,
		<884, 3234, 2900>, 1,
		<885, 2901, 3709>, 1,
		<885, 3709, 1894>, 1,
		<885, 1894, 4013>, 1,
		<885, 4013, 1953>, 1,
		<885, 1953, 3738>, 1,
		<885, 3738, 2902>, 1,
		<885, 2902, 3234>, 1,
		<885, 3234, 2901>, 1,
		<886, 2902, 3738>, 1,
		<886, 3738, 1952>, 1,
		<886, 1952, 4011>, 1,
		<886, 4011, 1890>, 1,
		<886, 1890, 3707>, 1,
		<886, 3707, 2899>, 1,
		<886, 2899, 3234>, 1,
		<886, 3234, 2902>, 1,
		<887, 2903, 3705>, 1,
		<887, 3705, 1887>, 1,
		<887, 1887, 3949>, 1,
		<887, 3949, 1298>, 1,
		<887, 1298, 3411>, 1,
		<887, 3411, 2904>, 1,
		<887, 2904, 3235>, 1,
		<887, 3235, 2903>, 1,
		<888, 2904, 3411>, 1,
		<888, 3411, 1299>, 1,
		<888, 1299, 3950>, 1,
		<888, 3950, 1891>, 1,
		<888, 1891, 3707>, 1,
		<888, 3707, 2905>, 1,
		<888, 2905, 3235>, 1,
		<888, 3235, 2904>, 1,
		<889, 2905, 3707>, 1,
		<889, 3707, 1890>, 1,
		<889, 1890, 4011>, 1,
		<889, 4011, 1955>, 1,
		<889, 1955, 3739>, 1,
		<889, 3739, 2906>, 1,
		<889, 2906, 3235>, 1,
		<889, 3235, 2905>, 1,
		<890, 2906, 3739>, 1,
		<890, 3739, 1954>, 1,
		<890, 1954, 4009>, 1,
		<890, 4009, 1886>, 1,
		<890, 1886, 3705>, 1,
		<890, 3705, 2903>, 1,
		<890, 2903, 3235>, 1,
		<890, 3235, 2906>, 1,
		<891, 2907, 3703>, 1,
		<891, 3703, 1883>, 1,
		<891, 1883, 3948>, 1,
		<891, 3948, 1252>, 1,
		<891, 1252, 3388>, 1,
		<891, 3388, 2908>, 1,
		<891, 2908, 3236>, 1,
		<891, 3236, 2907>, 1,
		<892, 2908, 3388>, 1,
		<892, 3388, 1253>, 1,
		<892, 1253, 3949>, 1,
		<892, 3949, 1887>, 1,
		<892, 1887, 3705>, 1,
		<892, 3705, 2909>, 1,
		<892, 2909, 3236>, 1,
		<892, 3236, 2908>, 1,
		<893, 2909, 3705>, 1,
		<893, 3705, 1886>, 1,
		<893, 1886, 4009>, 1,
		<893, 4009, 1957>, 1,
		<893, 1957, 3740>, 1,
		<893, 3740, 2910>, 1,
		<893, 2910, 3236>, 1,
		<893, 3236, 2909>, 1,
		<894, 2910, 3740>, 1,
		<894, 3740, 1956>, 1,
		<894, 1956, 4007>, 1,
		<894, 4007, 1882>, 1,
		<894, 1882, 3703>, 1,
		<894, 3703, 2907>, 1,
		<894, 2907, 3236>, 1,
		<894, 3236, 2910>, 1,
		<895, 2911, 3701>, 1,
		<895, 3701, 1879>, 1,
		<895, 1879, 3947>, 1,
		<895, 3947, 1206>, 1,
		<895, 1206, 3365>, 1,
		<895, 3365, 2912>, 1,
		<895, 2912, 3237>, 1,
		<895, 3237, 2911>, 1,
		<896, 2912, 3365>, 1,
		<896, 3365, 1207>, 1,
		<896, 1207, 3948>, 1,
		<896, 3948, 1883>, 1,
		<896, 1883, 3703>, 1,
		<896, 3703, 2913>, 1,
		<896, 2913, 3237>, 1,
		<896, 3237, 2912>, 1,
		<897, 2913, 3703>, 1,
		<897, 3703, 1882>, 1,
		<897, 1882, 4007>, 1,
		<897, 4007, 1959>, 1,
		<897, 1959, 3741>, 1,
		<897, 3741, 2914>, 1,
		<897, 2914, 3237>, 1,
		<897, 3237, 2913>, 1,
		<898, 2914, 3741>, 1,
		<898, 3741, 1958>, 1,
		<898, 1958, 4005>, 1,
		<898, 4005, 1878>, 1,
		<898, 1878, 3701>, 1,
		<898, 3701, 2911>, 1,
		<898, 2911, 3237>, 1,
		<898, 3237, 2914>, 1,
		<899, 2915, 3342>, 1,
		<899, 3342, 1161>, 1,
		<899, 1161, 3935>, 1,
		<899, 3935, 1153>, 1,
		<899, 1153, 3338>, 1,
		<899, 3338, 2916>, 1,
		<899, 2916, 3238>, 1,
		<899, 3238, 2915>, 1,
		<900, 2916, 3338>, 1,
		<900, 3338, 1152>, 1,
		<900, 1152, 4004>, 1,
		<900, 4004, 1961>, 1,
		<900, 1961, 3742>, 1,
		<900, 3742, 2917>, 1,
		<900, 2917, 3238>, 1,
		<900, 3238, 2916>, 1,
		<901, 2917, 3742>, 1,
		<901, 3742, 1960>, 1,
		<901, 1960, 4005>, 1,
		<901, 4005, 1160>, 1,
		<901, 1160, 3342>, 1,
		<901, 3342, 2915>, 1,
		<901, 2915, 3238>, 1,
		<901, 3238, 2917>, 1,
		<902, 2918, 3338>, 1,
		<902, 3338, 1153>, 1,
		<902, 1153, 3935>, 1,
		<902, 3935, 1154>, 1,
		<902, 1154, 3339>, 1,
		<902, 3339, 2919>, 1,
		<902, 2919, 3239>, 1,
		<902, 3239, 2918>, 1,
		<903, 2919, 3339>, 1,
		<903, 3339, 1155>, 1,
		<903, 1155, 3923>, 1,
		<903, 3923, 1147>, 1,
		<903, 1147, 3335>, 1,
		<903, 3335, 2920>, 1,
		<903, 2920, 3239>, 1,
		<903, 3239, 2919>, 1,
		<904, 2920, 3335>, 1,
		<904, 3335, 1146>, 1,
		<904, 1146, 4003>, 1,
		<904, 4003, 1963>, 1,
		<904, 1963, 3743>, 1,
		<904, 3743, 2921>, 1,
		<904, 2921, 3239>, 1,
		<904, 3239, 2920>, 1,
		<905, 2921, 3743>, 1,
		<905, 3743, 1962>, 1,
		<905, 1962, 4004>, 1,
		<905, 4004, 1152>, 1,
		<905, 1152, 3338>, 1,
		<905, 3338, 2918>, 1,
		<905, 2918, 3239>, 1,
		<905, 3239, 2921>, 1,
		<906, 2922, 3335>, 1,
		<906, 3335, 1147>, 1,
		<906, 1147, 3923>, 1,
		<906, 3923, 1148>, 1,
		<906, 1148, 3336>, 1,
		<906, 3336, 2923>, 1,
		<906, 2923, 3240>, 1,
		<906, 3240, 2922>, 1,
		<907, 2923, 3336>, 1,
		<907, 3336, 1149>, 1,
		<907, 1149, 3911>, 1,
		<907, 3911, 1141>, 1,
		<907, 1141, 3332>, 1,
		<907, 3332, 2924>, 1,
		<907, 2924, 3240>, 1,
		<907, 3240, 2923>, 1,
		<908, 2924, 3332>, 1,
		<908, 3332, 1140>, 1,
		<908, 1140, 4002>, 1,
		<908, 4002, 1965>, 1,
		<908, 1965, 3744>, 1,
		<908, 3744, 2925>, 1,
		<908, 2925, 3240>, 1,
		<908, 3240, 2924>, 1,
		<909, 2925, 3744>, 1,
		<909, 3744, 1964>, 1,
		<909, 1964, 4003>, 1,
		<909, 4003, 1146>, 1,
		<909, 1146, 3335>, 1,
		<909, 3335, 2922>, 1,
		<909, 2922, 3240>, 1,
		<909, 3240, 2925>, 1,
		<910, 2926, 3332>, 1,
		<910, 3332, 1141>, 1,
		<910, 1141, 3911>, 1,
		<910, 3911, 1142>, 1,
		<910, 1142, 3333>, 1,
		<910, 3333, 2927>, 1,
		<910, 2927, 3241>, 1,
		<910, 3241, 2926>, 1,
		<911, 2927, 3333>, 1,
		<911, 3333, 1143>, 1,
		<911, 1143, 3899>, 1,
		<911, 3899, 1135>, 1,
		<911, 1135, 3329>, 1,
		<911, 3329, 2928>, 1,
		<911, 2928, 3241>, 1,
		<911, 3241, 2927>, 1,
		<912, 2928, 3329>, 1,
		<912, 3329, 1134>, 1,
		<912, 1134, 4001>, 1,
		<912, 4001, 1967>, 1,
		<912, 1967, 3745>, 1,
		<912, 3745, 2929>, 1,
		<912, 2929, 3241>, 1,
		<912, 3241, 2928>, 1,
		<913, 2929, 3745>, 1,
		<913, 3745, 1966>, 1,
		<913, 1966, 4002>, 1,
		<913, 4002, 1140>, 1,
		<913, 1140, 3332>, 1,
		<913, 3332, 2926>, 1,
		<913, 2926, 3241>, 1,
		<913, 3241, 2929>, 1,
		<914, 2930, 3329>, 1,
		<914, 3329, 1135>, 1,
		<914, 1135, 3899>, 1,
		<914, 3899, 1136>, 1,
		<914, 1136, 3330>, 1,
		<914, 3330, 2931>, 1,
		<914, 2931, 3242>, 1,
		<914, 3242, 2930>, 1,
		<915, 2931, 3330>, 1,
		<915, 3330, 1137>, 1,
		<915, 1137, 3887>, 1,
		<915, 3887, 1129>, 1,
		<915, 1129, 3326>, 1,
		<915, 3326, 2932>, 1,
		<915, 2932, 3242>, 1,
		<915, 3242, 2931>, 1,
		<916, 2932, 3326>, 1,
		<916, 3326, 1128>, 1,
		<916, 1128, 4000>, 1,
		<916, 4000, 1969>, 1,
		<916, 1969, 3746>, 1,
		<916, 3746, 2933>, 1,
		<916, 2933, 3242>, 1,
		<916, 3242, 2932>, 1,
		<917, 2933, 3746>, 1,
		<917, 3746, 1968>, 1,
		<917, 1968, 4001>, 1,
		<917, 4001, 1134>, 1,
		<917, 1134, 3329>, 1,
		<917, 3329, 2930>, 1,
		<917, 2930, 3242>, 1,
		<917, 3242, 2933>, 1,
		<918, 2934, 3326>, 1,
		<918, 3326, 1129>, 1,
		<918, 1129, 3887>, 1,
		<918, 3887, 1131>, 1,
		<918, 1131, 3327>, 1,
		<918, 3327, 2935>, 1,
		<918, 2935, 3243>, 1,
		<918, 3243, 2934>, 1,
		<919, 2935, 3327>, 1,
		<919, 3327, 1130>, 1,
		<919, 1130, 3875>, 1,
		<919, 3875, 1123>, 1,
		<919, 1123, 3323>, 1,
		<919, 3323, 2936>, 1,
		<919, 2936, 3243>, 1,
		<919, 3243, 2935>, 1,
		<920, 2936, 3323>, 1,
		<920, 3323, 1122>, 1,
		<920, 1122, 3999>, 1,
		<920, 3999, 1971>, 1,
		<920, 1971, 3747>, 1,
		<920, 3747, 2937>, 1,
		<920, 2937, 3243>, 1,
		<920, 3243, 2936>, 1,
		<921, 2937, 3747>, 1,
		<921, 3747, 1970>, 1,
		<921, 1970, 4000>, 1,
		<921, 4000, 1128>, 1,
		<921, 1128, 3326>, 1,
		<921, 3326, 2934>, 1,
		<921, 2934, 3243>, 1,
		<921, 3243, 2937>, 1,
		<922, 2938, 3323>, 1,
		<922, 3323, 1123>, 1,
		<922, 1123, 3875>, 1,
		<922, 3875, 1124>, 1,
		<922, 1124, 3324>, 1,
		<922, 3324, 2939>, 1,
		<922, 2939, 3244>, 1,
		<922, 3244, 2938>, 1,
		<923, 2939, 3324>, 1,
		<923, 3324, 1125>, 1,
		<923, 1125, 3863>, 1,
		<923, 3863, 1117>, 1,
		<923, 1117, 3320>, 1,
		<923, 3320, 2940>, 1,
		<923, 2940, 3244>, 1,
		<923, 3244, 2939>, 1,
		<924, 2940, 3320>, 1,
		<924, 3320, 1116>, 1,
		<924, 1116, 3998>, 1,
		<924, 3998, 1973>, 1,
		<924, 1973, 3748>, 1,
		<924, 3748, 2941>, 1,
		<924, 2941, 3244>, 1,
		<924, 3244, 2940>, 1,
		<925, 2941, 3748>, 1,
		<925, 3748, 1972>, 1,
		<925, 1972, 3999>, 1,
		<925, 3999, 1122>, 1,
		<925, 1122, 3323>, 1,
		<925, 3323, 2938>, 1,
		<925, 2938, 3244>, 1,
		<925, 3244, 2941>, 1,
		<926, 2942, 3320>, 1,
		<926, 3320, 1117>, 1,
		<926, 1117, 3863>, 1,
		<926, 3863, 1118>, 1,
		<926, 1118, 3321>, 1,
		<926, 3321, 2943>, 1,
		<926, 2943, 3245>, 1,
		<926, 3245, 2942>, 1,
		<927, 2943, 3321>, 1,
		<927, 3321, 1119>, 1,
		<927, 1119, 3851>, 1,
		<927, 3851, 1111>, 1,
		<927, 1111, 3317>, 1,
		<927, 3317, 2944>, 1,
		<927, 2944, 3245>, 1,
		<927, 3245, 2943>, 1,
		<928, 2944, 3317>, 1,
		<928, 3317, 1110>, 1,
		<928, 1110, 3997>, 1,
		<928, 3997, 1975>, 1,
		<928, 1975, 3749>, 1,
		<928, 3749, 2945>, 1,
		<928, 2945, 3245>, 1,
		<928, 3245, 2944>, 1,
		<929, 2945, 3749>, 1,
		<929, 3749, 1974>, 1,
		<929, 1974, 3998>, 1,
		<929, 3998, 1116>, 1,
		<929, 1116, 3320>, 1,
		<929, 3320, 2942>, 1,
		<929, 2942, 3245>, 1,
		<929, 3245, 2945>, 1,
		<930, 2946, 3317>, 1,
		<930, 3317, 1111>, 1,
		<930, 1111, 3851>, 1,
		<930, 3851, 1112>, 1,
		<930, 1112, 3318>, 1,
		<930, 3318, 2947>, 1,
		<930, 2947, 3246>, 1,
		<930, 3246, 2946>, 1,
		<931, 2947, 3318>, 1,
		<931, 3318, 1113>, 1,
		<931, 1113, 3839>, 1,
		<931, 3839, 1105>, 1,
		<931, 1105, 3314>, 1,
		<931, 3314, 2948>, 1,
		<931, 2948, 3246>, 1,
		<931, 3246, 2947>, 1,
		<932, 2948, 3314>, 1,
		<932, 3314, 1104>, 1,
		<932, 1104, 3996>, 1,
		<932, 3996, 1977>, 1,
		<932, 1977, 3750>, 1,
		<932, 3750, 2949>, 1,
		<932, 2949, 3246>, 1,
		<932, 3246, 2948>, 1,
		<933, 2949, 3750>, 1,
		<933, 3750, 1976>, 1,
		<933, 1976, 3997>, 1,
		<933, 3997, 1110>, 1,
		<933, 1110, 3317>, 1,
		<933, 3317, 2946>, 1,
		<933, 2946, 3246>, 1,
		<933, 3246, 2949>, 1,
		<934, 2950, 3314>, 1,
		<934, 3314, 1105>, 1,
		<934, 1105, 3839>, 1,
		<934, 3839, 1106>, 1,
		<934, 1106, 3315>, 1,
		<934, 3315, 2951>, 1,
		<934, 2951, 3247>, 1,
		<934, 3247, 2950>, 1,
		<935, 2951, 3315>, 1,
		<935, 3315, 1107>, 1,
		<935, 1107, 3827>, 1,
		<935, 3827, 1097>, 1,
		<935, 1097, 3310>, 1,
		<935, 3310, 2952>, 1,
		<935, 2952, 3247>, 1,
		<935, 3247, 2951>, 1,
		<936, 2952, 3310>, 1,
		<936, 3310, 1096>, 1,
		<936, 1096, 3994>, 1,
		<936, 3994, 1979>, 1,
		<936, 1979, 3751>, 1,
		<936, 3751, 2953>, 1,
		<936, 2953, 3247>, 1,
		<936, 3247, 2952>, 1,
		<937, 2953, 3751>, 1,
		<937, 3751, 1978>, 1,
		<937, 1978, 3996>, 1,
		<937, 3996, 1104>, 1,
		<937, 1104, 3314>, 1,
		<937, 3314, 2950>, 1,
		<937, 2950, 3247>, 1,
		<937, 3247, 2953>, 1,
		<938, 2954, 3310>, 1,
		<938, 3310, 1097>, 1,
		<938, 1097, 3827>, 1,
		<938, 3827, 1859>, 1,
		<938, 1859, 3691>, 1,
		<938, 3691, 2955>, 1,
		<938, 2955, 3248>, 1,
		<938, 3248, 2954>, 1,
		<939, 2955, 3691>, 1,
		<939, 3691, 1858>, 1,
		<939, 1858, 3995>, 1,
		<939, 3995, 1981>, 1,
		<939, 1981, 3752>, 1,
		<939, 3752, 2956>, 1,
		<939, 2956, 3248>, 1,
		<939, 3248, 2955>, 1,
		<940, 2956, 3752>, 1,
		<940, 3752, 1980>, 1,
		<940, 1980, 3994>, 1,
		<940, 3994, 1096>, 1,
		<940, 1096, 3310>, 1,
		<940, 3310, 2954>, 1,
		<940, 2954, 3248>, 1,
		<940, 3248, 2956>, 1,
		<941, 2957, 3691>, 1,
		<941, 3691, 1859>, 1,
		<941, 1859, 3827>, 1,
		<941, 3827, 1164>, 1,
		<941, 1164, 3344>, 1,
		<941, 3344, 2958>, 1,
		<941, 2958, 3249>, 1,
		<941, 3249, 2957>, 1,
		<942, 2958, 3344>, 1,
		<942, 3344, 1165>, 1,
		<942, 1165, 3828>, 1,
		<942, 3828, 1881>, 1,
		<942, 1881, 3702>, 1,
		<942, 3702, 2959>, 1,
		<942, 2959, 3249>, 1,
		<942, 3249, 2958>, 1,
		<943, 2959, 3702>, 1,
		<943, 3702, 1880>, 1,
		<943, 1880, 4006>, 1,
		<943, 4006, 1983>, 1,
		<943, 1983, 3753>, 1,
		<943, 3753, 2960>, 1,
		<943, 2960, 3249>, 1,
		<943, 3249, 2959>, 1,
		<944, 2960, 3753>, 1,
		<944, 3753, 1982>, 1,
		<944, 1982, 3995>, 1,
		<944, 3995, 1858>, 1,
		<944, 1858, 3691>, 1,
		<944, 3691, 2957>, 1,
		<944, 2957, 3249>, 1,
		<944, 3249, 2960>, 1,
		<945, 2961, 3702>, 1,
		<945, 3702, 1881>, 1,
		<945, 1881, 3828>, 1,
		<945, 3828, 1210>, 1,
		<945, 1210, 3367>, 1,
		<945, 3367, 2962>, 1,
		<945, 2962, 3250>, 1,
		<945, 3250, 2961>, 1,
		<946, 2962, 3367>, 1,
		<946, 3367, 1211>, 1,
		<946, 1211, 3829>, 1,
		<946, 3829, 1885>, 1,
		<946, 1885, 3704>, 1,
		<946, 3704, 2963>, 1,
		<946, 2963, 3250>, 1,
		<946, 3250, 2962>, 1,
		<947, 2963, 3704>, 1,
		<947, 3704, 1884>, 1,
		<947, 1884, 4008>, 1,
		<947, 4008, 1985>, 1,
		<947, 1985, 3754>, 1,
		<947, 3754, 2964>, 1,
		<947, 2964, 3250>, 1,
		<947, 3250, 2963>, 1,
		<948, 2964, 3754>, 1,
		<948, 3754, 1984>, 1,
		<948, 1984, 4006>, 1,
		<948, 4006, 1880>, 1,
		<948, 1880, 3702>, 1,
		<948, 3702, 2961>, 1,
		<948, 2961, 3250>, 1,
		<948, 3250, 2964>, 1,
		<949, 2965, 3704>, 1,
		<949, 3704, 1885>, 1,
		<949, 1885, 3829>, 1,
		<949, 3829, 1256>, 1,
		<949, 1256, 3390>, 1,
		<949, 3390, 2966>, 1,
		<949, 2966, 3251>, 1,
		<949, 3251, 2965>, 1,
		<950, 2966, 3390>, 1,
		<950, 3390, 1257>, 1,
		<950, 1257, 3830>, 1,
		<950, 3830, 1889>, 1,
		<950, 1889, 3706>, 1,
		<950, 3706, 2967>, 1,
		<950, 2967, 3251>, 1,
		<950, 3251, 2966>, 1,
		<951, 2967, 3706>, 1,
		<951, 3706, 1888>, 1,
		<951, 1888, 4010>, 1,
		<951, 4010, 1987>, 1,
		<951, 1987, 3755>, 1,
		<951, 3755, 2968>, 1,
		<951, 2968, 3251>, 1,
		<951, 3251, 2967>, 1,
		<952, 2968, 3755>, 1,
		<952, 3755, 1986>, 1,
		<952, 1986, 4008>, 1,
		<952, 4008, 1884>, 1,
		<952, 1884, 3704>, 1,
		<952, 3704, 2965>, 1,
		<952, 2965, 3251>, 1,
		<952, 3251, 2968>, 1,
		<953, 2969, 3706>, 1,
		<953, 3706, 1889>, 1,
		<953, 1889, 3830>, 1,
		<953, 3830, 1302>, 1,
		<953, 1302, 3413>, 1,
		<953, 3413, 2970>, 1,
		<953, 2970, 3252>, 1,
		<953, 3252, 2969>, 1,
		<954, 2970, 3413>, 1,
		<954, 3413, 1303>, 1,
		<954, 1303, 3831>, 1,
		<954, 3831, 1893>, 1,
		<954, 1893, 3708>, 1,
		<954, 3708, 2971>, 1,
		<954, 2971, 3252>, 1,
		<954, 3252, 2970>, 1,
		<955, 2971, 3708>, 1,
		<955, 3708, 1892>, 1,
		<955, 1892, 4012>, 1,
		<955, 4012, 1989>, 1,
		<955, 1989, 3756>, 1,
		<955, 3756, 2972>, 1,
		<955, 2972, 3252>, 1,
		<955, 3252, 2971>, 1,
		<956, 2972, 3756>, 1,
		<956, 3756, 1988>, 1,
		<956, 1988, 4010>, 1,
		<956, 4010, 1888>, 1,
		<956, 1888, 3706>, 1,
		<956, 3706, 2969>, 1,
		<956, 2969, 3252>, 1,
		<956, 3252, 2972>, 1,
		<957, 2973, 3708>, 1,
		<957, 3708, 1893>, 1,
		<957, 1893, 3831>, 1,
		<957, 3831, 1349>, 1,
		<957, 1349, 3436>, 1,
		<957, 3436, 2974>, 1,
		<957, 2974, 3253>, 1,
		<957, 3253, 2973>, 1,
		<958, 2974, 3436>, 1,
		<958, 3436, 1348>, 1,
		<958, 1348, 3832>, 1,
		<958, 3832, 1897>, 1,
		<958, 1897, 3710>, 1,
		<958, 3710, 2975>, 1,
		<958, 2975, 3253>, 1,
		<958, 3253, 2974>, 1,
		<959, 2975, 3710>, 1,
		<959, 3710, 1896>, 1,
		<959, 1896, 4014>, 1,
		<959, 4014, 1991>, 1,
		<959, 1991, 3757>, 1,
		<959, 3757, 2976>, 1,
		<959, 2976, 3253>, 1,
		<959, 3253, 2975>, 1,
		<960, 2976, 3757>, 1,
		<960, 3757, 1990>, 1,
		<960, 1990, 4012>, 1,
		<960, 4012, 1892>, 1,
		<960, 1892, 3708>, 1,
		<960, 3708, 2973>, 1,
		<960, 2973, 3253>, 1,
		<960, 3253, 2976>, 1,
		<961, 2977, 3710>, 1,
		<961, 3710, 1897>, 1,
		<961, 1897, 3832>, 1,
		<961, 3832, 1394>, 1,
		<961, 1394, 3459>, 1,
		<961, 3459, 2978>, 1,
		<961, 2978, 3254>, 1,
		<961, 3254, 2977>, 1,
		<962, 2978, 3459>, 1,
		<962, 3459, 1395>, 1,
		<962, 1395, 3833>, 1,
		<962, 3833, 1901>, 1,
		<962, 1901, 3712>, 1,
		<962, 3712, 2979>, 1,
		<962, 2979, 3254>, 1,
		<962, 3254, 2978>, 1,
		<963, 2979, 3712>, 1,
		<963, 3712, 1900>, 1,
		<963, 1900, 4016>, 1,
		<963, 4016, 1993>, 1,
		<963, 1993, 3758>, 1,
		<963, 3758, 2980>, 1,
		<963, 2980, 3254>, 1,
		<963, 3254, 2979>, 1,
		<964, 2980, 3758>, 1,
		<964, 3758, 1992>, 1,
		<964, 1992, 4014>, 1,
		<964, 4014, 1896>, 1,
		<964, 1896, 3710>, 1,
		<964, 3710, 2977>, 1,
		<964, 2977, 3254>, 1,
		<964, 3254, 2980>, 1,
		<965, 2981, 3712>, 1,
		<965, 3712, 1901>, 1,
		<965, 1901, 3833>, 1,
		<965, 3833, 1440>, 1,
		<965, 1440, 3482>, 1,
		<965, 3482, 2982>, 1,
		<965, 2982, 3255>, 1,
		<965, 3255, 2981>, 1,
		<966, 2982, 3482>, 1,
		<966, 3482, 1441>, 1,
		<966, 1441, 3834>, 1,
		<966, 3834, 1905>, 1,
		<966, 1905, 3714>, 1,
		<966, 3714, 2983>, 1,
		<966, 2983, 3255>, 1,
		<966, 3255, 2982>, 1,
		<967, 2983, 3714>, 1,
		<967, 3714, 1904>, 1,
		<967, 1904, 4018>, 1,
		<967, 4018, 1995>, 1,
		<967, 1995, 3759>, 1,
		<967, 3759, 2984>, 1,
		<967, 2984, 3255>, 1,
		<967, 3255, 2983>, 1,
		<968, 2984, 3759>, 1,
		<968, 3759, 1994>, 1,
		<968, 1994, 4016>, 1,
		<968, 4016, 1900>, 1,
		<968, 1900, 3712>, 1,
		<968, 3712, 2981>, 1,
		<968, 2981, 3255>, 1,
		<968, 3255, 2984>, 1,
		<969, 2985, 3714>, 1,
		<969, 3714, 1905>, 1,
		<969, 1905, 3834>, 1,
		<969, 3834, 1486>, 1,
		<969, 1486, 3505>, 1,
		<969, 3505, 2986>, 1,
		<969, 2986, 3256>, 1,
		<969, 3256, 2985>, 1,
		<970, 2986, 3505>, 1,
		<970, 3505, 1487>, 1,
		<970, 1487, 3835>, 1,
		<970, 3835, 1909>, 1,
		<970, 1909, 3716>, 1,
		<970, 3716, 2987>, 1,
		<970, 2987, 3256>, 1,
		<970, 3256, 2986>, 1,
		<971, 2987, 3716>, 1,
		<971, 3716, 1908>, 1,
		<971, 1908, 4020>, 1,
		<971, 4020, 1997>, 1,
		<971, 1997, 3760>, 1,
		<971, 3760, 2988>, 1,
		<971, 2988, 3256>, 1,
		<971, 3256, 2987>, 1,
		<972, 2988, 3760>, 1,
		<972, 3760, 1996>, 1,
		<972, 1996, 4018>, 1,
		<972, 4018, 1904>, 1,
		<972, 1904, 3714>, 1,
		<972, 3714, 2985>, 1,
		<972, 2985, 3256>, 1,
		<972, 3256, 2988>, 1,
		<973, 2989, 3716>, 1,
		<973, 3716, 1909>, 1,
		<973, 1909, 3835>, 1,
		<973, 3835, 1532>, 1,
		<973, 1532, 3528>, 1,
		<973, 3528, 2990>, 1,
		<973, 2990, 3257>, 1,
		<973, 3257, 2989>, 1,
		<974, 2990, 3528>, 1,
		<974, 3528, 1533>, 1,
		<974, 1533, 3836>, 1,
		<974, 3836, 1913>, 1,
		<974, 1913, 3718>, 1,
		<974, 3718, 2991>, 1,
		<974, 2991, 3257>, 1,
		<974, 3257, 2990>, 1,
		<975, 2991, 3718>, 1,
		<975, 3718, 1912>, 1,
		<975, 1912, 4022>, 1,
		<975, 4022, 1999>, 1,
		<975, 1999, 3761>, 1,
		<975, 3761, 2992>, 1,
		<975, 2992, 3257>, 1,
		<975, 3257, 2991>, 1,
		<976, 2992, 3761>, 1,
		<976, 3761, 1998>, 1,
		<976, 1998, 4020>, 1,
		<976, 4020, 1908>, 1,
		<976, 1908, 3716>, 1,
		<976, 3716, 2989>, 1,
		<976, 2989, 3257>, 1,
		<976, 3257, 2992>, 1,
		<977, 2993, 3718>, 1,
		<977, 3718, 1913>, 1,
		<977, 1913, 3836>, 1,
		<977, 3836, 1917>, 1,
		<977, 1917, 3720>, 1,
		<977, 3720, 2994>, 1,
		<977, 2994, 3258>, 1,
		<977, 3258, 2993>, 1,
		<978, 2994, 3720>, 1,
		<978, 3720, 1916>, 1,
		<978, 1916, 4024>, 1,
		<978, 4024, 2001>, 1,
		<978, 2001, 3762>, 1,
		<978, 3762, 2995>, 1,
		<978, 2995, 3258>, 1,
		<978, 3258, 2994>, 1,
		<979, 2995, 3762>, 1,
		<979, 3762, 2000>, 1,
		<979, 2000, 4022>, 1,
		<979, 4022, 1912>, 1,
		<979, 1912, 3718>, 1,
		<979, 3718, 2993>, 1,
		<979, 2993, 3258>, 1,
		<979, 3258, 2995>, 1,
		<980, 2996, 3554>, 1,
		<980, 3554, 1585>, 1,
		<980, 1585, 3849>, 1,
		<980, 3849, 1586>, 1,
		<980, 1586, 3555>, 1,
		<980, 3555, 2997>, 1,
		<980, 2997, 3259>, 1,
		<980, 3259, 2996>, 1,
		<981, 2997, 3555>, 1,
		<981, 3555, 1587>, 1,
		<981, 1587, 3837>, 1,
		<981, 3837, 1579>, 1,
		<981, 1579, 3551>, 1,
		<981, 3551, 2998>, 1,
		<981, 2998, 3259>, 1,
		<981, 3259, 2997>, 1,
		<982, 2998, 3551>, 1,
		<982, 3551, 1578>, 1,
		<982, 1578, 4024>, 1,
		<982, 4024, 2003>, 1,
		<982, 2003, 3763>, 1,
		<982, 3763, 2999>, 1,
		<982, 2999, 3259>, 1,
		<982, 3259, 2998>, 1,
		<983, 2999, 3763>, 1,
		<983, 3763, 2002>, 1,
		<983, 2002, 4025>, 1,
		<983, 4025, 1584>, 1,
		<983, 1584, 3554>, 1,
		<983, 3554, 2996>, 1,
		<983, 2996, 3259>, 1,
		<983, 3259, 2999>, 1,
		<984, 3000, 3556>, 1,
		<984, 3556, 1589>, 1,
		<984, 1589, 3861>, 1,
		<984, 3861, 1590>, 1,
		<984, 1590, 3557>, 1,
		<984, 3557, 3001>, 1,
		<984, 3001, 3260>, 1,
		<984, 3260, 3000>, 1,
		<985, 3001, 3557>, 1,
		<985, 3557, 1591>, 1,
		<985, 1591, 3849>, 1,
		<985, 3849, 1585>, 1,
		<985, 1585, 3554>, 1,
		<985, 3554, 3002>, 1,
		<985, 3002, 3260>, 1,
		<985, 3260, 3001>, 1,
		<986, 3002, 3554>, 1,
		<986, 3554, 1584>, 1,
		<986, 1584, 4025>, 1,
		<986, 4025, 2005>, 1,
		<986, 2005, 3764>, 1,
		<986, 3764, 3003>, 1,
		<986, 3003, 3260>, 1,
		<986, 3260, 3002>, 1,
		<987, 3003, 3764>, 1,
		<987, 3764, 2004>, 1,
		<987, 2004, 4026>, 1,
		<987, 4026, 1588>, 1,
		<987, 1588, 3556>, 1,
		<987, 3556, 3000>, 1,
		<987, 3000, 3260>, 1,
		<987, 3260, 3003>, 1,
		<988, 3004, 3558>, 1,
		<988, 3558, 1593>, 1,
		<988, 1593, 3873>, 1,
		<988, 3873, 1594>, 1,
		<988, 1594, 3559>, 1,
		<988, 3559, 3005>, 1,
		<988, 3005, 3261>, 1,
		<988, 3261, 3004>, 1,
		<989, 3005, 3559>, 1,
		<989, 3559, 1595>, 1,
		<989, 1595, 3861>, 1,
		<989, 3861, 1589>, 1,
		<989, 1589, 3556>, 1,
		<989, 3556, 3006>, 1,
		<989, 3006, 3261>, 1,
		<989, 3261, 3005>, 1,
		<990, 3006, 3556>, 1,
		<990, 3556, 1588>, 1,
		<990, 1588, 4026>, 1,
		<990, 4026, 2007>, 1,
		<990, 2007, 3765>, 1,
		<990, 3765, 3007>, 1,
		<990, 3007, 3261>, 1,
		<990, 3261, 3006>, 1,
		<991, 3007, 3765>, 1,
		<991, 3765, 2006>, 1,
		<991, 2006, 4027>, 1,
		<991, 4027, 1592>, 1,
		<991, 1592, 3558>, 1,
		<991, 3558, 3004>, 1,
		<991, 3004, 3261>, 1,
		<991, 3261, 3007>, 1,
		<992, 3008, 3560>, 1,
		<992, 3560, 1597>, 1,
		<992, 1597, 3885>, 1,
		<992, 3885, 1598>, 1,
		<992, 1598, 3561>, 1,
		<992, 3561, 3009>, 1,
		<992, 3009, 3262>, 1,
		<992, 3262, 3008>, 1,
		<993, 3009, 3561>, 1,
		<993, 3561, 1599>, 1,
		<993, 1599, 3873>, 1,
		<993, 3873, 1593>, 1,
		<993, 1593, 3558>, 1,
		<993, 3558, 3010>, 1,
		<993, 3010, 3262>, 1,
		<993, 3262, 3009>, 1,
		<994, 3010, 3558>, 1,
		<994, 3558, 1592>, 1,
		<994, 1592, 4027>, 1,
		<994, 4027, 2009>, 1,
		<994, 2009, 3766>, 1,
		<994, 3766, 3011>, 1,
		<994, 3011, 3262>, 1,
		<994, 3262, 3010>, 1,
		<995, 3011, 3766>, 1,
		<995, 3766, 2008>, 1,
		<995, 2008, 4028>, 1,
		<995, 4028, 1596>, 1,
		<995, 1596, 3560>, 1,
		<995, 3560, 3008>, 1,
		<995, 3008, 3262>, 1,
		<995, 3262, 3011>, 1,
		<996, 3012, 3562>, 1,
		<996, 3562, 1601>, 1,
		<996, 1601, 3897>, 1,
		<996, 3897, 1602>, 1,
		<996, 1602, 3563>, 1,
		<996, 3563, 3013>, 1,
		<996, 3013, 3263>, 1,
		<996, 3263, 3012>, 1,
		<997, 3013, 3563>, 1,
		<997, 3563, 1603>, 1,
		<997, 1603, 3885>, 1,
		<997, 3885, 1597>, 1,
		<997, 1597, 3560>, 1,
		<997, 3560, 3014>, 1,
		<997, 3014, 3263>, 1,
		<997, 3263, 3013>, 1,
		<998, 3014, 3560>, 1,
		<998, 3560, 1596>, 1,
		<998, 1596, 4028>, 1,
		<998, 4028, 2011>, 1,
		<998, 2011, 3767>, 1,
		<998, 3767, 3015>, 1,
		<998, 3015, 3263>, 1,
		<998, 3263, 3014>, 1,
		<999, 3015, 3767>, 1,
		<999, 3767, 2010>, 1,
		<999, 2010, 4029>, 1,
		<999, 4029, 1600>, 1,
		<999, 1600, 3562>, 1,
		<999, 3562, 3012>, 1,
		<999, 3012, 3263>, 1,
		<999, 3263, 3015>, 1,
		<1000, 3016, 3564>, 1,
		<1000, 3564, 1605>, 1,
		<1000, 1605, 3909>, 1,
		<1000, 3909, 1606>, 1,
		<1000, 1606, 3565>, 1,
		<1000, 3565, 3017>, 1,
		<1000, 3017, 3264>, 1,
		<1000, 3264, 3016>, 1,
		<1001, 3017, 3565>, 1,
		<1001, 3565, 1607>, 1,
		<1001, 1607, 3897>, 1,
		<1001, 3897, 1601>, 1,
		<1001, 1601, 3562>, 1,
		<1001, 3562, 3018>, 1,
		<1001, 3018, 3264>, 1,
		<1001, 3264, 3017>, 1,
		<1002, 3018, 3562>, 1,
		<1002, 3562, 1600>, 1,
		<1002, 1600, 4029>, 1,
		<1002, 4029, 2013>, 1,
		<1002, 2013, 3768>, 1,
		<1002, 3768, 3019>, 1,
		<1002, 3019, 3264>, 1,
		<1002, 3264, 3018>, 1,
		<1003, 3019, 3768>, 1,
		<1003, 3768, 2012>, 1,
		<1003, 2012, 4030>, 1,
		<1003, 4030, 1604>, 1,
		<1003, 1604, 3564>, 1,
		<1003, 3564, 3016>, 1,
		<1003, 3016, 3264>, 1,
		<1003, 3264, 3019>, 1,
		<1004, 3020, 3566>, 1,
		<1004, 3566, 1609>, 1,
		<1004, 1609, 3921>, 1,
		<1004, 3921, 1610>, 1,
		<1004, 1610, 3567>, 1,
		<1004, 3567, 3021>, 1,
		<1004, 3021, 3265>, 1,
		<1004, 3265, 3020>, 1,
		<1005, 3021, 3567>, 1,
		<1005, 3567, 1611>, 1,
		<1005, 1611, 3909>, 1,
		<1005, 3909, 1605>, 1,
		<1005, 1605, 3564>, 1,
		<1005, 3564, 3022>, 1,
		<1005, 3022, 3265>, 1,
		<1005, 3265, 3021>, 1,
		<1006, 3022, 3564>, 1,
		<1006, 3564, 1604>, 1,
		<1006, 1604, 4030>, 1,
		<1006, 4030, 2015>, 1,
		<1006, 2015, 3769>, 1,
		<1006, 3769, 3023>, 1,
		<1006, 3023, 3265>, 1,
		<1006, 3265, 3022>, 1,
		<1007, 3023, 3769>, 1,
		<1007, 3769, 2014>, 1,
		<1007, 2014, 4031>, 1,
		<1007, 4031, 1608>, 1,
		<1007, 1608, 3566>, 1,
		<1007, 3566, 3020>, 1,
		<1007, 3020, 3265>, 1,
		<1007, 3265, 3023>, 1
		}
	uv_indices {
		8064, 
		<0, 1, 2>,
		<3, 4, 5>,
		<6, 7, 8>,
		<9, 10, 11>,
		<12, 13, 14>,
		<15, 16, 17>,
		<18, 19, 20>,
		<21, 22, 23>,
		<24, 25, 26>,
		<27, 28, 29>,
		<30, 31, 32>,
		<33, 34, 35>,
		<36, 37, 38>,
		<39, 40, 41>,
		<42, 43, 44>,
		<45, 46, 47>,
		<48, 49, 50>,
		<51, 52, 53>,
		<54, 55, 56>,
		<57, 58, 59>,
		<60, 61, 62>,
		<63, 64, 65>,
		<66, 67, 68>,
		<69, 70, 71>,
		<72, 73, 74>,
		<75, 76, 77>,
		<78, 79, 80>,
		<81, 82, 83>,
		<84, 85, 86>,
		<87, 88, 89>,
		<90, 91, 92>,
		<93, 94, 95>,
		<96, 97, 98>,
		<99, 100, 101>,
		<102, 103, 104>,
		<105, 106, 107>,
		<108, 109, 110>,
		<111, 112, 113>,
		<114, 115, 116>,
		<117, 118, 119>,
		<120, 121, 122>,
		<123, 124, 125>,
		<126, 127, 128>,
		<129, 130, 131>,
		<132, 133, 134>,
		<135, 136, 137>,
		<138, 139, 140>,
		<141, 142, 143>,
		<144, 145, 146>,
		<147, 148, 149>,
		<150, 151, 152>,
		<153, 154, 155>,
		<156, 157, 158>,
		<159, 160, 161>,
		<162, 163, 164>,
		<165, 166, 167>,
		<168, 169, 170>,
		<171, 172, 173>,
		<174, 175, 176>,
		<177, 178, 179>,
		<180, 181, 182>,
		<183, 184, 185>,
		<186, 187, 188>,
		<189, 190, 191>,
		<192, 193, 194>,
		<195, 196, 197>,
		<198, 199, 200>,
		<201, 202, 203>,
		<204, 205, 206>,
		<207, 208, 209>,
		<210, 211, 212>,
		<213, 214, 215>,
		<216, 217, 218>,
		<219, 220, 221>,
		<222, 223, 224>,
		<225, 226, 227>,
		<228, 229, 230>,
		<231, 232, 233>,
		<234, 235, 236>,
		<237, 238, 239>,
		<240, 241, 242>,
		<243, 244, 245>,
		<246, 247, 248>,
		<249, 250, 251>,
		<252, 253, 254>,
		<255, 256, 257>,
		<258, 259, 260>,
		<261, 262, 263>,
		<264, 265, 266>,
		<267, 268, 269>,
		<270, 271, 272>,
		<273, 274, 275>,
		<276, 277, 278>,
		<279, 280, 281>,
		<282, 283, 284>,
		<285, 286, 287>,
		<288, 289, 290>,
		<291, 292, 293>,
		<294, 295, 296>,
		<297, 298, 299>,
		<300, 301, 302>,
		<303, 304, 305>,
		<306, 307, 308>,
		<309, 310, 311>,
		<312, 313, 314>,
		<315, 316, 317>,
		<318, 319, 320>,
		<321, 322, 323>,
		<324, 325, 326>,
		<327, 328, 329>,
		<330, 331, 332>,
		<333, 334, 335>,
		<336, 337, 338>,
		<339, 340, 341>,
		<342, 343, 344>,
		<345, 346, 347>,
		<348, 349, 350>,
		<351, 352, 353>,
		<354, 355, 356>,
		<357, 358, 359>,
		<360, 361, 362>,
		<363, 364, 365>,
		<366, 367, 368>,
		<369, 370, 371>,
		<372, 373, 374>,
		<375, 376, 377>,
		<378, 379, 380>,
		<381, 382, 383>,
		<384, 385, 386>,
		<387, 388, 389>,
		<390, 391, 392>,
		<393, 394, 395>,
		<396, 397, 398>,
		<399, 400, 401>,
		<402, 403, 404>,
		<405, 406, 407>,
		<408, 409, 410>,
		<411, 412, 413>,
		<414, 415, 416>,
		<417, 418, 419>,
		<420, 421, 422>,
		<423, 424, 425>,
		<426, 427, 428>,
		<429, 430, 431>,
		<432, 433, 434>,
		<435, 436, 437>,
		<438, 439, 440>,
		<441, 442, 443>,
		<444, 445, 446>,
		<447, 448, 449>,
		<450, 451, 452>,
		<453, 454, 455>,
		<456, 457, 458>,
		<459, 460, 461>,
		<462, 463, 464>,
		<465, 466, 467>,
		<468, 469, 470>,
		<471, 472, 473>,
		<474, 475, 476>,
		<477, 478, 479>,
		<480, 481, 482>,
		<483, 484, 485>,
		<486, 487, 488>,
		<489, 490, 491>,
		<492, 493, 494>,
		<495, 496, 497>,
		<498, 499, 500>,
		<501, 502, 503>,
		<504, 505, 506>,
		<507, 508, 509>,
		<510, 511, 512>,
		<513, 514, 515>,
		<516, 517, 518>,
		<519, 520, 521>,
		<522, 523, 524>,
		<525, 526, 527>,
		<528, 529, 530>,
		<531, 532, 533>,
		<534, 535, 536>,
		<537, 538, 539>,
		<540, 541, 542>,
		<543, 544, 545>,
		<546, 547, 548>,
		<549, 550, 551>,
		<552, 553, 554>,
		<555, 556, 557>,
		<558, 559, 560>,
		<561, 562, 563>,
		<564, 565, 566>,
		<567, 568, 569>,
		<570, 571, 572>,
		<573, 574, 575>,
		<576, 577, 578>,
		<579, 580, 581>,
		<582, 583, 584>,
		<585, 586, 587>,
		<588, 589, 590>,
		<591, 592, 593>,
		<594, 595, 596>,
		<597, 598, 599>,
		<600, 601, 602>,
		<603, 604, 605>,
		<606, 607, 608>,
		<609, 610, 611>,
		<612, 613, 614>,
		<615, 616, 617>,
		<618, 619, 620>,
		<621, 622, 623>,
		<624, 625, 626>,
		<627, 628, 629>,
		<630, 631, 632>,
		<633, 634, 635>,
		<636, 637, 638>,
		<639, 640, 641>,
		<642, 643, 644>,
		<645, 646, 647>,
		<648, 649, 650>,
		<651, 652, 653>,
		<654, 655, 656>,
		<657, 658, 659>,
		<660, 661, 662>,
		<663, 664, 665>,
		<666, 667, 668>,
		<669, 670, 671>,
		<672, 673, 674>,
		<675, 676, 677>,
		<678, 679, 680>,
		<681, 682, 683>,
		<684, 685, 686>,
		<687, 688, 689>,
		<690, 691, 692>,
		<693, 694, 695>,
		<696, 697, 698>,
		<699, 700, 701>,
		<702, 703, 704>,
		<705, 706, 707>,
		<708, 709, 710>,
		<711, 712, 713>,
		<714, 715, 716>,
		<717, 718, 719>,
		<720, 721, 722>,
		<723, 724, 725>,
		<726, 727, 728>,
		<729, 730, 731>,
		<732, 733, 734>,
		<735, 736, 737>,
		<738, 739, 740>,
		<741, 742, 743>,
		<744, 745, 746>,
		<747, 748, 749>,
		<750, 751, 752>,
		<753, 754, 755>,
		<756, 757, 758>,
		<759, 760, 761>,
		<762, 763, 764>,
		<765, 766, 767>,
		<768, 769, 770>,
		<771, 772, 773>,
		<774, 775, 776>,
		<777, 778, 779>,
		<780, 781, 782>,
		<783, 784, 785>,
		<786, 787, 788>,
		<789, 790, 791>,
		<792, 793, 794>,
		<795, 796, 797>,
		<798, 799, 800>,
		<801, 802, 803>,
		<804, 805, 806>,
		<807, 808, 809>,
		<810, 811, 812>,
		<813, 814, 815>,
		<816, 817, 818>,
		<819, 820, 821>,
		<822, 823, 824>,
		<825, 826, 827>,
		<828, 829, 830>,
		<831, 832, 833>,
		<834, 835, 836>,
		<837, 838, 839>,
		<840, 841, 842>,
		<843, 844, 845>,
		<846, 847, 848>,
		<849, 850, 851>,
		<852, 853, 854>,
		<855, 856, 857>,
		<858, 859, 860>,
		<861, 862, 863>,
		<864, 865, 866>,
		<867, 868, 869>,
		<870, 871, 872>,
		<873, 874, 875>,
		<876, 877, 878>,
		<879, 880, 881>,
		<882, 883, 884>,
		<885, 886, 887>,
		<888, 889, 890>,
		<891, 892, 893>,
		<894, 895, 896>,
		<897, 898, 899>,
		<900, 901, 902>,
		<903, 904, 905>,
		<906, 907, 908>,
		<909, 910, 911>,
		<912, 913, 914>,
		<915, 916, 917>,
		<918, 919, 920>,
		<921, 922, 923>,
		<924, 925, 926>,
		<927, 928, 929>,
		<930, 931, 932>,
		<933, 934, 935>,
		<936, 937, 938>,
		<939, 940, 941>,
		<942, 943, 944>,
		<945, 946, 947>,
		<948, 949, 950>,
		<951, 952, 953>,
		<954, 955, 956>,
		<957, 958, 959>,
		<960, 961, 962>,
		<963, 964, 965>,
		<966, 967, 968>,
		<969, 970, 971>,
		<972, 973, 974>,
		<975, 976, 977>,
		<978, 979, 980>,
		<981, 982, 983>,
		<984, 985, 986>,
		<987, 988, 989>,
		<990, 991, 992>,
		<993, 994, 995>,
		<996, 997, 998>,
		<999, 1000, 1001>,
		<1002, 1003, 1004>,
		<1005, 1006, 1007>,
		<1008, 1009, 1010>,
		<1011, 1012, 1013>,
		<1014, 1015, 1016>,
		<1017, 1018, 1019>,
		<1020, 1021, 1022>,
		<1023, 1024, 1025>,
		<1026, 1027, 1028>,
		<1029, 1030, 1031>,
		<1032, 1033, 1034>,
		<1035, 1036, 1037>,
		<1038, 1039, 1040>,
		<1041, 1042, 1043>,
		<1044, 1045, 1046>,
		<1047, 1048, 1049>,
		<1050, 1051, 1052>,
		<1053, 1054, 1055>,
		<1056, 1057, 1058>,
		<1059, 1060, 1061>,
		<1062, 1063, 1064>,
		<1065, 1066, 1067>,
		<1068, 1069, 1070>,
		<1071, 1072, 1073>,
		<1074, 1075, 1076>,
		<1077, 1078, 1079>,
		<1080, 1081, 1082>,
		<1083, 1084, 1085>,
		<1086, 1087, 1088>,
		<1089, 1090, 1091>,
		<1092, 1093, 1094>,
		<1095, 1096, 1097>,
		<1098, 1099, 1100>,
		<1101, 1102, 1103>,
		<1104, 1105, 1106>,
		<1107, 1108, 1109>,
		<1110, 1111, 1112>,
		<1113, 1114, 1115>,
		<1116, 1117, 1118>,
		<1119, 1120, 1121>,
		<1122, 1123, 1124>,
		<1125, 1126, 1127>,
		<1128, 1129, 1130>,
		<1131, 1132, 1133>,
		<1134, 1135, 1136>,
		<1137, 1138, 1139>,
		<1140, 1141, 1142>,
		<1143, 1144, 1145>,
		<1146, 1147, 1148>,
		<1149, 1150, 1151>,
		<1152, 1153, 1154>,
		<1155, 1156, 1157>,
		<1158, 1159, 1160>,
		<1161, 1162, 1163>,
		<1164, 1165, 1166>,
		<1167, 1168, 1169>,
		<1170, 1171, 1172>,
		<1173, 1174, 1175>,
		<1176, 1177, 1178>,
		<1179, 1180, 1181>,
		<1182, 1183, 1184>,
		<1185, 1186, 1187>,
		<1188, 1189, 1190>,
		<1191, 1192, 1193>,
		<1194, 1195, 1196>,
		<1197, 1198, 1199>,
		<1200, 1201, 1202>,
		<1203, 1204, 1205>,
		<1206, 1207, 1208>,
		<1209, 1210, 1211>,
		<1212, 1213, 1214>,
		<1215, 1216, 1217>,
		<1218, 1219, 1220>,
		<1221, 1222, 1223>,
		<1224, 1225, 1226>,
		<1227, 1228, 1229>,
		<1230, 1231, 1232>,
		<1233, 1234, 1235>,
		<1236, 1237, 1238>,
		<1239, 1240, 1241>,
		<1242, 1243, 1244>,
		<1245, 1246, 1247>,
		<1248, 1249, 1250>,
		<1251, 1252, 1253>,
		<1254, 1255, 1256>,
		<1257, 1258, 1259>,
		<1260, 1261, 1262>,
		<1263, 1264, 1265>,
		<1266, 1267, 1268>,
		<1269, 1270, 1271>,
		<1272, 1273, 1274>,
		<1275, 1276, 1277>,
		<1278, 1279, 1280>,
		<1281, 1282, 1283>,
		<1284, 1285, 1286>,
		<1287, 1288, 1289>,
		<1290, 1291, 1292>,
		<1293, 1294, 1295>,
		<1296, 1297, 1298>,
		<1299, 1300, 1301>,
		<1302, 1303, 1304>,
		<1305, 1306, 1307>,
		<1308, 1309, 1310>,
		<1311, 1312, 1313>,
		<1314, 1315, 1316>,
		<1317, 1318, 1319>,
		<1320, 1321, 1322>,
		<1323, 1324, 1325>,
		<1326, 1327, 1328>,
		<1329, 1330, 1331>,
		<1332, 1333, 1334>,
		<1335, 1336, 1337>,
		<1338, 1339, 1340>,
		<1341, 1342, 1343>,
		<1344, 1345, 1346>,
		<1347, 1348, 1349>,
		<1350, 1351, 1352>,
		<1353, 1354, 1355>,
		<1356, 1357, 1358>,
		<1359, 1360, 1361>,
		<1362, 1363, 1364>,
		<1365, 1366, 1367>,
		<1368, 1369, 1370>,
		<1371, 1372, 1373>,
		<1374, 1375, 1376>,
		<1377, 1378, 1379>,
		<1380, 1381, 1382>,
		<1383, 1384, 1385>,
		<1386, 1387, 1388>,
		<1389, 1390, 1391>,
		<1392, 1393, 1394>,
		<1395, 1396, 1397>,
		<1398, 1399, 1400>,
		<1401, 1402, 1403>,
		<1404, 1405, 1406>,
		<1407, 1408, 1409>,
		<1410, 1411, 1412>,
		<1413, 1414, 1415>,
		<1416, 1417, 1418>,
		<1419, 1420, 1421>,
		<1422, 1423, 1424>,
		<1425, 1426, 1427>,
		<1428, 1429, 1430>,
		<1431, 1432, 1433>,
		<1434, 1435, 1436>,
		<1437, 1438, 1439>,
		<1440, 1441, 1442>,
		<1443, 1444, 1445>,
		<1446, 1447, 1448>,
		<1449, 1450, 1451>,
		<1452, 1453, 1454>,
		<1455, 1456, 1457>,
		<1458, 1459, 1460>,
		<1461, 1462, 1463>,
		<1464, 1465, 1466>,
		<1467, 1468, 1469>,
		<1470, 1471, 1472>,
		<1473, 1474, 1475>,
		<1476, 1477, 1478>,
		<1479, 1480, 1481>,
		<1482, 1483, 1484>,
		<1485, 1486, 1487>,
		<1488, 1489, 1490>,
		<1491, 1492, 1493>,
		<1494, 1495, 1496>,
		<1497, 1498, 1499>,
		<1500, 1501, 1502>,
		<1503, 1504, 1505>,
		<1506, 1507, 1508>,
		<1509, 1510, 1511>,
		<1512, 1513, 1514>,
		<1515, 1516, 1517>,
		<1518, 1519, 1520>,
		<1521, 1522, 1523>,
		<1524, 1525, 1526>,
		<1527, 1528, 1529>,
		<1530, 1531, 1532>,
		<1533, 1534, 1535>,
		<1536, 1537, 1538>,
		<1539, 1540, 1541>,
		<1542, 1543, 1544>,
		<1545, 1546, 1547>,
		<1548, 1549, 1550>,
		<1551, 1552, 1553>,
		<1554, 1555, 1556>,
		<1557, 1558, 1559>,
		<1560, 1561, 1562>,
		<1563, 1564, 1565>,
		<1566, 1567, 1568>,
		<1569, 1570, 1571>,
		<1572, 1573, 1574>,
		<1575, 1576, 1577>,
		<1578, 1579, 1580>,
		<1581, 1582, 1583>,
		<1584, 1585, 1586>,
		<1587, 1588, 1589>,
		<1590, 1591, 1592>,
		<1593, 1594, 1595>,
		<1596, 1597, 1598>,
		<1599, 1600, 1601>,
		<1602, 1603, 1604>,
		<1605, 1606, 1607>,
		<1608, 1609, 1610>,
		<1611, 1612, 1613>,
		<1614, 1615, 1616>,
		<1617, 1618, 1619>,
		<1620, 1621, 1622>,
		<1623, 1624, 1625>,
		<1626, 1627, 1628>,
		<1629, 1630, 1631>,
		<1632, 1633, 1634>,
		<1635, 1636, 1637>,
		<1638, 1639, 1640>,
		<1641, 1642, 1643>,
		<1644, 1645, 1646>,
		<1647, 1648, 1649>,
		<1650, 1651, 1652>,
		<1653, 1654, 1655>,
		<1656, 1657, 1658>,
		<1659, 1660, 1661>,
		<1662, 1663, 1664>,
		<1665, 1666, 1667>,
		<1668, 1669, 1670>,
		<1671, 1672, 1673>,
		<1674, 1675, 1676>,
		<1677, 1678, 1679>,
		<1680, 1681, 1682>,
		<1683, 1684, 1685>,
		<1686, 1687, 1688>,
		<1689, 1690, 1691>,
		<1692, 1693, 1694>,
		<1695, 1696, 1697>,
		<1698, 1699, 1700>,
		<1701, 1702, 1703>,
		<1704, 1705, 1706>,
		<1707, 1708, 1709>,
		<1710, 1711, 1712>,
		<1713, 1714, 1715>,
		<1716, 1717, 1718>,
		<1719, 1720, 1721>,
		<1722, 1723, 1724>,
		<1725, 1726, 1727>,
		<1728, 1729, 1730>,
		<1731, 1732, 1733>,
		<1734, 1735, 1736>,
		<1737, 1738, 1739>,
		<1740, 1741, 1742>,
		<1743, 1744, 1745>,
		<1746, 1747, 1748>,
		<1749, 1750, 1751>,
		<1752, 1753, 1754>,
		<1755, 1756, 1757>,
		<1758, 1759, 1760>,
		<1761, 1762, 1763>,
		<1764, 1765, 1766>,
		<1767, 1768, 1769>,
		<1770, 1771, 1772>,
		<1773, 1774, 1775>,
		<1776, 1777, 1778>,
		<1779, 1780, 1781>,
		<1782, 1783, 1784>,
		<1785, 1786, 1787>,
		<1788, 1789, 1790>,
		<1791, 1792, 1793>,
		<1794, 1795, 1796>,
		<1797, 1798, 1799>,
		<1800, 1801, 1802>,
		<1803, 1804, 1805>,
		<1806, 1807, 1808>,
		<1809, 1810, 1811>,
		<1812, 1813, 1814>,
		<1815, 1816, 1817>,
		<1818, 1819, 1820>,
		<1821, 1822, 1823>,
		<1824, 1825, 1826>,
		<1827, 1828, 1829>,
		<1830, 1831, 1832>,
		<1833, 1834, 1835>,
		<1836, 1837, 1838>,
		<1839, 1840, 1841>,
		<1842, 1843, 1844>,
		<1845, 1846, 1847>,
		<1848, 1849, 1850>,
		<1851, 1852, 1853>,
		<1854, 1855, 1856>,
		<1857, 1858, 1859>,
		<1860, 1861, 1862>,
		<1863, 1864, 1865>,
		<1866, 1867, 1868>,
		<1869, 1870, 1871>,
		<1872, 1873, 1874>,
		<1875, 1876, 1877>,
		<1878, 1879, 1880>,
		<1881, 1882, 1883>,
		<1884, 1885, 1886>,
		<1887, 1888, 1889>,
		<1890, 1891, 1892>,
		<1893, 1894, 1895>,
		<1896, 1897, 1898>,
		<1899, 1900, 1901>,
		<1902, 1903, 1904>,
		<1905, 1906, 1907>,
		<1908, 1909, 1910>,
		<1911, 1912, 1913>,
		<1914, 1915, 1916>,
		<1917, 1918, 1919>,
		<1920, 1921, 1922>,
		<1923, 1924, 1925>,
		<1926, 1927, 1928>,
		<1929, 1930, 1931>,
		<1932, 1933, 1934>,
		<1935, 1936, 1937>,
		<1938, 1939, 1940>,
		<1941, 1942, 1943>,
		<1944, 1945, 1946>,
		<1947, 1948, 1949>,
		<1950, 1951, 1952>,
		<1953, 1954, 1955>,
		<1956, 1957, 1958>,
		<1959, 1960, 1961>,
		<1962, 1963, 1964>,
		<1965, 1966, 1967>,
		<1968, 1969, 1970>,
		<1971, 1972, 1973>,
		<1974, 1975, 1976>,
		<1977, 1978, 1979>,
		<1980, 1981, 1982>,
		<1983, 1984, 1985>,
		<1986, 1987, 1988>,
		<1989, 1990, 1991>,
		<1992, 1993, 1994>,
		<1995, 1996, 1997>,
		<1998, 1999, 2000>,
		<2001, 2002, 2003>,
		<2004, 2005, 2006>,
		<2007, 2008, 2009>,
		<2010, 2011, 2012>,
		<2013, 2014, 2015>,
		<2016, 2017, 2018>,
		<2019, 2020, 2021>,
		<2022, 2023, 2024>,
		<2025, 2026, 2027>,
		<2028, 2029, 2030>,
		<2031, 2032, 2033>,
		<2034, 2035, 2036>,
		<2037, 2038, 2039>,
		<2040, 2041, 2042>,
		<2043, 2044, 2045>,
		<2046, 2047, 2048>,
		<2049, 2050, 2051>,
		<2052, 2053, 2054>,
		<2055, 2056, 2057>,
		<2058, 2059, 2060>,
		<2061, 2062, 2063>,
		<2064, 2065, 2066>,
		<2067, 2068, 2069>,
		<2070, 2071, 2072>,
		<2073, 2074, 2075>,
		<2076, 2077, 2078>,
		<2079, 2080, 2081>,
		<2082, 2083, 2084>,
		<2085, 2086, 2087>,
		<2088, 2089, 2090>,
		<2091, 2092, 2093>,
		<2094, 2095, 2096>,
		<2097, 2098, 2099>,
		<2100, 2101, 2102>,
		<2103, 2104, 2105>,
		<2106, 2107, 2108>,
		<2109, 2110, 2111>,
		<2112, 2113, 2114>,
		<2115, 2116, 2117>,
		<2118, 2119, 2120>,
		<2121, 2122, 2123>,
		<2124, 2125, 2126>,
		<2127, 2128, 2129>,
		<2130, 2131, 2132>,
		<2133, 2134, 2135>,
		<2136, 2137, 2138>,
		<2139, 2140, 2141>,
		<2142, 2143, 2144>,
		<2145, 2146, 2147>,
		<2148, 2149, 2150>,
		<2151, 2152, 2153>,
		<2154, 2155, 2156>,
		<2157, 2158, 2159>,
		<2160, 2161, 2162>,
		<2163, 2164, 2165>,
		<2166, 2167, 2168>,
		<2169, 2170, 2171>,
		<2172, 2173, 2174>,
		<2175, 2176, 2177>,
		<2178, 2179, 2180>,
		<2181, 2182, 2183>,
		<2184, 2185, 2186>,
		<2187, 2188, 2189>,
		<2190, 2191, 2192>,
		<2193, 2194, 2195>,
		<2196, 2197, 2198>,
		<2199, 2200, 2201>,
		<2202, 2203, 2204>,
		<2205, 2206, 2207>,
		<2208, 2209, 2210>,
		<2211, 2212, 2213>,
		<2214, 2215, 2216>,
		<2217, 2218, 2219>,
		<2220, 2221, 2222>,
		<2223, 2224, 2225>,
		<2226, 2227, 2228>,
		<2229, 2230, 2231>,
		<2232, 2233, 2234>,
		<2235, 2236, 2237>,
		<2238, 2239, 2240>,
		<2241, 2242, 2243>,
		<2244, 2245, 2246>,
		<2247, 2248, 2249>,
		<2250, 2251, 2252>,
		<2253, 2254, 2255>,
		<2256, 2257, 2258>,
		<2259, 2260, 2261>,
		<2262, 2263, 2264>,
		<2265, 2266, 2267>,
		<2268, 2269, 2270>,
		<2271, 2272, 2273>,
		<2274, 2275, 2276>,
		<2277, 2278, 2279>,
		<2280, 2281, 2282>,
		<2283, 2284, 2285>,
		<2286, 2287, 2288>,
		<2289, 2290, 2291>,
		<2292, 2293, 2294>,
		<2295, 2296, 2297>,
		<2298, 2299, 2300>,
		<2301, 2302, 2303>,
		<2304, 2305, 2306>,
		<2307, 2308, 2309>,
		<2310, 2311, 2312>,
		<2313, 2314, 2315>,
		<2316, 2317, 2318>,
		<2319, 2320, 2321>,
		<2322, 2323, 2324>,
		<2325, 2326, 2327>,
		<2328, 2329, 2330>,
		<2331, 2332, 2333>,
		<2334, 2335, 2336>,
		<2337, 2338, 2339>,
		<2340, 2341, 2342>,
		<2343, 2344, 2345>,
		<2346, 2347, 2348>,
		<2349, 2350, 2351>,
		<2352, 2353, 2354>,
		<2355, 2356, 2357>,
		<2358, 2359, 2360>,
		<2361, 2362, 2363>,
		<2364, 2365, 2366>,
		<2367, 2368, 2369>,
		<2370, 2371, 2372>,
		<2373, 2374, 2375>,
		<2376, 2377, 2378>,
		<2379, 2380, 2381>,
		<2382, 2383, 2384>,
		<2385, 2386, 2387>,
		<2388, 2389, 2390>,
		<2391, 2392, 2393>,
		<2394, 2395, 2396>,
		<2397, 2398, 2399>,
		<2400, 2401, 2402>,
		<2403, 2404, 2405>,
		<2406, 2407, 2408>,
		<2409, 2410, 2411>,
		<2412, 2413, 2414>,
		<2415, 2416, 2417>,
		<2418, 2419, 2420>,
		<2421, 2422, 2423>,
		<2424, 2425, 2426>,
		<2427, 2428, 2429>,
		<2430, 2431, 2432>,
		<2433, 2434, 2435>,
		<2436, 2437, 2438>,
		<2439, 2440, 2441>,
		<2442, 2443, 2444>,
		<2445, 2446, 2447>,
		<2448, 2449, 2450>,
		<2451, 2452, 2453>,
		<2454, 2455, 2456>,
		<2457, 2458, 2459>,
		<2460, 2461, 2462>,
		<2463, 2464, 2465>,
		<2466, 2467, 2468>,
		<2469, 2470, 2471>,
		<2472, 2473, 2474>,
		<2475, 2476, 2477>,
		<2478, 2479, 2480>,
		<2481, 2482, 2483>,
		<2484, 2485, 2486>,
		<2487, 2488, 2489>,
		<2490, 2491, 2492>,
		<2493, 2494, 2495>,
		<2496, 2497, 2498>,
		<2499, 2500, 2501>,
		<2502, 2503, 2504>,
		<2505, 2506, 2507>,
		<2508, 2509, 2510>,
		<2511, 2512, 2513>,
		<2514, 2515, 2516>,
		<2517, 2518, 2519>,
		<2520, 2521, 2522>,
		<2523, 2524, 2525>,
		<2526, 2527, 2528>,
		<2529, 2530, 2531>,
		<2532, 2533, 2534>,
		<2535, 2536, 2537>,
		<2538, 2539, 2540>,
		<2541, 2542, 2543>,
		<2544, 2545, 2546>,
		<2547, 2548, 2549>,
		<2550, 2551, 2552>,
		<2553, 2554, 2555>,
		<2556, 2557, 2558>,
		<2559, 2560, 2561>,
		<2562, 2563, 2564>,
		<2565, 2566, 2567>,
		<2568, 2569, 2570>,
		<2571, 2572, 2573>,
		<2574, 2575, 2576>,
		<2577, 2578, 2579>,
		<2580, 2581, 2582>,
		<2583, 2584, 2585>,
		<2586, 2587, 2588>,
		<2589, 2590, 2591>,
		<2592, 2593, 2594>,
		<2595, 2596, 2597>,
		<2598, 2599, 2600>,
		<2601, 2602, 2603>,
		<2604, 2605, 2606>,
		<2607, 2608, 2609>,
		<2610, 2611, 2612>,
		<2613, 2614, 2615>,
		<2616, 2617, 2618>,
		<2619, 2620, 2621>,
		<2622, 2623, 2624>,
		<2625, 2626, 2627>,
		<2628, 2629, 2630>,
		<2631, 2632, 2633>,
		<2634, 2635, 2636>,
		<2637, 2638, 2639>,
		<2640, 2641, 2642>,
		<2643, 2644, 2645>,
		<2646, 2647, 2648>,
		<2649, 2650, 2651>,
		<2652, 2653, 2654>,
		<2655, 2656, 2657>,
		<2658, 2659, 2660>,
		<2661, 2662, 2663>,
		<2664, 2665, 2666>,
		<2667, 2668, 2669>,
		<2670, 2671, 2672>,
		<2673, 2674, 2675>,
		<2676, 2677, 2678>,
		<2679, 2680, 2681>,
		<2682, 2683, 2684>,
		<2685, 2686, 2687>,
		<2688, 2689, 2690>,
		<2691, 2692, 2693>,
		<2694, 2695, 2696>,
		<2697, 2698, 2699>,
		<2700, 2701, 2702>,
		<2703, 2704, 2705>,
		<2706, 2707, 2708>,
		<2709, 2710, 2711>,
		<2712, 2713, 2714>,
		<2715, 2716, 2717>,
		<2718, 2719, 2720>,
		<2721, 2722, 2723>,
		<2724, 2725, 2726>,
		<2727, 2728, 2729>,
		<2730, 2731, 2732>,
		<2733, 2734, 2735>,
		<2736, 2737, 2738>,
		<2739, 2740, 2741>,
		<2742, 2743, 2744>,
		<2745, 2746, 2747>,
		<2748, 2749, 2750>,
		<2751, 2752, 2753>,
		<2754, 2755, 2756>,
		<2757, 2758, 2759>,
		<2760, 2761, 2762>,
		<2763, 2764, 2765>,
		<2766, 2767, 2768>,
		<2769, 2770, 2771>,
		<2772, 2773, 2774>,
		<2775, 2776, 2777>,
		<2778, 2779, 2780>,
		<2781, 2782, 2783>,
		<2784, 2785, 2786>,
		<2787, 2788, 2789>,
		<2790, 2791, 2792>,
		<2793, 2794, 2795>,
		<2796, 2797, 2798>,
		<2799, 2800, 2801>,
		<2802, 2803, 2804>,
		<2805, 2806, 2807>,
		<2808, 2809, 2810>,
		<2811, 2812, 2813>,
		<2814, 2815, 2816>,
		<2817, 2818, 2819>,
		<2820, 2821, 2822>,
		<2823, 2824, 2825>,
		<2826, 2827, 2828>,
		<2829, 2830, 2831>,
		<2832, 2833, 2834>,
		<2835, 2836, 2837>,
		<2838, 2839, 2840>,
		<2841, 2842, 2843>,
		<2844, 2845, 2846>,
		<2847, 2848, 2849>,
		<2850, 2851, 2852>,
		<2853, 2854, 2855>,
		<2856, 2857, 2858>,
		<2859, 2860, 2861>,
		<2862, 2863, 2864>,
		<2865, 2866, 2867>,
		<2868, 2869, 2870>,
		<2871, 2872, 2873>,
		<2874, 2875, 2876>,
		<2877, 2878, 2879>,
		<2880, 2881, 2882>,
		<2883, 2884, 2885>,
		<2886, 2887, 2888>,
		<2889, 2890, 2891>,
		<2892, 2893, 2894>,
		<2895, 2896, 2897>,
		<2898, 2899, 2900>,
		<2901, 2902, 2903>,
		<2904, 2905, 2906>,
		<2907, 2908, 2909>,
		<2910, 2911, 2912>,
		<2913, 2914, 2915>,
		<2916, 2917, 2918>,
		<2919, 2920, 2921>,
		<2922, 2923, 2924>,
		<2925, 2926, 2927>,
		<2928, 2929, 2930>,
		<2931, 2932, 2933>,
		<2934, 2935, 2936>,
		<2937, 2938, 2939>,
		<2940, 2941, 2942>,
		<2943, 2944, 2945>,
		<2946, 2947, 2948>,
		<2949, 2950, 2951>,
		<2952, 2953, 2954>,
		<2955, 2956, 2957>,
		<2958, 2959, 2960>,
		<2961, 2962, 2963>,
		<2964, 2965, 2966>,
		<2967, 2968, 2969>,
		<2970, 2971, 2972>,
		<2973, 2974, 2975>,
		<2976, 2977, 2978>,
		<2979, 2980, 2981>,
		<2982, 2983, 2984>,
		<2985, 2986, 2987>,
		<2988, 2989, 2990>,
		<2991, 2992, 2993>,
		<2994, 2995, 2996>,
		<2997, 2998, 2999>,
		<3000, 3001, 3002>,
		<3003, 3004, 3005>,
		<3006, 3007, 3008>,
		<3009, 3010, 3011>,
		<3012, 3013, 3014>,
		<3015, 3016, 3017>,
		<3018, 3019, 3020>,
		<3021, 3022, 3023>,
		<3024, 3025, 3026>,
		<3027, 3028, 3029>,
		<3030, 3031, 3032>,
		<3033, 3034, 3035>,
		<3036, 3037, 3038>,
		<3039, 3040, 3041>,
		<3042, 3043, 3044>,
		<3045, 3046, 3047>,
		<3048, 3049, 3050>,
		<3051, 3052, 3053>,
		<3054, 3055, 3056>,
		<3057, 3058, 3059>,
		<3060, 3061, 3062>,
		<3063, 3064, 3065>,
		<3066, 3067, 3068>,
		<3069, 3070, 3071>,
		<3072, 3073, 3074>,
		<3075, 3076, 3077>,
		<3078, 3079, 3080>,
		<3081, 3082, 3083>,
		<3084, 3085, 3086>,
		<3087, 3088, 3089>,
		<3090, 3091, 3092>,
		<3093, 3094, 3095>,
		<3096, 3097, 3098>,
		<3099, 3100, 3101>,
		<3102, 3103, 3104>,
		<3105, 3106, 3107>,
		<3108, 3109, 3110>,
		<3111, 3112, 3113>,
		<3114, 3115, 3116>,
		<3117, 3118, 3119>,
		<3120, 3121, 3122>,
		<3123, 3124, 3125>,
		<3126, 3127, 3128>,
		<3129, 3130, 3131>,
		<3132, 3133, 3134>,
		<3135, 3136, 3137>,
		<3138, 3139, 3140>,
		<3141, 3142, 3143>,
		<3144, 3145, 3146>,
		<3147, 3148, 3149>,
		<3150, 3151, 3152>,
		<3153, 3154, 3155>,
		<3156, 3157, 3158>,
		<3159, 3160, 3161>,
		<3162, 3163, 3164>,
		<3165, 3166, 3167>,
		<3168, 3169, 3170>,
		<3171, 3172, 3173>,
		<3174, 3175, 3176>,
		<3177, 3178, 3179>,
		<3180, 3181, 3182>,
		<3183, 3184, 3185>,
		<3186, 3187, 3188>,
		<3189, 3190, 3191>,
		<3192, 3193, 3194>,
		<3195, 3196, 3197>,
		<3198, 3199, 3200>,
		<3201, 3202, 3203>,
		<3204, 3205, 3206>,
		<3207, 3208, 3209>,
		<3210, 3211, 3212>,
		<3213, 3214, 3215>,
		<3216, 3217, 3218>,
		<3219, 3220, 3221>,
		<3222, 3223, 3224>,
		<3225, 3226, 3227>,
		<3228, 3229, 3230>,
		<3231, 3232, 3233>,
		<3234, 3235, 3236>,
		<3237, 3238, 3239>,
		<3240, 3241, 3242>,
		<3243, 3244, 3245>,
		<3246, 3247, 3248>,
		<3249, 3250, 3251>,
		<3252, 3253, 3254>,
		<3255, 3256, 3257>,
		<3258, 3259, 3260>,
		<3261, 3262, 3263>,
		<3264, 3265, 3266>,
		<3267, 3268, 3269>,
		<3270, 3271, 3272>,
		<3273, 3274, 3275>,
		<3276, 3277, 3278>,
		<3279, 3280, 3281>,
		<3282, 3283, 3284>,
		<3285, 3286, 3287>,
		<3288, 3289, 3290>,
		<3291, 3292, 3293>,
		<3294, 3295, 3296>,
		<3297, 3298, 3299>,
		<3300, 3301, 3302>,
		<3303, 3304, 3305>,
		<3306, 3307, 3308>,
		<3309, 3310, 3311>,
		<3312, 3313, 3314>,
		<3315, 3316, 3317>,
		<3318, 3319, 3320>,
		<3321, 3322, 3323>,
		<3324, 3325, 3326>,
		<3327, 3328, 3329>,
		<3330, 3331, 3332>,
		<3333, 3334, 3335>,
		<3336, 3337, 3338>,
		<3339, 3340, 3341>,
		<3342, 3343, 3344>,
		<3345, 3346, 3347>,
		<3348, 3349, 3350>,
		<3351, 3352, 3353>,
		<3354, 3355, 3356>,
		<3357, 3358, 3359>,
		<3360, 3361, 3362>,
		<3363, 3364, 3365>,
		<3366, 3367, 3368>,
		<3369, 3370, 3371>,
		<3372, 3373, 3374>,
		<3375, 3376, 3377>,
		<3378, 3379, 3380>,
		<3381, 3382, 3383>,
		<3384, 3385, 3386>,
		<3387, 3388, 3389>,
		<3390, 3391, 3392>,
		<3393, 3394, 3395>,
		<3396, 3397, 3398>,
		<3399, 3400, 3401>,
		<3402, 3403, 3404>,
		<3405, 3406, 3407>,
		<3408, 3409, 3410>,
		<3411, 3412, 3413>,
		<3414, 3415, 3416>,
		<3417, 3418, 3419>,
		<3420, 3421, 3422>,
		<3423, 3424, 3425>,
		<3426, 3427, 3428>,
		<3429, 3430, 3431>,
		<3432, 3433, 3434>,
		<3435, 3436, 3437>,
		<3438, 3439, 3440>,
		<3441, 3442, 3443>,
		<3444, 3445, 3446>,
		<3447, 3448, 3449>,
		<3450, 3451, 3452>,
		<3453, 3454, 3455>,
		<3456, 3457, 3458>,
		<3459, 3460, 3461>,
		<3462, 3463, 3464>,
		<3465, 3466, 3467>,
		<3468, 3469, 3470>,
		<3471, 3472, 3473>,
		<3474, 3475, 3476>,
		<3477, 3478, 3479>,
		<3480, 3481, 3482>,
		<3483, 3484, 3485>,
		<3486, 3487, 3488>,
		<3489, 3490, 3491>,
		<3492, 3493, 3494>,
		<3495, 3496, 3497>,
		<3498, 3499, 3500>,
		<3501, 3502, 3503>,
		<3504, 3505, 3506>,
		<3507, 3508, 3509>,
		<3510, 3511, 3512>,
		<3513, 3514, 3515>,
		<3516, 3517, 3518>,
		<3519, 3520, 3521>,
		<3522, 3523, 3524>,
		<3525, 3526, 3527>,
		<3528, 3529, 3530>,
		<3531, 3532, 3533>,
		<3534, 3535, 3536>,
		<3537, 3538, 3539>,
		<3540, 3541, 3542>,
		<3543, 3544, 3545>,
		<3546, 3547, 3548>,
		<3549, 3550, 3551>,
		<3552, 3553, 3554>,
		<3555, 3556, 3557>,
		<3558, 3559, 3560>,
		<3561, 3562, 3563>,
		<3564, 3565, 3566>,
		<3567, 3568, 3569>,
		<3570, 3571, 3572>,
		<3573, 3574, 3575>,
		<3576, 3577, 3578>,
		<3579, 3580, 3581>,
		<3582, 3583, 3584>,
		<3585, 3586, 3587>,
		<3588, 3589, 3590>,
		<3591, 3592, 3593>,
		<3594, 3595, 3596>,
		<3597, 3598, 3599>,
		<3600, 3601, 3602>,
		<3603, 3604, 3605>,
		<3606, 3607, 3608>,
		<3609, 3610, 3611>,
		<3612, 3613, 3614>,
		<3615, 3616, 3617>,
		<3618, 3619, 3620>,
		<3621, 3622, 3623>,
		<3624, 3625, 3626>,
		<3627, 3628, 3629>,
		<3630, 3631, 3632>,
		<3633, 3634, 3635>,
		<3636, 3637, 3638>,
		<3639, 3640, 3641>,
		<3642, 3643, 3644>,
		<3645, 3646, 3647>,
		<3648, 3649, 3650>,
		<3651, 3652, 3653>,
		<3654, 3655, 3656>,
		<3657, 3658, 3659>,
		<3660, 3661, 3662>,
		<3663, 3664, 3665>,
		<3666, 3667, 3668>,
		<3669, 3670, 3671>,
		<3672, 3673, 3674>,
		<3675, 3676, 3677>,
		<3678, 3679, 3680>,
		<3681, 3682, 3683>,
		<3684, 3685, 3686>,
		<3687, 3688, 3689>,
		<3690, 3691, 3692>,
		<3693, 3694, 3695>,
		<3696, 3697, 3698>,
		<3699, 3700, 3701>,
		<3702, 3703, 3704>,
		<3705, 3706, 3707>,
		<3708, 3709, 3710>,
		<3711, 3712, 3713>,
		<3714, 3715, 3716>,
		<3717, 3718, 3719>,
		<3720, 3721, 3722>,
		<3723, 3724, 3725>,
		<3726, 3727, 3728>,
		<3729, 3730, 3731>,
		<3732, 3733, 3734>,
		<3735, 3736, 3737>,
		<3738, 3739, 3740>,
		<3741, 3742, 3743>,
		<3744, 3745, 3746>,
		<3747, 3748, 3749>,
		<3750, 3751, 3752>,
		<3753, 3754, 3755>,
		<3756, 3757, 3758>,
		<3759, 3760, 3761>,
		<3762, 3763, 3764>,
		<3765, 3766, 3767>,
		<3768, 3769, 3770>,
		<3771, 3772, 3773>,
		<3774, 3775, 3776>,
		<3777, 3778, 3779>,
		<3780, 3781, 3782>,
		<3783, 3784, 3785>,
		<3786, 3787, 3788>,
		<3789, 3790, 3791>,
		<3792, 3793, 3794>,
		<3795, 3796, 3797>,
		<3798, 3799, 3800>,
		<3801, 3802, 3803>,
		<3804, 3805, 3806>,
		<3807, 3808, 3809>,
		<3810, 3811, 3812>,
		<3813, 3814, 3815>,
		<3816, 3817, 3818>,
		<3819, 3820, 3821>,
		<3822, 3823, 3824>,
		<3825, 3826, 3827>,
		<3828, 3829, 3830>,
		<3831, 3832, 3833>,
		<3834, 3835, 3836>,
		<3837, 3838, 3839>,
		<3840, 3841, 3842>,
		<3843, 3844, 3845>,
		<3846, 3847, 3848>,
		<3849, 3850, 3851>,
		<3852, 3853, 3854>,
		<3855, 3856, 3857>,
		<3858, 3859, 3860>,
		<3861, 3862, 3863>,
		<3864, 3865, 3866>,
		<3867, 3868, 3869>,
		<3870, 3871, 3872>,
		<3873, 3874, 3875>,
		<3876, 3877, 3878>,
		<3879, 3880, 3881>,
		<3882, 3883, 3884>,
		<3885, 3886, 3887>,
		<3888, 3889, 3890>,
		<3891, 3892, 3893>,
		<3894, 3895, 3896>,
		<3897, 3898, 3899>,
		<3900, 3901, 3902>,
		<3903, 3904, 3905>,
		<3906, 3907, 3908>,
		<3909, 3910, 3911>,
		<3912, 3913, 3914>,
		<3915, 3916, 3917>,
		<3918, 3919, 3920>,
		<3921, 3922, 3923>,
		<3924, 3925, 3926>,
		<3927, 3928, 3929>,
		<3930, 3931, 3932>,
		<3933, 3934, 3935>,
		<3936, 3937, 3938>,
		<3939, 3940, 3941>,
		<3942, 3943, 3944>,
		<3945, 3946, 3947>,
		<3948, 3949, 3950>,
		<3951, 3952, 3953>,
		<3954, 3955, 3956>,
		<3957, 3958, 3959>,
		<3960, 3961, 3962>,
		<3963, 3964, 3965>,
		<3966, 3967, 3968>,
		<3969, 3970, 3971>,
		<3972, 3973, 3974>,
		<3975, 3976, 3977>,
		<3978, 3979, 3980>,
		<3981, 3982, 3983>,
		<3984, 3985, 3986>,
		<3987, 3988, 3989>,
		<3990, 3991, 3992>,
		<3993, 3994, 3995>,
		<3996, 3997, 3998>,
		<3999, 4000, 4001>,
		<4002, 4003, 4004>,
		<4005, 4006, 4007>,
		<4008, 4009, 4010>,
		<4011, 4012, 4013>,
		<4014, 4015, 4016>,
		<4017, 4018, 4019>,
		<4020, 4021, 4022>,
		<4023, 4024, 4025>,
		<4026, 4027, 4028>,
		<4029, 4030, 4031>,
		<4032, 4033, 4034>,
		<4035, 4036, 4037>,
		<4038, 4039, 4040>,
		<4041, 4042, 4043>,
		<4044, 4045, 4046>,
		<4047, 4048, 4049>,
		<4050, 4051, 4052>,
		<4053, 4054, 4055>,
		<4056, 4057, 4058>,
		<4059, 4060, 4061>,
		<4062, 4063, 4064>,
		<4065, 4066, 4067>,
		<4068, 4069, 4070>,
		<4071, 4072, 4073>,
		<4074, 4075, 4076>,
		<4077, 4078, 4079>,
		<4080, 4081, 4082>,
		<4083, 4084, 4085>,
		<4086, 4087, 4088>,
		<4089, 4090, 4091>,
		<4092, 4093, 4094>,
		<4095, 4096, 4097>,
		<4098, 4099, 4100>,
		<4101, 4102, 4103>,
		<4104, 4105, 4106>,
		<4107, 4108, 4109>,
		<4110, 4111, 4112>,
		<4113, 4114, 4115>,
		<4116, 4117, 4118>,
		<4119, 4120, 4121>,
		<4122, 4123, 4124>,
		<4125, 4126, 4127>,
		<4128, 4129, 4130>,
		<4131, 4132, 4133>,
		<4134, 4135, 4136>,
		<4137, 4138, 4139>,
		<4140, 4141, 4142>,
		<4143, 4144, 4145>,
		<4146, 4147, 4148>,
		<4149, 4150, 4151>,
		<4152, 4153, 4154>,
		<4155, 4156, 4157>,
		<4158, 4159, 4160>,
		<4161, 4162, 4163>,
		<4164, 4165, 4166>,
		<4167, 4168, 4169>,
		<4170, 4171, 4172>,
		<4173, 4174, 4175>,
		<4176, 4177, 4178>,
		<4179, 4180, 4181>,
		<4182, 4183, 4184>,
		<4185, 4186, 4187>,
		<4188, 4189, 4190>,
		<4191, 4192, 4193>,
		<4194, 4195, 4196>,
		<4197, 4198, 4199>,
		<4200, 4201, 4202>,
		<4203, 4204, 4205>,
		<4206, 4207, 4208>,
		<4209, 4210, 4211>,
		<4212, 4213, 4214>,
		<4215, 4216, 4217>,
		<4218, 4219, 4220>,
		<4221, 4222, 4223>,
		<4224, 4225, 4226>,
		<4227, 4228, 4229>,
		<4230, 4231, 4232>,
		<4233, 4234, 4235>,
		<4236, 4237, 4238>,
		<4239, 4240, 4241>,
		<4242, 4243, 4244>,
		<4245, 4246, 4247>,
		<4248, 4249, 4250>,
		<4251, 4252, 4253>,
		<4254, 4255, 4256>,
		<4257, 4258, 4259>,
		<4260, 4261, 4262>,
		<4263, 4264, 4265>,
		<4266, 4267, 4268>,
		<4269, 4270, 4271>,
		<4272, 4273, 4274>,
		<4275, 4276, 4277>,
		<4278, 4279, 4280>,
		<4281, 4282, 4283>,
		<4284, 4285, 4286>,
		<4287, 4288, 4289>,
		<4290, 4291, 4292>,
		<4293, 4294, 4295>,
		<4296, 4297, 4298>,
		<4299, 4300, 4301>,
		<4302, 4303, 4304>,
		<4305, 4306, 4307>,
		<4308, 4309, 4310>,
		<4311, 4312, 4313>,
		<4314, 4315, 4316>,
		<4317, 4318, 4319>,
		<4320, 4321, 4322>,
		<4323, 4324, 4325>,
		<4326, 4327, 4328>,
		<4329, 4330, 4331>,
		<4332, 4333, 4334>,
		<4335, 4336, 4337>,
		<4338, 4339, 4340>,
		<4341, 4342, 4343>,
		<4344, 4345, 4346>,
		<4347, 4348, 4349>,
		<4350, 4351, 4352>,
		<4353, 4354, 4355>,
		<4356, 4357, 4358>,
		<4359, 4360, 4361>,
		<4362, 4363, 4364>,
		<4365, 4366, 4367>,
		<4368, 4369, 4370>,
		<4371, 4372, 4373>,
		<4374, 4375, 4376>,
		<4377, 4378, 4379>,
		<4380, 4381, 4382>,
		<4383, 4384, 4385>,
		<4386, 4387, 4388>,
		<4389, 4390, 4391>,
		<4392, 4393, 4394>,
		<4395, 4396, 4397>,
		<4398, 4399, 4400>,
		<4401, 4402, 4403>,
		<4404, 4405, 4406>,
		<4407, 4408, 4409>,
		<4410, 4411, 4412>,
		<4413, 4414, 4415>,
		<4416, 4417, 4418>,
		<4419, 4420, 4421>,
		<4422, 4423, 4424>,
		<4425, 4426, 4427>,
		<4428, 4429, 4430>,
		<4431, 4432, 4433>,
		<4434, 4435, 4436>,
		<4437, 4438, 4439>,
		<4440, 4441, 4442>,
		<4443, 4444, 4445>,
		<4446, 4447, 4448>,
		<4449, 4450, 4451>,
		<4452, 4453, 4454>,
		<4455, 4456, 4457>,
		<4458, 4459, 4460>,
		<4461, 4462, 4463>,
		<4464, 4465, 4466>,
		<4467, 4468, 4469>,
		<4470, 4471, 4472>,
		<4473, 4474, 4475>,
		<4476, 4477, 4478>,
		<4479, 4480, 4481>,
		<4482, 4483, 4484>,
		<4485, 4486, 4487>,
		<4488, 4489, 4490>,
		<4491, 4492, 4493>,
		<4494, 4495, 4496>,
		<4497, 4498, 4499>,
		<4500, 4501, 4502>,
		<4503, 4504, 4505>,
		<4506, 4507, 4508>,
		<4509, 4510, 4511>,
		<4512, 4513, 4514>,
		<4515, 4516, 4517>,
		<4518, 4519, 4520>,
		<4521, 4522, 4523>,
		<4524, 4525, 4526>,
		<4527, 4528, 4529>,
		<4530, 4531, 4532>,
		<4533, 4534, 4535>,
		<4536, 4537, 4538>,
		<4539, 4540, 4541>,
		<4542, 4543, 4544>,
		<4545, 4546, 4547>,
		<4548, 4549, 4550>,
		<4551, 4552, 4553>,
		<4554, 4555, 4556>,
		<4557, 4558, 4559>,
		<4560, 4561, 4562>,
		<4563, 4564, 4565>,
		<4566, 4567, 4568>,
		<4569, 4570, 4571>,
		<4572, 4573, 4574>,
		<4575, 4576, 4577>,
		<4578, 4579, 4580>,
		<4581, 4582, 4583>,
		<4584, 4585, 4586>,
		<4587, 4588, 4589>,
		<4590, 4591, 4592>,
		<4593, 4594, 4595>,
		<4596, 4597, 4598>,
		<4599, 4600, 4601>,
		<4602, 4603, 4604>,
		<4605, 4606, 4607>,
		<4608, 4609, 4610>,
		<4611, 4612, 4613>,
		<4614, 4615, 4616>,
		<4617, 4618, 4619>,
		<4620, 4621, 4622>,
		<4623, 4624, 4625>,
		<4626, 4627, 4628>,
		<4629, 4630, 4631>,
		<4632, 4633, 4634>,
		<4635, 4636, 4637>,
		<4638, 4639, 4640>,
		<4641, 4642, 4643>,
		<4644, 4645, 4646>,
		<4647, 4648, 4649>,
		<4650, 4651, 4652>,
		<4653, 4654, 4655>,
		<4656, 4657, 4658>,
		<4659, 4660, 4661>,
		<4662, 4663, 4664>,
		<4665, 4666, 4667>,
		<4668, 4669, 4670>,
		<4671, 4672, 4673>,
		<4674, 4675, 4676>,
		<4677, 4678, 4679>,
		<4680, 4681, 4682>,
		<4683, 4684, 4685>,
		<4686, 4687, 4688>,
		<4689, 4690, 4691>,
		<4692, 4693, 4694>,
		<4695, 4696, 4697>,
		<4698, 4699, 4700>,
		<4701, 4702, 4703>,
		<4704, 4705, 4706>,
		<4707, 4708, 4709>,
		<4710, 4711, 4712>,
		<4713, 4714, 4715>,
		<4716, 4717, 4718>,
		<4719, 4720, 4721>,
		<4722, 4723, 4724>,
		<4725, 4726, 4727>,
		<4728, 4729, 4730>,
		<4731, 4732, 4733>,
		<4734, 4735, 4736>,
		<4737, 4738, 4739>,
		<4740, 4741, 4742>,
		<4743, 4744, 4745>,
		<4746, 4747, 4748>,
		<4749, 4750, 4751>,
		<4752, 4753, 4754>,
		<4755, 4756, 4757>,
		<4758, 4759, 4760>,
		<4761, 4762, 4763>,
		<4764, 4765, 4766>,
		<4767, 4768, 4769>,
		<4770, 4771, 4772>,
		<4773, 4774, 4775>,
		<4776, 4777, 4778>,
		<4779, 4780, 4781>,
		<4782, 4783, 4784>,
		<4785, 4786, 4787>,
		<4788, 4789, 4790>,
		<4791, 4792, 4793>,
		<4794, 4795, 4796>,
		<4797, 4798, 4799>,
		<4800, 4801, 4802>,
		<4803, 4804, 4805>,
		<4806, 4807, 4808>,
		<4809, 4810, 4811>,
		<4812, 4813, 4814>,
		<4815, 4816, 4817>,
		<4818, 4819, 4820>,
		<4821, 4822, 4823>,
		<4824, 4825, 4826>,
		<4827, 4828, 4829>,
		<4830, 4831, 4832>,
		<4833, 4834, 4835>,
		<4836, 4837, 4838>,
		<4839, 4840, 4841>,
		<4842, 4843, 4844>,
		<4845, 4846, 4847>,
		<4848, 4849, 4850>,
		<4851, 4852, 4853>,
		<4854, 4855, 4856>,
		<4857, 4858, 4859>,
		<4860, 4861, 4862>,
		<4863, 4864, 4865>,
		<4866, 4867, 4868>,
		<4869, 4870, 4871>,
		<4872, 4873, 4874>,
		<4875, 4876, 4877>,
		<4878, 4879, 4880>,
		<4881, 4882, 4883>,
		<4884, 4885, 4886>,
		<4887, 4888, 4889>,
		<4890, 4891, 4892>,
		<4893, 4894, 4895>,
		<4896, 4897, 4898>,
		<4899, 4900, 4901>,
		<4902, 4903, 4904>,
		<4905, 4906, 4907>,
		<4908, 4909, 4910>,
		<4911, 4912, 4913>,
		<4914, 4915, 4916>,
		<4917, 4918, 4919>,
		<4920, 4921, 4922>,
		<4923, 4924, 4925>,
		<4926, 4927, 4928>,
		<4929, 4930, 4931>,
		<4932, 4933, 4934>,
		<4935, 4936, 4937>,
		<4938, 4939, 4940>,
		<4941, 4942, 4943>,
		<4944, 4945, 4946>,
		<4947, 4948, 4949>,
		<4950, 4951, 4952>,
		<4953, 4954, 4955>,
		<4956, 4957, 4958>,
		<4959, 4960, 4961>,
		<4962, 4963, 4964>,
		<4965, 4966, 4967>,
		<4968, 4969, 4970>,
		<4971, 4972, 4973>,
		<4974, 4975, 4976>,
		<4977, 4978, 4979>,
		<4980, 4981, 4982>,
		<4983, 4984, 4985>,
		<4986, 4987, 4988>,
		<4989, 4990, 4991>,
		<4992, 4993, 4994>,
		<4995, 4996, 4997>,
		<4998, 4999, 5000>,
		<5001, 5002, 5003>,
		<5004, 5005, 5006>,
		<5007, 5008, 5009>,
		<5010, 5011, 5012>,
		<5013, 5014, 5015>,
		<5016, 5017, 5018>,
		<5019, 5020, 5021>,
		<5022, 5023, 5024>,
		<5025, 5026, 5027>,
		<5028, 5029, 5030>,
		<5031, 5032, 5033>,
		<5034, 5035, 5036>,
		<5037, 5038, 5039>,
		<5040, 5041, 5042>,
		<5043, 5044, 5045>,
		<5046, 5047, 5048>,
		<5049, 5050, 5051>,
		<5052, 5053, 5054>,
		<5055, 5056, 5057>,
		<5058, 5059, 5060>,
		<5061, 5062, 5063>,
		<5064, 5065, 5066>,
		<5067, 5068, 5069>,
		<5070, 5071, 5072>,
		<5073, 5074, 5075>,
		<5076, 5077, 5078>,
		<5079, 5080, 5081>,
		<5082, 5083, 5084>,
		<5085, 5086, 5087>,
		<5088, 5089, 5090>,
		<5091, 5092, 5093>,
		<5094, 5095, 5096>,
		<5097, 5098, 5099>,
		<5100, 5101, 5102>,
		<5103, 5104, 5105>,
		<5106, 5107, 5108>,
		<5109, 5110, 5111>,
		<5112, 5113, 5114>,
		<5115, 5116, 5117>,
		<5118, 5119, 5120>,
		<5121, 5122, 5123>,
		<5124, 5125, 5126>,
		<5127, 5128, 5129>,
		<5130, 5131, 5132>,
		<5133, 5134, 5135>,
		<5136, 5137, 5138>,
		<5139, 5140, 5141>,
		<5142, 5143, 5144>,
		<5145, 5146, 5147>,
		<5148, 5149, 5150>,
		<5151, 5152, 5153>,
		<5154, 5155, 5156>,
		<5157, 5158, 5159>,
		<5160, 5161, 5162>,
		<5163, 5164, 5165>,
		<5166, 5167, 5168>,
		<5169, 5170, 5171>,
		<5172, 5173, 5174>,
		<5175, 5176, 5177>,
		<5178, 5179, 5180>,
		<5181, 5182, 5183>,
		<5184, 5185, 5186>,
		<5187, 5188, 5189>,
		<5190, 5191, 5192>,
		<5193, 5194, 5195>,
		<5196, 5197, 5198>,
		<5199, 5200, 5201>,
		<5202, 5203, 5204>,
		<5205, 5206, 5207>,
		<5208, 5209, 5210>,
		<5211, 5212, 5213>,
		<5214, 5215, 5216>,
		<5217, 5218, 5219>,
		<5220, 5221, 5222>,
		<5223, 5224, 5225>,
		<5226, 5227, 5228>,
		<5229, 5230, 5231>,
		<5232, 5233, 5234>,
		<5235, 5236, 5237>,
		<5238, 5239, 5240>,
		<5241, 5242, 5243>,
		<5244, 5245, 5246>,
		<5247, 5248, 5249>,
		<5250, 5251, 5252>,
		<5253, 5254, 5255>,
		<5256, 5257, 5258>,
		<5259, 5260, 5261>,
		<5262, 5263, 5264>,
		<5265, 5266, 5267>,
		<5268, 5269, 5270>,
		<5271, 5272, 5273>,
		<5274, 5275, 5276>,
		<5277, 5278, 5279>,
		<5280, 5281, 5282>,
		<5283, 5284, 5285>,
		<5286, 5287, 5288>,
		<5289, 5290, 5291>,
		<5292, 5293, 5294>,
		<5295, 5296, 5297>,
		<5298, 5299, 5300>,
		<5301, 5302, 5303>,
		<5304, 5305, 5306>,
		<5307, 5308, 5309>,
		<5310, 5311, 5312>,
		<5313, 5314, 5315>,
		<5316, 5317, 5318>,
		<5319, 5320, 5321>,
		<5322, 5323, 5324>,
		<5325, 5326, 5327>,
		<5328, 5329, 5330>,
		<5331, 5332, 5333>,
		<5334, 5335, 5336>,
		<5337, 5338, 5339>,
		<5340, 5341, 5342>,
		<5343, 5344, 5345>,
		<5346, 5347, 5348>,
		<5349, 5350, 5351>,
		<5352, 5353, 5354>,
		<5355, 5356, 5357>,
		<5358, 5359, 5360>,
		<5361, 5362, 5363>,
		<5364, 5365, 5366>,
		<5367, 5368, 5369>,
		<5370, 5371, 5372>,
		<5373, 5374, 5375>,
		<5376, 5377, 5378>,
		<5379, 5380, 5381>,
		<5382, 5383, 5384>,
		<5385, 5386, 5387>,
		<5388, 5389, 5390>,
		<5391, 5392, 5393>,
		<5394, 5395, 5396>,
		<5397, 5398, 5399>,
		<5400, 5401, 5402>,
		<5403, 5404, 5405>,
		<5406, 5407, 5408>,
		<5409, 5410, 5411>,
		<5412, 5413, 5414>,
		<5415, 5416, 5417>,
		<5418, 5419, 5420>,
		<5421, 5422, 5423>,
		<5424, 5425, 5426>,
		<5427, 5428, 5429>,
		<5430, 5431, 5432>,
		<5433, 5434, 5435>,
		<5436, 5437, 5438>,
		<5439, 5440, 5441>,
		<5442, 5443, 5444>,
		<5445, 5446, 5447>,
		<5448, 5449, 5450>,
		<5451, 5452, 5453>,
		<5454, 5455, 5456>,
		<5457, 5458, 5459>,
		<5460, 5461, 5462>,
		<5463, 5464, 5465>,
		<5466, 5467, 5468>,
		<5469, 5470, 5471>,
		<5472, 5473, 5474>,
		<5475, 5476, 5477>,
		<5478, 5479, 5480>,
		<5481, 5482, 5483>,
		<5484, 5485, 5486>,
		<5487, 5488, 5489>,
		<5490, 5491, 5492>,
		<5493, 5494, 5495>,
		<5496, 5497, 5498>,
		<5499, 5500, 5501>,
		<5502, 5503, 5504>,
		<5505, 5506, 5507>,
		<5508, 5509, 5510>,
		<5511, 5512, 5513>,
		<5514, 5515, 5516>,
		<5517, 5518, 5519>,
		<5520, 5521, 5522>,
		<5523, 5524, 5525>,
		<5526, 5527, 5528>,
		<5529, 5530, 5531>,
		<5532, 5533, 5534>,
		<5535, 5536, 5537>,
		<5538, 5539, 5540>,
		<5541, 5542, 5543>,
		<5544, 5545, 5546>,
		<5547, 5548, 5549>,
		<5550, 5551, 5552>,
		<5553, 5554, 5555>,
		<5556, 5557, 5558>,
		<5559, 5560, 5561>,
		<5562, 5563, 5564>,
		<5565, 5566, 5567>,
		<5568, 5569, 5570>,
		<5571, 5572, 5573>,
		<5574, 5575, 5576>,
		<5577, 5578, 5579>,
		<5580, 5581, 5582>,
		<5583, 5584, 5585>,
		<5586, 5587, 5588>,
		<5589, 5590, 5591>,
		<5592, 5593, 5594>,
		<5595, 5596, 5597>,
		<5598, 5599, 5600>,
		<5601, 5602, 5603>,
		<5604, 5605, 5606>,
		<5607, 5608, 5609>,
		<5610, 5611, 5612>,
		<5613, 5614, 5615>,
		<5616, 5617, 5618>,
		<5619, 5620, 5621>,
		<5622, 5623, 5624>,
		<5625, 5626, 5627>,
		<5628, 5629, 5630>,
		<5631, 5632, 5633>,
		<5634, 5635, 5636>,
		<5637, 5638, 5639>,
		<5640, 5641, 5642>,
		<5643, 5644, 5645>,
		<5646, 5647, 5648>,
		<5649, 5650, 5651>,
		<5652, 5653, 5654>,
		<5655, 5656, 5657>,
		<5658, 5659, 5660>,
		<5661, 5662, 5663>,
		<5664, 5665, 5666>,
		<5667, 5668, 5669>,
		<5670, 5671, 5672>,
		<5673, 5674, 5675>,
		<5676, 5677, 5678>,
		<5679, 5680, 5681>,
		<5682, 5683, 5684>,
		<5685, 5686, 5687>,
		<5688, 5689, 5690>,
		<5691, 5692, 5693>,
		<5694, 5695, 5696>,
		<5697, 5698, 5699>,
		<5700, 5701, 5702>,
		<5703, 5704, 5705>,
		<5706, 5707, 5708>,
		<5709, 5710, 5711>,
		<5712, 5713, 5714>,
		<5715, 5716, 5717>,
		<5718, 5719, 5720>,
		<5721, 5722, 5723>,
		<5724, 5725, 5726>,
		<5727, 5728, 5729>,
		<5730, 5731, 5732>,
		<5733, 5734, 5735>,
		<5736, 5737, 5738>,
		<5739, 5740, 5741>,
		<5742, 5743, 5744>,
		<5745, 5746, 5747>,
		<5748, 5749, 5750>,
		<5751, 5752, 5753>,
		<5754, 5755, 5756>,
		<5757, 5758, 5759>,
		<5760, 5761, 5762>,
		<5763, 5764, 5765>,
		<5766, 5767, 5768>,
		<5769, 5770, 5771>,
		<5772, 5773, 5774>,
		<5775, 5776, 5777>,
		<5778, 5779, 5780>,
		<5781, 5782, 5783>,
		<5784, 5785, 5786>,
		<5787, 5788, 5789>,
		<5790, 5791, 5792>,
		<5793, 5794, 5795>,
		<5796, 5797, 5798>,
		<5799, 5800, 5801>,
		<5802, 5803, 5804>,
		<5805, 5806, 5807>,
		<5808, 5809, 5810>,
		<5811, 5812, 5813>,
		<5814, 5815, 5816>,
		<5817, 5818, 5819>,
		<5820, 5821, 5822>,
		<5823, 5824, 5825>,
		<5826, 5827, 5828>,
		<5829, 5830, 5831>,
		<5832, 5833, 5834>,
		<5835, 5836, 5837>,
		<5838, 5839, 5840>,
		<5841, 5842, 5843>,
		<5844, 5845, 5846>,
		<5847, 5848, 5849>,
		<5850, 5851, 5852>,
		<5853, 5854, 5855>,
		<5856, 5857, 5858>,
		<5859, 5860, 5861>,
		<5862, 5863, 5864>,
		<5865, 5866, 5867>,
		<5868, 5869, 5870>,
		<5871, 5872, 5873>,
		<5874, 5875, 5876>,
		<5877, 5878, 5879>,
		<5880, 5881, 5882>,
		<5883, 5884, 5885>,
		<5886, 5887, 5888>,
		<5889, 5890, 5891>,
		<5892, 5893, 5894>,
		<5895, 5896, 5897>,
		<5898, 5899, 5900>,
		<5901, 5902, 5903>,
		<5904, 5905, 5906>,
		<5907, 5908, 5909>,
		<5910, 5911, 5912>,
		<5913, 5914, 5915>,
		<5916, 5917, 5918>,
		<5919, 5920, 5921>,
		<5922, 5923, 5924>,
		<5925, 5926, 5927>,
		<5928, 5929, 5930>,
		<5931, 5932, 5933>,
		<5934, 5935, 5936>,
		<5937, 5938, 5939>,
		<5940, 5941, 5942>,
		<5943, 5944, 5945>,
		<5946, 5947, 5948>,
		<5949, 5950, 5951>,
		<5952, 5953, 5954>,
		<5955, 5956, 5957>,
		<5958, 5959, 5960>,
		<5961, 5962, 5963>,
		<5964, 5965, 5966>,
		<5967, 5968, 5969>,
		<5970, 5971, 5972>,
		<5973, 5974, 5975>,
		<5976, 5977, 5978>,
		<5979, 5980, 5981>,
		<5982, 5983, 5984>,
		<5985, 5986, 5987>,
		<5988, 5989, 5990>,
		<5991, 5992, 5993>,
		<5994, 5995, 5996>,
		<5997, 5998, 5999>,
		<6000, 6001, 6002>,
		<6003, 6004, 6005>,
		<6006, 6007, 6008>,
		<6009, 6010, 6011>,
		<6012, 6013, 6014>,
		<6015, 6016, 6017>,
		<6018, 6019, 6020>,
		<6021, 6022, 6023>,
		<6024, 6025, 6026>,
		<6027, 6028, 6029>,
		<6030, 6031, 6032>,
		<6033, 6034, 6035>,
		<6036, 6037, 6038>,
		<6039, 6040, 6041>,
		<6042, 6043, 6044>,
		<6045, 6046, 6047>,
		<6048, 6049, 6050>,
		<6051, 6052, 6053>,
		<6054, 6055, 6056>,
		<6057, 6058, 6059>,
		<6060, 6061, 6062>,
		<6063, 6064, 6065>,
		<6066, 6067, 6068>,
		<6069, 6070, 6071>,
		<6072, 6073, 6074>,
		<6075, 6076, 6077>,
		<6078, 6079, 6080>,
		<6081, 6082, 6083>,
		<6084, 6085, 6086>,
		<6087, 6088, 6089>,
		<6090, 6091, 6092>,
		<6093, 6094, 6095>,
		<6096, 6097, 6098>,
		<6099, 6100, 6101>,
		<6102, 6103, 6104>,
		<6105, 6106, 6107>,
		<6108, 6109, 6110>,
		<6111, 6112, 6113>,
		<6114, 6115, 6116>,
		<6117, 6118, 6119>,
		<6120, 6121, 6122>,
		<6123, 6124, 6125>,
		<6126, 6127, 6128>,
		<6129, 6130, 6131>,
		<6132, 6133, 6134>,
		<6135, 6136, 6137>,
		<6138, 6139, 6140>,
		<6141, 6142, 6143>,
		<6144, 6145, 6146>,
		<6147, 6148, 6149>,
		<6150, 6151, 6152>,
		<6153, 6154, 6155>,
		<6156, 6157, 6158>,
		<6159, 6160, 6161>,
		<6162, 6163, 6164>,
		<6165, 6166, 6167>,
		<6168, 6169, 6170>,
		<6171, 6172, 6173>,
		<6174, 6175, 6176>,
		<6177, 6178, 6179>,
		<6180, 6181, 6182>,
		<6183, 6184, 6185>,
		<6186, 6187, 6188>,
		<6189, 6190, 6191>,
		<6192, 6193, 6194>,
		<6195, 6196, 6197>,
		<6198, 6199, 6200>,
		<6201, 6202, 6203>,
		<6204, 6205, 6206>,
		<6207, 6208, 6209>,
		<6210, 6211, 6212>,
		<6213, 6214, 6215>,
		<6216, 6217, 6218>,
		<6219, 6220, 6221>,
		<6222, 6223, 6224>,
		<6225, 6226, 6227>,
		<6228, 6229, 6230>,
		<6231, 6232, 6233>,
		<6234, 6235, 6236>,
		<6237, 6238, 6239>,
		<6240, 6241, 6242>,
		<6243, 6244, 6245>,
		<6246, 6247, 6248>,
		<6249, 6250, 6251>,
		<6252, 6253, 6254>,
		<6255, 6256, 6257>,
		<6258, 6259, 6260>,
		<6261, 6262, 6263>,
		<6264, 6265, 6266>,
		<6267, 6268, 6269>,
		<6270, 6271, 6272>,
		<6273, 6274, 6275>,
		<6276, 6277, 6278>,
		<6279, 6280, 6281>,
		<6282, 6283, 6284>,
		<6285, 6286, 6287>,
		<6288, 6289, 6290>,
		<6291, 6292, 6293>,
		<6294, 6295, 6296>,
		<6297, 6298, 6299>,
		<6300, 6301, 6302>,
		<6303, 6304, 6305>,
		<6306, 6307, 6308>,
		<6309, 6310, 6311>,
		<6312, 6313, 6314>,
		<6315, 6316, 6317>,
		<6318, 6319, 6320>,
		<6321, 6322, 6323>,
		<6324, 6325, 6326>,
		<6327, 6328, 6329>,
		<6330, 6331, 6332>,
		<6333, 6334, 6335>,
		<6336, 6337, 6338>,
		<6339, 6340, 6341>,
		<6342, 6343, 6344>,
		<6345, 6346, 6347>,
		<6348, 6349, 6350>,
		<6351, 6352, 6353>,
		<6354, 6355, 6356>,
		<6357, 6358, 6359>,
		<6360, 6361, 6362>,
		<6363, 6364, 6365>,
		<6366, 6367, 6368>,
		<6369, 6370, 6371>,
		<6372, 6373, 6374>,
		<6375, 6376, 6377>,
		<6378, 6379, 6380>,
		<6381, 6382, 6383>,
		<6384, 6385, 6386>,
		<6387, 6388, 6389>,
		<6390, 6391, 6392>,
		<6393, 6394, 6395>,
		<6396, 6397, 6398>,
		<6399, 6400, 6401>,
		<6402, 6403, 6404>,
		<6405, 6406, 6407>,
		<6408, 6409, 6410>,
		<6411, 6412, 6413>,
		<6414, 6415, 6416>,
		<6417, 6418, 6419>,
		<6420, 6421, 6422>,
		<6423, 6424, 6425>,
		<6426, 6427, 6428>,
		<6429, 6430, 6431>,
		<6432, 6433, 6434>,
		<6435, 6436, 6437>,
		<6438, 6439, 6440>,
		<6441, 6442, 6443>,
		<6444, 6445, 6446>,
		<6447, 6448, 6449>,
		<6450, 6451, 6452>,
		<6453, 6454, 6455>,
		<6456, 6457, 6458>,
		<6459, 6460, 6461>,
		<6462, 6463, 6464>,
		<6465, 6466, 6467>,
		<6468, 6469, 6470>,
		<6471, 6472, 6473>,
		<6474, 6475, 6476>,
		<6477, 6478, 6479>,
		<6480, 6481, 6482>,
		<6483, 6484, 6485>,
		<6486, 6487, 6488>,
		<6489, 6490, 6491>,
		<6492, 6493, 6494>,
		<6495, 6496, 6497>,
		<6498, 6499, 6500>,
		<6501, 6502, 6503>,
		<6504, 6505, 6506>,
		<6507, 6508, 6509>,
		<6510, 6511, 6512>,
		<6513, 6514, 6515>,
		<6516, 6517, 6518>,
		<6519, 6520, 6521>,
		<6522, 6523, 6524>,
		<6525, 6526, 6527>,
		<6528, 6529, 6530>,
		<6531, 6532, 6533>,
		<6534, 6535, 6536>,
		<6537, 6538, 6539>,
		<6540, 6541, 6542>,
		<6543, 6544, 6545>,
		<6546, 6547, 6548>,
		<6549, 6550, 6551>,
		<6552, 6553, 6554>,
		<6555, 6556, 6557>,
		<6558, 6559, 6560>,
		<6561, 6562, 6563>,
		<6564, 6565, 6566>,
		<6567, 6568, 6569>,
		<6570, 6571, 6572>,
		<6573, 6574, 6575>,
		<6576, 6577, 6578>,
		<6579, 6580, 6581>,
		<6582, 6583, 6584>,
		<6585, 6586, 6587>,
		<6588, 6589, 6590>,
		<6591, 6592, 6593>,
		<6594, 6595, 6596>,
		<6597, 6598, 6599>,
		<6600, 6601, 6602>,
		<6603, 6604, 6605>,
		<6606, 6607, 6608>,
		<6609, 6610, 6611>,
		<6612, 6613, 6614>,
		<6615, 6616, 6617>,
		<6618, 6619, 6620>,
		<6621, 6622, 6623>,
		<6624, 6625, 6626>,
		<6627, 6628, 6629>,
		<6630, 6631, 6632>,
		<6633, 6634, 6635>,
		<6636, 6637, 6638>,
		<6639, 6640, 6641>,
		<6642, 6643, 6644>,
		<6645, 6646, 6647>,
		<6648, 6649, 6650>,
		<6651, 6652, 6653>,
		<6654, 6655, 6656>,
		<6657, 6658, 6659>,
		<6660, 6661, 6662>,
		<6663, 6664, 6665>,
		<6666, 6667, 6668>,
		<6669, 6670, 6671>,
		<6672, 6673, 6674>,
		<6675, 6676, 6677>,
		<6678, 6679, 6680>,
		<6681, 6682, 6683>,
		<6684, 6685, 6686>,
		<6687, 6688, 6689>,
		<6690, 6691, 6692>,
		<6693, 6694, 6695>,
		<6696, 6697, 6698>,
		<6699, 6700, 6701>,
		<6702, 6703, 6704>,
		<6705, 6706, 6707>,
		<6708, 6709, 6710>,
		<6711, 6712, 6713>,
		<6714, 6715, 6716>,
		<6717, 6718, 6719>,
		<6720, 6721, 6722>,
		<6723, 6724, 6725>,
		<6726, 6727, 6728>,
		<6729, 6730, 6731>,
		<6732, 6733, 6734>,
		<6735, 6736, 6737>,
		<6738, 6739, 6740>,
		<6741, 6742, 6743>,
		<6744, 6745, 6746>,
		<6747, 6748, 6749>,
		<6750, 6751, 6752>,
		<6753, 6754, 6755>,
		<6756, 6757, 6758>,
		<6759, 6760, 6761>,
		<6762, 6763, 6764>,
		<6765, 6766, 6767>,
		<6768, 6769, 6770>,
		<6771, 6772, 6773>,
		<6774, 6775, 6776>,
		<6777, 6778, 6779>,
		<6780, 6781, 6782>,
		<6783, 6784, 6785>,
		<6786, 6787, 6788>,
		<6789, 6790, 6791>,
		<6792, 6793, 6794>,
		<6795, 6796, 6797>,
		<6798, 6799, 6800>,
		<6801, 6802, 6803>,
		<6804, 6805, 6806>,
		<6807, 6808, 6809>,
		<6810, 6811, 6812>,
		<6813, 6814, 6815>,
		<6816, 6817, 6818>,
		<6819, 6820, 6821>,
		<6822, 6823, 6824>,
		<6825, 6826, 6827>,
		<6828, 6829, 6830>,
		<6831, 6832, 6833>,
		<6834, 6835, 6836>,
		<6837, 6838, 6839>,
		<6840, 6841, 6842>,
		<6843, 6844, 6845>,
		<6846, 6847, 6848>,
		<6849, 6850, 6851>,
		<6852, 6853, 6854>,
		<6855, 6856, 6857>,
		<6858, 6859, 6860>,
		<6861, 6862, 6863>,
		<6864, 6865, 6866>,
		<6867, 6868, 6869>,
		<6870, 6871, 6872>,
		<6873, 6874, 6875>,
		<6876, 6877, 6878>,
		<6879, 6880, 6881>,
		<6882, 6883, 6884>,
		<6885, 6886, 6887>,
		<6888, 6889, 6890>,
		<6891, 6892, 6893>,
		<6894, 6895, 6896>,
		<6897, 6898, 6899>,
		<6900, 6901, 6902>,
		<6903, 6904, 6905>,
		<6906, 6907, 6908>,
		<6909, 6910, 6911>,
		<6912, 6913, 6914>,
		<6915, 6916, 6917>,
		<6918, 6919, 6920>,
		<6921, 6922, 6923>,
		<6924, 6925, 6926>,
		<6927, 6928, 6929>,
		<6930, 6931, 6932>,
		<6933, 6934, 6935>,
		<6936, 6937, 6938>,
		<6939, 6940, 6941>,
		<6942, 6943, 6944>,
		<6945, 6946, 6947>,
		<6948, 6949, 6950>,
		<6951, 6952, 6953>,
		<6954, 6955, 6956>,
		<6957, 6958, 6959>,
		<6960, 6961, 6962>,
		<6963, 6964, 6965>,
		<6966, 6967, 6968>,
		<6969, 6970, 6971>,
		<6972, 6973, 6974>,
		<6975, 6976, 6977>,
		<6978, 6979, 6980>,
		<6981, 6982, 6983>,
		<6984, 6985, 6986>,
		<6987, 6988, 6989>,
		<6990, 6991, 6992>,
		<6993, 6994, 6995>,
		<6996, 6997, 6998>,
		<6999, 7000, 7001>,
		<7002, 7003, 7004>,
		<7005, 7006, 7007>,
		<7008, 7009, 7010>,
		<7011, 7012, 7013>,
		<7014, 7015, 7016>,
		<7017, 7018, 7019>,
		<7020, 7021, 7022>,
		<7023, 7024, 7025>,
		<7026, 7027, 7028>,
		<7029, 7030, 7031>,
		<7032, 7033, 7034>,
		<7035, 7036, 7037>,
		<7038, 7039, 7040>,
		<7041, 7042, 7043>,
		<7044, 7045, 7046>,
		<7047, 7048, 7049>,
		<7050, 7051, 7052>,
		<7053, 7054, 7055>,
		<7056, 7057, 7058>,
		<7059, 7060, 7061>,
		<7062, 7063, 7064>,
		<7065, 7066, 7067>,
		<7068, 7069, 7070>,
		<7071, 7072, 7073>,
		<7074, 7075, 7076>,
		<7077, 7078, 7079>,
		<7080, 7081, 7082>,
		<7083, 7084, 7085>,
		<7086, 7087, 7088>,
		<7089, 7090, 7091>,
		<7092, 7093, 7094>,
		<7095, 7096, 7097>,
		<7098, 7099, 7100>,
		<7101, 7102, 7103>,
		<7104, 7105, 7106>,
		<7107, 7108, 7109>,
		<7110, 7111, 7112>,
		<7113, 7114, 7115>,
		<7116, 7117, 7118>,
		<7119, 7120, 7121>,
		<7122, 7123, 7124>,
		<7125, 7126, 7127>,
		<7128, 7129, 7130>,
		<7131, 7132, 7133>,
		<7134, 7135, 7136>,
		<7137, 7138, 7139>,
		<7140, 7141, 7142>,
		<7143, 7144, 7145>,
		<7146, 7147, 7148>,
		<7149, 7150, 7151>,
		<7152, 7153, 7154>,
		<7155, 7156, 7157>,
		<7158, 7159, 7160>,
		<7161, 7162, 7163>,
		<7164, 7165, 7166>,
		<7167, 7168, 7169>,
		<7170, 7171, 7172>,
		<7173, 7174, 7175>,
		<7176, 7177, 7178>,
		<7179, 7180, 7181>,
		<7182, 7183, 7184>,
		<7185, 7186, 7187>,
		<7188, 7189, 7190>,
		<7191, 7192, 7193>,
		<7194, 7195, 7196>,
		<7197, 7198, 7199>,
		<7200, 7201, 7202>,
		<7203, 7204, 7205>,
		<7206, 7207, 7208>,
		<7209, 7210, 7211>,
		<7212, 7213, 7214>,
		<7215, 7216, 7217>,
		<7218, 7219, 7220>,
		<7221, 7222, 7223>,
		<7224, 7225, 7226>,
		<7227, 7228, 7229>,
		<7230, 7231, 7232>,
		<7233, 7234, 7235>,
		<7236, 7237, 7238>,
		<7239, 7240, 7241>,
		<7242, 7243, 7244>,
		<7245, 7246, 7247>,
		<7248, 7249, 7250>,
		<7251, 7252, 7253>,
		<7254, 7255, 7256>,
		<7257, 7258, 7259>,
		<7260, 7261, 7262>,
		<7263, 7264, 7265>,
		<7266, 7267, 7268>,
		<7269, 7270, 7271>,
		<7272, 7273, 7274>,
		<7275, 7276, 7277>,
		<7278, 7279, 7280>,
		<7281, 7282, 7283>,
		<7284, 7285, 7286>,
		<7287, 7288, 7289>,
		<7290, 7291, 7292>,
		<7293, 7294, 7295>,
		<7296, 7297, 7298>,
		<7299, 7300, 7301>,
		<7302, 7303, 7304>,
		<7305, 7306, 7307>,
		<7308, 7309, 7310>,
		<7311, 7312, 7313>,
		<7314, 7315, 7316>,
		<7317, 7318, 7319>,
		<7320, 7321, 7322>,
		<7323, 7324, 7325>,
		<7326, 7327, 7328>,
		<7329, 7330, 7331>,
		<7332, 7333, 7334>,
		<7335, 7336, 7337>,
		<7338, 7339, 7340>,
		<7341, 7342, 7343>,
		<7344, 7345, 7346>,
		<7347, 7348, 7349>,
		<7350, 7351, 7352>,
		<7353, 7354, 7355>,
		<7356, 7357, 7358>,
		<7359, 7360, 7361>,
		<7362, 7363, 7364>,
		<7365, 7366, 7367>,
		<7368, 7369, 7370>,
		<7371, 7372, 7373>,
		<7374, 7375, 7376>,
		<7377, 7378, 7379>,
		<7380, 7381, 7382>,
		<7383, 7384, 7385>,
		<7386, 7387, 7388>,
		<7389, 7390, 7391>,
		<7392, 7393, 7394>,
		<7395, 7396, 7397>,
		<7398, 7399, 7400>,
		<7401, 7402, 7403>,
		<7404, 7405, 7406>,
		<7407, 7408, 7409>,
		<7410, 7411, 7412>,
		<7413, 7414, 7415>,
		<7416, 7417, 7418>,
		<7419, 7420, 7421>,
		<7422, 7423, 7424>,
		<7425, 7426, 7427>,
		<7428, 7429, 7430>,
		<7431, 7432, 7433>,
		<7434, 7435, 7436>,
		<7437, 7438, 7439>,
		<7440, 7441, 7442>,
		<7443, 7444, 7445>,
		<7446, 7447, 7448>,
		<7449, 7450, 7451>,
		<7452, 7453, 7454>,
		<7455, 7456, 7457>,
		<7458, 7459, 7460>,
		<7461, 7462, 7463>,
		<7464, 7465, 7466>,
		<7467, 7468, 7469>,
		<7470, 7471, 7472>,
		<7473, 7474, 7475>,
		<7476, 7477, 7478>,
		<7479, 7480, 7481>,
		<7482, 7483, 7484>,
		<7485, 7486, 7487>,
		<7488, 7489, 7490>,
		<7491, 7492, 7493>,
		<7494, 7495, 7496>,
		<7497, 7498, 7499>,
		<7500, 7501, 7502>,
		<7503, 7504, 7505>,
		<7506, 7507, 7508>,
		<7509, 7510, 7511>,
		<7512, 7513, 7514>,
		<7515, 7516, 7517>,
		<7518, 7519, 7520>,
		<7521, 7522, 7523>,
		<7524, 7525, 7526>,
		<7527, 7528, 7529>,
		<7530, 7531, 7532>,
		<7533, 7534, 7535>,
		<7536, 7537, 7538>,
		<7539, 7540, 7541>,
		<7542, 7543, 7544>,
		<7545, 7546, 7547>,
		<7548, 7549, 7550>,
		<7551, 7552, 7553>,
		<7554, 7555, 7556>,
		<7557, 7558, 7559>,
		<7560, 7561, 7562>,
		<7563, 7564, 7565>,
		<7566, 7567, 7568>,
		<7569, 7570, 7571>,
		<7572, 7573, 7574>,
		<7575, 7576, 7577>,
		<7578, 7579, 7580>,
		<7581, 7582, 7583>,
		<7584, 7585, 7586>,
		<7587, 7588, 7589>,
		<7590, 7591, 7592>,
		<7593, 7594, 7595>,
		<7596, 7597, 7598>,
		<7599, 7600, 7601>,
		<7602, 7603, 7604>,
		<7605, 7606, 7607>,
		<7608, 7609, 7610>,
		<7611, 7612, 7613>,
		<7614, 7615, 7616>,
		<7617, 7618, 7619>,
		<7620, 7621, 7622>,
		<7623, 7624, 7625>,
		<7626, 7627, 7628>,
		<7629, 7630, 7631>,
		<7632, 7633, 7634>,
		<7635, 7636, 7637>,
		<7638, 7639, 7640>,
		<7641, 7642, 7643>,
		<7644, 7645, 7646>,
		<7647, 7648, 7649>,
		<7650, 7651, 7652>,
		<7653, 7654, 7655>,
		<7656, 7657, 7658>,
		<7659, 7660, 7661>,
		<7662, 7663, 7664>,
		<7665, 7666, 7667>,
		<7668, 7669, 7670>,
		<7671, 7672, 7673>,
		<7674, 7675, 7676>,
		<7677, 7678, 7679>,
		<7680, 7681, 7682>,
		<7683, 7684, 7685>,
		<7686, 7687, 7688>,
		<7689, 7690, 7691>,
		<7692, 7693, 7694>,
		<7695, 7696, 7697>,
		<7698, 7699, 7700>,
		<7701, 7702, 7703>,
		<7704, 7705, 7706>,
		<7707, 7708, 7709>,
		<7710, 7711, 7712>,
		<7713, 7714, 7715>,
		<7716, 7717, 7718>,
		<7719, 7720, 7721>,
		<7722, 7723, 7724>,
		<7725, 7726, 7727>,
		<7728, 7729, 7730>,
		<7731, 7732, 7733>,
		<7734, 7735, 7736>,
		<7737, 7738, 7739>,
		<7740, 7741, 7742>,
		<7743, 7744, 7745>,
		<7746, 7747, 7748>,
		<7749, 7750, 7751>,
		<7752, 7753, 7754>,
		<7755, 7756, 7757>,
		<7758, 7759, 7760>,
		<7761, 7762, 7763>,
		<7764, 7765, 7766>,
		<7767, 7768, 7769>,
		<7770, 7771, 7772>,
		<7773, 7774, 7775>,
		<7776, 7777, 7778>,
		<7779, 7780, 7781>,
		<7782, 7783, 7784>,
		<7785, 7786, 7787>,
		<7788, 7789, 7790>,
		<7791, 7792, 7793>,
		<7794, 7795, 7796>,
		<7797, 7798, 7799>,
		<7800, 7801, 7802>,
		<7803, 7804, 7805>,
		<7806, 7807, 7808>,
		<7809, 7810, 7811>,
		<7812, 7813, 7814>,
		<7815, 7816, 7817>,
		<7818, 7819, 7820>,
		<7821, 7822, 7823>,
		<7824, 7825, 7826>,
		<7827, 7828, 7829>,
		<7830, 7831, 7832>,
		<7833, 7834, 7835>,
		<7836, 7837, 7838>,
		<7839, 7840, 7841>,
		<7842, 7843, 7844>,
		<7845, 7846, 7847>,
		<7848, 7849, 7850>,
		<7851, 7852, 7853>,
		<7854, 7855, 7856>,
		<7857, 7858, 7859>,
		<7860, 7861, 7862>,
		<7863, 7864, 7865>,
		<7866, 7867, 7868>,
		<7869, 7870, 7871>,
		<7872, 7873, 7874>,
		<7875, 7876, 7877>,
		<7878, 7879, 7880>,
		<7881, 7882, 7883>,
		<7884, 7885, 7886>,
		<7887, 7888, 7889>,
		<7890, 7891, 7892>,
		<7893, 7894, 7895>,
		<7896, 7897, 7898>,
		<7899, 7900, 7901>,
		<7902, 7903, 7904>,
		<7905, 7906, 7907>,
		<7908, 7909, 7910>,
		<7911, 7912, 7913>,
		<7914, 7915, 7916>,
		<7917, 7918, 7919>,
		<7920, 7921, 7922>,
		<7923, 7924, 7925>,
		<7926, 7927, 7928>,
		<7929, 7930, 7931>,
		<7932, 7933, 7934>,
		<7935, 7936, 7937>,
		<7938, 7939, 7940>,
		<7941, 7942, 7943>,
		<7944, 7945, 7946>,
		<7947, 7948, 7949>,
		<7950, 7951, 7952>,
		<7953, 7954, 7955>,
		<7956, 7957, 7958>,
		<7959, 7960, 7961>,
		<7962, 7963, 7964>,
		<7965, 7966, 7967>,
		<7968, 7969, 7970>,
		<7971, 7972, 7973>,
		<7974, 7975, 7976>,
		<7977, 7978, 7979>,
		<7980, 7981, 7982>,
		<7983, 7984, 7985>,
		<7986, 7987, 7988>,
		<7989, 7990, 7991>,
		<7992, 7993, 7994>,
		<7995, 7996, 7997>,
		<7998, 7999, 8000>,
		<8001, 8002, 8003>,
		<8004, 8005, 8006>,
		<8007, 8008, 8009>,
		<8010, 8011, 8012>,
		<8013, 8014, 8015>,
		<8016, 8017, 8018>,
		<8019, 8020, 8021>,
		<8022, 8023, 8024>,
		<8025, 8026, 8027>,
		<8028, 8029, 8030>,
		<8031, 8032, 8033>,
		<8034, 8035, 8036>,
		<8037, 8038, 8039>,
		<8040, 8041, 8042>,
		<8043, 8044, 8045>,
		<8046, 8047, 8048>,
		<8049, 8050, 8051>,
		<8052, 8053, 8054>,
		<8055, 8056, 8057>,
		<8058, 8059, 8060>,
		<8061, 8062, 8063>,
		<8064, 8065, 8066>,
		<8067, 8068, 8069>,
		<8070, 8071, 8072>,
		<8073, 8074, 8075>,
		<8076, 8077, 8078>,
		<8079, 8080, 8081>,
		<8082, 8083, 8084>,
		<8085, 8086, 8087>,
		<8088, 8089, 8090>,
		<8091, 8092, 8093>,
		<8094, 8095, 8096>,
		<8097, 8098, 8099>,
		<8100, 8101, 8102>,
		<8103, 8104, 8105>,
		<8106, 8107, 8108>,
		<8109, 8110, 8111>,
		<8112, 8113, 8114>,
		<8115, 8116, 8117>,
		<8118, 8119, 8120>,
		<8121, 8122, 8123>,
		<8124, 8125, 8126>,
		<8127, 8128, 8129>,
		<8130, 8131, 8132>,
		<8133, 8134, 8135>,
		<8136, 8137, 8138>,
		<8139, 8140, 8141>,
		<8142, 8143, 8144>,
		<8145, 8146, 8147>,
		<8148, 8149, 8150>,
		<8151, 8152, 8153>,
		<8154, 8155, 8156>,
		<8157, 8158, 8159>,
		<8160, 8161, 8162>,
		<8163, 8164, 8165>,
		<8166, 8167, 8168>,
		<8169, 8170, 8171>,
		<8172, 8173, 8174>,
		<8175, 8176, 8177>,
		<8178, 8179, 8180>,
		<8181, 8182, 8183>,
		<8184, 8185, 8186>,
		<8187, 8188, 8189>,
		<8190, 8191, 8192>,
		<8193, 8194, 8195>,
		<8196, 8197, 8198>,
		<8199, 8200, 8201>,
		<8202, 8203, 8204>,
		<8205, 8206, 8207>,
		<8208, 8209, 8210>,
		<8211, 8212, 8213>,
		<8214, 8215, 8216>,
		<8217, 8218, 8219>,
		<8220, 8221, 8222>,
		<8223, 8224, 8225>,
		<8226, 8227, 8228>,
		<8229, 8230, 8231>,
		<8232, 8233, 8234>,
		<8235, 8236, 8237>,
		<8238, 8239, 8240>,
		<8241, 8242, 8243>,
		<8244, 8245, 8246>,
		<8247, 8248, 8249>,
		<8250, 8251, 8252>,
		<8253, 8254, 8255>,
		<8256, 8257, 8258>,
		<8259, 8260, 8261>,
		<8262, 8263, 8264>,
		<8265, 8266, 8267>,
		<8268, 8269, 8270>,
		<8271, 8272, 8273>,
		<8274, 8275, 8276>,
		<8277, 8278, 8279>,
		<8280, 8281, 8282>,
		<8283, 8284, 8285>,
		<8286, 8287, 8288>,
		<8289, 8290, 8291>,
		<8292, 8293, 8294>,
		<8295, 8296, 8297>,
		<8298, 8299, 8300>,
		<8301, 8302, 8303>,
		<8304, 8305, 8306>,
		<8307, 8308, 8309>,
		<8310, 8311, 8312>,
		<8313, 8314, 8315>,
		<8316, 8317, 8318>,
		<8319, 8320, 8321>,
		<8322, 8323, 8324>,
		<8325, 8326, 8327>,
		<8328, 8329, 8330>,
		<8331, 8332, 8333>,
		<8334, 8335, 8336>,
		<8337, 8338, 8339>,
		<8340, 8341, 8342>,
		<8343, 8344, 8345>,
		<8346, 8347, 8348>,
		<8349, 8350, 8351>,
		<8352, 8353, 8354>,
		<8355, 8356, 8357>,
		<8358, 8359, 8360>,
		<8361, 8362, 8363>,
		<8364, 8365, 8366>,
		<8367, 8368, 8369>,
		<8370, 8371, 8372>,
		<8373, 8374, 8375>,
		<8376, 8377, 8378>,
		<8379, 8380, 8381>,
		<8382, 8383, 8384>,
		<8385, 8386, 8387>,
		<8388, 8389, 8390>,
		<8391, 8392, 8393>,
		<8394, 8395, 8396>,
		<8397, 8398, 8399>,
		<8400, 8401, 8402>,
		<8403, 8404, 8405>,
		<8406, 8407, 8408>,
		<8409, 8410, 8411>,
		<8412, 8413, 8414>,
		<8415, 8416, 8417>,
		<8418, 8419, 8420>,
		<8421, 8422, 8423>,
		<8424, 8425, 8426>,
		<8427, 8428, 8429>,
		<8430, 8431, 8432>,
		<8433, 8434, 8435>,
		<8436, 8437, 8438>,
		<8439, 8440, 8441>,
		<8442, 8443, 8444>,
		<8445, 8446, 8447>,
		<8448, 8449, 8450>,
		<8451, 8452, 8453>,
		<8454, 8455, 8456>,
		<8457, 8458, 8459>,
		<8460, 8461, 8462>,
		<8463, 8464, 8465>,
		<8466, 8467, 8468>,
		<8469, 8470, 8471>,
		<8472, 8473, 8474>,
		<8475, 8476, 8477>,
		<8478, 8479, 8480>,
		<8481, 8482, 8483>,
		<8484, 8485, 8486>,
		<8487, 8488, 8489>,
		<8490, 8491, 8492>,
		<8493, 8494, 8495>,
		<8496, 8497, 8498>,
		<8499, 8500, 8501>,
		<8502, 8503, 8504>,
		<8505, 8506, 8507>,
		<8508, 8509, 8510>,
		<8511, 8512, 8513>,
		<8514, 8515, 8516>,
		<8517, 8518, 8519>,
		<8520, 8521, 8522>,
		<8523, 8524, 8525>,
		<8526, 8527, 8528>,
		<8529, 8530, 8531>,
		<8532, 8533, 8534>,
		<8535, 8536, 8537>,
		<8538, 8539, 8540>,
		<8541, 8542, 8543>,
		<8544, 8545, 8546>,
		<8547, 8548, 8549>,
		<8550, 8551, 8552>,
		<8553, 8554, 8555>,
		<8556, 8557, 8558>,
		<8559, 8560, 8561>,
		<8562, 8563, 8564>,
		<8565, 8566, 8567>,
		<8568, 8569, 8570>,
		<8571, 8572, 8573>,
		<8574, 8575, 8576>,
		<8577, 8578, 8579>,
		<8580, 8581, 8582>,
		<8583, 8584, 8585>,
		<8586, 8587, 8588>,
		<8589, 8590, 8591>,
		<8592, 8593, 8594>,
		<8595, 8596, 8597>,
		<8598, 8599, 8600>,
		<8601, 8602, 8603>,
		<8604, 8605, 8606>,
		<8607, 8608, 8609>,
		<8610, 8611, 8612>,
		<8613, 8614, 8615>,
		<8616, 8617, 8618>,
		<8619, 8620, 8621>,
		<8622, 8623, 8624>,
		<8625, 8626, 8627>,
		<8628, 8629, 8630>,
		<8631, 8632, 8633>,
		<8634, 8635, 8636>,
		<8637, 8638, 8639>,
		<8640, 8641, 8642>,
		<8643, 8644, 8645>,
		<8646, 8647, 8648>,
		<8649, 8650, 8651>,
		<8652, 8653, 8654>,
		<8655, 8656, 8657>,
		<8658, 8659, 8660>,
		<8661, 8662, 8663>,
		<8664, 8665, 8666>,
		<8667, 8668, 8669>,
		<8670, 8671, 8672>,
		<8673, 8674, 8675>,
		<8676, 8677, 8678>,
		<8679, 8680, 8681>,
		<8682, 8683, 8684>,
		<8685, 8686, 8687>,
		<8688, 8689, 8690>,
		<8691, 8692, 8693>,
		<8694, 8695, 8696>,
		<8697, 8698, 8699>,
		<8700, 8701, 8702>,
		<8703, 8704, 8705>,
		<8706, 8707, 8708>,
		<8709, 8710, 8711>,
		<8712, 8713, 8714>,
		<8715, 8716, 8717>,
		<8718, 8719, 8720>,
		<8721, 8722, 8723>,
		<8724, 8725, 8726>,
		<8727, 8728, 8729>,
		<8730, 8731, 8732>,
		<8733, 8734, 8735>,
		<8736, 8737, 8738>,
		<8739, 8740, 8741>,
		<8742, 8743, 8744>,
		<8745, 8746, 8747>,
		<8748, 8749, 8750>,
		<8751, 8752, 8753>,
		<8754, 8755, 8756>,
		<8757, 8758, 8759>,
		<8760, 8761, 8762>,
		<8763, 8764, 8765>,
		<8766, 8767, 8768>,
		<8769, 8770, 8771>,
		<8772, 8773, 8774>,
		<8775, 8776, 8777>,
		<8778, 8779, 8780>,
		<8781, 8782, 8783>,
		<8784, 8785, 8786>,
		<8787, 8788, 8789>,
		<8790, 8791, 8792>,
		<8793, 8794, 8795>,
		<8796, 8797, 8798>,
		<8799, 8800, 8801>,
		<8802, 8803, 8804>,
		<8805, 8806, 8807>,
		<8808, 8809, 8810>,
		<8811, 8812, 8813>,
		<8814, 8815, 8816>,
		<8817, 8818, 8819>,
		<8820, 8821, 8822>,
		<8823, 8824, 8825>,
		<8826, 8827, 8828>,
		<8829, 8830, 8831>,
		<8832, 8833, 8834>,
		<8835, 8836, 8837>,
		<8838, 8839, 8840>,
		<8841, 8842, 8843>,
		<8844, 8845, 8846>,
		<8847, 8848, 8849>,
		<8850, 8851, 8852>,
		<8853, 8854, 8855>,
		<8856, 8857, 8858>,
		<8859, 8860, 8861>,
		<8862, 8863, 8864>,
		<8865, 8866, 8867>,
		<8868, 8869, 8870>,
		<8871, 8872, 8873>,
		<8874, 8875, 8876>,
		<8877, 8878, 8879>,
		<8880, 8881, 8882>,
		<8883, 8884, 8885>,
		<8886, 8887, 8888>,
		<8889, 8890, 8891>,
		<8892, 8893, 8894>,
		<8895, 8896, 8897>,
		<8898, 8899, 8900>,
		<8901, 8902, 8903>,
		<8904, 8905, 8906>,
		<8907, 8908, 8909>,
		<8910, 8911, 8912>,
		<8913, 8914, 8915>,
		<8916, 8917, 8918>,
		<8919, 8920, 8921>,
		<8922, 8923, 8924>,
		<8925, 8926, 8927>,
		<8928, 8929, 8930>,
		<8931, 8932, 8933>,
		<8934, 8935, 8936>,
		<8937, 8938, 8939>,
		<8940, 8941, 8942>,
		<8943, 8944, 8945>,
		<8946, 8947, 8948>,
		<8949, 8950, 8951>,
		<8952, 8953, 8954>,
		<8955, 8956, 8957>,
		<8958, 8959, 8960>,
		<8961, 8962, 8963>,
		<8964, 8965, 8966>,
		<8967, 8968, 8969>,
		<8970, 8971, 8972>,
		<8973, 8974, 8975>,
		<8976, 8977, 8978>,
		<8979, 8980, 8981>,
		<8982, 8983, 8984>,
		<8985, 8986, 8987>,
		<8988, 8989, 8990>,
		<8991, 8992, 8993>,
		<8994, 8995, 8996>,
		<8997, 8998, 8999>,
		<9000, 9001, 9002>,
		<9003, 9004, 9005>,
		<9006, 9007, 9008>,
		<9009, 9010, 9011>,
		<9012, 9013, 9014>,
		<9015, 9016, 9017>,
		<9018, 9019, 9020>,
		<9021, 9022, 9023>,
		<9024, 9025, 9026>,
		<9027, 9028, 9029>,
		<9030, 9031, 9032>,
		<9033, 9034, 9035>,
		<9036, 9037, 9038>,
		<9039, 9040, 9041>,
		<9042, 9043, 9044>,
		<9045, 9046, 9047>,
		<9048, 9049, 9050>,
		<9051, 9052, 9053>,
		<9054, 9055, 9056>,
		<9057, 9058, 9059>,
		<9060, 9061, 9062>,
		<9063, 9064, 9065>,
		<9066, 9067, 9068>,
		<9069, 9070, 9071>,
		<9072, 9073, 9074>,
		<9075, 9076, 9077>,
		<9078, 9079, 9080>,
		<9081, 9082, 9083>,
		<9084, 9085, 9086>,
		<9087, 9088, 9089>,
		<9090, 9091, 9092>,
		<9093, 9094, 9095>,
		<9096, 9097, 9098>,
		<9099, 9100, 9101>,
		<9102, 9103, 9104>,
		<9105, 9106, 9107>,
		<9108, 9109, 9110>,
		<9111, 9112, 9113>,
		<9114, 9115, 9116>,
		<9117, 9118, 9119>,
		<9120, 9121, 9122>,
		<9123, 9124, 9125>,
		<9126, 9127, 9128>,
		<9129, 9130, 9131>,
		<9132, 9133, 9134>,
		<9135, 9136, 9137>,
		<9138, 9139, 9140>,
		<9141, 9142, 9143>,
		<9144, 9145, 9146>,
		<9147, 9148, 9149>,
		<9150, 9151, 9152>,
		<9153, 9154, 9155>,
		<9156, 9157, 9158>,
		<9159, 9160, 9161>,
		<9162, 9163, 9164>,
		<9165, 9166, 9167>,
		<9168, 9169, 9170>,
		<9171, 9172, 9173>,
		<9174, 9175, 9176>,
		<9177, 9178, 9179>,
		<9180, 9181, 9182>,
		<9183, 9184, 9185>,
		<9186, 9187, 9188>,
		<9189, 9190, 9191>,
		<9192, 9193, 9194>,
		<9195, 9196, 9197>,
		<9198, 9199, 9200>,
		<9201, 9202, 9203>,
		<9204, 9205, 9206>,
		<9207, 9208, 9209>,
		<9210, 9211, 9212>,
		<9213, 9214, 9215>,
		<9216, 9217, 9218>,
		<9219, 9220, 9221>,
		<9222, 9223, 9224>,
		<9225, 9226, 9227>,
		<9228, 9229, 9230>,
		<9231, 9232, 9233>,
		<9234, 9235, 9236>,
		<9237, 9238, 9239>,
		<9240, 9241, 9242>,
		<9243, 9244, 9245>,
		<9246, 9247, 9248>,
		<9249, 9250, 9251>,
		<9252, 9253, 9254>,
		<9255, 9256, 9257>,
		<9258, 9259, 9260>,
		<9261, 9262, 9263>,
		<9264, 9265, 9266>,
		<9267, 9268, 9269>,
		<9270, 9271, 9272>,
		<9273, 9274, 9275>,
		<9276, 9277, 9278>,
		<9279, 9280, 9281>,
		<9282, 9283, 9284>,
		<9285, 9286, 9287>,
		<9288, 9289, 9290>,
		<9291, 9292, 9293>,
		<9294, 9295, 9296>,
		<9297, 9298, 9299>,
		<9300, 9301, 9302>,
		<9303, 9304, 9305>,
		<9306, 9307, 9308>,
		<9309, 9310, 9311>,
		<9312, 9313, 9314>,
		<9315, 9316, 9317>,
		<9318, 9319, 9320>,
		<9321, 9322, 9323>,
		<9324, 9325, 9326>,
		<9327, 9328, 9329>,
		<9330, 9331, 9332>,
		<9333, 9334, 9335>,
		<9336, 9337, 9338>,
		<9339, 9340, 9341>,
		<9342, 9343, 9344>,
		<9345, 9346, 9347>,
		<9348, 9349, 9350>,
		<9351, 9352, 9353>,
		<9354, 9355, 9356>,
		<9357, 9358, 9359>,
		<9360, 9361, 9362>,
		<9363, 9364, 9365>,
		<9366, 9367, 9368>,
		<9369, 9370, 9371>,
		<9372, 9373, 9374>,
		<9375, 9376, 9377>,
		<9378, 9379, 9380>,
		<9381, 9382, 9383>,
		<9384, 9385, 9386>,
		<9387, 9388, 9389>,
		<9390, 9391, 9392>,
		<9393, 9394, 9395>,
		<9396, 9397, 9398>,
		<9399, 9400, 9401>,
		<9402, 9403, 9404>,
		<9405, 9406, 9407>,
		<9408, 9409, 9410>,
		<9411, 9412, 9413>,
		<9414, 9415, 9416>,
		<9417, 9418, 9419>,
		<9420, 9421, 9422>,
		<9423, 9424, 9425>,
		<9426, 9427, 9428>,
		<9429, 9430, 9431>,
		<9432, 9433, 9434>,
		<9435, 9436, 9437>,
		<9438, 9439, 9440>,
		<9441, 9442, 9443>,
		<9444, 9445, 9446>,
		<9447, 9448, 9449>,
		<9450, 9451, 9452>,
		<9453, 9454, 9455>,
		<9456, 9457, 9458>,
		<9459, 9460, 9461>,
		<9462, 9463, 9464>,
		<9465, 9466, 9467>,
		<9468, 9469, 9470>,
		<9471, 9472, 9473>,
		<9474, 9475, 9476>,
		<9477, 9478, 9479>,
		<9480, 9481, 9482>,
		<9483, 9484, 9485>,
		<9486, 9487, 9488>,
		<9489, 9490, 9491>,
		<9492, 9493, 9494>,
		<9495, 9496, 9497>,
		<9498, 9499, 9500>,
		<9501, 9502, 9503>,
		<9504, 9505, 9506>,
		<9507, 9508, 9509>,
		<9510, 9511, 9512>,
		<9513, 9514, 9515>,
		<9516, 9517, 9518>,
		<9519, 9520, 9521>,
		<9522, 9523, 9524>,
		<9525, 9526, 9527>,
		<9528, 9529, 9530>,
		<9531, 9532, 9533>,
		<9534, 9535, 9536>,
		<9537, 9538, 9539>,
		<9540, 9541, 9542>,
		<9543, 9544, 9545>,
		<9546, 9547, 9548>,
		<9549, 9550, 9551>,
		<9552, 9553, 9554>,
		<9555, 9556, 9557>,
		<9558, 9559, 9560>,
		<9561, 9562, 9563>,
		<9564, 9565, 9566>,
		<9567, 9568, 9569>,
		<9570, 9571, 9572>,
		<9573, 9574, 9575>,
		<9576, 9577, 9578>,
		<9579, 9580, 9581>,
		<9582, 9583, 9584>,
		<9585, 9586, 9587>,
		<9588, 9589, 9590>,
		<9591, 9592, 9593>,
		<9594, 9595, 9596>,
		<9597, 9598, 9599>,
		<9600, 9601, 9602>,
		<9603, 9604, 9605>,
		<9606, 9607, 9608>,
		<9609, 9610, 9611>,
		<9612, 9613, 9614>,
		<9615, 9616, 9617>,
		<9618, 9619, 9620>,
		<9621, 9622, 9623>,
		<9624, 9625, 9626>,
		<9627, 9628, 9629>,
		<9630, 9631, 9632>,
		<9633, 9634, 9635>,
		<9636, 9637, 9638>,
		<9639, 9640, 9641>,
		<9642, 9643, 9644>,
		<9645, 9646, 9647>,
		<9648, 9649, 9650>,
		<9651, 9652, 9653>,
		<9654, 9655, 9656>,
		<9657, 9658, 9659>,
		<9660, 9661, 9662>,
		<9663, 9664, 9665>,
		<9666, 9667, 9668>,
		<9669, 9670, 9671>,
		<9672, 9673, 9674>,
		<9675, 9676, 9677>,
		<9678, 9679, 9680>,
		<9681, 9682, 9683>,
		<9684, 9685, 9686>,
		<9687, 9688, 9689>,
		<9690, 9691, 9692>,
		<9693, 9694, 9695>,
		<9696, 9697, 9698>,
		<9699, 9700, 9701>,
		<9702, 9703, 9704>,
		<9705, 9706, 9707>,
		<9708, 9709, 9710>,
		<9711, 9712, 9713>,
		<9714, 9715, 9716>,
		<9717, 9718, 9719>,
		<9720, 9721, 9722>,
		<9723, 9724, 9725>,
		<9726, 9727, 9728>,
		<9729, 9730, 9731>,
		<9732, 9733, 9734>,
		<9735, 9736, 9737>,
		<9738, 9739, 9740>,
		<9741, 9742, 9743>,
		<9744, 9745, 9746>,
		<9747, 9748, 9749>,
		<9750, 9751, 9752>,
		<9753, 9754, 9755>,
		<9756, 9757, 9758>,
		<9759, 9760, 9761>,
		<9762, 9763, 9764>,
		<9765, 9766, 9767>,
		<9768, 9769, 9770>,
		<9771, 9772, 9773>,
		<9774, 9775, 9776>,
		<9777, 9778, 9779>,
		<9780, 9781, 9782>,
		<9783, 9784, 9785>,
		<9786, 9787, 9788>,
		<9789, 9790, 9791>,
		<9792, 9793, 9794>,
		<9795, 9796, 9797>,
		<9798, 9799, 9800>,
		<9801, 9802, 9803>,
		<9804, 9805, 9806>,
		<9807, 9808, 9809>,
		<9810, 9811, 9812>,
		<9813, 9814, 9815>,
		<9816, 9817, 9818>,
		<9819, 9820, 9821>,
		<9822, 9823, 9824>,
		<9825, 9826, 9827>,
		<9828, 9829, 9830>,
		<9831, 9832, 9833>,
		<9834, 9835, 9836>,
		<9837, 9838, 9839>,
		<9840, 9841, 9842>,
		<9843, 9844, 9845>,
		<9846, 9847, 9848>,
		<9849, 9850, 9851>,
		<9852, 9853, 9854>,
		<9855, 9856, 9857>,
		<9858, 9859, 9860>,
		<9861, 9862, 9863>,
		<9864, 9865, 9866>,
		<9867, 9868, 9869>,
		<9870, 9871, 9872>,
		<9873, 9874, 9875>,
		<9876, 9877, 9878>,
		<9879, 9880, 9881>,
		<9882, 9883, 9884>,
		<9885, 9886, 9887>,
		<9888, 9889, 9890>,
		<9891, 9892, 9893>,
		<9894, 9895, 9896>,
		<9897, 9898, 9899>,
		<9900, 9901, 9902>,
		<9903, 9904, 9905>,
		<9906, 9907, 9908>,
		<9909, 9910, 9911>,
		<9912, 9913, 9914>,
		<9915, 9916, 9917>,
		<9918, 9919, 9920>,
		<9921, 9922, 9923>,
		<9924, 9925, 9926>,
		<9927, 9928, 9929>,
		<9930, 9931, 9932>,
		<9933, 9934, 9935>,
		<9936, 9937, 9938>,
		<9939, 9940, 9941>,
		<9942, 9943, 9944>,
		<9945, 9946, 9947>,
		<9948, 9949, 9950>,
		<9951, 9952, 9953>,
		<9954, 9955, 9956>,
		<9957, 9958, 9959>,
		<9960, 9961, 9962>,
		<9963, 9964, 9965>,
		<9966, 9967, 9968>,
		<9969, 9970, 9971>,
		<9972, 9973, 9974>,
		<9975, 9976, 9977>,
		<9978, 9979, 9980>,
		<9981, 9982, 9983>,
		<9984, 9985, 9986>,
		<9987, 9988, 9989>,
		<9990, 9991, 9992>,
		<9993, 9994, 9995>,
		<9996, 9997, 9998>,
		<9999, 10000, 10001>,
		<10002, 10003, 10004>,
		<10005, 10006, 10007>,
		<10008, 10009, 10010>,
		<10011, 10012, 10013>,
		<10014, 10015, 10016>,
		<10017, 10018, 10019>,
		<10020, 10021, 10022>,
		<10023, 10024, 10025>,
		<10026, 10027, 10028>,
		<10029, 10030, 10031>,
		<10032, 10033, 10034>,
		<10035, 10036, 10037>,
		<10038, 10039, 10040>,
		<10041, 10042, 10043>,
		<10044, 10045, 10046>,
		<10047, 10048, 10049>,
		<10050, 10051, 10052>,
		<10053, 10054, 10055>,
		<10056, 10057, 10058>,
		<10059, 10060, 10061>,
		<10062, 10063, 10064>,
		<10065, 10066, 10067>,
		<10068, 10069, 10070>,
		<10071, 10072, 10073>,
		<10074, 10075, 10076>,
		<10077, 10078, 10079>,
		<10080, 10081, 10082>,
		<10083, 10084, 10085>,
		<10086, 10087, 10088>,
		<10089, 10090, 10091>,
		<10092, 10093, 10094>,
		<10095, 10096, 10097>,
		<10098, 10099, 10100>,
		<10101, 10102, 10103>,
		<10104, 10105, 10106>,
		<10107, 10108, 10109>,
		<10110, 10111, 10112>,
		<10113, 10114, 10115>,
		<10116, 10117, 10118>,
		<10119, 10120, 10121>,
		<10122, 10123, 10124>,
		<10125, 10126, 10127>,
		<10128, 10129, 10130>,
		<10131, 10132, 10133>,
		<10134, 10135, 10136>,
		<10137, 10138, 10139>,
		<10140, 10141, 10142>,
		<10143, 10144, 10145>,
		<10146, 10147, 10148>,
		<10149, 10150, 10151>,
		<10152, 10153, 10154>,
		<10155, 10156, 10157>,
		<10158, 10159, 10160>,
		<10161, 10162, 10163>,
		<10164, 10165, 10166>,
		<10167, 10168, 10169>,
		<10170, 10171, 10172>,
		<10173, 10174, 10175>,
		<10176, 10177, 10178>,
		<10179, 10180, 10181>,
		<10182, 10183, 10184>,
		<10185, 10186, 10187>,
		<10188, 10189, 10190>,
		<10191, 10192, 10193>,
		<10194, 10195, 10196>,
		<10197, 10198, 10199>,
		<10200, 10201, 10202>,
		<10203, 10204, 10205>,
		<10206, 10207, 10208>,
		<10209, 10210, 10211>,
		<10212, 10213, 10214>,
		<10215, 10216, 10217>,
		<10218, 10219, 10220>,
		<10221, 10222, 10223>,
		<10224, 10225, 10226>,
		<10227, 10228, 10229>,
		<10230, 10231, 10232>,
		<10233, 10234, 10235>,
		<10236, 10237, 10238>,
		<10239, 10240, 10241>,
		<10242, 10243, 10244>,
		<10245, 10246, 10247>,
		<10248, 10249, 10250>,
		<10251, 10252, 10253>,
		<10254, 10255, 10256>,
		<10257, 10258, 10259>,
		<10260, 10261, 10262>,
		<10263, 10264, 10265>,
		<10266, 10267, 10268>,
		<10269, 10270, 10271>,
		<10272, 10273, 10274>,
		<10275, 10276, 10277>,
		<10278, 10279, 10280>,
		<10281, 10282, 10283>,
		<10284, 10285, 10286>,
		<10287, 10288, 10289>,
		<10290, 10291, 10292>,
		<10293, 10294, 10295>,
		<10296, 10297, 10298>,
		<10299, 10300, 10301>,
		<10302, 10303, 10304>,
		<10305, 10306, 10307>,
		<10308, 10309, 10310>,
		<10311, 10312, 10313>,
		<10314, 10315, 10316>,
		<10317, 10318, 10319>,
		<10320, 10321, 10322>,
		<10323, 10324, 10325>,
		<10326, 10327, 10328>,
		<10329, 10330, 10331>,
		<10332, 10333, 10334>,
		<10335, 10336, 10337>,
		<10338, 10339, 10340>,
		<10341, 10342, 10343>,
		<10344, 10345, 10346>,
		<10347, 10348, 10349>,
		<10350, 10351, 10352>,
		<10353, 10354, 10355>,
		<10356, 10357, 10358>,
		<10359, 10360, 10361>,
		<10362, 10363, 10364>,
		<10365, 10366, 10367>,
		<10368, 10369, 10370>,
		<10371, 10372, 10373>,
		<10374, 10375, 10376>,
		<10377, 10378, 10379>,
		<10380, 10381, 10382>,
		<10383, 10384, 10385>,
		<10386, 10387, 10388>,
		<10389, 10390, 10391>,
		<10392, 10393, 10394>,
		<10395, 10396, 10397>,
		<10398, 10399, 10400>,
		<10401, 10402, 10403>,
		<10404, 10405, 10406>,
		<10407, 10408, 10409>,
		<10410, 10411, 10412>,
		<10413, 10414, 10415>,
		<10416, 10417, 10418>,
		<10419, 10420, 10421>,
		<10422, 10423, 10424>,
		<10425, 10426, 10427>,
		<10428, 10429, 10430>,
		<10431, 10432, 10433>,
		<10434, 10435, 10436>,
		<10437, 10438, 10439>,
		<10440, 10441, 10442>,
		<10443, 10444, 10445>,
		<10446, 10447, 10448>,
		<10449, 10450, 10451>,
		<10452, 10453, 10454>,
		<10455, 10456, 10457>,
		<10458, 10459, 10460>,
		<10461, 10462, 10463>,
		<10464, 10465, 10466>,
		<10467, 10468, 10469>,
		<10470, 10471, 10472>,
		<10473, 10474, 10475>,
		<10476, 10477, 10478>,
		<10479, 10480, 10481>,
		<10482, 10483, 10484>,
		<10485, 10486, 10487>,
		<10488, 10489, 10490>,
		<10491, 10492, 10493>,
		<10494, 10495, 10496>,
		<10497, 10498, 10499>,
		<10500, 10501, 10502>,
		<10503, 10504, 10505>,
		<10506, 10507, 10508>,
		<10509, 10510, 10511>,
		<10512, 10513, 10514>,
		<10515, 10516, 10517>,
		<10518, 10519, 10520>,
		<10521, 10522, 10523>,
		<10524, 10525, 10526>,
		<10527, 10528, 10529>,
		<10530, 10531, 10532>,
		<10533, 10534, 10535>,
		<10536, 10537, 10538>,
		<10539, 10540, 10541>,
		<10542, 10543, 10544>,
		<10545, 10546, 10547>,
		<10548, 10549, 10550>,
		<10551, 10552, 10553>,
		<10554, 10555, 10556>,
		<10557, 10558, 10559>,
		<10560, 10561, 10562>,
		<10563, 10564, 10565>,
		<10566, 10567, 10568>,
		<10569, 10570, 10571>,
		<10572, 10573, 10574>,
		<10575, 10576, 10577>,
		<10578, 10579, 10580>,
		<10581, 10582, 10583>,
		<10584, 10585, 10586>,
		<10587, 10588, 10589>,
		<10590, 10591, 10592>,
		<10593, 10594, 10595>,
		<10596, 10597, 10598>,
		<10599, 10600, 10601>,
		<10602, 10603, 10604>,
		<10605, 10606, 10607>,
		<10608, 10609, 10610>,
		<10611, 10612, 10613>,
		<10614, 10615, 10616>,
		<10617, 10618, 10619>,
		<10620, 10621, 10622>,
		<10623, 10624, 10625>,
		<10626, 10627, 10628>,
		<10629, 10630, 10631>,
		<10632, 10633, 10634>,
		<10635, 10636, 10637>,
		<10638, 10639, 10640>,
		<10641, 10642, 10643>,
		<10644, 10645, 10646>,
		<10647, 10648, 10649>,
		<10650, 10651, 10652>,
		<10653, 10654, 10655>,
		<10656, 10657, 10658>,
		<10659, 10660, 10661>,
		<10662, 10663, 10664>,
		<10665, 10666, 10667>,
		<10668, 10669, 10670>,
		<10671, 10672, 10673>,
		<10674, 10675, 10676>,
		<10677, 10678, 10679>,
		<10680, 10681, 10682>,
		<10683, 10684, 10685>,
		<10686, 10687, 10688>,
		<10689, 10690, 10691>,
		<10692, 10693, 10694>,
		<10695, 10696, 10697>,
		<10698, 10699, 10700>,
		<10701, 10702, 10703>,
		<10704, 10705, 10706>,
		<10707, 10708, 10709>,
		<10710, 10711, 10712>,
		<10713, 10714, 10715>,
		<10716, 10717, 10718>,
		<10719, 10720, 10721>,
		<10722, 10723, 10724>,
		<10725, 10726, 10727>,
		<10728, 10729, 10730>,
		<10731, 10732, 10733>,
		<10734, 10735, 10736>,
		<10737, 10738, 10739>,
		<10740, 10741, 10742>,
		<10743, 10744, 10745>,
		<10746, 10747, 10748>,
		<10749, 10750, 10751>,
		<10752, 10753, 10754>,
		<10755, 10756, 10757>,
		<10758, 10759, 10760>,
		<10761, 10762, 10763>,
		<10764, 10765, 10766>,
		<10767, 10768, 10769>,
		<10770, 10771, 10772>,
		<10773, 10774, 10775>,
		<10776, 10777, 10778>,
		<10779, 10780, 10781>,
		<10782, 10783, 10784>,
		<10785, 10786, 10787>,
		<10788, 10789, 10790>,
		<10791, 10792, 10793>,
		<10794, 10795, 10796>,
		<10797, 10798, 10799>,
		<10800, 10801, 10802>,
		<10803, 10804, 10805>,
		<10806, 10807, 10808>,
		<10809, 10810, 10811>,
		<10812, 10813, 10814>,
		<10815, 10816, 10817>,
		<10818, 10819, 10820>,
		<10821, 10822, 10823>,
		<10824, 10825, 10826>,
		<10827, 10828, 10829>,
		<10830, 10831, 10832>,
		<10833, 10834, 10835>,
		<10836, 10837, 10838>,
		<10839, 10840, 10841>,
		<10842, 10843, 10844>,
		<10845, 10846, 10847>,
		<10848, 10849, 10850>,
		<10851, 10852, 10853>,
		<10854, 10855, 10856>,
		<10857, 10858, 10859>,
		<10860, 10861, 10862>,
		<10863, 10864, 10865>,
		<10866, 10867, 10868>,
		<10869, 10870, 10871>,
		<10872, 10873, 10874>,
		<10875, 10876, 10877>,
		<10878, 10879, 10880>,
		<10881, 10882, 10883>,
		<10884, 10885, 10886>,
		<10887, 10888, 10889>,
		<10890, 10891, 10892>,
		<10893, 10894, 10895>,
		<10896, 10897, 10898>,
		<10899, 10900, 10901>,
		<10902, 10903, 10904>,
		<10905, 10906, 10907>,
		<10908, 10909, 10910>,
		<10911, 10912, 10913>,
		<10914, 10915, 10916>,
		<10917, 10918, 10919>,
		<10920, 10921, 10922>,
		<10923, 10924, 10925>,
		<10926, 10927, 10928>,
		<10929, 10930, 10931>,
		<10932, 10933, 10934>,
		<10935, 10936, 10937>,
		<10938, 10939, 10940>,
		<10941, 10942, 10943>,
		<10944, 10945, 10946>,
		<10947, 10948, 10949>,
		<10950, 10951, 10952>,
		<10953, 10954, 10955>,
		<10956, 10957, 10958>,
		<10959, 10960, 10961>,
		<10962, 10963, 10964>,
		<10965, 10966, 10967>,
		<10968, 10969, 10970>,
		<10971, 10972, 10973>,
		<10974, 10975, 10976>,
		<10977, 10978, 10979>,
		<10980, 10981, 10982>,
		<10983, 10984, 10985>,
		<10986, 10987, 10988>,
		<10989, 10990, 10991>,
		<10992, 10993, 10994>,
		<10995, 10996, 10997>,
		<10998, 10999, 11000>,
		<11001, 11002, 11003>,
		<11004, 11005, 11006>,
		<11007, 11008, 11009>,
		<11010, 11011, 11012>,
		<11013, 11014, 11015>,
		<11016, 11017, 11018>,
		<11019, 11020, 11021>,
		<11022, 11023, 11024>,
		<11025, 11026, 11027>,
		<11028, 11029, 11030>,
		<11031, 11032, 11033>,
		<11034, 11035, 11036>,
		<11037, 11038, 11039>,
		<11040, 11041, 11042>,
		<11043, 11044, 11045>,
		<11046, 11047, 11048>,
		<11049, 11050, 11051>,
		<11052, 11053, 11054>,
		<11055, 11056, 11057>,
		<11058, 11059, 11060>,
		<11061, 11062, 11063>,
		<11064, 11065, 11066>,
		<11067, 11068, 11069>,
		<11070, 11071, 11072>,
		<11073, 11074, 11075>,
		<11076, 11077, 11078>,
		<11079, 11080, 11081>,
		<11082, 11083, 11084>,
		<11085, 11086, 11087>,
		<11088, 11089, 11090>,
		<11091, 11092, 11093>,
		<11094, 11095, 11096>,
		<11097, 11098, 11099>,
		<11100, 11101, 11102>,
		<11103, 11104, 11105>,
		<11106, 11107, 11108>,
		<11109, 11110, 11111>,
		<11112, 11113, 11114>,
		<11115, 11116, 11117>,
		<11118, 11119, 11120>,
		<11121, 11122, 11123>,
		<11124, 11125, 11126>,
		<11127, 11128, 11129>,
		<11130, 11131, 11132>,
		<11133, 11134, 11135>,
		<11136, 11137, 11138>,
		<11139, 11140, 11141>,
		<11142, 11143, 11144>,
		<11145, 11146, 11147>,
		<11148, 11149, 11150>,
		<11151, 11152, 11153>,
		<11154, 11155, 11156>,
		<11157, 11158, 11159>,
		<11160, 11161, 11162>,
		<11163, 11164, 11165>,
		<11166, 11167, 11168>,
		<11169, 11170, 11171>,
		<11172, 11173, 11174>,
		<11175, 11176, 11177>,
		<11178, 11179, 11180>,
		<11181, 11182, 11183>,
		<11184, 11185, 11186>,
		<11187, 11188, 11189>,
		<11190, 11191, 11192>,
		<11193, 11194, 11195>,
		<11196, 11197, 11198>,
		<11199, 11200, 11201>,
		<11202, 11203, 11204>,
		<11205, 11206, 11207>,
		<11208, 11209, 11210>,
		<11211, 11212, 11213>,
		<11214, 11215, 11216>,
		<11217, 11218, 11219>,
		<11220, 11221, 11222>,
		<11223, 11224, 11225>,
		<11226, 11227, 11228>,
		<11229, 11230, 11231>,
		<11232, 11233, 11234>,
		<11235, 11236, 11237>,
		<11238, 11239, 11240>,
		<11241, 11242, 11243>,
		<11244, 11245, 11246>,
		<11247, 11248, 11249>,
		<11250, 11251, 11252>,
		<11253, 11254, 11255>,
		<11256, 11257, 11258>,
		<11259, 11260, 11261>,
		<11262, 11263, 11264>,
		<11265, 11266, 11267>,
		<11268, 11269, 11270>,
		<11271, 11272, 11273>,
		<11274, 11275, 11276>,
		<11277, 11278, 11279>,
		<11280, 11281, 11282>,
		<11283, 11284, 11285>,
		<11286, 11287, 11288>,
		<11289, 11290, 11291>,
		<11292, 11293, 11294>,
		<11295, 11296, 11297>,
		<11298, 11299, 11300>,
		<11301, 11302, 11303>,
		<11304, 11305, 11306>,
		<11307, 11308, 11309>,
		<11310, 11311, 11312>,
		<11313, 11314, 11315>,
		<11316, 11317, 11318>,
		<11319, 11320, 11321>,
		<11322, 11323, 11324>,
		<11325, 11326, 11327>,
		<11328, 11329, 11330>,
		<11331, 11332, 11333>,
		<11334, 11335, 11336>,
		<11337, 11338, 11339>,
		<11340, 11341, 11342>,
		<11343, 11344, 11345>,
		<11346, 11347, 11348>,
		<11349, 11350, 11351>,
		<11352, 11353, 11354>,
		<11355, 11356, 11357>,
		<11358, 11359, 11360>,
		<11361, 11362, 11363>,
		<11364, 11365, 11366>,
		<11367, 11368, 11369>,
		<11370, 11371, 11372>,
		<11373, 11374, 11375>,
		<11376, 11377, 11378>,
		<11379, 11380, 11381>,
		<11382, 11383, 11384>,
		<11385, 11386, 11387>,
		<11388, 11389, 11390>,
		<11391, 11392, 11393>,
		<11394, 11395, 11396>,
		<11397, 11398, 11399>,
		<11400, 11401, 11402>,
		<11403, 11404, 11405>,
		<11406, 11407, 11408>,
		<11409, 11410, 11411>,
		<11412, 11413, 11414>,
		<11415, 11416, 11417>,
		<11418, 11419, 11420>,
		<11421, 11422, 11423>,
		<11424, 11425, 11426>,
		<11427, 11428, 11429>,
		<11430, 11431, 11432>,
		<11433, 11434, 11435>,
		<11436, 11437, 11438>,
		<11439, 11440, 11441>,
		<11442, 11443, 11444>,
		<11445, 11446, 11447>,
		<11448, 11449, 11450>,
		<11451, 11452, 11453>,
		<11454, 11455, 11456>,
		<11457, 11458, 11459>,
		<11460, 11461, 11462>,
		<11463, 11464, 11465>,
		<11466, 11467, 11468>,
		<11469, 11470, 11471>,
		<11472, 11473, 11474>,
		<11475, 11476, 11477>,
		<11478, 11479, 11480>,
		<11481, 11482, 11483>,
		<11484, 11485, 11486>,
		<11487, 11488, 11489>,
		<11490, 11491, 11492>,
		<11493, 11494, 11495>,
		<11496, 11497, 11498>,
		<11499, 11500, 11501>,
		<11502, 11503, 11504>,
		<11505, 11506, 11507>,
		<11508, 11509, 11510>,
		<11511, 11512, 11513>,
		<11514, 11515, 11516>,
		<11517, 11518, 11519>,
		<11520, 11521, 11522>,
		<11523, 11524, 11525>,
		<11526, 11527, 11528>,
		<11529, 11530, 11531>,
		<11532, 11533, 11534>,
		<11535, 11536, 11537>,
		<11538, 11539, 11540>,
		<11541, 11542, 11543>,
		<11544, 11545, 11546>,
		<11547, 11548, 11549>,
		<11550, 11551, 11552>,
		<11553, 11554, 11555>,
		<11556, 11557, 11558>,
		<11559, 11560, 11561>,
		<11562, 11563, 11564>,
		<11565, 11566, 11567>,
		<11568, 11569, 11570>,
		<11571, 11572, 11573>,
		<11574, 11575, 11576>,
		<11577, 11578, 11579>,
		<11580, 11581, 11582>,
		<11583, 11584, 11585>,
		<11586, 11587, 11588>,
		<11589, 11590, 11591>,
		<11592, 11593, 11594>,
		<11595, 11596, 11597>,
		<11598, 11599, 11600>,
		<11601, 11602, 11603>,
		<11604, 11605, 11606>,
		<11607, 11608, 11609>,
		<11610, 11611, 11612>,
		<11613, 11614, 11615>,
		<11616, 11617, 11618>,
		<11619, 11620, 11621>,
		<11622, 11623, 11624>,
		<11625, 11626, 11627>,
		<11628, 11629, 11630>,
		<11631, 11632, 11633>,
		<11634, 11635, 11636>,
		<11637, 11638, 11639>,
		<11640, 11641, 11642>,
		<11643, 11644, 11645>,
		<11646, 11647, 11648>,
		<11649, 11650, 11651>,
		<11652, 11653, 11654>,
		<11655, 11656, 11657>,
		<11658, 11659, 11660>,
		<11661, 11662, 11663>,
		<11664, 11665, 11666>,
		<11667, 11668, 11669>,
		<11670, 11671, 11672>,
		<11673, 11674, 11675>,
		<11676, 11677, 11678>,
		<11679, 11680, 11681>,
		<11682, 11683, 11684>,
		<11685, 11686, 11687>,
		<11688, 11689, 11690>,
		<11691, 11692, 11693>,
		<11694, 11695, 11696>,
		<11697, 11698, 11699>,
		<11700, 11701, 11702>,
		<11703, 11704, 11705>,
		<11706, 11707, 11708>,
		<11709, 11710, 11711>,
		<11712, 11713, 11714>,
		<11715, 11716, 11717>,
		<11718, 11719, 11720>,
		<11721, 11722, 11723>,
		<11724, 11725, 11726>,
		<11727, 11728, 11729>,
		<11730, 11731, 11732>,
		<11733, 11734, 11735>,
		<11736, 11737, 11738>,
		<11739, 11740, 11741>,
		<11742, 11743, 11744>,
		<11745, 11746, 11747>,
		<11748, 11749, 11750>,
		<11751, 11752, 11753>,
		<11754, 11755, 11756>,
		<11757, 11758, 11759>,
		<11760, 11761, 11762>,
		<11763, 11764, 11765>,
		<11766, 11767, 11768>,
		<11769, 11770, 11771>,
		<11772, 11773, 11774>,
		<11775, 11776, 11777>,
		<11778, 11779, 11780>,
		<11781, 11782, 11783>,
		<11784, 11785, 11786>,
		<11787, 11788, 11789>,
		<11790, 11791, 11792>,
		<11793, 11794, 11795>,
		<11796, 11797, 11798>,
		<11799, 11800, 11801>,
		<11802, 11803, 11804>,
		<11805, 11806, 11807>,
		<11808, 11809, 11810>,
		<11811, 11812, 11813>,
		<11814, 11815, 11816>,
		<11817, 11818, 11819>,
		<11820, 11821, 11822>,
		<11823, 11824, 11825>,
		<11826, 11827, 11828>,
		<11829, 11830, 11831>,
		<11832, 11833, 11834>,
		<11835, 11836, 11837>,
		<11838, 11839, 11840>,
		<11841, 11842, 11843>,
		<11844, 11845, 11846>,
		<11847, 11848, 11849>,
		<11850, 11851, 11852>,
		<11853, 11854, 11855>,
		<11856, 11857, 11858>,
		<11859, 11860, 11861>,
		<11862, 11863, 11864>,
		<11865, 11866, 11867>,
		<11868, 11869, 11870>,
		<11871, 11872, 11873>,
		<11874, 11875, 11876>,
		<11877, 11878, 11879>,
		<11880, 11881, 11882>,
		<11883, 11884, 11885>,
		<11886, 11887, 11888>,
		<11889, 11890, 11891>,
		<11892, 11893, 11894>,
		<11895, 11896, 11897>,
		<11898, 11899, 11900>,
		<11901, 11902, 11903>,
		<11904, 11905, 11906>,
		<11907, 11908, 11909>,
		<11910, 11911, 11912>,
		<11913, 11914, 11915>,
		<11916, 11917, 11918>,
		<11919, 11920, 11921>,
		<11922, 11923, 11924>,
		<11925, 11926, 11927>,
		<11928, 11929, 11930>,
		<11931, 11932, 11933>,
		<11934, 11935, 11936>,
		<11937, 11938, 11939>,
		<11940, 11941, 11942>,
		<11943, 11944, 11945>,
		<11946, 11947, 11948>,
		<11949, 11950, 11951>,
		<11952, 11953, 11954>,
		<11955, 11956, 11957>,
		<11958, 11959, 11960>,
		<11961, 11962, 11963>,
		<11964, 11965, 11966>,
		<11967, 11968, 11969>,
		<11970, 11971, 11972>,
		<11973, 11974, 11975>,
		<11976, 11977, 11978>,
		<11979, 11980, 11981>,
		<11982, 11983, 11984>,
		<11985, 11986, 11987>,
		<11988, 11989, 11990>,
		<11991, 11992, 11993>,
		<11994, 11995, 11996>,
		<11997, 11998, 11999>,
		<12000, 12001, 12002>,
		<12003, 12004, 12005>,
		<12006, 12007, 12008>,
		<12009, 12010, 12011>,
		<12012, 12013, 12014>,
		<12015, 12016, 12017>,
		<12018, 12019, 12020>,
		<12021, 12022, 12023>,
		<12024, 12025, 12026>,
		<12027, 12028, 12029>,
		<12030, 12031, 12032>,
		<12033, 12034, 12035>,
		<12036, 12037, 12038>,
		<12039, 12040, 12041>,
		<12042, 12043, 12044>,
		<12045, 12046, 12047>,
		<12048, 12049, 12050>,
		<12051, 12052, 12053>,
		<12054, 12055, 12056>,
		<12057, 12058, 12059>,
		<12060, 12061, 12062>,
		<12063, 12064, 12065>,
		<12066, 12067, 12068>,
		<12069, 12070, 12071>,
		<12072, 12073, 12074>,
		<12075, 12076, 12077>,
		<12078, 12079, 12080>,
		<12081, 12082, 12083>,
		<12084, 12085, 12086>,
		<12087, 12088, 12089>,
		<12090, 12091, 12092>,
		<12093, 12094, 12095>,
		<12096, 12097, 12098>,
		<12099, 12100, 12101>,
		<12102, 12103, 12104>,
		<12105, 12106, 12107>,
		<12108, 12109, 12110>,
		<12111, 12112, 12113>,
		<12114, 12115, 12116>,
		<12117, 12118, 12119>,
		<12120, 12121, 12122>,
		<12123, 12124, 12125>,
		<12126, 12127, 12128>,
		<12129, 12130, 12131>,
		<12132, 12133, 12134>,
		<12135, 12136, 12137>,
		<12138, 12139, 12140>,
		<12141, 12142, 12143>,
		<12144, 12145, 12146>,
		<12147, 12148, 12149>,
		<12150, 12151, 12152>,
		<12153, 12154, 12155>,
		<12156, 12157, 12158>,
		<12159, 12160, 12161>,
		<12162, 12163, 12164>,
		<12165, 12166, 12167>,
		<12168, 12169, 12170>,
		<12171, 12172, 12173>,
		<12174, 12175, 12176>,
		<12177, 12178, 12179>,
		<12180, 12181, 12182>,
		<12183, 12184, 12185>,
		<12186, 12187, 12188>,
		<12189, 12190, 12191>,
		<12192, 12193, 12194>,
		<12195, 12196, 12197>,
		<12198, 12199, 12200>,
		<12201, 12202, 12203>,
		<12204, 12205, 12206>,
		<12207, 12208, 12209>,
		<12210, 12211, 12212>,
		<12213, 12214, 12215>,
		<12216, 12217, 12218>,
		<12219, 12220, 12221>,
		<12222, 12223, 12224>,
		<12225, 12226, 12227>,
		<12228, 12229, 12230>,
		<12231, 12232, 12233>,
		<12234, 12235, 12236>,
		<12237, 12238, 12239>,
		<12240, 12241, 12242>,
		<12243, 12244, 12245>,
		<12246, 12247, 12248>,
		<12249, 12250, 12251>,
		<12252, 12253, 12254>,
		<12255, 12256, 12257>,
		<12258, 12259, 12260>,
		<12261, 12262, 12263>,
		<12264, 12265, 12266>,
		<12267, 12268, 12269>,
		<12270, 12271, 12272>,
		<12273, 12274, 12275>,
		<12276, 12277, 12278>,
		<12279, 12280, 12281>,
		<12282, 12283, 12284>,
		<12285, 12286, 12287>,
		<12288, 12289, 12290>,
		<12291, 12292, 12293>,
		<12294, 12295, 12296>,
		<12297, 12298, 12299>,
		<12300, 12301, 12302>,
		<12303, 12304, 12305>,
		<12306, 12307, 12308>,
		<12309, 12310, 12311>,
		<12312, 12313, 12314>,
		<12315, 12316, 12317>,
		<12318, 12319, 12320>,
		<12321, 12322, 12323>,
		<12324, 12325, 12326>,
		<12327, 12328, 12329>,
		<12330, 12331, 12332>,
		<12333, 12334, 12335>,
		<12336, 12337, 12338>,
		<12339, 12340, 12341>,
		<12342, 12343, 12344>,
		<12345, 12346, 12347>,
		<12348, 12349, 12350>,
		<12351, 12352, 12353>,
		<12354, 12355, 12356>,
		<12357, 12358, 12359>,
		<12360, 12361, 12362>,
		<12363, 12364, 12365>,
		<12366, 12367, 12368>,
		<12369, 12370, 12371>,
		<12372, 12373, 12374>,
		<12375, 12376, 12377>,
		<12378, 12379, 12380>,
		<12381, 12382, 12383>,
		<12384, 12385, 12386>,
		<12387, 12388, 12389>,
		<12390, 12391, 12392>,
		<12393, 12394, 12395>,
		<12396, 12397, 12398>,
		<12399, 12400, 12401>,
		<12402, 12403, 12404>,
		<12405, 12406, 12407>,
		<12408, 12409, 12410>,
		<12411, 12412, 12413>,
		<12414, 12415, 12416>,
		<12417, 12418, 12419>,
		<12420, 12421, 12422>,
		<12423, 12424, 12425>,
		<12426, 12427, 12428>,
		<12429, 12430, 12431>,
		<12432, 12433, 12434>,
		<12435, 12436, 12437>,
		<12438, 12439, 12440>,
		<12441, 12442, 12443>,
		<12444, 12445, 12446>,
		<12447, 12448, 12449>,
		<12450, 12451, 12452>,
		<12453, 12454, 12455>,
		<12456, 12457, 12458>,
		<12459, 12460, 12461>,
		<12462, 12463, 12464>,
		<12465, 12466, 12467>,
		<12468, 12469, 12470>,
		<12471, 12472, 12473>,
		<12474, 12475, 12476>,
		<12477, 12478, 12479>,
		<12480, 12481, 12482>,
		<12483, 12484, 12485>,
		<12486, 12487, 12488>,
		<12489, 12490, 12491>,
		<12492, 12493, 12494>,
		<12495, 12496, 12497>,
		<12498, 12499, 12500>,
		<12501, 12502, 12503>,
		<12504, 12505, 12506>,
		<12507, 12508, 12509>,
		<12510, 12511, 12512>,
		<12513, 12514, 12515>,
		<12516, 12517, 12518>,
		<12519, 12520, 12521>,
		<12522, 12523, 12524>,
		<12525, 12526, 12527>,
		<12528, 12529, 12530>,
		<12531, 12532, 12533>,
		<12534, 12535, 12536>,
		<12537, 12538, 12539>,
		<12540, 12541, 12542>,
		<12543, 12544, 12545>,
		<12546, 12547, 12548>,
		<12549, 12550, 12551>,
		<12552, 12553, 12554>,
		<12555, 12556, 12557>,
		<12558, 12559, 12560>,
		<12561, 12562, 12563>,
		<12564, 12565, 12566>,
		<12567, 12568, 12569>,
		<12570, 12571, 12572>,
		<12573, 12574, 12575>,
		<12576, 12577, 12578>,
		<12579, 12580, 12581>,
		<12582, 12583, 12584>,
		<12585, 12586, 12587>,
		<12588, 12589, 12590>,
		<12591, 12592, 12593>,
		<12594, 12595, 12596>,
		<12597, 12598, 12599>,
		<12600, 12601, 12602>,
		<12603, 12604, 12605>,
		<12606, 12607, 12608>,
		<12609, 12610, 12611>,
		<12612, 12613, 12614>,
		<12615, 12616, 12617>,
		<12618, 12619, 12620>,
		<12621, 12622, 12623>,
		<12624, 12625, 12626>,
		<12627, 12628, 12629>,
		<12630, 12631, 12632>,
		<12633, 12634, 12635>,
		<12636, 12637, 12638>,
		<12639, 12640, 12641>,
		<12642, 12643, 12644>,
		<12645, 12646, 12647>,
		<12648, 12649, 12650>,
		<12651, 12652, 12653>,
		<12654, 12655, 12656>,
		<12657, 12658, 12659>,
		<12660, 12661, 12662>,
		<12663, 12664, 12665>,
		<12666, 12667, 12668>,
		<12669, 12670, 12671>,
		<12672, 12673, 12674>,
		<12675, 12676, 12677>,
		<12678, 12679, 12680>,
		<12681, 12682, 12683>,
		<12684, 12685, 12686>,
		<12687, 12688, 12689>,
		<12690, 12691, 12692>,
		<12693, 12694, 12695>,
		<12696, 12697, 12698>,
		<12699, 12700, 12701>,
		<12702, 12703, 12704>,
		<12705, 12706, 12707>,
		<12708, 12709, 12710>,
		<12711, 12712, 12713>,
		<12714, 12715, 12716>,
		<12717, 12718, 12719>,
		<12720, 12721, 12722>,
		<12723, 12724, 12725>,
		<12726, 12727, 12728>,
		<12729, 12730, 12731>,
		<12732, 12733, 12734>,
		<12735, 12736, 12737>,
		<12738, 12739, 12740>,
		<12741, 12742, 12743>,
		<12744, 12745, 12746>,
		<12747, 12748, 12749>,
		<12750, 12751, 12752>,
		<12753, 12754, 12755>,
		<12756, 12757, 12758>,
		<12759, 12760, 12761>,
		<12762, 12763, 12764>,
		<12765, 12766, 12767>,
		<12768, 12769, 12770>,
		<12771, 12772, 12773>,
		<12774, 12775, 12776>,
		<12777, 12778, 12779>,
		<12780, 12781, 12782>,
		<12783, 12784, 12785>,
		<12786, 12787, 12788>,
		<12789, 12790, 12791>,
		<12792, 12793, 12794>,
		<12795, 12796, 12797>,
		<12798, 12799, 12800>,
		<12801, 12802, 12803>,
		<12804, 12805, 12806>,
		<12807, 12808, 12809>,
		<12810, 12811, 12812>,
		<12813, 12814, 12815>,
		<12816, 12817, 12818>,
		<12819, 12820, 12821>,
		<12822, 12823, 12824>,
		<12825, 12826, 12827>,
		<12828, 12829, 12830>,
		<12831, 12832, 12833>,
		<12834, 12835, 12836>,
		<12837, 12838, 12839>,
		<12840, 12841, 12842>,
		<12843, 12844, 12845>,
		<12846, 12847, 12848>,
		<12849, 12850, 12851>,
		<12852, 12853, 12854>,
		<12855, 12856, 12857>,
		<12858, 12859, 12860>,
		<12861, 12862, 12863>,
		<12864, 12865, 12866>,
		<12867, 12868, 12869>,
		<12870, 12871, 12872>,
		<12873, 12874, 12875>,
		<12876, 12877, 12878>,
		<12879, 12880, 12881>,
		<12882, 12883, 12884>,
		<12885, 12886, 12887>,
		<12888, 12889, 12890>,
		<12891, 12892, 12893>,
		<12894, 12895, 12896>,
		<12897, 12898, 12899>,
		<12900, 12901, 12902>,
		<12903, 12904, 12905>,
		<12906, 12907, 12908>,
		<12909, 12910, 12911>,
		<12912, 12913, 12914>,
		<12915, 12916, 12917>,
		<12918, 12919, 12920>,
		<12921, 12922, 12923>,
		<12924, 12925, 12926>,
		<12927, 12928, 12929>,
		<12930, 12931, 12932>,
		<12933, 12934, 12935>,
		<12936, 12937, 12938>,
		<12939, 12940, 12941>,
		<12942, 12943, 12944>,
		<12945, 12946, 12947>,
		<12948, 12949, 12950>,
		<12951, 12952, 12953>,
		<12954, 12955, 12956>,
		<12957, 12958, 12959>,
		<12960, 12961, 12962>,
		<12963, 12964, 12965>,
		<12966, 12967, 12968>,
		<12969, 12970, 12971>,
		<12972, 12973, 12974>,
		<12975, 12976, 12977>,
		<12978, 12979, 12980>,
		<12981, 12982, 12983>,
		<12984, 12985, 12986>,
		<12987, 12988, 12989>,
		<12990, 12991, 12992>,
		<12993, 12994, 12995>,
		<12996, 12997, 12998>,
		<12999, 13000, 13001>,
		<13002, 13003, 13004>,
		<13005, 13006, 13007>,
		<13008, 13009, 13010>,
		<13011, 13012, 13013>,
		<13014, 13015, 13016>,
		<13017, 13018, 13019>,
		<13020, 13021, 13022>,
		<13023, 13024, 13025>,
		<13026, 13027, 13028>,
		<13029, 13030, 13031>,
		<13032, 13033, 13034>,
		<13035, 13036, 13037>,
		<13038, 13039, 13040>,
		<13041, 13042, 13043>,
		<13044, 13045, 13046>,
		<13047, 13048, 13049>,
		<13050, 13051, 13052>,
		<13053, 13054, 13055>,
		<13056, 13057, 13058>,
		<13059, 13060, 13061>,
		<13062, 13063, 13064>,
		<13065, 13066, 13067>,
		<13068, 13069, 13070>,
		<13071, 13072, 13073>,
		<13074, 13075, 13076>,
		<13077, 13078, 13079>,
		<13080, 13081, 13082>,
		<13083, 13084, 13085>,
		<13086, 13087, 13088>,
		<13089, 13090, 13091>,
		<13092, 13093, 13094>,
		<13095, 13096, 13097>,
		<13098, 13099, 13100>,
		<13101, 13102, 13103>,
		<13104, 13105, 13106>,
		<13107, 13108, 13109>,
		<13110, 13111, 13112>,
		<13113, 13114, 13115>,
		<13116, 13117, 13118>,
		<13119, 13120, 13121>,
		<13122, 13123, 13124>,
		<13125, 13126, 13127>,
		<13128, 13129, 13130>,
		<13131, 13132, 13133>,
		<13134, 13135, 13136>,
		<13137, 13138, 13139>,
		<13140, 13141, 13142>,
		<13143, 13144, 13145>,
		<13146, 13147, 13148>,
		<13149, 13150, 13151>,
		<13152, 13153, 13154>,
		<13155, 13156, 13157>,
		<13158, 13159, 13160>,
		<13161, 13162, 13163>,
		<13164, 13165, 13166>,
		<13167, 13168, 13169>,
		<13170, 13171, 13172>,
		<13173, 13174, 13175>,
		<13176, 13177, 13178>,
		<13179, 13180, 13181>,
		<13182, 13183, 13184>,
		<13185, 13186, 13187>,
		<13188, 13189, 13190>,
		<13191, 13192, 13193>,
		<13194, 13195, 13196>,
		<13197, 13198, 13199>,
		<13200, 13201, 13202>,
		<13203, 13204, 13205>,
		<13206, 13207, 13208>,
		<13209, 13210, 13211>,
		<13212, 13213, 13214>,
		<13215, 13216, 13217>,
		<13218, 13219, 13220>,
		<13221, 13222, 13223>,
		<13224, 13225, 13226>,
		<13227, 13228, 13229>,
		<13230, 13231, 13232>,
		<13233, 13234, 13235>,
		<13236, 13237, 13238>,
		<13239, 13240, 13241>,
		<13242, 13243, 13244>,
		<13245, 13246, 13247>,
		<13248, 13249, 13250>,
		<13251, 13252, 13253>,
		<13254, 13255, 13256>,
		<13257, 13258, 13259>,
		<13260, 13261, 13262>,
		<13263, 13264, 13265>,
		<13266, 13267, 13268>,
		<13269, 13270, 13271>,
		<13272, 13273, 13274>,
		<13275, 13276, 13277>,
		<13278, 13279, 13280>,
		<13281, 13282, 13283>,
		<13284, 13285, 13286>,
		<13287, 13288, 13289>,
		<13290, 13291, 13292>,
		<13293, 13294, 13295>,
		<13296, 13297, 13298>,
		<13299, 13300, 13301>,
		<13302, 13303, 13304>,
		<13305, 13306, 13307>,
		<13308, 13309, 13310>,
		<13311, 13312, 13313>,
		<13314, 13315, 13316>,
		<13317, 13318, 13319>,
		<13320, 13321, 13322>,
		<13323, 13324, 13325>,
		<13326, 13327, 13328>,
		<13329, 13330, 13331>,
		<13332, 13333, 13334>,
		<13335, 13336, 13337>,
		<13338, 13339, 13340>,
		<13341, 13342, 13343>,
		<13344, 13345, 13346>,
		<13347, 13348, 13349>,
		<13350, 13351, 13352>,
		<13353, 13354, 13355>,
		<13356, 13357, 13358>,
		<13359, 13360, 13361>,
		<13362, 13363, 13364>,
		<13365, 13366, 13367>,
		<13368, 13369, 13370>,
		<13371, 13372, 13373>,
		<13374, 13375, 13376>,
		<13377, 13378, 13379>,
		<13380, 13381, 13382>,
		<13383, 13384, 13385>,
		<13386, 13387, 13388>,
		<13389, 13390, 13391>,
		<13392, 13393, 13394>,
		<13395, 13396, 13397>,
		<13398, 13399, 13400>,
		<13401, 13402, 13403>,
		<13404, 13405, 13406>,
		<13407, 13408, 13409>,
		<13410, 13411, 13412>,
		<13413, 13414, 13415>,
		<13416, 13417, 13418>,
		<13419, 13420, 13421>,
		<13422, 13423, 13424>,
		<13425, 13426, 13427>,
		<13428, 13429, 13430>,
		<13431, 13432, 13433>,
		<13434, 13435, 13436>,
		<13437, 13438, 13439>,
		<13440, 13441, 13442>,
		<13443, 13444, 13445>,
		<13446, 13447, 13448>,
		<13449, 13450, 13451>,
		<13452, 13453, 13454>,
		<13455, 13456, 13457>,
		<13458, 13459, 13460>,
		<13461, 13462, 13463>,
		<13464, 13465, 13466>,
		<13467, 13468, 13469>,
		<13470, 13471, 13472>,
		<13473, 13474, 13475>,
		<13476, 13477, 13478>,
		<13479, 13480, 13481>,
		<13482, 13483, 13484>,
		<13485, 13486, 13487>,
		<13488, 13489, 13490>,
		<13491, 13492, 13493>,
		<13494, 13495, 13496>,
		<13497, 13498, 13499>,
		<13500, 13501, 13502>,
		<13503, 13504, 13505>,
		<13506, 13507, 13508>,
		<13509, 13510, 13511>,
		<13512, 13513, 13514>,
		<13515, 13516, 13517>,
		<13518, 13519, 13520>,
		<13521, 13522, 13523>,
		<13524, 13525, 13526>,
		<13527, 13528, 13529>,
		<13530, 13531, 13532>,
		<13533, 13534, 13535>,
		<13536, 13537, 13538>,
		<13539, 13540, 13541>,
		<13542, 13543, 13544>,
		<13545, 13546, 13547>,
		<13548, 13549, 13550>,
		<13551, 13552, 13553>,
		<13554, 13555, 13556>,
		<13557, 13558, 13559>,
		<13560, 13561, 13562>,
		<13563, 13564, 13565>,
		<13566, 13567, 13568>,
		<13569, 13570, 13571>,
		<13572, 13573, 13574>,
		<13575, 13576, 13577>,
		<13578, 13579, 13580>,
		<13581, 13582, 13583>,
		<13584, 13585, 13586>,
		<13587, 13588, 13589>,
		<13590, 13591, 13592>,
		<13593, 13594, 13595>,
		<13596, 13597, 13598>,
		<13599, 13600, 13601>,
		<13602, 13603, 13604>,
		<13605, 13606, 13607>,
		<13608, 13609, 13610>,
		<13611, 13612, 13613>,
		<13614, 13615, 13616>,
		<13617, 13618, 13619>,
		<13620, 13621, 13622>,
		<13623, 13624, 13625>,
		<13626, 13627, 13628>,
		<13629, 13630, 13631>,
		<13632, 13633, 13634>,
		<13635, 13636, 13637>,
		<13638, 13639, 13640>,
		<13641, 13642, 13643>,
		<13644, 13645, 13646>,
		<13647, 13648, 13649>,
		<13650, 13651, 13652>,
		<13653, 13654, 13655>,
		<13656, 13657, 13658>,
		<13659, 13660, 13661>,
		<13662, 13663, 13664>,
		<13665, 13666, 13667>,
		<13668, 13669, 13670>,
		<13671, 13672, 13673>,
		<13674, 13675, 13676>,
		<13677, 13678, 13679>,
		<13680, 13681, 13682>,
		<13683, 13684, 13685>,
		<13686, 13687, 13688>,
		<13689, 13690, 13691>,
		<13692, 13693, 13694>,
		<13695, 13696, 13697>,
		<13698, 13699, 13700>,
		<13701, 13702, 13703>,
		<13704, 13705, 13706>,
		<13707, 13708, 13709>,
		<13710, 13711, 13712>,
		<13713, 13714, 13715>,
		<13716, 13717, 13718>,
		<13719, 13720, 13721>,
		<13722, 13723, 13724>,
		<13725, 13726, 13727>,
		<13728, 13729, 13730>,
		<13731, 13732, 13733>,
		<13734, 13735, 13736>,
		<13737, 13738, 13739>,
		<13740, 13741, 13742>,
		<13743, 13744, 13745>,
		<13746, 13747, 13748>,
		<13749, 13750, 13751>,
		<13752, 13753, 13754>,
		<13755, 13756, 13757>,
		<13758, 13759, 13760>,
		<13761, 13762, 13763>,
		<13764, 13765, 13766>,
		<13767, 13768, 13769>,
		<13770, 13771, 13772>,
		<13773, 13774, 13775>,
		<13776, 13777, 13778>,
		<13779, 13780, 13781>,
		<13782, 13783, 13784>,
		<13785, 13786, 13787>,
		<13788, 13789, 13790>,
		<13791, 13792, 13793>,
		<13794, 13795, 13796>,
		<13797, 13798, 13799>,
		<13800, 13801, 13802>,
		<13803, 13804, 13805>,
		<13806, 13807, 13808>,
		<13809, 13810, 13811>,
		<13812, 13813, 13814>,
		<13815, 13816, 13817>,
		<13818, 13819, 13820>,
		<13821, 13822, 13823>,
		<13824, 13825, 13826>,
		<13827, 13828, 13829>,
		<13830, 13831, 13832>,
		<13833, 13834, 13835>,
		<13836, 13837, 13838>,
		<13839, 13840, 13841>,
		<13842, 13843, 13844>,
		<13845, 13846, 13847>,
		<13848, 13849, 13850>,
		<13851, 13852, 13853>,
		<13854, 13855, 13856>,
		<13857, 13858, 13859>,
		<13860, 13861, 13862>,
		<13863, 13864, 13865>,
		<13866, 13867, 13868>,
		<13869, 13870, 13871>,
		<13872, 13873, 13874>,
		<13875, 13876, 13877>,
		<13878, 13879, 13880>,
		<13881, 13882, 13883>,
		<13884, 13885, 13886>,
		<13887, 13888, 13889>,
		<13890, 13891, 13892>,
		<13893, 13894, 13895>,
		<13896, 13897, 13898>,
		<13899, 13900, 13901>,
		<13902, 13903, 13904>,
		<13905, 13906, 13907>,
		<13908, 13909, 13910>,
		<13911, 13912, 13913>,
		<13914, 13915, 13916>,
		<13917, 13918, 13919>,
		<13920, 13921, 13922>,
		<13923, 13924, 13925>,
		<13926, 13927, 13928>,
		<13929, 13930, 13931>,
		<13932, 13933, 13934>,
		<13935, 13936, 13937>,
		<13938, 13939, 13940>,
		<13941, 13942, 13943>,
		<13944, 13945, 13946>,
		<13947, 13948, 13949>,
		<13950, 13951, 13952>,
		<13953, 13954, 13955>,
		<13956, 13957, 13958>,
		<13959, 13960, 13961>,
		<13962, 13963, 13964>,
		<13965, 13966, 13967>,
		<13968, 13969, 13970>,
		<13971, 13972, 13973>,
		<13974, 13975, 13976>,
		<13977, 13978, 13979>,
		<13980, 13981, 13982>,
		<13983, 13984, 13985>,
		<13986, 13987, 13988>,
		<13989, 13990, 13991>,
		<13992, 13993, 13994>,
		<13995, 13996, 13997>,
		<13998, 13999, 14000>,
		<14001, 14002, 14003>,
		<14004, 14005, 14006>,
		<14007, 14008, 14009>,
		<14010, 14011, 14012>,
		<14013, 14014, 14015>,
		<14016, 14017, 14018>,
		<14019, 14020, 14021>,
		<14022, 14023, 14024>,
		<14025, 14026, 14027>,
		<14028, 14029, 14030>,
		<14031, 14032, 14033>,
		<14034, 14035, 14036>,
		<14037, 14038, 14039>,
		<14040, 14041, 14042>,
		<14043, 14044, 14045>,
		<14046, 14047, 14048>,
		<14049, 14050, 14051>,
		<14052, 14053, 14054>,
		<14055, 14056, 14057>,
		<14058, 14059, 14060>,
		<14061, 14062, 14063>,
		<14064, 14065, 14066>,
		<14067, 14068, 14069>,
		<14070, 14071, 14072>,
		<14073, 14074, 14075>,
		<14076, 14077, 14078>,
		<14079, 14080, 14081>,
		<14082, 14083, 14084>,
		<14085, 14086, 14087>,
		<14088, 14089, 14090>,
		<14091, 14092, 14093>,
		<14094, 14095, 14096>,
		<14097, 14098, 14099>,
		<14100, 14101, 14102>,
		<14103, 14104, 14105>,
		<14106, 14107, 14108>,
		<14109, 14110, 14111>,
		<14112, 14113, 14114>,
		<14115, 14116, 14117>,
		<14118, 14119, 14120>,
		<14121, 14122, 14123>,
		<14124, 14125, 14126>,
		<14127, 14128, 14129>,
		<14130, 14131, 14132>,
		<14133, 14134, 14135>,
		<14136, 14137, 14138>,
		<14139, 14140, 14141>,
		<14142, 14143, 14144>,
		<14145, 14146, 14147>,
		<14148, 14149, 14150>,
		<14151, 14152, 14153>,
		<14154, 14155, 14156>,
		<14157, 14158, 14159>,
		<14160, 14161, 14162>,
		<14163, 14164, 14165>,
		<14166, 14167, 14168>,
		<14169, 14170, 14171>,
		<14172, 14173, 14174>,
		<14175, 14176, 14177>,
		<14178, 14179, 14180>,
		<14181, 14182, 14183>,
		<14184, 14185, 14186>,
		<14187, 14188, 14189>,
		<14190, 14191, 14192>,
		<14193, 14194, 14195>,
		<14196, 14197, 14198>,
		<14199, 14200, 14201>,
		<14202, 14203, 14204>,
		<14205, 14206, 14207>,
		<14208, 14209, 14210>,
		<14211, 14212, 14213>,
		<14214, 14215, 14216>,
		<14217, 14218, 14219>,
		<14220, 14221, 14222>,
		<14223, 14224, 14225>,
		<14226, 14227, 14228>,
		<14229, 14230, 14231>,
		<14232, 14233, 14234>,
		<14235, 14236, 14237>,
		<14238, 14239, 14240>,
		<14241, 14242, 14243>,
		<14244, 14245, 14246>,
		<14247, 14248, 14249>,
		<14250, 14251, 14252>,
		<14253, 14254, 14255>,
		<14256, 14257, 14258>,
		<14259, 14260, 14261>,
		<14262, 14263, 14264>,
		<14265, 14266, 14267>,
		<14268, 14269, 14270>,
		<14271, 14272, 14273>,
		<14274, 14275, 14276>,
		<14277, 14278, 14279>,
		<14280, 14281, 14282>,
		<14283, 14284, 14285>,
		<14286, 14287, 14288>,
		<14289, 14290, 14291>,
		<14292, 14293, 14294>,
		<14295, 14296, 14297>,
		<14298, 14299, 14300>,
		<14301, 14302, 14303>,
		<14304, 14305, 14306>,
		<14307, 14308, 14309>,
		<14310, 14311, 14312>,
		<14313, 14314, 14315>,
		<14316, 14317, 14318>,
		<14319, 14320, 14321>,
		<14322, 14323, 14324>,
		<14325, 14326, 14327>,
		<14328, 14329, 14330>,
		<14331, 14332, 14333>,
		<14334, 14335, 14336>,
		<14337, 14338, 14339>,
		<14340, 14341, 14342>,
		<14343, 14344, 14345>,
		<14346, 14347, 14348>,
		<14349, 14350, 14351>,
		<14352, 14353, 14354>,
		<14355, 14356, 14357>,
		<14358, 14359, 14360>,
		<14361, 14362, 14363>,
		<14364, 14365, 14366>,
		<14367, 14368, 14369>,
		<14370, 14371, 14372>,
		<14373, 14374, 14375>,
		<14376, 14377, 14378>,
		<14379, 14380, 14381>,
		<14382, 14383, 14384>,
		<14385, 14386, 14387>,
		<14388, 14389, 14390>,
		<14391, 14392, 14393>,
		<14394, 14395, 14396>,
		<14397, 14398, 14399>,
		<14400, 14401, 14402>,
		<14403, 14404, 14405>,
		<14406, 14407, 14408>,
		<14409, 14410, 14411>,
		<14412, 14413, 14414>,
		<14415, 14416, 14417>,
		<14418, 14419, 14420>,
		<14421, 14422, 14423>,
		<14424, 14425, 14426>,
		<14427, 14428, 14429>,
		<14430, 14431, 14432>,
		<14433, 14434, 14435>,
		<14436, 14437, 14438>,
		<14439, 14440, 14441>,
		<14442, 14443, 14444>,
		<14445, 14446, 14447>,
		<14448, 14449, 14450>,
		<14451, 14452, 14453>,
		<14454, 14455, 14456>,
		<14457, 14458, 14459>,
		<14460, 14461, 14462>,
		<14463, 14464, 14465>,
		<14466, 14467, 14468>,
		<14469, 14470, 14471>,
		<14472, 14473, 14474>,
		<14475, 14476, 14477>,
		<14478, 14479, 14480>,
		<14481, 14482, 14483>,
		<14484, 14485, 14486>,
		<14487, 14488, 14489>,
		<14490, 14491, 14492>,
		<14493, 14494, 14495>,
		<14496, 14497, 14498>,
		<14499, 14500, 14501>,
		<14502, 14503, 14504>,
		<14505, 14506, 14507>,
		<14508, 14509, 14510>,
		<14511, 14512, 14513>,
		<14514, 14515, 14516>,
		<14517, 14518, 14519>,
		<14520, 14521, 14522>,
		<14523, 14524, 14525>,
		<14526, 14527, 14528>,
		<14529, 14530, 14531>,
		<14532, 14533, 14534>,
		<14535, 14536, 14537>,
		<14538, 14539, 14540>,
		<14541, 14542, 14543>,
		<14544, 14545, 14546>,
		<14547, 14548, 14549>,
		<14550, 14551, 14552>,
		<14553, 14554, 14555>,
		<14556, 14557, 14558>,
		<14559, 14560, 14561>,
		<14562, 14563, 14564>,
		<14565, 14566, 14567>,
		<14568, 14569, 14570>,
		<14571, 14572, 14573>,
		<14574, 14575, 14576>,
		<14577, 14578, 14579>,
		<14580, 14581, 14582>,
		<14583, 14584, 14585>,
		<14586, 14587, 14588>,
		<14589, 14590, 14591>,
		<14592, 14593, 14594>,
		<14595, 14596, 14597>,
		<14598, 14599, 14600>,
		<14601, 14602, 14603>,
		<14604, 14605, 14606>,
		<14607, 14608, 14609>,
		<14610, 14611, 14612>,
		<14613, 14614, 14615>,
		<14616, 14617, 14618>,
		<14619, 14620, 14621>,
		<14622, 14623, 14624>,
		<14625, 14626, 14627>,
		<14628, 14629, 14630>,
		<14631, 14632, 14633>,
		<14634, 14635, 14636>,
		<14637, 14638, 14639>,
		<14640, 14641, 14642>,
		<14643, 14644, 14645>,
		<14646, 14647, 14648>,
		<14649, 14650, 14651>,
		<14652, 14653, 14654>,
		<14655, 14656, 14657>,
		<14658, 14659, 14660>,
		<14661, 14662, 14663>,
		<14664, 14665, 14666>,
		<14667, 14668, 14669>,
		<14670, 14671, 14672>,
		<14673, 14674, 14675>,
		<14676, 14677, 14678>,
		<14679, 14680, 14681>,
		<14682, 14683, 14684>,
		<14685, 14686, 14687>,
		<14688, 14689, 14690>,
		<14691, 14692, 14693>,
		<14694, 14695, 14696>,
		<14697, 14698, 14699>,
		<14700, 14701, 14702>,
		<14703, 14704, 14705>,
		<14706, 14707, 14708>,
		<14709, 14710, 14711>,
		<14712, 14713, 14714>,
		<14715, 14716, 14717>,
		<14718, 14719, 14720>,
		<14721, 14722, 14723>,
		<14724, 14725, 14726>,
		<14727, 14728, 14729>,
		<14730, 14731, 14732>,
		<14733, 14734, 14735>,
		<14736, 14737, 14738>,
		<14739, 14740, 14741>,
		<14742, 14743, 14744>,
		<14745, 14746, 14747>,
		<14748, 14749, 14750>,
		<14751, 14752, 14753>,
		<14754, 14755, 14756>,
		<14757, 14758, 14759>,
		<14760, 14761, 14762>,
		<14763, 14764, 14765>,
		<14766, 14767, 14768>,
		<14769, 14770, 14771>,
		<14772, 14773, 14774>,
		<14775, 14776, 14777>,
		<14778, 14779, 14780>,
		<14781, 14782, 14783>,
		<14784, 14785, 14786>,
		<14787, 14788, 14789>,
		<14790, 14791, 14792>,
		<14793, 14794, 14795>,
		<14796, 14797, 14798>,
		<14799, 14800, 14801>,
		<14802, 14803, 14804>,
		<14805, 14806, 14807>,
		<14808, 14809, 14810>,
		<14811, 14812, 14813>,
		<14814, 14815, 14816>,
		<14817, 14818, 14819>,
		<14820, 14821, 14822>,
		<14823, 14824, 14825>,
		<14826, 14827, 14828>,
		<14829, 14830, 14831>,
		<14832, 14833, 14834>,
		<14835, 14836, 14837>,
		<14838, 14839, 14840>,
		<14841, 14842, 14843>,
		<14844, 14845, 14846>,
		<14847, 14848, 14849>,
		<14850, 14851, 14852>,
		<14853, 14854, 14855>,
		<14856, 14857, 14858>,
		<14859, 14860, 14861>,
		<14862, 14863, 14864>,
		<14865, 14866, 14867>,
		<14868, 14869, 14870>,
		<14871, 14872, 14873>,
		<14874, 14875, 14876>,
		<14877, 14878, 14879>,
		<14880, 14881, 14882>,
		<14883, 14884, 14885>,
		<14886, 14887, 14888>,
		<14889, 14890, 14891>,
		<14892, 14893, 14894>,
		<14895, 14896, 14897>,
		<14898, 14899, 14900>,
		<14901, 14902, 14903>,
		<14904, 14905, 14906>,
		<14907, 14908, 14909>,
		<14910, 14911, 14912>,
		<14913, 14914, 14915>,
		<14916, 14917, 14918>,
		<14919, 14920, 14921>,
		<14922, 14923, 14924>,
		<14925, 14926, 14927>,
		<14928, 14929, 14930>,
		<14931, 14932, 14933>,
		<14934, 14935, 14936>,
		<14937, 14938, 14939>,
		<14940, 14941, 14942>,
		<14943, 14944, 14945>,
		<14946, 14947, 14948>,
		<14949, 14950, 14951>,
		<14952, 14953, 14954>,
		<14955, 14956, 14957>,
		<14958, 14959, 14960>,
		<14961, 14962, 14963>,
		<14964, 14965, 14966>,
		<14967, 14968, 14969>,
		<14970, 14971, 14972>,
		<14973, 14974, 14975>,
		<14976, 14977, 14978>,
		<14979, 14980, 14981>,
		<14982, 14983, 14984>,
		<14985, 14986, 14987>,
		<14988, 14989, 14990>,
		<14991, 14992, 14993>,
		<14994, 14995, 14996>,
		<14997, 14998, 14999>,
		<15000, 15001, 15002>,
		<15003, 15004, 15005>,
		<15006, 15007, 15008>,
		<15009, 15010, 15011>,
		<15012, 15013, 15014>,
		<15015, 15016, 15017>,
		<15018, 15019, 15020>,
		<15021, 15022, 15023>,
		<15024, 15025, 15026>,
		<15027, 15028, 15029>,
		<15030, 15031, 15032>,
		<15033, 15034, 15035>,
		<15036, 15037, 15038>,
		<15039, 15040, 15041>,
		<15042, 15043, 15044>,
		<15045, 15046, 15047>,
		<15048, 15049, 15050>,
		<15051, 15052, 15053>,
		<15054, 15055, 15056>,
		<15057, 15058, 15059>,
		<15060, 15061, 15062>,
		<15063, 15064, 15065>,
		<15066, 15067, 15068>,
		<15069, 15070, 15071>,
		<15072, 15073, 15074>,
		<15075, 15076, 15077>,
		<15078, 15079, 15080>,
		<15081, 15082, 15083>,
		<15084, 15085, 15086>,
		<15087, 15088, 15089>,
		<15090, 15091, 15092>,
		<15093, 15094, 15095>,
		<15096, 15097, 15098>,
		<15099, 15100, 15101>,
		<15102, 15103, 15104>,
		<15105, 15106, 15107>,
		<15108, 15109, 15110>,
		<15111, 15112, 15113>,
		<15114, 15115, 15116>,
		<15117, 15118, 15119>,
		<15120, 15121, 15122>,
		<15123, 15124, 15125>,
		<15126, 15127, 15128>,
		<15129, 15130, 15131>,
		<15132, 15133, 15134>,
		<15135, 15136, 15137>,
		<15138, 15139, 15140>,
		<15141, 15142, 15143>,
		<15144, 15145, 15146>,
		<15147, 15148, 15149>,
		<15150, 15151, 15152>,
		<15153, 15154, 15155>,
		<15156, 15157, 15158>,
		<15159, 15160, 15161>,
		<15162, 15163, 15164>,
		<15165, 15166, 15167>,
		<15168, 15169, 15170>,
		<15171, 15172, 15173>,
		<15174, 15175, 15176>,
		<15177, 15178, 15179>,
		<15180, 15181, 15182>,
		<15183, 15184, 15185>,
		<15186, 15187, 15188>,
		<15189, 15190, 15191>,
		<15192, 15193, 15194>,
		<15195, 15196, 15197>,
		<15198, 15199, 15200>,
		<15201, 15202, 15203>,
		<15204, 15205, 15206>,
		<15207, 15208, 15209>,
		<15210, 15211, 15212>,
		<15213, 15214, 15215>,
		<15216, 15217, 15218>,
		<15219, 15220, 15221>,
		<15222, 15223, 15224>,
		<15225, 15226, 15227>,
		<15228, 15229, 15230>,
		<15231, 15232, 15233>,
		<15234, 15235, 15236>,
		<15237, 15238, 15239>,
		<15240, 15241, 15242>,
		<15243, 15244, 15245>,
		<15246, 15247, 15248>,
		<15249, 15250, 15251>,
		<15252, 15253, 15254>,
		<15255, 15256, 15257>,
		<15258, 15259, 15260>,
		<15261, 15262, 15263>,
		<15264, 15265, 15266>,
		<15267, 15268, 15269>,
		<15270, 15271, 15272>,
		<15273, 15274, 15275>,
		<15276, 15277, 15278>,
		<15279, 15280, 15281>,
		<15282, 15283, 15284>,
		<15285, 15286, 15287>,
		<15288, 15289, 15290>,
		<15291, 15292, 15293>,
		<15294, 15295, 15296>,
		<15297, 15298, 15299>,
		<15300, 15301, 15302>,
		<15303, 15304, 15305>,
		<15306, 15307, 15308>,
		<15309, 15310, 15311>,
		<15312, 15313, 15314>,
		<15315, 15316, 15317>,
		<15318, 15319, 15320>,
		<15321, 15322, 15323>,
		<15324, 15325, 15326>,
		<15327, 15328, 15329>,
		<15330, 15331, 15332>,
		<15333, 15334, 15335>,
		<15336, 15337, 15338>,
		<15339, 15340, 15341>,
		<15342, 15343, 15344>,
		<15345, 15346, 15347>,
		<15348, 15349, 15350>,
		<15351, 15352, 15353>,
		<15354, 15355, 15356>,
		<15357, 15358, 15359>,
		<15360, 15361, 15362>,
		<15363, 15364, 15365>,
		<15366, 15367, 15368>,
		<15369, 15370, 15371>,
		<15372, 15373, 15374>,
		<15375, 15376, 15377>,
		<15378, 15379, 15380>,
		<15381, 15382, 15383>,
		<15384, 15385, 15386>,
		<15387, 15388, 15389>,
		<15390, 15391, 15392>,
		<15393, 15394, 15395>,
		<15396, 15397, 15398>,
		<15399, 15400, 15401>,
		<15402, 15403, 15404>,
		<15405, 15406, 15407>,
		<15408, 15409, 15410>,
		<15411, 15412, 15413>,
		<15414, 15415, 15416>,
		<15417, 15418, 15419>,
		<15420, 15421, 15422>,
		<15423, 15424, 15425>,
		<15426, 15427, 15428>,
		<15429, 15430, 15431>,
		<15432, 15433, 15434>,
		<15435, 15436, 15437>,
		<15438, 15439, 15440>,
		<15441, 15442, 15443>,
		<15444, 15445, 15446>,
		<15447, 15448, 15449>,
		<15450, 15451, 15452>,
		<15453, 15454, 15455>,
		<15456, 15457, 15458>,
		<15459, 15460, 15461>,
		<15462, 15463, 15464>,
		<15465, 15466, 15467>,
		<15468, 15469, 15470>,
		<15471, 15472, 15473>,
		<15474, 15475, 15476>,
		<15477, 15478, 15479>,
		<15480, 15481, 15482>,
		<15483, 15484, 15485>,
		<15486, 15487, 15488>,
		<15489, 15490, 15491>,
		<15492, 15493, 15494>,
		<15495, 15496, 15497>,
		<15498, 15499, 15500>,
		<15501, 15502, 15503>,
		<15504, 15505, 15506>,
		<15507, 15508, 15509>,
		<15510, 15511, 15512>,
		<15513, 15514, 15515>,
		<15516, 15517, 15518>,
		<15519, 15520, 15521>,
		<15522, 15523, 15524>,
		<15525, 15526, 15527>,
		<15528, 15529, 15530>,
		<15531, 15532, 15533>,
		<15534, 15535, 15536>,
		<15537, 15538, 15539>,
		<15540, 15541, 15542>,
		<15543, 15544, 15545>,
		<15546, 15547, 15548>,
		<15549, 15550, 15551>,
		<15552, 15553, 15554>,
		<15555, 15556, 15557>,
		<15558, 15559, 15560>,
		<15561, 15562, 15563>,
		<15564, 15565, 15566>,
		<15567, 15568, 15569>,
		<15570, 15571, 15572>,
		<15573, 15574, 15575>,
		<15576, 15577, 15578>,
		<15579, 15580, 15581>,
		<15582, 15583, 15584>,
		<15585, 15586, 15587>,
		<15588, 15589, 15590>,
		<15591, 15592, 15593>,
		<15594, 15595, 15596>,
		<15597, 15598, 15599>,
		<15600, 15601, 15602>,
		<15603, 15604, 15605>,
		<15606, 15607, 15608>,
		<15609, 15610, 15611>,
		<15612, 15613, 15614>,
		<15615, 15616, 15617>,
		<15618, 15619, 15620>,
		<15621, 15622, 15623>,
		<15624, 15625, 15626>,
		<15627, 15628, 15629>,
		<15630, 15631, 15632>,
		<15633, 15634, 15635>,
		<15636, 15637, 15638>,
		<15639, 15640, 15641>,
		<15642, 15643, 15644>,
		<15645, 15646, 15647>,
		<15648, 15649, 15650>,
		<15651, 15652, 15653>,
		<15654, 15655, 15656>,
		<15657, 15658, 15659>,
		<15660, 15661, 15662>,
		<15663, 15664, 15665>,
		<15666, 15667, 15668>,
		<15669, 15670, 15671>,
		<15672, 15673, 15674>,
		<15675, 15676, 15677>,
		<15678, 15679, 15680>,
		<15681, 15682, 15683>,
		<15684, 15685, 15686>,
		<15687, 15688, 15689>,
		<15690, 15691, 15692>,
		<15693, 15694, 15695>,
		<15696, 15697, 15698>,
		<15699, 15700, 15701>,
		<15702, 15703, 15704>,
		<15705, 15706, 15707>,
		<15708, 15709, 15710>,
		<15711, 15712, 15713>,
		<15714, 15715, 15716>,
		<15717, 15718, 15719>,
		<15720, 15721, 15722>,
		<15723, 15724, 15725>,
		<15726, 15727, 15728>,
		<15729, 15730, 15731>,
		<15732, 15733, 15734>,
		<15735, 15736, 15737>,
		<15738, 15739, 15740>,
		<15741, 15742, 15743>,
		<15744, 15745, 15746>,
		<15747, 15748, 15749>,
		<15750, 15751, 15752>,
		<15753, 15754, 15755>,
		<15756, 15757, 15758>,
		<15759, 15760, 15761>,
		<15762, 15763, 15764>,
		<15765, 15766, 15767>,
		<15768, 15769, 15770>,
		<15771, 15772, 15773>,
		<15774, 15775, 15776>,
		<15777, 15778, 15779>,
		<15780, 15781, 15782>,
		<15783, 15784, 15785>,
		<15786, 15787, 15788>,
		<15789, 15790, 15791>,
		<15792, 15793, 15794>,
		<15795, 15796, 15797>,
		<15798, 15799, 15800>,
		<15801, 15802, 15803>,
		<15804, 15805, 15806>,
		<15807, 15808, 15809>,
		<15810, 15811, 15812>,
		<15813, 15814, 15815>,
		<15816, 15817, 15818>,
		<15819, 15820, 15821>,
		<15822, 15823, 15824>,
		<15825, 15826, 15827>,
		<15828, 15829, 15830>,
		<15831, 15832, 15833>,
		<15834, 15835, 15836>,
		<15837, 15838, 15839>,
		<15840, 15841, 15842>,
		<15843, 15844, 15845>,
		<15846, 15847, 15848>,
		<15849, 15850, 15851>,
		<15852, 15853, 15854>,
		<15855, 15856, 15857>,
		<15858, 15859, 15860>,
		<15861, 15862, 15863>,
		<15864, 15865, 15866>,
		<15867, 15868, 15869>,
		<15870, 15871, 15872>,
		<15873, 15874, 15875>,
		<15876, 15877, 15878>,
		<15879, 15880, 15881>,
		<15882, 15883, 15884>,
		<15885, 15886, 15887>,
		<15888, 15889, 15890>,
		<15891, 15892, 15893>,
		<15894, 15895, 15896>,
		<15897, 15898, 15899>,
		<15900, 15901, 15902>,
		<15903, 15904, 15905>,
		<15906, 15907, 15908>,
		<15909, 15910, 15911>,
		<15912, 15913, 15914>,
		<15915, 15916, 15917>,
		<15918, 15919, 15920>,
		<15921, 15922, 15923>,
		<15924, 15925, 15926>,
		<15927, 15928, 15929>,
		<15930, 15931, 15932>,
		<15933, 15934, 15935>,
		<15936, 15937, 15938>,
		<15939, 15940, 15941>,
		<15942, 15943, 15944>,
		<15945, 15946, 15947>,
		<15948, 15949, 15950>,
		<15951, 15952, 15953>,
		<15954, 15955, 15956>,
		<15957, 15958, 15959>,
		<15960, 15961, 15962>,
		<15963, 15964, 15965>,
		<15966, 15967, 15968>,
		<15969, 15970, 15971>,
		<15972, 15973, 15974>,
		<15975, 15976, 15977>,
		<15978, 15979, 15980>,
		<15981, 15982, 15983>,
		<15984, 15985, 15986>,
		<15987, 15988, 15989>,
		<15990, 15991, 15992>,
		<15993, 15994, 15995>,
		<15996, 15997, 15998>,
		<15999, 16000, 16001>,
		<16002, 16003, 16004>,
		<16005, 16006, 16007>,
		<16008, 16009, 16010>,
		<16011, 16012, 16013>,
		<16014, 16015, 16016>,
		<16017, 16018, 16019>,
		<16020, 16021, 16022>,
		<16023, 16024, 16025>,
		<16026, 16027, 16028>,
		<16029, 16030, 16031>,
		<16032, 16033, 16034>,
		<16035, 16036, 16037>,
		<16038, 16039, 16040>,
		<16041, 16042, 16043>,
		<16044, 16045, 16046>,
		<16047, 16048, 16049>,
		<16050, 16051, 16052>,
		<16053, 16054, 16055>,
		<16056, 16057, 16058>,
		<16059, 16060, 16061>,
		<16062, 16063, 16064>,
		<16065, 16066, 16067>,
		<16068, 16069, 16070>,
		<16071, 16072, 16073>,
		<16074, 16075, 16076>,
		<16077, 16078, 16079>,
		<16080, 16081, 16082>,
		<16083, 16084, 16085>,
		<16086, 16087, 16088>,
		<16089, 16090, 16091>,
		<16092, 16093, 16094>,
		<16095, 16096, 16097>,
		<16098, 16099, 16100>,
		<16101, 16102, 16103>,
		<16104, 16105, 16106>,
		<16107, 16108, 16109>,
		<16110, 16111, 16112>,
		<16113, 16114, 16115>,
		<16116, 16117, 16118>,
		<16119, 16120, 16121>,
		<16122, 16123, 16124>,
		<16125, 16126, 16127>,
		<16128, 16129, 16130>,
		<16131, 16132, 16133>,
		<16134, 16135, 16136>,
		<16137, 16138, 16139>,
		<16140, 16141, 16142>,
		<16143, 16144, 16145>,
		<16146, 16147, 16148>,
		<16149, 16150, 16151>,
		<16152, 16153, 16154>,
		<16155, 16156, 16157>,
		<16158, 16159, 16160>,
		<16161, 16162, 16163>,
		<16164, 16165, 16166>,
		<16167, 16168, 16169>,
		<16170, 16171, 16172>,
		<16173, 16174, 16175>,
		<16176, 16177, 16178>,
		<16179, 16180, 16181>,
		<16182, 16183, 16184>,
		<16185, 16186, 16187>,
		<16188, 16189, 16190>,
		<16191, 16192, 16193>,
		<16194, 16195, 16196>,
		<16197, 16198, 16199>,
		<16200, 16201, 16202>,
		<16203, 16204, 16205>,
		<16206, 16207, 16208>,
		<16209, 16210, 16211>,
		<16212, 16213, 16214>,
		<16215, 16216, 16217>,
		<16218, 16219, 16220>,
		<16221, 16222, 16223>,
		<16224, 16225, 16226>,
		<16227, 16228, 16229>,
		<16230, 16231, 16232>,
		<16233, 16234, 16235>,
		<16236, 16237, 16238>,
		<16239, 16240, 16241>,
		<16242, 16243, 16244>,
		<16245, 16246, 16247>,
		<16248, 16249, 16250>,
		<16251, 16252, 16253>,
		<16254, 16255, 16256>,
		<16257, 16258, 16259>,
		<16260, 16261, 16262>,
		<16263, 16264, 16265>,
		<16266, 16267, 16268>,
		<16269, 16270, 16271>,
		<16272, 16273, 16274>,
		<16275, 16276, 16277>,
		<16278, 16279, 16280>,
		<16281, 16282, 16283>,
		<16284, 16285, 16286>,
		<16287, 16288, 16289>,
		<16290, 16291, 16292>,
		<16293, 16294, 16295>,
		<16296, 16297, 16298>,
		<16299, 16300, 16301>,
		<16302, 16303, 16304>,
		<16305, 16306, 16307>,
		<16308, 16309, 16310>,
		<16311, 16312, 16313>,
		<16314, 16315, 16316>,
		<16317, 16318, 16319>,
		<16320, 16321, 16322>,
		<16323, 16324, 16325>,
		<16326, 16327, 16328>,
		<16329, 16330, 16331>,
		<16332, 16333, 16334>,
		<16335, 16336, 16337>,
		<16338, 16339, 16340>,
		<16341, 16342, 16343>,
		<16344, 16345, 16346>,
		<16347, 16348, 16349>,
		<16350, 16351, 16352>,
		<16353, 16354, 16355>,
		<16356, 16357, 16358>,
		<16359, 16360, 16361>,
		<16362, 16363, 16364>,
		<16365, 16366, 16367>,
		<16368, 16369, 16370>,
		<16371, 16372, 16373>,
		<16374, 16375, 16376>,
		<16377, 16378, 16379>,
		<16380, 16381, 16382>,
		<16383, 16384, 16385>,
		<16386, 16387, 16388>,
		<16389, 16390, 16391>,
		<16392, 16393, 16394>,
		<16395, 16396, 16397>,
		<16398, 16399, 16400>,
		<16401, 16402, 16403>,
		<16404, 16405, 16406>,
		<16407, 16408, 16409>,
		<16410, 16411, 16412>,
		<16413, 16414, 16415>,
		<16416, 16417, 16418>,
		<16419, 16420, 16421>,
		<16422, 16423, 16424>,
		<16425, 16426, 16427>,
		<16428, 16429, 16430>,
		<16431, 16432, 16433>,
		<16434, 16435, 16436>,
		<16437, 16438, 16439>,
		<16440, 16441, 16442>,
		<16443, 16444, 16445>,
		<16446, 16447, 16448>,
		<16449, 16450, 16451>,
		<16452, 16453, 16454>,
		<16455, 16456, 16457>,
		<16458, 16459, 16460>,
		<16461, 16462, 16463>,
		<16464, 16465, 16466>,
		<16467, 16468, 16469>,
		<16470, 16471, 16472>,
		<16473, 16474, 16475>,
		<16476, 16477, 16478>,
		<16479, 16480, 16481>,
		<16482, 16483, 16484>,
		<16485, 16486, 16487>,
		<16488, 16489, 16490>,
		<16491, 16492, 16493>,
		<16494, 16495, 16496>,
		<16497, 16498, 16499>,
		<16500, 16501, 16502>,
		<16503, 16504, 16505>,
		<16506, 16507, 16508>,
		<16509, 16510, 16511>,
		<16512, 16513, 16514>,
		<16515, 16516, 16517>,
		<16518, 16519, 16520>,
		<16521, 16522, 16523>,
		<16524, 16525, 16526>,
		<16527, 16528, 16529>,
		<16530, 16531, 16532>,
		<16533, 16534, 16535>,
		<16536, 16537, 16538>,
		<16539, 16540, 16541>,
		<16542, 16543, 16544>,
		<16545, 16546, 16547>,
		<16548, 16549, 16550>,
		<16551, 16552, 16553>,
		<16554, 16555, 16556>,
		<16557, 16558, 16559>,
		<16560, 16561, 16562>,
		<16563, 16564, 16565>,
		<16566, 16567, 16568>,
		<16569, 16570, 16571>,
		<16572, 16573, 16574>,
		<16575, 16576, 16577>,
		<16578, 16579, 16580>,
		<16581, 16582, 16583>,
		<16584, 16585, 16586>,
		<16587, 16588, 16589>,
		<16590, 16591, 16592>,
		<16593, 16594, 16595>,
		<16596, 16597, 16598>,
		<16599, 16600, 16601>,
		<16602, 16603, 16604>,
		<16605, 16606, 16607>,
		<16608, 16609, 16610>,
		<16611, 16612, 16613>,
		<16614, 16615, 16616>,
		<16617, 16618, 16619>,
		<16620, 16621, 16622>,
		<16623, 16624, 16625>,
		<16626, 16627, 16628>,
		<16629, 16630, 16631>,
		<16632, 16633, 16634>,
		<16635, 16636, 16637>,
		<16638, 16639, 16640>,
		<16641, 16642, 16643>,
		<16644, 16645, 16646>,
		<16647, 16648, 16649>,
		<16650, 16651, 16652>,
		<16653, 16654, 16655>,
		<16656, 16657, 16658>,
		<16659, 16660, 16661>,
		<16662, 16663, 16664>,
		<16665, 16666, 16667>,
		<16668, 16669, 16670>,
		<16671, 16672, 16673>,
		<16674, 16675, 16676>,
		<16677, 16678, 16679>,
		<16680, 16681, 16682>,
		<16683, 16684, 16685>,
		<16686, 16687, 16688>,
		<16689, 16690, 16691>,
		<16692, 16693, 16694>,
		<16695, 16696, 16697>,
		<16698, 16699, 16700>,
		<16701, 16702, 16703>,
		<16704, 16705, 16706>,
		<16707, 16708, 16709>,
		<16710, 16711, 16712>,
		<16713, 16714, 16715>,
		<16716, 16717, 16718>,
		<16719, 16720, 16721>,
		<16722, 16723, 16724>,
		<16725, 16726, 16727>,
		<16728, 16729, 16730>,
		<16731, 16732, 16733>,
		<16734, 16735, 16736>,
		<16737, 16738, 16739>,
		<16740, 16741, 16742>,
		<16743, 16744, 16745>,
		<16746, 16747, 16748>,
		<16749, 16750, 16751>,
		<16752, 16753, 16754>,
		<16755, 16756, 16757>,
		<16758, 16759, 16760>,
		<16761, 16762, 16763>,
		<16764, 16765, 16766>,
		<16767, 16768, 16769>,
		<16770, 16771, 16772>,
		<16773, 16774, 16775>,
		<16776, 16777, 16778>,
		<16779, 16780, 16781>,
		<16782, 16783, 16784>,
		<16785, 16786, 16787>,
		<16788, 16789, 16790>,
		<16791, 16792, 16793>,
		<16794, 16795, 16796>,
		<16797, 16798, 16799>,
		<16800, 16801, 16802>,
		<16803, 16804, 16805>,
		<16806, 16807, 16808>,
		<16809, 16810, 16811>,
		<16812, 16813, 16814>,
		<16815, 16816, 16817>,
		<16818, 16819, 16820>,
		<16821, 16822, 16823>,
		<16824, 16825, 16826>,
		<16827, 16828, 16829>,
		<16830, 16831, 16832>,
		<16833, 16834, 16835>,
		<16836, 16837, 16838>,
		<16839, 16840, 16841>,
		<16842, 16843, 16844>,
		<16845, 16846, 16847>,
		<16848, 16849, 16850>,
		<16851, 16852, 16853>,
		<16854, 16855, 16856>,
		<16857, 16858, 16859>,
		<16860, 16861, 16862>,
		<16863, 16864, 16865>,
		<16866, 16867, 16868>,
		<16869, 16870, 16871>,
		<16872, 16873, 16874>,
		<16875, 16876, 16877>,
		<16878, 16879, 16880>,
		<16881, 16882, 16883>,
		<16884, 16885, 16886>,
		<16887, 16888, 16889>,
		<16890, 16891, 16892>,
		<16893, 16894, 16895>,
		<16896, 16897, 16898>,
		<16899, 16900, 16901>,
		<16902, 16903, 16904>,
		<16905, 16906, 16907>,
		<16908, 16909, 16910>,
		<16911, 16912, 16913>,
		<16914, 16915, 16916>,
		<16917, 16918, 16919>,
		<16920, 16921, 16922>,
		<16923, 16924, 16925>,
		<16926, 16927, 16928>,
		<16929, 16930, 16931>,
		<16932, 16933, 16934>,
		<16935, 16936, 16937>,
		<16938, 16939, 16940>,
		<16941, 16942, 16943>,
		<16944, 16945, 16946>,
		<16947, 16948, 16949>,
		<16950, 16951, 16952>,
		<16953, 16954, 16955>,
		<16956, 16957, 16958>,
		<16959, 16960, 16961>,
		<16962, 16963, 16964>,
		<16965, 16966, 16967>,
		<16968, 16969, 16970>,
		<16971, 16972, 16973>,
		<16974, 16975, 16976>,
		<16977, 16978, 16979>,
		<16980, 16981, 16982>,
		<16983, 16984, 16985>,
		<16986, 16987, 16988>,
		<16989, 16990, 16991>,
		<16992, 16993, 16994>,
		<16995, 16996, 16997>,
		<16998, 16999, 17000>,
		<17001, 17002, 17003>,
		<17004, 17005, 17006>,
		<17007, 17008, 17009>,
		<17010, 17011, 17012>,
		<17013, 17014, 17015>,
		<17016, 17017, 17018>,
		<17019, 17020, 17021>,
		<17022, 17023, 17024>,
		<17025, 17026, 17027>,
		<17028, 17029, 17030>,
		<17031, 17032, 17033>,
		<17034, 17035, 17036>,
		<17037, 17038, 17039>,
		<17040, 17041, 17042>,
		<17043, 17044, 17045>,
		<17046, 17047, 17048>,
		<17049, 17050, 17051>,
		<17052, 17053, 17054>,
		<17055, 17056, 17057>,
		<17058, 17059, 17060>,
		<17061, 17062, 17063>,
		<17064, 17065, 17066>,
		<17067, 17068, 17069>,
		<17070, 17071, 17072>,
		<17073, 17074, 17075>,
		<17076, 17077, 17078>,
		<17079, 17080, 17081>,
		<17082, 17083, 17084>,
		<17085, 17086, 17087>,
		<17088, 17089, 17090>,
		<17091, 17092, 17093>,
		<17094, 17095, 17096>,
		<17097, 17098, 17099>,
		<17100, 17101, 17102>,
		<17103, 17104, 17105>,
		<17106, 17107, 17108>,
		<17109, 17110, 17111>,
		<17112, 17113, 17114>,
		<17115, 17116, 17117>,
		<17118, 17119, 17120>,
		<17121, 17122, 17123>,
		<17124, 17125, 17126>,
		<17127, 17128, 17129>,
		<17130, 17131, 17132>,
		<17133, 17134, 17135>,
		<17136, 17137, 17138>,
		<17139, 17140, 17141>,
		<17142, 17143, 17144>,
		<17145, 17146, 17147>,
		<17148, 17149, 17150>,
		<17151, 17152, 17153>,
		<17154, 17155, 17156>,
		<17157, 17158, 17159>,
		<17160, 17161, 17162>,
		<17163, 17164, 17165>,
		<17166, 17167, 17168>,
		<17169, 17170, 17171>,
		<17172, 17173, 17174>,
		<17175, 17176, 17177>,
		<17178, 17179, 17180>,
		<17181, 17182, 17183>,
		<17184, 17185, 17186>,
		<17187, 17188, 17189>,
		<17190, 17191, 17192>,
		<17193, 17194, 17195>,
		<17196, 17197, 17198>,
		<17199, 17200, 17201>,
		<17202, 17203, 17204>,
		<17205, 17206, 17207>,
		<17208, 17209, 17210>,
		<17211, 17212, 17213>,
		<17214, 17215, 17216>,
		<17217, 17218, 17219>,
		<17220, 17221, 17222>,
		<17223, 17224, 17225>,
		<17226, 17227, 17228>,
		<17229, 17230, 17231>,
		<17232, 17233, 17234>,
		<17235, 17236, 17237>,
		<17238, 17239, 17240>,
		<17241, 17242, 17243>,
		<17244, 17245, 17246>,
		<17247, 17248, 17249>,
		<17250, 17251, 17252>,
		<17253, 17254, 17255>,
		<17256, 17257, 17258>,
		<17259, 17260, 17261>,
		<17262, 17263, 17264>,
		<17265, 17266, 17267>,
		<17268, 17269, 17270>,
		<17271, 17272, 17273>,
		<17274, 17275, 17276>,
		<17277, 17278, 17279>,
		<17280, 17281, 17282>,
		<17283, 17284, 17285>,
		<17286, 17287, 17288>,
		<17289, 17290, 17291>,
		<17292, 17293, 17294>,
		<17295, 17296, 17297>,
		<17298, 17299, 17300>,
		<17301, 17302, 17303>,
		<17304, 17305, 17306>,
		<17307, 17308, 17309>,
		<17310, 17311, 17312>,
		<17313, 17314, 17315>,
		<17316, 17317, 17318>,
		<17319, 17320, 17321>,
		<17322, 17323, 17324>,
		<17325, 17326, 17327>,
		<17328, 17329, 17330>,
		<17331, 17332, 17333>,
		<17334, 17335, 17336>,
		<17337, 17338, 17339>,
		<17340, 17341, 17342>,
		<17343, 17344, 17345>,
		<17346, 17347, 17348>,
		<17349, 17350, 17351>,
		<17352, 17353, 17354>,
		<17355, 17356, 17357>,
		<17358, 17359, 17360>,
		<17361, 17362, 17363>,
		<17364, 17365, 17366>,
		<17367, 17368, 17369>,
		<17370, 17371, 17372>,
		<17373, 17374, 17375>,
		<17376, 17377, 17378>,
		<17379, 17380, 17381>,
		<17382, 17383, 17384>,
		<17385, 17386, 17387>,
		<17388, 17389, 17390>,
		<17391, 17392, 17393>,
		<17394, 17395, 17396>,
		<17397, 17398, 17399>,
		<17400, 17401, 17402>,
		<17403, 17404, 17405>,
		<17406, 17407, 17408>,
		<17409, 17410, 17411>,
		<17412, 17413, 17414>,
		<17415, 17416, 17417>,
		<17418, 17419, 17420>,
		<17421, 17422, 17423>,
		<17424, 17425, 17426>,
		<17427, 17428, 17429>,
		<17430, 17431, 17432>,
		<17433, 17434, 17435>,
		<17436, 17437, 17438>,
		<17439, 17440, 17441>,
		<17442, 17443, 17444>,
		<17445, 17446, 17447>,
		<17448, 17449, 17450>,
		<17451, 17452, 17453>,
		<17454, 17455, 17456>,
		<17457, 17458, 17459>,
		<17460, 17461, 17462>,
		<17463, 17464, 17465>,
		<17466, 17467, 17468>,
		<17469, 17470, 17471>,
		<17472, 17473, 17474>,
		<17475, 17476, 17477>,
		<17478, 17479, 17480>,
		<17481, 17482, 17483>,
		<17484, 17485, 17486>,
		<17487, 17488, 17489>,
		<17490, 17491, 17492>,
		<17493, 17494, 17495>,
		<17496, 17497, 17498>,
		<17499, 17500, 17501>,
		<17502, 17503, 17504>,
		<17505, 17506, 17507>,
		<17508, 17509, 17510>,
		<17511, 17512, 17513>,
		<17514, 17515, 17516>,
		<17517, 17518, 17519>,
		<17520, 17521, 17522>,
		<17523, 17524, 17525>,
		<17526, 17527, 17528>,
		<17529, 17530, 17531>,
		<17532, 17533, 17534>,
		<17535, 17536, 17537>,
		<17538, 17539, 17540>,
		<17541, 17542, 17543>,
		<17544, 17545, 17546>,
		<17547, 17548, 17549>,
		<17550, 17551, 17552>,
		<17553, 17554, 17555>,
		<17556, 17557, 17558>,
		<17559, 17560, 17561>,
		<17562, 17563, 17564>,
		<17565, 17566, 17567>,
		<17568, 17569, 17570>,
		<17571, 17572, 17573>,
		<17574, 17575, 17576>,
		<17577, 17578, 17579>,
		<17580, 17581, 17582>,
		<17583, 17584, 17585>,
		<17586, 17587, 17588>,
		<17589, 17590, 17591>,
		<17592, 17593, 17594>,
		<17595, 17596, 17597>,
		<17598, 17599, 17600>,
		<17601, 17602, 17603>,
		<17604, 17605, 17606>,
		<17607, 17608, 17609>,
		<17610, 17611, 17612>,
		<17613, 17614, 17615>,
		<17616, 17617, 17618>,
		<17619, 17620, 17621>,
		<17622, 17623, 17624>,
		<17625, 17626, 17627>,
		<17628, 17629, 17630>,
		<17631, 17632, 17633>,
		<17634, 17635, 17636>,
		<17637, 17638, 17639>,
		<17640, 17641, 17642>,
		<17643, 17644, 17645>,
		<17646, 17647, 17648>,
		<17649, 17650, 17651>,
		<17652, 17653, 17654>,
		<17655, 17656, 17657>,
		<17658, 17659, 17660>,
		<17661, 17662, 17663>,
		<17664, 17665, 17666>,
		<17667, 17668, 17669>,
		<17670, 17671, 17672>,
		<17673, 17674, 17675>,
		<17676, 17677, 17678>,
		<17679, 17680, 17681>,
		<17682, 17683, 17684>,
		<17685, 17686, 17687>,
		<17688, 17689, 17690>,
		<17691, 17692, 17693>,
		<17694, 17695, 17696>,
		<17697, 17698, 17699>,
		<17700, 17701, 17702>,
		<17703, 17704, 17705>,
		<17706, 17707, 17708>,
		<17709, 17710, 17711>,
		<17712, 17713, 17714>,
		<17715, 17716, 17717>,
		<17718, 17719, 17720>,
		<17721, 17722, 17723>,
		<17724, 17725, 17726>,
		<17727, 17728, 17729>,
		<17730, 17731, 17732>,
		<17733, 17734, 17735>,
		<17736, 17737, 17738>,
		<17739, 17740, 17741>,
		<17742, 17743, 17744>,
		<17745, 17746, 17747>,
		<17748, 17749, 17750>,
		<17751, 17752, 17753>,
		<17754, 17755, 17756>,
		<17757, 17758, 17759>,
		<17760, 17761, 17762>,
		<17763, 17764, 17765>,
		<17766, 17767, 17768>,
		<17769, 17770, 17771>,
		<17772, 17773, 17774>,
		<17775, 17776, 17777>,
		<17778, 17779, 17780>,
		<17781, 17782, 17783>,
		<17784, 17785, 17786>,
		<17787, 17788, 17789>,
		<17790, 17791, 17792>,
		<17793, 17794, 17795>,
		<17796, 17797, 17798>,
		<17799, 17800, 17801>,
		<17802, 17803, 17804>,
		<17805, 17806, 17807>,
		<17808, 17809, 17810>,
		<17811, 17812, 17813>,
		<17814, 17815, 17816>,
		<17817, 17818, 17819>,
		<17820, 17821, 17822>,
		<17823, 17824, 17825>,
		<17826, 17827, 17828>,
		<17829, 17830, 17831>,
		<17832, 17833, 17834>,
		<17835, 17836, 17837>,
		<17838, 17839, 17840>,
		<17841, 17842, 17843>,
		<17844, 17845, 17846>,
		<17847, 17848, 17849>,
		<17850, 17851, 17852>,
		<17853, 17854, 17855>,
		<17856, 17857, 17858>,
		<17859, 17860, 17861>,
		<17862, 17863, 17864>,
		<17865, 17866, 17867>,
		<17868, 17869, 17870>,
		<17871, 17872, 17873>,
		<17874, 17875, 17876>,
		<17877, 17878, 17879>,
		<17880, 17881, 17882>,
		<17883, 17884, 17885>,
		<17886, 17887, 17888>,
		<17889, 17890, 17891>,
		<17892, 17893, 17894>,
		<17895, 17896, 17897>,
		<17898, 17899, 17900>,
		<17901, 17902, 17903>,
		<17904, 17905, 17906>,
		<17907, 17908, 17909>,
		<17910, 17911, 17912>,
		<17913, 17914, 17915>,
		<17916, 17917, 17918>,
		<17919, 17920, 17921>,
		<17922, 17923, 17924>,
		<17925, 17926, 17927>,
		<17928, 17929, 17930>,
		<17931, 17932, 17933>,
		<17934, 17935, 17936>,
		<17937, 17938, 17939>,
		<17940, 17941, 17942>,
		<17943, 17944, 17945>,
		<17946, 17947, 17948>,
		<17949, 17950, 17951>,
		<17952, 17953, 17954>,
		<17955, 17956, 17957>,
		<17958, 17959, 17960>,
		<17961, 17962, 17963>,
		<17964, 17965, 17966>,
		<17967, 17968, 17969>,
		<17970, 17971, 17972>,
		<17973, 17974, 17975>,
		<17976, 17977, 17978>,
		<17979, 17980, 17981>,
		<17982, 17983, 17984>,
		<17985, 17986, 17987>,
		<17988, 17989, 17990>,
		<17991, 17992, 17993>,
		<17994, 17995, 17996>,
		<17997, 17998, 17999>,
		<18000, 18001, 18002>,
		<18003, 18004, 18005>,
		<18006, 18007, 18008>,
		<18009, 18010, 18011>,
		<18012, 18013, 18014>,
		<18015, 18016, 18017>,
		<18018, 18019, 18020>,
		<18021, 18022, 18023>,
		<18024, 18025, 18026>,
		<18027, 18028, 18029>,
		<18030, 18031, 18032>,
		<18033, 18034, 18035>,
		<18036, 18037, 18038>,
		<18039, 18040, 18041>,
		<18042, 18043, 18044>,
		<18045, 18046, 18047>,
		<18048, 18049, 18050>,
		<18051, 18052, 18053>,
		<18054, 18055, 18056>,
		<18057, 18058, 18059>,
		<18060, 18061, 18062>,
		<18063, 18064, 18065>,
		<18066, 18067, 18068>,
		<18069, 18070, 18071>,
		<18072, 18073, 18074>,
		<18075, 18076, 18077>,
		<18078, 18079, 18080>,
		<18081, 18082, 18083>,
		<18084, 18085, 18086>,
		<18087, 18088, 18089>,
		<18090, 18091, 18092>,
		<18093, 18094, 18095>,
		<18096, 18097, 18098>,
		<18099, 18100, 18101>,
		<18102, 18103, 18104>,
		<18105, 18106, 18107>,
		<18108, 18109, 18110>,
		<18111, 18112, 18113>,
		<18114, 18115, 18116>,
		<18117, 18118, 18119>,
		<18120, 18121, 18122>,
		<18123, 18124, 18125>,
		<18126, 18127, 18128>,
		<18129, 18130, 18131>,
		<18132, 18133, 18134>,
		<18135, 18136, 18137>,
		<18138, 18139, 18140>,
		<18141, 18142, 18143>,
		<18144, 18145, 18146>,
		<18147, 18148, 18149>,
		<18150, 18151, 18152>,
		<18153, 18154, 18155>,
		<18156, 18157, 18158>,
		<18159, 18160, 18161>,
		<18162, 18163, 18164>,
		<18165, 18166, 18167>,
		<18168, 18169, 18170>,
		<18171, 18172, 18173>,
		<18174, 18175, 18176>,
		<18177, 18178, 18179>,
		<18180, 18181, 18182>,
		<18183, 18184, 18185>,
		<18186, 18187, 18188>,
		<18189, 18190, 18191>,
		<18192, 18193, 18194>,
		<18195, 18196, 18197>,
		<18198, 18199, 18200>,
		<18201, 18202, 18203>,
		<18204, 18205, 18206>,
		<18207, 18208, 18209>,
		<18210, 18211, 18212>,
		<18213, 18214, 18215>,
		<18216, 18217, 18218>,
		<18219, 18220, 18221>,
		<18222, 18223, 18224>,
		<18225, 18226, 18227>,
		<18228, 18229, 18230>,
		<18231, 18232, 18233>,
		<18234, 18235, 18236>,
		<18237, 18238, 18239>,
		<18240, 18241, 18242>,
		<18243, 18244, 18245>,
		<18246, 18247, 18248>,
		<18249, 18250, 18251>,
		<18252, 18253, 18254>,
		<18255, 18256, 18257>,
		<18258, 18259, 18260>,
		<18261, 18262, 18263>,
		<18264, 18265, 18266>,
		<18267, 18268, 18269>,
		<18270, 18271, 18272>,
		<18273, 18274, 18275>,
		<18276, 18277, 18278>,
		<18279, 18280, 18281>,
		<18282, 18283, 18284>,
		<18285, 18286, 18287>,
		<18288, 18289, 18290>,
		<18291, 18292, 18293>,
		<18294, 18295, 18296>,
		<18297, 18298, 18299>,
		<18300, 18301, 18302>,
		<18303, 18304, 18305>,
		<18306, 18307, 18308>,
		<18309, 18310, 18311>,
		<18312, 18313, 18314>,
		<18315, 18316, 18317>,
		<18318, 18319, 18320>,
		<18321, 18322, 18323>,
		<18324, 18325, 18326>,
		<18327, 18328, 18329>,
		<18330, 18331, 18332>,
		<18333, 18334, 18335>,
		<18336, 18337, 18338>,
		<18339, 18340, 18341>,
		<18342, 18343, 18344>,
		<18345, 18346, 18347>,
		<18348, 18349, 18350>,
		<18351, 18352, 18353>,
		<18354, 18355, 18356>,
		<18357, 18358, 18359>,
		<18360, 18361, 18362>,
		<18363, 18364, 18365>,
		<18366, 18367, 18368>,
		<18369, 18370, 18371>,
		<18372, 18373, 18374>,
		<18375, 18376, 18377>,
		<18378, 18379, 18380>,
		<18381, 18382, 18383>,
		<18384, 18385, 18386>,
		<18387, 18388, 18389>,
		<18390, 18391, 18392>,
		<18393, 18394, 18395>,
		<18396, 18397, 18398>,
		<18399, 18400, 18401>,
		<18402, 18403, 18404>,
		<18405, 18406, 18407>,
		<18408, 18409, 18410>,
		<18411, 18412, 18413>,
		<18414, 18415, 18416>,
		<18417, 18418, 18419>,
		<18420, 18421, 18422>,
		<18423, 18424, 18425>,
		<18426, 18427, 18428>,
		<18429, 18430, 18431>,
		<18432, 18433, 18434>,
		<18435, 18436, 18437>,
		<18438, 18439, 18440>,
		<18441, 18442, 18443>,
		<18444, 18445, 18446>,
		<18447, 18448, 18449>,
		<18450, 18451, 18452>,
		<18453, 18454, 18455>,
		<18456, 18457, 18458>,
		<18459, 18460, 18461>,
		<18462, 18463, 18464>,
		<18465, 18466, 18467>,
		<18468, 18469, 18470>,
		<18471, 18472, 18473>,
		<18474, 18475, 18476>,
		<18477, 18478, 18479>,
		<18480, 18481, 18482>,
		<18483, 18484, 18485>,
		<18486, 18487, 18488>,
		<18489, 18490, 18491>,
		<18492, 18493, 18494>,
		<18495, 18496, 18497>,
		<18498, 18499, 18500>,
		<18501, 18502, 18503>,
		<18504, 18505, 18506>,
		<18507, 18508, 18509>,
		<18510, 18511, 18512>,
		<18513, 18514, 18515>,
		<18516, 18517, 18518>,
		<18519, 18520, 18521>,
		<18522, 18523, 18524>,
		<18525, 18526, 18527>,
		<18528, 18529, 18530>,
		<18531, 18532, 18533>,
		<18534, 18535, 18536>,
		<18537, 18538, 18539>,
		<18540, 18541, 18542>,
		<18543, 18544, 18545>,
		<18546, 18547, 18548>,
		<18549, 18550, 18551>,
		<18552, 18553, 18554>,
		<18555, 18556, 18557>,
		<18558, 18559, 18560>,
		<18561, 18562, 18563>,
		<18564, 18565, 18566>,
		<18567, 18568, 18569>,
		<18570, 18571, 18572>,
		<18573, 18574, 18575>,
		<18576, 18577, 18578>,
		<18579, 18580, 18581>,
		<18582, 18583, 18584>,
		<18585, 18586, 18587>,
		<18588, 18589, 18590>,
		<18591, 18592, 18593>,
		<18594, 18595, 18596>,
		<18597, 18598, 18599>,
		<18600, 18601, 18602>,
		<18603, 18604, 18605>,
		<18606, 18607, 18608>,
		<18609, 18610, 18611>,
		<18612, 18613, 18614>,
		<18615, 18616, 18617>,
		<18618, 18619, 18620>,
		<18621, 18622, 18623>,
		<18624, 18625, 18626>,
		<18627, 18628, 18629>,
		<18630, 18631, 18632>,
		<18633, 18634, 18635>,
		<18636, 18637, 18638>,
		<18639, 18640, 18641>,
		<18642, 18643, 18644>,
		<18645, 18646, 18647>,
		<18648, 18649, 18650>,
		<18651, 18652, 18653>,
		<18654, 18655, 18656>,
		<18657, 18658, 18659>,
		<18660, 18661, 18662>,
		<18663, 18664, 18665>,
		<18666, 18667, 18668>,
		<18669, 18670, 18671>,
		<18672, 18673, 18674>,
		<18675, 18676, 18677>,
		<18678, 18679, 18680>,
		<18681, 18682, 18683>,
		<18684, 18685, 18686>,
		<18687, 18688, 18689>,
		<18690, 18691, 18692>,
		<18693, 18694, 18695>,
		<18696, 18697, 18698>,
		<18699, 18700, 18701>,
		<18702, 18703, 18704>,
		<18705, 18706, 18707>,
		<18708, 18709, 18710>,
		<18711, 18712, 18713>,
		<18714, 18715, 18716>,
		<18717, 18718, 18719>,
		<18720, 18721, 18722>,
		<18723, 18724, 18725>,
		<18726, 18727, 18728>,
		<18729, 18730, 18731>,
		<18732, 18733, 18734>,
		<18735, 18736, 18737>,
		<18738, 18739, 18740>,
		<18741, 18742, 18743>,
		<18744, 18745, 18746>,
		<18747, 18748, 18749>,
		<18750, 18751, 18752>,
		<18753, 18754, 18755>,
		<18756, 18757, 18758>,
		<18759, 18760, 18761>,
		<18762, 18763, 18764>,
		<18765, 18766, 18767>,
		<18768, 18769, 18770>,
		<18771, 18772, 18773>,
		<18774, 18775, 18776>,
		<18777, 18778, 18779>,
		<18780, 18781, 18782>,
		<18783, 18784, 18785>,
		<18786, 18787, 18788>,
		<18789, 18790, 18791>,
		<18792, 18793, 18794>,
		<18795, 18796, 18797>,
		<18798, 18799, 18800>,
		<18801, 18802, 18803>,
		<18804, 18805, 18806>,
		<18807, 18808, 18809>,
		<18810, 18811, 18812>,
		<18813, 18814, 18815>,
		<18816, 18817, 18818>,
		<18819, 18820, 18821>,
		<18822, 18823, 18824>,
		<18825, 18826, 18827>,
		<18828, 18829, 18830>,
		<18831, 18832, 18833>,
		<18834, 18835, 18836>,
		<18837, 18838, 18839>,
		<18840, 18841, 18842>,
		<18843, 18844, 18845>,
		<18846, 18847, 18848>,
		<18849, 18850, 18851>,
		<18852, 18853, 18854>,
		<18855, 18856, 18857>,
		<18858, 18859, 18860>,
		<18861, 18862, 18863>,
		<18864, 18865, 18866>,
		<18867, 18868, 18869>,
		<18870, 18871, 18872>,
		<18873, 18874, 18875>,
		<18876, 18877, 18878>,
		<18879, 18880, 18881>,
		<18882, 18883, 18884>,
		<18885, 18886, 18887>,
		<18888, 18889, 18890>,
		<18891, 18892, 18893>,
		<18894, 18895, 18896>,
		<18897, 18898, 18899>,
		<18900, 18901, 18902>,
		<18903, 18904, 18905>,
		<18906, 18907, 18908>,
		<18909, 18910, 18911>,
		<18912, 18913, 18914>,
		<18915, 18916, 18917>,
		<18918, 18919, 18920>,
		<18921, 18922, 18923>,
		<18924, 18925, 18926>,
		<18927, 18928, 18929>,
		<18930, 18931, 18932>,
		<18933, 18934, 18935>,
		<18936, 18937, 18938>,
		<18939, 18940, 18941>,
		<18942, 18943, 18944>,
		<18945, 18946, 18947>,
		<18948, 18949, 18950>,
		<18951, 18952, 18953>,
		<18954, 18955, 18956>,
		<18957, 18958, 18959>,
		<18960, 18961, 18962>,
		<18963, 18964, 18965>,
		<18966, 18967, 18968>,
		<18969, 18970, 18971>,
		<18972, 18973, 18974>,
		<18975, 18976, 18977>,
		<18978, 18979, 18980>,
		<18981, 18982, 18983>,
		<18984, 18985, 18986>,
		<18987, 18988, 18989>,
		<18990, 18991, 18992>,
		<18993, 18994, 18995>,
		<18996, 18997, 18998>,
		<18999, 19000, 19001>,
		<19002, 19003, 19004>,
		<19005, 19006, 19007>,
		<19008, 19009, 19010>,
		<19011, 19012, 19013>,
		<19014, 19015, 19016>,
		<19017, 19018, 19019>,
		<19020, 19021, 19022>,
		<19023, 19024, 19025>,
		<19026, 19027, 19028>,
		<19029, 19030, 19031>,
		<19032, 19033, 19034>,
		<19035, 19036, 19037>,
		<19038, 19039, 19040>,
		<19041, 19042, 19043>,
		<19044, 19045, 19046>,
		<19047, 19048, 19049>,
		<19050, 19051, 19052>,
		<19053, 19054, 19055>,
		<19056, 19057, 19058>,
		<19059, 19060, 19061>,
		<19062, 19063, 19064>,
		<19065, 19066, 19067>,
		<19068, 19069, 19070>,
		<19071, 19072, 19073>,
		<19074, 19075, 19076>,
		<19077, 19078, 19079>,
		<19080, 19081, 19082>,
		<19083, 19084, 19085>,
		<19086, 19087, 19088>,
		<19089, 19090, 19091>,
		<19092, 19093, 19094>,
		<19095, 19096, 19097>,
		<19098, 19099, 19100>,
		<19101, 19102, 19103>,
		<19104, 19105, 19106>,
		<19107, 19108, 19109>,
		<19110, 19111, 19112>,
		<19113, 19114, 19115>,
		<19116, 19117, 19118>,
		<19119, 19120, 19121>,
		<19122, 19123, 19124>,
		<19125, 19126, 19127>,
		<19128, 19129, 19130>,
		<19131, 19132, 19133>,
		<19134, 19135, 19136>,
		<19137, 19138, 19139>,
		<19140, 19141, 19142>,
		<19143, 19144, 19145>,
		<19146, 19147, 19148>,
		<19149, 19150, 19151>,
		<19152, 19153, 19154>,
		<19155, 19156, 19157>,
		<19158, 19159, 19160>,
		<19161, 19162, 19163>,
		<19164, 19165, 19166>,
		<19167, 19168, 19169>,
		<19170, 19171, 19172>,
		<19173, 19174, 19175>,
		<19176, 19177, 19178>,
		<19179, 19180, 19181>,
		<19182, 19183, 19184>,
		<19185, 19186, 19187>,
		<19188, 19189, 19190>,
		<19191, 19192, 19193>,
		<19194, 19195, 19196>,
		<19197, 19198, 19199>,
		<19200, 19201, 19202>,
		<19203, 19204, 19205>,
		<19206, 19207, 19208>,
		<19209, 19210, 19211>,
		<19212, 19213, 19214>,
		<19215, 19216, 19217>,
		<19218, 19219, 19220>,
		<19221, 19222, 19223>,
		<19224, 19225, 19226>,
		<19227, 19228, 19229>,
		<19230, 19231, 19232>,
		<19233, 19234, 19235>,
		<19236, 19237, 19238>,
		<19239, 19240, 19241>,
		<19242, 19243, 19244>,
		<19245, 19246, 19247>,
		<19248, 19249, 19250>,
		<19251, 19252, 19253>,
		<19254, 19255, 19256>,
		<19257, 19258, 19259>,
		<19260, 19261, 19262>,
		<19263, 19264, 19265>,
		<19266, 19267, 19268>,
		<19269, 19270, 19271>,
		<19272, 19273, 19274>,
		<19275, 19276, 19277>,
		<19278, 19279, 19280>,
		<19281, 19282, 19283>,
		<19284, 19285, 19286>,
		<19287, 19288, 19289>,
		<19290, 19291, 19292>,
		<19293, 19294, 19295>,
		<19296, 19297, 19298>,
		<19299, 19300, 19301>,
		<19302, 19303, 19304>,
		<19305, 19306, 19307>,
		<19308, 19309, 19310>,
		<19311, 19312, 19313>,
		<19314, 19315, 19316>,
		<19317, 19318, 19319>,
		<19320, 19321, 19322>,
		<19323, 19324, 19325>,
		<19326, 19327, 19328>,
		<19329, 19330, 19331>,
		<19332, 19333, 19334>,
		<19335, 19336, 19337>,
		<19338, 19339, 19340>,
		<19341, 19342, 19343>,
		<19344, 19345, 19346>,
		<19347, 19348, 19349>,
		<19350, 19351, 19352>,
		<19353, 19354, 19355>,
		<19356, 19357, 19358>,
		<19359, 19360, 19361>,
		<19362, 19363, 19364>,
		<19365, 19366, 19367>,
		<19368, 19369, 19370>,
		<19371, 19372, 19373>,
		<19374, 19375, 19376>,
		<19377, 19378, 19379>,
		<19380, 19381, 19382>,
		<19383, 19384, 19385>,
		<19386, 19387, 19388>,
		<19389, 19390, 19391>,
		<19392, 19393, 19394>,
		<19395, 19396, 19397>,
		<19398, 19399, 19400>,
		<19401, 19402, 19403>,
		<19404, 19405, 19406>,
		<19407, 19408, 19409>,
		<19410, 19411, 19412>,
		<19413, 19414, 19415>,
		<19416, 19417, 19418>,
		<19419, 19420, 19421>,
		<19422, 19423, 19424>,
		<19425, 19426, 19427>,
		<19428, 19429, 19430>,
		<19431, 19432, 19433>,
		<19434, 19435, 19436>,
		<19437, 19438, 19439>,
		<19440, 19441, 19442>,
		<19443, 19444, 19445>,
		<19446, 19447, 19448>,
		<19449, 19450, 19451>,
		<19452, 19453, 19454>,
		<19455, 19456, 19457>,
		<19458, 19459, 19460>,
		<19461, 19462, 19463>,
		<19464, 19465, 19466>,
		<19467, 19468, 19469>,
		<19470, 19471, 19472>,
		<19473, 19474, 19475>,
		<19476, 19477, 19478>,
		<19479, 19480, 19481>,
		<19482, 19483, 19484>,
		<19485, 19486, 19487>,
		<19488, 19489, 19490>,
		<19491, 19492, 19493>,
		<19494, 19495, 19496>,
		<19497, 19498, 19499>,
		<19500, 19501, 19502>,
		<19503, 19504, 19505>,
		<19506, 19507, 19508>,
		<19509, 19510, 19511>,
		<19512, 19513, 19514>,
		<19515, 19516, 19517>,
		<19518, 19519, 19520>,
		<19521, 19522, 19523>,
		<19524, 19525, 19526>,
		<19527, 19528, 19529>,
		<19530, 19531, 19532>,
		<19533, 19534, 19535>,
		<19536, 19537, 19538>,
		<19539, 19540, 19541>,
		<19542, 19543, 19544>,
		<19545, 19546, 19547>,
		<19548, 19549, 19550>,
		<19551, 19552, 19553>,
		<19554, 19555, 19556>,
		<19557, 19558, 19559>,
		<19560, 19561, 19562>,
		<19563, 19564, 19565>,
		<19566, 19567, 19568>,
		<19569, 19570, 19571>,
		<19572, 19573, 19574>,
		<19575, 19576, 19577>,
		<19578, 19579, 19580>,
		<19581, 19582, 19583>,
		<19584, 19585, 19586>,
		<19587, 19588, 19589>,
		<19590, 19591, 19592>,
		<19593, 19594, 19595>,
		<19596, 19597, 19598>,
		<19599, 19600, 19601>,
		<19602, 19603, 19604>,
		<19605, 19606, 19607>,
		<19608, 19609, 19610>,
		<19611, 19612, 19613>,
		<19614, 19615, 19616>,
		<19617, 19618, 19619>,
		<19620, 19621, 19622>,
		<19623, 19624, 19625>,
		<19626, 19627, 19628>,
		<19629, 19630, 19631>,
		<19632, 19633, 19634>,
		<19635, 19636, 19637>,
		<19638, 19639, 19640>,
		<19641, 19642, 19643>,
		<19644, 19645, 19646>,
		<19647, 19648, 19649>,
		<19650, 19651, 19652>,
		<19653, 19654, 19655>,
		<19656, 19657, 19658>,
		<19659, 19660, 19661>,
		<19662, 19663, 19664>,
		<19665, 19666, 19667>,
		<19668, 19669, 19670>,
		<19671, 19672, 19673>,
		<19674, 19675, 19676>,
		<19677, 19678, 19679>,
		<19680, 19681, 19682>,
		<19683, 19684, 19685>,
		<19686, 19687, 19688>,
		<19689, 19690, 19691>,
		<19692, 19693, 19694>,
		<19695, 19696, 19697>,
		<19698, 19699, 19700>,
		<19701, 19702, 19703>,
		<19704, 19705, 19706>,
		<19707, 19708, 19709>,
		<19710, 19711, 19712>,
		<19713, 19714, 19715>,
		<19716, 19717, 19718>,
		<19719, 19720, 19721>,
		<19722, 19723, 19724>,
		<19725, 19726, 19727>,
		<19728, 19729, 19730>,
		<19731, 19732, 19733>,
		<19734, 19735, 19736>,
		<19737, 19738, 19739>,
		<19740, 19741, 19742>,
		<19743, 19744, 19745>,
		<19746, 19747, 19748>,
		<19749, 19750, 19751>,
		<19752, 19753, 19754>,
		<19755, 19756, 19757>,
		<19758, 19759, 19760>,
		<19761, 19762, 19763>,
		<19764, 19765, 19766>,
		<19767, 19768, 19769>,
		<19770, 19771, 19772>,
		<19773, 19774, 19775>,
		<19776, 19777, 19778>,
		<19779, 19780, 19781>,
		<19782, 19783, 19784>,
		<19785, 19786, 19787>,
		<19788, 19789, 19790>,
		<19791, 19792, 19793>,
		<19794, 19795, 19796>,
		<19797, 19798, 19799>,
		<19800, 19801, 19802>,
		<19803, 19804, 19805>,
		<19806, 19807, 19808>,
		<19809, 19810, 19811>,
		<19812, 19813, 19814>,
		<19815, 19816, 19817>,
		<19818, 19819, 19820>,
		<19821, 19822, 19823>,
		<19824, 19825, 19826>,
		<19827, 19828, 19829>,
		<19830, 19831, 19832>,
		<19833, 19834, 19835>,
		<19836, 19837, 19838>,
		<19839, 19840, 19841>,
		<19842, 19843, 19844>,
		<19845, 19846, 19847>,
		<19848, 19849, 19850>,
		<19851, 19852, 19853>,
		<19854, 19855, 19856>,
		<19857, 19858, 19859>,
		<19860, 19861, 19862>,
		<19863, 19864, 19865>,
		<19866, 19867, 19868>,
		<19869, 19870, 19871>,
		<19872, 19873, 19874>,
		<19875, 19876, 19877>,
		<19878, 19879, 19880>,
		<19881, 19882, 19883>,
		<19884, 19885, 19886>,
		<19887, 19888, 19889>,
		<19890, 19891, 19892>,
		<19893, 19894, 19895>,
		<19896, 19897, 19898>,
		<19899, 19900, 19901>,
		<19902, 19903, 19904>,
		<19905, 19906, 19907>,
		<19908, 19909, 19910>,
		<19911, 19912, 19913>,
		<19914, 19915, 19916>,
		<19917, 19918, 19919>,
		<19920, 19921, 19922>,
		<19923, 19924, 19925>,
		<19926, 19927, 19928>,
		<19929, 19930, 19931>,
		<19932, 19933, 19934>,
		<19935, 19936, 19937>,
		<19938, 19939, 19940>,
		<19941, 19942, 19943>,
		<19944, 19945, 19946>,
		<19947, 19948, 19949>,
		<19950, 19951, 19952>,
		<19953, 19954, 19955>,
		<19956, 19957, 19958>,
		<19959, 19960, 19961>,
		<19962, 19963, 19964>,
		<19965, 19966, 19967>,
		<19968, 19969, 19970>,
		<19971, 19972, 19973>,
		<19974, 19975, 19976>,
		<19977, 19978, 19979>,
		<19980, 19981, 19982>,
		<19983, 19984, 19985>,
		<19986, 19987, 19988>,
		<19989, 19990, 19991>,
		<19992, 19993, 19994>,
		<19995, 19996, 19997>,
		<19998, 19999, 20000>,
		<20001, 20002, 20003>,
		<20004, 20005, 20006>,
		<20007, 20008, 20009>,
		<20010, 20011, 20012>,
		<20013, 20014, 20015>,
		<20016, 20017, 20018>,
		<20019, 20020, 20021>,
		<20022, 20023, 20024>,
		<20025, 20026, 20027>,
		<20028, 20029, 20030>,
		<20031, 20032, 20033>,
		<20034, 20035, 20036>,
		<20037, 20038, 20039>,
		<20040, 20041, 20042>,
		<20043, 20044, 20045>,
		<20046, 20047, 20048>,
		<20049, 20050, 20051>,
		<20052, 20053, 20054>,
		<20055, 20056, 20057>,
		<20058, 20059, 20060>,
		<20061, 20062, 20063>,
		<20064, 20065, 20066>,
		<20067, 20068, 20069>,
		<20070, 20071, 20072>,
		<20073, 20074, 20075>,
		<20076, 20077, 20078>,
		<20079, 20080, 20081>,
		<20082, 20083, 20084>,
		<20085, 20086, 20087>,
		<20088, 20089, 20090>,
		<20091, 20092, 20093>,
		<20094, 20095, 20096>,
		<20097, 20098, 20099>,
		<20100, 20101, 20102>,
		<20103, 20104, 20105>,
		<20106, 20107, 20108>,
		<20109, 20110, 20111>,
		<20112, 20113, 20114>,
		<20115, 20116, 20117>,
		<20118, 20119, 20120>,
		<20121, 20122, 20123>,
		<20124, 20125, 20126>,
		<20127, 20128, 20129>,
		<20130, 20131, 20132>,
		<20133, 20134, 20135>,
		<20136, 20137, 20138>,
		<20139, 20140, 20141>,
		<20142, 20143, 20144>,
		<20145, 20146, 20147>,
		<20148, 20149, 20150>,
		<20151, 20152, 20153>,
		<20154, 20155, 20156>,
		<20157, 20158, 20159>,
		<20160, 20161, 20162>,
		<20163, 20164, 20165>,
		<20166, 20167, 20168>,
		<20169, 20170, 20171>,
		<20172, 20173, 20174>,
		<20175, 20176, 20177>,
		<20178, 20179, 20180>,
		<20181, 20182, 20183>,
		<20184, 20185, 20186>,
		<20187, 20188, 20189>,
		<20190, 20191, 20192>,
		<20193, 20194, 20195>,
		<20196, 20197, 20198>,
		<20199, 20200, 20201>,
		<20202, 20203, 20204>,
		<20205, 20206, 20207>,
		<20208, 20209, 20210>,
		<20211, 20212, 20213>,
		<20214, 20215, 20216>,
		<20217, 20218, 20219>,
		<20220, 20221, 20222>,
		<20223, 20224, 20225>,
		<20226, 20227, 20228>,
		<20229, 20230, 20231>,
		<20232, 20233, 20234>,
		<20235, 20236, 20237>,
		<20238, 20239, 20240>,
		<20241, 20242, 20243>,
		<20244, 20245, 20246>,
		<20247, 20248, 20249>,
		<20250, 20251, 20252>,
		<20253, 20254, 20255>,
		<20256, 20257, 20258>,
		<20259, 20260, 20261>,
		<20262, 20263, 20264>,
		<20265, 20266, 20267>,
		<20268, 20269, 20270>,
		<20271, 20272, 20273>,
		<20274, 20275, 20276>,
		<20277, 20278, 20279>,
		<20280, 20281, 20282>,
		<20283, 20284, 20285>,
		<20286, 20287, 20288>,
		<20289, 20290, 20291>,
		<20292, 20293, 20294>,
		<20295, 20296, 20297>,
		<20298, 20299, 20300>,
		<20301, 20302, 20303>,
		<20304, 20305, 20306>,
		<20307, 20308, 20309>,
		<20310, 20311, 20312>,
		<20313, 20314, 20315>,
		<20316, 20317, 20318>,
		<20319, 20320, 20321>,
		<20322, 20323, 20324>,
		<20325, 20326, 20327>,
		<20328, 20329, 20330>,
		<20331, 20332, 20333>,
		<20334, 20335, 20336>,
		<20337, 20338, 20339>,
		<20340, 20341, 20342>,
		<20343, 20344, 20345>,
		<20346, 20347, 20348>,
		<20349, 20350, 20351>,
		<20352, 20353, 20354>,
		<20355, 20356, 20357>,
		<20358, 20359, 20360>,
		<20361, 20362, 20363>,
		<20364, 20365, 20366>,
		<20367, 20368, 20369>,
		<20370, 20371, 20372>,
		<20373, 20374, 20375>,
		<20376, 20377, 20378>,
		<20379, 20380, 20381>,
		<20382, 20383, 20384>,
		<20385, 20386, 20387>,
		<20388, 20389, 20390>,
		<20391, 20392, 20393>,
		<20394, 20395, 20396>,
		<20397, 20398, 20399>,
		<20400, 20401, 20402>,
		<20403, 20404, 20405>,
		<20406, 20407, 20408>,
		<20409, 20410, 20411>,
		<20412, 20413, 20414>,
		<20415, 20416, 20417>,
		<20418, 20419, 20420>,
		<20421, 20422, 20423>,
		<20424, 20425, 20426>,
		<20427, 20428, 20429>,
		<20430, 20431, 20432>,
		<20433, 20434, 20435>,
		<20436, 20437, 20438>,
		<20439, 20440, 20441>,
		<20442, 20443, 20444>,
		<20445, 20446, 20447>,
		<20448, 20449, 20450>,
		<20451, 20452, 20453>,
		<20454, 20455, 20456>,
		<20457, 20458, 20459>,
		<20460, 20461, 20462>,
		<20463, 20464, 20465>,
		<20466, 20467, 20468>,
		<20469, 20470, 20471>,
		<20472, 20473, 20474>,
		<20475, 20476, 20477>,
		<20478, 20479, 20480>,
		<20481, 20482, 20483>,
		<20484, 20485, 20486>,
		<20487, 20488, 20489>,
		<20490, 20491, 20492>,
		<20493, 20494, 20495>,
		<20496, 20497, 20498>,
		<20499, 20500, 20501>,
		<20502, 20503, 20504>,
		<20505, 20506, 20507>,
		<20508, 20509, 20510>,
		<20511, 20512, 20513>,
		<20514, 20515, 20516>,
		<20517, 20518, 20519>,
		<20520, 20521, 20522>,
		<20523, 20524, 20525>,
		<20526, 20527, 20528>,
		<20529, 20530, 20531>,
		<20532, 20533, 20534>,
		<20535, 20536, 20537>,
		<20538, 20539, 20540>,
		<20541, 20542, 20543>,
		<20544, 20545, 20546>,
		<20547, 20548, 20549>,
		<20550, 20551, 20552>,
		<20553, 20554, 20555>,
		<20556, 20557, 20558>,
		<20559, 20560, 20561>,
		<20562, 20563, 20564>,
		<20565, 20566, 20567>,
		<20568, 20569, 20570>,
		<20571, 20572, 20573>,
		<20574, 20575, 20576>,
		<20577, 20578, 20579>,
		<20580, 20581, 20582>,
		<20583, 20584, 20585>,
		<20586, 20587, 20588>,
		<20589, 20590, 20591>,
		<20592, 20593, 20594>,
		<20595, 20596, 20597>,
		<20598, 20599, 20600>,
		<20601, 20602, 20603>,
		<20604, 20605, 20606>,
		<20607, 20608, 20609>,
		<20610, 20611, 20612>,
		<20613, 20614, 20615>,
		<20616, 20617, 20618>,
		<20619, 20620, 20621>,
		<20622, 20623, 20624>,
		<20625, 20626, 20627>,
		<20628, 20629, 20630>,
		<20631, 20632, 20633>,
		<20634, 20635, 20636>,
		<20637, 20638, 20639>,
		<20640, 20641, 20642>,
		<20643, 20644, 20645>,
		<20646, 20647, 20648>,
		<20649, 20650, 20651>,
		<20652, 20653, 20654>,
		<20655, 20656, 20657>,
		<20658, 20659, 20660>,
		<20661, 20662, 20663>,
		<20664, 20665, 20666>,
		<20667, 20668, 20669>,
		<20670, 20671, 20672>,
		<20673, 20674, 20675>,
		<20676, 20677, 20678>,
		<20679, 20680, 20681>,
		<20682, 20683, 20684>,
		<20685, 20686, 20687>,
		<20688, 20689, 20690>,
		<20691, 20692, 20693>,
		<20694, 20695, 20696>,
		<20697, 20698, 20699>,
		<20700, 20701, 20702>,
		<20703, 20704, 20705>,
		<20706, 20707, 20708>,
		<20709, 20710, 20711>,
		<20712, 20713, 20714>,
		<20715, 20716, 20717>,
		<20718, 20719, 20720>,
		<20721, 20722, 20723>,
		<20724, 20725, 20726>,
		<20727, 20728, 20729>,
		<20730, 20731, 20732>,
		<20733, 20734, 20735>,
		<20736, 20737, 20738>,
		<20739, 20740, 20741>,
		<20742, 20743, 20744>,
		<20745, 20746, 20747>,
		<20748, 20749, 20750>,
		<20751, 20752, 20753>,
		<20754, 20755, 20756>,
		<20757, 20758, 20759>,
		<20760, 20761, 20762>,
		<20763, 20764, 20765>,
		<20766, 20767, 20768>,
		<20769, 20770, 20771>,
		<20772, 20773, 20774>,
		<20775, 20776, 20777>,
		<20778, 20779, 20780>,
		<20781, 20782, 20783>,
		<20784, 20785, 20786>,
		<20787, 20788, 20789>,
		<20790, 20791, 20792>,
		<20793, 20794, 20795>,
		<20796, 20797, 20798>,
		<20799, 20800, 20801>,
		<20802, 20803, 20804>,
		<20805, 20806, 20807>,
		<20808, 20809, 20810>,
		<20811, 20812, 20813>,
		<20814, 20815, 20816>,
		<20817, 20818, 20819>,
		<20820, 20821, 20822>,
		<20823, 20824, 20825>,
		<20826, 20827, 20828>,
		<20829, 20830, 20831>,
		<20832, 20833, 20834>,
		<20835, 20836, 20837>,
		<20838, 20839, 20840>,
		<20841, 20842, 20843>,
		<20844, 20845, 20846>,
		<20847, 20848, 20849>,
		<20850, 20851, 20852>,
		<20853, 20854, 20855>,
		<20856, 20857, 20858>,
		<20859, 20860, 20861>,
		<20862, 20863, 20864>,
		<20865, 20866, 20867>,
		<20868, 20869, 20870>,
		<20871, 20872, 20873>,
		<20874, 20875, 20876>,
		<20877, 20878, 20879>,
		<20880, 20881, 20882>,
		<20883, 20884, 20885>,
		<20886, 20887, 20888>,
		<20889, 20890, 20891>,
		<20892, 20893, 20894>,
		<20895, 20896, 20897>,
		<20898, 20899, 20900>,
		<20901, 20902, 20903>,
		<20904, 20905, 20906>,
		<20907, 20908, 20909>,
		<20910, 20911, 20912>,
		<20913, 20914, 20915>,
		<20916, 20917, 20918>,
		<20919, 20920, 20921>,
		<20922, 20923, 20924>,
		<20925, 20926, 20927>,
		<20928, 20929, 20930>,
		<20931, 20932, 20933>,
		<20934, 20935, 20936>,
		<20937, 20938, 20939>,
		<20940, 20941, 20942>,
		<20943, 20944, 20945>,
		<20946, 20947, 20948>,
		<20949, 20950, 20951>,
		<20952, 20953, 20954>,
		<20955, 20956, 20957>,
		<20958, 20959, 20960>,
		<20961, 20962, 20963>,
		<20964, 20965, 20966>,
		<20967, 20968, 20969>,
		<20970, 20971, 20972>,
		<20973, 20974, 20975>,
		<20976, 20977, 20978>,
		<20979, 20980, 20981>,
		<20982, 20983, 20984>,
		<20985, 20986, 20987>,
		<20988, 20989, 20990>,
		<20991, 20992, 20993>,
		<20994, 20995, 20996>,
		<20997, 20998, 20999>,
		<21000, 21001, 21002>,
		<21003, 21004, 21005>,
		<21006, 21007, 21008>,
		<21009, 21010, 21011>,
		<21012, 21013, 21014>,
		<21015, 21016, 21017>,
		<21018, 21019, 21020>,
		<21021, 21022, 21023>,
		<21024, 21025, 21026>,
		<21027, 21028, 21029>,
		<21030, 21031, 21032>,
		<21033, 21034, 21035>,
		<21036, 21037, 21038>,
		<21039, 21040, 21041>,
		<21042, 21043, 21044>,
		<21045, 21046, 21047>,
		<21048, 21049, 21050>,
		<21051, 21052, 21053>,
		<21054, 21055, 21056>,
		<21057, 21058, 21059>,
		<21060, 21061, 21062>,
		<21063, 21064, 21065>,
		<21066, 21067, 21068>,
		<21069, 21070, 21071>,
		<21072, 21073, 21074>,
		<21075, 21076, 21077>,
		<21078, 21079, 21080>,
		<21081, 21082, 21083>,
		<21084, 21085, 21086>,
		<21087, 21088, 21089>,
		<21090, 21091, 21092>,
		<21093, 21094, 21095>,
		<21096, 21097, 21098>,
		<21099, 21100, 21101>,
		<21102, 21103, 21104>,
		<21105, 21106, 21107>,
		<21108, 21109, 21110>,
		<21111, 21112, 21113>,
		<21114, 21115, 21116>,
		<21117, 21118, 21119>,
		<21120, 21121, 21122>,
		<21123, 21124, 21125>,
		<21126, 21127, 21128>,
		<21129, 21130, 21131>,
		<21132, 21133, 21134>,
		<21135, 21136, 21137>,
		<21138, 21139, 21140>,
		<21141, 21142, 21143>,
		<21144, 21145, 21146>,
		<21147, 21148, 21149>,
		<21150, 21151, 21152>,
		<21153, 21154, 21155>,
		<21156, 21157, 21158>,
		<21159, 21160, 21161>,
		<21162, 21163, 21164>,
		<21165, 21166, 21167>,
		<21168, 21169, 21170>,
		<21171, 21172, 21173>,
		<21174, 21175, 21176>,
		<21177, 21178, 21179>,
		<21180, 21181, 21182>,
		<21183, 21184, 21185>,
		<21186, 21187, 21188>,
		<21189, 21190, 21191>,
		<21192, 21193, 21194>,
		<21195, 21196, 21197>,
		<21198, 21199, 21200>,
		<21201, 21202, 21203>,
		<21204, 21205, 21206>,
		<21207, 21208, 21209>,
		<21210, 21211, 21212>,
		<21213, 21214, 21215>,
		<21216, 21217, 21218>,
		<21219, 21220, 21221>,
		<21222, 21223, 21224>,
		<21225, 21226, 21227>,
		<21228, 21229, 21230>,
		<21231, 21232, 21233>,
		<21234, 21235, 21236>,
		<21237, 21238, 21239>,
		<21240, 21241, 21242>,
		<21243, 21244, 21245>,
		<21246, 21247, 21248>,
		<21249, 21250, 21251>,
		<21252, 21253, 21254>,
		<21255, 21256, 21257>,
		<21258, 21259, 21260>,
		<21261, 21262, 21263>,
		<21264, 21265, 21266>,
		<21267, 21268, 21269>,
		<21270, 21271, 21272>,
		<21273, 21274, 21275>,
		<21276, 21277, 21278>,
		<21279, 21280, 21281>,
		<21282, 21283, 21284>,
		<21285, 21286, 21287>,
		<21288, 21289, 21290>,
		<21291, 21292, 21293>,
		<21294, 21295, 21296>,
		<21297, 21298, 21299>,
		<21300, 21301, 21302>,
		<21303, 21304, 21305>,
		<21306, 21307, 21308>,
		<21309, 21310, 21311>,
		<21312, 21313, 21314>,
		<21315, 21316, 21317>,
		<21318, 21319, 21320>,
		<21321, 21322, 21323>,
		<21324, 21325, 21326>,
		<21327, 21328, 21329>,
		<21330, 21331, 21332>,
		<21333, 21334, 21335>,
		<21336, 21337, 21338>,
		<21339, 21340, 21341>,
		<21342, 21343, 21344>,
		<21345, 21346, 21347>,
		<21348, 21349, 21350>,
		<21351, 21352, 21353>,
		<21354, 21355, 21356>,
		<21357, 21358, 21359>,
		<21360, 21361, 21362>,
		<21363, 21364, 21365>,
		<21366, 21367, 21368>,
		<21369, 21370, 21371>,
		<21372, 21373, 21374>,
		<21375, 21376, 21377>,
		<21378, 21379, 21380>,
		<21381, 21382, 21383>,
		<21384, 21385, 21386>,
		<21387, 21388, 21389>,
		<21390, 21391, 21392>,
		<21393, 21394, 21395>,
		<21396, 21397, 21398>,
		<21399, 21400, 21401>,
		<21402, 21403, 21404>,
		<21405, 21406, 21407>,
		<21408, 21409, 21410>,
		<21411, 21412, 21413>,
		<21414, 21415, 21416>,
		<21417, 21418, 21419>,
		<21420, 21421, 21422>,
		<21423, 21424, 21425>,
		<21426, 21427, 21428>,
		<21429, 21430, 21431>,
		<21432, 21433, 21434>,
		<21435, 21436, 21437>,
		<21438, 21439, 21440>,
		<21441, 21442, 21443>,
		<21444, 21445, 21446>,
		<21447, 21448, 21449>,
		<21450, 21451, 21452>,
		<21453, 21454, 21455>,
		<21456, 21457, 21458>,
		<21459, 21460, 21461>,
		<21462, 21463, 21464>,
		<21465, 21466, 21467>,
		<21468, 21469, 21470>,
		<21471, 21472, 21473>,
		<21474, 21475, 21476>,
		<21477, 21478, 21479>,
		<21480, 21481, 21482>,
		<21483, 21484, 21485>,
		<21486, 21487, 21488>,
		<21489, 21490, 21491>,
		<21492, 21493, 21494>,
		<21495, 21496, 21497>,
		<21498, 21499, 21500>,
		<21501, 21502, 21503>,
		<21504, 21505, 21506>,
		<21507, 21508, 21509>,
		<21510, 21511, 21512>,
		<21513, 21514, 21515>,
		<21516, 21517, 21518>,
		<21519, 21520, 21521>,
		<21522, 21523, 21524>,
		<21525, 21526, 21527>,
		<21528, 21529, 21530>,
		<21531, 21532, 21533>,
		<21534, 21535, 21536>,
		<21537, 21538, 21539>,
		<21540, 21541, 21542>,
		<21543, 21544, 21545>,
		<21546, 21547, 21548>,
		<21549, 21550, 21551>,
		<21552, 21553, 21554>,
		<21555, 21556, 21557>,
		<21558, 21559, 21560>,
		<21561, 21562, 21563>,
		<21564, 21565, 21566>,
		<21567, 21568, 21569>,
		<21570, 21571, 21572>,
		<21573, 21574, 21575>,
		<21576, 21577, 21578>,
		<21579, 21580, 21581>,
		<21582, 21583, 21584>,
		<21585, 21586, 21587>,
		<21588, 21589, 21590>,
		<21591, 21592, 21593>,
		<21594, 21595, 21596>,
		<21597, 21598, 21599>,
		<21600, 21601, 21602>,
		<21603, 21604, 21605>,
		<21606, 21607, 21608>,
		<21609, 21610, 21611>,
		<21612, 21613, 21614>,
		<21615, 21616, 21617>,
		<21618, 21619, 21620>,
		<21621, 21622, 21623>,
		<21624, 21625, 21626>,
		<21627, 21628, 21629>,
		<21630, 21631, 21632>,
		<21633, 21634, 21635>,
		<21636, 21637, 21638>,
		<21639, 21640, 21641>,
		<21642, 21643, 21644>,
		<21645, 21646, 21647>,
		<21648, 21649, 21650>,
		<21651, 21652, 21653>,
		<21654, 21655, 21656>,
		<21657, 21658, 21659>,
		<21660, 21661, 21662>,
		<21663, 21664, 21665>,
		<21666, 21667, 21668>,
		<21669, 21670, 21671>,
		<21672, 21673, 21674>,
		<21675, 21676, 21677>,
		<21678, 21679, 21680>,
		<21681, 21682, 21683>,
		<21684, 21685, 21686>,
		<21687, 21688, 21689>,
		<21690, 21691, 21692>,
		<21693, 21694, 21695>,
		<21696, 21697, 21698>,
		<21699, 21700, 21701>,
		<21702, 21703, 21704>,
		<21705, 21706, 21707>,
		<21708, 21709, 21710>,
		<21711, 21712, 21713>,
		<21714, 21715, 21716>,
		<21717, 21718, 21719>,
		<21720, 21721, 21722>,
		<21723, 21724, 21725>,
		<21726, 21727, 21728>,
		<21729, 21730, 21731>,
		<21732, 21733, 21734>,
		<21735, 21736, 21737>,
		<21738, 21739, 21740>,
		<21741, 21742, 21743>,
		<21744, 21745, 21746>,
		<21747, 21748, 21749>,
		<21750, 21751, 21752>,
		<21753, 21754, 21755>,
		<21756, 21757, 21758>,
		<21759, 21760, 21761>,
		<21762, 21763, 21764>,
		<21765, 21766, 21767>,
		<21768, 21769, 21770>,
		<21771, 21772, 21773>,
		<21774, 21775, 21776>,
		<21777, 21778, 21779>,
		<21780, 21781, 21782>,
		<21783, 21784, 21785>,
		<21786, 21787, 21788>,
		<21789, 21790, 21791>,
		<21792, 21793, 21794>,
		<21795, 21796, 21797>,
		<21798, 21799, 21800>,
		<21801, 21802, 21803>,
		<21804, 21805, 21806>,
		<21807, 21808, 21809>,
		<21810, 21811, 21812>,
		<21813, 21814, 21815>,
		<21816, 21817, 21818>,
		<21819, 21820, 21821>,
		<21822, 21823, 21824>,
		<21825, 21826, 21827>,
		<21828, 21829, 21830>,
		<21831, 21832, 21833>,
		<21834, 21835, 21836>,
		<21837, 21838, 21839>,
		<21840, 21841, 21842>,
		<21843, 21844, 21845>,
		<21846, 21847, 21848>,
		<21849, 21850, 21851>,
		<21852, 21853, 21854>,
		<21855, 21856, 21857>,
		<21858, 21859, 21860>,
		<21861, 21862, 21863>,
		<21864, 21865, 21866>,
		<21867, 21868, 21869>,
		<21870, 21871, 21872>,
		<21873, 21874, 21875>,
		<21876, 21877, 21878>,
		<21879, 21880, 21881>,
		<21882, 21883, 21884>,
		<21885, 21886, 21887>,
		<21888, 21889, 21890>,
		<21891, 21892, 21893>,
		<21894, 21895, 21896>,
		<21897, 21898, 21899>,
		<21900, 21901, 21902>,
		<21903, 21904, 21905>,
		<21906, 21907, 21908>,
		<21909, 21910, 21911>,
		<21912, 21913, 21914>,
		<21915, 21916, 21917>,
		<21918, 21919, 21920>,
		<21921, 21922, 21923>,
		<21924, 21925, 21926>,
		<21927, 21928, 21929>,
		<21930, 21931, 21932>,
		<21933, 21934, 21935>,
		<21936, 21937, 21938>,
		<21939, 21940, 21941>,
		<21942, 21943, 21944>,
		<21945, 21946, 21947>,
		<21948, 21949, 21950>,
		<21951, 21952, 21953>,
		<21954, 21955, 21956>,
		<21957, 21958, 21959>,
		<21960, 21961, 21962>,
		<21963, 21964, 21965>,
		<21966, 21967, 21968>,
		<21969, 21970, 21971>,
		<21972, 21973, 21974>,
		<21975, 21976, 21977>,
		<21978, 21979, 21980>,
		<21981, 21982, 21983>,
		<21984, 21985, 21986>,
		<21987, 21988, 21989>,
		<21990, 21991, 21992>,
		<21993, 21994, 21995>,
		<21996, 21997, 21998>,
		<21999, 22000, 22001>,
		<22002, 22003, 22004>,
		<22005, 22006, 22007>,
		<22008, 22009, 22010>,
		<22011, 22012, 22013>,
		<22014, 22015, 22016>,
		<22017, 22018, 22019>,
		<22020, 22021, 22022>,
		<22023, 22024, 22025>,
		<22026, 22027, 22028>,
		<22029, 22030, 22031>,
		<22032, 22033, 22034>,
		<22035, 22036, 22037>,
		<22038, 22039, 22040>,
		<22041, 22042, 22043>,
		<22044, 22045, 22046>,
		<22047, 22048, 22049>,
		<22050, 22051, 22052>,
		<22053, 22054, 22055>,
		<22056, 22057, 22058>,
		<22059, 22060, 22061>,
		<22062, 22063, 22064>,
		<22065, 22066, 22067>,
		<22068, 22069, 22070>,
		<22071, 22072, 22073>,
		<22074, 22075, 22076>,
		<22077, 22078, 22079>,
		<22080, 22081, 22082>,
		<22083, 22084, 22085>,
		<22086, 22087, 22088>,
		<22089, 22090, 22091>,
		<22092, 22093, 22094>,
		<22095, 22096, 22097>,
		<22098, 22099, 22100>,
		<22101, 22102, 22103>,
		<22104, 22105, 22106>,
		<22107, 22108, 22109>,
		<22110, 22111, 22112>,
		<22113, 22114, 22115>,
		<22116, 22117, 22118>,
		<22119, 22120, 22121>,
		<22122, 22123, 22124>,
		<22125, 22126, 22127>,
		<22128, 22129, 22130>,
		<22131, 22132, 22133>,
		<22134, 22135, 22136>,
		<22137, 22138, 22139>,
		<22140, 22141, 22142>,
		<22143, 22144, 22145>,
		<22146, 22147, 22148>,
		<22149, 22150, 22151>,
		<22152, 22153, 22154>,
		<22155, 22156, 22157>,
		<22158, 22159, 22160>,
		<22161, 22162, 22163>,
		<22164, 22165, 22166>,
		<22167, 22168, 22169>,
		<22170, 22171, 22172>,
		<22173, 22174, 22175>,
		<22176, 22177, 22178>,
		<22179, 22180, 22181>,
		<22182, 22183, 22184>,
		<22185, 22186, 22187>,
		<22188, 22189, 22190>,
		<22191, 22192, 22193>,
		<22194, 22195, 22196>,
		<22197, 22198, 22199>,
		<22200, 22201, 22202>,
		<22203, 22204, 22205>,
		<22206, 22207, 22208>,
		<22209, 22210, 22211>,
		<22212, 22213, 22214>,
		<22215, 22216, 22217>,
		<22218, 22219, 22220>,
		<22221, 22222, 22223>,
		<22224, 22225, 22226>,
		<22227, 22228, 22229>,
		<22230, 22231, 22232>,
		<22233, 22234, 22235>,
		<22236, 22237, 22238>,
		<22239, 22240, 22241>,
		<22242, 22243, 22244>,
		<22245, 22246, 22247>,
		<22248, 22249, 22250>,
		<22251, 22252, 22253>,
		<22254, 22255, 22256>,
		<22257, 22258, 22259>,
		<22260, 22261, 22262>,
		<22263, 22264, 22265>,
		<22266, 22267, 22268>,
		<22269, 22270, 22271>,
		<22272, 22273, 22274>,
		<22275, 22276, 22277>,
		<22278, 22279, 22280>,
		<22281, 22282, 22283>,
		<22284, 22285, 22286>,
		<22287, 22288, 22289>,
		<22290, 22291, 22292>,
		<22293, 22294, 22295>,
		<22296, 22297, 22298>,
		<22299, 22300, 22301>,
		<22302, 22303, 22304>,
		<22305, 22306, 22307>,
		<22308, 22309, 22310>,
		<22311, 22312, 22313>,
		<22314, 22315, 22316>,
		<22317, 22318, 22319>,
		<22320, 22321, 22322>,
		<22323, 22324, 22325>,
		<22326, 22327, 22328>,
		<22329, 22330, 22331>,
		<22332, 22333, 22334>,
		<22335, 22336, 22337>,
		<22338, 22339, 22340>,
		<22341, 22342, 22343>,
		<22344, 22345, 22346>,
		<22347, 22348, 22349>,
		<22350, 22351, 22352>,
		<22353, 22354, 22355>,
		<22356, 22357, 22358>,
		<22359, 22360, 22361>,
		<22362, 22363, 22364>,
		<22365, 22366, 22367>,
		<22368, 22369, 22370>,
		<22371, 22372, 22373>,
		<22374, 22375, 22376>,
		<22377, 22378, 22379>,
		<22380, 22381, 22382>,
		<22383, 22384, 22385>,
		<22386, 22387, 22388>,
		<22389, 22390, 22391>,
		<22392, 22393, 22394>,
		<22395, 22396, 22397>,
		<22398, 22399, 22400>,
		<22401, 22402, 22403>,
		<22404, 22405, 22406>,
		<22407, 22408, 22409>,
		<22410, 22411, 22412>,
		<22413, 22414, 22415>,
		<22416, 22417, 22418>,
		<22419, 22420, 22421>,
		<22422, 22423, 22424>,
		<22425, 22426, 22427>,
		<22428, 22429, 22430>,
		<22431, 22432, 22433>,
		<22434, 22435, 22436>,
		<22437, 22438, 22439>,
		<22440, 22441, 22442>,
		<22443, 22444, 22445>,
		<22446, 22447, 22448>,
		<22449, 22450, 22451>,
		<22452, 22453, 22454>,
		<22455, 22456, 22457>,
		<22458, 22459, 22460>,
		<22461, 22462, 22463>,
		<22464, 22465, 22466>,
		<22467, 22468, 22469>,
		<22470, 22471, 22472>,
		<22473, 22474, 22475>,
		<22476, 22477, 22478>,
		<22479, 22480, 22481>,
		<22482, 22483, 22484>,
		<22485, 22486, 22487>,
		<22488, 22489, 22490>,
		<22491, 22492, 22493>,
		<22494, 22495, 22496>,
		<22497, 22498, 22499>,
		<22500, 22501, 22502>,
		<22503, 22504, 22505>,
		<22506, 22507, 22508>,
		<22509, 22510, 22511>,
		<22512, 22513, 22514>,
		<22515, 22516, 22517>,
		<22518, 22519, 22520>,
		<22521, 22522, 22523>,
		<22524, 22525, 22526>,
		<22527, 22528, 22529>,
		<22530, 22531, 22532>,
		<22533, 22534, 22535>,
		<22536, 22537, 22538>,
		<22539, 22540, 22541>,
		<22542, 22543, 22544>,
		<22545, 22546, 22547>,
		<22548, 22549, 22550>,
		<22551, 22552, 22553>,
		<22554, 22555, 22556>,
		<22557, 22558, 22559>,
		<22560, 22561, 22562>,
		<22563, 22564, 22565>,
		<22566, 22567, 22568>,
		<22569, 22570, 22571>,
		<22572, 22573, 22574>,
		<22575, 22576, 22577>,
		<22578, 22579, 22580>,
		<22581, 22582, 22583>,
		<22584, 22585, 22586>,
		<22587, 22588, 22589>,
		<22590, 22591, 22592>,
		<22593, 22594, 22595>,
		<22596, 22597, 22598>,
		<22599, 22600, 22601>,
		<22602, 22603, 22604>,
		<22605, 22606, 22607>,
		<22608, 22609, 22610>,
		<22611, 22612, 22613>,
		<22614, 22615, 22616>,
		<22617, 22618, 22619>,
		<22620, 22621, 22622>,
		<22623, 22624, 22625>,
		<22626, 22627, 22628>,
		<22629, 22630, 22631>,
		<22632, 22633, 22634>,
		<22635, 22636, 22637>,
		<22638, 22639, 22640>,
		<22641, 22642, 22643>,
		<22644, 22645, 22646>,
		<22647, 22648, 22649>,
		<22650, 22651, 22652>,
		<22653, 22654, 22655>,
		<22656, 22657, 22658>,
		<22659, 22660, 22661>,
		<22662, 22663, 22664>,
		<22665, 22666, 22667>,
		<22668, 22669, 22670>,
		<22671, 22672, 22673>,
		<22674, 22675, 22676>,
		<22677, 22678, 22679>,
		<22680, 22681, 22682>,
		<22683, 22684, 22685>,
		<22686, 22687, 22688>,
		<22689, 22690, 22691>,
		<22692, 22693, 22694>,
		<22695, 22696, 22697>,
		<22698, 22699, 22700>,
		<22701, 22702, 22703>,
		<22704, 22705, 22706>,
		<22707, 22708, 22709>,
		<22710, 22711, 22712>,
		<22713, 22714, 22715>,
		<22716, 22717, 22718>,
		<22719, 22720, 22721>,
		<22722, 22723, 22724>,
		<22725, 22726, 22727>,
		<22728, 22729, 22730>,
		<22731, 22732, 22733>,
		<22734, 22735, 22736>,
		<22737, 22738, 22739>,
		<22740, 22741, 22742>,
		<22743, 22744, 22745>,
		<22746, 22747, 22748>,
		<22749, 22750, 22751>,
		<22752, 22753, 22754>,
		<22755, 22756, 22757>,
		<22758, 22759, 22760>,
		<22761, 22762, 22763>,
		<22764, 22765, 22766>,
		<22767, 22768, 22769>,
		<22770, 22771, 22772>,
		<22773, 22774, 22775>,
		<22776, 22777, 22778>,
		<22779, 22780, 22781>,
		<22782, 22783, 22784>,
		<22785, 22786, 22787>,
		<22788, 22789, 22790>,
		<22791, 22792, 22793>,
		<22794, 22795, 22796>,
		<22797, 22798, 22799>,
		<22800, 22801, 22802>,
		<22803, 22804, 22805>,
		<22806, 22807, 22808>,
		<22809, 22810, 22811>,
		<22812, 22813, 22814>,
		<22815, 22816, 22817>,
		<22818, 22819, 22820>,
		<22821, 22822, 22823>,
		<22824, 22825, 22826>,
		<22827, 22828, 22829>,
		<22830, 22831, 22832>,
		<22833, 22834, 22835>,
		<22836, 22837, 22838>,
		<22839, 22840, 22841>,
		<22842, 22843, 22844>,
		<22845, 22846, 22847>,
		<22848, 22849, 22850>,
		<22851, 22852, 22853>,
		<22854, 22855, 22856>,
		<22857, 22858, 22859>,
		<22860, 22861, 22862>,
		<22863, 22864, 22865>,
		<22866, 22867, 22868>,
		<22869, 22870, 22871>,
		<22872, 22873, 22874>,
		<22875, 22876, 22877>,
		<22878, 22879, 22880>,
		<22881, 22882, 22883>,
		<22884, 22885, 22886>,
		<22887, 22888, 22889>,
		<22890, 22891, 22892>,
		<22893, 22894, 22895>,
		<22896, 22897, 22898>,
		<22899, 22900, 22901>,
		<22902, 22903, 22904>,
		<22905, 22906, 22907>,
		<22908, 22909, 22910>,
		<22911, 22912, 22913>,
		<22914, 22915, 22916>,
		<22917, 22918, 22919>,
		<22920, 22921, 22922>,
		<22923, 22924, 22925>,
		<22926, 22927, 22928>,
		<22929, 22930, 22931>,
		<22932, 22933, 22934>,
		<22935, 22936, 22937>,
		<22938, 22939, 22940>,
		<22941, 22942, 22943>,
		<22944, 22945, 22946>,
		<22947, 22948, 22949>,
		<22950, 22951, 22952>,
		<22953, 22954, 22955>,
		<22956, 22957, 22958>,
		<22959, 22960, 22961>,
		<22962, 22963, 22964>,
		<22965, 22966, 22967>,
		<22968, 22969, 22970>,
		<22971, 22972, 22973>,
		<22974, 22975, 22976>,
		<22977, 22978, 22979>,
		<22980, 22981, 22982>,
		<22983, 22984, 22985>,
		<22986, 22987, 22988>,
		<22989, 22990, 22991>,
		<22992, 22993, 22994>,
		<22995, 22996, 22997>,
		<22998, 22999, 23000>,
		<23001, 23002, 23003>,
		<23004, 23005, 23006>,
		<23007, 23008, 23009>,
		<23010, 23011, 23012>,
		<23013, 23014, 23015>,
		<23016, 23017, 23018>,
		<23019, 23020, 23021>,
		<23022, 23023, 23024>,
		<23025, 23026, 23027>,
		<23028, 23029, 23030>,
		<23031, 23032, 23033>,
		<23034, 23035, 23036>,
		<23037, 23038, 23039>,
		<23040, 23041, 23042>,
		<23043, 23044, 23045>,
		<23046, 23047, 23048>,
		<23049, 23050, 23051>,
		<23052, 23053, 23054>,
		<23055, 23056, 23057>,
		<23058, 23059, 23060>,
		<23061, 23062, 23063>,
		<23064, 23065, 23066>,
		<23067, 23068, 23069>,
		<23070, 23071, 23072>,
		<23073, 23074, 23075>,
		<23076, 23077, 23078>,
		<23079, 23080, 23081>,
		<23082, 23083, 23084>,
		<23085, 23086, 23087>,
		<23088, 23089, 23090>,
		<23091, 23092, 23093>,
		<23094, 23095, 23096>,
		<23097, 23098, 23099>,
		<23100, 23101, 23102>,
		<23103, 23104, 23105>,
		<23106, 23107, 23108>,
		<23109, 23110, 23111>,
		<23112, 23113, 23114>,
		<23115, 23116, 23117>,
		<23118, 23119, 23120>,
		<23121, 23122, 23123>,
		<23124, 23125, 23126>,
		<23127, 23128, 23129>,
		<23130, 23131, 23132>,
		<23133, 23134, 23135>,
		<23136, 23137, 23138>,
		<23139, 23140, 23141>,
		<23142, 23143, 23144>,
		<23145, 23146, 23147>,
		<23148, 23149, 23150>,
		<23151, 23152, 23153>,
		<23154, 23155, 23156>,
		<23157, 23158, 23159>,
		<23160, 23161, 23162>,
		<23163, 23164, 23165>,
		<23166, 23167, 23168>,
		<23169, 23170, 23171>,
		<23172, 23173, 23174>,
		<23175, 23176, 23177>,
		<23178, 23179, 23180>,
		<23181, 23182, 23183>,
		<23184, 23185, 23186>,
		<23187, 23188, 23189>,
		<23190, 23191, 23192>,
		<23193, 23194, 23195>,
		<23196, 23197, 23198>,
		<23199, 23200, 23201>,
		<23202, 23203, 23204>,
		<23205, 23206, 23207>,
		<23208, 23209, 23210>,
		<23211, 23212, 23213>,
		<23214, 23215, 23216>,
		<23217, 23218, 23219>,
		<23220, 23221, 23222>,
		<23223, 23224, 23225>,
		<23226, 23227, 23228>,
		<23229, 23230, 23231>,
		<23232, 23233, 23234>,
		<23235, 23236, 23237>,
		<23238, 23239, 23240>,
		<23241, 23242, 23243>,
		<23244, 23245, 23246>,
		<23247, 23248, 23249>,
		<23250, 23251, 23252>,
		<23253, 23254, 23255>,
		<23256, 23257, 23258>,
		<23259, 23260, 23261>,
		<23262, 23263, 23264>,
		<23265, 23266, 23267>,
		<23268, 23269, 23270>,
		<23271, 23272, 23273>,
		<23274, 23275, 23276>,
		<23277, 23278, 23279>,
		<23280, 23281, 23282>,
		<23283, 23284, 23285>,
		<23286, 23287, 23288>,
		<23289, 23290, 23291>,
		<23292, 23293, 23294>,
		<23295, 23296, 23297>,
		<23298, 23299, 23300>,
		<23301, 23302, 23303>,
		<23304, 23305, 23306>,
		<23307, 23308, 23309>,
		<23310, 23311, 23312>,
		<23313, 23314, 23315>,
		<23316, 23317, 23318>,
		<23319, 23320, 23321>,
		<23322, 23323, 23324>,
		<23325, 23326, 23327>,
		<23328, 23329, 23330>,
		<23331, 23332, 23333>,
		<23334, 23335, 23336>,
		<23337, 23338, 23339>,
		<23340, 23341, 23342>,
		<23343, 23344, 23345>,
		<23346, 23347, 23348>,
		<23349, 23350, 23351>,
		<23352, 23353, 23354>,
		<23355, 23356, 23357>,
		<23358, 23359, 23360>,
		<23361, 23362, 23363>,
		<23364, 23365, 23366>,
		<23367, 23368, 23369>,
		<23370, 23371, 23372>,
		<23373, 23374, 23375>,
		<23376, 23377, 23378>,
		<23379, 23380, 23381>,
		<23382, 23383, 23384>,
		<23385, 23386, 23387>,
		<23388, 23389, 23390>,
		<23391, 23392, 23393>,
		<23394, 23395, 23396>,
		<23397, 23398, 23399>,
		<23400, 23401, 23402>,
		<23403, 23404, 23405>,
		<23406, 23407, 23408>,
		<23409, 23410, 23411>,
		<23412, 23413, 23414>,
		<23415, 23416, 23417>,
		<23418, 23419, 23420>,
		<23421, 23422, 23423>,
		<23424, 23425, 23426>,
		<23427, 23428, 23429>,
		<23430, 23431, 23432>,
		<23433, 23434, 23435>,
		<23436, 23437, 23438>,
		<23439, 23440, 23441>,
		<23442, 23443, 23444>,
		<23445, 23446, 23447>,
		<23448, 23449, 23450>,
		<23451, 23452, 23453>,
		<23454, 23455, 23456>,
		<23457, 23458, 23459>,
		<23460, 23461, 23462>,
		<23463, 23464, 23465>,
		<23466, 23467, 23468>,
		<23469, 23470, 23471>,
		<23472, 23473, 23474>,
		<23475, 23476, 23477>,
		<23478, 23479, 23480>,
		<23481, 23482, 23483>,
		<23484, 23485, 23486>,
		<23487, 23488, 23489>,
		<23490, 23491, 23492>,
		<23493, 23494, 23495>,
		<23496, 23497, 23498>,
		<23499, 23500, 23501>,
		<23502, 23503, 23504>,
		<23505, 23506, 23507>,
		<23508, 23509, 23510>,
		<23511, 23512, 23513>,
		<23514, 23515, 23516>,
		<23517, 23518, 23519>,
		<23520, 23521, 23522>,
		<23523, 23524, 23525>,
		<23526, 23527, 23528>,
		<23529, 23530, 23531>,
		<23532, 23533, 23534>,
		<23535, 23536, 23537>,
		<23538, 23539, 23540>,
		<23541, 23542, 23543>,
		<23544, 23545, 23546>,
		<23547, 23548, 23549>,
		<23550, 23551, 23552>,
		<23553, 23554, 23555>,
		<23556, 23557, 23558>,
		<23559, 23560, 23561>,
		<23562, 23563, 23564>,
		<23565, 23566, 23567>,
		<23568, 23569, 23570>,
		<23571, 23572, 23573>,
		<23574, 23575, 23576>,
		<23577, 23578, 23579>,
		<23580, 23581, 23582>,
		<23583, 23584, 23585>,
		<23586, 23587, 23588>,
		<23589, 23590, 23591>,
		<23592, 23593, 23594>,
		<23595, 23596, 23597>,
		<23598, 23599, 23600>,
		<23601, 23602, 23603>,
		<23604, 23605, 23606>,
		<23607, 23608, 23609>,
		<23610, 23611, 23612>,
		<23613, 23614, 23615>,
		<23616, 23617, 23618>,
		<23619, 23620, 23621>,
		<23622, 23623, 23624>,
		<23625, 23626, 23627>,
		<23628, 23629, 23630>,
		<23631, 23632, 23633>,
		<23634, 23635, 23636>,
		<23637, 23638, 23639>,
		<23640, 23641, 23642>,
		<23643, 23644, 23645>,
		<23646, 23647, 23648>,
		<23649, 23650, 23651>,
		<23652, 23653, 23654>,
		<23655, 23656, 23657>,
		<23658, 23659, 23660>,
		<23661, 23662, 23663>,
		<23664, 23665, 23666>,
		<23667, 23668, 23669>,
		<23670, 23671, 23672>,
		<23673, 23674, 23675>,
		<23676, 23677, 23678>,
		<23679, 23680, 23681>,
		<23682, 23683, 23684>,
		<23685, 23686, 23687>,
		<23688, 23689, 23690>,
		<23691, 23692, 23693>,
		<23694, 23695, 23696>,
		<23697, 23698, 23699>,
		<23700, 23701, 23702>,
		<23703, 23704, 23705>,
		<23706, 23707, 23708>,
		<23709, 23710, 23711>,
		<23712, 23713, 23714>,
		<23715, 23716, 23717>,
		<23718, 23719, 23720>,
		<23721, 23722, 23723>,
		<23724, 23725, 23726>,
		<23727, 23728, 23729>,
		<23730, 23731, 23732>,
		<23733, 23734, 23735>,
		<23736, 23737, 23738>,
		<23739, 23740, 23741>,
		<23742, 23743, 23744>,
		<23745, 23746, 23747>,
		<23748, 23749, 23750>,
		<23751, 23752, 23753>,
		<23754, 23755, 23756>,
		<23757, 23758, 23759>,
		<23760, 23761, 23762>,
		<23763, 23764, 23765>,
		<23766, 23767, 23768>,
		<23769, 23770, 23771>,
		<23772, 23773, 23774>,
		<23775, 23776, 23777>,
		<23778, 23779, 23780>,
		<23781, 23782, 23783>,
		<23784, 23785, 23786>,
		<23787, 23788, 23789>,
		<23790, 23791, 23792>,
		<23793, 23794, 23795>,
		<23796, 23797, 23798>,
		<23799, 23800, 23801>,
		<23802, 23803, 23804>,
		<23805, 23806, 23807>,
		<23808, 23809, 23810>,
		<23811, 23812, 23813>,
		<23814, 23815, 23816>,
		<23817, 23818, 23819>,
		<23820, 23821, 23822>,
		<23823, 23824, 23825>,
		<23826, 23827, 23828>,
		<23829, 23830, 23831>,
		<23832, 23833, 23834>,
		<23835, 23836, 23837>,
		<23838, 23839, 23840>,
		<23841, 23842, 23843>,
		<23844, 23845, 23846>,
		<23847, 23848, 23849>,
		<23850, 23851, 23852>,
		<23853, 23854, 23855>,
		<23856, 23857, 23858>,
		<23859, 23860, 23861>,
		<23862, 23863, 23864>,
		<23865, 23866, 23867>,
		<23868, 23869, 23870>,
		<23871, 23872, 23873>,
		<23874, 23875, 23876>,
		<23877, 23878, 23879>,
		<23880, 23881, 23882>,
		<23883, 23884, 23885>,
		<23886, 23887, 23888>,
		<23889, 23890, 23891>,
		<23892, 23893, 23894>,
		<23895, 23896, 23897>,
		<23898, 23899, 23900>,
		<23901, 23902, 23903>,
		<23904, 23905, 23906>,
		<23907, 23908, 23909>,
		<23910, 23911, 23912>,
		<23913, 23914, 23915>,
		<23916, 23917, 23918>,
		<23919, 23920, 23921>,
		<23922, 23923, 23924>,
		<23925, 23926, 23927>,
		<23928, 23929, 23930>,
		<23931, 23932, 23933>,
		<23934, 23935, 23936>,
		<23937, 23938, 23939>,
		<23940, 23941, 23942>,
		<23943, 23944, 23945>,
		<23946, 23947, 23948>,
		<23949, 23950, 23951>,
		<23952, 23953, 23954>,
		<23955, 23956, 23957>,
		<23958, 23959, 23960>,
		<23961, 23962, 23963>,
		<23964, 23965, 23966>,
		<23967, 23968, 23969>,
		<23970, 23971, 23972>,
		<23973, 23974, 23975>,
		<23976, 23977, 23978>,
		<23979, 23980, 23981>,
		<23982, 23983, 23984>,
		<23985, 23986, 23987>,
		<23988, 23989, 23990>,
		<23991, 23992, 23993>,
		<23994, 23995, 23996>,
		<23997, 23998, 23999>,
		<24000, 24001, 24002>,
		<24003, 24004, 24005>,
		<24006, 24007, 24008>,
		<24009, 24010, 24011>,
		<24012, 24013, 24014>,
		<24015, 24016, 24017>,
		<24018, 24019, 24020>,
		<24021, 24022, 24023>,
		<24024, 24025, 24026>,
		<24027, 24028, 24029>,
		<24030, 24031, 24032>,
		<24033, 24034, 24035>,
		<24036, 24037, 24038>,
		<24039, 24040, 24041>,
		<24042, 24043, 24044>,
		<24045, 24046, 24047>,
		<24048, 24049, 24050>,
		<24051, 24052, 24053>,
		<24054, 24055, 24056>,
		<24057, 24058, 24059>,
		<24060, 24061, 24062>,
		<24063, 24064, 24065>,
		<24066, 24067, 24068>,
		<24069, 24070, 24071>,
		<24072, 24073, 24074>,
		<24075, 24076, 24077>,
		<24078, 24079, 24080>,
		<24081, 24082, 24083>,
		<24084, 24085, 24086>,
		<24087, 24088, 24089>,
		<24090, 24091, 24092>,
		<24093, 24094, 24095>,
		<24096, 24097, 24098>,
		<24099, 24100, 24101>,
		<24102, 24103, 24104>,
		<24105, 24106, 24107>,
		<24108, 24109, 24110>,
		<24111, 24112, 24113>,
		<24114, 24115, 24116>,
		<24117, 24118, 24119>,
		<24120, 24121, 24122>,
		<24123, 24124, 24125>,
		<24126, 24127, 24128>,
		<24129, 24130, 24131>,
		<24132, 24133, 24134>,
		<24135, 24136, 24137>,
		<24138, 24139, 24140>,
		<24141, 24142, 24143>,
		<24144, 24145, 24146>,
		<24147, 24148, 24149>,
		<24150, 24151, 24152>,
		<24153, 24154, 24155>,
		<24156, 24157, 24158>,
		<24159, 24160, 24161>,
		<24162, 24163, 24164>,
		<24165, 24166, 24167>,
		<24168, 24169, 24170>,
		<24171, 24172, 24173>,
		<24174, 24175, 24176>,
		<24177, 24178, 24179>,
		<24180, 24181, 24182>,
		<24183, 24184, 24185>,
		<24186, 24187, 24188>,
		<24189, 24190, 24191>
		}
  photons{collect off}
	}

