#include "colors.inc" 
               
global_settings {
  assumed_gamma 2.2
}

camera{location 0 look_at -z rotate 20*z rotate 11*y} 
light_source{5*x color White}
fog{fog_type 1 color rgbt <.3,.3,.8,.7> distance 150}
sphere {
  0, 1
  texture{
    pigment {gradient y
      color_map {
        [0 color <.05, .05, .25>/2]
        [1 color <.3, .2, 1.5>/1.5]
      } translate -.5 scale 1.2
    }                
    finish {diffuse 0  ambient 1}
  } 
  scale 500 hollow 
} 
                      
#declare minx = -70;
#declare maxx =  70;
#declare minz =   0;
#declare maxz = 300;
#declare disp = 2;   
#declare rad = .15;
                        
#declare c1 = <.6,.1,1>;
#declare c2 = <.1,.6,1>;
#declare f  = finish{
  ambient .05 
  diffuse .4 
  specular .3 
  roughness .1
  phong .2 
  phong_size 80
}                                                   
#declare t1 = texture{pigment{color c1} finish{f}}
#declare t2 = texture{pigment{color c2} finish{f}}

// Use these two sphere to quickly test color, finish, lighting etc...
//sphere {-5*z + y, 1 texture{t1}}
//sphere {-5*z - y, 1 texture{t2}}
///*
#declare i = minx;
#while (i < maxx)    
  #declare j = minz;
  #while (j < maxz)
    #declare p = sqrt(sqrt(j/maxz))/2;
    sphere {<i,  disp, -j>, rad texture{t1}}
    sphere {<i, -disp, -j>, rad texture{t2}}
    #declare j = j + 1;
  #end
  #declare i = i + 1;
#end
//*/
