// -*- pov -*-
//----------------------------------------------------------------------------
// minimum.pov --- A mimimalistic blend of typesetting and raytracing
// (c) Bertrand Petit
// Touts droits rservs
//----------------------------------------------------------------------------
// This is the "distilled" version of the scene description file
// where all tests, variants, and speed/quality parameters were
// removed.
//----------------------------------------------------------------------------

#version 3.6;

#include "colors.inc"
#include "textures.inc"

//----------------------------------------------------------------------------
// Configuration
//----------------------------------------------------------------------------

global_settings 
{
  ambient_light 0
  radiosity 
  {
    recursion_limit 1
    adc_bailout 0.01/2
    pretrace_start 0.08
    pretrace_end   0.01
    count 1000
    error_bound 0.02
    nearest_count 15
    low_error_factor 0.05
    brightness 1
    gray_threshold 0.0
    minimum_reuse 0.015
    normal off
    save_file "minimum.rad"
    load_file "minimum.rad"
  }
}

//----------------------------------------------------------------------------
// Camera(s)
//----------------------------------------------------------------------------

camera
{
  up <0,1,0>
  right  <-1,0,0>

  location <0,0,8>
  look_at <0,0,0>
  angle 45
}

//----------------------------------------------------------------------------
// Lighting
//----------------------------------------------------------------------------

light_source
{
  <-4,4,4>
  color rgb 1.3
  area_light
  <2,0,0>,<0,0,2>,40,40
  adaptive 4
  jitter circular orient
}

//----------------------------------------------------------------------------
// Materials
//----------------------------------------------------------------------------

#declare MinimumMat = material
{
  texture 
  { 
    pigment { White } 
    normal 
    {
      agate 0.08
      agate_turb 0.5
      scale <0.05,0.05,0.05>
    }
  }
}

//----------------------------------------------------------------------------
// Environement
//----------------------------------------------------------------------------

plane 
{ 
  <0,0,1>, 0
  material { MinimumMat }
}

sphere 
{     
  <0,0,0>, 150
  uv_mapping 
  pigment
  {
    image_map { jpeg "railroad-tracks-35.4.jpg" }
  }
  hollow
}

//----------------------------------------------------------------------------
// Main matter objects
//----------------------------------------------------------------------------

#local MinimumBase = text
{
  ttf "bubbleboy/Bubbleboy-mod.ttf" "MINIMUM"
  0.2,0
}
object
{
  MinimumBase
  translate <max_extent(MinimumBase).x/-2,0,0>
  material { MinimumMat }
}

//----------------------------------------------------------------------------
// Here ends the minimum.pov file.
//----------------------------------------------------------------------------
