//=====================================
//   cellule de moine
//
//   pour le topic "Minimalism"
//   IRTC - Aot 2005
//
//   Hlne - Juillet 2005
//====================================

// la base du script provient du
// tutorial POV 3.6
// o de la lumire tait matrialise
// dans son passage  travers d'une ouverture
//
// par contre, les coordonnes taient inverses
// ce qui n'a pas facilit le placement des objets

// ---  Includes de base

#include "colors.inc"
#include "couleurs.inc"
#include "textures.inc"
#include "stones.inc" 
#include "woods.inc"
#include "skies.inc"

// --- Includes des objets

#include "table.inc" // object table_pot
#include "lit.inc"
#include "bougeoir.inc"
#include "tabouret2.inc" // Letabouret 


global_settings { max_trace_level 15}

//global_settings { ambient_light }

// C'est la radiosit qui ralise l'clairage
// de la scne, avec un ambient sur les murs
// le temps de rendu en est rallong d'autant...


global_settings {
  radiosity {
    pretrace_start 0.08
    pretrace_end 0.04
    count 35
    
    nearest_count 5
    error_bound 1.8
    recursion_limit 3
    low_error_factor 0.5
    gray_threshold 0.0
    minimum_reuse 0.015
    brightness 0.55
    
    adc_bailout 0.01
  }
}
    




//*********************************
//   la camra
// a veut dire quoi look_at -z ?
//*********************************

camera
{
  location <14.9,1,-8>
  look_at -z
  angle 70
}

//*************************************
// La lumire
// la seconde light_source a t
// te au bnfice de la radiosit
// elle donnait des ombres trop normes
//*************************************

light_source
{
  <10,100,150>,1
}


sky_sphere
{ 
pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 SkyBlue * 0.2 ]
        [0.50 SteelBlue ]
        [1.00 Gray70 ]
    }
    scale <0.5, 0.15, 1>
}
}     





//=======================================
// la piece
//
// bon, c'est pas moi qui l'ai faite
// sinon je n'aurais pas mis des
// coordonnes aussi tordues !!
//=======================================

union
{
  difference
  {
    box
    {
      <-11,-7,-11>, <16,7,10.5>
    }
    box
    {
      <-10,-6,-10>, <15,6,10>
    }
    box
    {
      <-4,-2,9.9>, <2,3,10.6>
    }
  }
  box
  {
    <-1.25,-2,10>, <-0.75,3,10.5>
  }
  box
  {
    <-4,0.25,10>, <2,0.75,10.5>
  }
  
  pigment {Wheat*2}
  normal {granite 0.1}
  finish {ambient 0.12}
}

//==================================
//   la fentre
//==================================

// scattering media box

box
{
  <-5,-6.5,-10.5>, <3,6.5,10.25>
  pigment {rgbt 1}
  hollow
  
  interior
  {
    media
    {
      scattering
      {
        1,0.07 extinction 0.01
      }
      samples 30,100
      
    }
  }
}

//=========================
//  floor
//=========================

box
{
  <-10,-5.99,-10>, <15,-6,10>
  pigment {Wheat*2}
  
}
  
 
  
//**********************************
//	Les pavs du floor
//**********************************

#declare pave =
superellipsoid
{ 
        <.50, .10>
	scale 0.3
                
} 
#declare sol =
union
        {     
#declare I=-60;
 #while (I < 50)
  #declare J=0;
   #while (J < 170)
  object
  {
        pave
	pigment { color <0.953, 0.949, 0.647>}
        normal { bumps 0.4 scale 0.4 }
        finish {Shiny}
	translate x*0.55*I
        translate z*0.65*J
  }
   #declare J=J+1;
   #end
  #declare I=I+1;
 #end
        }// fin de l'object gnr par la boucle


object
{
	sol
        scale 1.5
        //rotate y*10
	translate <0,-6.4,-150>
}




//======================
// --- croix
//======================

union
{
cylinder
{
  <0,0,0>, <0,4,0>,0.2
  texture{DMFWood6}
	texture
	{
    		pigment { rgbt <0.75, 0.15, 0.0, 0.95> }
    	finish
		{ 
        specular 0.25
        roughness 0.01
        ambient 0
        diffuse 0.33
    		}
	}
}

cylinder
{
  <-1,0,0>, <1,0,0>,0.2
  texture{DMFWood6}
	texture
	{
    		pigment { rgbt <0.75, 0.15, 0.0, 0.95> }
    	finish
		{ 
        specular 0.25
        roughness 0.01
        ambient 0
        diffuse 0.33
    		}
	}
  
  translate <0,3,0>
}
 rotate y*90
  translate <-10,0,0>
}

//************************
//   la table
//************************

object
{
  table_pot
  scale 0.6
  rotate y*15
  translate <-2,-6,2.5>
}

//========================
// le lit
//========================

object
{
  lit
  translate <-5,-6,-10>
}

//================================
// le bougeoir vers le mur du fond
//================================

object
{
  bougeoir
  scale 0.4
  translate <-9,-6,-4.5>
}



//==================================
// le tabouret 
//==================================

object
{
  tabouret2
  scale 0.7
  rotate y*-30
  translate <3,-6,-2>
}

//===============================
// la couverture
// merci  Olivier 
// qui l'a faite
//===============================

// --- Fabrication

#declare couverture =
difference {
	union {
sphere_sweep {
	cubic_spline
	6
	<-1, 0.4, 0>0.4
	
	<0, 0.4, 0>0.4
	<3, 0.4, 0>0.4
	<3, 0, 0>0.4
	<0, 0, 0>0.4
	
	<-1, 0, 0>0.4
	
pigment { Gold*1.5 }
	
normal { granite scale 0.071}	
scale z*4
}
}
plane { x, 0.4 }

}

// --- Positionnement

object
{ 
  couverture 
  scale 0.8
  rotate y*45 
  translate <-1,-4.5,-6.5>
}

//===========================
//    END OF FILE
//===========================




