/*      macro
                Cube
        sm
                Block
                Plane   */        


#include "colors.inc"


#declare loc    = array[7]      // null, bt, fb, lr
        {
        rgb <1, .5, .5>,        
        Yellow,
        White,
        Blue,
        Green,
        Red,
        Orange,
        }


// cube macro

#macro Cube (mx, my, mz)

        // block macro, block xyz <0, 1>
        
        #macro  Block   (side)
        
                #local blockbend        = .2;   // cube / sphere ratio for superellipsoid
                #local planethick       = .001;  // thickness for colorshite
                
                // plane macro, appr. pos xyz <0,1>
                
                #macro  Plane    (plassierung, farbe)  // p = <1, 6>
                
                        superellipsoid
                                {
        
                                <blockbend, blockbend>
                                
                                pigment {       loc[farbe]      }
                                finish  {       phong   .8      diffuse .6      }
                                
                                translate 1
                                scale .5
                                scale <1 - blockbend, planethick, 1 - blockbend>
                                translate <blockbend / 2, 0, blockbend / 2>
                                
                                // move from xz <0,1>
                                
                                #switch (plassierung)
                                
                                        #case (1)
                                                #break
                                        #case (2)
                                                translate y * (1 - planethick)
                                                #break
                                        #case (3)
                                                rotate x * -90
                                                translate z * planethick
                                                #break
                                        #case (4)
                                                rotate x * -90
                                                translate z
                                                #break
                                        #case (5)
                                                rotate z * 90
                                                translate x * planethick
                                                #break
                                        #case (6)
                                                rotate z * 90
                                                translate x
                                                #break
                                        
                                        #else
                                                #debug "bad switch plass\n"
                                                
                                        #end
                                        
                                }
                                
                        #end
                        
                // alt
                
                union
                        {        
                
                        // big block
                        
                        superellipsoid
                                {
                
                                <blockbend, blockbend>
                
                                pigment {       Black  }
                                finish  {       phong   .9      diffuse .6      }
                
                                translate 1
                                scale .5
                                scale (1 - planethick * 2)
                                translate planethick
                                
                                }
                                
                                
                        // planes                
                                
                        #local index = 1;
                        #while (index <= 6)
                                #if (side[index-1])
                                        Plane (index, side[index-1])   
                                        #end
                                #local index = index + 1;
                                #end
                                
                        }
                
                #end
                
        // tegn alle
        
        // gir axbxc
        union
                {  
                #local ix = 0;
                #while (ix < mx)
                        #local iy = 0; 
                        #while (iy < my)
                                #local iz = 0;
                                #while (iz < mz)
                                        object
                                                {
                                                Block   (array [6]
                                                                {1,2,3,4,5,6
                                                                /*1 * (iy == 0),
                                                                2 * (iy == my-1),
                                                                3 * (iz == 0),
                                                                4 * (iz == mz-1),
                                                                5 * (ix == 0),
                                                                6 * (ix == mx-1)*/
                                                                })
                                                translate <ix, iy, iz>
                                                }
                                        #local iz = iz + 1;
                                        #end
                                #local iy = iy + 1;
                                #end
                        #local ix = ix + 1;
                        #end
                }
                   
        // gir 1x2           
        /*union
                {
                object
                        {
                        Block   (array[6] {1,0,3,4,5,6})
                        }
                object
                        {        
                        Block   (array[6] {0,2,3,4,5,6})
                        translate -.5
                        rotate y * 90
                        translate .5
                        translate y * 1
                        }
                }*/
                
        #end        
