#include "math.inc"
#include "shapes.inc"

// ---------------- //
// --- Textures --- //
// ---------------- //

#declare T_Plateau2 = texture {
  pigment {rgb <.1,.095,.105>}
  finish {
    ambient .3 diffuse .7 
    specular .3 roughness .1
    crand .1
    }
}

#declare T_Plateau = texture {
  pigment {rgb <.43,.45,.6>}
  finish {
    ambient .3 diffuse .7 
    specular .1 roughness .1
    crand .05
    }
}

#declare T_Bille_blanche = texture {
  pigment {rgb .99}
  finish {
    ambient .3
    diffuse .7
    specular .6 roughness .03
    reflection .1
  }
}

#declare T_Bille_noire = texture {
  pigment {rgb .01}
  finish {
    ambient .3
    diffuse .7
    specular .8 roughness .01
    reflection .1
  }
}

// ----------------- //
// --- Gomtrie --- //
// ----------------- //
#declare rt=.63 ;
#declare bo=2.5*(1-rt);
#declare ep=1.2*(1-sqrt(1-pow(rt,2))) ;
#declare ber=ep/2;

#declare ra=.16 ;
#declare th=40 ;
#declare er=.03 ;
#declare hp=.08 ;

#declare Picot = intersection {
union {
  intersection {
    cylinder {<0,hp*.9,0> <0,hp,0> ra-er}
    plane {z 0 translate (ra-er)/2*z}
    plane {z 0 translate (ra-er)/2*z rotate 120*y}
    plane {z 0 translate (ra-er)/2*z rotate 240*y}
  }
  cylinder {
    <-sqrt(3)/2*(ra-er),hp-er,(ra-er)/2>
    <sqrt(3)/2*(ra-er),hp-er,(ra-er)/2>
    er
  }
  cylinder {
    <-sqrt(3)/2*(ra-er),hp-er,(ra-er)/2>
    <sqrt(3)/2*(ra-er),hp-er,(ra-er)/2>
    er
    rotate 120*y
  }
  cylinder {
    <-sqrt(3)/2*(ra-er),hp-er,(ra-er)/2>
    <sqrt(3)/2*(ra-er),hp-er,(ra-er)/2>
    er
    rotate 240*y
  }
  sphere {<sqrt(3)/2*(ra-er),hp-er,(ra-er)/2> er}
  sphere {<sqrt(3)/2*(ra-er),hp-er,(ra-er)/2> er rotate 120*y}
  sphere {<sqrt(3)/2*(ra-er),hp-er,(ra-er)/2> er rotate 240*y}
  
  union {
    intersection {
      box {<-1,-er,-1> <1,er,1>}
      plane {-z 0}
      plane {-z 0 rotate 120*y translate -sqrt(3)/2*(ra-er)*x}
      plane {-z 0 rotate -120*y translate sqrt(3)/2*(ra-er)*x}
    }
    cylinder {<0,0,3/2*(ra-er)> <-sqrt(3)/2*(ra-er),0,0> er}
    cylinder {<0,0,3/2*(ra-er)> <sqrt(3)/2*(ra-er),0,0> er}

    rotate th*x translate <0,hp-er,(ra-er)/2>
  }
  union {
    intersection {
      box {<-1,-er,-1> <1,er,1>}
      plane {-z 0}
      plane {-z 0 rotate 120*y translate -sqrt(3)/2*(ra-er)*x}
      plane {-z 0 rotate -120*y translate sqrt(3)/2*(ra-er)*x}
    }
    cylinder {<0,0,3/2*(ra-er)> <-sqrt(3)/2*(ra-er),0,0> er}
    cylinder {<0,0,3/2*(ra-er)> <sqrt(3)/2*(ra-er),0,0> er}

    rotate th*x translate <0,hp-er,(ra-er)/2>
    rotate 120*y
  }
   union {
    intersection {
      box {<-1,-er,-1> <1,er,1>}
      plane {-z 0}
      plane {-z 0 rotate 120*y translate -sqrt(3)/2*(ra-er)*x}
      plane {-z 0 rotate -120*y translate sqrt(3)/2*(ra-er)*x}
    }
    cylinder {<0,0,3/2*(ra-er)> <-sqrt(3)/2*(ra-er),0,0> er}
    cylinder {<0,0,3/2*(ra-er)> <sqrt(3)/2*(ra-er),0,0> er}

    rotate th*x translate <0,hp-er,(ra-er)/2>
    rotate 240*y
  }
  
  #declare th2=100.41 ;
  #declare th3=55 ;
  intersection {
    box {<-1,0,-1> <1,er,0>}
    plane {-x 0 rotate th3*y}
    plane {x 0 rotate -th3*y}
    rotate -th2*x
    translate <0,hp-er,-(ra-er)> 
  }
  intersection {
    box {<-1,0,-1> <1,er,0>}
    plane {-x 0 rotate th3*y}
    plane {x 0 rotate -th3*y}
    rotate -th2*x
    translate <0,hp-er,-(ra-er)> 
  
    rotate 120*y
  }
  intersection {
    box {<-1,0,-1> <1,er,0>}
    plane {-x 0 rotate th3*y}
    plane {x 0 rotate -th3*y}
    rotate -th2*x
    translate <0,hp-er,-(ra-er)> 
  
    rotate 240*y
  }
  
}
  box {<-1,0,-1> <1,1,1>}
  
  scale <1,.85,1>*.6*(2/sqrt(3)-rt)/ra
  translate ep*y
}




#declare Plateau_etp1 = union {
  
  // -- Base du plateau -- //
  difference {
    intersection {
      cylinder {<0,0,0> <0,ep,0> 8}
      plane {z 0 translate (2*sqrt(3)+rt+bo)*z rotate 30*y}
      plane {z 0 translate (2*sqrt(3)+rt+bo)*z rotate 90*y}
      plane {z 0 translate (2*sqrt(3)+rt+bo)*z rotate 150*y}
      plane {z 0 translate (2*sqrt(3)+rt+bo)*z rotate 210*y}
      plane {z 0 translate (2*sqrt(3)+rt+bo)*z rotate 270*y}
      plane {z 0 translate (2*sqrt(3)+rt+bo)*z rotate 330*y}
   }
 
   #declare v1=<sqrt(3),0,1> ;
   #declare v2=<sqrt(3),0,-1> ;
   
   cylinder {<0,-1,0> <0,1,0> rt}
   cylinder {<0,-1,0> <0,1,0> rt translate v1}
   cylinder {<0,-1,0> <0,1,0> rt translate v2}
   cylinder {<0,-1,0> <0,1,0> rt translate v1+v2}
   cylinder {<0,-1,0> <0,1,0> rt translate 2*v1}
   cylinder {<0,-1,0> <0,1,0> rt translate 2*v2}
   cylinder {<0,-1,0> <0,1,0> rt translate v1-v2}
   cylinder {<0,-1,0> <0,1,0> rt translate 2*v1-v2}
   cylinder {<0,-1,0> <0,1,0> rt translate 2*v1-2*v2}
   cylinder {<0,-1,0> <0,1,0> rt translate v2-v1}
   cylinder {<0,-1,0> <0,1,0> rt translate 2*v2-v1}
   cylinder {<0,-1,0> <0,1,0> rt translate 2*v2-2*v1}
   cylinder {<0,-1,0> <0,1,0> rt translate -v1}
   cylinder {<0,-1,0> <0,1,0> rt translate -v2}
   cylinder {<0,-1,0> <0,1,0> rt translate v1-2*v2}
   cylinder {<0,-1,0> <0,1,0> rt translate -2*v2}
   cylinder {<0,-1,0> <0,1,0> rt translate v2-2*v1}
   cylinder {<0,-1,0> <0,1,0> rt translate -2*v1}
   cylinder {<0,-1,0> <0,1,0> rt translate -v2-v1}
  }

   // -- Arrondis des trous -- //
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y}}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate v1+v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate 2*v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate 2*v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate v1-v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate 2*v1-v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate 2*v1-2*v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate v2-v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate 2*v2-v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate 2*v2-2*v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate -v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate -v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate v1-2*v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate -2*v2}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate v2-2*v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate -2*v1}
   union {difference {cylinder {<0,0,0> <0,ep-er,0> rt+er}
                      cylinder {<0,-1,0> <0,ep,0> rt-er}}
          torus {rt er translate (ep-er)*y} translate -v2-v1}

          
   // -- Picots -- //
   object {Picot translate 2/sqrt(3)*z rotate 30*y}
   object {Picot translate 2/sqrt(3)*z rotate 90*y}
   object {Picot translate 2/sqrt(3)*z rotate 150*y}
   object {Picot translate 2/sqrt(3)*z rotate 210*y}
   object {Picot translate 2/sqrt(3)*z rotate 270*y}
   object {Picot translate 2/sqrt(3)*z rotate 330*y}
   
   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate v1}
   object {Picot translate 2/sqrt(3)*z rotate 90*y
     translate v1}
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate v1}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate v1}

   object {Picot translate 2/sqrt(3)*z rotate 90*y
     translate v2}
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate v2}
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate v2}
   
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate v2-v1}
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate v2-v1}
   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate v2-v1}
    
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate -v1}
   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate -v1}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate -v1}
   
   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate -v2}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate -v2}
   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate -v2}

   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate v1-v2}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate v1-v2}
     
   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate 2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 90*y
     translate 2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate 2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate 2*v1}
   
   object {Picot translate 2/sqrt(3)*z rotate 90*y
     translate v1+v2}
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate v1+v2}

   object {Picot translate 2/sqrt(3)*z rotate 90*y
     translate 2*v2}
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate 2*v2}
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate 2*v2}
   
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate 2*v2-v1}
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate 2*v2-v1}
   
   object {Picot translate 2/sqrt(3)*z rotate 150*y
     translate 2*v2-2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate 2*v2-2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate 2*v2-2*v1}
    
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate v2-2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate v2-2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate v2-2*v1}
   
   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate -2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 210*y
     translate -2*v1}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate -2*v1}

   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate -v1-v2}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate -v1-v2}
   
   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate -2*v2}
   object {Picot translate 2/sqrt(3)*z rotate 270*y
     translate -2*v2}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate -2*v2}
   
   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate v1-2*v2}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate v1-2*v2}
   
   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate 2*v1-2*v2}
   object {Picot translate 2/sqrt(3)*z rotate 90*y
     translate 2*v1-2*v2}
   object {Picot translate 2/sqrt(3)*z rotate 330*y
     translate 2*v1-2*v2}

   object {Picot translate 2/sqrt(3)*z rotate 30*y
     translate 2*v1-v2}
}

  
   // -- Arrondi extrieur -- //
   #declare leb = 2*sqrt(3)+rt+bo ;
   #declare arr = .5 ;
   #declare elt_bord = union {
     box {<leb,0,-leb/sqrt(3)+arr>
          <leb+ber,ep-ber,leb/sqrt(3)-arr>}
     box {<leb,0,-leb/sqrt(3)+arr>
          <leb+ber,ep-ber,leb/sqrt(3)-arr>}
     cylinder {<leb,ep-ber,-leb/sqrt(3)+arr>
               <leb,ep-ber,leb/sqrt(3)-arr>
               ber}
     difference {
       union {
         cylinder {<leb-sqrt(3)*arr,0,-leb/sqrt(3)+arr>
                   <leb-sqrt(3)*arr,ep-ber,-leb/sqrt(3)+arr>
                   sqrt(3)*arr+ber}
         cylinder {<leb-sqrt(3)*arr,0,-leb/sqrt(3)+arr>
                   <leb-sqrt(3)*arr,ep,-leb/sqrt(3)+arr>
                   sqrt(3)*arr}
         torus {sqrt(3)*arr ber 
           translate <leb-sqrt(3)*arr,ep-ber,-leb/sqrt(3)+arr>}
       }
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)-arr/2-.01)*z rotate 120*y}
     } 
   }
   
#declare Plateau_etp2 = union {
   intersection {
     object {Plateau_etp1}
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)-arr/2)*z}
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)-arr/2)*z rotate 60*y}
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)-arr/2)*z rotate 120*y}
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)-arr/2)*z rotate 180*y}
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)-arr/2)*z rotate 240*y}
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)-arr/2)*z rotate 300*y}
   }
  
   object{elt_bord}
   object{elt_bord rotate 60*y}
   object{elt_bord rotate 120*y}
   object{elt_bord rotate 180*y}
   object{elt_bord rotate 240*y}
   object{elt_bord rotate 300*y}
   
   // -- bord extrieur -- //
   #declare ru=rt ;
   #declare bp=bo ;
   #declare esp=.07 ;
   #declare lplein=2.5*arr ;
   
   #declare Troubord = union {
     box {<leb+ber,-1,-leb/sqrt(3)+lplein>
          <leb+ber+2*ru,1,leb/sqrt(3)-lplein>}
     cylinder {<leb+ber+ru,-1,-leb/sqrt(3)+lplein>
               <leb+ber+ru,1,-leb/sqrt(3)+lplein>
               ru}
     cylinder {<leb+ber+ru,-1,leb/sqrt(3)-lplein>
               <leb+ber+ru,1,leb/sqrt(3)-lplein>
               ru}
   }
               
   difference {
     intersection {
       cylinder {<0,0,0> <0,esp,0> 8}
       plane {z 0 translate (2*sqrt(3)+rt+bo+2*ru+bp/2)*z rotate 30*y}
       plane {z 0 translate (2*sqrt(3)+rt+bo+2*ru+bp/2)*z rotate 90*y}
       plane {z 0 translate (2*sqrt(3)+rt+bo+2*ru+bp/2)*z rotate 150*y}
       plane {z 0 translate (2*sqrt(3)+rt+bo+2*ru+bp/2)*z rotate 210*y}
       plane {z 0 translate (2*sqrt(3)+rt+bo+2*ru+bp/2)*z rotate 270*y}
       plane {z 0 translate (2*sqrt(3)+rt+bo+2*ru+bp/2)*z rotate 330*y}
    }
 
    cylinder {<0,-1,0> <0,1,0> rt}
    cylinder {<0,-1,0> <0,1,0> rt translate v1}
    cylinder {<0,-1,0> <0,1,0> rt translate v2}
    cylinder {<0,-1,0> <0,1,0> rt translate v1+v2}
    cylinder {<0,-1,0> <0,1,0> rt translate 2*v1}
    cylinder {<0,-1,0> <0,1,0> rt translate 2*v2}
    cylinder {<0,-1,0> <0,1,0> rt translate v1-v2}
    cylinder {<0,-1,0> <0,1,0> rt translate 2*v1-v2}
    cylinder {<0,-1,0> <0,1,0> rt translate 2*v1-2*v2}
    cylinder {<0,-1,0> <0,1,0> rt translate v2-v1}
    cylinder {<0,-1,0> <0,1,0> rt translate 2*v2-v1}
    cylinder {<0,-1,0> <0,1,0> rt translate 2*v2-2*v1}
    cylinder {<0,-1,0> <0,1,0> rt translate -v1}
    cylinder {<0,-1,0> <0,1,0> rt translate -v2}
    cylinder {<0,-1,0> <0,1,0> rt translate v1-2*v2}
    cylinder {<0,-1,0> <0,1,0> rt translate -2*v2}
    cylinder {<0,-1,0> <0,1,0> rt translate v2-2*v1}
    cylinder {<0,-1,0> <0,1,0> rt translate -2*v1}
    cylinder {<0,-1,0> <0,1,0> rt translate -v2-v1}
    
    object {Troubord}
    object {Troubord rotate 60*y}
    object {Troubord rotate 120*y}
    object {Troubord rotate 180*y}
    object {Troubord rotate 240*y}
    object {Troubord rotate 300*y}
 }
 
   #declare arr2=bp/sqrt(3) ;
   #declare elt_bord2 = union {
     box {<leb+2*ru,0,-leb/sqrt(3)>
          <leb+2*ru+bp,ep-ber,leb/sqrt(3)>}
     box {<leb+2*ru+ber,0,-leb/sqrt(3)>
          <leb+2*ru+bp-ber,ep,leb/sqrt(3)>}
     cylinder {<leb+2*ru+ber,ep-ber,-leb/sqrt(3)>
               <leb+2*ru+ber,ep-ber,leb/sqrt(3)>
               ber}
     cylinder {<leb+2*ru+bp-ber,ep-ber,-leb/sqrt(3)>
               <leb+2*ru+bp-ber,ep-ber,leb/sqrt(3)>
               ber}
     difference {
       union {
         difference {
           cylinder {<leb,0,-leb/sqrt(3)>
                     <leb,ep-ber,-leb/sqrt(3)>
                     2*ru+bp}
           cylinder {<leb,-1,-leb/sqrt(3)>
                     <leb,1,-leb/sqrt(3)>
                     2*ru}
         }
         difference {
           cylinder {<leb,0,-leb/sqrt(3)>
                     <leb,ep,-leb/sqrt(3)>
                     2*ru+bp-ber}
           cylinder {<leb,-1,-leb/sqrt(3)>
                     <leb,1,-leb/sqrt(3)>
                     2*ru+ber}
         }
         torus {2*ru+ber ber 
           translate <leb,ep-ber,-leb/sqrt(3)>}
         torus {2*ru+bp-ber ber 
           translate <leb,ep-ber,-leb/sqrt(3)>}
       }
     plane {z 0 translate (4+2/sqrt(3)*(rt+bo)+ru)*z rotate 120*y}
     plane {-z 0 translate <leb,0,-leb/sqrt(3)>}
     plane {z 0 rotate 60*y translate <leb,0,-leb/sqrt(3)>}
    
     } 
   }

   object{elt_bord2}
   object{elt_bord2 rotate 60*y}
   object{elt_bord2 rotate 120*y}
   object{elt_bord2 rotate 180*y}
   object{elt_bord2 rotate 240*y}
   object{elt_bord2 rotate 300*y}
  
 }  
     

#declare Plateau = object {
  Plateau_etp2
  texture {T_Plateau}
}
 
// -- Billes -- //
#declare rbille=.95 ;
#declare hbille=sqrt(pow(rbille,2)-pow(rt,2)) ;

#declare Bille = sphere {hbille*y rbille}
#declare Bille_blanche = object {
  Bille
  texture {T_Bille_blanche}
}
#declare Bille_noire = object {
  Bille
  texture {T_Bille_noire}
}

#declare Depart = union {
  object {Bille_blanche translate v2}
  object {Bille_blanche translate 2*v2}
  object {Bille_blanche translate v2-v1}
  object {Bille_blanche translate 2*v2-v1}
  object {Bille_blanche translate 2*v2-2*v1}
  
  object {Bille_noire translate 2*v1-2*v2}
  object {Bille_noire translate v1-2*v2}
  object {Bille_noire translate -2*v2}
  object {Bille_noire translate v1-v2}
  object {Bille_noire translate -v2}

}
  
// ------------- //
// --- Scne --- //
// ------------- //

#declare Abalone = union {
object {Plateau}
object {Depart}
}

/*
light_source {<3,15,-8> rgb 1}

camera {location <1,11,-10> look_at <0,-2.2,0>}

background {<1,1,1>}


global_settings {
  ambient_light 0
  radiosity {
    pretrace_end .02
    count 301
    recursion_limit 1
  }
}*/