camera { 
	orthographic
	right x*image_width/image_height
	location <0, 0, -1.5>
	look_at 0
}

light_source {<2, 5, -5> color rgb 2 }

#declare Plane = union {
	triangle{<-0.5, -0.5, 0>, <-0.5, 0.5, 0>, <0.5, 0.5, 0>}
	triangle{<-0.5, -0.5, 0>, <0.5, -0.5, 0>, <0.5, 0.5, 0>}
}

#declare Sail = triangle{0, <0, 0.5, 0>, <0.5, 0, 0>}
#declare Shadow = triangle{0, <0.5, -0.2, 0>, <0.5, 0, 0> no_shadow}

#declare C1 = <0, 0.8, 1>*0.72;
#declare C2 = <0.3, 0.5, 1>*0.72;
#declare C3 = <0.9, 0.9, 1>;

#declare C4 = <0, 0.8, 1>*5;
#declare C5 = <0.3, 0.6, 1>*5;
#declare C6 = <0.4, 0.4, 1>*5;

#declare C7 = <1, 1, 0.6>;
#declare C8 = <1, 1, 1, 1>;

#declare Fin = finish{diffuse 0.8 phong 0.7};

#declare Sea = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C1 color rgb C1]
			[1/3 (1/3)*2 color rgb C2 color rgb C2]
			[(1/3)*2 1 color rgb C3 color rgb C3]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare Sky = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C4 color rgb C4]
			[1/3 (1/3)*2 color rgb C5 color rgb C5]
			[(1/3)*2 1 color rgb C6 color rgb C6]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare k = 0.13;

#declare SkyDark = texture{
	pigment {
		granite
		color_map {
			[0 1/3 color rgb C4*k color rgb C4*k]
			[1/3 (1/3)*2 color rgb C5*k color rgb C5*k]
			[(1/3)*2 1 color rgb C6*k color rgb C6*k]
		}
		scale 0.01
	}
	finish {Fin}
}

#declare Bgr = texture{
	gradient y
	texture_map {
		[0.4 Sky]    
		[0.6 Sea]
	}
	translate -y*0.5
}

#declare Sun = texture{
	pigment {color rgb <1, 1, 0.8>}
	finish{Fin}
}



object{
	Plane       
	texture{Sky}
	no_shadow
} 

disc{
	0, -z, 1
	texture{Sun}
	scale 0.08
	translate<-0.25, 0.27, -0.003>
	no_shadow
}

object {
	Sail
	scale<0.25, 0.5, 0>
	scale 0.8
	scale 1.4
	translate<0, -0.26, -0.00001>
	
	pigment{color rgb<1, 0.4, 0.9>*1}
	finish{Fin}
}
object {
	Shadow
	scale<0.25, 0.5, 0>
	scale 0.8
	scale 1.4
	translate<0, -0.26, -0.00001>
	
	texture{SkyDark}
}
  
object {
	Sail
	scale<0.25, 0.5, 0>
	scale 1.4
	translate<0.16, -0.33, -0.00001>
	
	pigment{color rgb<0.9, 0.5, 0>}
	finish{Fin}
}
object {
	Shadow
	scale<0.25, 0.5, 0>
	scale 1.4
	translate<0.16, -0.33, -0.00001>
	
	texture{SkyDark}
}

object {
	Sail
	scale<0.25, 0.5, 0>
	scale 0.6
	scale 1.4
	translate<0.28, -0.18, -0.00001>
	
	pigment{color rgb<1, 0.5, 0.7>}
	finish{Fin}
}
object {
	Shadow
	scale<0.25, 0.5, 0>
	scale 0.6
	scale 1.4
	translate<0.28, -0.18, -0.00001>
	
	texture{SkyDark}
}

triangle {
	<-0.5, 0, 0>, <-0.5, 0.15, 0>, <-0.2, 0, 0>
	pigment{color rgb<0.95, 0.8, 1>}
	finish{Fin}
	translate<0, -0.0, -0.002>
	no_shadow
}  

triangle {
	<-0.5, 0, 0>, <-0.5, 0.15, 0>, <-0.2, 0, 0>
	texture{SkyDark}
	scale<1, -1, 1>
	translate<0, -0.0, -0.002>
	no_shadow
}  
  
//background{color rgb 0}
 