
//==================================================
// Control
// With a desire to keep the ZIP archive of this project as small as possible
// for the IRTC server, the Poser 5 model JPEGs have not been included.
// If you have the JPEGs, change the control below accordingly.

#declare use_standin_textures = on;

//==================================================
//Map definitions

#if (use_standin_textures = on)
    #warning "You are rendering this scene with stand-in textures for the figure. See balancer_pov_mat.inc for details\n"
    #declare p_map1=pigment {color rgb <1,0.5,0.5> }
    #declare p_map2=pigment {color rgb <1,0.5,0.5>}
    #declare p_map3=pigment {color rgb <0,0,1>}
    #declare p_map4=pigment {color rgb <0,0,1>}
#else
    #declare p_map1=pigment {image_map{jpeg "JudyBodyTexHi.jpg" interpolate 2 transmit all 0 filter all 0}  }
    #declare p_map2=pigment {image_map{jpeg "JudyHeadTexHi.jpg" interpolate 2 transmit all 0 filter all 0}  }
    #declare p_map3=pigment {image_map{jpeg "JudyBlueEyeHi.jpg" interpolate 2 transmit all 0 filter all 0}  }
    #declare p_map4=pigment {image_map{jpeg "JudyBodyTexLo.jpg" interpolate 2 transmit all 0 filter all 0}  }
#end    

#declare global_diffuse = 1; // 0.6 is PoseRay default
 
//==================================================
//Material definitions
#declare SkinBody_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map1} 
        finish{ phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Tongue_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map1} 
        finish{ phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Lacrimal_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map2} 
        finish{ phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Eyelashes_= 
texture{pigment {color rgb <0,0,0> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare InnerMouth_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map1} 
        finish{ phong 0 phong_size 10.1753 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Lips_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map2} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare SkinHead_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map2} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Nostrils_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map2} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Teeth_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map1} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Pupil_= 
texture{pigment {color rgb <0,0,0> transmit 0} 
        finish{phong 0 phong_size 41.298 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Iris_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0.4078431 phong_size 41.298 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map3} 
        finish{ phong 0.4078431 phong_size 41.298 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare EyeWhite_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map3} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare EyeBall_= 
texture{pigment {color rgb <0.745098,0.7490196,0.9803922> transmit 0} 
        finish{phong 1 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare lenscovering_= 
texture{pigment {color rgb <0.9960784,0.9960784,0.9960784> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare Nipples_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map1} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare FingerNails_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map1} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================
#declare ToeNails_= 
texture{pigment {color rgb <1,1,1> transmit 0} 
        finish{phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
texture{pigment{p_map4} 
        finish{ phong 0 phong_size 44.0784 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
//==================================================

/* // Old box texture
#declare Preview_= 
texture{pigment {color rgb <1,0,0> transmit 0} 
        finish{phong 1 phong_size 15.04279 diffuse global_diffuse ambient rgb <0,0,0> reflection{0}}}
*/
        
//==================================================

// New box texture
#declare Preview_= 
texture{
    pigment {color rgb 1}
    finish{diffuse 0.75 ambient 0.75}
}
