// Infinity (c) 2005 by Malte Marwedel
// Submitted for the Internet Ray Tracing Competition.
//*PMRawBegin
#declare nscale = 20;
#declare blocks = 42; //48
//*PMRawEnd

intersection {
   union {
      //*PMRawBegin
      //Schleife
      #declare ix = -blocks;
      #while (ix <= 3)
      #declare px = ix*nscale;
      
      #declare iy = -blocks;
      #while (iy <= 0)
      #declare py = iy*nscale;
      
      box{
        <px-1,py-1,-10000>,<px+1,py+1,10000>
      }
      
      #declare iy = iy + 1;
      #end
      
      #declare ix = ix + 1;
      #end
      //*PMRawEnd
   }
   
   union {
      //*PMRawBegin
      //Schleife
      #declare ix = -blocks;
      #while (ix <= 3)
      #declare px = ix*nscale;
      
      #declare iz = -blocks;
      #while (iz <= 7)
      #declare pz = iz*nscale;
      
      box{
        <px-1,-10000,pz-1>,<px+1,10000,pz+1>
      }
      
      #declare iz = iz + 1;
      #end
      
      #declare ix = ix + 1;
      #end
      //*PMRawEnd
      translate x*0.01
   }
   
   pigment {
      color rgb <0, 0.501961, 1>
   }
   
   finish {
      brilliance 2
   }
}

global_settings {
   adc_bailout 0.00392157
   assumed_gamma 1.5
   noise_generator 2
}

light_source {
   <5, 5, 5>, rgb <1, 1, 1>
   media_interaction off
   media_attenuation off
   rotate x*(-16.6)
   translate <0, 0.033333, 0.0666667>
}

camera {
   perspective
   location <5, 5, 5>
   sky <0, 1, 0>
   direction <0, 0, 1>
   right <1.3333, 0, 0>
   up <0, 1, 0>
   look_at <0, -0.025262, -0.06947>
   rotate x*(-16.6)
   translate <0, 0.0333333, 0.0666667>
}