
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   :      .pov
 Version     : 3.6 / MegaPOV 1.0
 Description : I have a normal "myNormal", created from a pigment function "fnPig" that I
               want to apply to a texture "t3", but i want to apply the normal after I'm
               done doing the warp & scale loop. "t3" is a texture created with a
               "texture_map" of two textures "t1" and "t2".
               Is it possible to apply a normal on "t3" (see comment in "t3") without
               specifying a normal on "t1" and "t2"? If so, how?
               
 Date        : July 2005
 Author      : Ross
 E-mail      : rlitscher@everestkc.net
 
 Copyright (C) 2005. All rights reserved.
**********************************************************************************/

//Answer by PM 2Ring:
//No, but I think the following does what you want.

// Persistence of Vision Ray Tracer Scene Description File
//  From: Ross
//  Subject: normals and textures using texture_map
//  Date: 1 Jul 2005 21:54:37
//  Message: <42c5bb9d@news.povray.org>
//  Modified by PM 2Ring
//
//  -D +A0.1 +AM2 +R3
//  -F -A0.5 +AM2 +R1
//

#ifndef (Standalone)	#declare Standalone = true;	#end

#local Step = 8;
#local Turb = <0.34, 0.3, 0.7>;

#local Pig =
pigment {
 leopard scale 0.15
 //color_map {[0.0 rgb 1][1.0 rgb 0]} //Redundant: this is the default
 #local I = Step;
 #while (I > 0)
  warp {repeat x flip y}
  warp {turbulence Turb}
  scale 1.2
  #local I = I - 1;
 #end
}

#local fnPig = function {pigment {Pig}}
#local myNormal = normal {function {fnPig(x, y, z).x}}

#local Dull =  
finish {
  specular 1 
  roughness 0.003 
  diffuse 0.3 
  reflection {
    0.2, 0.4 
    fresnel on
  }
}

#local Shiny = 
finish {
  specular 0.6 
  roughness 0.03 
  diffuse 0.3
}

#local t1 = texture {pigment {rgb 1} finish { Dull } normal {myNormal} }
#local t2 = texture {pigment {rgb 0.2} finish { Shiny } normal {myNormal}
}

#declare WarpReflection =
texture {
  function {fnPig(x, y, z).grey}
  texture_map {
    [0.0 t1]
    [1.0 t2]
  }
}

/**** test scene ****/
#if (Standalone)
#version 3.6;

global_settings { assumed_gamma 1.0 }

camera {
  right x*image_width/image_height

  //location  <0, 6, -10>
  //look_at   <0,5,0>

  location  <0, 3, -12>
  look_at   <0,2,0>
  angle 30
}

light_source {
  <200,400,-350>
  rgb 1
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

plane {
  y, 0
  texture { pigment {rgb <0.65, 1, 0.36>} }
}

//The ball
sphere {
 <0, 2, 2>, 2
 texture {WarpReflection}
 interior { ior 1.455 }   //So Fresnel works
}

//Some objects to reflect in the ball
#macro Post(A,C) cylinder{A, A+4*y, 0.5 pigment{C}
  finish{specular .5 roughness 0.03}}
#end

Post(-2.4*x, red 1)
Post(2.4*x, blue 1)

#end // end of Standalone
//------------------------------------------------------------

//I hope this helps.



