
/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : mirror.pov
 Version     : 3.6 / MegaPOV 1.0
 Description : series of mirrors illustrating 'less is more'
               
 Date        : July 2005
 Author      : Thomas A. M. de Groot
 E-mail      : t.degroot@inter.nl.net
 
 Copyright (C) 2005. All rights reserved.
**********************************************************************************/

#include "rad_def.inc"
#include "colors.inc"
#include "woods.inc"

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

background { color rgb <0.1, 0.3, 0.8> }


global_settings {
  assumed_gamma 1.0
  ambient_light 0
  max_trace_level 100 // increase for increasing the depth of the infinity box (best >100)
  radiosity {Rad_Settings (Radiosity_OutdoorLight, on, off)}
}


camera {
  location  <-4.0, 5.0, -25.0>
  look_at   <0.0, 5.0,  0.0>
  right     x*image_width/image_height
  sky       <0.1, 1, 0>
}


light_source {
  0*x
  color rgb <1, 1, 1.0>*1.5
  translate <-200, 400, -200>
  //fade_distance  10.0
  //fade_power 1.0
}

#declare InnerLight_01 =
 light_source {
  <0, 0, 0>
  color rgb <1.0, 1.0, 0.0> // yellow
  fade_distance  5.0
  fade_power 1.0
  scale 1
 }

#declare InnerLight_02 =
 light_source {
  <-0.75, -0.65, 0.85>
  color rgb <1.0, 0.0, 0.0> // red
  fade_distance  5.0
  fade_power 1.0
  scale 1
 }

//
// ********  TEXTURES  *******
//

// for the outside texture of the mirror, use:
#declare Glass_1 = 
      texture {      
         pigment {
            color rgbft <1.0, 1.0, 1.0, 1.0, 1.0>
         }      
         finish {
            ambient 0.01
            diffuse 0.0
            phong 0.3
            phong_size 90.0
            reflection 0.0
         }
      }

// for the interior_texture of the box, use this...
#declare Chrome_Metal_3 = 
      texture {      
         pigment {
            color rgb <0.0, 0.0, 0.0>
         }      
         finish {
            ambient 0.01
            diffuse 0.0
            brilliance 20.0
            phong 1.0
            phong_size 90.0
            specular 1.0
            roughness 0.0004
            reflection 1
         }
      }

// ... or this
#declare ReflectiveCheckersTex = 
      texture {
         checker
            texture {            
               pigment {
                  color rgb <1, 1, 1>
               }            
               finish {
                  ambient 0.01
                  conserve_energy
                  diffuse 0.0
                  brilliance 1.0
                  phong 0.3
                  phong_size 90.0
                  specular 1.0
                  roughness 0.0004
                  reflection {
                     0.8 , 1
                     fresnel  on
                     falloff  1.0
                     exponent 1.0
                     metallic 0.0
                  }
               }
            }
            texture {            
               pigment {
                  color rgb <1, 1, 1>
               }            
               finish {
                  ambient 0.01
                  conserve_energy
                  diffuse 0.0
                  brilliance 1.0
                  phong 0.3
                  phong_size 90.0
                  specular 1.0
                  roughness 0.0004
                  reflection {
                     0.9 , 1
                     fresnel  on
                     falloff  1.0
                     exponent 1.0
                     metallic 0.0
                  }
               }
            }
         scale  0.3
      }

#declare ReflectiveCheckersTex_original = 
      texture {
         checker
            texture {            
               pigment {
                  color rgb <0.66, 0.66, 0.66>
               }            
               finish {
                  ambient 0.01
                  conserve_energy
                  reflection {
                     0.5 , 1
                     fresnel  on
                     falloff  1.0
                     exponent 1.0
                     metallic 0.0
                  }
               }
            }
            texture {            
               pigment {
                  color rgb <0.33, 0.33, 0.33>
               }            
               finish {
                  ambient 0.01
                  conserve_energy
                  reflection {
                     0.9 , 1
                     fresnel  on
                     falloff  1.0
                     exponent 1.0
                     metallic 0.0
                  }
               }
            }
         scale  0.3
         rotate    <-10.0, -10.0, -10.0>
      }

#declare ReflectiveTex =
            texture {            
               pigment {
                  color rgbt <1, 1, 1, 0.8>
               }            
               finish {
                  ambient 0.01
                  conserve_energy
                  diffuse 0.0
                  brilliance 1.0
                  phong 0.3
                  phong_size 90.0
                  specular 1.0
                  roughness 0.0004
                  reflection {
                     0.3 , 1
                     fresnel  on
                     falloff  1.0
                     exponent 1.0
                     metallic 0.0
                  }
               }
            }

#declare Gradient_Orb = 
      texture
      {
         gradient y
         texture_map
         {
            [0.00   pigment {color rgb <0.0, 1.0, 0.0>*0.5} ]
            [0.49   pigment {color rgb <0.0, 1.0, 0.0>*0.5} ]
            [0.51   pigment {color rgb <0.0, 0.0, 1.0>*1.0} ]
            [1.00   pigment {color rgb <0.0, 0.0, 1.0>*1.0} ]

         }
         scale  <1.0, 2.0, 1.0>
         translate 1.0 * y
      }


//
// ********  OBJECTS  *******
//

#declare Standalone=false;
#include "Ross_WarpReflection.inc"

#declare Face01=
union {
  polygon {
    4,
    <-50, -100>, <50, -100>, <50, 100>, <-50, 100>
    texture { Glass_1 }
    //interior_texture { Chrome_Metal_3 }
    interior_texture { ReflectiveCheckersTex }
    //interior_texture { ReflectiveCheckersTex_original }
    interior { ior 1.5 }
  }
  
  union {
    text {
      ttf             // font type (only TrueType format for now)
      "crystal.ttf",  // Microsoft Windows-format TrueType font file name
      //"less",      // the string to create
      "-min",      // the string to create
      0.01,              // the extrusion depth
      0               // inter-character spacing
      scale 2
      //translate <-2, 6.5, -0.01>
      translate <-2, 8.0, -0.01>
    }
    text {
      ttf             // font type (only TrueType format for now)
      "crystal.ttf",  // Microsoft Windows-format TrueType font file name
      //"=",      // the string to create
      "imal",      // the string to create
      0.01,              // the extrusion depth
      0               // inter-character spacing
      scale 2
      //translate <-0.5, 5, -0.01>
      translate <-2, 5, -0.01>
    }
    text {
      ttf             // font type (only TrueType format for now)
      "crystal.ttf",  // Microsoft Windows-format TrueType font file name
      //"more",      // the string to create
      "ism+",      // the string to create
      0.01,              // the extrusion depth
      0               // inter-character spacing
      scale 2
      //translate <-2, 3.5, -0.01>
      translate <-2, 2.0, -0.01>
    }
    //texture { ReflectiveTex }
    //texture { Chrome_Metal_3 }
    texture { WarpReflection }
  }
  
  rotate -0.1*x
}

#declare Angle = 0;

#while (Angle <= 360)
  object {Face01
    translate <0, 0, 10>
    rotate Angle*y
  }
  #declare Angle = Angle + 110;
#end


object {InnerLight_01
  translate <-3, 20, 2>
}

object {InnerLight_02
  translate <4, -20, -5>
}

sphere { <0, 0, 0>, 1 
  texture { Gradient_Orb }
  scale 1000
}

