/*
  Author:  Philip Chan
  Last Updated:  August 14, 2005
  Version: POV-Ray version 3.6
   
	This include file contains a macro for generating a tile with a rough surface.
*/

// Pigment noise function for tile
#declare fn_TNoise = function {
	pigment {
		agate
		turbulence 0.65
		color_map {
		  [0.00 colour rgb 0.0]
			[0.10 colour rgb 0.1]
			[0.20 colour rgb 0.5]
			[0.85 colour rgb 0.5]
			[0.92 colour rgb 0.9]
			[1.00 colour rgb 1.0]
		}
	}
}

#declare R_isotile = seed( 132587 );
#macro Isotile()
  #local delta_x = 5000*rand(R_isotile);
  #local delta_y = 5000*rand(R_isotile);
  #local delta_z = 5000*rand(R_isotile);
  isosurface {
  	function {
  		(y - 0.1)	 // height 0.1
  		// falloff behaviour
  		+ (x < -0.45)*pow((-x - 0.45)*sqrt(40), 2)
  		+ (z < -0.45)*pow((-z - 0.45)*sqrt(40), 2)
  		+ (x > 0.45)*pow((x - 0.45)*sqrt(40), 2)
  		+ (z > 0.45)*pow((z - 0.45)*sqrt(40), 2)
  		// rough surface, falloff (first line) smooths it out before it hits the edge of the tile
  		+ max(0, (x < -0.35)*(x + 0.35)/0.1 + (z < -0.35)*(z + 0.35)/0.1 + (x > 0.35)*(-x + 0.35)/0.1 + (z > 0.35)*(-z + 0.35)/0.1 + 1 )
  		  *(fn_TNoise(0.5*x + delta_x, 0.5*y + delta_y, 0.5*z + delta_z).gray - 0.5)*0.01
  	}
  	contained_by { box { <-0.51, 0, -0.51>, <0.51, 0.11, 0.51> } }
  	accuracy 0.001
  	max_gradient 6.0
  }
#end
