//minimalism

//theory: simple scene with elaborate lighting effects        

#include "rad_def.inc"

global_settings {
	max_trace_level 20
	assumed_gamma 1
	radiosity { Rad_Settings( Radiosity_Fast, on, on ) }
	photons { spacing 0.01 }
}

#default { pigment { rgb 1 } finish { diffuse .7 ambient 0 } }

#declare White =
	material {
		texture {
			pigment { rgb 1 }
			normal { spotted scale .01 }
		}
	}

#macro Glass1(col)
	//perlescent
	material {
		texture {
			pigment { rgb 0 transmit 1 }
			finish {
				reflection { .01, .95 fresnel } conserve_energy
				//big fat phong highlight, to give ethereal sheen to the material.
				//make phong fade with angle, using pov's metallic effect on black (because there's no fresnel for phong)
				phong 30 phong_size 20 metallic 1
				specular 50 roughness .0004   //layer a sharp highlight on top.
			}
		}
		interior {
			ior 1.5
			fade_colour col
			fade_distance .5
			fade_power 2
		}
	}
#end


plane { y, -.01 material { White } }

#local loop=0;
#while ( loop <= 1 )
	difference {
		superellipsoid { <.1,.1> }
		superellipsoid { <1-.7*loop,1-.7*loop> scale .9*loop+.09 }
		translate y
		Glass1(<loop,1-abs(loop-.5),1-loop>)
		photons{
			target 1.0
			refraction on
			reflection on
		}
		translate (loop-.5)*16*x
	}
	#local loop = loop + 1/6;
#end

background { rgb .8 }

light_source {
	<-5,15,30>, rgb 1
	fade_power 2 fade_distance vlength(<-5,15,30>)
	photons {
		refraction on
		reflection on
		//area_light
	}
}

camera {
	right		x*image_width/image_height
	up			y
	direction	z*1
	
	location <0,16,-8>
	look_at <0,0,0>
}

