// Light and Color
// by Ian McNamara
// 07.21.05 - 

// 1.     First attempt
// 2.     Removed collision loop (not required)
// 3.     Prevented cable box write/read
//        Read/Write block now determines cable points.
//        Tack scale now always has y = 1
//        Fixed rotation errors in tack placement, it now matches
//             the rotation of the block
// 4.     Created a blockCableArray after read/write
// 5.     Rewrite to ensure cable collsion detection 
// 6.     Changed support bound detection

//NOTE:   
//        This file was used to create a new city layout
//        for the picture used on the pamphlet.  For this
//        reason, running this file will result in the re-writing
//        of the pamphlet_memory.txt file.  Change the output .txt
//        file name in order to get a different file output.
//        (see line #297)
//
/* INCLUDE */
#include "boxcollisiondetection2d.inc" 
#include "math.inc"

#declare numberOfBlocks = 88;
/* Block info */
#declare maxDistance = 8;         // No block will be further from the center
                                  // then this distance.
#declare weight = 3.75;
#declare weightPower = 2.5;          // Max divider (on the outside of the radius)
                                   // will be pow(weight,weightPower).
                                   // Min divider (in the center) will be 1.
#declare minScale = <1,28,0.1>;    // The blocks will be no smaller than this (before weighting)
#declare addScale = <0,5,0>;       // This is the max value to be added to the scale of the block.
/* Cable/Tack info */
#declare maxSupportDistance = 9;  // No support will be further from the center
                                   // then this distance.
#declare cableDistFromSide = 0.1;
#declare cableDistFromTop = 0.1;   // Where the cables attatch to
                                   // the blocks that they support.
#declare cableRadius = 0.02;
#declare cableBoundingWidth = 0.05;     // The width used for the cable bounding box.
#declare tackDistFromBase = 0.25;  // This is % of block height
                                   // Distance from block on Z axis (before rotation)
#declare tackRotationFromBlock = 5;     // The degree given here (must be < 90)
                                        // determines the angle of the intersection
                                        // between the cable and the block (outside angle)
                                        // A value of 0 results in the cable
                                        // extending directly outward.                                    
#declare tackRadius = 0.05;
/* Randomizer */
#declare S = seed(2);
/* Create Block and Support arrays */
     // These arrays will hold information on the 
     // location and placement of 3 different types 
     // of blocks.  Array one will track the blocks
     // to be shown.  Array two will track the 
     // bounding boxes of the support cables.  The
     // last array will track the bounding boxes of
     // the tacks.
#declare blockInfoArray = array[numberOfBlocks][3];
#declare blockCableArray = array[numberOfBlocks*4][3];
#declare blockTackArray = array[numberOfBlocks*4][3];
/* Setup is complete */
/* Begin the placement testing */
#declare blockIndex = 0;
#while (blockIndex < numberOfBlocks)
     #debug concat("Block ",str(blockIndex,0,0),".\n")
     /* Select a size for the block */
     #declare thisScale = minScale + (addScale * <rand(S),rand(S),rand(S)>);
     /* Attempt Placement */
     #declare blockIsPlaced = false;    // The following loop will continue until
                                        // this value becomes true 
     #declare attempt = 0;                                     
     #while (!blockIsPlaced)
          #debug concat("         Attempt ",str(attempt,0,0),".\n")
          /* Select location and rotation */
          #declare thisRadius = maxDistance * rand(S);
          #declare thisLocation = vaxis_rotate(<thisRadius,0,0>,y,360*rand(S));
          #declare thisRotation = rand(S)*360;
          /* To weight the heights create a test scale */
          #declare distancePercent = thisRadius / maxDistance;
          #declare dividerToAdd = weight - 1;
          #declare thisDivider = 1 + (dividerToAdd * distancePercent); 
          #declare testScale = thisScale * <1,1/pow(thisDivider,weightPower),1>;
          /* Test for collision */
          #declare collisionDetected = false;     // The block will be placed if this
                                                  // value remains false through the 
                                                  // following loops. 
          /* Test the block for collisions */
               // Test against Borders, Blocks, Tacks and Cables
          // Instead of testing against border boxes, find the location
          // of each of the four corners of the box, and see if they 
          // are too far from the center.  If they exceed the maxDistance
          // then report a collision.
          #declare thisBlockCornerArray = array[4];
          #declare thisBlockCornerArray[0] = <0.5,0,0.5>; 
          #declare thisBlockCornerArray[1] = <0.5,0,-.5>;
          #declare thisBlockCornerArray[2] = <-.5,0,-.5>;
          #declare thisBlockCornerArray[3] = <-.5,0,0.5>;
          #declare cornerIndex = 0;
          #while (cornerIndex < 4 & !collisionDetected)
               #declare thisBlockCornerArray[cornerIndex] = 
                    thisBlockCornerArray[cornerIndex]*thisScale;
               #declare thisBlockCornerArray[cornerIndex] = 
                    vaxis_rotate(thisBlockCornerArray[cornerIndex],y,thisRotation);
               #declare thisBlockCornerArray[cornerIndex] = 
                    thisBlockCornerArray[cornerIndex] + thisLocation; 
               #declare cornerDistanceFromCenter = 
                    VDist(<0,0,0>,thisBlockCornerArray[cornerIndex]);
               #if (cornerDistanceFromCenter > maxDistance)
                    #declare collisionDetected = true;
               #end
               #declare cornerIndex = cornerIndex + 1;
          #end                                
          #if (!collisionDetected)     // Abort 1
          #declare i = 0;
          #while (i < blockIndex & !collisionDetected)      // Block test
               #declare collisionDetected = bCD2D(
                                             thisLocation,
                                             blockInfoArray[i][0],
                                             thisScale,
                                             blockInfoArray[i][1],
                                             thisRotation,
                                             blockInfoArray[i][2].y
                                             )
               #declare i = i + 1;                              
          #end
          #if (!collisionDetected)      // Abort 2
          #declare i = 0;
          #while (i < (blockIndex*4) & !collisionDetected)   // Tack test
               #declare collisionDetected = bCD2D(
                                             thisLocation,
                                             blockTackArray[i][0],
                                             thisScale,
                                             blockTackArray[i][1],
                                             thisRotation,
                                             blockTackArray[i][2].y
                                             ) 
               #declare i = i + 1;                                
          #end
          #if (!collisionDetected)      // Abort 3
          #declare i = 0;
          #while (i < (blockIndex*4) & !collisionDetected)   // Cable test
               #declare collisionDetected = bCD2D(
                                             thisLocation,
                                             blockCableArray[i][0],
                                             thisScale,
                                             blockCableArray[i][1],
                                             thisRotation,
                                             blockCableArray[i][2].y
                                             ) 
               #declare i = i + 1;                                
          #end
          #if (!collisionDetected)      // Abort 4
          /* Construct a temp tack array */     
          #declare thisDistanceFromBlock = testScale.y * tackDistFromBase;
          #declare thisTackLocation = <0,0,thisDistanceFromBlock>;
          #declare thisTackLocation = vaxis_rotate(thisTackLocation,y,tackRotationFromBlock);
          #declare thisTackLocation = thisTackLocation + 
                                        <(thisScale.x/2) - cableDistFromSide,0,(thisScale.z/2)>;                                                            
          #declare thisTackInfoArray = array[4][3]; 
          #declare thisTackInfoArray[0][0] = 
                         vaxis_rotate((thisTackLocation * <1,1,1>),y,thisRotation) + thisLocation;   // +x, +z tack
          #declare thisTackInfoArray[1][0] = 
                         vaxis_rotate((thisTackLocation * <1,1,-1>),y,thisRotation) + thisLocation;   // +x, -z tack
          #declare thisTackInfoArray[2][0] = 
                         vaxis_rotate((thisTackLocation * <-1,1,-1>),y,thisRotation) + thisLocation;   // -x, -z tack
          #declare thisTackInfoArray[3][0] = 
                         vaxis_rotate((thisTackLocation * <-1,1,1>),y,thisRotation) + thisLocation;   // -x, +z tack                                            
          #declare j = 0;
          #while (j < 4)
               #declare thisTackInfoArray[j][1] = <(tackRadius*2),1,(tackRadius*2)>;
               #if (j = 0 | j = 2)                         
                    #declare thisTackInfoArray[j][2] = tackRotationFromBlock * <0,1,0>;
               #else
                    #declare thisTackInfoArray[j][2] = -tackRotationFromBlock * <0,1,0>;
               #end            
               #declare j = j + 1;
          #end
          /* Test tacks for collisions */
               // If the block hasn't collided with anything, which
               // is the case if the code has gotten here, then determine
               // the locations for the tacks and their bounding boxes
          #declare tackIndex = 0;
          #while (tackIndex < 4 & !collisionDetected)
               // For each tack...
               #declare i = 0;
               #while (i < 4 & !collisionDetected)     // Border test
                    #if (VDist(thisTackInfoArray[i][0]*<1,0,1>,<0,0,0>) > maxSupportDistance)
                         #declare collisionDetected = true;
                    #end      
                    #declare i = i + 1;                                  
               #end
               #declare i = 0;
               #while (i < (blockIndex * 4) & !collisionDetected)     // Tack test
                    #declare collisionDetected = bCD2D(
                                                  thisTackInfoArray[tackIndex][0],
                                                  blockTackArray[i][0],
                                                  thisTackInfoArray[tackIndex][1],
                                                  blockTackArray[i][1],
                                                  thisTackInfoArray[tackIndex][2].y,
                                                  blockTackArray[i][2].y
                                                  )
                    #declare i = i + 1;                                  
               #end       
               #declare i = 0;
               #while (i < blockIndex & !collisionDetected)      // Block test
                    #declare collisionDetected = bCD2D(
                                                  thisTackInfoArray[tackIndex][0],
                                                  blockInfoArray[i][0],
                                                  thisTackInfoArray[tackIndex][1],
                                                  blockInfoArray[i][1],
                                                  thisTackInfoArray[tackIndex][2].y,
                                                  blockInfoArray[i][2].y
                                                  )
                    #declare i = i + 1;                              
               #end
               #declare tackIndex = tackIndex + 1;
          #end
          #if (!collisionDetected)      // Abort 5
          /* Test cables for collisions */
               // At this point, the boxes and tacks have checked
               // out collision-free.  Now, all that is left is
               // to compute the bounding boxes for the cables
               // and to check that they aren't colliding with
               // any boxes.   
          #declare thisCableInfoArray = array[4][3];
          #declare thisCableLocation = <0,0,thisDistanceFromBlock/2>;
          #declare thisCableLocation = vaxis_rotate(thisCableLocation,y,tackRotationFromBlock);        
          #declare thisCableLocation = thisCableLocation + 
                                        <(thisScale.x/2) - cableDistFromSide,0,(thisScale.z/2)>;                            
          #declare thisCableInfoArray[0][0] = 
                         vaxis_rotate((thisCableLocation * <1,1,1>),y,thisRotation) + thisLocation;   // +x, +z tack
          #declare thisCableInfoArray[1][0] = 
                         vaxis_rotate((thisCableLocation * <1,1,-1>),y,thisRotation) + thisLocation;   // +x, -z tack
          #declare thisCableInfoArray[2][0] = 
                         vaxis_rotate((thisCableLocation * <-1,1,-1>),y,thisRotation) + thisLocation;   // -x, -z tack
          #declare thisCableInfoArray[3][0] = 
                         vaxis_rotate((thisCableLocation * <-1,1,1>),y,thisRotation) + thisLocation;   // -x, +z tack
                                    
          #declare j = 0;
          #while (j < 4)
               #declare thisCableInfoArray[j][1] = <cableBoundingWidth,1,thisDistanceFromBlock>;
               #if (j = 0 | j = 2)                         
                    #declare thisCableInfoArray[j][2] = tackRotationFromBlock * <0,1,0> + thisRotation; 
               #else
                    #declare thisCableInfoArray[j][2] = -tackRotationFromBlock * <0,1,0> + thisRotation;                          
               #end            
               #declare j = j + 1;
          #end
          #declare cableIndex = 0;
          #while (cableIndex < 4 & !collisionDetected)
               // For each cable...
               #declare i = 0;
               #while (i < blockIndex & !collisionDetected)      // Block test
                    #declare collisionDetected = bCD2D(
                                                  thisCableInfoArray[cableIndex][0],
                                                  blockInfoArray[i][0],
                                                  thisCableInfoArray[cableIndex][1],
                                                  blockInfoArray[i][1],
                                                  thisCableInfoArray[cableIndex][2].y,
                                                  blockInfoArray[i][2].y
                                                  )
                    #declare i = i + 1;                              
               #end
               #declare cableIndex = cableIndex + 1;
          #end                                                   
          #end #end #end #end #end   // End aborts 1-5
          /* All collision tests are done */
          /* Place block? */
          #if (!collisionDetected)
               /* Place block */ 
               #declare blockInfoArray[blockIndex][0] = thisLocation; 
               #declare blockInfoArray[blockIndex][1] = testScale;
               #declare blockInfoArray[blockIndex][2] = thisRotation * <0,1,0>;
               #declare i = 0;
               #while (i < 4)
                    #declare blockCableArray[(blockIndex*4)+i][0] = thisCableInfoArray[i][0]; 
                    #declare blockTackArray[(blockIndex*4)+i][0] = thisTackInfoArray[i][0];
                    #declare blockCableArray[(blockIndex*4)+i][1] = thisCableInfoArray[i][1]; 
                    #declare blockTackArray[(blockIndex*4)+i][1] = thisTackInfoArray[i][1];
                    #declare blockCableArray[(blockIndex*4)+i][2] = thisCableInfoArray[i][2]; 
                    #declare blockTackArray[(blockIndex*4)+i][2] = thisTackInfoArray[i][2];
                    #declare i = i+1;
               #end
               #declare blockIsPlaced = true;       
          #end
          #declare attempt = attempt + 1;
     #end
     #declare blockIndex = blockIndex + 1;
#end
/* Write information to file */
#fopen writeMemory "pamphlet_memory.txt" write
#write (writeMemory,numberOfBlocks,",\n")
#write (writeMemory,cableDistFromSide,",\n")
#write (writeMemory,cableDistFromTop,",\n")
#write (writeMemory,cableRadius,",\n")
#write (writeMemory,tackRadius,",\n")
#declare i = 0;
#while (i < numberOfBlocks)
     #debug concat("Writing block ",str(i,0,0),".\n")
     #write (writeMemory,blockInfoArray[i][0],",")     // Block info
     #write (writeMemory,blockInfoArray[i][1],",")
     #write (writeMemory,blockInfoArray[i][2],",\n")
     #declare j = 0;
     #while (j < 4)
          #write (writeMemory,blockTackArray[(i*4)+j][0],",")
          #write (writeMemory,blockTackArray[(i*4)+j][1],",")
          #write (writeMemory,blockTackArray[(i*4)+j][2],",\n")
          #declare j = j + 1;
     #end                     
     #declare i = i + 1;      
#end 
#fclose writeMemory
/* Create and fill a cable array (start and end points) */
#declare blockCableArray = array[numberOfBlocks*4][2];
#declare i = 0;
#while (i < numberOfBlocks)
     /* Determine locations of block and tack contact */
          // The following contact points should be relative
          // to the location of the block. (sans translation)
     #declare blockContact = 
          <(blockInfoArray[i][1].x/2)-cableDistFromSide,
          blockInfoArray[i][1].y-cableDistFromTop,
          blockInfoArray[i][1].z/2>;
     #declare tackRotatedLocation = blockTackArray[i*4][0] - blockInfoArray[i][0];
     #declare tackLocation = vaxis_rotate(tackRotatedLocation,y,-blockInfoArray[i][2].y);
     #declare tackRadiusVector = <0,0,-(blockTackArray[i*4][1].x / 2)>;
     #declare tackRadiusVector = vaxis_rotate(tackRadiusVector,y,blockTackArray[i*4][2].y);
     #declare tackContact = tackLocation + tackRadiusVector;
     /* Plug the values into an array */
          // These locations still have not been modified
          // to account for block rotation and location.
     #declare blockCableArray[(i*4)+0][0] = (blockContact * <1,1,1>);
     #declare blockCableArray[(i*4)+0][1] = (tackContact * <1,1,1>);
     #declare blockCableArray[(i*4)+1][0] = (blockContact * <1,1,-1>);
     #declare blockCableArray[(i*4)+1][1] = (tackContact * <1,1,-1>);
     #declare blockCableArray[(i*4)+2][0] = (blockContact * <-1,1,-1>);
     #declare blockCableArray[(i*4)+2][1] = (tackContact * <-1,1,-1>);
     #declare blockCableArray[(i*4)+3][0] = (blockContact * <-1,1,1>);
     #declare blockCableArray[(i*4)+3][1] = (tackContact * <-1,1,1>);
     /* Modify the values */
          // Adjust the values to match the rotation 
          // and location of the block.
     #declare j = 0;     
     #while (j < 4) 
          #declare k = 0;
          #while (k < 2)
               #declare blockCableArray[(i*4)+j][k] = 
                    vaxis_rotate(blockCableArray[(i*4)+j][k],y,blockInfoArray[i][2].y);
               #declare blockCableArray[(i*4)+j][k] =
                    blockCableArray[(i*4)+j][k] + blockInfoArray[i][0];      
               #declare k = k + 1;
          #end
          #declare j = j + 1;
     #end               
     #declare i = i + 1;
#end 
                                  