// Light Distribution Macro
// by Ian McNamara
// 

#macro lightDistribute(
               numberOfLights,
               centerOfScene,
               minRadius,
               maxAdditionalRadius,
               minHeight,
               maxAdditionalHeight,
               minRotation, 
               maxAdditionalRotation,
               brightnessMultiplier,
               seedInt)
               
     #local thisSeed = seed(seedInt);
     #local index = 0;
     #while (index < numberOfLights)
          light_source {
               <minRadius,minHeight,0>
               rgb (1/numberOfLights) * brightnessMultiplier
               translate <maxAdditionalRadius*rand(thisSeed),
                         maxAdditionalHeight*rand(thisSeed),0>
               rotate y*minRotation 
               rotate y*(maxAdditionalRotation / numberOfLights)*index
               translate centerOfScene
               jitter
               fade_power 2
               fade_distance sqrt(pow(minRadius,2)+pow(minHeight,2)) + (sqrt(pow(maxAdditionalRadius,2)+pow(maxAdditionalHeight,2)) / 2)
               }
          #declare index = index + 1;
          #debug "lightDist read\n\n"
     #end
#end      