/*
Copyright (c) 2005 Thorsten Thielen <thth@c2226.de>

This work is licensed under the Creative Commons
Attribution-NonCommercial License. To view a copy of this license,
visit http://creativecommons.org/licenses/by-nc/2.5/ or send a letter
to Creative Commons, 543 Howard Street, 5th Floor, San Francisco,
California, 94105, USA.
*/

#macro CylinderSquare( _length )
object {
    union {
        // "rings"
        cylinder {
            <-_length/2,0.00200,-_length/2>,
            < _length/2,0.00200,-_length/2>,
            0.0013
        }
        cylinder {
            < _length/2,0.00200,-_length/2>,
            < _length/2,0.00200, _length/2>,
            0.0013
        }
        cylinder {
            < _length/2,0.00200, _length/2>,
            <-_length/2,0.00200, _length/2>,
            0.0013
        }
        cylinder {
            <-_length/2,0.00200, _length/2>,
            <-_length/2,0.00200,-_length/2>,
            0.0013
        }
        // round corner correction
        sphere { <-_length/2,0.00200,-_length/2>,0.0013 texture { T_Black } }
        sphere { <-_length/2,0.00200, _length/2>,0.0013 texture { T_Black } }
        sphere { < _length/2,0.00200,-_length/2>,0.0013 texture { T_Black } }
        sphere { < _length/2,0.00200, _length/2>,0.0013 texture { T_Black } }
    }
    texture { T_Black }
}
#end

#declare M_Millsboard = object {
    difference {
        Round_Box_Union(
            <-0.21,-0.0020,-0.21>,
            < 0.21, 0.0020, 0.21>,
            0.0001
        )
        CylinderSquare( 0.36 )
        CylinderSquare( 0.24 )
        CylinderSquare( 0.12 )
        // "cross"
        cylinder {
            <0.0,0.00200,-0.18>,
            <0.0,0.00200,-0.06>,
            0.0013
        }
        cylinder {
            <0.0,0.00200, 0.18>,
            <0.0,0.00200, 0.06>,
            0.0013
        }
        cylinder {
            <-0.18,0.00200,0.0>,
            <-0.06,0.00200,0.0>,
            0.0013
        }
        cylinder {
            < 0.18,0.00200,0.0>,
            < 0.06,0.00200,0.0>,
            0.0013
        }
    }
    scale 0.60
    texture { T_White }
}

