//  Persistence of Vision Raytracer V3.5
//  World definition file.
//
//  Minimal audience
//  by Teemu Tommola 2005
//

           



//
// RENDERING OPTIONS
//






#declare Speed=0;
#declare Radios=1;
#declare AspectRatio=2/1;

  
  


//
// INCLUDE FILES
//

#include "math.inc"
#include "rand.inc"

 



//
// GLOBAL SETTINGS
//

global_settings {
#if (Radios=1)
  radiosity { brightness 2.5 }
#end
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
}

background { color <0.000,0.000,0.000> }





//
// CAMERAS
//

#declare Camera_Sat = camera {
  location  <0,-100,600>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     35
  look_at   <0,-1000,400>
}

#declare Camera_Far = camera {
  location  <0,690,150>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     40
  look_at   <-50,-1000,500>
}

#declare Camera_Near = camera {
  location  <-485,490,112>//<-450,400,106>//<-450,400,110><-300,500,110>
  sky       vrotate(<0,0,1>, <3,0,0>)
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     40
  look_at   <-347,330,134>//<50,-100,180>//<50,-100,150><80,-100,150>
  focal_point < -380, 330, 110>
  aperture 1     // a nice compromise
  //  aperture 0.05    // almost everything is in focus
  //  aperture 1.5     // much blurring
  //  blur_samples 4       // fewer samples, faster to render
  blur_samples 25      // more samples, higher quality image
}

#declare Camera_New = camera {
  location  <-400,305,120>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     25
  look_at   <-390,290,100>
}

#declare Camera_Piano = camera {
  location  <-490,390,220>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     48
  look_at   <900,-2000,155>
//  focal_point < -340, 215, 200>
//  aperture 0.4     // a nice compromise
  //  aperture 0.05    // almost everything is in focus
  //  aperture 1.5     // much blurring
  //  blur_samples 4       // fewer samples, faster to render
//  blur_samples 10      // more samples, higher quality image
}

#declare Camera_Back = camera {
  location  <-900,-1600,550>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     30
  look_at   <200,-50,80>
}

#declare Camera_Ground = camera {
  location  <0,690,101>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0> 
  angle     45
  look_at   <0,0,101>
}

#declare Camera_Seat = camera {
  location  <250,-90,460>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     35
  look_at   <-050,-590,30>
}

#declare Camera_Wall = camera {
  location  <300,-130,599>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0> 
  angle     5
  look_at   <650,-1500,550>
}

#declare Camera_Stairs = camera {
  location  <600,-670,500>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0> 
  angle     20
  look_at   <800,-660,150>
}

#declare Camera_StageFront = camera {
  location  <100,-670,400>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0> 
  angle     30
  look_at   <0,-270,100>
}

#declare Camera_StageSat = camera {
  location  <0,200,6000>
  sky       <0,0,1>
  up        <0,0,1>
  right     <AspectRatio,0,0>
  angle     13
  look_at   <0,100,0>
}





//
// LIGHTS
//

#if (Speed=2)

light_source {
 <0,-500,1500>, <1,.97,.8>*3
}

#else

/*#declare Limelights=6;

#declare Index1=0;
  #while (Index1<Limelights)

light_source {
  <0,-890,200>, <1,.97,.8>*1 spotlight
  radius 30
  falloff 55
  tightness 0
  point_at <0,-600,100>
  rotate <0,0,25-Index1*10>
  translate <0,800,0>
}
  
#declare Index1 = Index1 + 1;
#end
*/
/*
light_source { //BackStageLeft
 <800,100,300>, <0,0,.8>*.1 spotlight
 radius 40
 falloff 50
 tightness 0
 point_at <600,-150,250>
}
*/
/*light_source { 
 <-370,290,200>, <1,.97,.8>*3 spotlight
 radius 40
 falloff 50
 tightness 10
 point_at <-380,330,100>
} */

/*light_source { //Piano spotlight
 <-330,380,200>, <1,.97,.8>*2 spotlight
 radius 40
 falloff 50
 tightness 10
 point_at <-355,340,100>
}

light_source { //Piano spotlight
 <-430,380,200>, <1,.97,.8>*2 spotlight
 radius 40
 falloff 50
 tightness 10
 point_at <-405,340,100>
} 

light_source { //Main stage light
 <-200,180,700>, <1,.97,.8>*.5 spotlight
 radius 30
 falloff 40
 tightness 10
 point_at <400,140,100>
}

light_source { //Main stage light
 <200,180,700>, <1,.97,.8>*.5 spotlight
 radius 30
 falloff 40
 tightness 10
 point_at <-400,140,100>
}
 
light_source { //Main stage light
 <-250,100,700>, <1,.97,.8>*3 spotlight
 radius 30
 falloff 40
 tightness 10
 point_at <200,340,100>
}

light_source { //Main stage light
 <250,100,700>, <1,.97,.8>*3 spotlight
 radius 30
 falloff 40
 tightness 10
 point_at <-200,340,100>
}

light_source { //Extra light
 <250,0,106>, <1,.97,.8>*2 spotlight
 radius 30
 falloff 40
 tightness 10
 point_at <-150,250,100>
}
*/
light_source {
 <500,400,700>, <1,.97,.8>*2 spotlight
 radius 40
 falloff 50
 tightness 10
 point_at <-250,350,100>
}

light_source {
 <-500,400,700>, <1,.97,.8>*2 spotlight
 radius 40
 falloff 50
 tightness 10
 point_at <250,350,100>
}

#declare Index1=0;
#while (Index1<4)
  light_source { //Piano spotlight
    <-20,20,25>, <1,.97,.8>*2 spotlight
    radius 32
    falloff 35
    tightness 10
    point_at <0,0,0>
    rotate z*(Index1*90)
    translate <-380,330,105>
  }
#declare Index1 = Index1 + 1;
#end

#end 

//
// TEXTURES AND MATERIALS
//

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


#declare Brass_Texture_1 = 
   material  // Brass_Texture_1
   {   
      texture
      {      
         pigment
         {
            color rgb <0.71, 0.65, 0.26>
         }      
         finish
         {
            ambient 0.1
            diffuse 0.7
            brilliance 3.0
            phong 0.75
            phong_size 80.0
            roughness 0.2
            metallic 1.0
            reflection
            {
               0.05 , 0.05
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }
   }


#declare DGray = texture {      
  pigment { color rgb <.644444,.555556,.555556> }      
  normal { wrinkles ,.3 }      
  finish {
    ambient .2
    phong .4
    phong_size 5.0
    roughness .9
    reflection {
      .05, .05
      fresnel  off
      falloff  1.0
      exponent 1.0
      metallic 1.0
    }
  }
}

#declare Bright_Bronze = texture {      
  pigment { color rgb <.2,.28,.36> }      
  finish {
    ambient .7
    diffuse .65
    brilliance 1.5
    specular .85
    roughness .01
    reflection {
      .2, .2
      falloff  1.0
      exponent 1.0
      metallic 2.0
    }
  }
}

#declare Chrome1 = 
   material  // Chrome1
   {   
      texture
      {      
         pigment
         {
            color rgb <0.84, 0.84, 0.84>
         }      
         finish
         {
            ambient 0.2
            diffuse 0.3
            brilliance 7.5
            phong 0.7
            phong_size 10.0
            roughness 0.9
            reflection
            {
               0.25 , 0.25
               metallic 1.0
            }
         }
      }
   }

#declare Chrome2 = 
   material  // Chrome1
   {   
      texture
      {      
         pigment
         {
            color rgb <0.84, 0.84, 0.84>*.8
         }      
         normal
         {
            bumps .1 scale .5
         }
         finish
         {
            ambient 0.1
            diffuse 0.5
            brilliance 7
            phong 0.5
            phong_size 10
            reflection
            {
               0.05 , 0.05
            }
         }
      }
   }

#declare ChromeTexture = 
   material  // ChromeTexture
   {   
      texture
      {      
         pigment
         {
            color rgb <0.658824, 0.658824, 0.658824>
         }      
         finish
         {
            ambient 0.3
            brilliance 10.0
            phong 1.0
            phong_size 20.0
            reflection
            {
               0.6 , 0.6
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }
   }

#declare DMFWood4 = 
   material  // DMFWood4
   {   
      texture
      {      
         pigment
         {
            wood
            color_map
            {
               [ 0.0     rgbft <0.888, 0.6, 0.3, 0.0, 0.0> ]
               [ 0.1     rgbft <0.888, 0.6, 0.3, 0.0, 0.0> ]
               [ 0.9     rgbft <0.6, 0.4, 0.2, 0.0, 0.0> ]
               [ 1.0     rgbft <0.6, 0.4, 0.2, 0.0, 0.0> ]
            }
            turbulence 0.04
            octaves 3
            ramp_wave
            scale  <0.05, 0.05, 1.0>
         }
      }
   }

#declare ExitSign = material {
  texture {
    pigment {
      image_map {
        jpeg "D:\Omat tiedostot\Grafiikka\Moray-materiaalit\exit.jpg"
//        filter all .5         
        once
        interpolate 2
      } 
    }
    scale  <47.5, 28.6, .02>*.5
    normal { dents .2 scale .6 }
    finish { ambient .6 phong .15 phong_size 5 }
  }
  interior { media { emission <.15,1,.75>*.5 } }
}

#declare Musta_kangas = 
   material  // Musta kangas
   {   
      texture
      {      
         pigment
         {
            color rgb <0.0, 0.0, 0.0>
         }      
         normal
         {
            planar , 0.001
            bump_size 0.001
         }      
         finish
         {
            ambient 0.1
            diffuse 0.3
            brilliance 0.0
            phong 0.05
            phong_size 5.0
            roughness 1.0
         }
      }
   }

#declare Kangas = 
   material  // Kangas
   {   
      texture
      {      
         pigment
         {
            bumps
            color_map
            {
               [ 0.0     rgbft <0.5729, 0.093733, 0.406233, 0.0, 0.0> ]
               [ 1.0     rgbft <0.864567, 0.4375, 0.593733, 0.0, 0.0> ]
            }
            scale .01        //.5
         }      
         normal
         {
            wrinkles , 0.05  //.5
            bump_size 0.01   //.1
         }
      }
   }
/*
#declare Velvet = material {   
      texture
      {      
         pigment
         {
            bumps
            color_map
            {
               [ 0.0     rgbft <0.5729, 0.093733, 0.206233, 0.0, 0.0>*.5 ]
               [ 1.0     rgbft <0.864567, 0.4375, 0.293733, 0.0, 0.0>*.5 ]
            }
            scale .5
         }      
         normal
         {
            wrinkles , 0.5
            scale 5
         }
      }
   }
*/
#declare Velvet = material {   
  texture {
    checker 
    texture {      
      pigment {
        bumps
        color_map
        {
          [ 0.0     rgbft <0.5729, 0.093733, 0.356233, 0.0, 0.0>*.3 ]
          [ 1.0     rgbft <0.864567, 0.4375, 0.493733, 0.0, 0.0>*.3 ]
        }
        scale .5
      }
      normal {
        average
        normal_map {
         [2, bumps .2 scale 10 ]
         [2, bumps .05 scale .05]
         [1, wrinkles , 0.5 scale 5 ]
        }
      }
      finish { ambient .1 diffuse .9 reflection { 0.01, 0.01 } phong .3 phong_size 15 }      
      scale 1000
    }
    texture {      
      pigment {
        bumps
        color_map {
          [ 0.0     rgbft <0.5729, 0.093733, 0.356233, 0.0, 0.0>*.3 ]
          [ 1.0     rgbft <0.864567, 0.4375, 0.393733, 0.0, 0.0>*.3 ]
        }
        scale .5
      }      
      normal {
        average
        normal_map {
          [2, bumps .5 scale 10 ]
          [2, bumps .05 scale .05]
          [1, wrinkles , 0.5 scale 5 ]
        }
      }
      finish { ambient .1 diffuse 1 phong .2 phong_size 20 }      
      scale 1000
    }
    scale .0005
  }
}

#declare BrightWhite = texture {
  pigment { color rgb 1 }
  finish { ambient 1 }
}

#declare Thin_Glass = texture {      
  pigment { color rgbf <1.0, 1.0, 1.0, .99999> }      
  finish {
    ambient 0
    diffuse 0
    phong 1.0
    specular 1.0
    roughness .001
    reflection {
      .1,.1
      falloff  1.0
      exponent 1.0
      metallic 0
    }
  }
}


#declare PDB_Tex_C = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 0.15
            specular 0.309333
            roughness 0.006177
         }
      }
   }

#declare Nuottipaperi1 = 
   material  // Nuottipaperi
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               sys   "D:\Omat tiedostot\Grafiikka\Moray-materiaalit\Vexations.bmp"
               once
               interpolate 2
            }
         }      
         finish { ambient .05 }
        scale <2.0, 2.0, 0.002>
         rotate -180*z
         translate <1.0, 1.0, 0.0>
      }
   }

#declare Nuottipaperi2 = 
   material  // Nuottipaperi
   {   
      texture
      {      
         pigment
         {
            image_map
            {
               sys   "D:\Omat tiedostot\Grafiikka\Moray-materiaalit\Gesualdo.bmp"
               once
               interpolate 2
            }
         }      
         finish { ambient .05 }
         scale <2.0, 2.0, 0.002>
         rotate -180*z
         translate <1.0, 1.0, 0.0>
      }
   }

#declare Tietokonemuovi = 
   material  // Tietokonemuovi
   {   
      texture
      {      
         pigment
         {
            color rgb <0.9479, 0.956231, 0.906233>
         }      
         finish
         {
            ambient 0.15
            diffuse 0.4
            brilliance 0.5
            specular 0.10933
            roughness 0.06177
         }
      }
   }

#declare WallTexture = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }
         normal {
           average
           normal_map {
              [1, bumps .5 scale 20 ]
              [1, bumps .6 scale .3 ]
           }
         }
         finish
         {
            ambient 0.0
            diffuse 0.6
         }
      }
   }

#declare WallTexture2 = 
   material
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>*.5
         }
         normal {
           average
           normal_map {
              [1, bumps .5 scale 20 ]
              [1, bumps .6 scale .3 ]
           }
         }
         finish
         {
            ambient 0.0
            diffuse 0.6
         }
      }
   }

#declare Pianopuu2 = 
   material  // Pianopuu
   {   
      texture
      {      
         pigment
         {
            color rgb <0.0, 0.0, 0.0>
         }      
         finish
         {
            ambient 0.1
            phong 0.453233
            phong_size 80.793333
            specular 0.676233
            roughness 0.01
            reflection
            {
               0.05 , 0.05
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }
   }

#declare PianopuuNormal = normal {
           average
           normal_map {
              [3, bumps .3 scale 5 ]                     //2, b...
              [1, wrinkles .01 scale <.02,.04,.03>*2 ]     //ripples
           }
         }   
#declare PianopuuA = texture {      
         pigment
         {
            color rgb <0.0, 0.0, 0.0>
         }      
         normal { PianopuuNormal }   
         finish
         {
            ambient 0.1
            phong 0.453233
            phong_size 15.793333
            specular 0.476233
            roughness 0.01
            reflection { 0.06 , 0.06 }
         }
}
#declare PianopuuB = texture {         
         pigment
         {
            color rgb <0.0, 0.0, 0.0>
         }      
         normal { PianopuuNormal }   
         finish
         {
            ambient 0.1
            phong 0.453233
            phong_size 25.793333
            specular 0.576233
            roughness 0.03
            reflection { 0.05 , 0.05 }
         }
}
#declare PianopuuC = texture {         
         pigment
         {
            color rgb <0.0, 0.0, 0.0>
         }      
         normal { PianopuuNormal }   
         finish
         {
            ambient 0.1
            phong 0.453233
            phong_size 35.793333
            specular 0.676233
            roughness 0.04
            reflection { 0.05 , 0.05 }
         }
}

#declare Pianopuu = material {
  texture {
    bozo
    texture_map {
      [0.1 PianopuuA]
      [0.7 PianopuuB]
      [1.0 PianopuuC]
    }
    scale 5
  }
}

#declare Lamppumetalli = 
   material  // Lamppumetalli
   {   
      texture
      {      
         pigment
         {
            color rgb <1.0, 1.0, 1.0>
         }      
         finish
         {
            ambient 1.0
            diffuse 0.8
            brilliance 0.0
            roughness 0.006177
         }
      }
   }

#declare Lasi = 
   material  // Lasi
   {   
      texture
      {      
         pigment
         {
            color rgbf <1.0, 1.0, 1.0, 0.95>
         }      
         finish
         {
            ambient 0.1
            diffuse 0.1
            phong_size 5.0
            specular 0.3
            roughness 0.001
            reflection
            {
               0.1 , 0.1
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }   
      interior
      {
         ior 1.5
      }
   }

#declare Lightwood = 
   material
   {   
      texture
      {      
         pigment
         {
            wood
            color_map
            {
               [ 0.0     rgbft <0.888, 0.6, 0.3, 0.0, 0.0> ]
               [ 0.1     rgbft <0.888, 0.6, 0.3, 0.0, 0.0> ]
               [ 0.9     rgbft <0.7, 0.35, 0.2, 0.0, 0.0> ]
               [ 1.0     rgbft <0.7, 0.35, 0.2, 0.0, 0.0> ]
            }
            turbulence 0.06
            octaves 3
            ramp_wave
            scale  <0.05, 0.75, 1.0>
         }
         normal { bumps .0005 scale .005 }
         finish { ambient 0.05 diffuse 0.5 }
      }
   }

#declare Ruskea_maali = 
   material  // Ruskea maali
   {   
      texture
      {      
         pigment
         {
            color rgb <0.337255, 0.172549, 0.172549>
         }      
         finish
         {
            ambient 0.1
            phong 0.2
            specular 0.1
            roughness 0.3
         }
      }
   }

//  $MRY$: 'Hieno parketti'


#declare ParquetWood1 = 
   texture  // txt_167_1_1_1
   {   
      pigment
      {
         marble
         color_map
         {
            [ 0.0     rgbft <0.54, 0.35, 0.25, 0.0, 0.0> ]
            [ 0.2     rgbft <0.54, 0.35, 0.25, 0.0, 0.0> ]
            [ 0.4     rgbft <0.57, 0.37, 0.24, 0.0, 0.0> ]
            [ 0.6     rgbft <0.56, 0.31, 0.21, 0.0, 0.0> ]
            [ 0.8     rgbft <0.56, 0.31, 0.21, 0.0, 0.0> ]
            [ 0.9     rgbft <0.57, 0.37, 0.24, 0.0, 0.0> ]
            [ 1.0     rgbft <0.54, 0.35, 0.25, 0.0, 0.0> ]
         }
         turbulence 0.25
         ramp_wave
         scale  <9.0, 9.0, 1.0>
      }   
      finish
      {
         ambient 0.3  //0.3
         diffuse 0.5  //0.5,0.9
      }
   }
   texture  // txt_168_1_1_1
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.4, 0.21, 0.15, 0.0, 0.0> ]
            [ 0.05    rgbft <0.4, 0.21, 0.15, 0.7, 0.0> ]
            [ 0.2     rgbft <0.4, 0.24, 0.14, 1.0, 0.0> ]
            [ 0.7     rgbft <0.4, 0.24, 0.14, 0.8, 0.0> ]
            [ 0.7     rgbft <0.3, 0.14, 0.02, 0.7, 0.0> ]
            [ 0.8     rgbft <0.3, 0.14, 0.02, 1.0, 0.0> ]
            [ 0.9     rgbft <0.3, 0.14, 0.02, 0.7, 0.0> ]
            [ 1.0     rgbft <0.25, 0.13, 0.09, 0.7, 0.0> ]
         }
         turbulence 0.3
         ramp_wave
         scale  <5.0, 10.0, 5.0>
         translate 5.0 * x
      }   
      finish
      {
         ambient 0.3  //0.3,0.6
         diffuse 0.4  //0.4,0.8
      }
   }
   texture  // txt_169_1_1_1
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.4, 0.21, 0.15, 0.0, 0.0> ]
            [ 0.05    rgbft <0.4, 0.21, 0.15, 0.4, 0.0> ]
            [ 0.2     rgbft <0.4, 0.24, 0.14, 0.8, 0.0> ]
            [ 0.7     rgbft <0.4, 0.24, 0.14, 0.9, 0.0> ]
            [ 0.7     rgbft <0.3, 0.14, 0.02, 0.8, 0.0> ]
            [ 0.8     rgbft <0.3, 0.14, 0.02, 0.6, 0.0> ]
            [ 0.9     rgbft <0.3, 0.14, 0.02, 0.4, 0.0> ]
            [ 1.0     rgbft <0.25, 0.13, 0.09, 0.8, 0.0> ]
         }
         turbulence 0.2
         ramp_wave
         scale  <4.0, 20.0, 4.0>
         translate 10.0 * x
      }   
      normal
      {
         dents , 0.2
         scale  <0.1, 0.1, 0.03>
         turbulence 0.85
         frequency 0.0
         ramp_wave
      }   
      finish
      {
         ambient 0.3
         diffuse 0.4 //0.4,0.8
         phong 0.1   //0.1,0.5
         phong_size 30.0 //20.0
         crand 0.1
      }
   }

#declare ParquetWood2 = 
   texture  // txt_168_1_1_2
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.4, 0.21, 0.15, 0.0, 0.0> ]
            [ 0.05    rgbft <0.4, 0.21, 0.15, 0.7, 0.0> ]
            [ 0.2     rgbft <0.4, 0.24, 0.14, 1.0, 0.0> ]
            [ 0.7     rgbft <0.4, 0.24, 0.14, 0.8, 0.0> ]
            [ 0.7     rgbft <0.3, 0.14, 0.02, 0.7, 0.0> ]
            [ 0.8     rgbft <0.3, 0.14, 0.02, 1.0, 0.0> ]
            [ 0.9     rgbft <0.3, 0.14, 0.02, 0.7, 0.0> ]
            [ 1.0     rgbft <0.25, 0.13, 0.09, 0.7, 0.0> ]
         }
         turbulence 0.3
         ramp_wave
         scale  <5.0, 10.0, 5.0>
      }   
      finish
      {
         ambient 0.3  //0.3,0.6
         diffuse 0.5  //0.5,0.9
      }
   }
   texture  // txt_169_1_1_2
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <0.4, 0.21, 0.15, 0.0, 0.0> ]
            [ 0.05    rgbft <0.4, 0.21, 0.15, 0.4, 0.0> ]
            [ 0.2     rgbft <0.4, 0.24, 0.14, 0.8, 0.0> ]
            [ 0.7     rgbft <0.4, 0.24, 0.14, 0.9, 0.0> ]
            [ 0.7     rgbft <0.3, 0.14, 0.02, 0.8, 0.0> ]
            [ 0.8     rgbft <0.3, 0.14, 0.02, 0.6, 0.0> ]
            [ 0.9     rgbft <0.3, 0.14, 0.02, 0.4, 0.0> ]
            [ 1.0     rgbft <0.25, 0.13, 0.09, 0.8, 0.0> ]
         }
         turbulence 0.2
         ramp_wave
         scale  <4.0, 20.0, 4.0>
      }   
      normal
      {
         dents , 0.2
         scale  <0.1, 0.1, 0.03>
         turbulence 0.85
         frequency 0.0
         ramp_wave
      }   
      finish
      {
         ambient 0.3  //0.3
         diffuse 0.5  //0.5,0.9 
         phong 0.1    //0.1,0.5
         phong_size 30.0 //20.0
         crand 0.1
      }
   }
   texture
   {   
      pigment
      {
         color rgbft <0.375, 0.177067, 0.0, 0.5, 0.5>
      }   
      normal
      {
         bumps , 0.001
      }   
      finish
      {
         ambient 0.4 //0.4
         phong 0.1 //0.1,0.2158
         phong_size 58.276667
      }
   }

#declare Hieno_parketti = 
   material  // Hieno parketti
   {   
      texture
      {
         checker
            texture { ParquetWood1 }
            texture { ParquetWood2 }
      }   
      scale  <0.1, 0.5, 0.03>
   }

#declare Punainen_maali = 
   material  // Punainen maali
   {   
      texture
      {      
         pigment
         {
            color rgb <0.6354, 0.0104, 0.1354>
         }
      }
   }

#declare WrinkleGray = texture {      
  pigment { color rgb <.45, .4, .4> }      
  normal { wrinkles, .3 }      
  finish {
    ambient .2
    diffuse .7
    phong .5
    phong_size 10.0
    roughness .9
    reflection {
      .05,.05
      falloff  1.0
      exponent 1.0
      metallic 2.0
    }
  }
}

#declare body_texture = texture {      
  pigment { color rgb <.31,.318,.231> }      
  finish {
    ambient .3
    diffuse .5
    phong .7
    phong_size 20.0
  }
}

#declare ChromeTexture2 = texture {      
  pigment { color rgb <0.698, 0.698, 0.698> }      
  finish {
    ambient 0.3
    brilliance 1.004
    phong_size 1.0
    roughness 0.001
    reflection {
      0.3 , 0.3
      falloff  1.0
      exponent 1.0
      metallic 0
    }
  }
}


#declare MaaAines = pigment {
  agate
  agate_turb 1.0
  pigment_map {  
    [0.0 color rgb <1.0, 0.9375, 0.0729>*.9]
    [1.0 color rgb <0.864567, 0.666667, 0.1354>*1]
  }
}

#declare MaaAines2 = texture {  
  pigment { MaaAines }
  scale 2
  normal { bumps .2 }
  scale .5
}


#declare Dull_Bronze = texture {      
  pigment { color rgb <.514286,.4,.285714> }      
  normal { wrinkles ,.1 }      
  finish {
    ambient 0.15
    diffuse 0.65
    specular 0.5
    roughness 0.01
    reflection {
      0.05 , 0.05
      falloff  1.0
      exponent 1.0
      metallic 5.0
    }
  }
}

#declare _auto_name_no_1_ = 
   texture  // txt_84
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <1.0, 0.85, 0.5, 0.0, 0.0> ]
            [ 0.5     rgbft <0.9, 0.7, 0.46, 0.0, 0.0> ]
            [ 0.7     rgbft <0.9, 0.7, 0.46, 0.0, 0.0> ]
            [ 1.0     rgbft <1.0, 0.85, 0.5, 0.0, 0.0> ]
         }
         turbulence 0.02
         octaves 4
         lambda 3.0
         ramp_wave
         scale  0.175
         rotate    <2.0, 2.0, 0.0>
      }
   }
   texture  // txt_85
   {   
      pigment
      {
         wood
         color_map
         {
            [ 0.0     rgbft <1.0, 0.45, 0.1, 0.8, 0.0> ]
            [ 0.5     rgbft <0.85, 0.65, 0.4, 0.4, 0.0> ]
            [ 0.7     rgbft <0.85, 0.65, 0.4, 0.4, 0.0> ]
            [ 1.0     rgbft <1.0, 0.45, 0.1, 0.8, 0.0> ]
         }
         turbulence 0.02
         octaves 4
         lambda 2.8
         ramp_wave
         scale  <0.2, 0.2, 0.2>
         rotate    <2.0, 2.0, 0.0>
         translate    <0.0175, 0.0175, 0.0175>
      }
   }

#declare T_Wood10 = 
   material  // T_Wood10
   {   
      texture { _auto_name_no_1_ }
   }

#declare Red = texture {
  pigment { color rgb <0.8, 0.2, 0.2> }
  finish { ambient 0.2 diffuse 0.5 }
}
  
#declare Black = texture {
  pigment { color rgb 0 }
  finish { ambient 0.2 diffuse 0.5 }
}





//
// TESTING
//

#declare OneMeter = box { <-5,2.5,0>, <5,2.5,80> texture { Red finish { ambient 1 } } }





//
// ********  REFERENCED OBJECTS  *******
//
#declare Tuoli = union {
  cylinder { // Tuolin_etujalka
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome1
    }
    scale <0.02, 0.02, 0.8>
    translate  <0.4, -0.4, 0.0>
  }
  cylinder { // Tuolin_etujalka1
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome1
    }
    scale <0.02, 0.02, 0.8>
    translate  <-0.4, -0.4, 0.0>
  }
  cylinder { // Tuolin_takajalka
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome1
    }
    scale <0.02, 0.02, 1.5>
    translate  <0.4, 0.4, 0.0>
  }
  cylinder { // Tuolin_takajalka1
    <0,0,1>, <0,0,0>, 1 
    material {
      Chrome1
    }
    scale <0.02, 0.02, 1.5>
    translate  <-0.4, 0.4, 0.0>
  }
  box { // Istuin
    <-1, -1, -1>, <1, 1, 1>
    scale <0.42, 0.4, 0.02>
    translate  <0.0, -0.02, 0.8>
    material { Kangas }
  }
  box { // Selkaenoja
    <-1, -1, -1>, <1, 1, 1>
    scale <0.42, 0.02, 0.2>
    translate  <0.0, 0.36, 1.29>
    material { Kangas }
  }
  rotate -180.0*z
  scale 50
//  translate  <-0.55, -1.2, 0>
}

#declare H7_valkoista_kosketinta = union {
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.3, 0.015>
    translate  <-1.057, -0.41, -0.01>
  }
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.3, 0.015>
    translate  <-1.0155, -0.41, -0.01>
  }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.3, 0.015>
    translate  <-0.974, -0.41, -0.01>
  }
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.3, 0.015>
    translate  <-0.9325, -0.41, -0.01>
  }
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.3, 0.015>
    translate  <-0.891, -0.41, -0.01>
  }
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.3, 0.015>
    translate  <-0.8495, -0.41, -0.01>
  }
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    scale <0.02, 0.3, 0.015>
    translate  <-0.808, -0.41, -0.01>
  }
  material {
    PDB_Tex_C
  }
}
#declare F5_mustaa_kosketinta = union {
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.25, 0.015>
    translate  <-0.995, -0.36, -0.01>
  }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.25, 0.015>
    translate  <-1.036, -0.36, -0.01>
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.25, 0.015>
    translate  <-0.871, -0.36, -0.01>
  }
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.25, 0.015>
    translate  <-0.829, -0.36, -0.01>
  }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    scale <0.01, 0.25, 0.015>
    translate  <-0.912, -0.36, -0.01>
  }
  material {
    Pianopuu
  }
  translate  0.01*z
}




#declare Pianon_kaikukoppa = difference {
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    scale <1.45, 0.28, 1.08>
  }
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.4, 0.5>
    rotate -9.21*x
    translate  <0.0, -0.63, 0.68>
  }
}
#declare Pianon_runko = union {
  object { Pianon_kaikukoppa }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.27, 0.13>
    translate  <-1.385, -0.49, 0.47>
  }
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    scale <0.025, 0.27, 0.13>
    translate  <1.385, -0.49, 0.47>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    scale <1.37, 0.07, 0.125>
    translate  <0.0, -0.35, 0.47>
  }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.26, 0.075>
    translate  <-1.265, -0.49, 0.42>
  }
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    scale <0.07, 0.26, 0.075>
    translate  <1.32, -0.49, 0.42>
  }
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    scale <1.37, 0.26, 0.06>
    translate  <0.0, -0.485, 0.4>
  }
  material {
    Pianopuu
  }
  translate  <0.0, 0.16, -0.64>
}
#declare Pianon_kansilevy = union {
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    scale <1.35, 0.16, 0.02>
    translate  <0.0, -0.16, -0.025>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 2.704>
    rotate <90.0, -0.0, 90.0>
    translate  <-1.352, -0.32, -0.025>
  }
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    scale <1.35, 0.01, 0.01>
    translate  <0.0, -0.33, -0.035>
  }
  material {
    Pianopuu
  }
  translate  0.005*z
}
#declare Nuottiteline = union {
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pianopuu
    }
    scale <1.348, 0.03, 0.014>
    translate  <0.0, -0.03, -0.015>
  }
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pianopuu
    }
    scale <1.348, 0.015, 0.046>
    translate  <0.0, -0.075, -0.047>
  }
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    material {
      Punainen_maali
    }
    scale <1.346, 0.042, 0.001>
    translate  <0.0, -0.045, -0.001>
  }
  rotate 122.0*x
  translate  <0.0, -0.25, -0.04>
}
#declare Pianon_kansi = union {
  object { Pianon_kansilevy }
  object { Nuottiteline }
  text {   // Pianoteksti
    ttf      "C:\WINDOWS\Fonts\Baskvill.ttf",
    "FAZER",
    0.1,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Brass_Texture_1
    }
    scale 0.08
    rotate <180.0, 0.0, -0.0>
    translate  <-0.12, -0.04, -0.039>
  }

  rotate -132.0*x
  translate  <0.0, -0.26, -0.045>
}
#declare Koskettimisto = union {
  object { H7_valkoista_kosketinta }
  object { // H7_valkoista_kosketinta1 -> 7 valkoista kosketinta
    H7_valkoista_kosketinta
    translate  0.2905*x
  }
  object { // H7_valkoista_kosketinta2 -> 7 valkoista kosketinta
    H7_valkoista_kosketinta
    translate  0.581*x
  }
  object { // H7_valkoista_kosketinta3 -> 7 valkoista kosketinta
    H7_valkoista_kosketinta
    translate  0.8715*x
  }
  object { // H7_valkoista_kosketinta4 -> 7 valkoista kosketinta
    H7_valkoista_kosketinta
    translate  1.162*x
  }
  object { // H7_valkoista_kosketinta5 -> 7 valkoista kosketinta
    H7_valkoista_kosketinta
    translate  1.4525*x
  }
  object { // H7_valkoista_kosketinta6 -> 7 valkoista kosketinta
    H7_valkoista_kosketinta
    translate  1.743*x
  }
  object { // H7_valkoista_kosketinta7 -> 7 valkoista kosketinta
    H7_valkoista_kosketinta
    translate  2.0335*x
  }
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_C
    }
    scale <0.02, 0.3, 0.015>
    translate  <-1.14, -0.41, -0.01>
  }
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    material {
      PDB_Tex_C
    }
    scale <0.02, 0.3, 0.015>
    translate  <-1.0985, -0.41, -0.01>
  }
  object { // F5_mustaa_kosketinta1 -> 5 mustaa kosketinta
    F5_mustaa_kosketinta
    translate  0.2905*x
  }
  object { // F5_mustaa_kosketinta2 -> 5 mustaa kosketinta
    F5_mustaa_kosketinta
    translate  0.581*x
  }
  object { // F5_mustaa_kosketinta3 -> 5 mustaa kosketinta
    F5_mustaa_kosketinta
    translate  0.8715*x
  }
  object { // F5_mustaa_kosketinta4 -> 5 mustaa kosketinta
    F5_mustaa_kosketinta
    translate  1.162*x
  }
  object { // F5_mustaa_kosketinta5 -> 5 mustaa kosketinta
    F5_mustaa_kosketinta
    translate  1.4525*x
  }
  object { // F5_mustaa_kosketinta6 -> 5 mustaa kosketinta
    F5_mustaa_kosketinta
    translate  1.743*x
  }
  object { // F5_mustaa_kosketinta7 -> 5 mustaa kosketinta
    F5_mustaa_kosketinta
    translate  2.0335*x
  }
  object { F5_mustaa_kosketinta }
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    material {
      Pianopuu
    }
    scale <0.01, 0.25, 0.015>
    translate  <-1.12, -0.36, 0.0>
  }
  translate  <0.0, 0.15, -0.15>
}

#declare Piano = union {
  object { Pianon_runko }
  object { Pianon_kansi }
  object { Koskettimisto }
  superellipsoid { // Pedaali
    <0.1, 0.1>
    material {
      Brass_Texture_1
    }
    scale <0.035, 0.1, 0.02>
    translate  <0.0, -0.21, -1.63>
  }
  superellipsoid { // Pedaali1
    <0.1, 0.1>
    material {
      Brass_Texture_1
    }
    scale <0.035, 0.1, 0.02>
    translate  <-0.14, -0.21, -1.63>
  }
  superellipsoid { // Pedaali2
    <0.1, 0.1>
    material {
      Brass_Texture_1
    }
    scale <0.035, 0.1, 0.02>
    translate  <0.14, -0.21, -1.63>
  }
  translate z*1.70
  scale 50
  bounded_by { box { <-75,-75,-1>, <75,75,120> } }
}

#declare RotSweep005 = lathe {
  linear_spline
  6  // control points
  <0.085, 0.0>,
  <0.085, 0.22>,
  <0.07, 0.26>,
  <0.085, 0.6>,
  <0.065, 0.605>,
  <0.065, 0.615>
  rotate <90,0,90>
  translate  0.205*z
}
// Include contains 'TransSweep020'
#include "koti.i37"

#declare TransSweep020 = object {
  TransSweep020_Raw
  rotate 90.0*x
  translate  0.02*y
}
// Include contains 'TransSweep021'
#include "koti.i38"

#declare TransSweep021 = object {
  TransSweep021_Raw
  rotate <90.0, 0.0, 90.0>
  translate  <-0.02, 0.02, 0.0>
}
#declare Pianotuolin_jalka = union {
  object { RotSweep005 }
  object { TransSweep020 }
  object { TransSweep021 }
  material {
    Pianopuu
  }
}
#declare CSG007 = difference {
  superellipsoid { // SuperQ003
    <1.0, 0.6>
    material {
      Musta_kangas
    }
    scale <0.37, 0.37, 0.07>
    translate  0.99*z
  }
  box { // Cube411
    <-1, -1, -1>, <1, 1, 1>
    material {
      Ruskea_maali
    }
    scale <0.35, 0.35, 0.04>
    translate  0.9*z
  }
}
#declare RotSweep006 = lathe {
  linear_spline
  5  // control points
  <0.025, -0.01>,
  <0.025, 0.065>,
  <0.045, 0.095>,
  <0.08, 0.095>,
  <0.09, 0.125>
  rotate <90,0,90>
  material {
    Ruskea_maali
  }
  translate  0.82*z
}
#declare Pianotuolin_istuin = union {
  object { CSG007 }
  object { RotSweep006 }

}
#declare Pianotuoli = union {
  object { Pianotuolin_jalka }
  object { Pianotuolin_istuin }
  scale 50
  bounded_by { box { <-50,-50,-1>, <50,50,75> } }
}



#declare Cloud = sphere {
  <0,0,0>, 1
  hollow
  rotate z*20
  
  material {
    texture {
      pigment { rgbf 1 }
    }
    interior {
      media {
        emission .75
        density {
          wood
          color_map {
            [0.0 rgb <1,.97,.7>*0]
            [0.92 rgb <1,.97,.7>*.01]
            [0.96 rgb <1,.97,.7>*.04]
            [1.0 rgb <1,.97,.7>*.1]
          }
          scale 10
          warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
          scale .1
          warp { turbulence <2,2,2> octaves 3 lambda 1.5 omega 0.3 }
        }
        density {
          spherical
        }
      }
    }
  }
}

#declare Cloud2 = sphere {
  <0,0,0>, 1
  hollow
  rotate z*20
  
  material {
    texture {
      pigment { rgbf 1 }
    }
    interior {
      media {
        emission .75
        density {
          wood
          color_map {
            [0.0 rgb <1,1,1>*0]
            [0.92 rgb <1,1,1>*.08]
            [0.96 rgb <1,1,1>*.32]
            [1.0 rgb <1,1,1>*.8]
          }
          scale 10
          warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
          scale .1
          warp { turbulence <2,2,2> octaves 3 lambda 1.5 omega 0.3 }
        }
        density {
          spherical
        }
      }
    }
  }
}

#declare LeftCurtain = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.642035, -0.843602, 0.015917>, <-0.821017, -0.843602, 0.013312>, <0.000000, -0.843602, 0.011043>, <0.821017, -0.843602, 0.000489>, 
      <-1.642035, -0.802235, 0.341017>, <-0.821017, -0.802235, 0.285203>, <0.000000, -0.802235, 0.236603>, <0.821017, -0.802235, 0.010467>, 
      <-1.642035, -0.561034, -0.341017>, <-0.821017, -0.561034, -0.285203>, <0.000000, -0.561034, -0.236603>, <0.821017, -0.561034, -0.010467>, 
      <-1.642035, -0.362042, 0.000000>, <-0.821017, -0.362042, 0.000000>, <0.000000, -0.362042, 0.000000>, <0.821017, -0.362042, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.642035, -0.362042, 0.000000>, <-0.821017, -0.362042, 0.000000>, <0.000000, -0.362042, 0.000000>, <0.821017, -0.362042, 0.000000>, 
      <-1.642035, -0.163049, 0.341017>, <-0.821017, -0.163049, 0.285203>, <0.000000, -0.163049, 0.236603>, <0.821017, -0.163049, 0.010467>, 
      <-1.642035, -0.095034, -0.224069>, <-0.821017, -0.095034, -0.187396>, <0.000000, -0.095034, -0.155463>, <0.821017, -0.095034, -0.006877>, 
      <-1.642035, 0.112618, -0.007058>, <-0.821017, 0.112618, -0.005903>, <0.000000, 0.112618, -0.004897>, <0.821017, 0.112618, -0.000217>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.642035, 0.112618, -0.007058>, <-0.821017, 0.112618, -0.005903>, <0.000000, 0.112618, -0.004897>, <0.821017, 0.112618, -0.000217>, 
      <-1.642035, 0.320270, 0.209952>, <-0.821017, 0.320270, 0.175589>, <0.000000, 0.320270, 0.145668>, <0.821017, 0.320270, 0.006444>, 
      <-1.642035, 0.491738, -0.244545>, <-0.821017, 0.491738, -0.204520>, <0.000000, 0.491738, -0.169669>, <0.821017, 0.491738, -0.007506>, 
      <-1.642035, 0.434347, 0.052757>, <-0.821017, 0.434347, 0.044123>, <0.000000, 0.434347, 0.036604>, <0.821017, 0.434347, 0.001619>
    }
  }
  material {
    Velvet
  }

  rotate <90, -90, 0>
  scale <100,50,300>
}
#declare RightCurtain = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.642035, -0.843602, 0.015917>, <-0.821017, -0.843602, 0.012763>, <0.000000, -0.843602, 0.009660>, <0.821017, -0.843602, 0.000845>, 
      <-1.642035, -0.762221, 0.279664>, <-0.821017, -0.762221, 0.224251>, <0.000000, -0.762221, 0.169722>, <0.821017, -0.762221, 0.014844>, 
      <-1.642035, -0.513594, -0.319453>, <-0.821017, -0.513594, -0.251883>, <0.000000, -0.513594, -0.185391>, <0.821017, -0.513594, 0.003463>, 
      <-1.642035, -0.338322, 0.010782>, <-0.821017, -0.338322, 0.010782>, <0.000000, -0.338322, 0.010782>, <0.821017, -0.338322, 0.010782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.642035, -0.338322, 0.010782>, <-0.821017, -0.338322, 0.010782>, <0.000000, -0.338322, 0.010782>, <0.821017, -0.338322, 0.010782>, 
      <-1.642035, -0.163049, 0.341017>, <-0.821017, -0.163049, 0.273447>, <0.000000, -0.163049, 0.206955>, <0.821017, -0.163049, 0.018101>, 
      <-1.642035, -0.095034, -0.224069>, <-0.821017, -0.095034, -0.179672>, <0.000000, -0.095034, -0.135982>, <0.821017, -0.095034, -0.011893>, 
      <-1.642035, 0.062068, 0.010945>, <-0.821017, 0.062068, 0.008776>, <0.000000, 0.062068, 0.006642>, <0.821017, 0.062068, 0.000581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.642035, 0.062068, 0.010945>, <-0.821017, 0.062068, 0.008776>, <0.000000, 0.062068, 0.006642>, <0.821017, 0.062068, 0.000581>, 
      <-1.642035, 0.219171, 0.245959>, <-0.821017, 0.219171, 0.197224>, <0.000000, 0.219171, 0.149267>, <0.821017, 0.219171, 0.013055>, 
      <-1.642035, 0.455773, -0.344062>, <-0.821017, 0.455773, -0.275889>, <0.000000, 0.455773, -0.208803>, <0.821017, 0.455773, -0.018262>, 
      <-1.642035, 0.558443, 0.105230>, <-0.821017, 0.558443, 0.083411>, <0.000000, 0.558443, 0.061940>, <0.821017, 0.558443, 0.000956>
    }
  }
  material {
    Velvet
  }
  rotate <90, -90, 0>
  scale <80,50,300>
}

#declare ExitLight = union {
  light_source { <12.5,7.5,1>, <.8,1,.8>*4 fade_distance 75 fade_power 2 }
  difference {
    box { <0,0,0>, <25,15,5> }
    box { <1,1,-1>, <23.5,13.5,6> }
    material { Brass_Texture_1 }
  }
  box {
    <0,0,0>, <47.5, 28.6, 1> hollow
    translate <2.5, 1.4, .5>
    scale .5
    texture { pigment { color rgbf <1,1,1,.5> } finish { ambient 1 } }
  }
  box {
    <0,0,0>, <47.5, 28.6, 1> hollow
    translate <2.5, 1.4, 8.5>
    scale .5
    material { ExitSign }
  }
  translate <-12.5, -7.5, .5>
}  
#declare TransSweep022 = prism {
  linear_sweep
  linear_spline
  -0.3,0.0
  7  // control points
  <-0.04, -0.07>,
  <0.04, -0.07>,
  <0.08, 0.0>,
  <0.04, 0.07>,
  <-0.04, 0.07>,
  <-0.08, 0.0>,
  <-0.04, -0.07>
  rotate -x*90
  material {
    Lightwood
  }
  photons {
    collect off
  }
  scale <0.1, 0.1, 1.0>
}
#declare CSG008 = intersection {
  object { TransSweep022 }
  cone { // Cone021
    <0,0,0>, 0.008, <0,0,1>, 0.0
    scale <10.25, 10.25, 0.3075>
  }
  material {
    Lightwood
  }
}
#declare CSG009 = intersection {
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    scale <0.0018, 0.0018, 0.31>
    translate  -0.001*z
  }
  cone { // Cone022
    <0,0,0>, 0.008, <0,0,1>, 0.0
    scale <10.25, 10.25, 0.3075>
  }
  material {
    Pianopuu
  }
}
#declare Lyijykynae = union {
  object { CSG008 }
  object { CSG009 }
  text {
    ttf "GOTHIC.ttf" "CRAYONS SATIE" .051, 0
    scale <.01,.01,.02>
    rotate <90,-90,0>
    translate <0.004,-0.006,0.02>
    material { Pianopuu }
  }
  text {
    ttf "GOTHIC.ttf" "2005" .051, 0
    scale <.01,.01,.02>
    rotate <90,-90,0>
    translate <0.004,-0.006,0.23>
    material { Pianopuu }
  }
  rotate z*180
  translate  <-0.02, 0.0, 0.01>
}
#declare Kartiolasi = difference {
  cone { // Cone014
    <0,0,0>, 0.055, <0,0,1>, 0.08
    scale <1.0, 1.0, 0.16>
  }
  cone { // Cone015
    <0,0,0>, 0.045, <0,0,1>, 0.077
    scale <1.0, 1.0, 0.14>
    translate  0.03*z
  }
  material {
    Lasi
  }

#declare SheetOfMusic1 = box {
  <-1, -1, -1>, <1, 1, 1>
  material {
    Nuottipaperi1
  }
  scale <0.248, 0.351, 0.001>*42.7
}
#declare SheetOfMusic2 = box {
  <-1, -1, -1>, <1, 1, 1>
  material {
    Nuottipaperi2
  }
  scale <0.248, 0.351, 0.001>*42.7
}

#declare Bolt = union {
  cylinder { <0,-.2,0>,<0,0.01,0>,0.1 }
  intersection {
    sphere { <0,-.05,0>, 0.25 }
    box { <-.3,0,-.3>,<.3,.3,.3> }
  }
}

#declare Screw = union { 
  cylinder { <0,-.5,0>,<0,0.85,0>,0.2 }
  cylinder { <0,0,0>,<0,1.1,0>,0.2 rotate z*45 translate y*.8 }
  cylinder { <0,0,0>,<0,1.1,0>,0.2 rotate z*-45 translate y*.8 }
  difference {
    torus { 0.35,0.2 rotate x*90 }
    box { <-1,-1,-1>,<0,1,1> }
    box { <-1,-1,-1>,<0,1,1> rotate z*45}
    translate <0.5,1.80,0>
  }
  difference {
    torus { 0.35,0.2 rotate x*90 }
    box { <0,-1,-1>,<1,1,1> }
    box { <0,-1,-1>,<1,1,1> rotate z*-45}
    translate <-0.5,1.80,0>
  }
  cylinder { <-.5,0,0>,<0.5,0,0>,0.2 translate y*2.15 }
}  

#declare Rim = union {
  box { <-1.3,0,6>,<1.3,0.1,25> } //Middle
  box { <-1.3,0,0>,<1.3,0.1,1.15> rotate x*30 translate <0,.5,4.95> }
  box { <-1.3,0.5,3>,<1.3,0.6,5> }
  box { <-.1,0.2,0>,<0.1,1.0,3.15> }
  object { Bolt translate <-0.8,0.3,24.1> }
  object { Bolt translate <0.8,0.3,24.1> }
  box { <-22.1,0.6,3.1>,<-0.1,0.7,4.5> } //Left holder
  box { <-22.1,0.69,3.2>,<-0.1,3.6,3.09> }
  object { Bolt translate <-0.8,0.7,3.8> }
  object { Bolt translate <-21.2,0.7,3.8> }
  box { <0.1,0.6,3.1>,<22.1,0.7,4.5> } //Right holder
  box { <0.1,0.69,3.2>,<22.1,3.6,3.09> }
  object { Bolt translate <0.8,0.7,3.8> }
  object { Bolt translate <21.2,0.7,3.8> }
  box { <-21.7,0.1,23.7>,<-0.3,0.2,24.5> } //Left rim
  box { <-21.6,0.2,3.2>,<-20.8,0.3,24.6> }
  object { Bolt translate <-21.2,0.3,24.1> }
  box { <0.3,0.1,23.7>,<21.7,0.2,24.5> } //Right rim
  box { <20.8,0.2,3.2>,<21.6,0.3,24.6> }
  object { Bolt translate <21.2,0.3,24.1> }
  box { <-0.5,0.3,-0.4>,<15,0.4,0.4> rotate y*315 translate <-21.3,0,3.8> } //Left hinge
  box { <-0.5,0.2,-0.4>,<15,0.3,0.4> rotate y*135 translate <-0.8,0,24.1> }
  object { Bolt translate <14.5,0.4,0> rotate y*315 translate <-21.3,0,3.8> }
  box { <-0.5,0.3,-0.4>,<15,0.4,0.4> rotate y*225 translate <21.3,0,3.8> } //Right hinge
  box { <-0.5,0.2,-0.4>,<15,0.3,0.4> rotate y*45 translate <0.8,0,24.1> }
  object { Bolt translate <14.5,0.4,0> rotate y*225 translate <21.3,0,3.8> }
}

#declare Tripod = union {
  
  #declare Index1=0;
  #while (Index1<3)
    union {
      box { <1,-0.1,-.4>, <19,0,0.4> rotate y*58.5 }
      cylinder { <19,-0.1,0>, <19,0,0>, 0.4 rotate y*58.5 }
      box { <-1.3,0.7,-.6>, <1.3,0.8,0.6> rotate z*90 translate z*-1.3}
      box { <1,0,-.4>, <35.5,0.1,0.4> rotate y*41 translate z*-7.5 }
      cylinder { <35.5,0,0>, <35.5,0.1,0>, 0.4 rotate y*41 translate z*-7.5 }
      box { <-1.3,0.7,-.6>, <1.3,0.8,0.6> rotate z*90 translate z*-8.5}
      object { Bolt translate <18.6,0.05,0> rotate y*58.5 }
      rotate z*(Index1*120)
    }
  #declare Index1 = Index1 + 1;
  #end
  object { Screw rotate <0,149,90> translate <0,0,-1.3> }
}  

#declare Stand = union {
  union {
    cylinder { <0,0,0>, <0,0,33>, 0.7 }
    cylinder { <0,0,32.8>, <0,0,34>, 1 }
    object { Screw rotate <0,20,-35> translate <0,0,33.4> }
    union {
      cylinder { <0,0,0>, <0,0,33>, 0.55 }
      cylinder { <0,0,32.8>, <0,0,34>, 0.85 }
      object { Screw rotate <0,51,40> translate <0,0,33.4> }
      union {
        cylinder { <0,0,0>, <0,0,34>, 0.4 }
        cylinder { <0,0,32.2>, <0,0,33.7>, 0.5 }
        box { <-.3,0.45,32.25>, <-.1,3.8,33.65> }
        box { <0.1,0.45,32.25>, <0.3,3.8,33.65> }
        object { Screw rotate <0,116,90> translate <0,2.5,32.95> }
        object { Rim rotate x*20 translate <0,2.5,32.95> }
        translate z*32.5 // Scale 1.5->32.5
      }
      translate z*32.5 // Scale 1.5->32.5
    }
    translate z*22
  }
  object { Tripod rotate z*25 translate z*31.15 }
  material { Pianopuu2 }
}

#declare Stand1 = union {
  object { Stand }
  object { SheetOfMusic2 rotate x*-88 translate <-4,0.6,18.2> rotate x*20 translate <0,2.5,32.95> translate z*87 }  
}

#declare Stand2 = union {
  object { Stand }
  object { SheetOfMusic2 rotate x*-88 translate <-11.5,0.6,18.2> rotate x*20 translate <0,2.5,32.95> translate z*87 }  
  object { SheetOfMusic2 rotate x*-88 translate <11,0.6,18.2> rotate x*20 translate <0,2.5,32.95> translate z*87 }  
}

#declare LowStand = union {
  union {
    cylinder { <0,0,0>, <0,0,33>, 0.7 }
    cylinder { <0,0,32.8>, <0,0,34>, 1 }
    object { Screw rotate <0,20,-35> translate <0,0,33.4> }
    union {
      cylinder { <0,0,0>, <0,0,33>, 0.55 }
      cylinder { <0,0,32.8>, <0,0,34>, 0.85 }
      object { Screw rotate <0,51,40> translate <0,0,33.4> }
      union {
        cylinder { <0,0,0>, <0,0,34>, 0.4 }
        cylinder { <0,0,32.2>, <0,0,33.7>, 0.5 }
        box { <-.3,0.45,32.25>, <-.1,3.8,33.65> }
        box { <0.1,0.45,32.25>, <0.3,3.8,33.65> }
        object { Screw rotate <0,116,90> translate <0,2.5,32.95> }
        object { Rim rotate x*40 translate <0,2.5,32.95> }
        object { SheetOfMusic2 rotate x*-88 translate <0.22,0.6,18.2> rotate x*40 translate <0,2.5,32.95> }  
        translate z*1.5 // Scale 1.5->32.5
      }
      translate z*20 // Scale 1.5->32.5
    }
    translate z*22
  }
  object { Tripod rotate z*35 translate z*30.9 }
  material { Pianopuu }
}

  // Scaling fixed
}

#declare Lukulampun_valo = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*5.0000      //3
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    75
    radius     35
    tightness  5.000
  fade_distance  1.0
  fade_power 1.0
  scale 0.1
  translate  <0, 0, -0.06>
}

#declare Lukulampun_haemy = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*3.0000      //2
  fade_distance  0.3
  fade_power 2.0                              //5
  scale 0.1
  translate  <0, 0, -0.02>
}
#declare Sphere055 = sphere {
  <0,0,0>,1
  scale <0.01, 0.005, 0.02>
  rotate -20.0*y
  translate  <0.05, 0.0, 0.17>
}
#declare Lukulampun_kupu = difference {
  sphere { <0,0,0>,1 scale <0.081, 0.081, 0.255> translate  -0.02*z }
  object { Sphere055 }
  box { <-1, -1, -1>, <1, 1, 1> scale <0.09, 0.09, 0.15> translate  -0.15*z }
  object { Sphere055 rotate <0.0, -0.0, -45.0> translate  <0.0, -0.0, 0.0> }
  object { Sphere055 rotate <-0.0, -0.0, -90.0> translate  <-0.0, 0.0, 0.0> }
  object { Sphere055 rotate <-0.0, -0.0, -135.0> translate  <-0.0, 0.0, 0.0> }
  object { Sphere055 rotate <-0.0, -0.0, -180.0> translate  <0.0, 0.0, 0.0> }
  object { Sphere055 rotate <0.0, -0.0, 135.0> translate  <0.0, 0.0, 0.0> }
  object { Sphere055 rotate <0.0, -0.0, 90.0> translate  <0.0, 0.0, 0.0> }
  object { Sphere055 rotate <0.0, -0.0, 45.0> translate  <0.0, -0.0, 0.0> }
  sphere { <0,0,0>,1 material { Lamppumetalli } scale <0.079, 0.079, 0.248704> translate  -0.02*z }
}
#declare PianoSpot = union {
  cylinder {
    <0,0,1>, <0,0,0>, 1 
    scale <0.01, 0.01, 0.02>*1
    translate  0.23*z
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1 
    scale <0.007, 0.007, 1>
    translate  0.25*z
//    material { Pianopuu }
  }
  object { Lukulampun_kupu }
  object { Lukulampun_valo }
  object { Lukulampun_haemy }
  cone { 
    <0,0,0>, 0.055, <0,0,1>, 0.035
    open
    material { Lamppumetalli }
    no_shadow
    photons { pass_through off }
    scale <1.0, 1.0, 0.055>
    translate  <0,0,0.142436>
  }
  material { Pianopuu }
  scale 6 
}
         



//
// THE INTERIOR
//

#declare Ground = cylinder {
  <0, -1000, 0>, <0, -1000, 1>, 2000
  texture { Red }
}

#declare Walls = union {
// Balcony walls
  difference {
    cylinder {
      <0,2000,570>, <0,2000,690>, 3810
    }
    cylinder {
      <0,2000,569>, <0,2000,691>, 3800
    }
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*-64.8
      translate <0,650,0>
    }  
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*64.8
      translate <0,650,0>
    }
    material { WallTexture }
  }
  difference {
    cylinder {
      <0,2000,580.1>, <0,2000,590.1>, 4300
    }
    cylinder {
      <0,2000,579>, <0,2000,591>, 3810
    }
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*-62
      translate <0,650,0>
    }  
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*62
      translate <0,650,0>
    }
    material { Hieno_parketti }
  }   
  difference {
    cylinder {
      <0,2000,590>, <0,2000,825>, 4310
    }
    cylinder {
      <0,2000,589>, <0,2000,826>, 4300
    }
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*-55.7
      translate <0,650,0>
    }  
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*55.7
      translate <0,650,0>
    }
    box {
      <-55,-4695,588>,<50,-5315,770>
      rotate z*9
      translate <0,2500,0>
    }
    box {
      <-50,-2295,588>,<50,-2315,770>
    }
    box {
      <-50,-4695,588>,<50,-5315,770>
      rotate z*-9
      translate <0,2500,0>
    }
    material { WallTexture }
  }
// Upper balcony walls
  difference {
    cylinder {
      <0,2000,800>, <0,2000,920>, 3810
    }
    cylinder {
      <0,2000,799>, <0,2000,911>, 3800
    }
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*-64.8
      translate <0,650,0>
    }  
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*64.8
      translate <0,650,0>
    }
    material { WallTexture }
  }
  difference {
    cylinder {
      <0,2000,810.1>, <0,2000,820.1>, 4300
    }
    cylinder {
      <0,2000,809>, <0,2000,821>, 3810
    }
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*-62
      translate <0,650,0>
    }  
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*62
      translate <0,650,0>
    }
    material { Hieno_parketti }
  }   
// Back wall
  difference {
    cylinder {
      <0,2000,369>, <0,2000,581>, 3910
    }
    cylinder {
      <0,2000,368>, <0,2000,582>, 3900
    }
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*-55.7
      translate <0,650,0>
    }  
    box {
      <-10000,0,-1>, <10000,5000,1002>
      rotate z*55.7
      translate <0,650,0>
    }
    box {
      <-50,-4195,368>,<50,-4815,550>
      rotate z*9
      translate <0,2500,0>
    }
    box {
      <-50,-1895,368>,<50,-1915,550>
    }
    box {
      <-50,-4195,368>,<50,-4815,550>
      rotate z*-9
      translate <0,2500,0>
    }
    material { WallTexture }
  }
/*
// Inner back walls
  box {
    <-300,-4400,370>,
    <300,-4410,580>
    rotate z*4.5
    translate <0,2500,0>
    material { WallTexture }
  }

  box {
    <-300,-4400,370>,
    <300,-4410,580>
    rotate z*-4.5
    translate <0,2500,0>
    material { WallTexture }
  }
// Back door walls
  box {
    <-55,-4408,550>,
    <55,-4418,580>

    translate <0,2500,0>
    material { WallTexture }
  }
  box {
    <-55,-4408,550>,
    <55,-4418,580>
    rotate z*-9
    translate <0,2500,0>
    material { WallTexture }
  }
  box {
    <-55,-4408,550>,
    <55,-4418,580>
    rotate z*9
    translate <0,2500,0>
    material { WallTexture }
  }
  box {
    <-85,-4410,370>,
    <-75,-4710,580>
    rotate z*9
    translate <0,2500,0>
//    texture { BrightWhite }
    material { WallTexture2 }
  }
  box {
    <75,-4410,370>,
    <85,-4710,580>
    rotate z*9
    translate <0,2500,0>
//    texture { BrightWhite }
    material { WallTexture2 }
  }
// Outer back walls
  box {
    <-300,-4400,370>,
    <300,-4410,580>
    rotate z*13.5
    translate <0,2500,0>
    material { WallTexture }
  }

  box {
    <-300,-4400,370>,
    <300,-4410,580>
    rotate z*-13.5
    translate <0,2500,0>
    material { WallTexture }
  }
*/
// Side walls
  box {
    <50,-1530,-10>,
    <60,-3700,580>
    rotate <0,0,22>
    translate <0,1200,0>
    material { WallTexture }
  }
  box {
    <-60,-1530,-10>,
    <-50,-3700,580>
    rotate <0,0,-22>
    translate <0,1200,0>
    material { WallTexture }
  }

// Side balcony walls
  box {
    <-70,-1500,570>,
    <-60,-3050,690>
    rotate <0,0,22>
    translate <0,1200,0>
    material { WallTexture }
//    texture { MaaAines2 }
  }
  box {
    <70,-1500,570>,
    <60,-3050,690>
    rotate <0,0,-22>
    translate <0,1200,0>
    material { WallTexture }
  }
  box {
    <-60,-1500,580>,
    <250,-3550,590>
    rotate <0,0,22>
    translate <0,1200,0>
    material { Hieno_parketti }
  }
  box {
    <-250,-1500,580>,
    <60,-3550,590>
    rotate <0,0,-22>
    translate <0,1200,0>
    material { Hieno_parketti }
  }
  box {
    <250,-1530,589>,
    <260,-3550,1000>
    rotate <0,0,22>
    translate <0,1200,0>
    material { WallTexture }
  }
  box {
    <-250,-1530,589>,
    <-260,-3550,1000>
    rotate <0,0,-22>
    translate <0,1200,0>
    material { WallTexture }
  }
// Upper side balcony walls
  box {
    <-70,-1500,800>,
    <-60,-3050,920>
    rotate <0,0,22>
    translate <0,1200,0>
    material { WallTexture }
  }
  box {
    <70,-1500,800>,
    <60,-3050,920>
    rotate <0,0,-22>
    translate <0,1200,0>
    material { WallTexture }
  }
  box {
    <-60,-1500,810>,
    <250,-3550,820>
    rotate <0,0,22>
    translate <0,1200,0>
    material { Hieno_parketti }
  }
  box {
    <-250,-1500,810>,
    <60,-3550,820>
    rotate <0,0,-22>
    translate <0,1200,0>
    material { Hieno_parketti }
  }
// Curtain walls  
  box {
    <-670, -205, 0>, <-485, -174, 1001>
    material { WallTexture }
  }

  box {
    <485, -205, 0>, <660, -174, 1001>
    material { WallTexture }
  }
// Stage side walls
  box {
    <-670, -81, 0>, <-485, 701, 1000>
    material { WallTexture }
  }
  
  box {
    <485, -81, 0>, <670, 701, 1000>
    material { WallTexture }
  }
// Stage door walls
  box {
    <-665, -176, 280>, <-655, -80, 1002>
    material { WallTexture2 }
  }
  
  box {
    <-510, -176, 280>, <-500, -80, 1002>
    material { WallTexture2 }
  }
  
  box {
    <655, -176, 280>, <665, -80, 1002>
    material { WallTexture2 }
  }
  
  box {
    <500, -176, 280>, <510, -80, 1002>
    material { WallTexture2 }
  }
// Stage back wall
  box {
    <-510, 700, 0>, <510, 710, 1001>
    material { WallTexture2 }
  }
}

#declare Banisters = union {
  union {
    cylinder {
      <41,-2500,125>,<41,-3900,475>, 2.8
      texture { ParquetWood2 }
    }
  
    #declare Rows=14;
    #declare Index1=0;
    #while (Index1<Rows)   //Index1=0: First step downwards; Index1=14: Ground level (0)
 
      cylinder {
        <41,-3800+Index1*100+4,450-Index1*25-1>, <41,-3800+Index1*100-4,450-Index1*25+1>, 3
        material { Chrome2 }
//        texture { BrightWhite }
      }
      box {
        <41,-3800+Index1*100+2,450-Index1*25-.7> <51,-3800+Index1*100-2,450-Index1*25+.7>
        material { Chrome2 }
      }
      
    #declare Index1 = Index1 + 2; //Posts at every other step
    #end
    translate <0,800,-20>
    rotate <0,0,22>
    translate <0,1200,0>
  }
  union {
    cylinder {
      <-41,-2500,125>,<-41,-3900,475>, 2.8
      texture { ParquetWood2 }
    }
  
    #declare Rows=14;
    #declare Index1=0;
    #while (Index1<Rows)   //Index1=0: First step downwards; Index1=14: Ground level (0)
 
      cylinder {
        <-41,-3800+Index1*100+4,450-Index1*25-1>, <-41,-3800+Index1*100-4,450-Index1*25+1>, 3
        material { Chrome2 }
      }
      box {
        <-41,-3800+Index1*100+2,450-Index1*25-.7> <-51,-3800+Index1*100-2,450-Index1*25+.7>
        material { Chrome2 }
      }
      
    #declare Index1 = Index1 + 2; //Posts at every other step
    #end
    translate <0,800,-20>
    rotate <0,0,-22>
    translate <0,1200,0>
  }
}

#declare Railings = union {
  union {
    cylinder {
      <-65,-1540,700>,<-65,-3042,700>, 2.8
      texture { ParquetWood2 }
    }
  
    #declare Index1=0;
    #while (Index1<5)
 
      cylinder {
        <-65,-2990+Index1*350+4,700>, <-65,-2990+Index1*350-4,700>, 3
        material { Chrome2 }
      }
      box {
        <-65.7,-2990+Index1*350+2,685> <-64.3,-2990+Index1*350-2,700>
        material { Chrome2 }
      }
      
    #declare Index1 = Index1 + 1;
    #end
    
    rotate <0,0,22>
    translate <0,1200,0>
  }
  union {
    cylinder {
      <65,-1540,740>,<65,-3042,700>, 2.8
      texture { ParquetWood2 }
    }
  
    #declare Index1=0;
    #while (Index1<5)
 
      cylinder {
        <65,-2990+Index1*350+4,700>, <65,-2990+Index1*350-4,700>, 3
        material { Chrome2 }
      }
      box {
        <65.7,-2990+Index1*350+2,685> <64.3,-2990+Index1*350-2,700>
        material { Chrome2 }
      }
      
    #declare Index1 = Index1 + 1;
    #end
    
    rotate <0,0,-22>
    translate <0,1200,0>
  }
  union {
    difference {
      torus {
        3805, 2.8
        rotate x*90
        translate <0,2000,700>
        texture { ParquetWood2 }
      }
      box {
        <-10000,0,-1>, <10000,5000,1002>
        rotate z*-64.9
        translate <0,650,0>
      }  
      box {
        <-10000,0,-1>, <10000,5000,1002>
        rotate z*64.9
        translate <0,650,0>
      }
      texture { ParquetWood2 }
    }
    #declare Index1=0;
    #while (Index1<8)
 
      cylinder {
        <-4,-3805,700>, <4,-3805,700>, 3
        material { Chrome2 }
        rotate z*(14-Index1*4)
        translate <0,2000,0>
      }
      box {
        <-2,-3805.7,689> <2,-3804.3,700>
        material { Chrome2 }
        rotate z*(14-Index1*4)
        translate <0,2000,0>
      }
      
    #declare Index1 = Index1 + 1;
    #end
  }
}

#declare StairLight = union {
  light_source {
    <0,1,3>, <1,.97,.8>*5 spotlight
    radius 30
    falloff 44
    tightness 0
    point_at <0,3,5>
  }
  difference {
    cylinder { <0,0,0>,<0,0,3>, 5 }
    cylinder { <0,0,-1>,<0,0,4>, 3.5 }
  }
  difference {
    sphere { <0,0,3>, 3.6 hollow }
    box { <-4,.8,-1>,<4,4,7> }
  }
  material { Chrome2 }
  rotate <-90,0,0>
  translate y*.1
}

#declare StairLights = union {
  #declare Rows=15;
  #declare Index1=0;
  #while (Index1<Rows)   //Index1=0: First step downwards; Index1=14: Ground level (0)
 
//    object { StairLight rotate <0,0,90> translate <50,-3800+Index1*100-50,350-Index1*25+12.5> translate <0,800,30> rotate <0,0,21> translate <0,1200,0> }
//    object { StairLight rotate <0,0,-90> translate <-50,-3800+Index1*100-50,350-Index1*25+12.5> translate <0,800,30> rotate <0,0,-21> translate <0,1200,0> }
      
    #local Radius=3800-(Index1*100)+13;
    #local StepLevel=350-(Index1*25)+25;
    #local Angle=22-(degrees(asin((1220/Radius)*sin(radians(158)))));

      object {
        StairLight
        rotate <0,0,90>
        translate <210,-Radius,StepLevel>
        rotate <0,0,Angle>
        translate <0,2000,30>
      }
      object {
        StairLight
        rotate <0,0,-90>
        translate <-210,-Radius,StepLevel>
        rotate <0,0,-Angle>
        translate <0,2000,30>
      }
      light_source {
        <0,0,0>, <1,.97,.8>*5 spotlight
        radius 30
        falloff 44
        tightness 0
        point_at <0,0.5,-1>
        translate <0,-Radius+1950,StepLevel+50>
      }
        

  #declare Index1 = Index1 + 1; //Lights at every step
  #end
}

#declare BalconyLights = union {
  #declare Index1=0;
  #while (Index1<5)
 
  #local Radius=2990-Index1*350;
    
  light_source {
    <-39,-Radius,565>, <1,.97,.8>*5 spotlight
    radius 40
    falloff 47
    tightness 0
    point_at <-30,-Radius,580>
    rotate <0,0,22>
    translate <0,1200,0>
  }
  light_source {
    <39,-Radius,565>, <1,.97,.8>*5 spotlight
    radius 40
    falloff 47
    tightness 0
    point_at <30,-Radius,580>
    rotate <0,0,-22>
    translate <0,1200,0>
  }
    

  #declare Index1 = Index1 + 1;
  #end
  
  #declare Index1=0;
  #while (Index1<8)
 
    light_source {
      <0,-3831,565>, <1,.97,.8>*5 spotlight
      radius 40
      falloff 47
      tightness 0
      point_at <0,-3840,580>
      rotate z*(14-Index1*4)
      translate <0,2000,0>
    }
    light_source {
      <0,-4279,565>, <1,.97,.8>*5 spotlight
      radius 40
      falloff 47
      tightness 0
      point_at <0,-4270,580>
      rotate z*(14-Index1*4)
      translate <0,2000,0>
    }  
    #declare Index1 = Index1 + 1;
    #end

}

#declare StageLight = light_source {
  <0,1,10>, <1,.97,.8>*5 spotlight
  radius 25
  falloff 40
  tightness 0
  point_at vrotate(<0,1,10>,<-29,0,0>)
  looks_like {
    difference {
      cylinder { <0,0,0>,<0,2,0>, 2.5 material { Chrome2 } }
      cylinder { <0,1.5,0>,<0,2.5,0>, 1.8 texture { BrightWhite } }
    }
    translate <0,0,-10>
  }
  translate <0,-.1,0>
}

#declare StageLights = union {
  
  #declare Limelights=6;
  #declare Index1=0;
  #while (Index1<Limelights)

    object {
      StageLight
      translate <0,-1285,102.5>
      rotate <0,0,15-Index1*6>
      translate <0,1000,0>
    }
  
#declare Index1 = Index1 + 1;
#end
}

#declare Door = box {
  <-46.4,-3,0.1>,<46.4,3,179.9>
  texture { ParquetWood2 }
  translate <46.5,0,0>
}

#declare DoorText = text {
  ttf "GOTHIC.ttf" "BACKSTAGE" .12, 0
  translate <-2.5,0,0>
  scale 10
  material { Chrome1 }
}
      
#declare Floor = difference {
  cylinder {
    <0,2000,0>, <0,2000,370>, 3900
    material { Hieno_parketti rotate z*90 scale 100 }
  }

  #declare Rows=14;
  #declare Index1=0;
  #while (Index1<Rows)   //Index1=0: First step downwards; Index1=14: Ground level (0)

    cylinder {
      <0,2000,349-(Index1*25)>, <0,2000,371+Index1>, 3800-(Index1*100)
       material { Musta_kangas scale 100 }
    }
      
  #declare Index1 = Index1 + 1;
  #end

  box {
    <-10000,0,-1>, <10000,5000,372>
    rotate z*-62
    material { Musta_kangas scale 100 }
    translate <0,650,0>
  }
    
  box {
    <-10000,0,-1>, <10000,5000,373>
    rotate z*62
    material { Musta_kangas scale 100 }
    translate <0,650,0>
  }
  bounded_by { box { <-1000,-150,1>, <1000,-150,375> } }
}


#declare Steps1 = intersection {
  box {
    <-50,0,-10>,
    <50,-3800,390>
    material { Hieno_parketti rotate z*90 scale 100 }
  }
  difference {

    cylinder {
      <0,2000,0>, <0,2000,370>, 3950
    }

    #declare Rows=14;
    #declare Index1=0;
    #while (Index1<Rows)   //Index1=0: First step downwards; Index1=14: Ground level (0)

      cylinder {
        <0,2000,349-(Index1*25)>, <0,2000,371+Index1>, 3800-(Index1*100)
      }
      
    #declare Index1 = Index1 + 1;
    #end
    
    translate <0,-1200,0>
    rotate <0,0,22>
  }
  
  cutaway_textures
  translate <0,1,1>
}  
  
#declare Steps2 = intersection {
  box {
    <-50,0,-10>,
    <50,-2600,390>
    material { Hieno_parketti rotate z*90 scale 100 }
  }
  difference {

    cylinder {
      <0,2000,0>, <0,2000,370>, 3950
    }

    #declare Rows=14;
    #declare Index1=0;
    #while (Index1<Rows)   //Index1=0: First step downwards; Index1=14: Ground level (0)

      cylinder {
        <0,2000,349-(Index1*25)>, <0,2000,371+Index1>, 3800-(Index1*100)
      }
      
    #declare Index1 = Index1 + 1;
    #end
  }
  
  cutaway_textures
  translate <0,1,1>
}

#declare Steps3 = intersection {
  box {
    <-50,0,-10>,
    <50,-3800,390>
    material { Hieno_parketti rotate z*90 scale 100 }
  }
  difference {

    cylinder {
      <0,2000,0>, <0,2000,370>, 3950
    }

    #declare Rows=14;
    #declare Index1=0;
    #while (Index1<Rows)   //Index1=0: First step downwards; Index1=14: Ground level (0)

      cylinder {
        <0,2000,349-(Index1*25)>, <0,2000,371+Index1>, 3800-(Index1*100)
      }
      
    #declare Index1 = Index1 + 1;
    #end 
    
    translate <0,-1200,0>
    rotate <0,0,-22>
  }
  
  cutaway_textures
  translate <0,1,1>
}    

#declare Bottom = cylinder {
  <0,2000,20>, <0,2000,25>, 2450
  material { Hieno_parketti rotate z*90 scale 100 }
}

#declare Stage = union {
  intersection {
  box {
    <-550, -300, 0>, <550, 700, 100>
    material { Hieno_parketti scale 50 }
  }
  cylinder {
    <0,1000,-1>, <0,1000,101>, 1299
    material { WallTexture }
  }
  }
  intersection {
    difference {
      cylinder { <0,1000,99>, <0,1000,105>, 1300 }
      cylinder { <0,1000,98>, <0,1000,106>, 1285 }
    }
    box { <-470, -300, 97>, <470, 0, 107> }
    texture { ParquetWood1 }
  }
}
      

#declare Audience = union {
  #declare Rows=14;
  #declare Index1=0;
  #while (Index1<Rows)

    #declare Radius=3800-(Index1*100)-23;
    #declare ShiftAngle=degrees(atan2(45,Radius));
    #declare Threshold=22-(degrees(asin((1220/Radius)*sin(radians(158)))));

    #declare Index2=0;
    #while (Index2*ShiftAngle<Threshold)
      
      object {
        Tuoli
        translate <0,-Radius,350-(Index1*25)>
        rotate <0,0,Index2*ShiftAngle>
        translate <75,2000,0>
      }

      object {
        Tuoli
        translate <0,-Radius,350-(Index1*25)>
        rotate <0,0,-Index2*ShiftAngle>
        translate <-75,2000,0>
      }

    #declare Index2 = Index2 + 1;
    #end

  #declare Index1 = Index1 + 1;
  #end
  bounded_by { box { <-1000,-150,1>, <1000,-150,500> } }
}

/*#declare LightingScreen = box {
  <-1000,300,13000>, <1000,-3000,13000>
  texture {
  pigment { color rgb 1 }
//    pigment { color rgb <0.864567, 0.4375, 0.593733> }
    finish { ambient .5 }
  }
}
*/
#declare Interior = union {
//  object { Ground }
  object { Walls }
#if (Speed=0)  object { BalconyLights } object { BalconyLights translate z*230 } #end
  object { Door rotate <0,0,70> translate <660,-128-46.5,100> }
  object { ExitLight rotate <90,0,90> translate <-501,-128,295> }
  object { DoorText rotate <90,0,90> translate <-501,-128,310> }
  object { Door rotate <0,0,100> translate <-660,-128-46.5,100> }
  object { ExitLight rotate <90,0,-90> translate <501,-128,295> }
  object { DoorText rotate <90,0,-90> translate <501,-128,310> }
#if (Speed=0)
  object { ExitLight rotate <90,0,180> translate <0,-4395,565> rotate z*-9 translate <0,2500,0> } //Floor
  object { ExitLight rotate <90,0,180> translate <0,-1905,565> }                                  
  object { ExitLight rotate <90,0,180> translate <0,-4395,565> rotate z*9 translate <0,2500,0> }  
  object { ExitLight rotate <90,0,180> translate <0,-4795,780> rotate z*-9 translate <0,2500,0> } //Balcony
  object { ExitLight rotate <90,0,180> translate <0,-2305,780> }
  object { ExitLight rotate <90,0,180> translate <0,-4795,780> rotate z*9 translate <0,2500,0> }
#end
  object { Floor }
  object { Steps1 rotate <0,0,-22> translate <0,1200,0> }
  object { Steps1 translate <0,50,-12.5> rotate <0,0,22> translate <0,1200,0> }
  object { Steps2 }
  object { Steps2 translate <0,50,-12.5> }
  object { Steps3 rotate <0,0,22> translate <0,1200,0> }
  object { Steps3 translate <0,50,-12.5> rotate <0,0,-22> translate <0,1200,0> }
  object { Banisters }
  object { Railings }
#if (Speed=0) object { StairLights } #end
  object { Bottom }
  object { Stage }
#if (Speed=0) object { StageLights } #end
  object { LeftCurtain translate <-440,-200,593> }
  object { RightCurtain translate <395,-200,593> }
  object { Audience }
//  object { LightingScreen }
//  object { Cloud rotate z*30 scale <2000,1000,120>*.7 translate <400,-3200,1500>}
}




//
// THE OBJECTS
//



#declare PianoSystem = union {
  object { Piano rotate z*180 }
  object { SheetOfMusic1 rotate <-66,0,0> translate <0,1,107.5>}
  object { Pianotuoli translate <0,70,0> }
}

#declare Objects = union {
  object { PianoSystem scale .1 rotate z*100 translate <-380,330,100> } //340,215,100
//  object { SheetOfMusic scale 50 rotate <0,0,60> translate <-320,325,100>}
//  object { Kartiolasi scale 50 translate <-290,210,100> }
  object { Lyijykynae scale 50 rotate <90,0,250> translate <-385,290,100.35> } 
//  object { Pianotuoli scale 2 rotate z*120 translate <-380,330,100> }
  object { Stand translate <-380,330,100> }
  object { Stand rotate z*105 translate <450,-55,100> }
  object { LowStand rotate z*5 translate <-100,153,100> }
  object { Stand1 rotate z*2 translate <0,-120,100> }
  object { LowStand rotate z*-15 translate <-154,-80,100> }
  object { PianoSpot translate <-380,330,118> }

//  object { Tuoli rotate z*170 translate <-150,-40,100> }
  
}

// THE MAIN CONTROLS

camera { // options: Sat, Far, Near, New, Piano, Back, Ground, Seat, Wall, Stairs, StageFront, StageSat
  Camera_Near
}

object { Interior }
object { Objects }