

/////////////////////////
//     Declarations    //
/////////////////////////
// //  //  //  //  //  //
 //  //  //  //  //  //
#include "woods.inc"
#include "finish.inc"
#include "textures.inc"

#declare radiosityrender = on;
#declare glass = on;
#declare baseswoodtexture = texture { T_Wood1 };
#declare rodswoodtexture = texture { T_Wood1 rotate x*90 };
// //  //  //  //  //  //
 //  //  //  //  //  //
/////////////////////////
//     Declarations    //
/////////////////////////

 
/////////////////////////
// Camera and Lighting //
/////////////////////////
// //  //  //  //  //  //
 //  //  //  //  //  //
camera { location <0,1,-5>
        look_at <0,0,0>
        up y right x*image_width/image_height
        rotate y*-20
        }

light_source {
  0*x
  color rgb <1,1,1>
  translate <20, 10, -20>*200
}
light_source {
  0*x
  color rgb <0.7,0.5,1>
  translate <20, 10, 20>*200
}
// //  //  //  //  //  //
 //  //  //  //  //  //
/////////////////////////
// Camera and Lighting //
/////////////////////////

/////////////////////////
//Creation Of HourGlass//
/////////////////////////
// //  //  //  //  //  //
 //  //  //  //  //  //
union {
//Top
lathe {
  quadratic_spline
  10,
  <0, -0.1>, <0, -0.1>, <1, -0.1>, <1.1, 0>, <1, 0.1>, <1, 0.2>, <1.1, 0.2>, <1.1, 0.3>, <0, 0.3>, <0, 0.3>
  texture { baseswoodtexture }
  finish { Glossy }
translate y*1.7
}
//Posts
lathe {
  quadratic_spline
  17,
  <0, 1.6>, <0, 1.6>, <0.2, 1.6>, <0.2, 1.5>, <0.1, 1.4>, <0.1, 1.2>, <0.2, 0.9>, <0.2, 0.7>, <0.1, 0.6>, <0.1, 0>, <0.2, -0.8>, <0.2, -1.1>, <0.1, -1.5>, <0.2, -1.5>, <0.2, -1.6>, <0, -1.6>, <0, -1.6>
  texture { rodswoodtexture }
  finish { Glossy }
  scale <.7,1,.7>
  translate <0.8,0,0>
}
lathe {
  quadratic_spline
  17,
  <0, 1.6>, <0, 1.6>, <0.2, 1.6>, <0.2, 1.5>, <0.1, 1.4>, <0.1, 1.2>, <0.2, 0.9>, <0.2, 0.7>, <0.1, 0.6>, <0.1, 0>, <0.2, -0.8>, <0.2, -1.1>, <0.1, -1.5>, <0.2, -1.5>, <0.2, -1.6>, <0, -1.6>, <0, -1.6>
  texture { rodswoodtexture }
  finish { Glossy }
  scale <.7,1,.7>
  translate <-0.8,0,0>
}
lathe {
  quadratic_spline
  17,
  <0, 1.6>, <0, 1.6>, <0.2, 1.6>, <0.2, 1.5>, <0.1, 1.4>, <0.1, 1.2>, <0.2, 0.9>, <0.2, 0.7>, <0.1, 0.6>, <0.1, 0>, <0.2, -0.8>, <0.2, -1.1>, <0.1, -1.5>, <0.2, -1.5>, <0.2, -1.6>, <0, -1.6>, <0, -1.6>
  texture { rodswoodtexture }
  finish { Glossy }
  scale <.7,1,.7>
  translate <0,0,0.8>
}
lathe {
  quadratic_spline
  17,
  <0, 1.6>, <0, 1.6>, <0.2, 1.6>, <0.2, 1.5>, <0.1, 1.4>, <0.1, 1.2>, <0.2, 0.9>, <0.2, 0.7>, <0.1, 0.6>, <0.1, 0>, <0.2, -0.8>, <0.2, -1.1>, <0.1, -1.5>, <0.2, -1.5>, <0.2, -1.6>, <0, -1.6>, <0, -1.6>
  texture { rodswoodtexture }
  finish { Glossy }
  scale <.7,1,.7>
  translate <0,0,-0.8>
}
//Bottom
lathe {
  quadratic_spline
  10,
  <0, -0.1>, <0, -0.1>, <1, -0.1>, <1.1, 0>, <1, 0.1>, <1, 0.2>, <1.1, 0.2>, <1.1, 0.3>, <0, 0.3>, <0, 0.3>
  texture { baseswoodtexture }
  finish { Glossy }
  translate y*1.7
  scale <1,-1,1>
}
//Glass
#if (glass)
difference {
lathe {
  cubic_spline
  12,
  <0, -1.6>, <0, -1.6>, <0.5, -1.6>, <0.5, -1>, <0.4, -0.5>, <0.1, -0.1>, <0.1, 0.1>, <0.4, 0.5>, <0.5, 1>, <0.5, 1.6>, <0, 1.6>, <0, 1.6>
  pigment { color rgbt <1,1,1,.9> }
  finish { Metallic_Finish }
  interior { ior 1.5 }
  scale <1,1,1>
}
lathe {
  cubic_spline
  12,
  <0, -1.6>, <0, -1.6>, <0.5, -1.6>, <0.5, -1>, <0.4, -0.5>, <0.08, -0.1>, <0.08, 0.1>, <0.4, 0.5>, <0.5, 1>, <0.5, 1.6>, <0, 1.6>, <0, 1.6>
  pigment { color rgbt <1,1,1,.99> }
  scale <.9,1,.9>
}
}
#end
//FeetBalls
sphere { <0, 0, 0>, 0.1 
   translate <-1,-2.05,0> 
  texture { baseswoodtexture }
  finish { Glossy } }
sphere { <0, 0, 0>, 0.1 
   translate <1,-2.05,0> 
  texture { baseswoodtexture }
  finish { Glossy } }
sphere { <0, 0, 0>, 0.1 
   translate <0,-2.05,-1> 
  texture { baseswoodtexture }
  finish { Glossy } }
sphere { <0, 0, 0>, 0.1 
   translate <0,-2.05,1> 
  texture { baseswoodtexture }
  finish { Glossy } }
   
scale <1.10,.75,1.10>
scale <1.10,1,1.10>
translate x*-1
rotate <15,0,15>
translate <0,0,0>
}
// //  //  //  //  //  //
 //  //  //  //  //  //
/////////////////////////
//Creation Of HourGlass//
/////////////////////////



//CREATION OF THE GALAXY//

   #declare galaxy_seed = (clock - .0001) * 2e5;
   #declare debug_options = true;
   #include "GALAXY.INC"
                           //0.2, 0.7, .0001 

#if (radiosityrender)
// radiosity (global illumination) settings
global_settings {
  radiosity {
    pretrace_start 0.28           // start pretrace at this size
    pretrace_end   0.0004           // end pretrace at this size
    count 70                      // higher -> higher quality (1..1600) [35]
    nearest_count 8               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
  }
}
#end