// Persistence of Vision Ray Tracer Scene Description File
// File: Magnet.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: 31/10/05
// Auth: GRAPHIKTO
// http://inmyotherworld.free.fr

#version 3.6;

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "finish.inc"

#include "isowood3.inc"
#include "iw_textures.inc"

#declare IW_Quality = 2;
#declare IW_ISOmaxgrad = 2;


// You can download these includes files here : http://inmyotherworld.free.fr/pov_01.htm
#include "trombone.inc"
#include "can.inc"
#include "pens.inc"
#include "gobelets.inc"


global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------
// focal blur camera
camera {
  location  <200, 150, -250>
  look_at   <100, 10,  0>
  right     x*image_width/image_height
  angle 53
  aperture 7           // [0...N] larger is narrower depth of field (blurrier)
  blur_samples 20        // number of rays per pixel for sampling
  focal_point <40,10,0>    // point that is in focus <X,Y,Z>
  confidence 1           // [0...<1] when to move on while sampling (smaller is less accurate)
  variance 1/500            // [0...1] how precise to calculate (smaller is more accurate)
}


sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}



light_source {
  <4000, 3000, -3000>  // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
}

// ----------------------------------------
#declare Rouge = texture { pigment { color rgb <1,0,0> } finish { Dull  } }
#declare Bleu = texture { pigment { color rgb <0,0,1> } finish { Dull }}
#declare Gris = texture { pigment { color rgb <0.3,0.3,0.3> } finish { Dull }}
#declare Aspect = normal { wrinkles 0.1 scale 1 } 
#declare P_M_Wood10A = pigment { P_IW_06 color_map { M_Wood10A }}
// ----------------------------------------


object { IW_Plank_Round_Cut (1400, 1400, 10, 1400, 4, 4, 0.02, 0.002, 0.005, P_M_Wood10A, Fin_W , Norm_W)
          translate < -800, -10, -200>
          scale 150
          }



#declare DemiC1 = difference {
     cylinder { 0*y,  20*y,  40 }
     cylinder { -10*y,  30*y,  20 }}

#declare DemiC2 = difference {
     object { DemiC1 }
     box { <0, -10, -50>, <50, 30, 50> }}

#declare Magnet1= union {
     object { DemiC2 }
     box { <0, 0, 20>, <40, 20, 40> } 
     box { <0, 0, -20>, <40, 20, -40> } 
     texture { Gris normal { Aspect }  } }


#declare Magnet= union {
     object { Magnet1 }
     box { <40, 0, 20>, <70, 20, 40> texture { Bleu normal { Aspect } } }
     box { <40, 0, -20>, <70, 20, -40> texture { Rouge normal { Aspect } } }
}



// Ici les trombones prs de l'aimant
object { Trombone rotate <0,-17,0> translate <40,20.5,-35> }  //Trombone sur le bout rouge
object { Trombone rotate <0,10,-5> translate <70,5,-30> }
object { Trombone rotate <0,160,0> translate <142,.5,-18.5> }
object { Trombone rotate <0,11,0> translate <117,.5,-35> }
object { Trombone rotate <0,5,0> translate <140,0.5,-25> }

object { Magnet  }

object { Trombone rotate <90,0,37> translate <37,3,19.5> }  //Trombone 1 sur le bout bleu
object { Trombone rotate <0,67,90> translate <70.5,5,54> }  //Trombone 2 sur le bout bleu
object { Trombone rotate <0,-5,0> translate <70,0.5,30> }
object { Trombone rotate <0,-7,0> translate <109.5,0.5,30> }
object { Trombone rotate <0,14,0> translate <133,1.5,39> }
object { Trombone rotate <0,-14,0> translate <155,0.5,30>}
object { Trombone rotate <0,33,0> translate <191,0.5,33> }

object { Can rotate 70*y translate <-170,0,270> }
object { GobeletB translate <21,0,180> }
object { Can rotate -40*y translate <150,0,250> }
object { Trombone rotate <0,-27,0> translate <37,.5,-150> }
object { Trombone rotate <0,143,0> translate <97,.5,-135> }
object { PenOB  rotate <-27,14,0> translate <14,0.51,-13> scale 10 }
object { PenCR  rotate <-47,-37,0> translate <31,0.51,-1> scale 10 }
object { Trombone rotate <0,-27,0> translate <211,0.5,150> }



