// testing Chessmen
#ifndef(Get)
 global_settings {max_trace_level 30}
 #include "colors.inc"
 #include "shapes.inc"
 #include "functions.inc"
 #include "Math.inc"
 #include "transforms.inc"

 #declare At=<0,20,0>;//<5,0,-5>; // 
 #declare Lat=<0,0,0>; 
 camera{ location At
         look_at Lat
       }
 //light_source{ <0,0,-100> color White }
 background {rgb<.5,.5,1>}
 //plane {y,-2 pigment{Gold}}
 //light_source{ <-200,0,0> color White}
 //light_source{ <200,0,0> color White}
 light_source{ <0,200,-60> color White}
 //light_source{ <0,-200,0> color White}
 light_source{ <0,0,-200> color White}
 light_source{ <0,0,200> color White}
#end

#macro CLoc(St)
  #local A= (asc(St)-65);
  #local B= (val(substr(St,2,1))-1);
  #declare C=0; #if ((A<0)|(A>7)) #declare C=-.1; #end
   #if ((B<0)|(B>7)) #declare C=-.1; #end
  translate <3.5-A,C,3.5-B>
 //#declare V=<A,C,B>;
 //#debug concat("abc <", vstr(3, V, ",", 1,1), ">\n")
#end
//table
#declare CTab=union{
 box{<-6,0,-6>,<6,-.1,6> pigment{Brown}}
 box{<-5.5,-2,-5.5>,<5.5,-.1,5.5> pigment{Brown}}
 box{<-4,0,-4>,<4,.1,4> pigment{checker White Gray40}}// chess board  
}
#include"pawn.lat"
#declare Pawn=union{object{Thing} sphere{-y*1.2,.3}  
              rotate z*180 translate y*.15 scale<.7,.8,.7>}
#include"Rook.lat"
#declare Rook=intersection{object{Thing}
  box{<-1,-1.08,.05> ,<1,-1.5,-.05> inverse} 
  box{<-1,-1.08,.05> ,<1,-1.5,-.05> rotate y*60 inverse} 
  box{<-1,-1.08,.05> ,<1,-1.5,-.05> rotate -y*60 inverse} 
  rotate z*180  translate y*.1 scale<.8,1.2,.8>}
//--------- knight-----------------------
#include"Knite3.prm"
#declare Knite=object{Thing translate -y*.25 rotate -x*90  scale<.8,1.5,.8>}
#include"Kns1.prm"
#declare Kns1=object{Thing translate -y*.95 rotate -x*90  scale<.8,1.5,.8>}
#include"Kns2.prm"
#declare Kns2=object{Thing translate -y*.95 rotate <-90,180,0> scale<.8,1.5,.8>}

#declare Knight=union{
 intersection{
 sphere_sweep {linear_spline 5,    
    <0, 0, 0>, .2 <-.01, .75, 0>, .4   
    <.05,1, 0>, .27 <.1,1.2, 0>,.2 < 0,1.4, 0>, .1 
      scale<1,1,.5> }//rotate -y*90
 box{<-1,.2,-1>,<1,3,1>}
 }


 object{Knite  scale<1.2,1,.1> translate y*.4 }
 intersection{object{Kns1  scale<.57,.5,.5>}
 sphere{<-.08,.58,.1>,.1 inverse}
 translate <0,1.19,.04> }

 sphere{<-.08,1.77,.01>,.05 inverse}

 intersection{object{Kns2  scale<.57,.5,.5>}
 sphere{<-.08,.58,-.1>,.1 inverse}
 translate <0,1.19,-.04> }

 sphere{<-.08,1.77,-.01>,.05 inverse}

 #include"Knbase.lat"
 object{Thing rotate z*180  translate y*.1 scale<.8,1.2,.8>}
 
}

#include"Bish.lat"
#declare Bish=intersection {torus{.5,.04 scale <1,1,.6> rotate -z*45 translate <.18,.9,0> inverse}
object{Thing rotate z*180} translate y*.1 scale<.8,1.3,.8>}

#include"Queen.lat"
#declare Quen=union{
 #declare Cnt=0;
 #while(Cnt<360) 
  sphere{<.28,1.88,0>,.05 rotate y*Cnt}
 #declare Cnt=Cnt+20;
 #end 
  object{Thing rotate z*180 translate y*.1 scale<.8,1.2,.8>}
}
  
#include"King3.lat"
#declare King=union{box{<.17,2.3,.05>,<-.17,2.4,-.05>}
         box{<.06,2,.05>,<-.06,2.55,-.05>}
         cone{y*2.2,0,y*2.1,.2}
         object{Thing rotate z*180 translate y*.1 scale<.8,1.2,.8>}
         }
#declare Fin1= finish{ambient .2 diffuse .5 phong .5 phong_size 190 brilliance 1
                     irid {0.1 thickness .1 turbulence .1 }}
#declare Wtex=texture{pigment{cells color_map {[0 Gray80][1 Gray90]}scale.01} 
                      // pigment{granite color_map {[0 Gray80][0 Gray90][0 Gray80]}scale.1}
                     finish{Fin1} 
                     normal{facets  size .06}
                     //normal{granite .1}
                     }
#declare Btex=texture{ pigment{cells color_map {[0 Gold*.3][1 Gold*.4]}scale.01}
                      //pigment{granite color_map {[0 Gold*.9][0 Gold][0 Gold*.9]}scale.1}
                      finish{Fin1} 
                      normal{facets  size .06}
                      //normal{granite .1}
                      }
// black pieces

#declare Call=union{
 object{Pawn texture{Btex translate -x}  CLoc("A7") no_reflection}  
 object{Pawn texture{Btex translate -x*12}  CLoc("B7")no_reflection}  
 object{Pawn texture{Btex translate -x*22}  CLoc("C7")no_reflection}  
 object{Pawn texture{Btex translate -x*32}  CLoc("D5")no_reflection}  
 object{Pawn texture{Btex translate -x*42}  CLoc("E7")no_reflection}  
 object{Pawn texture{Btex translate -x*52}  CLoc("F7")no_reflection}  
 object{Pawn texture{Btex translate -x*62}  CLoc("G7")no_reflection}  
 object{Pawn texture{Btex translate -x*72}  CLoc("H7")no_reflection}  

 object{Rook texture{Btex translate -x*82}  CLoc("A8")no_reflection}  
 object{Rook texture{Btex translate -x*92}  CLoc("H8")no_reflection}  

 object{Knight texture{Btex translate -x*4}  CLoc("C6")no_reflection}  
 object{Knight rotate y*180 texture{Btex translate -x*6}  CLoc("G8")no_reflection}  

 object{Bish  texture{Btex translate -x*8}  CLoc("C8")no_reflection}  
 object{Bish rotate y*180 texture{Btex translate -x*9}  CLoc("F8")no_reflection}  


 object{Quen texture{Btex translate -x*48}  CLoc("D8")no_reflection}  

 object{King texture{Btex translate -x*18}  CLoc("E8")no_reflection}    

// White pieces

 object{Pawn texture{Wtex translate x}  CLoc("A2")no_reflection}  
 object{Pawn texture{Wtex translate x*2}  CLoc("B2")no_reflection}  
 object{Pawn texture{Wtex translate x*4}  CLoc("C2")no_reflection}  
 object{Pawn texture{Wtex translate x*6}  CLoc("D4")no_reflection}  
 object{Pawn texture{Wtex translate x*8}  CLoc("E2")no_reflection}  
 object{Pawn texture{Wtex translate x*1}  CLoc("F2")no_reflection}  
 object{Pawn texture{Wtex translate x*3}  CLoc("G2")no_reflection}  
 object{Pawn texture{Wtex translate x*5}  CLoc("H2")no_reflection}  

 object{Rook texture{Wtex translate x*12}  CLoc("A1")no_reflection}  
 object{Rook texture{Wtex translate x*22}  CLoc("H1")no_reflection}  

 object{Knight texture{Wtex translate x*32}  CLoc("C3")no_reflection}  
 object{Knight rotate y*180 texture{Wtex translate x*42}  CLoc("G1")no_reflection}  

 object{Bish  texture{Wtex translate x*52}  CLoc("C1")no_reflection}  
 object{Bish  rotate y*180 texture{Wtex translate x*62}  CLoc("F1")no_reflection}  


 object{Quen texture{Wtex translate x*82}  CLoc("D1")no_reflection}  

 object{King texture{Wtex translate x*92}  CLoc("E1")no_reflection}    
}
#ifndef(Get)
 object{Call}
 object{CTab}
#else
#declare Cset=union{object{Call}object{CTab}}
#end