// My Pov stuf base
#declare Radon=1;
#declare Lights=1;
#include "colors.inc"
 global_settings{assumed_gamma 1.0  
                 hf_gray_16 off
                 max_trace_level 50 
     #if (Radon)
      #debug"\n-----Radiosity on-------\n"
      ambient_light 0
      radiosity {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.02           // end pretrace at this size
      count 5                      // higher -> higher quality (1..1600) [35]
      nearest_count 2               // higher -> higher quality (1..10) [5]
      error_bound .8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness .5                  // brightness of radiosity effects (0..1) [1]

      adc_bailout 0.01/2
      normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      always_sample on           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end
}
camera{ location <0,0,-5>
        right x*image_width/image_height
        look_at <0,0,0>
        }

#if(Lights)
 #declare Cnt=-60;
 #while(Cnt<61)
  light_source{ <Cnt,260-abs(Cnt),-300> color White/14}
 #declare Cnt=Cnt+20;
 #end
#else
 light_source{ <60,200,-300> color White}
 light_source{ <-60,200,-300> color White}
#end

//--------- sky---------------
 #declare Spig1=pigment{gradient x color_map{[0 rgb<1,1,.9>][.5 Blue*.1][1 rgb<1,1,.9>]}
                  turbulence .5 }
 #declare Spig2=pigment{image_map {tga "LR.tga"} translate <-.465,-.45,0>} 
 #declare Spig3=pigment{average pigment_map{[9 Spig1][2 Spig2]}}
 sky_sphere{pigment{Spig3}}


//------robots---------
 #declare Get=1;
 #include"PlacBots.inc"
 #include"Chesmen.pov"
 object{Cset scale .1 rotate y*90 translate <0,-3.9,3.3>}


//---------- ground-----------------
#declare Gpig1=pigment{agate color_map{[.1 Green][.5 Black][.9 Green]} scale .2/25}
#declare Gpig2=pigment{agate color_map{[.1 Black][.5 Green][.9 Black]} scale .2/25}
#declare Pkpig=pigment{checker pigment{Gpig2} pigment{Gpig1} turbulence .1 scale 25 translate z}
#declare PkpigT=pigment{gradient y color_map{[0 Black][.5 White][.9 Black]} scale .1}

box{<0,-5,-10><30,-4.1,30> pigment{rgb<.9,.9,1>} normal{agate .4}}
box{<-30,-5,-10><0,-4.1,30> pigment{rgb<1,.9,.9>} normal{agate .4}}
#declare Park=height_field {tga "Park2.tga" smooth scale <30,1,40>}
object{Park translate <0,-5,-10> pigment{Pkpig}}
object{Park scale<-1,1,1> translate <0,-5,-10> pigment{Pkpig}}


//Wall
 // left wall
 box{<0,.8,25.08><-30,-5,26> pigment{Brown*.7} normal {agate .1}}
 #declare Bloc= box{<-.45,0,0><.45,.4,.5>}
 #declare Bloc2= box{<.1,0,0><-.45,.4,.5>}
 #declare Bloc3= box{<.1,0,0><.45,.4,.5>}
 #declare s1 = seed(21432543);
  #declare s2 = seed(9357363);
#declare Cnt2 = 0;
#while (Cnt2 < 5)
   object{Bloc2 pigment{Gold*(1-rand(s1)*.3)} normal{agate.2}
   rotate z*8*rand(s1)-4 translate<0,-3.5+Cnt2,25>}
   //object{Bloc translate<0,-3.25+Cnt2,25>}
 #declare Cnt = 0;
 #while (Cnt < 22)
   object{Bloc pigment{Gold*(1-rand(s1)*.3)} normal{agate.2} finish{brilliance 2}
   rotate z*8*rand(s1)-4 translate<-Cnt-.5,-4+Cnt2,25>}
   object{Bloc pigment{Gold*(1-rand(s1)*.3)} normal{agate.2} finish{brilliance 2}
   rotate z*8*rand(s1)-4 translate<-Cnt-1,-3.5+Cnt2,25>}
   //object{Bloc translate<-Cnt-.5,-3.5+Cnt2,25>}
   //object{Bloc translate<-Cnt-1,-3.25+Cnt2,25>}
 #declare Cnt = Cnt+1; 
 #end
#declare Cnt2 = Cnt2+1; 
#end
// right wall 
box{<30,.8,25.05><0,-5,26> pigment{Gold*.7} normal {agate .1}}
#declare Cnt2 = 0;
#while (Cnt2 < 5)
   object{Bloc3 pigment{Brown*(1-rand(s1)*.3)} normal{agate.2}
   rotate z*8*rand(s1)-4 translate<0,-3.5+Cnt2,25>}
   //object{Bloc translate<0,-3.25+Cnt2,25>}
 #declare Cnt = 0;
 #while (Cnt < 22)
   object{Bloc pigment{Brown*(1-rand(s1)*.3)} normal{agate.2} finish{brilliance 2}
   rotate z*8*rand(s1)-4 translate<Cnt+.5,-4+Cnt2,25>}
   object{Bloc pigment{Brown*(1-rand(s1)*.3)} normal{agate.2} finish{brilliance 2}
   rotate z*8*rand(s1)-4 translate<Cnt+1,-3.5+Cnt2,25>}
   //object{Bloc translate<-Cnt-.5,-3.5+Cnt2,25>}
   //object{Bloc translate<-Cnt-1,-3.25+Cnt2,25>}
 #declare Cnt = Cnt+1; 
 #end
#declare Cnt2 = Cnt2+1; 
#end


//Flag pole
#declare Pig1=pigment{spiral1 3 color_map{[0 Black][.5 Black][.5 White][1 White][1 Black]} frequency 2 rotate x*90}
union{
 cylinder{<0,-4,0><0,10,0>,.15}
 cone{<0,10,0>,.15,<0,10.5,0>,0}
 sphere{<0,10.5,0>,.2}
 //pigment{checker Black White scale 25 translate -y*5}
 pigment{Pig1}
 translate z*19}
cylinder{<0,-4,0><0,-3.9,0>,1 
   pigment{Pig1}
   translate z*19}

//rope
#declare SP=
sphere_sweep {
  linear_spline                 // linear curve
  //cubic_spline                // alternative spline curves
  //b_spline
  5,                            // number of specified sphere positions
  <-.15, 10.25, 19>, .025               // position, radius
  <-.5, 9, 19>, .025                // ...
  <-.5, 8, 19>, .025                // ...
  <-.3, 2, 19>, .025
  <-.15, -1, 19>, .025
  //tolerance 0.001             // optional

}
object{SP  pigment{Black}}
object{SP  pigment{Black} scale<-1,1,1>}

//flags
#declare Get=1;
#include"Flag3.pov"
   object{Ribon pigment{rgb<1,1,1>} } 
   object{Ribon scale<-1,1,1> pigment{rgb<0,0,0>}}             


//benches
#declare Get=1;
#include"Bench.pov"
object{Bench
 pigment{White*.1} normal{agate .1}
 finish{brilliance 3 specular .3 roughness .04 }
 translate <-.6,0,-1.75>  rotate y*32 translate <-4.75,-4,14.5>}
object{Bench
 pigment{White*.8} normal{agate .1}
 finish{brilliance 3 specular .3 roughness .04 }
translate <-.6,0,-1.75>  rotate y*148 translate <4.75,-4,14.5>}

//-----Ballons-----
#include "balloon.inc"
#include "S_Srope.inc"
object{Balloon(rgbft<1.4,1.4,0,.5,.1>,no) scale .6 rotate <0,60,-5> translate <-5.75,4,13>}
 #declare RStart=<-5.75,4,13>;//start vector
 #declare REnd=<-4,-3,15>;//End vector
 #declare RDiv=3;//int >0 number of division points
 #declare RSwid=.03; // float>0 start radius
 #declare REwid=.03;// float>0 end radius
 #declare RWarp=<.5,.75,.5>;//vector or float random deform points 
 #declare Rsd=298136;//int random seed
 #declare Rtol=0;//0<float<1=tolerance; float=0 =defalt tolerance
object{Rope()pigment{White}}
object{Balloon(rgbft<.4,1,.4,.5,.1>,no) scale .6 rotate <0,-60,5> translate <5.75,4,13>}
object{Rope() scale<-1,1,1> pigment{Black}}
//post
union{
 cylinder{<-3.5,-4,1><-3.5,-2,1>,.4 }sphere{<-3.5,-2,1>,.4}
 pigment{granite color_map{[.5 White*.7][.5 White*.3]}scale.02} 
 normal {agate .1} 
 finish{brilliance 2 specular .5 roughness .005 metallic .5}}
union{
 cylinder{<3.5,-4,1><3.5,-2,1>,.4 }sphere{<3.5,-2,1>,.4}
 pigment{granite color_map{[.5 White*.3][.5 White*.7]}scale.02} 
 normal {agate .1} 
 finish{brilliance 2 specular .5 roughness .005 metallic .5}}

//bolt

#declare Bolt=
 union{ cylinder{<0,0,0><.55,0,0>,.06} 
     torus{.15,.06 rotate x*90 translate <.7,0,0>}}
#declare Bolt2=
 union{ cylinder{<0,0,0><.55,0,0>,.065} 
     torus{.15,.065 rotate x*90 translate <.7,0,0>}}
#declare EBolt=union{
object{Bolt pigment{granite color_map {[.3 rgb<0.6510,0.5020,0.3882>*.4][.6 rgb<0.6510,0.5020,0.3882>*.5]} scale.2} 
       finish{brilliance 6 specular .5 roughness .0005 metallic .5 }
       }
object{Bolt2 pigment{agate color_map{[.5 rgb<0.6510,0.5020,0.3882>*.5][.5 Clear]}scale .1}
       finish{brilliance 3 specular .5 roughness .0005 metallic .5}//rgb<.9,.9,1>*.8
        }
    } 
#declare EBolt2=union{
object{Bolt pigment{granite color_map {[.3 rgb<0.6510,0.5020,0.3882>*.4][.6 rgb<0.6510,0.5020,0.3882>*.5]} scale.2} 
       finish{brilliance 6 specular .5 roughness .0005 metallic .5 
       }//irid {0.3 thickness .25 turbulence 1 }}
       }
object{Bolt2 pigment{agate color_map{[.5 rgb<0.6510,0.5020,0.3882>*.5][.5 Clear]}scale .1}
       finish{brilliance 3 specular .5 roughness .0005 metallic .5
       }
        }
    } 

object{EBolt translate <-3.5,-2.25,1>} 
object{EBolt2 rotate y*180 translate <3.5,-2.25,1>}       

//--------chain------------
 #declare Ce= intersection{torus{.15,.065 }box{<-.2,-.07,-.22><0,.07,.22>}}
 #declare ChainA=union{object{Ce translate -x*.1} 
                   object{Ce rotate y*180 translate x*.1}
                   cylinder{<-.1,0,-.15>,<.1,0,-.15>.065} 
                   cylinder{<-.1,0,.15>,<.1,0,.15>.065} 
                   }
 #declare Ce2= intersection{torus{.15,.06 }box{<-.2,-.07,-.22><0,.07,.22>}}
 #declare ChainB=union{object{Ce2 translate -x*.1} 
                   object{Ce2 rotate y*180 translate x*.1}
                   cylinder{<-.1,0,-.15>,<.1,0,-.15>.06} 
                   cylinder{<-.1,0,.15>,<.1,0,.15>.06} 
                   }
#declare Link1=union{
 object{ChainB pigment{granite color_map {[.3 rgb<0.6510,0.5020,0.3882>*.4][.6 rgb<0.6510,0.5020,0.3882>*.5]} scale.2} 
       finish{brilliance 6 specular .5 roughness .0005 metallic .5 }
       }
 object{ChainA pigment{agate color_map{[.5 rgb<0.6510,0.5020,0.3882>*.5][.5 Clear]}scale .1}
       finish{brilliance 3 specular .5 roughness .0005 metallic .5}
       } 
       }
#declare Link2=union{
 object{ChainB pigment{granite color_map {[.3 rgb<0.6510,0.5020,0.3882>*.5][.6 rgb<0.6510,0.5020,0.3882>*.4]} scale.2} 
       finish{brilliance 6 specular .5 roughness .0005 metallic .5 
       }//irid {0.3 thickness .25 turbulence 1 }}
       }
 object{ChainA pigment{agate color_map{[.5 Clear][.5 rgb<0.6510,0.5020,0.3882>*.5]}scale .1}
       finish{brilliance 3 specular .5 roughness .0005 metallic .5
       }
       } 
       }

// show chain/bead
union{
 object{Link1} object{Link1 rotate x*90 translate x*.4}
 object{Link1 translate x*.8} object{Link1 rotate x*90 translate x*1.2}
 object{Link1 translate x*1.6} object{Link1 rotate x*90 translate x*2.0}
   translate <-2.5,-2.25,1>}   //z*3   

union{
 object{Link2} object{Link2 rotate x*90 translate -x*.4}
 object{Link2 translate -x*.8} object{Link2 rotate x*90 translate -x*1.2}
 object{Link2 translate -x*1.6} object{Link2 rotate x*90 translate -x*2.0}
   translate <2.5,-2.25,1>}   //-z*7   

//intersection{box{<-.05,-.41,-.41><.05,.41,.41> inverse}
 union{box{<-.45,-.19,-.15><.45,.19,.15> }
      sphere{0,.4} 
      pigment{spiral1 1 color_map{[.5 rgb<0,0,.01>][.5 rgb<.9,.9,1>]}rotate -z*20 scale .5}
       finish{brilliance 3 specular .6 roughness .0005} //metallic .5
         //irid {0.1 thickness .25 turbulence 1 }
   scale<1,1,.5> translate<0,-2.25,1>}
 
//fountain
intersection{
 //cone{-y*4.51,3.2,-y*3.49,2.7 inverse} 
 cone{-y*4.51,2.5,-y*3.49,2.7 inverse} 
 cone{-y*4.5,3.2,-y*3.5,3} 
 pigment{radial color_map{[.5 Clear][.5 rgb<1,1,.9>]} frequency 25} 
 normal{granite .1}
 translate z*8}
intersection{
 //cone{-y*4.51,3.2,-y*3.5,2.75 inverse} 
 cone{-y*4.51,2.5,-y*3.5,2.75 inverse} 
 cone{-y*4.5,3.1,-y*3.55,2.95} 
 pigment{ White *.3} normal {agate .3}translate z*8}

// ice
cylinder{-y*4.51,-y*3.75,2.8 
 texture{pigment{rgb<.5,.5,.55>} normal{granite .1}
         finish{reflection <.2,.2,.4> ambient 0 diffuse 0}} 
 texture{pigment{spherical color_map{[.25 rgb<.8,.8,1>][.9 Clear]} 
         scale 2.8 translate -y*3.75}
  normal {agate .1} finish{ambient .2 diffuse .6}}
 translate z*8}
//Flame
#include"Flame.pov"
/*#declare Flame= merge{sphere{0,.1} 
                      cylinder{0,y,.1}
                      cone{y,.1,y*1.125,.075}
                      cone{y*1.125,.075, y*1.25,.05}
                      sphere{y*1.25,.05}
                      scale <1.5,1,1.5>
                      }*/
#declare Fs = seed(173986);
#declare N=0;
#declare Cnt = 0;
#while (Cnt < 350)
object{ #if (Cnt<180) FlameB
        #else Flame
        #end  
        rotate <rand(Fs)*6-3,rand(Fs)*360,rand(Fs)*6-3>  
         translate<0,-3.245,2.86> rotate y*Cnt translate z*8}
                //<0,-3.42,2.84>
cylinder{<0,-3.8,2.84>,<0,-3.35,2.86>,.08 pigment{Black} 
         rotate y*Cnt translate z*8}
#declare N=N+1;
#declare Cnt = Cnt+14.4; 
#end

//Trees
#include"Opp03.Tms"//HR_L14.Tms

object{Tree pigment{spherical color_map{[0 Tan][1 Black]} scale<50,50,50>} 
   scale .18 translate <15,-2.75,20>}
object{Leafs pigment{Gold*.5} scale .18 translate <15,-2.75,20>}

object{Tree pigment{spherical color_map{[0 Black][1 Tan]} scale<50,50,50>} 
   scale <-.18,.18,.18> translate <-15,-2.75,20>}
object{Leafs pigment{Brown*.5} scale <-.18,.18,.18> translate <-15,-2.75,20>} 

//left holder
cylinder{<-15,-4,20><-15,-2.75,20>,2.5 pigment{Brown*.3} normal{agate }}
intersection{cylinder{<-15,-4.1,20><-15,-2.5,20>,2.5 inverse}
             cylinder{<-15,-4,20><-15,-2.75,20>,3.2}
             pigment{Gold} normal{agate.6}}
             
#declare Cnt2 = 0;
#while (Cnt2 < 3)
 #declare rt = 5*mod(Cnt2,2);
 #declare Cnt = 0;
 #while (Cnt < 360)
  object{Bloc  #if (Cnt2<2) rotate x*(6*rand(s2)-3) #end
         translate x*2.75 rotate y*(Cnt+rt)  translate<-15,-4+.5*Cnt2,20> 
         pigment{Brown*(1-rand(s2)*.4)} normal{granite .4}}
 #declare Cnt = Cnt+10; 
 #end
#declare Cnt2 = Cnt2+1; 
#end

//Right holder
cylinder{<15,-4,20><15,-2.75,20>,2.5 pigment{Brown*.3} normal{agate }}
intersection{cylinder{<15,-4.1,20><15,-2.5,20>,2.5 inverse}
             cylinder{<15,-4,20><15,-2.75,20>,3.2}
             pigment{Brown*.5} normal{agate.6}}
             
#declare Cnt2 = 0;
#while (Cnt2 < 3)
 #declare rt = 5*mod(Cnt2,2);
 #declare Cnt = 0;
 #while (Cnt < 360)
  object{Bloc  #if (Cnt2<2) rotate x*(6*rand(s2)-3) #end
         translate x*2.75 rotate y*(Cnt+rt)  translate<15,-4+.5*Cnt2,20> 
         pigment{Gold*(1-rand(s2)*.4)} normal{granite .4}}
 #declare Cnt = Cnt+10; 
 #end
#declare Cnt2 = Cnt2+1; 
#end

         