// #macro Rope()   
// Sphere_sweep w/ cubic_spline macro
// point to point rnd rope
// call one time only
#ifndef(ROP_MAC)
 #declare ROP_MAC=100;
#ifndef(Get)
 #include "colors.inc"
 global_settings{ max_trace_level 50 }
 camera{ location <0,0,-30>
        right x*image_width/image_height
        look_at <0,0,0>
        }
 background{Pink}
 light_source{ <40,200,-300> color White}
 light_source{ <-60,100,-20> color White}
 plane{y,-5 pigment{Green}}
#end
//---- changable vairables---------
 #declare RStart=<-2,0,0>;//start vector
 #declare REnd=<-8,8,0>;//End vector
 #declare RDiv=4;//int >0 number of division points
 #declare RSwid=.4; // float>0 start radius
 #declare REwid=.01;// float>0 end radius
 #declare RWarp=<3,3,3>;//vector or float random deform points 
 #declare Rsd=5636;//int random seed
 #declare Rtol=.01;//0<float<1=tolerance; float=0 =defalt tolerance


#macro Rope()   
 #ifndef (RStart) #declare RStart=<0,0,0>;#end//vector
 #ifndef (REnd) #declare REnd=<4,8,0>;#end//vector
 #ifndef (RDiv) #declare RDiv=4; #end//int >0
 #ifndef (RSwid) #declare RSwid=.5;#end//float>0
 #ifndef (RSwid) #declare REwid=.01;#end//float>0
 #ifndef (RWarp) #declare RWarp=-1;#end//float
 #ifndef (Rsd) #declare Rs=seed(5636);
 #else  #declare Rs=seed(Rsd); #end
 
 #ifdef (Rtol) #if(Rtol>0) #local Tol=Rtol; #end #end

 #local Rv=REnd-RStart;
 #local Rl=vlength(Rv);
  #local Delta = Rl / RDiv;
  //#debug concat("Delta= ",str(Delta,3,3),"\n")

 sphere_sweep {
  cubic_spline,                // alternative spline curves
  RDiv+3,
  RStart+ 2*RWarp*<rand(Rs),rand(Rs),rand(Rs)>-RWarp,RSwid
  RStart,RSwid
 #local Cnt = 1;
 #while (Cnt< RDiv)
  #local Cat = Cnt*Delta/Rl;
  #local Rad = RSwid+Cat*(REwid-RSwid);
  #local Pnt= RStart+Cat*Rv+2*RWarp*<rand(Rs),rand(Rs),rand(Rs)>-RWarp;
   Pnt,Rad
  //#debug concat("Cat= ",str(Cat,3,3),"\n")
  //#debug concat("Pnt= ",vstr(3,Pnt,",",3,3),"\n")
  #local Cnt = Cnt + 1;
 #end
  REnd,REwid
  REnd+ 2*RWarp*<rand(Rs),rand(Rs),rand(Rs)>-RWarp,REwid
 //#ifdef (Tol) tolerance Tol #debug"Tolerance SET!\n" #end
 }

#end

//sphere{RStart,.6 pigment{White}}
//sphere{REnd,.3 pigment{White}}
#ifndef(Get)
 object{Rope() pigment{White} normal{agate}}
 #declare RStart=<2,0,0>;
 #declare REnd=<8,8,0>;
 #declare RWarp=<-3,3,3>;
 object{Rope()pigment{White} normal{agate}}
#end
#end