global_settings {
    max_trace_level 40
    #if(PHOTONS)
    photons {
        count 2000000
        #if( GENERATE_PHOTONS )
            save_file "glass.pht"
        #else
            load_file "glass.pht"
        #end
        media 100
    }
    #end
}

#declare AMBIENT = <160,161,165>/255;
#declare DIFFUSE = 0.6;

#if(ATMOSPHERE)
    #include "Planet.pov"
#end

#declare SCENE_HEIGHT = 30;

#declare GLASS_SCALE = 0.18/13.0415*MPP;
#declare GLASS_POSITION = <0.05,SCENE_HEIGHT+0.0005,-0.1>*MPP;

#declare CAMERA_FOCUS = <0.0,SCENE_HEIGHT+0.1,0.0>*MPP;
#declare CAMERA_DIRECTION = <12.0,4.0,20.0>*GLASS_SCALE;

#declare TABLE_RADIUS = 0.75*MPP;
#declare TABLE_STRIP_RADIUS = 0.025*MPP;
#declare TABLE_STRIP_SPACING = 0.02*MPP;
#declare TABLE_STRIP_HEIGHT = 0.0005*MPP;

#include "House.pov"

camera {
    location CAMERA_FOCUS+CAMERA_DIRECTION
    look_at CAMERA_FOCUS
}


union {
    torus {
        TABLE_RADIUS, 0.01*MPP
        translate <0,SCENE_HEIGHT-0.01,0>*MPP
    }
    torus {
        0.025*MPP, 0.005*MPP
        translate <0,SCENE_HEIGHT-0.005,0>*MPP
    }
    intersection {
        cylinder {
            <0,SCENE_HEIGHT,0>*MPP,
            <0,SCENE_HEIGHT-0.005,0>*MPP,
            TABLE_RADIUS
        }
        cylinder {
            <0,SCENE_HEIGHT+0.005,0>*MPP,
            <0,SCENE_HEIGHT-0.015,0>*MPP,
            TABLE_STRIP_RADIUS
            inverse
        }
    }
    intersection {
        cylinder {
            <0,SCENE_HEIGHT-0.04,0>*MPP,
            <0,SCENE_HEIGHT-0.005,0>*MPP,
            TABLE_STRIP_RADIUS
        }
        cylinder {
            <0,SCENE_HEIGHT-0.045,0>*MPP,
            <0,SCENE_HEIGHT,0>*MPP,
            (TABLE_STRIP_RADIUS-0.005*MPP)
            inverse
        }
    }
    texture {
        pigment {
            color rgb 1
        }
        finish { ambient AMBIENT diffuse DIFFUSE specular 0.2 roughness 0.05 #if(REFLECTION) reflection { 0.1 } #end }
    }
    #if(PHOTONS)
    photons{
        collect on
    }
    #end
}

union {
    #macro O_roughstrip( start_position, end_position )
        cylinder {
            <start_position.x,start_position.y,start_position.z>,
            <start_position.x,end_position.y,start_position.z>,
            TABLE_STRIP_RADIUS
        }
        cylinder {
            <end_position.x,start_position.y,end_position.z>,
            <end_position.x,end_position.y,end_position.z>,
            TABLE_STRIP_RADIUS
        }
        box {
            start_position+<0,0,TABLE_STRIP_RADIUS>,
            end_position-<0,0,TABLE_STRIP_RADIUS>
        }
    #end
    O_roughstrip( <TABLE_RADIUS-TABLE_STRIP_SPACING-TABLE_STRIP_RADIUS,SCENE_HEIGHT*MPP-0.005*MPP,0>, <2*TABLE_STRIP_RADIUS+TABLE_STRIP_SPACING,SCENE_HEIGHT*MPP+TABLE_STRIP_HEIGHT,0> )
    O_roughstrip( <-TABLE_RADIUS+TABLE_STRIP_SPACING+TABLE_STRIP_RADIUS,SCENE_HEIGHT*MPP-0.005*MPP,0>, <-2*TABLE_STRIP_RADIUS-TABLE_STRIP_SPACING,SCENE_HEIGHT*MPP+TABLE_STRIP_HEIGHT,0> )
    #declare offsetZ = TABLE_STRIP_SPACING + 2*TABLE_STRIP_RADIUS;
    #while( offsetZ < TABLE_RADIUS-TABLE_STRIP_SPACING-TABLE_STRIP_RADIUS )
        #declare offsetX = sqrt(pow(TABLE_RADIUS - TABLE_STRIP_SPACING - TABLE_STRIP_RADIUS,2)-pow(offsetZ,2));
        O_roughstrip( <offsetX,SCENE_HEIGHT*MPP-0.005*MPP,offsetZ>, <-offsetX,SCENE_HEIGHT*MPP+TABLE_STRIP_HEIGHT,offsetZ> )
        O_roughstrip( <offsetX,SCENE_HEIGHT*MPP-0.005*MPP,-offsetZ>, <-offsetX,SCENE_HEIGHT*MPP+TABLE_STRIP_HEIGHT,-offsetZ> )
        #declare offsetZ = offsetZ + TABLE_STRIP_SPACING + 2*TABLE_STRIP_RADIUS;
    #end
    no_shadow
    texture {
        pigment {
            color rgb 1
        }
        normal {
            granite
            bump_size 0.1
            scale 0.001*MPP
        }
        finish { ambient AMBIENT diffuse DIFFUSE specular 0.3 roughness 0.05 }
    }
    #if(PHOTONS)
    photons{
        collect on
    }
    #end
}

#if(WINE_GLASS)
    #declare A_glass_points = array[28] {
        <0,0,0>,
        <2.8065,0,0>,
        <3.26601,0,0.0578475>,
        <3.37463,0,0.166818>,
        <3.26588,0,0.298373>,
        <2.10453,0,0.34548>,
        <1.31908,0,0.521753>,
        <0.830167,0,0.811258>,
        <0.527533,0,1.4556>,
        <0.527533,0,2.29053>,
        <0.527533,0,4.30749>,
        <0.527533,0,5.06738>,
        <0.823789,0,5.67166>,
        <1.28537,0,6.11613>,
        <2.33341,0,6.90146>,
        <3.07917,0,8.13808>,
        <3.27027,0,9.52153>,
        <3.04392,0,10.8786>,
        <2.69398,0,12.1379>,
        <2.38984,0,12.9887>,
        //<2.30651,0,13.0415>,
        <2.25246,0,12.9583>,
        <2.55581,0,12.114>,
        <2.93022,0,10.8302>,
        <3.14226,0,9.51206>,
        <2.94499,0,8.16747>,
        <2.25718,0,7.01192>,
        <1.20104,0,6.22369>,
        <0,0,5.96683>
    }
    #declare T_glass =
    texture {
        pigment {
            #if( REFRACTION )
            color rgbf <1.00, 1.00, 1.00, 1.00>
            #else
            color rgbf <0.70, 1.00, 0.80, 0.90>
            #end
        }
        finish {
            specular 0.8
            roughness 0.008
            ambient 0
            diffuse 0
            #if(REFLECTION)
                reflection {
                    0.05, 0.2
                    fresnel on
                }
                conserve_energy
            #end
        }
    }
    #macro TIP_Glass()
        texture {T_glass}
        hollow
        #if( REFRACTION )
    	interior {
            ior 1.51
            dispersion 1.01
            dispersion_samples 13
            fade_distance 8
            fade_power 2
    	}
    	#end
        #if(PHOTONS)
    	photons {
            target
            #if(REFLECTION)
                reflection on
            #else
                reflection off
            #end
            refraction on
    	    collect off
    	}
    	#end
    #end
    
    #declare O_glass = lathe {
        cubic_spline
        dimension_size(A_glass_points,1)+2
        #declare index = 0;
        ,<A_glass_points[index].x-1,A_glass_points[index].z>
        #while(index<dimension_size(A_glass_points,1))
            ,<A_glass_points[index].x,A_glass_points[index].z>
            #declare index = index + 1;
        #end
        ,<A_glass_points[index-1].x-1,A_glass_points[index-1].z>
    }
    object { O_glass TIP_Glass() scale GLASS_SCALE translate GLASS_POSITION }
#end

#if(WINE)
    #declare A_wine_points = array[22] {
        <0,0,5.96683>,
        <1.10104,0,6.22369>,
        <2.15718,0,7.01192>,
        <2.84499,0,8.16747>,
        <3.04226,0,9.51206>,
        <3.03255,0,9.56363>,
        <3.01218,0,9.57901>,
        <2.94069,0,9.58176>,
        <2.84166,0,9.66132>,
        <2.62632,0,9.70185>,
        <2.42254,0,9.67269>,
        <2.22316,0,9.59454>,
        <1.97898,0,9.53261>,
        <1.72564,0,9.58409>,
        <1.54725,0,9.64837>,
        <1.29891,0,9.68658>,
        <1.05784,0,9.63524>,
        <0.887247,0,9.5766>,
        <0.636078,0,9.53588>,
        <0.398138,0,9.59344>,
        <0.162285,0,9.63167>,
        <0,0,9.62025>
    }
    #declare C_White_Wine = <244,241,202>/255;
    
    #declare T_wine =
    texture {
        pigment {
            color rgbf <C_White_Wine.x, C_White_Wine.y, C_White_Wine.z, 1.00>
        }
        finish {
            specular 0.6
            roughness 0.002
            ambient 0
            diffuse 0
            #if(REFLECTION)
                reflection {
                    0.1*C_White_Wine, 0.4*C_White_Wine
                    fresnel on
                    metallic 1
                }
                conserve_energy
            #end
        }
    }
    
    intersection {
        lathe {
            cubic_spline
            dimension_size(A_wine_points,1)+2
            #declare index = 0;
            ,<A_wine_points[index].x-1,A_wine_points[index].z>
            #while(index<dimension_size(A_wine_points,1))
                ,<A_wine_points[index].x,A_wine_points[index].z>
                #declare index = index + 1;
            #end
            ,<A_wine_points[index-1].x-1,A_wine_points[index-1].z>
        }
        object { O_glass inverse }
        texture {T_wine}
        hollow
        #if( REFRACTION )
    	interior {
            ior 1.36
            #if( DISPERSION )
                dispersion 1.01
                dispersion_samples 15
            #end
            fade_color C_White_Wine
            fade_distance 3
            fade_power 2
    	}
    	#end
        #if(PHOTONS)
    	photons {
            target
            #if(REFLECTION)
                reflection on
            #else
                reflection off
            #end
            refraction on
    	    collect on
    	}
    	#end
    	scale GLASS_SCALE
    	translate GLASS_POSITION
    }
#end