#include "math.inc"
#include "functions.inc"

#declare INTERVALS=(DETAIL>1?2:1);
#declare SAMPLES=(DETAIL+1)*5;

#declare MPP=0.17196;
#declare PLANET_SEA_BED = 6359.5*1000*MPP;
#declare PLANET_RADIUS = 6360*1000*MPP;
#declare PLANET_TROPOSPHERE_START = PLANET_RADIUS + 0.5*1000*MPP;
#declare PLANET_TROPOSPHERE_END = PLANET_RADIUS + 14.5*1000*MPP;
#declare PLANET_STRATOSPHERE_START = PLANET_RADIUS + 15*1000*MPP;
#declare PLANET_STRATOSPHERE_END = PLANET_RADIUS + 50*1000*MPP;
#declare PLANET_MESOSPHERE_START = PLANET_RADIUS + 60*1000*MPP;
#declare PLANET_MESOSPHERE_END = PLANET_RADIUS + 85*1000*MPP;
#declare PLANET_THERMOSPHERE_START = PLANET_RADIUS + 120*1000*MPP;
#declare PLANET_THERMOSPHERE_END = PLANET_RADIUS + 600*1000*MPP;
//#declare PLANET_EXOSPHERE_START = PLANET_RADIUS + 650*1000*MPP;
//#declare PLANET_EXOSPHERE_END = PLANET_RADIUS + 10000*1000*MPP;

#declare SKY_COLOUR=<58,107,127>/255;
#declare POLLUTION_COLOUR=<254,159,102>/255;

// scale moon and sun distances, otherwise they are either too far away to see or too close to the atmosphere
#declare MOON_DISTANCE = 3.844e8*MPP/30;
#declare MOON_RADIUS = 1.74e6*MPP/15;

#declare SUN_DISTANCE = 1.496e11*MPP/3000;
#declare SUN_RADIUS = 1.392e9*MPP/3000;


#declare MOON_POSITION = vnormalize(<-1.0, 9.0, -10.0>)*MOON_DISTANCE+<0,-PLANET_RADIUS,0>;

#declare SUN_ROTATE = <0,0,254>;
#declare SUN_AXIS = vrotate(<0.0,-1.0,-1.0>,SUN_ROTATE);
#declare SUN_POSITION = SUN_DISTANCE*vnormalize(SUN_AXIS)+<0,-PLANET_RADIUS/2,0>;

#if( !GENERATE_PHOTONS )

// sea
sphere {
    <0,0,0>,
    PLANET_RADIUS
    hollow
    
    texture {
        #declare frq = PLANET_RADIUS/pow(2,0);
        #declare phs = 2*pi*clock;
        #declare scl = PLANET_RADIUS;
        pigment {
            rgbf 1
        }
        #declare phaseXYZ = vrotate(<0,clock/1.5,0>,<45,30,0>);
        #declare phaseX = phaseXYZ.x;
        #declare phaseY = phaseXYZ.y;
        #declare phaseZ = phaseXYZ.z;
        normal {
            function { f_noise3d(x+phaseX,y+phaseY,z+phaseZ)+0.1*f_granite(x+phaseX,y+phaseY,z+phaseZ) }
        }
        finish {
            ambient 0
            diffuse 0
            specular 0.1
            roughness 0.005
            reflection {
                0.2, 0.8
                fresnel
            }
            conserve_energy
        }
    }
    interior {
        ior 1.34 // salt water ior
        fade_power 2
        fade_distance 50*MPP
    }
    translate <0,-PLANET_RADIUS,0>
    #if(PHOTONS)
    photons{
        collect off
    }
    #end
}
#if( ATMOSPHERE )
    #macro O_sky_sphere( startRadius, endRadius, scatter, eccen, ints, sampsmin, sampsmax )
        difference {
            sphere { <0,0,0>, endRadius }
            sphere { <0,0,0>, startRadius }
            hollow
            texture { pigment { rgbf 1 } }
            interior {
                media {
                    method 3
                    samples sampsmin,sampsmax
                    intervals ints
                    scattering { 5, scatter eccentricity eccen }
                }
            }
            translate <0,-PLANET_RADIUS,0>            
            #if(PHOTONS)
            photons{
                collect off
            }
            #end
        }
    #end
    // humidity layer (more humidity reduces horizontal viewing distance)
    O_sky_sphere( PLANET_RADIUS+10*MPP, PLANET_TROPOSPHERE_END, 0.000001, 0.01, 1, 4, 8 )
    // pollution layer (makes sunsets red)
    O_sky_sphere( PLANET_STRATOSPHERE_START, PLANET_STRATOSPHERE_END, POLLUTION_COLOUR*0.000001, 0.6, 1, 4, 8 )
    // upper atmosphere (makes sky blue)
    O_sky_sphere( PLANET_MESOSPHERE_START, PLANET_THERMOSPHERE_END, SKY_COLOUR*0.000004, 0.01, (DETAIL>1?2:1), (DETAIL+1)*5, (DETAIL+1)*6 )
#end

// sun
sphere {
    <0,0,0>,
    1
    no_shadow
    hollow
    texture {
        pigment { color rgbf 1 }
        finish { ambient 0 diffuse 0 }
    }
    interior {
        media {
            emission 0.000005
            density {
                spherical
                density_map { [0 rgb 0][0.25 rgb <0.25,0.25,0.23>][0.5 rgb 1] }
            }
        }
    }
    scale SUN_RADIUS*2
    translate SUN_POSITION
    #if(PHOTONS)
    photons{
        collect off
    }
    #end
}

// moon
sphere {
    MOON_POSITION,
    MOON_RADIUS
    texture {
        pigment {
            granite
            color_map {
                [0 color rgb 0.46]
                [1 color rgb 0.67]
            }
        }
        finish {
            ambient 0
            diffuse 1
        }
        scale MOON_RADIUS/8
    }
    #if(PHOTONS)
    photons{
        collect off
    }
    #end
}
#end // !GENERATE_PHOTONS

light_source {
    SUN_POSITION
    rgb 1.9
    #if(PHOTONS)
    photons {
        refraction on
        #if(REFLECTION)
            reflection on
        #else
            reflection off
        #end
    }
    #end
}