// Persistence of Vision Ray Tracer Scene Description File
// File: rf_arch_int.inc
// Vers: 3.6
// Desc: interior architectural objects  
// Date: Sept 27, 2005
// Auth: Rob Fitzel
// Units: inches

/*
   Objects
     baseboard  (untextured)
     door (untextured)
     door_stopper
   Macros 
   window_casing(wx,wy,txt, xfrm)
      wx, wy are outside frame measurement - casing is 2.375 inches wide 
*/

// conditional includes
#ifndef (Metals_Inc_Temp)
  #include "metals.inc"
#end

                              
#declare baseboard = prism {  // intended to be X-axis scaled, put z against wall
  linear_sweep
  linear_spline
   0,
   1,
   14,
   <0,0>,  <1,-0.2>, <1.4,-0.4>,  <1.5,-1>, <1.4,-1.5>, <1.1,-2>, <1.5,-2.5>, <1.5,-4>,
   <1.4,-5>, <1.4, -5>, <1.5, -5.5>, <1.5, -10> <0,-10>, <0,0> 
   
   translate <0,0,10>
   rotate <270,0,0> 
   rotate <0,90,0>
   translate <1,0,3>
   scale <1,0.3,0.3> 

 };    



#declare casing =
difference {
  union {
    box      {<0,0,0>,<1,2.375,-0.375> }  
    box      {<0,0,-0.375>,<1,0.5,-0.5>}
    cylinder {<0,0.5,-0.375>,<1,0.5,-0.375>, 0.125}
    cylinder {<0,0.75,-0.375>,<1,0.75,-0.375>, 0.125}
    box      {<0,0.75,-0.375>,<1,1,-0.5>}
    cylinder {<0,1,0>,<1,1,0>,0.125 scale <1,1,1> translate <0,0,-0.375>}
    cylinder {<0,1.75,0>,<1,1.75,0>, 0.125 scale <1,1,0.25> translate <0,0,-0.375>} 
    cylinder {<0,1.9375,0>,<1,1.9375,0>, 0.125 scale <1,1,0.5> translate <0,0,-0.375>} 
  }
  cylinder {<-1,1.375,0>,<2,1.375,0> ,0.15 scale <1,1,0.125> translate <0,0,-0.375>}
 // texture {t_casing}
};

// wx, wy are outside frame measurement - casing is 2.375 inches wide 
#macro window_casing(wx,wy,txt, xfrm)
  
  #local horizontal = 
  union {
    intersection {
    object {casing scale <wx,1,1> translate <0,0,0>}
    plane {y,0 rotate <0,0,45>  } 
    plane {y,0 rotate <0,0,-45> translate <wx,0,0> }
    }
  }; 
  
  #local vertical = 
  union {
    intersection {
      object {casing scale <wy,1,1> rotate <0,0,-90> translate <0,wy,0>}
      plane {y,0 rotate <0,0,45>   inverse }
      plane {y,0 rotate <0,0,-45> translate <0,wy,0>  }
    }

  };
    
  union {   
    union {horizontal translate <0,0,0>}
    union {horizontal scale  <1,-1,1> translate <0,wy,0>} 
    
    union {vertical}
    union {vertical  scale <-1,1,1> translate <wx,0,0>}
    texture {txt}
    transform {xfrm}
  }
#end 





// Basic interior door
#declare t_door = texture {pigment {color <1,1,1>} finish {ambient  0.7 } };
#declare t_door_knob = texture {T_Gold_1E };
#declare door = 
union {
  #declare door_panel = 
   difference{
     box      {<-1,-1,0>,<9.5,25,-0.5>}
 /*    cylinder {<0,0,0>,<0,24,0> 0.1}            //vertical ones
     cylinder {<1.5,1.5,0>,<1.5,22.5,0>,0.1}
     cylinder {<7,1.5,0>,<7,22.5,0>,0.1}
     cylinder {<8.5,0,0>,<8.5,24,0>,0.1}
     cylinder {<0,0,0>,<8.5,0,0>,0.1}         // horizontal ones
     cylinder {<1.5,1.5,0>,<7,1.5,0>, 0.1}
     cylinder {<0,24,0>,<8.5,24,0>,0.1}      
     cylinder {<1.5,22.5,0>,<7,22.5,0>, 0.1} 
     

*/
    difference {
      cylinder {<0,0.75,0>,<8.5,0.75,0>,0.75 scale <1,1,0.1>} // bot
      box      {<0,0,1>,<3,3,-1>  rotate <0,0,45>}
      box      {<0,0,1>,<-3,3,-1> rotate <0,0,-45> translate <8.5,0,0>}
      }
     
    difference {
       cylinder {<0.75,0,0>,<0.75,24,0>,0.75  scale <1,1,0.1>} // rt       
       box {<0,0,1>,<3,-3,-1>  rotate <0,0,45>}
       box {<0,0,1>,<3,3,-1>  rotate <0,0,-45> translate <0,24,0>}
    }
    
    difference {
      cylinder {<0,23.25,0>,<8.5,23.25,0>,0.75 scale <1,1,0.1>}
      box      {<0,0,1>,<-3,-3,-1>  rotate <0,0,45> translate <0,24,0>}
      box      {<0,0,1>,<3,-3,-1> rotate <0,0,-45> translate <8.5,24,0>} 
    }
    
    difference {
      cylinder {<7.75,0,0>,<7.75,24,0>,0.75  scale <1,1,0.1>} // left
      box      {<0,0,1>,<-3,-3,-1>  rotate <0,0,45> translate <7,1.5,0>}
      box      {<0,0,1>,<-3, 3,-1> rotate <0,0,-45> translate <7,22.5,0>}    
    }
    

    // texture  {t_door}
   };
  #declare sm_door_panel =  // shortcut: merge parts of the larger panels
   union {
     union {door_panel translate <0,0,0> clipped_by {plane {y,5}}   }
     union {door_panel translate <0,-20.5,0>  clipped_by {plane {-y,0}} translate <0,5,0> } 
   };
  #declare door_hinge = // TODO: turn into a gradient ytexture map!
    union {
      cylinder {<0,0,0>,     <0,0.5,0>,    0.1875   texture {T_Copper_5A}} // T_Brass_1A too dark 
      cylinder {<0,0.501,0>,   <0,1.1875,0>, 0.1875 texture {T_Copper_1A}}
      cylinder {<0,1.1975,0>,<0,1.875,0>,  0.1875   texture {T_Copper_4A }}
      cylinder {<0,1.885,0>, <0,2.5625,0>, 0.1875   texture {T_Copper_1A}}
      cylinder {<0,2.5725,0>,<0,3,0>,      0.1875   texture {T_Copper_3A }} 
      cylinder {<0,3.01,0>,<0,3.0725,0>,     0.2    texture {T_Copper_1A}}
      cylinder {<0,0.01,0>,<0,3.05,0>,       0.18   pigment {color <0,0,0>}}
  }; 
  #declare door_handle = 
    union {
      cylinder {<0,0,0>,<0,0,0.125>,1.25 }
      difference {
        cylinder {<0,0,0.125>,<0,0,0.45>,0.75 }
        torus    {1.5,1 rotate <90,0,0> scale <1,1,0.5> translate <0,0,0.5>}
      }
      cylinder {<0,0,0.5>,<0,0,1>, 0.5 }
      sphere {<0,0,1.75>,1 scale <1,1,0.625> }
      texture {t_door_knob}
    };
    union {                                                                              
      box {<0,0,0>,<3.25,80,-1>}
      box {<13.75,0,0>,<16,80,-1>} 
      box {<26.5,0,0>,<29.75,80,-1>}
      box {<3.25,0,0>,<13.75,7.5,-1>}
      box {<16,0,0>,<26.5,7.5,-1>}
      box {<3.25,33.5,0>,<13.75,38.5,-1>}
      box {<16,33.5,0>,<26.5,38.5,-1>} 
      box {<3.25,64.5,0>,<13.75,66.5,-1>}
      box {<16,64.5,0>,<26.5,66.5,-1>} 
      box {<3.25,76.5,0>,<13.75,80,-1>}
      box {<16,76.5,0>,<26.5,80,-1>}
       
      //box {<0,0,0>,<29.75,80,-1.875>}  // main part
    }
    union {door_panel    translate <4.25,8.5,0>}
    union {door_panel    translate <17,8.5,0>}
    union {door_panel    translate <4.25,39.5,0>}
    union {door_panel    translate <17,39.5,0>}
    union {sm_door_panel translate <17,67.5,0>}
    union {sm_door_panel translate <4.25,67.5,0>}
    union {door_hinge    translate <0,10,0.2>}
    union {door_hinge    translate <-0.18,71.5,0.2>} 
    union {door_handle   translate <27.25,36,0>}
  //texture {t_door}
};

#declare t_door_stopper = texture {T_Copper_1A};
#declare door_stopper = 
union {
  cylinder {<0,0,0>,<0,0,0.125>, 0.4375}
  cylinder {<0,0,0>,<0,0,2.5>,0.12 pigment {rgb 0}  }
  cylinder {<0,0,2.5>,<0,0,3>, 0.21875 pigment {rgb 1}  }
  #declare i = 2;
  #while (i<42)
    torus {40*0.15/(i+20),0.030 rotate <100,0,0> translate <0,0,i*0.07> }
    #declare i = i+1;  
  #end
  rotate <0,90,0>
  texture {t_door_stopper}
};


