// Persistence of Vision Ray Tracer Scene Description File
// File: rf_cosmetics.inc
// Vers: 3.6
// Desc: Hairdresser objects
// Date: Sept 15, 2005 
// Auth: Rob Fitzel
// Units: inches 
/* 
Objects:
  black_comb, white_comb, hair_pick, hair_dryer, hand_mirror, 
  nivea_jar, vaseline_jar, gel_bottle1, gel_bottle2, gel_bottle3, gel_bottle4,
  cream_bottle1, cream_bottle2, cream_bottle3, cream_bottle4,
  skincream_tube_, tube_bottle2_, lipstick1, lipstick2, lipstick3, lipstick4, 
  compact, curling_iron 
*/

#declare incl_rf_cosmetics = 1;
#declare  cm_to_inches = 0.3937; 

#ifndef (SHAPES_INC_TEMP)
  #include "shapes.inc"
#end 

#ifndef (Metals_Inc_Temp)
  #include "metals.inc"
#end

#include "skincream_tube.inc"
#include "tube_bottle2.inc"

// -----------------------------------------------------------------------------
// Textures 
// -----------------------------------------------------------------------------
#declare t_mirror = texture {pigment {rgb 1} finish { reflection {1.0} ambient 0 diffuse 0 } };
#declare t_hair_dryer_white = texture {pigment {rgb 1} finish {phong 1 phong_size 60} };
#declare t_hair_dryer_black = texture {pigment {rgb 0} }; 
#declare t_hair_dryer_grill = 
texture {
  gradient y
  texture_map {
    [0   t_hair_dryer_white]
    [0.5 t_hair_dryer_white]
    [0.5 t_hair_dryer_black]
    [1.0 t_hair_dryer_black]
  }
  scale 0.1
};


#declare t_black_comb_teeth =
texture {
  pigment {
    gradient x
    pigment_map {
      [0     rgbt 0]
      [0.5   rgbt 0]
      [0.5   rgbt 1]
      [1.0   rgbt 1]
    }
  }
  scale 0.05
};

#declare t_white_comb = texture {pigment {rgb 1} finish {phong 1 phong_size 60 ambient 0.3} };
#declare t_white_comb_clear= texture {pigment {rgbt 1}};
#declare t_white_comb_teeth= 
texture {
  gradient x 
  texture_map {
    [0   t_white_comb_clear]
    [0.6 t_white_comb_clear]
    [0.6 t_white_comb]
    [1.0 t_white_comb]
  } 
  scale 0.4
};

#declare t_hair_pick = texture {pigment {rgb 0} finish {phong 1 phong_size 100}};
#declare t_vaseline  = texture {pigment {rgb <211,241,129>/255} finish {phong 1 phong_size 60} };
#declare t_gel_bottle1 = texture {pigment {rgb <0.098,0.6,0.31>}}; 
#declare t_gel_bottle2_gel   = texture {pigment {rgbf <0.831,0.761,0.267,0.5>}};
#declare t_get_bottle2_clear = texture {pigment {rgbf <0.659,0.576,0.62,0.9>}};
#declare t_gel_bottle2 = 
texture {
  gradient y
  texture_map {
    [0.0  t_gel_bottle2_gel]
    [0.9  t_gel_bottle2_gel]
    [0.9  t_get_bottle2_clear]
    [1.0  t_get_bottle2_clear]
  }
  scale 5
};
#declare c_gel_bottle3_blue = <6,45,158>/255;
#declare t_gel_bottle3 = texture {pigment {rgb c_gel_bottle3_blue} finish {phong 1 phong_size 50 ambient 0} }; 
#declare t_gel_bottle3_cap = 
texture {
  pigment {
    radial color_map{
    [0.5 rgb 0][0.5 rgb c_gel_bottle3_blue]}
    frequency 50
  }
};

#declare n_gel_bottle3_cap = 
normal {
    radial 
  //  normal_map{
  //  [0.5 0][0.5 1]}
    frequency 50
};


#declare t_cream_bottle3 = texture {pigment {image_map {png "label_curel_bottle.png" map_type 2  }} scale 5 translate <0,0.5,0>};
#declare t_cream_bottle4 = texture {pigment {rgb <1.0,0.863,0.863>}};
#declare t_curling_iron_white = texture {pigment {rgb 0.9}  finish {phong 1 phong_size 150} };
#declare t_curling_iron_metal = texture {T_Chrome_3D}; 
#declare t_curling_iron_metalb = texture {T_Chrome_3C}; 
#declare t_curling_iron_metal_dull = texture {T_Chrome_3A};

#declare t_lipstick2_black = texture {pigment {rgb 0} finish {phong 0.9 phong_size 120}};
#declare t_lipstick2_silver = texture {pigment {rgb <0.894,0.894,0.894>} finish {phong 0.9 phong_size 120}};
#declare t_lipstick2_clear = texture {pigment {rgbt 0.8} finish {phong 0.9 phong_size 120}};
#declare t_lipstick1 = 
texture {
  pigment {
    gradient y
    pigment_map {
      [0.0  rgb 0]
      [0.65 rgb 0]
      [0.65 rgb <0.933,0.808,0.427>]
      [0.69 rgb <0.933,0.808,0.427>]
      [0.69 rgb 0]
      [1.00 rgb 0]
    }
  }
  finish {phong 1 phong_size 150}
  scale 3
}; 

#declare t_lipstick3 = 
texture {
  pigment {
    gradient y
    pigment_map {
      [0.0  rgb 0]
      [0.75/3.1 rgb 0]
      [0.75/3.1 P_Chrome2]
      [1.0/3.1 P_Chrome2]
      [1.0/3.1 rgb 0]
      [1.0 rgb 0]
    }
  }
  finish {phong 1 phong_size 150}
  scale 3.1
};

#declare t_lipstick4 = 
texture {
  gradient y
  texture_map {
    [0.0  T_Gold_1E]
    [0.45 T_Gold_1E]
    [0.45 T_Gold_1A]
    [0.5  T_Gold_1A]
    [0.5  T_Gold_1E]
    [1.0  T_Gold_1E]
  }
  scale 2.5
};
#declare t_compact = texture {pigment {rgb <0.902,0.835,0.698>}};

// -----------------------------------------------------------------------------
// Objects 
// -----------------------------------------------------------------------------


// Black Comb //////////////////////////////////////////////////////////////////
#declare black_comb =
union {
  box {<0,0,0>,<8,0.1,0.2> pigment {rgb 0} }
  box {<0,0,0.2>,<8,0.1,0.75> texture {t_black_comb_teeth} }
};


#declare white_comb_body =
prism {
  linear_sweep
  //linear_spline 
  cubic_spline
  0,0.2 
  19
  <0.2,1> // control pt
  <2,0>,
  <9,0.6>,<15,0.4>,<20,1>,
  <22,2>,<21,6>,<21,3>,<15,1.8>,
  <11,2.5>,<11,5>,<10,3>,<7,2.7>,
  <3,3.1>,<1,3.7>,<0,2>,<0.2,1>,
  <2,0>
  <9,0.6> // control pt
  texture {t_white_comb}
};


#declare white_comb_teeth = 
prism {
  linear_sweep
  //cubic_spline
  linear_spline
  0.05, 0.15
  6
//  <11,5>, 
  <21,6>,
  <21,2>,<15,1.5>,
  <11,1>,<11,5>,
  <21,6> // endpt
//  <21,3>
  texture {t_white_comb_teeth}
};  


// white Comb //////////////////////////////////////////////////////////////////
#declare white_comb = 
union {
 union{white_comb_body} 
 union{white_comb_teeth}
 scale cm_to_inches
}

// Hair Pick //////////////////////////////////////////////////////////////////
#declare hair_pick = 
union { 
  prism {
    linear_sweep
   // quadratic_spline
   //linear_spline  
   cubic_spline
     
    0.0, 0.4
    27
    <-1.7,1> // control point
    <0,0>, // start point  
    <1.7,1>,<1.9,2>,<1.5,3>,<1.4,4>,<1.4,5>,<2.2,7>,<4,9>,<4,10>,<4,10.5>,<3.9,10.5>,<3.8,10.5>,
    <0,10.5>, 
    <-3.8,10.5>,<-3.9,10.5>,<-4,10.5>,<-4,10>,<-4,9>,<-2.2,7>,<-1.4,5>,<-1.4,4>,<-1.5,3>,<-1.9,2>,<-1.7,1>
    <0,0>, // end point
    <1.9,2> // control point
    
  } 
  #local i=0;
  #while (i<11)
    cone {<0,0.2,10.5>,0.2,<0,0.2,17>,0.1  translate <-3.8+i*0.75,0,0>} 
    #local i=i+1;
  #end


 texture {t_hair_pick}
 scale 0.75 // convert to cm
 scale cm_to_inches
};

// Hair Dryer //////////////////////////////////////////////////////////////////
#declare hair_dryer =
union {

  sphere_sweep {  // main body
    cubic_spline
    6,                            // number of specified sphere positions 
    <0, 0,   0>, 1.6
    <0, 0,   0>, 1.6                // position, radius
    <0, 0,   1>, 1.4                 // ...
    <0, 0,   4>, 1.1
    <0, 0, 5.5>, 1
    <0, 0,   6>, 1
    clipped_by {plane {z, 5.5}}
  }
  
  // front grill
  cylinder {<0,0,5.5>,<0,0,6.05> 1 open} // front grill cover
  cylinder {<0,0,5.5>,<0,0,6.01> 0.99 texture {t_hair_dryer_grill} } 
  
  sphere {0, 1.59 scale <0.9,0.9,1> translate <0,0,-0.11> texture {t_hair_dryer_grill} }
  difference {
    sphere_sweep {  // handle
      cubic_spline
      6,
      <0,0.5,0>, 1.5
      <0,0,0>, 1.5
      <0,-2,0>,0.45 
      <0,-4.5,0>, 0.6
      <0,-5,0>, 0.3
      <0,-6,0>, 0.1
      }
      // screw holes
      cylinder {<0,-2,0.2>, <0,-2,-1> 0.1}
      cylinder {<0,-4.5,0.2>, <0,-4.5,-1> 0.1}
    } 
    
  // on/off switch
  cylinder {<0,0,0>,<-0.5,0,0>, 0.2 scale <1,2,1> translate <0,-2.8,0> pigment {rgb <0.4,0.42,0.42>}}
  texture{t_hair_dryer_white}
};
   
// Hand Mirror (needs work)   
#declare hand_mirror = 
union {
  cylinder {<0,0,0.2>,<0,4,0.2> 0.5 texture {pigment {rgb 0}} } 
  box {<-3,4,0>,<3,10,0.2> texture {pigment {rgb 0} } }
  box {<-2.8,4.2,0>,<2.8,9.8,-0.001> texture {t_mirror} } 
}; 



// Bottles, Jars, and Tubes /////////////////////////////////////////////////// 

// Nivea Jar //////////////////////////////////////////////////////////////////
#declare nivea_jar_finish = finish {phong 1 phong_size 100 reflection {0.1}};
#declare nivea_jar =
union {
  Round_Cylinder_Merge (<0,0,0>,<0,1.77,0>, 1.57, 0.2) // body
  cylinder {<0,0.2,0>,<0,1.5,0> 1.575 texture {pigment {image_map {png "nivea_side.png" map_type 2} scale 1.5} finish {nivea_jar_finish} } no_shadow}  
  box {<0,0,0>,<1,1,0.00001> texture {pigment {image_map {png "nivea_top.png" }}  } scale 2 rotate <90,0,0> translate <-1,1.771,-1>  no_shadow} 
  texture {pigment {rgb <16,50,146>/255} finish {nivea_jar_finish} }
};  

// Vaseline Jar ///////////////////////////////////////////////////////////////
#declare vaseline_shape = 
  prism {                                
    linear_sweep  // or conic_sweep for tapering to a point
    quadratic_spline  // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
    0,         // height 1
    1,         // height 2 
    9 // number of points
  
    <0,2>  // control point    
    <6,0>, // first point
    <12.5,2>,<12.5,7>,<6,9.4>,<0,7>,<0,2>,
    <6,0>  // last point
    <12.5,2> // control point   
    translate <-6,0,-4.7>
};


#declare vaseline_jar =
union {
  union {
    object {vaseline_shape   scale <0.9,1,0.9>}
    object {vaseline_shape   scale <1,10,1> translate <0,1,0> /*texture {pigment {image_map {png "nivea_side.png" map_type 2} scale 10} finish {nivea_jar_finish} }*/ }
    object {vaseline_shape   scale <0.95,1,0.95> translate <0,11,0>}
    texture {t_vaseline}    
  }
  difference {
    object {vaseline_shape   scale <1,2.5,1> translate <0,12,0>  }
    object {vaseline_shape                 translate <0,14.3,0>}
    texture {pigment {rgb 1} finish {reflection 0.05}}
  } 
 scale 0.75 // convert to cm
 scale cm_to_inches
};

// Gel Bottle 1 ///////////////////////////////////////////////////////////////
#declare gel_bottle1 = 
union {          

  intersection { 
    sphere_sweep {
      cubic_spline                
      5,                           
      <0, -1, 0>, 1
      <0, 0, 0>, 1               
      <0, 5, 0>, 1               
      <0, 7, 0>, 0.5
      <0, 8, 0>, 0.5
      
    } 
  
  box {<-2,0,-2>,<2,7,2>}
  }
  
 // cylinder {<0,2,0>,<0,4,0> 1.05  texture {pigment {image_map {png "label_hair_jello.png" map_type 2}} scale 2} }
  cylinder {<0,0.5,0>,<0,5,0> 1.05  texture {pigment {image_map {png "label_hair_jello.png" map_type 2}} scale 4.5} }
  cylinder {<0,7,0>,<0,8,0>,0.5}
  texture {t_gel_bottle1}
};   

// Gel Bottle 2 ///////////////////////////////////////////////////////////////
#declare gel_bottle2 = 
union {
  sphere_sweep {
    cubic_spline                
    5,                           
    <0, -1, 0>, 1
    <0, 0, 0>, 2               
    <0, 4.5, 0>, 3               
    <0, 5, 0>, 2.5
    <0, 5.5, 0>, 2
    scale <0.3,1,0.5>
  } 
  texture {t_gel_bottle2}
};

// Gel Bottle 3 ///////////////////////////////////////////////////////////////
#declare gel_bottle3 = 
union {
  cylinder {<0,0.2,0>,<0,6,0>,0.999}
  cylinder {<0,0.2,0>,<0,6,0> 1 open texture {pigment{image_map{png "gel_bottle3.png" map_type 2 once}} scale <1,6,1> finish {ambient 0} } no_shadow }
  torus {0.8 0.2 translate <0,0.2,0>}
  sphere {0, 1 scale <1,0.4,1> translate <0,6,0>}
  
  cylinder {<0,6,0>,<0,6.5,0> 0.4} // inner tube
  
  //cap 
  union {
    cone {<0,6.45,0>,0.5,<0,7.1,0>,0.45}
    torus {0.5,0.02 translate <0,6.45,0>} 
    torus {0.45,0.02 translate <0,7.1,0>}  
    texture {t_gel_bottle3}
    normal {n_gel_bottle3_cap} 
  }
  
  Round_Cylinder_Merge(<0,7.1,0>,<0,8.25,0>,0.35,0.1)
  texture {t_gel_bottle3}
}; 
 
// Gel Bottle 4 ///////////////////////////////////////////////////////////////
#declare gel_bottle4 = 
union {
  cylinder {<0,0,0>,<0,4,0> 1   scale <1,1,0.4>   texture {pigment {rgb <0.878,0.663,0.914>}} } 
  cylinder {<0,1,0>,<0,4,0> 1.1 scale <1,1,0.4>   texture {pigment{image_map{png "label_skin_saviour.png" map_type 2}}scale 3} }
  sphere {0 1 scale <1,1,0.4> clipped_by {plane {y,0.8} }  translate <0,4,0>  }
  texture {pigment {rgb <0.937,0.639,0.694>}}
};

// Cream Bottle 1 /////////////////////////////////////////////////////////////
#declare cream_bottle1 = 
union { 
  union { // body
    cylinder {<0,0.4,0>,<0,4,0> 1}
    sphere   {0, 1  clipped_by {plane {-y,0.4}} translate <0,0.4,0> }
    sphere   {<0,4,0>   1}     
  }
  
  // labels around body 
                                    
  cylinder {<0,3,0>,<0,4,0>   1.00001 texture{pigment{image_map{png "label_cream_bottle1_top.png" map_type 2} }} rotate <0,180,0> no_shadow }
  cylinder {<0,0.5,0>,<0,1,0> 1.00001 texture{pigment{image_map{png "label_cream_bottle1_bot.png" map_type 2} scale 0.5 }} rotate <0,180,0> no_shadow }
  
  cylinder {<0,4.9,0>,<0,5.6,0> 0.35 texture {pigment {rgb 1}} normal {n_gel_bottle3_cap}} // cap
  cylinder {<0,5.6,0>,<0,6,0> 0.1 } // inner part of dispenser
  cylinder {<0,5.65,0>,<0,5.8,0>,0.25} 
  
  // top part
  cylinder {<0,5.85,0>,<0,6.2,0>,0.25} 
  cone {<0,6.2,0> 0.2 <1,6.2,0> 0.1 clipped_by {plane {y,6.2}} }
  box  {<0,6.2,-0.1> <-0.4,6.1,0.1>}
  texture {pigment {rgb <0.639,0.718,0.486>} finish {phong 0.5 phong_size 80 }}
};

// Cream Bottle 2 /////////////////////////////////////////////////////////////
#declare cream_bottle2 = 
union {
  union {
 // Round_Box_Merge(<0,0,0>,<2,2,2>,0.2)
  Round_Box_Merge(<0,0.5,0>,<2,5,1>,0.7)
  pigment {rgb 0.7}
  }
};


// Cream Bottle 3 (based on a Curel bottle ////////////////////////////////////
#declare cream_bottle3 = 
union {
  superellipsoid {<0.5 0.5> scale <1.2,3,0.5> translate <0,3,0>}
  union { // cap
    cylinder {<0,6,0>,<0,6.7,0> 0.4}
    cylinder {<0,6.7,0>,<0,7,0> 0.1}
    cylinder {<0,6.85,0>,<0,7.2,0>,0.25} 
    cone {<0,7.2,0> 0.2 <1,7.2,0> 0.1 clipped_by {plane {y,7.2}} }
    box  {<0,7.2,-0.1> <-0.4,7.1,0.1>}
    texture {pigment {rgb <0,0,0.4>}}
  }
  texture {t_cream_bottle3}
}; 

// Cream Bottle 4 (based on Johnson's baby lotion bottle) ///////////////////// 
#declare cream_bottle4 =  
union {
  superellipsoid {<0.5 0.5> scale <2,4,0.9>  translate <0,3.75,0> clipped_by {plane {-y,0}} }  
  cylinder {<0,7,0>,<0,8,0> 0.4}
  cylinder {<0,7.85,0>,<0,9,0> 0.6} 
  #ifdef (cream_bottle4_open)
    cylinder {<0,0,0>,<0,0,0.1> 0.6 rotate <20,0,0> translate <0,9.6,0.6> rotate <0,45,0>} 
  #end
  
  texture {t_cream_bottle4}
}; 

// lipstick1 //////////////////////////////////////////////////////////////////
#declare lipstick1 = cylinder {<0,0,0>,<0,3,0>,0.25 texture {t_lipstick1} }; 

// lipstick2 //////////////////////////////////////////////////////////////////
#declare lipstick2 = 
union {
  cylinder {<0,0,0>,<0,1.25,0>,0.48  texture {t_lipstick2_black} }
  cylinder {<0,1.25,0>,<0,1.5,0>,0.48  texture {t_lipstick2_silver} }
  cylinder {<0,1.5,0>,<0,2.75,0>,0.48 open texture {t_lipstick2_black} } 
  cylinder {<0,1.5,0>,<0,2.75,0>,0.47 open pigment {rgb <0.984,0.894,0.796>} }
  cylinder {<0,1.5,0>,<0,2.8,0>,0.47      pigment {rgb <0.984,0.894,0.796>} }      
  cylinder {<0,2.75,0>,<0,3.5,0>,0.48 texture {t_lipstick2_clear} }  
};

// lipstick3 //////////////////////////////////////////////////////////////////
#declare lipstick3 = 
union {
  Round_Box_Merge(<0,0,0>,<0.75,3.1,0.75>,0.2)
  texture {t_lipstick3}
}

// lipstick4 //////////////////////////////////////////////////////////////////
#declare lipstick4 = 
union {
  Round_Cylinder_Merge (<0,0,0>,<0,2.5,0>,0.3, 0.15)
  texture {t_lipstick4}
}

// compact ////////////////////////////////////////////////////////////////////
#declare compact_half = 
  union {
    Round_Box_Merge(<0,0,0>,<2.5,1,2>, 0.2)
    clipped_by {plane {y, 0.5}}
    scale <1,0.2,1> 
    texture {t_compact}
  };

#declare compact_top_half = 
union {
  object {compact_half}
  union {
    box {<0.25,0.1,0.4>,<2.25,0.2,1.6> }
    scale <1,0.1,1>
  }
  texture {pigment { rgb 1} finish {reflection 1} }

};


#declare compact_bottom_half = 
union {
  object {compact_half}
  union {
    Round_Box_Merge (<0.2,0.1,0.4>,<2.3,0.2,1.6> 0.1)
    scale <1,0.1,1>
  }
  texture {pigment { rgb<0.945,0.569,0.698>}}

};
  
#declare compact = 
  union {
    object {compact_bottom_half translate <0,0,0.1>}
    object {compact_top_half translate <0,0,-2> rotate <45,0,0>}
    cylinder {<0,0,0>,<0.5,0,0> 0.15 texture {t_compact} clipped_by {plane {-y,0}} }
    cylinder {<1.5,0,0>,<2,0,0> 0.15 texture {t_compact} clipped_by {plane {-y,0}} }
};


// Curling Iron ///////////////////////////////////////////////////////////////


#declare curling_iron_switch_body =
  union { // body
    box {<0,-0.5,-0.2>,<1.25,0.01,0.2> }
    cylinder {<0,-0.5,0>,<0,0.01,0> 0.2  }
    cylinder {<1.25,-0.5,0>,<1.25,0.01,0> 0.2 }
    texture {t_curling_iron_metal_dull} 
  };
 

#declare curling_iron_switch = 
union {
  difference {
    union {curling_iron_switch_body}
    box {<0.875,-0.3,-0.09>,<1.325,0.05,0.09> } // hole for switch     
    }
  sphere {0,0.125 translate <0.25,0,0> scale <1,0.3,1> texture {pigment {rgb <0.2,0,0>} finish {phong 1 phong_size 160}} }
  box {<1,-0.2,-0.08>,<1.15,0.15,0.08> texture {pigment {rgb 0} } } // button  
};

#declare curling_iron_clasp = 
union { 

  //cylinder {<6.5,0,0>,<5,1.5,0> 0.38 }
  difference {
    cylinder {<0,0,0>  ,<-2.5,0,0> 0.38 scale <1,1,1.1> }
    cylinder {<1,0,0>  ,<-2.6,0,0> 0.35 scale <1,1,1.1>}   
    plane {y,0 }  
    superellipsoid {<0.5,0.5>  scale <1.5,0.2,1> translate <-2,0,0>} 
    superellipsoid {<0.5,0.5>  scale <1.5,0.4,1> translate <-1.7,0,0> inverse}
  } 
  // rounded edges
  difference {
    cylinder {<-0.36,0,0.38>,<-0.36,0,0.41> 0.155}  
    plane {-y,0}   
  }
  
  difference {
    cylinder {<-0.36,0,-0.38>,<-0.36,0,-0.41> 0.155}  
    plane {-y,0}   
  }
  
  // bolts for support
  cylinder {<-0.36,0,0.38>,<-0.36,0,0.45> 0.05}
  cylinder {<-0.36,0,-0.38>,<-0.36,0,-0.45> 0.05}
  
  
  superellipsoid {<0.4,0.4> scale <0.4,0.2,0.4>  rotate <0,0,15> translate <-2.5,0.2,0>  texture {t_curling_iron_white} }
  rotate <0,0,-45>
  translate <6.5,-0.2,0>
//  translate <6.5,3,0>
  texture {t_curling_iron_metalb}
};


#declare curling_iron_support = 
union {
  cylinder {<0,1,-0.45>,<0,1,-0.50> 0.03}
  cylinder {<0,1,-0.50>,<0,0,-0.50> 0.03}
  torus    {0.5,0.03 clipped_by {plane {-x,0} }  } 
  
  cylinder {<0,1,0.45>,<0,1,0.50> 0.03}
  cylinder {<0,1,0.50>,<0,0,0.50> 0.03} 
  
  sphere {<0,1,-0.50> 0.03}
  sphere {<0,0,-0.50> 0.03} 
  sphere {<0,1, 0.50> 0.03}
  sphere {<0,0, 0.50> 0.03}  
  texture {t_curling_iron_metalb} 
};

#declare curling_iron_electrical_cord_half =  
  sphere_sweep {
    b_spline
    5,
    < 1, 0, 0>, 0.1                            // number of specified sphere positions
    < -0.2, 0, 0>, 0.1                // position, radius
    <-2, -0.2, 1>, 0.1                 // ...
    <-8, 0.2, -3>, 0.1
    <-10, 0.2, -3>, 0.1

};

#declare curling_iron_electrical_cord = 
union { 
  cone {<0,0,0>, 0.3 <-0.2,0,0> 0.2 scale <1,1.5,1>}
  union {curling_iron_electrical_cord_half translate <0,0,-0.09>}
  union {curling_iron_electrical_cord_half translate <0,0, 0.09>}
  scale <1,0.5,1>
  texture {pigment {rgb 1}}  
};




#declare curling_iron = 
union { 
  union {
    union {  // handle
      difference {
        cone {<0,0,0>,0.5,<5,0,0>,0.625}
        union {curling_iron_switch_body translate <1.75,0.6,0>} 
        box {<-0.1,-0.05,-1>,<5,0,1> }// groove
      }
      cone {<5,0,0>,0.625,<5.1,0,0>,0.5}
      cylinder {<5.1,0,0>,<5.25,0,0>,0.5}
      texture {t_curling_iron_white}
    }
    
    union {curling_iron_electrical_cord}
    
    // metallic part
    cylinder {<5.25,0,0>,<10.25,0,0> 0.375 texture {t_curling_iron_metal} }
    
    
    // tip
    cone {<10.25,0,0>,0.375,<11.125,0,0>,0.32 texture {t_curling_iron_white}} 
    union {curling_iron_switch translate <1.75,0.5,0>}
     
    union {curling_iron_clasp} 
    
    translate <-6.25,0,0>
    rotate <0,0,5>
    translate <6.25,0,0>
   }
  union {curling_iron_support translate <6.25,-1,0>}
  translate <0,1,0>
  
};

